Grammar index
=============

This is a list of grammars that Linguist selects to provide syntax highlighting on GitHub. If you've encountered an error with highlighting, please find the grammar in the list below and report it to the appropriate repository.

**Note:** grammars marked with 🐌 are not updated when Linguist is so upstream fixes may take longer to appear on GitHub.

<!-- Everything below this line is auto-generated by script/list-grammars. Manual edits will be lost -->
- **1C Enterprise:** [xDrivenDevelopment/atom-language-1c-bsl](https://github.com/xDrivenDevelopment/atom-language-1c-bsl)
- **2-Dimensional Array:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **4D:** [ayoubserti/lang-4d](https://github.com/ayoubserti/lang-4d)
- **ABAP:** [pvl/abap.tmbundle](https://github.com/pvl/abap.tmbundle)
- **ABAP CDS:** [FreHu/abap-cds-grammar](https://github.com/FreHu/abap-cds-grammar)
- **ABNF:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **AGS Script:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **AIDL:** [google/aidl-language](https://github.com/google/aidl-language)
- **AL:** [microsoft/AL](https://github.com/microsoft/AL)
- **AMPL:** [ampl/sublime-ampl](https://github.com/ampl/sublime-ampl)
- **ANTLR:** [textmate/antlr.tmbundle](https://github.com/textmate/antlr.tmbundle)
- **API Blueprint:** [apiaryio/api-blueprint-sublime-plugin](https://github.com/apiaryio/api-blueprint-sublime-plugin)
- **APL:** [Alhadis/language-apl](https://github.com/Alhadis/language-apl)
- **ASL:** [sebadur/language-asl](https://github.com/sebadur/language-asl)
- **ASN.1:** [ajlangley/language-asn1](https://github.com/ajlangley/language-asn1)
- **ASP.NET:** [textmate/asp.tmbundle](https://github.com/textmate/asp.tmbundle)
- **ATS:** [steinwaywhw/ats-mode-sublimetext](https://github.com/steinwaywhw/ats-mode-sublimetext)
- **ActionScript:** [simongregory/actionscript3-tmbundle](https://github.com/simongregory/actionscript3-tmbundle)
- **Ada:** [textmate/ada.tmbundle](https://github.com/textmate/ada.tmbundle)
- **Adblock Filter List:** [AdguardTeam/VscodeAdblockSyntax](https://github.com/AdguardTeam/VscodeAdblockSyntax)
- **Adobe Font Metrics:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Agda:** [agda/agda-github-syntax-highlighting](https://github.com/agda/agda-github-syntax-highlighting)
- **Alloy:** [macekond/Alloy.tmbundle](https://github.com/macekond/Alloy.tmbundle)
- **Alpine Abuild:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **Altium Designer:** [textmate/ini.tmbundle](https://github.com/textmate/ini.tmbundle)
- **AngelScript:** [wronex/sublime-angelscript](https://github.com/wronex/sublime-angelscript)
- **Ant Build System:** [textmate/ant.tmbundle](https://github.com/textmate/ant.tmbundle)
- **Antlers:** [Stillat/vscode-antlers-language-server](https://github.com/Stillat/vscode-antlers-language-server)
- **ApacheConf:** [textmate/apache.tmbundle](https://github.com/textmate/apache.tmbundle)
- **Apex:** [forcedotcom/apex-tmLanguage](https://github.com/forcedotcom/apex-tmLanguage)
- **Apollo Guidance Computer:** [Alhadis/language-agc](https://github.com/Alhadis/language-agc)
- **AppleScript:** [textmate/applescript.tmbundle](https://github.com/textmate/applescript.tmbundle)
- **AsciiDoc:** [zuckschwerdt/asciidoc.tmbundle](https://github.com/zuckschwerdt/asciidoc.tmbundle)
- **AspectJ:** [pchaigno/sublime-aspectj](https://github.com/pchaigno/sublime-aspectj)
- **Assembly:** [Nessphoro/sublimeassembly](https://github.com/Nessphoro/sublimeassembly)
- **Astro:** [withastro/language-tools](https://github.com/withastro/language-tools)
- **Asymptote:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **AutoHotkey:** [ahkscript/SublimeAutoHotkey](https://github.com/ahkscript/SublimeAutoHotkey)
- **AutoIt:** [AutoIt/SublimeAutoItScript](https://github.com/AutoIt/SublimeAutoItScript)
- **Avro IDL:** [Jason3S/avro.tmLanguage](https://github.com/Jason3S/avro.tmLanguage)
- **Awk:** [github-linguist/awk-sublime](https://github.com/github-linguist/awk-sublime)
- **BASIC:** [telnet23/language-basic](https://github.com/telnet23/language-basic)
- **Ballerina:** [ballerina-platform/ballerina-grammar](https://github.com/ballerina-platform/ballerina-grammar)
- **Batchfile:** [mmims/language-batchfile](https://github.com/mmims/language-batchfile)
- **Beef:** [dotnet/csharp-tmLanguage](https://github.com/dotnet/csharp-tmLanguage)
- **Befunge:** [johanasplund/sublime-befunge](https://github.com/johanasplund/sublime-befunge)
- **Berry:** [berry-lang/berry-grammar](https://github.com/berry-lang/berry-grammar)
- **BibTeX:** [textmate/latex.tmbundle](https://github.com/textmate/latex.tmbundle)
- **Bicep:** [azure/bicep](https://github.com/azure/bicep)
- **Bikeshed:** [tabatkins/bikeshed](https://github.com/tabatkins/bikeshed)
- **Bison:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **Blade:** [jawee/language-blade](https://github.com/jawee/language-blade)
- **BlitzBasic:** [textmate/blitzmax.tmbundle](https://github.com/textmate/blitzmax.tmbundle)
- **BlitzMax:** [textmate/blitzmax.tmbundle](https://github.com/textmate/blitzmax.tmbundle)
- **Bluespec:** [thotypous/sublime-bsv](https://github.com/thotypous/sublime-bsv)
- **Boo:** [drslump/sublime-boo](https://github.com/drslump/sublime-boo)
- **Boogie:** [boogie-org/boogie-vscode](https://github.com/boogie-org/boogie-vscode)
- **Brainfuck:** [Drako/SublimeBrainfuck](https://github.com/Drako/SublimeBrainfuck)
- **BrighterScript:** [rokucommunity/vscode-brightscript-language](https://github.com/rokucommunity/vscode-brightscript-language)
- **Brightscript:** [rokucommunity/vscode-brightscript-language](https://github.com/rokucommunity/vscode-brightscript-language)
- **Browserslist:** [browserslist/browserslist-vscode](https://github.com/browserslist/browserslist-vscode)
- **C:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **C#:** [dotnet/csharp-tmLanguage](https://github.com/dotnet/csharp-tmLanguage)
- **C++:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **C-ObjDump:** [nanoant/assembly.tmbundle](https://github.com/nanoant/assembly.tmbundle)
- **C2hs Haskell:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **CAP CDS:** [SAP/cds-textmate-grammar](https://github.com/SAP/cds-textmate-grammar)
- **CIL:** [google/selinux-policy-languages](https://github.com/google/selinux-policy-languages)
- **CLIPS:** [psicomante/CLIPS-sublime](https://github.com/psicomante/CLIPS-sublime)
- **CMake:** [textmate/cmake.tmbundle](https://github.com/textmate/cmake.tmbundle)
- **COBOL:** [spgennard/vscode_cobol](https://github.com/spgennard/vscode_cobol)
- **CODEOWNERS:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **COLLADA:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **CSON:** [atom/language-coffee-script](https://github.com/atom/language-coffee-script)
- **CSS:** [tree-sitter/tree-sitter-css](https://github.com/tree-sitter/tree-sitter-css) 🐌
- **CUE:** [cue-sh/vscode-cue](https://github.com/cue-sh/vscode-cue)
- **Cabal Config:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **Cadence:** [onflow/vscode-cadence](https://github.com/onflow/vscode-cadence)
- **Cairo:** [xshitaka/atom-language-cairo](https://github.com/xshitaka/atom-language-cairo)
- **CameLIGO:** [pewulfman/Ligo-grammar](https://github.com/pewulfman/Ligo-grammar)
- **Cap'n Proto:** [textmate/capnproto.tmbundle](https://github.com/textmate/capnproto.tmbundle)
- **CartoCSS:** [yohanboniface/carto-atom](https://github.com/yohanboniface/carto-atom)
- **Ceylon:** [jeancharles-roger/ceylon-sublimetext](https://github.com/jeancharles-roger/ceylon-sublimetext)
- **Chapel:** [chapel-lang/chapel-tmbundle](https://github.com/chapel-lang/chapel-tmbundle)
- **Checksums:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **ChucK:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **Circom:** [iden3/circom-highlighting-vscode](https://github.com/iden3/circom-highlighting-vscode)
- **Cirru:** [Cirru/sublime-cirru](https://github.com/Cirru/sublime-cirru)
- **Clarion:** [fushnisoft/SublimeClarion](https://github.com/fushnisoft/SublimeClarion)
- **Clarity:** [hirosystems/clarity.tmbundle](https://github.com/hirosystems/clarity.tmbundle)
- **Classic ASP:** [textmate/asp.tmbundle](https://github.com/textmate/asp.tmbundle)
- **Clean:** [timjs/atom-language-clean](https://github.com/timjs/atom-language-clean)
- **Click:** [stenverbois/language-click](https://github.com/stenverbois/language-click)
- **Clojure:** [atom/language-clojure](https://github.com/atom/language-clojure)
- **Closure Templates:** [mthadley/language-closure-templates](https://github.com/mthadley/language-closure-templates)
- **Cloud Firestore Security Rules:** [jaysquared/atom-firestore-grammar](https://github.com/jaysquared/atom-firestore-grammar)
- **CoNLL-U:** [odanoburu/conllu-linguist-grammar](https://github.com/odanoburu/conllu-linguist-grammar)
- **CodeQL:** [tree-sitter/tree-sitter-ql](https://github.com/tree-sitter/tree-sitter-ql) 🐌
- **CoffeeScript:** [atom/language-coffee-script](https://github.com/atom/language-coffee-script)
- **ColdFusion:** [SublimeText/ColdFusion](https://github.com/SublimeText/ColdFusion)
- **ColdFusion CFC:** [SublimeText/ColdFusion](https://github.com/SublimeText/ColdFusion)
- **Common Lisp:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **Common Workflow Language:** [manabuishii/language-cwl](https://github.com/manabuishii/language-cwl)
- **Component Pascal:** [textmate/pascal.tmbundle](https://github.com/textmate/pascal.tmbundle)
- **Cool:** [anunayk/cool-tmbundle](https://github.com/anunayk/cool-tmbundle)
- **Coq:** [mkolosick/Sublime-Coq](https://github.com/mkolosick/Sublime-Coq)
- **Cpp-ObjDump:** [nanoant/assembly.tmbundle](https://github.com/nanoant/assembly.tmbundle)
- **Creole:** [Siddley/Creole](https://github.com/Siddley/Creole)
- **Crystal:** [atom-crystal/language-crystal](https://github.com/atom-crystal/language-crystal)
- **Csound:** [nwhetsell/language-csound](https://github.com/nwhetsell/language-csound)
- **Csound Document:** [nwhetsell/language-csound](https://github.com/nwhetsell/language-csound)
- **Csound Score:** [nwhetsell/language-csound](https://github.com/nwhetsell/language-csound)
- **Cuda:** [harrism/sublimetext-cuda-cpp](https://github.com/harrism/sublimetext-cuda-cpp)
- **Cue Sheet:** [relikd/CUE-Sheet_sublime](https://github.com/relikd/CUE-Sheet_sublime)
- **Curry:** [fwcd/vscode-curry](https://github.com/fwcd/vscode-curry)
- **Cycript:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **Cypher:** [fredbenenson/sublime-cypher](https://github.com/fredbenenson/sublime-cypher)
- **Cython:** [textmate/cython.tmbundle](https://github.com/textmate/cython.tmbundle)
- **D:** [textmate/d.tmbundle](https://github.com/textmate/d.tmbundle)
- **D-ObjDump:** [nanoant/assembly.tmbundle](https://github.com/nanoant/assembly.tmbundle)
- **D2:** [terrastruct/d2-vscode](https://github.com/terrastruct/d2-vscode)
- **DM:** [PJB3005/atomic-dreams](https://github.com/PJB3005/atomic-dreams)
- **DNS Zone:** [sixty4k/st2-zonefile](https://github.com/sixty4k/st2-zonefile)
- **DTrace:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Dafny:** [DafnyVSCode/Dafny-VSCode](https://github.com/DafnyVSCode/Dafny-VSCode)
- **Dart:** [dart-lang/dart-syntax-highlight](https://github.com/dart-lang/dart-syntax-highlight)
- **DataWeave:** [mulesoft-labs/data-weave-tmLanguage](https://github.com/mulesoft-labs/data-weave-tmLanguage)
- **Debian Package Control File:** [tsbarnes/language-debian](https://github.com/tsbarnes/language-debian)
- **DenizenScript:** [DenizenScript/denizenscript-grammar](https://github.com/DenizenScript/denizenscript-grammar)
- **Dhall:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **Diff:** [textmate/diff.tmbundle](https://github.com/textmate/diff.tmbundle)
- **Dockerfile:** [asbjornenge/Docker.tmbundle](https://github.com/asbjornenge/Docker.tmbundle)
- **Dotenv:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Dylan:** [textmate/dylan.tmbundle](https://github.com/textmate/dylan.tmbundle)
- **E-mail:** [mariozaizar/language-eml](https://github.com/mariozaizar/language-eml)
- **EBNF:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **ECL:** [hpcc-systems/ecl-tmLanguage](https://github.com/hpcc-systems/ecl-tmLanguage)
- **ECLiPSe:** [alnkpa/sublimeprolog](https://github.com/alnkpa/sublimeprolog)
- **EJS:** [tree-sitter/tree-sitter-embedded-template](https://github.com/tree-sitter/tree-sitter-embedded-template) 🐌
- **EQ:** [dotnet/csharp-tmLanguage](https://github.com/dotnet/csharp-tmLanguage)
- **Eagle:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **Earthly:** [earthly/earthfile-grammar](https://github.com/earthly/earthfile-grammar)
- **Easybuild:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Ecere Projects:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **Ecmarkup:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **EditorConfig:** [sindresorhus/atom-editorconfig](https://github.com/sindresorhus/atom-editorconfig)
- **Edje Data Collection:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Eiffel:** [textmate/eiffel.tmbundle](https://github.com/textmate/eiffel.tmbundle)
- **Elixir:** [elixir-lang/tree-sitter-elixir](https://github.com/elixir-lang/tree-sitter-elixir) 🐌
- **Elvish:** [elves/elvish](https://github.com/elves/elvish)
- **Elvish Transcript:** [elves/elvish](https://github.com/elves/elvish)
- **Emacs Lisp:** [Alhadis/language-emacs-lisp](https://github.com/Alhadis/language-emacs-lisp)
- **EmberScript:** [atom/language-coffee-script](https://github.com/atom/language-coffee-script)
- **Erlang:** [textmate/erlang.tmbundle](https://github.com/textmate/erlang.tmbundle)
- **Euphoria:** [OpenEuphoria/vscode-euphoria](https://github.com/OpenEuphoria/vscode-euphoria)
- **F#:** [ionide/ionide-fsgrammar](https://github.com/ionide/ionide-fsgrammar)
- **F\*:** [FStarLang/atom-fstar](https://github.com/FStarLang/atom-fstar)
- **FIGlet Font:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Factor:** [slavapestov/factor](https://github.com/slavapestov/factor)
- **Fancy:** [fancy-lang/fancy-tmbundle](https://github.com/fancy-lang/fancy-tmbundle)
- **Fantom:** [rkoeninger/sublime-fantom](https://github.com/rkoeninger/sublime-fantom)
- **Faust:** [jpcima/language-faust](https://github.com/jpcima/language-faust)
- **Fennel:** [kongeor/vsc-fennel](https://github.com/kongeor/vsc-fennel)
- **Fluent:** [macabeus/vscode-fluent](https://github.com/macabeus/vscode-fluent)
- **Forth:** [textmate/forth.tmbundle](https://github.com/textmate/forth.tmbundle)
- **Fortran:** [textmate/fortran.tmbundle](https://github.com/textmate/fortran.tmbundle)
- **Fortran Free Form:** [textmate/fortran.tmbundle](https://github.com/textmate/fortran.tmbundle)
- **FreeBasic:** [peters-ben-0007/VBDotNetSyntax](https://github.com/peters-ben-0007/VBDotNetSyntax)
- **FreeMarker:** [freemarker/FreeMarker.tmbundle](https://github.com/freemarker/FreeMarker.tmbundle)
- **Frege:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **Futhark:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **G-code:** [appliedengdesign/vscode-gcode-syntax](https://github.com/appliedengdesign/vscode-gcode-syntax)
- **GAP:** [dhowden/gap-tmbundle](https://github.com/dhowden/gap-tmbundle)
- **GCC Machine Description:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **GDB:** [quarnster/SublimeGDB](https://github.com/quarnster/SublimeGDB)
- **GDScript:** [godotengine/godot-vscode-plugin](https://github.com/godotengine/godot-vscode-plugin)
- **GEDCOM:** [fguitton/vscode-gedcom](https://github.com/fguitton/vscode-gedcom)
- **GLSL:** [euler0/sublime-glsl](https://github.com/euler0/sublime-glsl)
- **GN:** [devoncarew/language-gn](https://github.com/devoncarew/language-gn)
- **GSC:** [Jake-NotTheMuss/CoDT7-Sublime](https://github.com/Jake-NotTheMuss/CoDT7-Sublime)
- **Game Maker Language:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Gemfile.lock:** [hmarr/gemfile-lock-tmlanguage](https://github.com/hmarr/gemfile-lock-tmlanguage)
- **Gemini:** [printfn/gemini-vscode](https://github.com/printfn/gemini-vscode)
- **Genero:** [alienriver49/genero.tmbundle](https://github.com/alienriver49/genero.tmbundle)
- **Genero Forms:** [alienriver49/genero.tmbundle](https://github.com/alienriver49/genero.tmbundle)
- **Genshi:** [genshi.edgewall.org/query](https://genshi.edgewall.org/query)
- **Gentoo Ebuild:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **Gentoo Eclass:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **Gerber Image:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **Gettext Catalog:** [textmate/gettext.tmbundle](https://github.com/textmate/gettext.tmbundle)
- **Gherkin:** [cucumber/cucumber-tmbundle](https://github.com/cucumber/cucumber-tmbundle)
- **Git Attributes:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Git Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Git Revision List:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **Gleam:** [gleam-lang/tree-sitter-gleam](https://github.com/gleam-lang/tree-sitter-gleam) 🐌
- **Glyph:** [textmate/tcl.tmbundle](https://github.com/textmate/tcl.tmbundle)
- **Glyph Bitmap Distribution Format:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Gnuplot:** [mattfoster/gnuplot-tmbundle](https://github.com/mattfoster/gnuplot-tmbundle)
- **Go:** [tree-sitter/tree-sitter-go](https://github.com/tree-sitter/tree-sitter-go) 🐌
- **Go Checksums:** [golang/vscode-go](https://github.com/golang/vscode-go)
- **Go Module:** [golang/vscode-go](https://github.com/golang/vscode-go)
- **Go Workspace:** [golang/vscode-go](https://github.com/golang/vscode-go)
- **Godot Resource:** [godotengine/godot-vscode-plugin](https://github.com/godotengine/godot-vscode-plugin)
- **Golo:** [TypeUnsafe/sublime-golo](https://github.com/TypeUnsafe/sublime-golo)
- **Gosu:** [jpcamara/Textmate-Gosu-Bundle](https://github.com/jpcamara/Textmate-Gosu-Bundle)
- **Grace:** [zmthy/grace-tmbundle](https://github.com/zmthy/grace-tmbundle)
- **Gradle:** [alkemist/gradle.tmbundle](https://github.com/alkemist/gradle.tmbundle)
- **Grammatical Framework:** [johnjcamilleri/language-gf](https://github.com/johnjcamilleri/language-gf)
- **GraphQL:** [graphql/graphiql](https://github.com/graphql/graphiql)
- **Graphviz (DOT):** [textmate/graphviz.tmbundle](https://github.com/textmate/graphviz.tmbundle)
- **Groovy:** [textmate/groovy.tmbundle](https://github.com/textmate/groovy.tmbundle)
- **Groovy Server Pages:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **HAProxy:** [abulimov/atom-language-haproxy](https://github.com/abulimov/atom-language-haproxy)
- **HCL:** [alexlouden/Terraform.tmLanguage](https://github.com/alexlouden/Terraform.tmLanguage)
- **HLSL:** [tgjones/shaders-tmLanguage](https://github.com/tgjones/shaders-tmLanguage)
- **HOCON:** [jacobwgillespie/language-hocon](https://github.com/jacobwgillespie/language-hocon)
- **HTML:** [tree-sitter/tree-sitter-html](https://github.com/tree-sitter/tree-sitter-html) 🐌
- **HTML+ECR:** [atom-crystal/language-crystal](https://github.com/atom-crystal/language-crystal)
- **HTML+EEX:** [elixir-lang/elixir-tmbundle](https://github.com/elixir-lang/elixir-tmbundle)
- **HTML+ERB:** [atom/language-ruby](https://github.com/atom/language-ruby)
- **HTML+PHP:** [ondrejmirtes/php.tmbundle](https://github.com/ondrejmirtes/php.tmbundle)
- **HTML+Razor:** [github-linguist/razor-plus](https://github.com/github-linguist/razor-plus)
- **HTTP:** [samsalisbury/Sublime-HTTP](https://github.com/samsalisbury/Sublime-HTTP)
- **HXML:** [vshaxe/haxe-TmLanguage](https://github.com/vshaxe/haxe-TmLanguage)
- **Hack:** [slackhq/vscode-hack](https://github.com/slackhq/vscode-hack)
- **Haml:** [ezekg/language-haml](https://github.com/ezekg/language-haml)
- **Handlebars:** [daaain/Handlebars](https://github.com/daaain/Handlebars)
- **Harbour:** [hernad/atom-language-harbour](https://github.com/hernad/atom-language-harbour)
- **Haskell:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **Haxe:** [vshaxe/haxe-TmLanguage](https://github.com/vshaxe/haxe-TmLanguage)
- **HiveQL:** [adidonato/language-hql](https://github.com/adidonato/language-hql)
- **HolyC:** [codingdandy/holyc.tmbundle](https://github.com/codingdandy/holyc.tmbundle)
- **Hosts File:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Hy:** [tshakalekholoane/vscode-hy](https://github.com/tshakalekholoane/vscode-hy)
- **IDL:** [mgalloy/idl.tmbundle](https://github.com/mgalloy/idl.tmbundle)
- **IGOR Pro:** [byte-physics/language-igor](https://github.com/byte-physics/language-igor)
- **INI:** [textmate/ini.tmbundle](https://github.com/textmate/ini.tmbundle)
- **Idris:** [idris-hackers/idris-sublime](https://github.com/idris-hackers/idris-sublime)
- **Ignore List:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Imba:** [imba/imba-linguist-grammar](https://github.com/imba/imba-linguist-grammar)
- **Inform 7:** [iftechfoundation/language-inform7](https://github.com/iftechfoundation/language-inform7)
- **Ink:** [inkle/ink-tmlanguage](https://github.com/inkle/ink-tmlanguage)
- **Inno Setup:** [idleberg/atom-language-innosetup](https://github.com/idleberg/atom-language-innosetup)
- **Io:** [textmate/io.tmbundle](https://github.com/textmate/io.tmbundle)
- **Ioke:** [vic/ioke-outdated](https://github.com/vic/ioke-outdated)
- **Isabelle:** [lsf37/Isabelle.tmbundle](https://github.com/lsf37/Isabelle.tmbundle)
- **Isabelle ROOT:** [lsf37/Isabelle.tmbundle](https://github.com/lsf37/Isabelle.tmbundle)
- **J:** [tikkanz/JSyntax](https://github.com/tikkanz/JSyntax)
- **JAR Manifest:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **JCL:** [spgennard/vscode_cobol](https://github.com/spgennard/vscode_cobol)
- **JFlex:** [jflex-de/jflex.tmbundle](https://github.com/jflex-de/jflex.tmbundle)
- **JSON:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **JSON with Comments:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **JSON5:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **JSONLD:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **JSONiq:** [wcandillon/language-jsoniq](https://github.com/wcandillon/language-jsoniq)
- **Janet:** [janet-lang/vscode-janet](https://github.com/janet-lang/vscode-janet)
- **Jasmin:** [atmarksharp/jasmin-sublime](https://github.com/atmarksharp/jasmin-sublime)
- **Java:** [tree-sitter/tree-sitter-java](https://github.com/tree-sitter/tree-sitter-java) 🐌
- **Java Properties:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **Java Server Pages:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **JavaScript:** [tree-sitter/tree-sitter-javascript](https://github.com/tree-sitter/tree-sitter-javascript) 🐌
- **JavaScript+ERB:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **Jest Snapshot:** [jest-community/vscode-jest](https://github.com/jest-community/vscode-jest)
- **Jinja:** [textmate/python-django.tmbundle](https://github.com/textmate/python-django.tmbundle)
- **Jison:** [cdibbs/language-jison](https://github.com/cdibbs/language-jison)
- **Jison Lex:** [cdibbs/language-jison](https://github.com/cdibbs/language-jison)
- **Jolie:** [fmontesi/language-jolie](https://github.com/fmontesi/language-jolie)
- **Jsonnet:** [google/language-jsonnet](https://github.com/google/language-jsonnet)
- **Julia:** [JuliaEditorSupport/atom-language-julia](https://github.com/JuliaEditorSupport/atom-language-julia)
- **Jupyter Notebook:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **Just:** [skellock/vscode-just](https://github.com/skellock/vscode-just)
- **Kaitai Struct:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **KakouneScript:** [kakoune-editor/language-kak](https://github.com/kakoune-editor/language-kak)
- **KerboScript:** [KSP-KOS/language-kerboscript](https://github.com/KSP-KOS/language-kerboscript)
- **KiCad Layout:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **KiCad Legacy Layout:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **KiCad Schematic:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **Kickstart:** [wgwoods/language-kickstart](https://github.com/wgwoods/language-kickstart)
- **Kit:** [atom/language-html](https://github.com/atom/language-html)
- **Kotlin:** [nishtahir/language-kotlin](https://github.com/nishtahir/language-kotlin)
- **Kusto:** [mmanela/kusto-sublime](https://github.com/mmanela/kusto-sublime)
- **LFE:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **LLVM:** [whitequark/llvm.tmbundle](https://github.com/whitequark/llvm.tmbundle)
- **LOLCODE:** [KrazIvan/LOLCODE-grammar-vscode](https://github.com/KrazIvan/LOLCODE-grammar-vscode)
- **LSL:** [textmate/secondlife-lsl.tmbundle](https://github.com/textmate/secondlife-lsl.tmbundle)
- **LTspice Symbol:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **LabVIEW:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **Lark:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **Lasso:** [bfad/Sublime-Lasso](https://github.com/bfad/Sublime-Lasso)
- **Latte:** [textmate/php-smarty.tmbundle](https://github.com/textmate/php-smarty.tmbundle)
- **Lean:** [leanprover/vscode-lean](https://github.com/leanprover/vscode-lean)
- **Less:** [atom/language-less](https://github.com/atom/language-less)
- **Lex:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **LigoLANG:** [pewulfman/Ligo-grammar](https://github.com/pewulfman/Ligo-grammar)
- **LilyPond:** [nwhetsell/linter-lilypond](https://github.com/nwhetsell/linter-lilypond)
- **Liquid:** [Shopify/liquid-tm-grammar](https://github.com/Shopify/liquid-tm-grammar)
- **Literate CoffeeScript:** [atom/language-coffee-script](https://github.com/atom/language-coffee-script)
- **Literate Haskell:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **LiveScript:** [paulmillr/LiveScript.tmbundle](https://github.com/paulmillr/LiveScript.tmbundle)
- **Logos:** [Cykey/Sublime-Logos](https://github.com/Cykey/Sublime-Logos)
- **Logtalk:** [textmate/logtalk.tmbundle](https://github.com/textmate/logtalk.tmbundle)
- **LookML:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **LoomScript:** [ambethia/Sublime-Loom](https://github.com/ambethia/Sublime-Loom)
- **Lua:** [textmate/lua.tmbundle](https://github.com/textmate/lua.tmbundle)
- **M4:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **M4Sugar:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **MATLAB:** [mathworks/MATLAB-Language-grammar](https://github.com/mathworks/MATLAB-Language-grammar)
- **MAXScript:** [Alhadis/language-maxscript](https://github.com/Alhadis/language-maxscript)
- **MDX:** [wooorm/markdown-tm-language](https://github.com/wooorm/markdown-tm-language)
- **MLIR:** [jpienaar/mlir-grammar](https://github.com/jpienaar/mlir-grammar)
- **MQL4:** [mqsoft/MQL5-sublime](https://github.com/mqsoft/MQL5-sublime)
- **MQL5:** [mqsoft/MQL5-sublime](https://github.com/mqsoft/MQL5-sublime)
- **MTML:** [atom/language-html](https://github.com/atom/language-html)
- **Macaulay2:** [Macaulay2/language-macaulay2](https://github.com/Macaulay2/language-macaulay2)
- **Makefile:** [textmate/make.tmbundle](https://github.com/textmate/make.tmbundle)
- **Mako:** [marconi/mako-tmbundle](https://github.com/marconi/mako-tmbundle)
- **Markdown:** [wooorm/markdown-tm-language](https://github.com/wooorm/markdown-tm-language)
- **Marko:** [marko-js/marko-tmbundle](https://github.com/marko-js/marko-tmbundle)
- **Mask:** [tenbits/sublime-mask](https://github.com/tenbits/sublime-mask)
- **Mathematica:** [shadanan/mathematica-tmbundle](https://github.com/shadanan/mathematica-tmbundle)
- **Maven POM:** [textmate/maven.tmbundle](https://github.com/textmate/maven.tmbundle)
- **Max:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **Mercury:** [sebgod/mercury-tmlanguage](https://github.com/sebgod/mercury-tmlanguage)
- **Mermaid:** [Alhadis/language-mermaid](https://github.com/Alhadis/language-mermaid)
- **Meson:** [TingPing/language-meson](https://github.com/TingPing/language-meson)
- **Metal:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Microsoft Visual Studio Solution:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **MiniYAML:** [OpenRA/atom-miniyaml](https://github.com/OpenRA/atom-miniyaml)
- **Mint:** [mint-lang/mint-vscode](https://github.com/mint-lang/mint-vscode)
- **Mirah:** [atom/language-ruby](https://github.com/atom/language-ruby)
- **Modelica:** [BorisChumichev/modelicaSublimeTextPackage](https://github.com/BorisChumichev/modelicaSublimeTextPackage)
- **Modula-2:** [harogaston/Sublime-Modula-2](https://github.com/harogaston/Sublime-Modula-2)
- **Modula-3:** [newgrammars/m3](https://github.com/newgrammars/m3)
- **Monkey:** [gingerbeardman/monkey.tmbundle](https://github.com/gingerbeardman/monkey.tmbundle)
- **Monkey C:** [ghisguth/vscode-monkey-c](https://github.com/ghisguth/vscode-monkey-c)
- **MoonScript:** [leafo/moonscript-tmbundle](https://github.com/leafo/moonscript-tmbundle)
- **Motoko:** [dfinity/vscode-motoko](https://github.com/dfinity/vscode-motoko)
- **Motorola 68K Assembly:** [zerkman/language-m68k](https://github.com/zerkman/language-m68k)
- **Move:** [damirka/vscode-move-syntax](https://github.com/damirka/vscode-move-syntax)
- **Muse:** [Alhadis/language-emacs-lisp](https://github.com/Alhadis/language-emacs-lisp)
- **Mustache:** [textmate/php-smarty.tmbundle](https://github.com/textmate/php-smarty.tmbundle)
- **NASL:** [tenable/sublimetext-nasl](https://github.com/tenable/sublimetext-nasl)
- **NCL:** [rpavlick/language-ncl](https://github.com/rpavlick/language-ncl)
- **NEON:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **NPM Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **NSIS:** [github-linguist/NSIS](https://github.com/github-linguist/NSIS)
- **NWScript:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Nasal:** [BobDotCom/Nasal.tmbundle](https://github.com/BobDotCom/Nasal.tmbundle)
- **Nearley:** [Hardmath123/sublime-nearley](https://github.com/Hardmath123/sublime-nearley)
- **Nemerle:** [textmate/nemerle.tmbundle](https://github.com/textmate/nemerle.tmbundle)
- **NetLinx:** [amclain/sublime-netlinx](https://github.com/amclain/sublime-netlinx)
- **NetLinx+ERB:** [amclain/sublime-netlinx](https://github.com/amclain/sublime-netlinx)
- **NetLogo:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **NewLisp:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **Nextflow:** [nextflow-io/atom-language-nextflow](https://github.com/nextflow-io/atom-language-nextflow)
- **Nginx:** [brandonwamboldt/sublime-nginx](https://github.com/brandonwamboldt/sublime-nginx)
- **Nim:** [nim-lang/NimLime](https://github.com/nim-lang/NimLime)
- **Ninja:** [khyo/language-ninja](https://github.com/khyo/language-ninja)
- **Nit:** [R4PaSs/Sublime-Nit](https://github.com/R4PaSs/Sublime-Nit)
- **Nix:** [sambacha/nix-linguist](https://github.com/sambacha/nix-linguist)
- **Nu:** [jsallis/nu.tmbundle](https://github.com/jsallis/nu.tmbundle)
- **Nunjucks:** [alohaas/language-nunjucks](https://github.com/alohaas/language-nunjucks)
- **Nushell:** [hustcer/nu-grammar](https://github.com/hustcer/nu-grammar)
- **OASv2-json:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **OASv2-yaml:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **OASv3-json:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **OASv3-yaml:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **OCaml:** [textmate/ocaml.tmbundle](https://github.com/textmate/ocaml.tmbundle)
- **ObjDump:** [nanoant/assembly.tmbundle](https://github.com/nanoant/assembly.tmbundle)
- **Object Data Instance Notation:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **ObjectScript:** [intersystems-community/ObjectScript.tmBundle](https://github.com/intersystems-community/ObjectScript.tmBundle)
- **Objective-C:** [textmate/objective-c.tmbundle](https://github.com/textmate/objective-c.tmbundle)
- **Objective-C++:** [textmate/objective-c.tmbundle](https://github.com/textmate/objective-c.tmbundle)
- **Objective-J:** [textmate/javascript-objective-j.tmbundle](https://github.com/textmate/javascript-objective-j.tmbundle)
- **Odin:** [odin-lang/sublime-odin](https://github.com/odin-lang/sublime-odin)
- **Opa:** [mads379/opa.tmbundle](https://github.com/mads379/opa.tmbundle)
- **Opal:** [artifactz/sublime-opal](https://github.com/artifactz/sublime-opal)
- **Open Policy Agent:** [tsandall/vscode-opa](https://github.com/tsandall/vscode-opa)
- **OpenCL:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **OpenEdge ABL:** [chriscamicas/abl-tmlanguage](https://github.com/chriscamicas/abl-tmlanguage)
- **OpenQASM:** [tareqdandachi/language-qasm](https://github.com/tareqdandachi/language-qasm)
- **OpenRC runscript:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **OpenSCAD:** [tbuser/openscad.tmbundle](https://github.com/tbuser/openscad.tmbundle)
- **OpenStep Property List:** [atom/language-property-list](https://github.com/atom/language-property-list)
- **OpenType Feature File:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Option List:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Ox:** [andreashetland/sublime-text-ox](https://github.com/andreashetland/sublime-text-ox)
- **Oz:** [eregon/oz-tmbundle](https://github.com/eregon/oz-tmbundle)
- **P4:** [TakeshiTseng/atom-language-p4](https://github.com/TakeshiTseng/atom-language-p4)
- **PDDL:** [jan-dolejsi/vscode-pddl](https://github.com/jan-dolejsi/vscode-pddl)
- **PEG.js:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **PHP:** [tree-sitter/tree-sitter-php](https://github.com/tree-sitter/tree-sitter-php) 🐌
- **PLpgSQL:** [textmate/sql.tmbundle](https://github.com/textmate/sql.tmbundle)
- **POV-Ray SDL:** [c-lipka/language-povray](https://github.com/c-lipka/language-povray)
- **Pact:** [kadena-io/pact-atom](https://github.com/kadena-io/pact-atom)
- **Pan:** [quattor/language-pan](https://github.com/quattor/language-pan)
- **Papyrus:** [Kapiainen/SublimePapyrus](https://github.com/Kapiainen/SublimePapyrus)
- **Parrot Internal Representation:** [textmate/parrot.tmbundle](https://github.com/textmate/parrot.tmbundle)
- **Pascal:** [textmate/pascal.tmbundle](https://github.com/textmate/pascal.tmbundle)
- **Pawn:** [Southclaw/pawn-sublime-language](https://github.com/Southclaw/pawn-sublime-language)
- **Pep8:** [R4PaSs/Sublime-Pep8](https://github.com/R4PaSs/Sublime-Pep8)
- **Perl:** [textmate/perl.tmbundle](https://github.com/textmate/perl.tmbundle)
- **Pic:** [Alhadis/language-roff](https://github.com/Alhadis/language-roff)
- **PicoLisp:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **PigLatin:** [goblindegook/sublime-text-pig-latin](https://github.com/goblindegook/sublime-text-pig-latin)
- **Pike:** [hww3/pike-textmate](https://github.com/hww3/pike-textmate)
- **PlantUML:** [qjebbs/vscode-plantuml](https://github.com/qjebbs/vscode-plantuml)
- **Pod 6:** [perl6/atom-language-perl6](https://github.com/perl6/atom-language-perl6)
- **PogoScript:** [featurist/PogoScript.tmbundle](https://github.com/featurist/PogoScript.tmbundle)
- **Polar:** [osohq/polar-grammar](https://github.com/osohq/polar-grammar)
- **Pony:** [CausalityLtd/sublime-pony](https://github.com/CausalityLtd/sublime-pony)
- **Portugol:** [luisgbr1el/portugol-grammar](https://github.com/luisgbr1el/portugol-grammar)
- **PostCSS:** [hudochenkov/Syntax-highlighting-for-PostCSS](https://github.com/hudochenkov/Syntax-highlighting-for-PostCSS)
- **PostScript:** [Alhadis/Atom-PostScript](https://github.com/Alhadis/Atom-PostScript)
- **PowerShell:** [PowerShell/EditorSyntax](https://github.com/PowerShell/EditorSyntax)
- **Prisma:** [prisma/vscode-prisma](https://github.com/prisma/vscode-prisma)
- **Processing:** [textmate/processing.tmbundle](https://github.com/textmate/processing.tmbundle)
- **Procfile:** [benspaulding/vscode-procfile](https://github.com/benspaulding/vscode-procfile)
- **Prolog:** [alnkpa/sublimeprolog](https://github.com/alnkpa/sublimeprolog)
- **Promela:** [corbanmailloux/sublime-promela-spin](https://github.com/corbanmailloux/sublime-promela-spin)
- **Propeller Spin:** [bitbased/sublime-spintools](https://github.com/bitbased/sublime-spintools)
- **Protocol Buffer:** [zxh0/vscode-proto3](https://github.com/zxh0/vscode-proto3)
- **Protocol Buffer Text Format:** [thejustinwalsh/textproto-grammar](https://github.com/thejustinwalsh/textproto-grammar)
- **Pug:** [davidrios/jade-tmbundle](https://github.com/davidrios/jade-tmbundle)
- **Puppet:** [russCloak/SublimePuppet](https://github.com/russCloak/SublimePuppet)
- **PureScript:** [purescript-contrib/atom-language-purescript](https://github.com/purescript-contrib/atom-language-purescript)
- **Pyret:** [samuela/language-pyret](https://github.com/samuela/language-pyret)
- **Python:** [tree-sitter/tree-sitter-python](https://github.com/tree-sitter/tree-sitter-python) 🐌
- **Python console:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Python traceback:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Q#:** [microsoft/qsharp-compiler](https://github.com/microsoft/qsharp-compiler)
- **QML:** [skozlovf/Sublime-QML](https://github.com/skozlovf/Sublime-QML)
- **QMake:** [textmate/cpp-qt.tmbundle](https://github.com/textmate/cpp-qt.tmbundle)
- **Qt Script:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **Quake:** [newgrammars/quake](https://github.com/newgrammars/quake)
- **R:** [textmate/r.tmbundle](https://github.com/textmate/r.tmbundle)
- **RAML:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **RBS:** [soutaro/vscode-rbs-syntax](https://github.com/soutaro/vscode-rbs-syntax)
- **RDoc:** [joshaven/RDoc.tmbundle](https://github.com/joshaven/RDoc.tmbundle)
- **REALbasic:** [peters-ben-0007/VBDotNetSyntax](https://github.com/peters-ben-0007/VBDotNetSyntax)
- **REXX:** [mblocker/rexx-sublime](https://github.com/mblocker/rexx-sublime)
- **RMarkdown:** [wooorm/markdown-tm-language](https://github.com/wooorm/markdown-tm-language)
- **RPC:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **RPGLE:** [barrettotte/vscode-ibmi-languages](https://github.com/barrettotte/vscode-ibmi-languages)
- **RPM Spec:** [waveclaw/language-rpm-spec](https://github.com/waveclaw/language-rpm-spec)
- **RUNOFF:** [Alhadis/language-roff](https://github.com/Alhadis/language-roff)
- **Racket:** [soegaard/racket-highlight-for-github](https://github.com/soegaard/racket-highlight-for-github)
- **Raku:** [perl6/atom-language-perl6](https://github.com/perl6/atom-language-perl6)
- **Rascal:** [usethesource/rascal-syntax-highlighting](https://github.com/usethesource/rascal-syntax-highlighting)
- **ReScript:** [rescript-lang/rescript-vscode](https://github.com/rescript-lang/rescript-vscode)
- **Readline Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Reason:** [reasonml-editor/language-reason](https://github.com/reasonml-editor/language-reason)
- **ReasonLIGO:** [pewulfman/Ligo-grammar](https://github.com/pewulfman/Ligo-grammar)
- **Rebol:** [Oldes/Sublime-REBOL](https://github.com/Oldes/Sublime-REBOL)
- **Record Jar:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Red:** [Oldes/Sublime-Red](https://github.com/Oldes/Sublime-Red)
- **Redirect Rules:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **Regular Expression:** [Alhadis/language-regexp](https://github.com/Alhadis/language-regexp)
- **Ren'Py:** [williamd1k0/language-renpy](https://github.com/williamd1k0/language-renpy)
- **Rich Text Format:** [nwhetsell/language-rtf](https://github.com/nwhetsell/language-rtf)
- **Ring:** [MahmoudFayed/atom-language-ring](https://github.com/MahmoudFayed/atom-language-ring)
- **Riot:** [riot/syntax-highlight](https://github.com/riot/syntax-highlight)
- **RobotFramework:** [shellderp/sublime-robot-plugin](https://github.com/shellderp/sublime-robot-plugin)
- **Roff:** [Alhadis/language-roff](https://github.com/Alhadis/language-roff)
- **Roff Manpage:** [Alhadis/language-roff](https://github.com/Alhadis/language-roff)
- **Rouge:** [atom/language-clojure](https://github.com/atom/language-clojure)
- **Ruby:** [tree-sitter/tree-sitter-ruby](https://github.com/tree-sitter/tree-sitter-ruby) 🐌
- **Rust:** [tree-sitter/tree-sitter-rust](https://github.com/tree-sitter/tree-sitter-rust) 🐌
- **SAS:** [rpardee/sas.tmbundle](https://github.com/rpardee/sas.tmbundle)
- **SCSS:** [atom/language-sass](https://github.com/atom/language-sass)
- **SELinux Policy:** [google/selinux-policy-languages](https://github.com/google/selinux-policy-languages)
- **SMT:** [SRI-CSL/SMT.tmbundle](https://github.com/SRI-CSL/SMT.tmbundle)
- **SPARQL:** [peta/turtle.tmbundle](https://github.com/peta/turtle.tmbundle)
- **SQF:** [JonBons/Sublime-SQF-Language](https://github.com/JonBons/Sublime-SQF-Language)
- **SQL:** [textmate/sql.tmbundle](https://github.com/textmate/sql.tmbundle)
- **SQLPL:** [textmate/sql.tmbundle](https://github.com/textmate/sql.tmbundle)
- **SRecode Template:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **SSH Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **STAR:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **STL:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **STON:** [tomas-stefano/smalltalk-tmbundle](https://github.com/tomas-stefano/smalltalk-tmbundle)
- **SVG:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **SWIG:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Sage:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **SaltStack:** [saltstack/atom-salt](https://github.com/saltstack/atom-salt)
- **Sass:** [atom/language-sass](https://github.com/atom/language-sass)
- **Scala:** [scala/vscode-scala-syntax](https://github.com/scala/vscode-scala-syntax)
- **Scaml:** [scalate/Scalate.tmbundle](https://github.com/scalate/Scalate.tmbundle)
- **Scenic:** [UCSCFormalMethods/Scenic-tmLanguage](https://github.com/UCSCFormalMethods/Scenic-tmLanguage)
- **Scheme:** [sicp-lang/scheme.tmbundle](https://github.com/sicp-lang/scheme.tmbundle)
- **Scilab:** [textmate/scilab.tmbundle](https://github.com/textmate/scilab.tmbundle)
- **ShaderLab:** [tgjones/shaders-tmLanguage](https://github.com/tgjones/shaders-tmLanguage)
- **Shell:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **ShellCheck Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **ShellSession:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **Shen:** [rkoeninger/sublime-shen](https://github.com/rkoeninger/sublime-shen)
- **Sieve:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Simple File Verification:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Singularity:** [onnovalkering/vscode-singularity](https://github.com/onnovalkering/vscode-singularity)
- **Slash:** [slash-lang/Slash.tmbundle](https://github.com/slash-lang/Slash.tmbundle)
- **Slice:** [zeroc-ice/vscode-slice](https://github.com/zeroc-ice/vscode-slice)
- **Slim:** [slim-template/ruby-slim.tmbundle](https://github.com/slim-template/ruby-slim.tmbundle)
- **SmPL:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Smali:** [ShaneWilton/sublime-smali](https://github.com/ShaneWilton/sublime-smali)
- **Smalltalk:** [tomas-stefano/smalltalk-tmbundle](https://github.com/tomas-stefano/smalltalk-tmbundle)
- **Smarty:** [textmate/php-smarty.tmbundle](https://github.com/textmate/php-smarty.tmbundle)
- **Smithy:** [awslabs/smithy-vscode](https://github.com/awslabs/smithy-vscode)
- **Snakemake:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Solidity:** [davidhq/SublimeEthereum](https://github.com/davidhq/SublimeEthereum)
- **Soong:** [flimberger/android-system-tools](https://github.com/flimberger/android-system-tools)
- **SourcePawn:** [Dreae/sourcepawn-vscode](https://github.com/Dreae/sourcepawn-vscode)
- **Spline Font Database:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Squirrel:** [mathewmariani/squirrel-language](https://github.com/mathewmariani/squirrel-language)
- **Stan:** [stan-dev/atom-language-stan](https://github.com/stan-dev/atom-language-stan)
- **Standard ML:** [textmate/standard-ml.tmbundle](https://github.com/textmate/standard-ml.tmbundle)
- **Starlark:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Stata:** [pschumm/Stata.tmbundle](https://github.com/pschumm/Stata.tmbundle)
- **StringTemplate:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Stylus:** [billymoon/Stylus](https://github.com/billymoon/Stylus)
- **SubRip Text:** [Alhadis/language-subtitles](https://github.com/Alhadis/language-subtitles)
- **SugarSS:** [hudochenkov/Syntax-highlighting-for-PostCSS](https://github.com/hudochenkov/Syntax-highlighting-for-PostCSS)
- **SuperCollider:** [supercollider/language-supercollider](https://github.com/supercollider/language-supercollider)
- **Svelte:** [sebastinez/svelte-atom](https://github.com/sebastinez/svelte-atom)
- **Sway:** [FuelLabs/sway-vscode-plugin](https://github.com/FuelLabs/sway-vscode-plugin)
- **Swift:** [textmate/swift.tmbundle](https://github.com/textmate/swift.tmbundle)
- **SystemVerilog:** [TheClams/SystemVerilog](https://github.com/TheClams/SystemVerilog)
- **TL-Verilog:** [adamint/tlv-vscode](https://github.com/adamint/tlv-vscode)
- **TLA:** [tlaplus-community/tree-sitter-tlaplus](https://github.com/tlaplus-community/tree-sitter-tlaplus) 🐌
- **TOML:** [textmate/toml.tmbundle](https://github.com/textmate/toml.tmbundle)
- **TSQL:** [beau-witter/language-tsql](https://github.com/beau-witter/language-tsql)
- **TSV:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **TSX:** [Microsoft/TypeScript-TmLanguage](https://github.com/Microsoft/TypeScript-TmLanguage)
- **TXL:** [MikeHoffert/Sublime-Text-TXL-syntax](https://github.com/MikeHoffert/Sublime-Text-TXL-syntax)
- **Talon:** [mrob95/vscode-TalonScript](https://github.com/mrob95/vscode-TalonScript)
- **Tcl:** [textmate/tcl.tmbundle](https://github.com/textmate/tcl.tmbundle)
- **Tcsh:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **TeX:** [textmate/latex.tmbundle](https://github.com/textmate/latex.tmbundle)
- **Tea:** [pferruggiaro/sublime-tea](https://github.com/pferruggiaro/sublime-tea)
- **Terra:** [pyk/sublime-terra](https://github.com/pyk/sublime-terra)
- **Texinfo:** [Alhadis/language-texinfo](https://github.com/Alhadis/language-texinfo)
- **TextMate Properties:** [textmate/textmate.tmbundle](https://github.com/textmate/textmate.tmbundle)
- **Thrift:** [textmate/thrift.tmbundle](https://github.com/textmate/thrift.tmbundle)
- **Turing:** [Alhadis/language-turing](https://github.com/Alhadis/language-turing)
- **Turtle:** [peta/turtle.tmbundle](https://github.com/peta/turtle.tmbundle)
- **Twig:** [Anomareh/PHP-Twig.tmbundle](https://github.com/Anomareh/PHP-Twig.tmbundle)
- **Type Language:** [goodmind/language-typelanguage](https://github.com/goodmind/language-typelanguage)
- **TypeScript:** [tree-sitter/tree-sitter-typescript](https://github.com/tree-sitter/tree-sitter-typescript) 🐌
- **Unified Parallel C:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Unity3D Asset:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **Unix Assembly:** [calculuswhiz/Assembly-Syntax-Definition](https://github.com/calculuswhiz/Assembly-Syntax-Definition)
- **Uno:** [dotnet/csharp-tmLanguage](https://github.com/dotnet/csharp-tmLanguage)
- **UnrealScript:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **UrWeb:** [gwalborn/UrWeb-Language-Definition](https://github.com/gwalborn/UrWeb-Language-Definition)
- **V:** [0x9ef/vscode-vlang](https://github.com/0x9ef/vscode-vlang)
- **VBA:** [tiabeast/vscode-vba-json](https://github.com/tiabeast/vscode-vba-json)
- **VBScript:** [peters-ben-0007/VBDotNetSyntax](https://github.com/peters-ben-0007/VBDotNetSyntax)
- **VCL:** [brandonwamboldt/sublime-varnish](https://github.com/brandonwamboldt/sublime-varnish)
- **VHDL:** [textmate/vhdl.tmbundle](https://github.com/textmate/vhdl.tmbundle)
- **Vala:** [technosophos/Vala-TMBundle](https://github.com/technosophos/Vala-TMBundle)
- **Valve Data Format:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **Velocity Template Language:** [animecyc/AtomLanguageVelocity](https://github.com/animecyc/AtomLanguageVelocity)
- **Verilog:** [textmate/verilog.tmbundle](https://github.com/textmate/verilog.tmbundle)
- **Vim Help File:** [Alhadis/language-viml](https://github.com/Alhadis/language-viml)
- **Vim Script:** [Alhadis/language-viml](https://github.com/Alhadis/language-viml)
- **Vim Snippet:** [Alhadis/language-viml](https://github.com/Alhadis/language-viml)
- **Visual Basic .NET:** [peters-ben-0007/VBDotNetSyntax](https://github.com/peters-ben-0007/VBDotNetSyntax)
- **Visual Basic 6.0:** [peters-ben-0007/VBDotNetSyntax](https://github.com/peters-ben-0007/VBDotNetSyntax)
- **Volt:** [textmate/d.tmbundle](https://github.com/textmate/d.tmbundle)
- **Vue:** [vuejs/vue-syntax-highlight](https://github.com/vuejs/vue-syntax-highlight)
- **Vyper:** [davidhq/SublimeEthereum](https://github.com/davidhq/SublimeEthereum)
- **WDL:** [broadinstitute/wdl-sublime-syntax-highlighter](https://github.com/broadinstitute/wdl-sublime-syntax-highlighter)
- **WGSL:** [wgsl-analyzer/wgsl-analyzer](https://github.com/wgsl-analyzer/wgsl-analyzer)
- **Wavefront Material:** [Alhadis/language-wavefront](https://github.com/Alhadis/language-wavefront)
- **Wavefront Object:** [Alhadis/language-wavefront](https://github.com/Alhadis/language-wavefront)
- **Web Ontology Language:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **WebAssembly:** [Alhadis/language-webassembly](https://github.com/Alhadis/language-webassembly)
- **WebAssembly Interface Type:** [bytecodealliance/vscode-wit](https://github.com/bytecodealliance/vscode-wit)
- **WebIDL:** [andik/IDL-Syntax](https://github.com/andik/IDL-Syntax)
- **WebVTT:** [Alhadis/language-subtitles](https://github.com/Alhadis/language-subtitles)
- **Wget Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Whiley:** [Whiley/WhileySyntaxBundle](https://github.com/Whiley/WhileySyntaxBundle)
- **Wikitext:** [textmate/mediawiki.tmbundle](https://github.com/textmate/mediawiki.tmbundle)
- **Win32 Message File:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **Windows Registry Entries:** [bsara/language-reg](https://github.com/bsara/language-reg)
- **Witcher Script:** [ADawesomeguy/witcherscript-grammar](https://github.com/ADawesomeguy/witcherscript-grammar)
- **Wollok:** [uqbar-project/wollok-sublime](https://github.com/uqbar-project/wollok-sublime)
- **World of Warcraft Addon Data:** [nebularg/language-toc-wow](https://github.com/nebularg/language-toc-wow)
- **Wren:** [Nelarius/vscode-wren](https://github.com/Nelarius/vscode-wren)
- **X BitMap:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **X Font Directory Index:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **X PixMap:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **X10:** [x10-lang/x10-highlighting](https://github.com/x10-lang/x10-highlighting)
- **XC:** [graymalkin/xc.tmbundle](https://github.com/graymalkin/xc.tmbundle)
- **XCompose:** [samcv/language-xcompose](https://github.com/samcv/language-xcompose)
- **XML:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **XML Property List:** [atom/language-property-list](https://github.com/atom/language-property-list)
- **XPages:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **XProc:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **XQuery:** [wcandillon/language-jsoniq](https://github.com/wcandillon/language-jsoniq)
- **XS:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **XSLT:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **Xojo:** [jimmckay/XojoSyntaxTM](https://github.com/jimmckay/XojoSyntaxTM)
- **Xonsh:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Xtend:** [staltz/SublimeXtend](https://github.com/staltz/SublimeXtend)
- **YAML:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **YANG:** [DzonyKalafut/language-yang](https://github.com/DzonyKalafut/language-yang)
- **YARA:** [infosec-intern/vscode-yara](https://github.com/infosec-intern/vscode-yara)
- **YASnippet:** [Alhadis/language-emacs-lisp](https://github.com/Alhadis/language-emacs-lisp)
- **Yacc:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **Yul:** [davidhq/SublimeEthereum](https://github.com/davidhq/SublimeEthereum)
- **ZAP:** [tclem/vscode-zil-language](https://github.com/tclem/vscode-zil-language)
- **ZIL:** [tclem/vscode-zil-language](https://github.com/tclem/vscode-zil-language)
- **Zeek:** [zeek/zeek-sublime](https://github.com/zeek/zeek-sublime)
- **ZenScript:** [CraftTweaker/ZenScript-tmLanguage](https://github.com/CraftTweaker/ZenScript-tmLanguage)
- **Zephir:** [phalcon/zephir-sublime](https://github.com/phalcon/zephir-sublime)
- **Zig:** [ziglang/sublime-zig-language](https://github.com/ziglang/sublime-zig-language)
- **cURL Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **desktop:** [Mailaender/desktop.tmbundle](https://github.com/Mailaender/desktop.tmbundle)
- **dircolors:** [jolkdarr/language-dircolors](https://github.com/jolkdarr/language-dircolors)
- **eC:** [ecere/ec.tmbundle](https://github.com/ecere/ec.tmbundle)
- **edn:** [atom/language-clojure](https://github.com/atom/language-clojure)
- **fish:** [l15n/fish-tmbundle](https://github.com/l15n/fish-tmbundle)
- **hoon:** [pkova/hoon-grammar](https://github.com/pkova/hoon-grammar)
- **jq:** [wader/language-jq](https://github.com/wader/language-jq)
- **kvlang:** [p0lygun/kivy-language-grammer](https://github.com/p0lygun/kivy-language-grammer)
- **mIRC Script:** [gen-angry/language-msl](https://github.com/gen-angry/language-msl)
- **mcfunction:** [Arcensoth/language-mcfunction](https://github.com/Arcensoth/language-mcfunction)
- **mupad:** [ccreutzig/sublime-MuPAD](https://github.com/ccreutzig/sublime-MuPAD)
- **nanorc:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **nesC:** [cdwilson/nesC.tmbundle](https://github.com/cdwilson/nesC.tmbundle)
- **ooc:** [nilium/ooc.tmbundle](https://github.com/nilium/ooc.tmbundle)
- **q:** [komsit37/sublime-q](https://github.com/komsit37/sublime-q)
- **reStructuredText:** [Lukasa/language-restructuredtext](https://github.com/Lukasa/language-restructuredtext)
- **robots.txt:** [Nixinova/NovaGrammars](https://github.com/Nixinova/NovaGrammars)
- **sed:** [Alhadis/language-sed](https://github.com/Alhadis/language-sed)
- **wisp:** [atom/language-clojure](https://github.com/atom/language-clojure)
- **xBase:** [hernad/atom-language-harbour](https://github.com/hernad/atom-language-harbour)
