(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    200462,       3656]
NotebookOptionsPosition[    199657,       3624]
NotebookOutlinePosition[    200002,       3639]
CellTagsIndexPosition[    199959,       3636]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
How far is the Earth from the Moon?\
\>", "WolframAlphaLong",
 CellChangeTimes->{{3.6112720079145803`*^9, 3.61127201386392*^9}}],

Cell[BoxData[
 NamespaceBox["WolframAlphaQueryResults",
  DynamicModuleBox[{Typeset`q$$ = "How far is the Earth from the Moon?", 
   Typeset`opts$$ = {
   AppearanceElements -> {
     "Warnings", "Assumptions", "Brand", "Pods", "PodMenus", "Unsuccessful", 
      "Sources"}, Asynchronous -> All, 
    TimeConstraint -> {30, Automatic, Automatic, Automatic}, 
    Method -> {
     "Formats" -> {"cell", "minput", "msound", "dataformats"}, "Server" -> 
      "http://api.wolframalpha.com/v1/"}}, Typeset`elements$$ = {
   "Warnings", "Assumptions", "Brand", "Pods", "PodMenus", "Unsuccessful", 
    "Sources"}, Typeset`pod1$$ = XMLElement[
   "pod", {"title" -> "Input interpretation", "scanner" -> "Identity", "id" -> 
     "Input", "position" -> "100", "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             FormBox[
              TagBox[
               GridBox[{{
                  PaneBox[
                   StyleBox[
                    TagBox[
                    GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox["\"Moon\"", 
                    $CellContext`TagBoxWrapper[
                    "Entity" -> {AstronomicalData, "Moon"}]], Identity], {
                    LineIndent -> 0, LineSpacing -> {0.9, 0, 1.5}}], 
                    "\"distance from Earth\""}}, 
                    GridBoxBackground -> {"Columns" -> {
                    GrayLevel[0.949], None}, "Rows" -> {{None}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    ColumnsEqual -> False, RowsEqual -> False, 
                    GridBoxDividers -> {"Columns" -> {
                    GrayLevel[0.84], 
                    GrayLevel[0.84], 
                    GrayLevel[0.84]}, "Rows" -> {{
                    GrayLevel[0.84]}}, 
                    "RowsIndexed" -> {
                    1 -> GrayLevel[0.84], -1 -> GrayLevel[0.84]}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {1, 1, 1}, "Rows" -> {{0.3}}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Baseline}}}, 
                    AllowScriptLevelChange -> False, BaselinePosition -> 1], 
                    $CellContext`TagBoxWrapper["Separator" -> " | "]], 
                    LineSpacing -> {1, 0, 1.5}, LineIndent -> 0], 
                   BaselinePosition -> Center]}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                ColumnsEqual -> False, RowsEqual -> False, 
                GridBoxSpacings -> {"Columns" -> {{
                    AbsoluteThickness[-1]}}, "Rows" -> {{0}}}, 
                AllowScriptLevelChange -> False], 
               $CellContext`TagBoxWrapper["Separator" -> " | "]], 
              TraditionalForm], 
             PolynomialForm[#, TraditionalOrder -> False]& ], 
            TraditionalForm]], "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {"plaintext,computabledata,formatteddata"}]}]}], 
   Typeset`pod2$$ = XMLElement[
   "pod", {"title" -> "Current result", "scanner" -> "Data", "id" -> "Result",
      "position" -> "200", "error" -> "false", "numsubpods" -> "1", "primary" -> 
     "true"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              TagBox[
               TagBox[
                RowBox[{
                  TagBox["239\[ThinSpace]262", 
                   $CellContext`TagBoxWrapper["StringBoxes" -> "239262"]], 
                  "\[InvisibleSpace]", " ", 
                  StyleBox[
                  "\"miles\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                   LineIndent -> 0, {
                   FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
               SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,moutput,computabledata,formatteddata,numberdata,\
quantitydata"}]}], 
     XMLElement["states", {"count" -> "1"}, {
       XMLElement[
       "state", {
        "name" -> "Show metric", "input" -> "Result__Show metric"}, {}]}]}], 
   Typeset`pod3$$ = XMLElement[
   "pod", {"title" -> "History", "scanner" -> "Data", "id" -> 
     "DistanceHistory:AstronomicalData", "position" -> "300", "error" -> 
     "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            TemplateBox[{
              GraphicsBox[
               GraphicsComplexBox[CompressedData["
1:eJxcnHc8lv/7961K0lCUnRWl7JHMt7JCIoRCGso4r+u0QktRpIyGKCoaRkap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                "], {{{}, {
                   EdgeForm[], 
                   Directive[
                    Opacity[0.05], 
                    Hue[0.67, 0.6, 0.6]], 
                   GraphicsGroupBox[{
                    PolygonBox[CompressedData["
1:eJwl1nfYjnUYxvEH2XuTkD2yV1b23iTKnmWFMkr2SJTsVfauEClSSUOiUkaI
llIhIQ0qUX0u/XEe5/d73e/xep/7/t2Xp0CvIe0GJ00kEknkctL/O2eKRCKX
lOIV+VX9tws7dWX9hjyK17n2l0zktXgLPEYOyX1m2c1y4x2Shs+V1ma9+BW8
DRfVm2UAnmt+Ei/EZ/AQfAeugCvhk/h1/Yhea3ZJ/8BX6z/5BHwXbo5z45XS
lY/m3+pD/Gl9kO/W9/JsOhevjffKJL6d/64v8hd0an1Qz9GtdE/Xi+BN0j/m
/Kw+wRfE38Tf1YN5SV2eV8SvyUi+hl/U3/NV+g/+gR7Pa+pmPBdeIV34Y/wT
6ciz8pz4FUnFZ0tLsx58tnwvD5qVMCuHm8oo+Vg6mGcxz4HLShN5VA7IPa5l
di077i6z5DsZZF7cvAyugE/gnXqEXh0/E/cZX8XjcA3cOM4Q/hQv1531I2YH
8Qz8EW6PM+FsuBb+Cr+nJ+qXzX7TF/jzOqWeJS1wN9cK443Sj8/kZ/RnfL4+
zd/RA3kxXZqXx6/KcL6KX4ifi/urr/D9eiyvrhvxHHiZdOIj497jp/CH+E19
N8+os/K78B6ZwLfxFPiT+Lt0c93VrFCcI3mAPx1nUQbworwUXhnnLd4ds2pm
DfGIOBPSziyDWRbcRWbIN9LfvIj5HXhF3C8ZbVbVrAH+FW+J56mP6KX6Pj08
zgJ+Eu/HbXF6nBnXxF/id/V4/VL8Hv0Tf04nj/dHmuHOrhWM5yP386f4D/o4
n6dP8X64MC6Jy+EdMizOBP9Jf8uX61/5vjjn/E5dn2fDS+RePiw+sz7Ap+t9
fJduw9PpTLwGfkfG8a38F32eb9C36I/1DN1Ud3K9QHwm6cuf5F/LA7wQL4GX
xe+Id8esilk9/LC8L63N0ppljD0n0+Urud+8oHlxXFcekr3SyjyNeQa8RZLF
eZImsYPi2eOX8O36mN6g++hprn0pfXkBXgxfi7OMy+rPYlfph+P5xj2Kc4sv
x3uNK+M68Tnwi3Fe9WH9rO6oh7r2EZ4W7x5uiVPj9Ph67CtcXX+h39Zj9Yuu
/YjX46RxjqQx7mieHx/F63Vv/UTsI32Mz9Vf8D74dlwUl8GvyEN8CT8f54Yv
1T/HvY69wSvp2jwLfkY68CH8Q/wE3oPf0C14Kp2Ob5Yk/ACfrhvpDmb58Drp
xafyz6U3z8+L4Cv6rzirsTv0yzI07plrl2Qkr8hr4cGx56W5WUqztLFH5XE5
Kb3M85kXjj0Rezl2kzQzT2GeBm9KJG7+pztNGpq1p3nxWunJp8SO1Uf5HH2C
98R5cSFcCm+TIfyZeDb663h39MU4f3oEr6Br8sx4sdzDB/FT+gM+NZ4xf103
5cl1al4NvyVj+EZ+Lu4f/jfOTjxj3iB2YuwgvBXfptdIDzzZ/FM8O3Y0flv3
4LfpgvxPvD32WLwDEl9GFsf7hJ/FF/B7sbd4eV2DX8ab473Xi6Q9Hmj+ljTh
t/BUuCreLaP5C/wfmcrr83Z4khyX7mZ5zArg6rGbZbc0Nk9mnhI/Lzfi2ZrV
M2uLJ8ox6WZ2a7y/+I8407Hz9PHYRfpBvSje5Ti/sU/xMFwOV8M/402xT/Qh
vVDfrfu7th8/jt/EjXBS7KtZ4k78ecz1Y/q5xP/f387G2dHX+RRcN/YkzoNX
S3c+gZ/WR/isOFu8K86N8+MSeIsMir8lnnm8u3FuYqfGHsRlcVWcAS+Qdrxf
7NHYz3yK3sUb4iQ4Od4gf8tkszpmrfH4OB/SxSyXWb74bLGL452WBuaJ2OHx
XkiV2LNxTqW+a//GM4odK+PkiHQ2yxnnEC+IdyJ2sVkZs8o4PZ4vbXnf2DN4
Mn4N18P/JLn5Tyaq6F0yKnZaPCd9Js62vhb7R0/itXVLfiteJd34WH4Yz8SH
42zqTjyHzsOvxm7BxWM3y0A8P/ZRnGl8Du+JHc1L60qxf/DG2G96nrTBfcx3
Sl1+Q/4D9Bd4ag==
                    "]]}]}, {}, {
                   EdgeForm[], 
                   Directive[
                    Opacity[0.05], 
                    Hue[0.67, 0.6, 0.6]], 
                   GraphicsGroupBox[{
                    PolygonBox[CompressedData["
1:eJwl1nfcVnMcxvG78bT30iYVbTLae+89VTRQifZSaUgTUbRRKqloKomoRFFU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                    "]]}]}, {}, {}, {}, {}, {}, {}}, {{}, {}, {
                   Hue[0.67, 0.6, 0.6], 
                   Directive[
                    RGBColor[0.24720000000000014`, 0.24, 0.6]], 
                   LineBox[CompressedData["
1:eJwl1nfYiFUcxvFXJNolJBUqKg07JaMiiowQIjM7hRKRrUJlJKLSsBLtEhoo
bRpWQ3soEdp7fu6rP2739/t7XK/nPc8551Khx8DWVxQqKCjYs1dBQfpvf5wt
K3FPaWV+K99fHsB7dE3zU/Ag/IL+ms/W7/OZ+DL8MD5BnsC/6LLmpXBHvEZv
5FPTfBTugufhI6Q5b8DH43X6D75Af8W/1ffx4fpZfprAgn/0OfIUnmDwMu6F
L8Qz8QFSi5/KB+MdeJYcKaXNOpltwqOlhRSWf80aytO4t5wmR0kRyT/ayLNn
YB+pLUfL4eaXmG/GY6SlnGU2wexPvFj2lkJm55o9i6/Dr+CPdV/eWs/iB8rp
vAq/Eu/Ec/AH+Gt9Gx+gH+EnSjlehnfGW/A0vAl/rsfyrnp+voW04mfz6/Bf
eCHejr/T9/MRehV/X9fWRfMr48Z4Fb4ev4r74TZ5F7xBH6Qf1N/qMzyriq/C
3+Db8Yd4Nr4cP4rf0ZX1Mv2rLu/ZEbgLfhuPyzeUc8yuN/sbL5F98o3Mmpit
xv2ljlSQsuZd87Px+KynNDS7wewfvFSu5auzvlIs35Sfl72Z/Stt+Wx+sDyE
v9NnmlfDQ/CLehe/Q3/E5+Ar8GP4JHkS/6aPyR7D3fBz+l0+XW/mE3A3vAAf
KY/iH3Ub80Z4Il6v/+WLcs5yBvFIvCbrK8Wzn/j52af6OX6Dfo1/ogfwi/Qc
fojU5dX51fglvZvfqT/OmdC384H6cX6yHJs9z7vj9/AteAv+InuHd9cL+VHS
lp/LJ+UiyT5Q+0pRs6b8+Xx3qSfH5byY9zDfmv2U95T98m3Nm5mvzZpKfalh
NtRsT9ZcBvEn+CmyHP+uf9YVPSunL83ezVpID76IHy3teGM+Gb+eOy/f12x/
KcYvyJnWL/CJeh0fiNtlbfCh0oDX5MPwy9nrfK7+JGdU38kH62X8VKnEy/Oe
+AM8A7+Nt+Ub80tzp+XM6nK6vVkTfGPuNrkP79APm4/KN87P0XVy3+m/cr95
Vhw3z97Ek/B6PAi3x3fgjbpEfo7+Xp/lWS18Tc49vgt/iufiK/GT+F1dRa/I
PayPzxnDvfCH+XekJ1+c86rL68f0T7qDZ+fhm3BheYQfmD1h1iL7L+uUe0hO
kGPMe5t/hCfLxXJQ9oR5y6x13it3Qe5is+Fm3+e95UQ51qxP7lF8o/TKXcYr
SEd+Pr8Zv6GL6MV6Z35G7iLPR+vnc85z7rMneKvc0bmf8076df5p7jTeId+a
HyYNeW0+Ar+if+B3689y9+m7+VV6Oa8qlXMGeN+cU3wrfgd/mfXivfWS3B/S
iTflU/Decj/+Rv+Q+8azMXptvoeum3NudgC+EL+atcBv4CFZUzwXb9Il803y
rrqRZ6fja/GP+B45SSqa9cvvjG+WS+TQfEfz1uav4atz7uUMs5FmP+F75WSp
ZNbf7DM8RfrwpblXpDNvxqfiN3VR/bjZ2Jw/XE9KZA/wNnhVziO/Sb/Jh+KO
+C5cShrzOnxUfm/9c34P/TnfpefxIXoFr5a7gx/PL8vdlL/HZ+aO5l/lvXhf
/QA/TrrwC/g0vI8swbuyXrmLPBunX8z+1fWzL8wOxm3x+qwffgsPw52yJ/Bm
XVo3MTsTj8a/ZP3wF3h+1hevzP2rq+dOyXnBA3IP42nSVUrKIeYX5W7D1+T8
SRUple/mWbvsfzw850Gq5uyYX577CE+XbtLcbLpZMVnGS0sJs/b5VnhE9gK/
hx8uTXldPiZ7Qv/K5+ltfLdewIfqp3iNrD+vzPOfz7X6Sz5Lv8e361t4P/0g
ryjdeYvM8Vu6uF6qd2e/5a7yfLx+Kfdz3okfxjvg1Vn37D+9IXsx+5x31vfy
MtKM1+Nj8W94ft6p0P//L17Ih+mn+VZdU1fP+cADs1fwbXgrnoH744dwpezn
7EPdw7wlnoH3leW8TL6Z2cV8Ax6Z/SX1zcaZ/Y4X5TvyZ3gtWYn/zB7RNXLG
9H+6xHgr
                    "]]}, {
                   Hue[0.9060679774997897, 0.6, 0.6], 
                   Directive[
                    RGBColor[0.24720000000000014`, 0.24, 0.6], 
                    Dashing[{0, Small}]], 
                   LineBox[CompressedData["
1:eJwl1XccjfUbxvFjr8y0JFmhLRooZEUKEUpTIUqhkEppokFSycwMGVFWu2hv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                    "]]}}}], {GridLines -> Dynamic[
                  Join[{{{3605299200, 
                    GrayLevel[0.9]}, {3607891200, 
                    GrayLevel[0.9]}, {3610569600, 
                    GrayLevel[0.9]}, {3613161600, 
                    GrayLevel[0.9]}, {3615840000, 
                    GrayLevel[0.9]}, {3618518400, 
                    GrayLevel[0.9]}}, {210, 220, 230, 240, 250, 260}}, 
                   Replace[
                    MousePosition[{"Graphics", Graphics}, None], {
                    None -> {{}, {}}, {
                    Pattern[CalculateUtilities`GraphicsUtilities`Private`x$, 
                    Blank[]], 
                    Pattern[CalculateUtilities`GraphicsUtilities`Private`y$, 
                    Blank[]]} :> {{{
                    CalculateUtilities`GraphicsUtilities`Private`x$, 
                    GrayLevel[0.7]}}, {{
                    CalculateUtilities`GraphicsUtilities`Private`y$, 
                    GrayLevel[0.7]}}}}], 2]], Epilog -> {{
                   Directive[
                    AbsoluteThickness[0.5], 
                    RGBColor[1, 0, 0]], 
                   
                   LineBox[{{3611188800, 212.72879241512837`}, {
                    3611188800, 257.21097084166985`}}], {
                    CapForm[None], {
                    GrayLevel[1], 
                    PolygonBox[{
                    Offset[{-4.6, -4.25}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{-4.6, -0.34999999999999987`}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{4.6, 4.25}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{4.6, 0.34999999999999987`}, 
                    Scaled[{0, 0.08}]]}]}, {
                    AbsoluteThickness[1], 
                    GrayLevel[0], 
                    LineBox[{{
                    Offset[{-4.6, -4.25}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{4.6, 0.34999999999999987`}, 
                    Scaled[{0, 0.08}]]}, {
                    Offset[{-4.6, -0.34999999999999987`}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{4.6, 4.25}, 
                    Scaled[{0, 0.08}]]}}]}}}, 
                  DynamicBox[
                   Typeset`ToBoxes[
                    
                    DynamicModule[{
                    CalculateUtilities`GraphicsUtilities`Private`pt = (
                    NearestFunction[1, {1541, 1}, 3, CompressedData["
1:eJwl2nc41t//B3AjQshKdjbZO1lRZIayV0kI2clKSkZKJDIiq0QhK0miRCER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                    "], CompressedData["
1:eJwl2nc8l9/7B3AjQshKdjbZO1lRZIayV0kI2clKSkZKJDIiq0QhK0miRCER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                    "], CompressedData["
1:eJwk3Hc41e0fB3CzJCSRrUhkb9luJYREESJpKON7zskIqRRRZJZIFCmRURpW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                    "], Automatic, 
                    Hold[
                    Nearest[CompressedData["
1:eJwl2nc8l9/7B3AjQshKdjbZO1lRZIayV0kI2clKSkZKJDIiq0QhK0miRCER
4SNlZCWUmZXE73V/f389/3h7nPO6rnOPc+4HPiefEy6kJCQkFJQkJHPaNCPz
/TNaueFjKkvwRE1tyjKsFj9n+AdeZmqvJvsyoyVnlM9IASeiwzx3Qr0/Evy0
cEOO4hI9LPEc+swAGUbi4/fARnbXqb0wwEzjCAcUjmfN5oL9zXPrPPAGSYsZ
H1RTySkVgLlPTJxF4YkfIq/F4A4+Eg5J6HanvFMWcnyMFVOA7TtPRytB2YuM
qqpEnqrpFHWYOvdm4RCRSzTD8DCR67R/gTaRK9OAVBee/I/fXp/IpdfDaEzk
ulrsaUrkqotsOUHkkVa4ZEXMz5oy5UjMb+p15Aysvq6T7ULkaOL+c5bI8W/F
zIPIofSx1BOG+xZQ+0CZonBnPzg+bvn6PJGHW5ojkMhjtfNCMJGj7bnYJWLe
CrbUGJgkUSBwHZYVylfEwZks4/ZESMU+aJMMhe64/0iBjjeiyDKJeSiYErNg
5pUc7lzYF1ir/BAanlnwLiPyDV/arIAxNrtuVMEGE+GHL6CSmv1AE+Tf06rb
DzUTLf77Ch12jTsNwXTSrUtjkG5OvuoXXG/O4SX9OqPVGRz0Zz+kf/DMTgIa
d/yul4If+XyvysP2Nrdd6rCVy5bbFDY2qGkFwmoqsuuNMKZe99tbaOEfr9gC
lwfYxj5AuTJp1f9gqYXD7A9YcL/mON3AjFag1VbhbqhDq73FCCcudBaxQn79
SXJemD3PXC0HvfNtaBWhuk2O0wE42Ci2Ww1ypGq56cA0NR8Oa9gt5/HAFtLu
d5FwgFf32Gk4wfpdli3OcJ30uOlZKL9u+MWdGHfuqJMnfDyh9dObmP+rWoAf
tGmRiwmE2rk8RVfg5VR2+UhYe5OlLhrKhNB8vAHP+VBYxcMCF5KRW3DE7q9b
EuQ8sbp4B1rqLYamwUSNX+QZkFJ8bE8OXCL/ePAxlNxobSyGbgtNhqVwePCF
w1PI3lM1+Qyavy/zqYEJr4vWa+H7Zw8j6uGOklyaBqhxPzO5EVYl3H7YAnPP
Xnr/CQ44BJ/ohazm5wf64E1N99kB2KLkHDgMySRPbY9ANQHb2HEYxG7BOAkr
d5tmTMFfFIYCP6HIpk7JLHRa0lRcgMYfJGw2YLFvf/UmpGKNYtmGjY4DneSD
M1r7KK9JUsKwYrk4Kqi0ev0oHUzOVMzfDRc0R0mZ4LHJm6dYYFGccj0r3Ck7
wcEOnftuBXMS4/D9kOclxmlOus0Pv57TmBeEd6pTivbDRTstKgloTDrrIgWp
jLT55KHL4ny4ImxMzRw8QIyjpquiQowzupSmBr/EZK9oELkkDMy0iDyBefRH
iTxcxzz1iDxv1t8bEDloTaNNYH/e1l9r2NBuN30Ocvvv1PWGoXuf5vtCBSca
xwvw0VpNXzi8zc/69ja0pQ4yvwP5Fz5PpMLK+rsU92CvNbduAdx7S7CtFmb9
lesah65jyY6TUOr98sIUfJVazTgHR2RVzNahgJtWH+0Q1sX4vutuWKVIvsYI
tcnf7d0LXbP1bPigVPTjaQG4do4mVBjGHmzPEIePe00GFSHZ0RpHZWj7nPe7
CqTJWJw9BD1PJW/rw7ddfyONINdhZyoT2CGoyGgOhVOzUixh+E5KDhtinpk+
/pMwxu5QoSMcbi8UPwOVNBjKXeCtsmAFNzjFO1rjATWT9NW94EIAx1F/qDd5
tS0A5lr9NA6Cx1XqrMJgUbHgYDiRkzveMQJWbju4xxA5/ZpnY6HTmJR/HKw1
S1uNh8zvtkMTifxKbttJRP7CrsgUGHAj72YGbP9LzZgFBb38U3LgfyZHsvOJ
/G+K+QuJ/HIshY+J3Hu+l5XChJhjChVwcu1ZzVOo4c6jXg3Tvsa8qSHyG87r
vCTy11u11cP1HNGeRmjKeNvqHdHnq38GWoj+urRNtMOXYp6rfcT4htEmX2D5
uexHA1Ds5nPSYZhf0mU7Ank6pp+OwbuzZHTfIQs9l+sPIo+U4utpSGVizPYL
Rvqc9ZuDweV3BX4T/ZDburYJB0/sHd2CVudlVEiH8RxM1k8mh0ZVTr8oYHPv
RR0qqLVyJ5sG1u0pXaOFSkotprthueXIY0YoHvSHjAXy1og/Y4M0Kons/DDK
9rG/INwObfwgDJdfLl8Sh96DdJ8l4fSmsIwMdObWvC4Hh9VtxhSg9Ul/1QOw
JzzuzkHY+rr+qAas1OIv1oUSTqo7DGDhVXMHI3ivKWb3cRij8/O8LbTRr1Lz
ghrFV1t9oCDdcXN/uNA1ey4IxlqLZEbA6rMZf1Igc8yV6ldw/Yfx4TdEDn3u
j02wiK72eys8nPKbpQf65rue/wE7Go1kGL7huuj5kMgEhyYMFlngLKV+JTuk
M9RREIDHetSVlaDFRF26MnRYUf2jAr32qtQegvF2Smr6MMXz2T1DmHVJ4d8x
+CRH7tUJ+Ky8gscC1r+RuWwF33WXfbOBHeNSmvbE/MtPck8S81NIkp4m5hcR
b3Qh5vcU0faBey4V5PtB7gQhigAoWS7QHEzkWt6nd5XIRZHzKIrIxcpDfQ26
iGS5XyfyKXO1xRH5wtiMUoj5djCaPoLOuWn5RXBTledPCbzzOf9YGZQ4L36/
Ar6lr1x9Cu2LlA2r4c1RneVaKHipXa8e1rGZZb2Gv0wcj76FRq9C0zvghA3p
bCcMW7mm1Q1ZbtOn9sISiZSZPqjdynnoCxw8cz95AAZsi04NwV2ZZWoj8L6S
0u0xqNJd930CelC3JUzDtqCJkSXoxHxOcQVulC5eX4Nik1tym7AxIvraFrTl
ph0kGcH7tSZJhhxeN2ePpoC8CzlfdsKaOGEpGmgq8uQqLZxqlP9MD/Vkjfez
wZH23kscMNjNrpsLPspxu8gHNVXnOwVgf98FQWFIRR/ZIQZzH1PzS0JlncRA
adg1wvpBFrqFZe1TgCRsggFKMP1pUasybJl57qcO21p+rx+CH/OlrxyGvScL
E3ThZ9XxPQbwK9u+LCMiT3dq8XE4XtYtZw4nb9LXWsIZdwMtGzh7NKbVDi4I
NJqchMskW32OcKP2wncX+C+twtONyHFh9rcH3CntQuYLaWjzrvtD+ulBhguQ
5YH5vlC490piQRjkcGiXvAx5VKieRUC+vdpqUVBw+XJTDBT99NLgOpSKk7dJ
gLJuPiOJUEGn+GwyVN3mD0wn+nqeKfk+NDQ15ngIjSVv5BXCEzTNokXQ4gdp
eQm0fqt+oAza54W8qoBOdovt1dBFWdL8BdHPPe4DL6FP58h0Aww70kX5AaaK
l2l+g3XPM++NwtEjsevjUML+dPkUbLzJzLtE9Gk2aHvHKK6/cs1XYtBDTZJD
Et5qZQ+Uhl9HliQVoA/jwyx1mOFPfckULip0qwbCq2QBbcGQqWuPzUWocM4m
8AoMzhspvwG36OaFcojxBhKr8iDvY7kj+VBLO9DxMYwK/ZfxFNL82MXQCjOr
nmS3QYmrJpId8Bh3skE3TDTjiB6EfHx1zN9g5ZzD/VHYcz3v9SRkbRDdWICF
8W2xv6GynefeVdgqSl+wDm1WyxT+wpmm403/YOjt38dJxnB/nUoZIYP3JA74
UIwR+87+fzvhq5bQmzTwm9Orx7sh/12dCXZ4eHHOlQue0U+f5oFReVqefDD/
z8ycAHx3/I6fMJx8rL4sCinJfgSKQxHbxD+SUK/yYJgMdKMZ35KDRbWKO5Sh
BOcA/WF47HzUbW3o/UGSRRcmCHxO1YdlF6+wG8Gunv33jOGCeA/PccgYFZZn
BuUGhQQt4QmFzgJreP5m8H47WKX2QcoRHsjyPegBrVfY6zxh8LEmDR9Y+2+P
dgD8avG6ORD+feKmHwK5KJnaL0K1ky+Nw6FDtfOnKzCcnt48Er5+5WgTS/Rj
H6VzEnQKKpu8AyM7rd3T4NvLxd734PfP5ovZRB9kts7nQeHYwtUHUHfENKSA
6IPyxt9HMDbxQXgxfDxlRFoK2zRXI8uhUV5mQi289Wjlex3sLjNRf03U8Yr8
VxPMfOdwpHmM2Gc9z2gl1mXgnH4HLBh7l9sJp6b3rX+C4oshJr1EX9d7Cvpg
xbbkVj9cpoy1GIChe9R2jMB6rlS7MUgiuFA5MUbsg/JPT8PbJrSvl+Cj64Mh
FOMzWj8TlT7thFLpiaI0sKpA+zM9fN1UosAG+/6FzYtBcn9uF1NYWSsxfwI6
kquFWMC6O7bxtjDgedozZzi5yUgZAu/o8CVehIcTZDjCYc4+E6lIaH34pmU8
fH+NsjAPBnftkc2HwuxCLwvg1aIjncVQpePK2jM4tScxogamnszZ9RL+nq/f
1wBLmP7qtkFbO5rudkiVz27fCat/iU5+gi6Kyr69kMf6QvowbM+N4h+FodPJ
JeNEXaGVDVPwVtb81BJRT0qZ7gqUifcpWIMk0dIUG7ArbP7MJswNKGvcgn6e
PnykE3hO2M8PU8AxszJ1KvjU0OceDTRXnbfZDVM45nvZoCtTmTwnVKLxSeKe
IO4j6cV9sO/PnAk/LFgsLRWEQdPedCJQb1TKcz9k+zLXJg6nukr3S8EXrd6x
MtC2Zk5HEWamzTVoQM9bpfu0oNo17/AjkPay1JAOHAycU9WDJd6lGQbwkqv3
HyNofFLK2gTyWM5VH4dzx0r3mMPXOt4BltBRcU7WDuaxzJU4Q3/a0l1n4eEd
3h7uRL2/Z0W8YeXPJzG+MHLc67s/UfeApPYFKNgzez8ILrc9IQ2F7xq9HMNg
aq3k63CiH5Wz3BGw8PZs+g1ivDYnsXgiz47+l7eIvwtsHL4zQdwfB3zTIN10
CWkGjLJLE8yBDXdoq/PgZkeEbj5U3rnWXwDPa3p6PIZOQlrlT2H2yWqtavg1
TbynBh6nYV2thzePxF1rgK1hJOxNUHN+RrUVhok6drTBmtP/newg8mcYLHRC
6d7XEd1Evhd3WgaJ/i9R23wjcopfnhkl8mW70/0g8lzVMFsk5jOaGqb4jvUf
UV2Vgo75NRdloYSbIqkCfDsvRXsQLm3x8R+BxtxUxlaQyrb34WUY1uNp0QU9
jmaUdUPrFy3U/0H5HP5XX+CMR7/wOLQh015fgUqynJmck+h7vt4KN2TaG2jC
C2c3u8iFYH5rjKcUZHZcUteCJD370o/AOZ1jSzqwTfxRgQG8uuaw2xwuJLwf
cYX6R0q83OH9tYSNc9Dc0ZzFD76Q/aZ7kZhn8k3vJeiZkX/6CuQh97gYTYzT
u1x6Cw7EflZNggrqta13YPziPYs0OPnw8thdeMjWyeceTKfX2cyGS40i1/Og
YRANaz6RW3z2fgHc+tYp/RiW66Xol0IWDt5LNdDrIxnNS9h89XtqPdx3oFWg
AQb/LCpvhJ9y4tXfQTFz37YWGEVlZtUGh+oUJ9qhkh+bXydMFPr779Mk8Zxq
2PsZFpwyNByF28xS/ePQupXBZRJWhv1enIK7ZPvCf0Ln7zW75uCru5npC3Cv
cbjQb+hLdrpyBb6vPnJoHfKfE27fgL09P79vw4MPA9lpfuA5S0VzkRbKeGYN
0sPiThkNRigs/zaHGd5PtSJlhdwbM05sMN0h/C0HZHnDKMwNbwk+vLYP0sQq
T/NBUpNTJcJwbrBETgZ6aGrekYPfH/SsKMBBj42ag9DqYzyHGuyW5QvTgMYp
VUOa8P267qEjUNt+IFcHNrz2JtODqgJkzgawOiblnRHMZxk3tIT7ggOfWMOM
AerddvD2fZnuU5CW8q28E4x1t0pxhuEy4dbucCOZsfYcvLCWz+kNPV99GPaH
P/hOaV6ATtFLeUHQxojdJQz2lpU0h0NTZk3RCHj0q+vPaKjgVuV3C9JHmYTf
h+z+Mz35UNAxen8hkVftZW8xdFsWFn8GG523PrfAjhN3Jdtgv6ZCZDuc5/KQ
+gS5/vsv6isUafL9OgjlKnbJfIP68VoD49D84qDMJHR0D4qZguesmAZnYKDO
E9lZ+C9odHEOkgX/vxHyetfm4U2+8cFFYt12h8stwwf/2GJXYenPp0PrsPaL
sfxf2PUsangbDjzYp0A2hfvjdu31HfCf14ICNRQTto9jgoosayMsUJMsSWkv
tBpuGeWEUanyykJwiHLX9wPQXMnOSwW2uRSvqMGat4aUh2HS1ZsiRpCqcrDM
GF4elVA+Dj01O/Qs4dEtOg9HWCd5cskJyjuUhrrAoptbZG6Qt844zgOm/sxm
9oJ0nPOZPnAj5FZJAPR9/E0hCP7ol64Pgb0HujrCYdkKw3wsFBY6HRQH75lX
bMdD5ijS2ER44+lxhmRIMp6XngKDmJZ40+Gc1uHHGdDZL0k2C37NHXuRA493
yR2+DzWke04UQrZZ5oAKmMDlvPkUUhhVRVXDsIs76F7ApSLzlJfQ7Ws+9yv4
jXrlYQO0PKgj1QTb3VKq38HD6d81WuGLFsWWNlgg3Pe5E0ZMsP75Ajma9loO
wso8tqfD0PAKO8MonDjJ4TUOL6lztn2HrFxcIlNE3RtcUTNQ7wv36C84+pxH
Yx6Gpu7LXITFZnwWq5D+o+D7bVhYIiRMNo31jROO3AH99ETVqSGNyP6MXfA+
hdgaHVSdEDNngL2N4hVM0CtPgn4PpLwieW7vNPHek2plhwfUpYW4YBenzFUe
6LYh840XZjyXuysE5VPlV0Vge4CCmRj8J6tEJw1TGQ54yEKp+QMt8tCx5GCE
MvxzQ2VYBSa5q6qqQzE9tfRDsElYfUUL2lNonNCGy+MaZUehcJ6muyF8fVmr
+dg08Z3osIApvM6pPWQOf6XoHj8JK28YH/SD1UU73p+HtW211oGwkUYk+CLs
ubFdHU2Me6NcIQMqxjHJNE0T5/w+4T0z2Fcr3SnaC0dGjktxQCqlDsV90Hqk
SXs/XFeocFKHysNx2S6wPVaf3w06yu8s8ICxsVef+MB+uZC6EBh8zfVrPKyR
0WKtht43yrxroOAEd0stvJ22EfQaemw9/dIKOduFswZgt1DKyhAx3mVy4xG4
LDeyNUHMd/eu4xwMP0srSPoTz683oWHkcIZjupfiJ/E8fhdNA+lFFYZp4duI
+0q7YegAwy1GKKN4+QcznEyYPcQK703ZpbNBqnvK+txwlGypSBim2zuS74fG
1R/txGGtezGtDPRtYneRg8LcsfUKP4l94eqeAzCpy9n7INQT62lWhVuRWvs0
YNVQWZAmPHeAp+sw1M7+LGsEXQ/+rTOG13p59I7DNhrXk5bw18Pr09aQTutJ
gB00DVq+4Qj9mdhYz8DkJ6p5LsS4eqck3GDf+NXnHnA9vOCwF2TnaOvwgfam
jBMBMPyngk8QzImx3giBY3U5DJfhDuumzAiIl6xwFHTbL6V+Hd54e7w1Dhaf
umCWANs30ocT4VxKnXsyZJAdWU6Bsu3kV9JhAJlhahZMzfLmy4XPlZNK7sMN
7y+NhZCL5t+xIqj+kPdLCbwycHa+At4PjAutgk2MZRTP4URJd+ILSKm3ylkH
RcfZC19B/XB1uTfwZlWUXjMsNXnU0wo7Zz6c/ACZ+JgvdBHXQZ0SSQ+0sLKN
+49Yv/i8vK/Euom+kxiCA01Tz7/BzZO0R8Ygz4b0xwmomWJm8wM6yQRNTMOH
rq825uBUeZLtIpT461r7m+j3rd2h67CxxvEP6S/kJFe02QENjlG/oIQJaUNs
1PDTaEXwLsgiEdNPB60DbZUZ4AgN+ToLFLT4bLUXuuUUP2eH8/LmQTxwy/7h
qgjkwrFJBTr+4bRQh/lHFqoOQfH+9ABtqEI68/sYMa7ZzSVHmLzWNR8DXdtL
jlwnfs+LTYuDYwaahxKhTHZZwl3Yrp0gWULkTjI89wl+dRV53QOfqJIz90Hz
77W1X+EDZTGaCaj5jerxKlFH1cTmOvwR22D6l6hTLnh9GzrtNDcim8W+b1A6
dwcciv6hSw3LbZsyd8Eo6Zx5OijxxTKNCYZKNE9ywheHrbx44Lr11G9eGBhN
QyoMn2VmXhOFyxUS9OLQf9iYUwZWLH/Lk4MLNH6iilCaj6zsAPQ+kKyoAp8c
E6xTg7/OPDt8CLonfjbRho8K3PqOwsm6P/b60Hma08MYPtguWTCFY3s0gsyg
42HHKGuYY71IYweHva/edoDc0cxsjtA+Mz/bCWZWKAq5wK8tzcVnofXyVI0n
TKMJPeQD+3h3NftB82OSPYEw+cwrmxDYHWIychGaFvjNXoG36sgCIuHH7uSN
6FniPCYYEQuNtp/tjINxe3QT4meJc0Q/SyLUs97gS4HXvOMepcHmKC7pDKhd
oaGWAyNbOhvzYOOQo34+1KSJtHwML/OyDBXDV0oPz5TCf0ZKM+VQ7UyL71N4
McR67RmsvTV9qQYeqNsVVw/TI45NvoYbR29pNcK6T0zrzcS4P9hdumBeiV1D
NyTzz+L8j+jrgW+Bn+G7Td7uL1C40UlyEMZey48dhtNGk+Mj0IBJ9NA4LP7s
nvEd0mYVr/wg+iAiXfILmqkrsa/CKrLggHXI2vqicwP2n1CP2YYH2S6Pks7h
fTvUoLYD2rtp/6aC9ZIxxrsgz++Wx3Rw5JKhIxN0ST7RwQm9XzkWSsErLJfs
zKERZ8C0JWTnPxdkAyulbZJPwgkDxQ9uUC9iVuUS3D3nwFEAB5fNHz2Cj/4a
KhVDTWqVE+XQX5D1Ri3ss/345yPMbtH4sgbjL02qbsAw+YTsTWiTM3SGdB73
UVDYHA28LlxLzgODB0+78kLXJOr3/FB7yzpBBG79t8YmC2fjci7Kw0Et3WFF
+OJJ6gMVGBCtKKUNnVSHEo/C44tRv/WglENvzTHIzRzGaQpp3wuEn4DTCueP
WMH+GY4CG9ic20hlD/NpmT46wpMT5dYe8FiG9UtPqGZKwuMD2etMxs9DKv81
nUC4KpLzKBj2Js95XYKN+qldl+eJ72Xq8ldh7rPvKVEw4Vz8egy8xKdodx16
fh6sj5snzr8SkYmwNXLgSxI8+vaGTApRt8700F1ivOh0hXtQq1k3Lhtq6BYo
P4B11yxuPYSqrTsmC2EtVZVaEVTWP5NcMk/83wnTTClUbHujWQHlDHnnnsHy
uE7tGijdHp5ZCyWODem9hsImGQ9aifpv6W+0QYGuddMOeJ/hUWEn5D1utfUJ
5tymtOiFPN3PivvgPSYXsi+Q04zFZgBmJDeVDUG2Xn/KEchq8enpBGSwSqCf
I/qQpu6yAOn6f71cgjQ2hu5rMPbuxus/cOfXx6ybMIbDxmsL7rCjekuygPN+
5nMOckg66OpHAa9wsbbuXCDeD+94aGBYVsAFWvh3SKCdHq6fvBrCDANzZLv2
wJVvI8JscMnxUC8X9MubE9sHF0azIvjgrNOmlDDsm3CsEYUNru+0xGHR1P4P
kvCOR4K5DAz/tTQkB928rc4qQjV/3lAVKLwcRa4OGQKnbx6CEyGVOdrwZoT2
O2MiB/lj4+PQMZqu3wwa7PQ/bQkVrvfNWEOeXaoBdpAqPuefAxxIdGM4A98y
ddx1gaV3ZAXciD6kbyh6QbHcm3ZBkIV/cSKE6MMDC+8wOCVUuxYOuwt5IiJg
3f5ImihYUPwjOQaGlJUXxEEn2T0yCdDoaciLRMj7/HB7Cmx91buYAys1D168
D+81Zu14CGO0yRIKoW+z694iaKv3IbcEardJi5VBto/ralXw7BBXbCsMoJeb
bCPW6ZCudgdMz/Mj6SbGd2kOHoCicz7uc3Bmq9GAZRH3kXT/I1ZIdnqWkn3x
f+egJm5oeM1TVQSW7GaVUIFevO50jnAiST7baZE4D2xJuUCDmSRTDyhaVZcc
QPyuy8Bxnfi99mtRHOyReKiaABsZVRySYc7AmdwsaOvzXLgSdo9GPK+C+uZG
es+h8sFR9zrISr7rSTNMuPCf+ntIMZXz8QMMs/U49REutyssdMFzh7av9MCx
iveMffBT6kn5AahHvf/tEGy4+Nt8BJY6xgZ+h8I9J3ZOwSwd7vQZeFOs8sU8
3JEVZrAEL+7WHViGSxGMnmvQY3lg8w8xvmtB/Ca0+eLLsw27DFXLSJcwzysK
zR3Q5OXnt5TQsuaxPjV0qTxmRg89y/b1M8CAkkV7Zni1IMWVDd54cPYnB7yd
e9CXG6Zn7VrZB3MzhkL4YWFa2ZbgEnH9RUSKwOrbZlRisD5BKF4Cvo1bY5Re
Is4771Nl4derXrlKcOzyIaGDcDqMsUgVrgc+e6oJt89fUz4CKf1s6nUgvbf4
YT2459y/ZgPI5dZpeAwKuuR1mUBxp/MWJ6DcKZ2v5lDFfu8pK6hlMz1uA03N
4mdPQi/d/0jcifq0C6PPwTCtEBpvGKlheMuXqFOVm+U8TFKeT78A7yq+4Q4m
6pRLvh8KH0m7iFyCZRIHSi4Tde6nlr0K3wk8UblG1LN35dhtOMPS0p0MFxnv
WqVCElr105lwJ/XuySyiHspRj9wl4rp5On8fcpNEBzyER0t2fiyEvtY3RIqI
vpXf+loKPU5naNYQ8zWW0X6AxtFf8xdgsKzD1hLMG/pmtQKXFb/TbMCMyXlf
8t/Yv+lSqLPCcBqZ/1Qh8/rZ0xrw0fecWU3Y3bCb8igUCppXMoXt46XpzvD0
p0nBs3D1FU+FO+TNSHjvDc+bem8EQ456Sft4WFbkMnULaqdnBSRB7/N08WmQ
/LQOewZMN7708B6UUHsmmwPf7J+tz4OWe4UM8uHMDoe+Asgy0j5XDN1SS/ZV
w3+RE8U1MMmPS/klfGl007QBmqq8HWyEEyKbbu8gPblnRBt8sPCAruM3ca4e
uNsJnV4YVvbCZz7i48PQk5ZFexQKPt7MHyfGHetwnYL6l6tbZiAJV47oLJHf
wndmkejHkrXhMhxM0CpZhcniYnR/oEErk/dfSOry9+M/WEM6IU2yjPtU9dni
Djj0OevETngnIOYpNSQrtbpAD18YaPYxQN8fogeY4TDvxvpemFI/ZsMBjWw/
1HJB8rWnnPtgbfK9MD7oJxM9JABFO7w0hGEq5SEScXjsgchpSbhDk6FRGvqH
jEYqwP2sbRNKcKSyUucgNP4VuVMDUlz3dNOEdUIW7w/D843qYjpQ7JRwnC4c
/Uv/Sx+mp68ZGUFTxZEnxnBndyv9cfjKu8LHDAbuyuiygBPa55JsYeao2W97
eCJczfwUbHhOx+oMg8xXA12h1OLwZzf4Pb5F+Ry8J1Z+1wuataRv+EAa5wg7
f/iGxKMuAAZnneAOgq/fHvYPgZS/5FouEv1UYfa7Ass/97y9Dte2mthvQg3h
Ku+EZeK70R22ZMh8L8orBdo2BTSmwdwZ570Z8Aejhec9Is9BnTfZMMBRkTUP
vrwmdO4BsU5lexoeQv0+ij2PYOK/FfciyGPUx1wGXc43u1XAkozq+qdQZTr1
bA20jLF6+QZmPdFleEv0pfeASzMU3xSpbSXWRYBt94f/rT+Vcwck8V+v6YQJ
Df1OvfC/H63P+yDX7he0X2CRw93qIdi8YUPzA9LxG5yahub6KlU/iX77ilHP
wbE0jpMLxHq/pnm6RFxXkxs7V+Bzup/2a3BLYaDiD9Sx/0C5CW9GvrTbghzd
mRTkK9jv+djb0MKpz6Sj9DBDs9CNEW4xLgWxwvLQtG02eGZc7RonbK26lsoL
Q7kleQSgREz3QyF424r7mRi03ajsUYC0Z6ztDsBXH/6NHYQCWXpLGrCPYi5E
C8Z6J5Nqw1+Hhhn0YfajyHTDFeL/2fbzGsNnY+elzWB4NLWxA5SZK/3vFByz
NHdwgrqiOZ5nIcMHhTi/FWLf6dgaDVsyqw+XwntPaXPKoe8Hp7+VkO0vfdVz
6GF7VugNpGdno+qFlqkhHX+gWGnn/k24/U4oZgs+WvmkQb6K85u5WDktzGYe
SNoHvyeqWeusEu/3gQ1dqGQbmmUAYwVqxkygWLW8ly3syeje7QDDLvtVnoId
emVrzjBQ0jjjLORhmlXzgC2rcd88oe+A2FUfyN7wXtAfNua7tQRAZu8C2lBY
TcKfFgVPfW84eA1StZ0avA5tkrP4bq0S3/nV3t6GRfYDrnegmVYodRrcFGIv
uQsf0tQY34PG85aL2TCn5o5SPjxsyPCmFM5Il52pgMksxpRVcGIozvAFjG8U
m3tJ1Fn4PvEVHI5zk38Dr/nu7GuCMhYFwc2w/6AO53uifvJIx4+wPWVrph9e
CM2KHyDqPaUmMwx9REMvjEM2Ona2Sdiw+Lx2Crr3WTr8hEwvV7Zn4f8BSDhK
Aw==
                    "] -> CompressedData["
1:eJwk3Hc41e0fB3CzJCSRrUhkb9luJYREESJpKON7zskIqRRRZJZIFCmRURpW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                    "]]]][
                    Part[#, 1]]& )[
                    MousePosition[{"Graphics", Graphics}, {0, 0}]], 
                    CalculateUtilities`GraphicsUtilities`Private`scaled = 
                    MousePosition[{"GraphicsScaled", Graphics}, None]}, 
                    If[
                    CalculateUtilities`GraphicsUtilities`Private`scaled === 
                    None, {}, {
                    Text[
                    Style[
                    Row[{
                    (
                    DateString[#, {
                    "DayShort", " ", "MonthNameShort", " ", "Year"}]& )[
                    Part[
                    CalculateUtilities`GraphicsUtilities`Private`pt, 1, 1]], 
                    (
                    Function[{
                    CalculateUtilities`GraphicsUtilities`Private`a, 
                    CalculateUtilities`GraphicsUtilities`Private`acc}, 
                    Quiet[
                    RawBoxes[
                    ToBoxes[
                    NumberForm[CalculateUtilities`GraphicsUtilities`Private`a, 
                    Max[1, 
                    Ceiling[
                    RealExponent[
                    CalculateUtilities`GraphicsUtilities`Private`a] + 
                    CalculateUtilities`GraphicsUtilities`Private`acc]], 
                    ExponentFunction -> (Null& ), 
                    NumberFormat -> (StringReplace[#, StringExpression[
                    Pattern[CalculateUtilities`GraphicsUtilities`Private`s, 
                    BlankSequence[]], ".", EndOfString] -> 
                    CalculateUtilities`GraphicsUtilities`Private`s]& )]]]]][#,
                     0]& )[
                    Part[
                    CalculateUtilities`GraphicsUtilities`Private`pt, 1, 2]]}, 
                    ","], 12], 
                    Part[
                    CalculateUtilities`GraphicsUtilities`Private`pt, 1], {
                    1.5 Sign[
                    Part[CalculateUtilities`GraphicsUtilities`Private`scaled, 
                    1] - 0.5], 0}, Background -> White], 
                    AbsolutePointSize[7], 
                    Point[CalculateUtilities`GraphicsUtilities`Private`pt], 
                    White, 
                    AbsolutePointSize[5], 
                    Point[CalculateUtilities`GraphicsUtilities`Private`pt]}]],
                     TraditionalForm, Graphics]]}, FrameTicks -> {{{{220., 
                    FormBox[
                    TagBox["220", #& ], TraditionalForm], {0.00625, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.25]}}, {230., 
                    FormBox[
                    TagBox["230", #& ], TraditionalForm], {0.00625, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.25]}}, {240., 
                    FormBox[
                    TagBox["240", #& ], TraditionalForm], {0.00625, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.25]}}, {250., 
                    FormBox[
                    TagBox["250", #& ], TraditionalForm], {0.00625, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.25]}}, {222., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {224., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {226., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {228., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {232., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {234., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {236., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {238., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {242., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {244., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {246., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {248., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {252., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {254., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {256., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}}, {{220., 
                    FormBox["\"\"", TraditionalForm], {0.00625, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.25]}}, {230., 
                    FormBox["\"\"", TraditionalForm], {0.00625, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.25]}}, {240., 
                    FormBox["\"\"", TraditionalForm], {0.00625, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.25]}}, {250., 
                    FormBox["\"\"", TraditionalForm], {0.00625, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.25]}}, {222., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {224., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {226., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {228., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {232., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {234., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {236., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {238., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {242., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {244., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {246., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {248., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {218., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {216., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {214., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {252., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {254., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}, {256., 
                    FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
                    GrayLevel[0.], 
                    AbsoluteThickness[0.125]}}}}, {{{3605299200, 
                    FormBox["\"Apr\"", TraditionalForm], {
                    0.020601132958329826`, 0}}, {3607891200, 
                    FormBox["\"May\"", TraditionalForm], {
                    0.020601132958329826`, 0}}, {3610569600, 
                    FormBox["\"Jun\"", TraditionalForm], {
                    0.020601132958329826`, 0}}, {3613161600, 
                    FormBox["\"Jul\"", TraditionalForm], {
                    0.020601132958329826`, 0}}, {3615840000, 
                    FormBox["\"Aug\"", TraditionalForm], {
                    0.020601132958329826`, 0}}, {3618518400, 
                    FormBox["\"Sep\"", TraditionalForm], {
                    0.020601132958329826`, 0}}, {3603830400, 
                    FormBox["\"\"", TraditionalForm], {
                    0.012360679774997897`, 0}}, {3606508800, 
                    FormBox["\"\"", TraditionalForm], {
                    0.012360679774997897`, 0}}, {3609100800, 
                    FormBox["\"\"", TraditionalForm], {
                    0.012360679774997897`, 0}}, {3611779200, 
                    FormBox["\"\"", TraditionalForm], {
                    0.012360679774997897`, 0}}, {3614371200, 
                    FormBox["\"\"", TraditionalForm], {
                    0.012360679774997897`, 0}}, {3617049600, 
                    FormBox["\"\"", TraditionalForm], {
                    0.012360679774997897`, 0}}}, {{3605299200, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.020601132958329826`, 0}}, {
                    3607891200, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.020601132958329826`, 0}}, {
                    3610569600, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.020601132958329826`, 0}}, {
                    3613161600, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.020601132958329826`, 0}}, {
                    3615840000, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.020601132958329826`, 0}}, {
                    3618518400, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.020601132958329826`, 0}}, {
                    3603830400, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.012360679774997897`, 0}}, {
                    3606508800, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.012360679774997897`, 0}}, {
                    3609100800, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.012360679774997897`, 0}}, {
                    3611779200, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.012360679774997897`, 0}}, {
                    3614371200, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.012360679774997897`, 0}}, {
                    3617049600, 
                    FormBox[
                    StyleBox["\"\"", 0, StripOnInput -> False], 
                    TraditionalForm], {0.012360679774997897`, 0}}}}}, 
                ImagePadding -> All, GridLines -> {{{3605299200, 
                    GrayLevel[0.9]}, {3607891200, 
                    GrayLevel[0.9]}, {3610569600, 
                    GrayLevel[0.9]}, {3613161600, 
                    GrayLevel[0.9]}, {3615840000, 
                    GrayLevel[0.9]}, {3618518400, 
                    GrayLevel[0.9]}}, Automatic}, Epilog -> {
                  Directive[
                   AbsoluteThickness[0.5], 
                   RGBColor[1, 0, 0]], 
                  
                  LineBox[{{3611188800, 212.72879241512837`}, {
                    3611188800, 257.21097084166985`}}], {
                   CapForm[None], {
                    GrayLevel[1], 
                    PolygonBox[{
                    Offset[{-4.6, -4.25}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{-4.6, -0.34999999999999987`}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{4.6, 4.25}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{4.6, 0.34999999999999987`}, 
                    Scaled[{0, 0.08}]]}]}, {
                    AbsoluteThickness[1], 
                    GrayLevel[0], 
                    LineBox[{{
                    Offset[{-4.6, -4.25}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{4.6, 0.34999999999999987`}, 
                    Scaled[{0, 0.08}]]}, {
                    Offset[{-4.6, -0.34999999999999987`}, 
                    Scaled[{0, 0.08}]], 
                    Offset[{4.6, 4.25}, 
                    Scaled[{0, 0.08}]]}}]}}}, PlotRangeClipping -> False, 
                PlotRangePadding -> None, AspectRatio -> 0.3, 
                AxesOrigin -> {3.604*^9, 214.}, AxesStyle -> Directive[
                  GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], 
                  FontOpacity -> 1], BaseStyle -> AbsoluteThickness[1], 
                Epilog -> {
                  Directive[
                   AbsoluteThickness[0.5], 
                   RGBColor[1, 0, 0]], 
                  
                  LineBox[{{3611188800, 212.72879241512837`}, {
                    3611188800, 257.21097084166985`}}]}, Frame -> True, 
                FrameLabel -> {None, None}, FrameStyle -> Directive[
                  GrayLevel[0, 0.35], FontColor -> GrayLevel[0.25], 
                  FontOpacity -> 1], FrameTicksStyle -> 
                Directive[FontFamily -> "Times", FontSize -> 10], 
                GridLines -> {{{3605299200, 
                    GrayLevel[0.9]}, {3607891200, 
                    GrayLevel[0.9]}, {3610569600, 
                    GrayLevel[0.9]}, {3613161600, 
                    GrayLevel[0.9]}, {3615840000, 
                    GrayLevel[0.9]}, {3618518400, 
                    GrayLevel[0.9]}}, Automatic}, GridLinesStyle -> 
                GrayLevel[0.9], ImageSize -> Full, 
                LabelStyle -> {FontFamily -> "Verdana", FontSize -> 10}, 
                Method -> {"AxesInFront" -> True}, 
                PlotRange -> {{3603398400, 3619123200}, {212.72879241512837`, 
                  257.21097084166985`}}, PlotRangeClipping -> True, 
                PlotRangePadding -> None, Prolog -> {
                  Opacity[0], 
                  TagBox[
                   RectangleBox[
                    Scaled[{0, 0}], 
                    Scaled[{1, 1}]], Annotation[#, "DatePlot", "Frame"]& ]}, 
                TicksStyle -> 
                Directive[FontFamily -> "Times", FontSize -> 10]}], 
              TagBox[
               GridBox[{{
                  TagBox[
                   GridBox[{{
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    FormBox[
                    TagBox[
                    FormBox[
                    TemplateBox[{"\"from \"", 
                    FormBox[
                    TagBox["\"Mar 10, 2014\"", Identity], TraditionalForm], 
                    "\" to \"", 
                    FormBox[
                    TagBox["\"Sep 8, 2014\"", Identity], TraditionalForm]}, 
                    "RowDefault"], TraditionalForm], 
                    Format[#, TraditionalForm]& ], TraditionalForm], 
                    "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}}, 
                    GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                   "Column"], 
                  TagBox[
                   GridBox[{{
                    StyleBox[
                    RowBox[{"\"(\"", "\[NoBreak]", 
                    
                    TemplateBox[{
                    "\"in \"", "\"thousands\"", "\" of \"", "\"miles\""}, 
                    "RowDefault"], "\[NoBreak]", "\")\""}], {
                    FontFamily -> "Verdana", FontSize -> 10, 
                    GrayLevel[0.5], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0}, StripOnInput -> False]}}, 
                    GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                   "Column"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Baseline}}}, 
                AutoDelete -> False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {"Columns" -> {{0.5}}}], "Grid"]}, 
             "Labeled", DisplayFunction -> (FormBox[
               GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  
                  ItemBox[#2, Alignment -> {Left, Inherited}, 
                   DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}], TraditionalForm]& ), 
             InterpretationFunction -> (RowBox[{
                StyleBox[
                "Labeled", FontFamily -> "Bitstream Vera Sans", 
                 FontSize -> -1 + Inherited], "[", 
                RowBox[{#, ",", 
                  RowBox[{"{", #2, "}"}], ",", 
                  RowBox[{"(", "\[NoBreak]", 
                    GridBox[{{
                    StyleBox[
                    "Bottom", FontFamily -> "Bitstream Vera Sans", 
                    FontSize -> -1 + Inherited], 
                    StyleBox[
                    "Left", FontFamily -> "Bitstream Vera Sans", 
                    FontSize -> -1 + Inherited]}}, RowSpacings -> 1, 
                    ColumnSpacings -> 1, RowAlignments -> Baseline, 
                    ColumnAlignments -> Center], "\[NoBreak]", ")"}]}], 
                "]"}]& )], TraditionalForm]], "Output", {
          Background -> None}]}], 
       XMLElement[
       "dataformats", {}, {"computabledata,formatteddata,timeseriesdata"}]}], 
     XMLElement["states", {"count" -> "2"}, {
       XMLElement[
       "state", {
        "name" -> "Use Metric", "input" -> 
         "DistanceHistory:AstronomicalData__Use Metric"}, {}], 
       XMLElement[
       "statelist", {
        "count" -> "5", "value" -> "\[PlusMinus]3 months", "delimiters" -> 
         ""}, {
         XMLElement[
         "state", {
          "name" -> "\[PlusMinus]3 months", "input" -> 
           "DistanceHistory:AstronomicalData__\[PlusMinus]3 months"}, {}], 
         XMLElement[
         "state", {
          "name" -> "\[PlusMinus]6 months", "input" -> 
           "DistanceHistory:AstronomicalData__\[PlusMinus]6 months"}, {}], 
         XMLElement[
         "state", {
          "name" -> "\[PlusMinus]1 year", "input" -> 
           "DistanceHistory:AstronomicalData__\[PlusMinus]1 year"}, {}], 
         XMLElement[
         "state", {
          "name" -> "\[PlusMinus]5 years", "input" -> 
           "DistanceHistory:AstronomicalData__\[PlusMinus]5 years"}, {}], 
         XMLElement[
         "state", {
          "name" -> "\[PlusMinus]10 years", "input" -> 
           "DistanceHistory:AstronomicalData__\[PlusMinus]10 years"}, \
{}]}]}]}], Typeset`pod4$$ = XMLElement[
   "pod", {"title" -> "Unit conversions", "scanner" -> "Unit", "id" -> 
     "UnitConversion", "position" -> "400", "error" -> "false", "numsubpods" -> 
     "2"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              RowBox[{
                TagBox[
                 TagBox[
                  RowBox[{
                    TagBox["385\[ThinSpace]056", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "385056"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"km\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "  ", 
                StyleBox[
                 
                 RowBox[{
                  "\"(\"", "\[NoBreak]", "\"kilometers\"", "\[NoBreak]", 
                   "\")\""}], {
                 FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                  Smaller, 
                  GrayLevel[0.6], LinebreakAdjustments -> {1, 100, 1, 0, 100},
                   LineIndent -> 0}, StripOnInput -> False]}], "Unit", 
              SyntaxForm -> Dot], LinebreakAdjustments -> {1, 100, 1, 0, 100},
              LineIndent -> 0, ZeroWidthTimes -> False], TraditionalForm]], 
          "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              TagBox[
               TagBox[
                RowBox[{
                  TagBox[
                   RowBox[{"3.851", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "8"]}], 
                   $CellContext`TagBoxWrapper[
                   "StringBoxes" -> RowBox[{"3.851", "\[Times]", 
                    SuperscriptBox["10", "8"]}]], SyntaxForm -> CenterDot], 
                  "\[InvisibleSpace]", " ", 
                  StyleBox[
                  "\"meters\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                   LineIndent -> 0, {
                   FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
               SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
             LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 0, 
             ZeroWidthTimes -> False], TraditionalForm]], "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod5$$ = XMLElement[
   "pod", {"title" -> "Comparison as distance", "scanner" -> "Unit", "id" -> 
     "ComparisonAsDistance", "position" -> "500", "error" -> "false", 
     "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            FormBox[
             
             TemplateBox[{
              "\" \[TildeTilde] \"", 
               "1.00017081986198578379799203020065608125`4.767535813146223", 
               "\" \"", 
               StyleBox["\"\[Times]\"", 
                GrayLevel[0.3], FontSize -> 10.219999999999999`, StripOnInput -> 
                False], "\"\[MediumSpace]\"", 
               StyleBox[
               "\"mean Moon\[Hyphen]Earth distance\"", FontFamily -> 
                "Helvetica", FontSize -> Smaller, StripOnInput -> False], 
               "\" \"", 
               StyleBox[
                RowBox[{"\"(\"", "\[NoBreak]", 
                  TemplateBox[{"\"\[MediumSpace]\"", 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox[
                    RowBox[{"3.85", 
                    StyleBox["\[Times]", 
                    GrayLevel[0.5]], 
                    SuperscriptBox["10", "8"]}], 
                    $CellContext`TagBoxWrapper[
                    "StringBoxes" -> RowBox[{"3.85", "\[Times]", 
                    SuperscriptBox["10", "8"]}]], SyntaxForm -> CenterDot], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"m\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], "\"\[MediumSpace]\""}, 
                   "RowDefault"], "\[NoBreak]", "\")\""}], {
                FontFamily -> "Verdana", FontSize -> 10, 
                 GrayLevel[0.5], LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                 LineIndent -> 0}, StripOnInput -> False]}, "RowDefault"], 
             TraditionalForm], TraditionalForm]], "Output", {}]}], 
       XMLElement["dataformats", {}, {"plaintext"}]}]}], Typeset`pod6$$ = 
   XMLElement[
   "pod", {"title" -> "Corresponding quantities", "scanner" -> "Unit", "id" -> 
     "CorrespondingQuantity", "position" -> "600", "error" -> "false", 
     "numsubpods" -> "2"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Light travel time ", 
                    Cell[
                    BoxData[
                    FormBox["t", TraditionalForm]]], " in vacuum from ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{"t", "\[LongEqual]", 
                    
                    RowBox[{"x", "\[InvisibleSpace]", "\"/\"", 
                    "\[InvisibleSpace]", "c"}]}], 
                    PolynomialForm[#, TraditionalOrder -> False]& ]}, 
                    "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  Row[{"Light travel time ", 
                    $CellContext`CalculateSymbol["t"], " in vacuum from ", 
                    $CellContext`InlineForm["t \[LongEqual] x/c"], ":"}]]]}, {
                TagBox[
                 GridBox[{{
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1.3", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.3"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"seconds\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                 "Grid"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {"ColumnsIndexed" -> {1 -> 0}}], "Column"], 
            TraditionalForm]], "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> False, "string" -> True}, {
         Cell[
          BoxData[
           FormBox[
            TagBox[
             GridBox[{{
                InterpretationBox[
                 Cell[
                  TextData[{"Light travel time ", 
                    Cell[
                    BoxData[
                    FormBox["t", TraditionalForm]]], " in an optical fiber ", 
                    Cell[
                    BoxData[
                    FormBox[
                    FormBox[
                    TemplateBox[{
                    TagBox[
                    RowBox[{"t", "\[LongEqual]", 
                    RowBox[{
                    RowBox[{"1.48`", "\[InvisibleSpace]", "x"}], 
                    "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                    "c"}]}], PolynomialForm[#, TraditionalOrder -> False]& ]},
                     "RowDefault"], TraditionalForm], TraditionalForm]]], 
                    ":"}]], 
                 TextCell[
                  Row[{"Light travel time ", 
                    $CellContext`CalculateSymbol["t"], 
                    " in an optical fiber ", 
                    $CellContext`InlineForm["t \[LongEqual] 1.48x/c"], 
                    ":"}]]]}, {
                TagBox[
                 GridBox[{{
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {10, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[10]], 
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["1.9", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "1.9"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"seconds\"", 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> 
                  False, GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                 "Grid"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
              DefaultBaseStyle -> "Column", 
              GridBoxItemSize -> {"ColumnsIndexed" -> {1 -> 0}}], "Column"], 
            TraditionalForm]], "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}]}]\
, Typeset`pod7$$ = XMLElement[
   "pod", {"title" -> "Orbital properties", "scanner" -> "Data", "id" -> 
     "BasicPlanetOrbitalProperties:AstronomicalData", "position" -> "700", 
     "error" -> "false", "numsubpods" -> "1"}, {
     XMLElement["subpod", {"title" -> ""}, {
       XMLElement["cell", {"compressed" -> True, "string" -> False}, {
         Cell[
          BoxData[
           FormBox[
            StyleBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  PaneBox[
                  "\"current distance from Earth\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["239\[ThinSpace]262", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "239262"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"mi\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["60.37", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "60.37"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    SubscriptBox[
                    StyleBox["\"a\"", Italic, StripOnInput -> False], 
                    "\"\[Earth]\""], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   BaselinePosition -> 1, DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                   TagBox["\"average distance from Earth\"", Identity], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["239\[ThinSpace]200", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "239200"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"mi\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["60.36", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "60.36"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    SubscriptBox[
                    StyleBox["\"a\"", Italic, StripOnInput -> False], 
                    "\"\[Earth]\""], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   BaselinePosition -> 1, DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                  "\"largest distance from orbit center\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["252\[ThinSpace]100", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "252100"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"mi\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["63.61", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "63.61"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    SubscriptBox[
                    StyleBox["\"a\"", Italic, StripOnInput -> False], 
                    "\"\[Earth]\""], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   BaselinePosition -> 1, DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                  "\"nearest distance from orbit center\"", 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["225\[ThinSpace]600", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "225600"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    "\"mi\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}, {
                    StyleBox[
                    TagBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["56.93", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "56.93"]], 
                    "\[NoBreak]", 
                    StyleBox[
                    RowBox[{}], FontFamily -> "Helvetica", FontSize -> 
                    Smaller], "\[InvisibleSpace]", "\[ThickSpace]", 
                    "\[InvisibleSpace]", 
                    StyleBox[
                    SubscriptBox[
                    StyleBox["\"a\"", Italic, StripOnInput -> False], 
                    "\"\[Earth]\""], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], #& , SyntaxForm -> Dot], "Unit", 
                    SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False]}}, 
                   GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                   BaselinePosition -> 1, DefaultBaseStyle -> "Column", 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                  "Column"]}, {
                 TagBox[
                  PaneBox[
                   TagBox["\"orbital period\"", Identity], 
                   BaseStyle -> {{
                    BaselinePosition -> Baseline, FontColor -> 
                    GrayLevel[0.3]}, LineSpacing -> {0.9, 0, 1.5}, 
                    LinebreakAdjustments -> {1, 10, 10000, 0, 100}, 
                    TextAlignment -> Left}, BaselinePosition -> Baseline], 
                  $CellContext`TagBoxWrapper["Label"]], 
                 StyleBox[
                  TagBox[
                   TagBox[
                    TagBox[
                    RowBox[{
                    TagBox["27.322", 
                    $CellContext`TagBoxWrapper["StringBoxes" -> "27.322"]], 
                    "\[InvisibleSpace]", " ", 
                    StyleBox[
                    "\"days\"", LinebreakAdjustments -> {1, 100, 1, 0, 100}, 
                    LineIndent -> 0, {
                    FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, StripOnInput -> False]}], Identity], #& , 
                    SyntaxForm -> Dot], "Unit", SyntaxForm -> Dot], 
                  LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                  0, ZeroWidthTimes -> False]}}, 
               GridBoxAlignment -> {
                "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
               AutoDelete -> False, 
               GridBoxBackground -> {"Columns" -> {None, None}}, 
               GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1.5}, 2}, "Rows" -> {{1}}}, 
               FrameStyle -> GrayLevel[0.84], BaselinePosition -> Automatic, 
               AllowScriptLevelChange -> False], "Grid"], 
             LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
             False], TraditionalForm]], "Output", {}]}], 
       XMLElement[
       "dataformats", {}, {
        "plaintext,computabledata,formatteddata,numberdata,quantitydata"}]}], 
     XMLElement["states", {"count" -> "2"}, {
       XMLElement[
       "state", {
        "name" -> "Show metric", "input" -> 
         "BasicPlanetOrbitalProperties:AstronomicalData__Show metric"}, {}], 
       XMLElement[
       "state", {
        "name" -> "More", "input" -> 
         "BasicPlanetOrbitalProperties:AstronomicalData__More"}, {}]}], 
     XMLElement["infos", {"count" -> "1"}, {
       XMLElement["info", {}, {
         XMLElement["units", {"count" -> "2"}, {
           XMLElement[
           "unit", {
            "short" -> "a_\[Earth]", "long" -> 
             "equatorial radii of Earth"}, {}], 
           XMLElement["unit", {"short" -> "mi", "long" -> "miles"}, {}], 
           XMLElement["cell", {"compressed" -> False, "string" -> True}, {
             Cell[
              BoxData[
               FormBox[
                StyleBox[
                 TagBox[
                  GridBox[{{
                    StyleBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    SubscriptBox[
                    StyleBox["\"a\"", Italic, StripOnInput -> False], 
                    "\"\[Earth]\""], FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], "UnitOnly", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"equatorial radii of Earth\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}, {
                    StyleBox[
                    StyleBox[
                    TagBox[
                    TagBox[
                    RowBox[{
                    StyleBox[
                    "\"mi\"", FontFamily -> "Helvetica", FontSize -> 
                    Smaller]}], Identity], "UnitOnly", SyntaxForm -> Dot], 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, ZeroWidthTimes -> False], 10, StripOnInput -> False], 
                    StyleBox[
                    "\"miles\"", FontSize -> 10, 
                    LinebreakAdjustments -> {1, 100, 1, 0, 100}, LineIndent -> 
                    0, {FontFamily :> $CellContext`$UnitFontFamily, FontSize -> 
                    Smaller}, 
                    GrayLevel[0.6], StripOnInput -> False]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Left, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxBackground -> {"Columns" -> {{None}}}, 
                   GridBoxFrame -> {
                    "Columns" -> {{True}}, "Rows" -> {{True}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{1.5}}, "Rows" -> {{0.5}}}, FrameStyle -> 
                   GrayLevel[0.84], BaselinePosition -> Automatic, 
                   AllowScriptLevelChange -> False], "Grid"], 
                 LineSpacing -> {0.9, 0, 1.5}, LineIndent -> 0, StripOnInput -> 
                 False], TraditionalForm]], "Output", {}]}]}]}]}]}], 
   Typeset`aux1$$ = {True, False, {False}, True}, Typeset`aux2$$ = {
   True, False, {False}, True}, Typeset`aux3$$ = {True, False, {False}, True},
    Typeset`aux4$$ = {True, False, {False, False}, True}, Typeset`aux5$$ = {
   True, False, {False}, True}, Typeset`aux6$$ = {
   True, False, {False, False}, True}, Typeset`aux7$$ = {
   True, False, {False}, True}, Typeset`asyncpods$$ = {}, Typeset`nonpods$$ = {
    XMLElement["sources", {"count" -> "1"}, {
      XMLElement[
      "source", {
       "url" -> 
        "http://www.wolframalpha.com/sources/\
AstronomicalDataSourceInformationNotes.html", "text" -> 
        "Astronomical data"}, {}]}]}, Typeset`initdone$$ = True, 
   Typeset`queryinfo$$ = {
   "success" -> "true", "error" -> "false", "numpods" -> "7", "datatypes" -> 
    "Astronomical", "timedout" -> "", "timedoutpods" -> "", "timing" -> 
    "2.573", "parsetiming" -> "0.486", "parsetimedout" -> "false", 
    "recalculate" -> "", "id" -> 
    "MSPa79522303fg0608bh95i00004h41i28eicg1ci5g", "host" -> 
    "http://www3.wolframalpha.com", "server" -> "20", "related" -> 
    "http://www3.wolframalpha.com/api/v2/relatedQueries.jsp?id=\
MSPa79622303fg0608bh95i000037d20g9h7ib3ec64&s=20", "version" -> "2.6"}, 
   Typeset`sessioninfo$$ = {
   "TimeZone" -> -4., 
    "Date" -> {2014, 6, 8, 23, 7, 20.2144277`9.058236384941416}, "Line" -> 3, 
    "SessionID" -> 25552092645876612485}, Typeset`showpods$$ = {1, 2, 3, 4, 5,
    6, 7}, Typeset`failedpods$$ = {}, Typeset`chosen$$ = {}, Typeset`open$$ = 
   False, Typeset`newq$$ = "How far is the Earth from the Moon?"}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`FormatAlphaResults[
      Dynamic[{
       1, {Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$, Typeset`pod6$$, Typeset`pod7$$}, {
        Typeset`aux1$$, Typeset`aux2$$, Typeset`aux3$$, Typeset`aux4$$, 
         Typeset`aux5$$, Typeset`aux6$$, Typeset`aux7$$}, Typeset`chosen$$, 
        Typeset`open$$, Typeset`elements$$, Typeset`q$$, Typeset`opts$$, 
        Typeset`nonpods$$, Typeset`queryinfo$$, Typeset`sessioninfo$$, 
        Typeset`showpods$$, Typeset`failedpods$$, Typeset`newq$$}]], 
     StandardForm],
    ImageSizeCache->{648., {478., 483.}},
    TrackedSymbols:>{Typeset`showpods$$, Typeset`failedpods$$}],
   DynamicModuleValues:>{},
   Initialization:>If[
     Not[Typeset`initdone$$], Null; WolframAlphaClient`Private`doAsyncUpdates[
       Hold[{
        Typeset`pod1$$, Typeset`pod2$$, Typeset`pod3$$, Typeset`pod4$$, 
         Typeset`pod5$$, Typeset`pod6$$, Typeset`pod7$$}], 
       Typeset`asyncpods$$, 
       Dynamic[Typeset`failedpods$$]]; Typeset`asyncpods$$ = {}; 
     Typeset`initdone$$ = True],
   SynchronousInitialization->False],
  BaseStyle->{Deployed -> True},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "Print",
 CellMargins->{{20, 10}, {Inherited, Inherited}},
 CellChangeTimes->{3.611272040233429*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Power", "[", 
     RowBox[{"x", ",", " ", "2"}], "]"}], " ", "+", " ", "y", " ", "+", " ", 
    "z"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "10"}], "}"}], " ", ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6112720578024335`*^9, 3.6112721112124887`*^9}}],

Cell[BoxData[
 Graphics3DBox[{},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 10}, {0, 10}, {0., 0.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.6112721144606743`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", "y", "+", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 Graphics3DBox[{},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 10}, {0, 10}, {0., 0.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.6112721290995116`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", "y", "+", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.05`", ",", "1.`", ",", "0.98`"}], "]"}], ",", 
      RowBox[{"Opacity", "[", "0.11`", "]"}], ",", 
      RowBox[{"AbsoluteThickness", "[", "1.555`", "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 Graphics3DBox[{},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 10}, {0, 10}, {0., 0.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.6112721409161873`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"Power", "[", 
       RowBox[{"x", ",", " ", "3"}], "]"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "10"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.611272144379386*^9, 3.61127220827404*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 74.60000000000001, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 100}}, Typeset`size$$ = {360., {106., 110.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$5214$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$5214$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Derivative[$CellContext`x$$^3], {$CellContext`x$$, 0, 10}], 
      "Specifications" :> {{$CellContext`x$$, 0, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{411., {152., 157.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.611272211487224*^9}]
}, Open  ]]
},
WindowSize->{716, 833},
WindowMargins->{{Automatic, 275}, {Automatic, 64}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 138, 3, 41, "WolframAlphaLong"],
Cell[720, 27, 194311, 3452, 971, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195068, 3484, 441, 11, 31, "Input"],
Cell[195512, 3497, 292, 10, 306, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195841, 3512, 404, 11, 55, "Input"],
Cell[196248, 3525, 292, 10, 306, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196577, 3540, 708, 18, 76, "Input"],
Cell[197288, 3560, 292, 10, 306, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197617, 3575, 472, 12, 31, "Input"],
Cell[198092, 3589, 1549, 32, 358, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

