package examples.SwingExamples where

import Java.Awt  (ActionListener)
import Java.Swing


main _ = do
    rs <- mapM Runnable.new [helloWorldGUI, buttonDemoGUI, celsiusConverterGUI]
    mapM_ invokeLater rs
    println "Hit enter to end ...."
    s <- getLine
    return ()

celsiusConverterGUI = do
    tempTextField   <- JTextField.new()
    celsiusLabel    <- JLabel.new ()
    convertButton   <- JButton.new ()
    fahrenheitLabel <- JLabel.new () 
    frame           <- JFrame.new ()
    frame.setDefaultCloseOperation JFrame.dispose_on_close
    frame.setTitle "Celsius Converter"
    celsiusLabel.setText  "Celsius"
    convertButton.setText "Convert"
    let convertButtonActionPerformed _ = do
            celsius <- tempTextField.getText
            case celsius.double of
                Left _  -> fahrenheitLabel.setText ("not a valid number: " ++ celsius)
                Right c -> fahrenheitLabel.setText (show (c*1.8 + 32.0).long ++ " Fahrenheit") 
            return ()
    ActionListener.new convertButtonActionPerformed >>= convertButton.addActionListener
    fahrenheitLabel.setText "Fahrenheit"
    contentPane <- frame.getContentPane
    layout      <- GroupLayout.new contentPane
    contentPane.setLayout layout
    -- TODO continue
    -- http://docs.oracle.com/javase/tutorial/displayCode.html?code=http://docs.oracle.com/javase/tutorial/uiswing/examples/learn/CelsiusConverterProject/src/learn/CelsiusConverterGUI.java
    frame.pack
    frame.setVisible true

helloWorldGUI = do
    frame <- JFrame.new "Hello World Frege"
    frame.setDefaultCloseOperation(JFrame.dispose_on_close)
    label <- JLabel.new "Hello World!"
    cp <- frame.getContentPane
    cp.add label
    frame.pack
    frame.setVisible true

buttonDemoGUI = do
    frame <- JFrame.new "Button Demo"
    frame.setDefaultCloseOperation(JFrame.dispose_on_close)
    newContentPane <- JPanel.new ()
    b1::JButton <- JButton.new "Disable middle button"
    b1.setVerticalTextPosition   SwingConstants.center
    b1.setHorizontalTextPosition SwingConstants.leading
    b2::JButton <- JButton.new "Middle button"
    b2.setVerticalTextPosition   SwingConstants.center
    b2.setHorizontalTextPosition SwingConstants.leading
    b3::JButton <- JButton.new "Enable middle button"
    b3.setVerticalTextPosition   SwingConstants.center
    b3.setHorizontalTextPosition SwingConstants.leading
    b3.setEnabled false
    let action1 _ = do
            b2.setEnabled false
            b1.setEnabled false
            b3.setEnabled true
        action3 _ = do
            b2.setEnabled true
            b1.setEnabled true
            b3.setEnabled false
    ActionListener.new action1  >>= b1.addActionListener
    ActionListener.new action3  >>= b3.addActionListener 
    newContentPane.add b1
    newContentPane.add b2
    newContentPane.add b3
    newContentPane.setOpaque true
    frame.setContentPane newContentPane
    frame.pack
    frame.setVisible true
