export default {
  'settings.opt_true': { message: 'on' },
  'settings.opt_false': { message: 'off' },

  'settings.nav_settings': { message: 'Settings' },
  'settings.nav_settings_general': { message: 'General' },
  'settings.nav_settings_menu': { message: 'Menu' },
  'settings.nav_settings_nav': { message: 'Navigation bar' },
  'settings.nav_settings_group': { message: 'Group page' },
  'settings.nav_settings_containers': { message: 'Containers' },
  'settings.nav_settings_panels': { message: 'Panels' },
  'settings.nav_settings_tabs': { message: 'Tabs' },
  'settings.nav_settings_new_tab_position': { message: 'Position of new tab' },
  'settings.nav_settings_pinned_tabs': { message: 'Pinned tabs' },
  'settings.nav_settings_tabs_tree': { message: 'Tabs tree' },
  'settings.nav_settings_bookmarks': { message: 'Bookmarks' },
  'settings.nav_settings_appearance': { message: 'Appearance' },
  'settings.nav_settings_snapshots': { message: 'Snapshots' },
  'settings.nav_settings_mouse': { message: 'Mouse' },
  'settings.nav_settings_keybindings': { message: 'Keybindings' },
  'settings.nav_settings_permissions': { message: 'Permissions' },
  'settings.nav_settings_storage': { message: 'Storage' },
  'settings.nav_settings_help': { message: 'Help' },

  'settings.nav_menu': { message: 'Menu editor' },
  'settings.nav_menu_tabs': { message: 'Tabs' },
  'settings.nav_menu_tabs_panel': { message: 'Tabs panel' },
  'settings.nav_menu_bookmarks': { message: 'Bookmarks' },
  'settings.nav_menu_bookmarks_panel': { message: 'Bookmarks panel' },

  'settings.nav_styles': { message: 'Styles editor' },
  'settings.nav_snapshots': { message: 'Snapshots viewer' },

  'settings.ctrl_copy': { message: 'COPY' },
  'settings.ctrl_close': { message: 'CLOSE' },

  // --- General
  'settings.general_title': { message: 'General' },
  'settings.native_scrollbars': { message: 'Use native scroll-bars' },
  'settings.state_storage': { message: 'Where to store tabs data' },
  'settings.state_storage_global': { message: 'global storage' },
  'settings.state_storage_session': { message: 'session storage' },
  'settings.state_storage_desc': {
    message: `- global storage - fast, but inaccurate in rare cases.
- session storage - more strict, but slower. (Warning: Will be removed along with Browser Session)
  Note: If you have issues with incorrectly restored tabs, try to reopen sidebar and change this option.`,
  },

  // --- Context menu
  'settings.ctx_menu_title': { message: 'Context menu' },
  'settings.autoHide_ctx_menu': { message: 'Auto hide context menu after' },
  'settings.autoHide_ctx_menu_250': { message: '0.25s' },
  'settings.autoHide_ctx_menu_500': { message: '0.5s' },
  'settings.autoHide_ctx_menu_1000': { message: '1s' },
  'settings.autoHide_ctx_menu_none': { message: 'none' },
  'settings.ctx_menu_native': { message: 'Use native context menu' },
  'settings.ctx_menu_render_inact': { message: 'Render inactive options' },
  'settings.ctx_menu_editor': { message: 'Edit context menu' },

  // --- Navigation bar
  'settings.nav_title': { message: 'Navigation bar' },
  'settings.nav_bar_layout': { message: 'Layout' },
  'settings.nav_bar_layout_horizontal': { message: 'horizontal' },
  'settings.nav_bar_layout_vertical': { message: 'vertical' },
  'settings.nav_bar_layout_hidden': { message: 'hidden' },
  'settings.nav_bar_inline': { message: 'Show navigation bar in one line' },
  'settings.hide_settings_btn': { message: 'Hide settings button' },
  'settings.hide_add_btn': { message: 'Hide "Create panel" button' },
  'settings.nav_btn_count': { message: 'Show count of tabs/bookmarks' },
  'settings.hide_empty_panels': { message: 'Hide empty panels' },
  'settings.nav_mid_click': { message: 'Middle click on panel button' },
  'settings.nav_mid_click_rm_all': { message: 'close tabs' },
  'settings.nav_mid_click_none': { message: 'none' },
  'settings.nav_switch_panels_wheel': { message: 'Switch panels with mouse wheel' },

  // --- Group page
  'settings.group_title': { message: 'Group page' },
  'settings.group_layout': { message: 'Layout of tabs' },
  'settings.group_layout_grid': { message: 'grid' },
  'settings.group_layout_list': { message: 'list' },

  // --- Containers
  'settings.containers_title': { message: 'Containers' },
  'settings.contianer_remove_confirm_prefix': { message: 'Are you sure you want to delete "' },
  'settings.contianer_remove_confirm_postfix': { message: '" container?' },
  'settings.containers_create_btn': { message: 'Create container' },

  // --- Panels
  'settings.panels_title': { message: 'Panels' },
  'settings.panel_remove_confirm_1': { message: 'Delete "' },
  'settings.panel_remove_confirm_2': {
    message: '" panel?\nAll tabs of this panel will be moved to another panel.',
  },
  'settings.panel_icon_custom': { message: 'custom' },
  'settings.panels_create_btn': { message: 'Create panel' },

  // --- Tabs
  'settings.tabs_title': { message: 'Tabs' },
  'settings.warn_on_multi_tab_close': { message: 'Warn on trying close multiple tabs' },
  'settings.warn_on_multi_tab_close_any': { message: 'any' },
  'settings.warn_on_multi_tab_close_collapsed': { message: 'collapsed' },
  'settings.warn_on_multi_tab_close_none': { message: 'none' },
  'settings.activate_on_mouseup': { message: 'Activate tab on mouse button release' },
  'settings.activate_last_tab_on_panel_switching': {
    message: 'Activate last active tab on panels switching',
  },
  'settings.skip_empty_panels': { message: 'Skip empty panels on switching' },
  'settings.show_tab_rm_btn': { message: 'Show close button on mouse hover' },
  'settings.show_tab_ctx': { message: 'Show color mark of container' },
  'settings.hide_inactive_panel_tabs': { message: 'Hide tabs of inactive panels' },
  'settings.activate_after_closing': { message: 'After closing current tab activate' },
  'settings.activate_after_closing_next': { message: 'next tab' },
  'settings.activate_after_closing_prev': { message: 'previous tab' },
  'settings.activate_after_closing_prev_act': { message: 'previously active tab' },
  'settings.activate_after_closing_none': { message: 'none' },
  'settings.activate_after_closing_prev_rule': { message: 'Previous tab rule' },
  'settings.activate_after_closing_next_rule': { message: 'Next tab rule' },
  'settings.activate_after_closing_rule_tree': { message: 'tree' },
  'settings.activate_after_closing_rule_visible': { message: 'visible' },
  'settings.activate_after_closing_rule_any': { message: 'any' },
  'settings.activate_after_closing_global': { message: 'Globally' },
  'settings.shift_selection_from_active': {
    message: 'Start shift+click selection from the active tab',
  },
  'settings.ask_new_bookmark_place': { message: 'Ask where to store bookmarks' },
  'settings.tabs_rm_undo_note': { message: 'Show undo notification on closing multiple tabs' },
  'settings.native_highlight': {
    message: 'Highlight native tabs (in top horizontal bar) along with tabs in sidebar',
  },

  // --- New tab position
  'settings.new_tab_position': { message: 'Position of new tab' },
  'settings.move_new_tab_pin': { message: 'Place new tab opened from pinned tab' },
  'settings.move_new_tab_pin_start': { message: 'panel start' },
  'settings.move_new_tab_pin_end': { message: 'panel end' },
  'settings.move_new_tab_pin_none': { message: 'none' },
  'settings.move_new_tab_parent': { message: 'Place new tab opened from another tab' },
  'settings.move_new_tab_parent_before': { message: 'before parent' },
  'settings.move_new_tab_parent_sibling': { message: 'after parent' },
  'settings.move_new_tab_parent_first_child': { message: 'first child' },
  'settings.move_new_tab_parent_last_child': { message: 'last child' },
  'settings.move_new_tab_parent_start': { message: 'panel start' },
  'settings.move_new_tab_parent_end': { message: 'panel end' },
  'settings.move_new_tab_parent_none': { message: 'none' },
  'settings.move_new_tab_parent_act_panel': { message: 'Only if panel of parent tab is active' },
  'settings.move_new_tab': { message: 'Place new tab (for the other cases)' },
  'settings.move_new_tab_start': { message: 'panel start' },
  'settings.move_new_tab_end': { message: 'panel end' },
  'settings.move_new_tab_before': { message: 'before active tab' },
  'settings.move_new_tab_after': { message: 'after active tab' },
  'settings.move_new_tab_first_child': { message: 'first child of active tab' },
  'settings.move_new_tab_last_child': { message: 'last child of active tab' },
  'settings.move_new_tab_none': { message: 'none' },

  // --- Pinned tabs
  'settings.pinned_tabs_title': { message: 'Pinned tabs' },
  'settings.pinned_tabs_position': { message: 'Pinned tabs position' },
  'settings.pinned_tabs_position_top': { message: 'top' },
  'settings.pinned_tabs_position_left': { message: 'left' },
  'settings.pinned_tabs_position_right': { message: 'right' },
  'settings.pinned_tabs_position_bottom': { message: 'bottom' },
  'settings.pinned_tabs_position_panel': { message: 'panel' },
  'settings.pinned_tabs_list': { message: 'Show titles of pinned tabs' },

  // --- Tabs tree
  'settings.tabs_tree_title': { message: 'Tabs tree' },
  'settings.tabs_tree_layout': { message: 'Tabs tree structure' },
  'settings.group_on_open_layout': { message: 'Create sub-tree on opening link in new tab' },
  'settings.tabs_tree_limit': { message: 'Tabs tree level limit' },
  'settings.tabs_tree_limit_1': { message: '1' },
  'settings.tabs_tree_limit_2': { message: '2' },
  'settings.tabs_tree_limit_3': { message: '3' },
  'settings.tabs_tree_limit_4': { message: '4' },
  'settings.tabs_tree_limit_5': { message: '5' },
  'settings.tabs_tree_limit_none': { message: 'none' },
  'settings.hide_folded_tabs': { message: 'Hide folded tabs' },
  'settings.auto_fold_tabs': { message: 'Auto fold tabs' },
  'settings.auto_fold_tabs_except': { message: 'Except the last active branches' },
  'settings.auto_fold_tabs_except_1': { message: '1' },
  'settings.auto_fold_tabs_except_2': { message: '2' },
  'settings.auto_fold_tabs_except_3': { message: '3' },
  'settings.auto_fold_tabs_except_4': { message: '4' },
  'settings.auto_fold_tabs_except_5': { message: '5' },
  'settings.auto_fold_tabs_except_none': { message: 'none' },
  'settings.auto_exp_tabs': { message: 'Auto expand tab on activation' },
  'settings.rm_child_tabs': { message: 'Close child tabs along with parent' },
  'settings.rm_child_tabs_all': { message: 'all' },
  'settings.rm_child_tabs_folded': { message: 'folded' },
  'settings.rm_child_tabs_none': { message: 'none' },
  'settings.tabs_child_count': { message: 'Show count of descendants on the folded tab' },
  'settings.tabs_lvl_dots': { message: 'Show marks of tabs levels' },
  'settings.discard_folded': { message: 'Discard folded tabs' },
  'settings.discard_folded_delay': { message: 'With delay' },
  'settings.discard_folded_delay_sec': { message: ['second', 'seconds'], plur: [1] },
  'settings.discard_folded_delay_min': { message: ['minute', 'minutes'], plur: [1] },
  'settings.tabs_tree_bookmarks': { message: 'Preserve tree on creating bookmarks' },

  // --- Bookmarks
  'settings.bookmarks_title': { message: 'Bookmarks' },
  'settings.bookmarks_panel': { message: 'Bookmarks panel' },
  'settings.warn_on_multi_bookmark_delete': { message: 'Warn on trying delete multiple bookmarks' },
  'settings.warn_on_multi_bookmark_delete_any': { message: 'any' },
  'settings.warn_on_multi_bookmark_delete_collapsed': { message: 'collapsed' },
  'settings.warn_on_multi_bookmark_delete_none': { message: 'none' },
  'settings.open_bookmark_new_tab': { message: 'Open bookmark in new tab' },
  'settings.mid_click_bookmark': { message: 'Middle click on the bookmark' },
  'settings.mid_click_bookmark_open_new_tab': { message: 'open in new tab' },
  'settings.mid_click_bookmark_edit': { message: 'edit' },
  'settings.mid_click_bookmark_delete': { message: 'delete' },
  'settings.act_mid_click_tab': { message: 'Activate tab' },
  'settings.auto_close_bookmarks': { message: 'Auto-close folders' },
  'settings.auto_rm_other': { message: 'Delete open bookmarks from "Other Bookmarks" folder' },
  'settings.show_bookmark_len': { message: 'Show folder size' },
  'settings.highlight_open_bookmarks': { message: 'Highlight open bookmarks' },
  'settings.activate_open_bookmark_tab': { message: 'Go to open tab instead of opening new one' },
  'settings.bookmarks_rm_undo_note': { message: 'Show undo notification after deleting bookmarks' },

  // --- Appearance
  'settings.appearance_title': { message: 'Appearance' },
  'settings.font_size': { message: 'Font size' },
  'settings.font_size_xxs': { message: 'XXS' },
  'settings.font_size_xs': { message: 'XS' },
  'settings.font_size_s': { message: 'S' },
  'settings.font_size_m': { message: 'M' },
  'settings.font_size_l': { message: 'L' },
  'settings.font_size_xl': { message: 'XL' },
  'settings.font_size_xxl': { message: 'XXL' },
  'settings.switch_style': { message: 'Style' },
  'settings.style_dark': { message: 'dark' },
  'settings.style_light': { message: 'light' },
  'settings.theme': { message: 'Theme' },
  'settings.theme_default': { message: 'default' },
  'settings.theme_tactile': { message: 'tactile' },
  'settings.theme_none': { message: 'none' },
  'settings.bg_noise': { message: 'Frosted background' },
  'settings.animations': { message: 'Animations' },
  'settings.edit_styles': { message: 'Edit styles' },
  'settings.edit_theme': { message: 'Edit theme' },
  'settings.appearance_notes_title': { message: 'Notes:' },
  'settings.appearance_notes': {
    message:
      '- To apply theme color to Sidebery buttons in browser interface set "svg.context-properties.content.enabled" to "true" in about:config page.',
  },

  // --- Snapshots
  'settings.snapshots_title': { message: 'Snapshots' },
  'settings.snap_notify': { message: 'Show notification after snapshot creation' },
  'settings.snap_interval': { message: 'Auto-snapshots interval' },
  'settings.snap_interval_min': { message: ['minute', 'minutes'], plur: [1] },
  'settings.snap_interval_hr': { message: ['hour', 'hours'], plur: [1] },
  'settings.snap_interval_day': { message: ['day', 'days'], plur: [1] },
  'settings.snap_interval_none': { message: 'none' },
  'settings.snap_limit': { message: 'Snapshots limit' },
  'settings.snap_limit_snap': { message: ['snapshot', 'snapshots'], plur: [1] },
  'settings.snap_limit_kb': { message: ['kbyte', 'kbytes'], plur: [1] },
  'settings.snap_limit_day': { message: ['day', 'days'], plur: [1] },
  'settings.snapshots_view_label': { message: 'View snapshots' },
  'settings.make_snapshot': { message: 'Create snapshot' },
  'settings.rm_all_snapshots': { message: 'Remove all snapshots' },
  'settings.apply_snapshot': { message: 'apply' },
  'settings.rm_snapshot': { message: 'remove' },

  // --- Mouse
  'settings.mouse_title': { message: 'Mouse' },
  'settings.h_scroll_through_panels': { message: 'Use horizontal scroll to switch panels' },
  'settings.scroll_through_tabs': { message: 'Switch tabs with scroll wheel' },
  'settings.scroll_through_tabs_panel': { message: 'panel' },
  'settings.scroll_through_tabs_global': { message: 'global' },
  'settings.scroll_through_tabs_none': { message: 'none' },
  'settings.scroll_through_visible_tabs': { message: 'Skip folded tabs' },
  'settings.scroll_through_tabs_skip_discarded': { message: 'Skip discarded tabs' },
  'settings.scroll_through_tabs_except_overflow': { message: 'Except if panel is overflowed' },
  'settings.tab_double_click': { message: 'Double click on tab' },
  'settings.tab_long_left_click': { message: 'Long left click on tab' },
  'settings.tab_long_right_click': { message: 'Long right click on tab' },
  'settings.tab_action_reload': { message: 'reload' },
  'settings.tab_action_duplicate': { message: 'duplicate' },
  'settings.tab_action_pin': { message: 'pin' },
  'settings.tab_action_mute': { message: 'mute' },
  'settings.tab_action_clear_cookies': { message: 'clear cookies' },
  'settings.tab_action_exp': { message: 'expand' },
  'settings.tab_action_new_after': { message: 'new sibling tab' },
  'settings.tab_action_new_child': { message: 'new child tab' },
  'settings.tab_action_close': { message: 'close tab' },
  'settings.tab_action_none': { message: 'none' },
  'settings.tabs_panel_left_click_action': { message: 'Left click on tabs panel' },
  'settings.tabs_panel_double_click_action': { message: 'Double click on tabs panel' },
  'settings.tabs_panel_right_click_action': { message: 'Right click on tabs panel' },
  'settings.tabs_panel_action_tab': { message: 'create tab' },
  'settings.tabs_panel_action_prev': { message: 'previous panel' },
  'settings.tabs_panel_action_next': { message: 'next panel' },
  'settings.tabs_panel_action_expand': { message: 'expand/fold' },
  'settings.tabs_panel_action_parent': { message: 'activate parent tab' },
  'settings.tabs_panel_action_menu': { message: 'show menu' },
  'settings.tabs_panel_action_collapse': { message: 'collapse inactive branches' },
  'settings.tabs_panel_action_none': { message: 'none' },

  // --- Keybindings
  'settings.kb_title': { message: 'Keybindings' },
  'settings.reset_kb': { message: 'Reset Keybindings' },
  'settings.toggle_kb': { message: 'Enable/Disable Keybindings' },

  // --- Permissions
  'settings.permissions_title': { message: 'Permissions' },
  'settings.all_urls_label': { message: 'Websites data:' },
  'settings.all_urls_info': {
    message:
      'Required for:\n- Cleaning cookies\n- Proxy and url rules of containers\n- Screenshots for the group page and windows selection panel\n- Changing the User-Agent per container',
  },
  'settings.tab_hide_label': { message: 'Hiding tabs:' },
  'settings.tab_hide_info': {
    message: 'Required for:\n- Hiding tabs on inactive panels\n- Hiding folded tabs',
  },
  'settings.clipboard_write_label': { message: 'Clipboard write:' },
  'settings.clipboard_write_info': {
    message: 'Required for:\n- Copying urls of tabs/bookmarks through context menu',
  },
  'settings.web_request_blocking_label': { message: 'Web requests blocking' },
  'settings.web_request_blocking_info': {
    message: 'Required for:\n- Changing the User-Agent per container',
  },

  // --- Storage
  'settings.storage_title': { message: 'Storage' },
  'settings.storage_delete_prop': { message: 'delete' },
  'settings.storage_open_prop': { message: 'open' },
  'settings.storage_delete_confirm': { message: 'Delete property ' },
  'settings.update_storage_info': { message: 'Update' },
  'settings.clear_storage_info': { message: 'Clear' },
  'settings.clear_storage_confirm': {
    message: 'Are you sure you want to delete all data of Sidebery?',
  },

  // --- Help
  'settings.help_title': { message: 'Help' },
  'settings.debug_info': { message: 'Show debug info' },
  'settings.repo_issues': { message: 'Open issues' },
  'settings.repo_issue': { message: 'Open issue' },
  'settings.repo_bug': { message: 'Report a bug' },
  'settings.repo_feature': { message: 'Suggest a feature' },
  'settings.reset_settings': { message: 'Reset settings' },
  'settings.reset_confirm': { message: 'Are you sure you want to reset settings?' },
  'settings.ref_rm': { message: 'Will be removed, open issue if you need this feature.' },
  'settings.help_exp_data': { message: 'Export' },
  'settings.help_imp_data': { message: 'Import' },
  'settings.help_imp_perm': { message: 'Additional permissions are required' },
  'settings.export_title': { message: 'Select what to export' },
  'settings.import_title': { message: 'Select what to import' },
  'settings.export_containers': { message: 'Containers' },
  'settings.export_panels': { message: 'Panels' },
  'settings.export_settings': { message: 'Settings' },
  'settings.export_ctx_menu': { message: 'Context menu' },
  'settings.export_styles': { message: 'Styles' },
  'settings.export_snapshots': { message: 'Snapshots' },
  'settings.export_select_all': { message: 'Select all' },
  'settings.reload_addon': { message: 'Reload addon' },
}
