/*
 * Authored by Alex Hultman, 2018-2019.
 * Intellectual property of third-party.

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 *     http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef UTILITIES_H
#define UTILITIES_H

/* Various common utilities */

#include <cstdint>

namespace uWS {
namespace utils {

inline int u32toaHex(uint32_t value, char *dst) {
    char palette[] = "0123456789abcdef";
    char temp[10];
    char *p = temp;
    do {
        *p++ = palette[value % 16];
        value /= 16;
    } while (value > 0);

    int ret = p - temp;

    do {
        *dst++ = *--p;
    } while (p != temp);

    return ret;
}

inline int u32toa(uint32_t value, char *dst) {
    char temp[10];
    char *p = temp;
    do {
        *p++ = (char) (value % 10) + '0';
        value /= 10;
    } while (value > 0);

    int ret = p - temp;

    do {
        *dst++ = *--p;
    } while (p != temp);

    return ret;
}

}
}

#endif // UTILITIES_H
