/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonemetadata;
import java.util.regex.Pattern;

public class ShortNumberUtil {
    private final PhoneNumberUtil phoneUtil;

    public ShortNumberUtil() {
        this.phoneUtil = PhoneNumberUtil.getInstance();
    }

    ShortNumberUtil(PhoneNumberUtil phoneNumberUtil) {
        this.phoneUtil = phoneNumberUtil;
    }

    public boolean connectsToEmergencyNumber(String string, String string2) {
        return this.matchesEmergencyNumberHelper(string, string2, true);
    }

    public boolean isEmergencyNumber(String string, String string2) {
        return this.matchesEmergencyNumberHelper(string, string2, false);
    }

    private boolean matchesEmergencyNumberHelper(String string, String string2, boolean bl) {
        if (PhoneNumberUtil.PLUS_CHARS_PATTERN.matcher(string = PhoneNumberUtil.extractPossibleNumber(string)).lookingAt()) {
            return false;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = this.phoneUtil.getMetadataForRegion(string2);
        if (phoneMetadata == null || !phoneMetadata.hasEmergency()) {
            return false;
        }
        Pattern pattern = Pattern.compile(phoneMetadata.getEmergency().getNationalNumberPattern());
        String string3 = PhoneNumberUtil.normalizeDigitsOnly(string);
        return !bl || string2.equals("BR") ? pattern.matcher(string3).matches() : pattern.matcher(string3).lookingAt();
    }
}

