/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class RegexCache {
    private LRUCache<String, Pattern> cache;

    public RegexCache(int n) {
        this.cache = new LRUCache(n);
    }

    public Pattern getPatternForRegex(String string) {
        Pattern pattern = this.cache.get(string);
        if (pattern == null) {
            pattern = Pattern.compile(string);
            this.cache.put(string, pattern);
        }
        return pattern;
    }

    boolean containsRegex(String string) {
        return this.cache.containsKey(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LRUCache<K, V> {
        private LinkedHashMap<K, V> map;
        private int size;

        public LRUCache(int n) {
            this.size = n;
            this.map = new LinkedHashMap<K, V>(n * 4 / 3 + 1, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                    return this.size() > LRUCache.this.size;
                }
            };
        }

        public synchronized V get(K k) {
            return this.map.get(k);
        }

        public synchronized void put(K k, V v) {
            this.map.put(k, v);
        }

        public synchronized boolean containsKey(K k) {
            return this.map.containsKey(k);
        }
    }
}

