/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public final class Phonemetadata {
    private Phonemetadata() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhoneMetadataCollection
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private List<PhoneMetadata> metadata_ = new ArrayList<PhoneMetadata>();

        public static Builder newBuilder() {
            return new Builder();
        }

        public List<PhoneMetadata> getMetadataList() {
            return this.metadata_;
        }

        public int getMetadataCount() {
            return this.metadata_.size();
        }

        public PhoneMetadataCollection addMetadata(PhoneMetadata phoneMetadata) {
            if (phoneMetadata == null) {
                throw new NullPointerException();
            }
            this.metadata_.add(phoneMetadata);
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            int n = this.getMetadataCount();
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.metadata_.get(i).writeExternal(objectOutput);
            }
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException {
            int n = objectInput.readInt();
            for (int i = 0; i < n; ++i) {
                PhoneMetadata phoneMetadata = new PhoneMetadata();
                phoneMetadata.readExternal(objectInput);
                this.metadata_.add(phoneMetadata);
            }
        }

        public PhoneMetadataCollection clear() {
            this.metadata_.clear();
            return this;
        }

        public static final class Builder
        extends PhoneMetadataCollection {
            public PhoneMetadataCollection build() {
                return this;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhoneMetadata
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private boolean hasGeneralDesc;
        private PhoneNumberDesc generalDesc_ = null;
        private boolean hasFixedLine;
        private PhoneNumberDesc fixedLine_ = null;
        private boolean hasMobile;
        private PhoneNumberDesc mobile_ = null;
        private boolean hasTollFree;
        private PhoneNumberDesc tollFree_ = null;
        private boolean hasPremiumRate;
        private PhoneNumberDesc premiumRate_ = null;
        private boolean hasSharedCost;
        private PhoneNumberDesc sharedCost_ = null;
        private boolean hasPersonalNumber;
        private PhoneNumberDesc personalNumber_ = null;
        private boolean hasVoip;
        private PhoneNumberDesc voip_ = null;
        private boolean hasPager;
        private PhoneNumberDesc pager_ = null;
        private boolean hasUan;
        private PhoneNumberDesc uan_ = null;
        private boolean hasVoicemail;
        private PhoneNumberDesc voicemail_ = null;
        private boolean hasEmergency;
        private PhoneNumberDesc emergency_ = null;
        private boolean hasNoInternationalDialling;
        private PhoneNumberDesc noInternationalDialling_ = null;
        private boolean hasId;
        private String id_ = "";
        private boolean hasCountryCode;
        private int countryCode_ = 0;
        private boolean hasInternationalPrefix;
        private String internationalPrefix_ = "";
        private boolean hasPreferredInternationalPrefix;
        private String preferredInternationalPrefix_ = "";
        private boolean hasNationalPrefix;
        private String nationalPrefix_ = "";
        private boolean hasPreferredExtnPrefix;
        private String preferredExtnPrefix_ = "";
        private boolean hasNationalPrefixForParsing;
        private String nationalPrefixForParsing_ = "";
        private boolean hasNationalPrefixTransformRule;
        private String nationalPrefixTransformRule_ = "";
        private boolean hasSameMobileAndFixedLinePattern;
        private boolean sameMobileAndFixedLinePattern_ = false;
        private List<NumberFormat> numberFormat_ = new ArrayList<NumberFormat>();
        private List<NumberFormat> intlNumberFormat_ = new ArrayList<NumberFormat>();
        private boolean hasMainCountryForCode;
        private boolean mainCountryForCode_ = false;
        private boolean hasLeadingDigits;
        private String leadingDigits_ = "";
        private boolean hasLeadingZeroPossible;
        private boolean leadingZeroPossible_ = false;

        public static Builder newBuilder() {
            return new Builder();
        }

        public boolean hasGeneralDesc() {
            return this.hasGeneralDesc;
        }

        public PhoneNumberDesc getGeneralDesc() {
            return this.generalDesc_;
        }

        public PhoneMetadata setGeneralDesc(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasGeneralDesc = true;
            this.generalDesc_ = phoneNumberDesc;
            return this;
        }

        public boolean hasFixedLine() {
            return this.hasFixedLine;
        }

        public PhoneNumberDesc getFixedLine() {
            return this.fixedLine_;
        }

        public PhoneMetadata setFixedLine(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasFixedLine = true;
            this.fixedLine_ = phoneNumberDesc;
            return this;
        }

        public boolean hasMobile() {
            return this.hasMobile;
        }

        public PhoneNumberDesc getMobile() {
            return this.mobile_;
        }

        public PhoneMetadata setMobile(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasMobile = true;
            this.mobile_ = phoneNumberDesc;
            return this;
        }

        public boolean hasTollFree() {
            return this.hasTollFree;
        }

        public PhoneNumberDesc getTollFree() {
            return this.tollFree_;
        }

        public PhoneMetadata setTollFree(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasTollFree = true;
            this.tollFree_ = phoneNumberDesc;
            return this;
        }

        public boolean hasPremiumRate() {
            return this.hasPremiumRate;
        }

        public PhoneNumberDesc getPremiumRate() {
            return this.premiumRate_;
        }

        public PhoneMetadata setPremiumRate(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasPremiumRate = true;
            this.premiumRate_ = phoneNumberDesc;
            return this;
        }

        public boolean hasSharedCost() {
            return this.hasSharedCost;
        }

        public PhoneNumberDesc getSharedCost() {
            return this.sharedCost_;
        }

        public PhoneMetadata setSharedCost(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasSharedCost = true;
            this.sharedCost_ = phoneNumberDesc;
            return this;
        }

        public boolean hasPersonalNumber() {
            return this.hasPersonalNumber;
        }

        public PhoneNumberDesc getPersonalNumber() {
            return this.personalNumber_;
        }

        public PhoneMetadata setPersonalNumber(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasPersonalNumber = true;
            this.personalNumber_ = phoneNumberDesc;
            return this;
        }

        public boolean hasVoip() {
            return this.hasVoip;
        }

        public PhoneNumberDesc getVoip() {
            return this.voip_;
        }

        public PhoneMetadata setVoip(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasVoip = true;
            this.voip_ = phoneNumberDesc;
            return this;
        }

        public boolean hasPager() {
            return this.hasPager;
        }

        public PhoneNumberDesc getPager() {
            return this.pager_;
        }

        public PhoneMetadata setPager(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasPager = true;
            this.pager_ = phoneNumberDesc;
            return this;
        }

        public boolean hasUan() {
            return this.hasUan;
        }

        public PhoneNumberDesc getUan() {
            return this.uan_;
        }

        public PhoneMetadata setUan(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasUan = true;
            this.uan_ = phoneNumberDesc;
            return this;
        }

        public boolean hasVoicemail() {
            return this.hasVoicemail;
        }

        public PhoneNumberDesc getVoicemail() {
            return this.voicemail_;
        }

        public PhoneMetadata setVoicemail(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasVoicemail = true;
            this.voicemail_ = phoneNumberDesc;
            return this;
        }

        public boolean hasEmergency() {
            return this.hasEmergency;
        }

        public PhoneNumberDesc getEmergency() {
            return this.emergency_;
        }

        public PhoneMetadata setEmergency(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasEmergency = true;
            this.emergency_ = phoneNumberDesc;
            return this;
        }

        public boolean hasNoInternationalDialling() {
            return this.hasNoInternationalDialling;
        }

        public PhoneNumberDesc getNoInternationalDialling() {
            return this.noInternationalDialling_;
        }

        public PhoneMetadata setNoInternationalDialling(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc == null) {
                throw new NullPointerException();
            }
            this.hasNoInternationalDialling = true;
            this.noInternationalDialling_ = phoneNumberDesc;
            return this;
        }

        public boolean hasId() {
            return this.hasId;
        }

        public String getId() {
            return this.id_;
        }

        public PhoneMetadata setId(String string) {
            this.hasId = true;
            this.id_ = string;
            return this;
        }

        public boolean hasCountryCode() {
            return this.hasCountryCode;
        }

        public int getCountryCode() {
            return this.countryCode_;
        }

        public PhoneMetadata setCountryCode(int n) {
            this.hasCountryCode = true;
            this.countryCode_ = n;
            return this;
        }

        public boolean hasInternationalPrefix() {
            return this.hasInternationalPrefix;
        }

        public String getInternationalPrefix() {
            return this.internationalPrefix_;
        }

        public PhoneMetadata setInternationalPrefix(String string) {
            this.hasInternationalPrefix = true;
            this.internationalPrefix_ = string;
            return this;
        }

        public boolean hasPreferredInternationalPrefix() {
            return this.hasPreferredInternationalPrefix;
        }

        public String getPreferredInternationalPrefix() {
            return this.preferredInternationalPrefix_;
        }

        public PhoneMetadata setPreferredInternationalPrefix(String string) {
            this.hasPreferredInternationalPrefix = true;
            this.preferredInternationalPrefix_ = string;
            return this;
        }

        public boolean hasNationalPrefix() {
            return this.hasNationalPrefix;
        }

        public String getNationalPrefix() {
            return this.nationalPrefix_;
        }

        public PhoneMetadata setNationalPrefix(String string) {
            this.hasNationalPrefix = true;
            this.nationalPrefix_ = string;
            return this;
        }

        public boolean hasPreferredExtnPrefix() {
            return this.hasPreferredExtnPrefix;
        }

        public String getPreferredExtnPrefix() {
            return this.preferredExtnPrefix_;
        }

        public PhoneMetadata setPreferredExtnPrefix(String string) {
            this.hasPreferredExtnPrefix = true;
            this.preferredExtnPrefix_ = string;
            return this;
        }

        public boolean hasNationalPrefixForParsing() {
            return this.hasNationalPrefixForParsing;
        }

        public String getNationalPrefixForParsing() {
            return this.nationalPrefixForParsing_;
        }

        public PhoneMetadata setNationalPrefixForParsing(String string) {
            this.hasNationalPrefixForParsing = true;
            this.nationalPrefixForParsing_ = string;
            return this;
        }

        public boolean hasNationalPrefixTransformRule() {
            return this.hasNationalPrefixTransformRule;
        }

        public String getNationalPrefixTransformRule() {
            return this.nationalPrefixTransformRule_;
        }

        public PhoneMetadata setNationalPrefixTransformRule(String string) {
            this.hasNationalPrefixTransformRule = true;
            this.nationalPrefixTransformRule_ = string;
            return this;
        }

        public boolean hasSameMobileAndFixedLinePattern() {
            return this.hasSameMobileAndFixedLinePattern;
        }

        public boolean isSameMobileAndFixedLinePattern() {
            return this.sameMobileAndFixedLinePattern_;
        }

        public PhoneMetadata setSameMobileAndFixedLinePattern(boolean bl) {
            this.hasSameMobileAndFixedLinePattern = true;
            this.sameMobileAndFixedLinePattern_ = bl;
            return this;
        }

        public List<NumberFormat> numberFormats() {
            return this.numberFormat_;
        }

        public int numberFormatSize() {
            return this.numberFormat_.size();
        }

        public NumberFormat getNumberFormat(int n) {
            return this.numberFormat_.get(n);
        }

        public PhoneMetadata addNumberFormat(NumberFormat numberFormat) {
            if (numberFormat == null) {
                throw new NullPointerException();
            }
            this.numberFormat_.add(numberFormat);
            return this;
        }

        public List<NumberFormat> intlNumberFormats() {
            return this.intlNumberFormat_;
        }

        public int intlNumberFormatSize() {
            return this.intlNumberFormat_.size();
        }

        public NumberFormat getIntlNumberFormat(int n) {
            return this.intlNumberFormat_.get(n);
        }

        public PhoneMetadata addIntlNumberFormat(NumberFormat numberFormat) {
            if (numberFormat == null) {
                throw new NullPointerException();
            }
            this.intlNumberFormat_.add(numberFormat);
            return this;
        }

        public PhoneMetadata clearIntlNumberFormat() {
            this.intlNumberFormat_.clear();
            return this;
        }

        public boolean hasMainCountryForCode() {
            return this.hasMainCountryForCode;
        }

        public boolean isMainCountryForCode() {
            return this.mainCountryForCode_;
        }

        public boolean getMainCountryForCode() {
            return this.mainCountryForCode_;
        }

        public PhoneMetadata setMainCountryForCode(boolean bl) {
            this.hasMainCountryForCode = true;
            this.mainCountryForCode_ = bl;
            return this;
        }

        public boolean hasLeadingDigits() {
            return this.hasLeadingDigits;
        }

        public String getLeadingDigits() {
            return this.leadingDigits_;
        }

        public PhoneMetadata setLeadingDigits(String string) {
            this.hasLeadingDigits = true;
            this.leadingDigits_ = string;
            return this;
        }

        public boolean hasLeadingZeroPossible() {
            return this.hasLeadingZeroPossible;
        }

        public boolean isLeadingZeroPossible() {
            return this.leadingZeroPossible_;
        }

        public PhoneMetadata setLeadingZeroPossible(boolean bl) {
            this.hasLeadingZeroPossible = true;
            this.leadingZeroPossible_ = bl;
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            int n;
            objectOutput.writeBoolean(this.hasGeneralDesc);
            if (this.hasGeneralDesc) {
                this.generalDesc_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasFixedLine);
            if (this.hasFixedLine) {
                this.fixedLine_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasMobile);
            if (this.hasMobile) {
                this.mobile_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasTollFree);
            if (this.hasTollFree) {
                this.tollFree_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasPremiumRate);
            if (this.hasPremiumRate) {
                this.premiumRate_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasSharedCost);
            if (this.hasSharedCost) {
                this.sharedCost_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasPersonalNumber);
            if (this.hasPersonalNumber) {
                this.personalNumber_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasVoip);
            if (this.hasVoip) {
                this.voip_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasPager);
            if (this.hasPager) {
                this.pager_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasUan);
            if (this.hasUan) {
                this.uan_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasVoicemail);
            if (this.hasVoicemail) {
                this.voicemail_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasEmergency);
            if (this.hasEmergency) {
                this.emergency_.writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.hasNoInternationalDialling);
            if (this.hasNoInternationalDialling) {
                this.noInternationalDialling_.writeExternal(objectOutput);
            }
            objectOutput.writeUTF(this.id_);
            objectOutput.writeInt(this.countryCode_);
            objectOutput.writeUTF(this.internationalPrefix_);
            objectOutput.writeBoolean(this.hasPreferredInternationalPrefix);
            if (this.hasPreferredInternationalPrefix) {
                objectOutput.writeUTF(this.preferredInternationalPrefix_);
            }
            objectOutput.writeBoolean(this.hasNationalPrefix);
            if (this.hasNationalPrefix) {
                objectOutput.writeUTF(this.nationalPrefix_);
            }
            objectOutput.writeBoolean(this.hasPreferredExtnPrefix);
            if (this.hasPreferredExtnPrefix) {
                objectOutput.writeUTF(this.preferredExtnPrefix_);
            }
            objectOutput.writeBoolean(this.hasNationalPrefixForParsing);
            if (this.hasNationalPrefixForParsing) {
                objectOutput.writeUTF(this.nationalPrefixForParsing_);
            }
            objectOutput.writeBoolean(this.hasNationalPrefixTransformRule);
            if (this.hasNationalPrefixTransformRule) {
                objectOutput.writeUTF(this.nationalPrefixTransformRule_);
            }
            objectOutput.writeBoolean(this.sameMobileAndFixedLinePattern_);
            int n2 = this.numberFormatSize();
            objectOutput.writeInt(n2);
            for (n = 0; n < n2; ++n) {
                this.numberFormat_.get(n).writeExternal(objectOutput);
            }
            n = this.intlNumberFormatSize();
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.intlNumberFormat_.get(i).writeExternal(objectOutput);
            }
            objectOutput.writeBoolean(this.mainCountryForCode_);
            objectOutput.writeBoolean(this.hasLeadingDigits);
            if (this.hasLeadingDigits) {
                objectOutput.writeUTF(this.leadingDigits_);
            }
            objectOutput.writeBoolean(this.leadingZeroPossible_);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException {
            int n;
            PhoneNumberDesc phoneNumberDesc;
            boolean bl = objectInput.readBoolean();
            if (bl) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setGeneralDesc(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setFixedLine(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setMobile(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setTollFree(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setPremiumRate(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setSharedCost(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setPersonalNumber(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setVoip(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setPager(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setUan(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setVoicemail(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setEmergency(phoneNumberDesc);
            }
            if (bl = objectInput.readBoolean()) {
                phoneNumberDesc = new PhoneNumberDesc();
                phoneNumberDesc.readExternal(objectInput);
                this.setNoInternationalDialling(phoneNumberDesc);
            }
            this.setId(objectInput.readUTF());
            this.setCountryCode(objectInput.readInt());
            this.setInternationalPrefix(objectInput.readUTF());
            boolean bl2 = objectInput.readBoolean();
            if (bl2) {
                this.setPreferredInternationalPrefix(objectInput.readUTF());
            }
            if (bl2 = objectInput.readBoolean()) {
                this.setNationalPrefix(objectInput.readUTF());
            }
            if (bl2 = objectInput.readBoolean()) {
                this.setPreferredExtnPrefix(objectInput.readUTF());
            }
            if (bl2 = objectInput.readBoolean()) {
                this.setNationalPrefixForParsing(objectInput.readUTF());
            }
            if (bl2 = objectInput.readBoolean()) {
                this.setNationalPrefixTransformRule(objectInput.readUTF());
            }
            this.setSameMobileAndFixedLinePattern(objectInput.readBoolean());
            int n2 = objectInput.readInt();
            for (n = 0; n < n2; ++n) {
                NumberFormat numberFormat = new NumberFormat();
                numberFormat.readExternal(objectInput);
                this.numberFormat_.add(numberFormat);
            }
            n = objectInput.readInt();
            for (int i = 0; i < n; ++i) {
                NumberFormat numberFormat = new NumberFormat();
                numberFormat.readExternal(objectInput);
                this.intlNumberFormat_.add(numberFormat);
            }
            this.setMainCountryForCode(objectInput.readBoolean());
            bl2 = objectInput.readBoolean();
            if (bl2) {
                this.setLeadingDigits(objectInput.readUTF());
            }
            this.setLeadingZeroPossible(objectInput.readBoolean());
        }

        public static final class Builder
        extends PhoneMetadata {
            public PhoneMetadata build() {
                return this;
            }
        }
    }

    public static class PhoneNumberDesc
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private boolean hasNationalNumberPattern;
        private String nationalNumberPattern_ = "";
        private boolean hasPossibleNumberPattern;
        private String possibleNumberPattern_ = "";
        private boolean hasExampleNumber;
        private String exampleNumber_ = "";

        public static Builder newBuilder() {
            return new Builder();
        }

        public boolean hasNationalNumberPattern() {
            return this.hasNationalNumberPattern;
        }

        public String getNationalNumberPattern() {
            return this.nationalNumberPattern_;
        }

        public PhoneNumberDesc setNationalNumberPattern(String string) {
            this.hasNationalNumberPattern = true;
            this.nationalNumberPattern_ = string;
            return this;
        }

        public boolean hasPossibleNumberPattern() {
            return this.hasPossibleNumberPattern;
        }

        public String getPossibleNumberPattern() {
            return this.possibleNumberPattern_;
        }

        public PhoneNumberDesc setPossibleNumberPattern(String string) {
            this.hasPossibleNumberPattern = true;
            this.possibleNumberPattern_ = string;
            return this;
        }

        public boolean hasExampleNumber() {
            return this.hasExampleNumber;
        }

        public String getExampleNumber() {
            return this.exampleNumber_;
        }

        public PhoneNumberDesc setExampleNumber(String string) {
            this.hasExampleNumber = true;
            this.exampleNumber_ = string;
            return this;
        }

        public PhoneNumberDesc mergeFrom(PhoneNumberDesc phoneNumberDesc) {
            if (phoneNumberDesc.hasNationalNumberPattern()) {
                this.setNationalNumberPattern(phoneNumberDesc.getNationalNumberPattern());
            }
            if (phoneNumberDesc.hasPossibleNumberPattern()) {
                this.setPossibleNumberPattern(phoneNumberDesc.getPossibleNumberPattern());
            }
            if (phoneNumberDesc.hasExampleNumber()) {
                this.setExampleNumber(phoneNumberDesc.getExampleNumber());
            }
            return this;
        }

        public boolean exactlySameAs(PhoneNumberDesc phoneNumberDesc) {
            return this.nationalNumberPattern_.equals(phoneNumberDesc.nationalNumberPattern_) && this.possibleNumberPattern_.equals(phoneNumberDesc.possibleNumberPattern_) && this.exampleNumber_.equals(phoneNumberDesc.exampleNumber_);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeBoolean(this.hasNationalNumberPattern);
            if (this.hasNationalNumberPattern) {
                objectOutput.writeUTF(this.nationalNumberPattern_);
            }
            objectOutput.writeBoolean(this.hasPossibleNumberPattern);
            if (this.hasPossibleNumberPattern) {
                objectOutput.writeUTF(this.possibleNumberPattern_);
            }
            objectOutput.writeBoolean(this.hasExampleNumber);
            if (this.hasExampleNumber) {
                objectOutput.writeUTF(this.exampleNumber_);
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            if (objectInput.readBoolean()) {
                this.setNationalNumberPattern(objectInput.readUTF());
            }
            if (objectInput.readBoolean()) {
                this.setPossibleNumberPattern(objectInput.readUTF());
            }
            if (objectInput.readBoolean()) {
                this.setExampleNumber(objectInput.readUTF());
            }
        }

        public static final class Builder
        extends PhoneNumberDesc {
            public PhoneNumberDesc build() {
                return this;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NumberFormat
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private boolean hasPattern;
        private String pattern_ = "";
        private boolean hasFormat;
        private String format_ = "";
        private List<String> leadingDigitsPattern_ = new ArrayList<String>();
        private boolean hasNationalPrefixFormattingRule;
        private String nationalPrefixFormattingRule_ = "";
        private boolean hasNationalPrefixOptionalWhenFormatting;
        private boolean nationalPrefixOptionalWhenFormatting_ = false;
        private boolean hasDomesticCarrierCodeFormattingRule;
        private String domesticCarrierCodeFormattingRule_ = "";

        public static Builder newBuilder() {
            return new Builder();
        }

        public boolean hasPattern() {
            return this.hasPattern;
        }

        public String getPattern() {
            return this.pattern_;
        }

        public NumberFormat setPattern(String string) {
            this.hasPattern = true;
            this.pattern_ = string;
            return this;
        }

        public boolean hasFormat() {
            return this.hasFormat;
        }

        public String getFormat() {
            return this.format_;
        }

        public NumberFormat setFormat(String string) {
            this.hasFormat = true;
            this.format_ = string;
            return this;
        }

        public List<String> leadingDigitPatterns() {
            return this.leadingDigitsPattern_;
        }

        public int leadingDigitsPatternSize() {
            return this.leadingDigitsPattern_.size();
        }

        public String getLeadingDigitsPattern(int n) {
            return this.leadingDigitsPattern_.get(n);
        }

        public NumberFormat addLeadingDigitsPattern(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.leadingDigitsPattern_.add(string);
            return this;
        }

        public boolean hasNationalPrefixFormattingRule() {
            return this.hasNationalPrefixFormattingRule;
        }

        public String getNationalPrefixFormattingRule() {
            return this.nationalPrefixFormattingRule_;
        }

        public NumberFormat setNationalPrefixFormattingRule(String string) {
            this.hasNationalPrefixFormattingRule = true;
            this.nationalPrefixFormattingRule_ = string;
            return this;
        }

        public NumberFormat clearNationalPrefixFormattingRule() {
            this.hasNationalPrefixFormattingRule = false;
            this.nationalPrefixFormattingRule_ = "";
            return this;
        }

        public boolean hasNationalPrefixOptionalWhenFormatting() {
            return this.hasNationalPrefixOptionalWhenFormatting;
        }

        public boolean isNationalPrefixOptionalWhenFormatting() {
            return this.nationalPrefixOptionalWhenFormatting_;
        }

        public NumberFormat setNationalPrefixOptionalWhenFormatting(boolean bl) {
            this.hasNationalPrefixOptionalWhenFormatting = true;
            this.nationalPrefixOptionalWhenFormatting_ = bl;
            return this;
        }

        public boolean hasDomesticCarrierCodeFormattingRule() {
            return this.hasDomesticCarrierCodeFormattingRule;
        }

        public String getDomesticCarrierCodeFormattingRule() {
            return this.domesticCarrierCodeFormattingRule_;
        }

        public NumberFormat setDomesticCarrierCodeFormattingRule(String string) {
            this.hasDomesticCarrierCodeFormattingRule = true;
            this.domesticCarrierCodeFormattingRule_ = string;
            return this;
        }

        public NumberFormat mergeFrom(NumberFormat numberFormat) {
            if (numberFormat.hasPattern()) {
                this.setPattern(numberFormat.getPattern());
            }
            if (numberFormat.hasFormat()) {
                this.setFormat(numberFormat.getFormat());
            }
            int n = numberFormat.leadingDigitsPatternSize();
            for (int i = 0; i < n; ++i) {
                this.addLeadingDigitsPattern(numberFormat.getLeadingDigitsPattern(i));
            }
            if (numberFormat.hasNationalPrefixFormattingRule()) {
                this.setNationalPrefixFormattingRule(numberFormat.getNationalPrefixFormattingRule());
            }
            if (numberFormat.hasDomesticCarrierCodeFormattingRule()) {
                this.setDomesticCarrierCodeFormattingRule(numberFormat.getDomesticCarrierCodeFormattingRule());
            }
            this.setNationalPrefixOptionalWhenFormatting(numberFormat.isNationalPrefixOptionalWhenFormatting());
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.pattern_);
            objectOutput.writeUTF(this.format_);
            int n = this.leadingDigitsPatternSize();
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutput.writeUTF(this.leadingDigitsPattern_.get(i));
            }
            objectOutput.writeBoolean(this.hasNationalPrefixFormattingRule);
            if (this.hasNationalPrefixFormattingRule) {
                objectOutput.writeUTF(this.nationalPrefixFormattingRule_);
            }
            objectOutput.writeBoolean(this.hasDomesticCarrierCodeFormattingRule);
            if (this.hasDomesticCarrierCodeFormattingRule) {
                objectOutput.writeUTF(this.domesticCarrierCodeFormattingRule_);
            }
            objectOutput.writeBoolean(this.nationalPrefixOptionalWhenFormatting_);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException {
            this.setPattern(objectInput.readUTF());
            this.setFormat(objectInput.readUTF());
            int n = objectInput.readInt();
            for (int i = 0; i < n; ++i) {
                this.leadingDigitsPattern_.add(objectInput.readUTF());
            }
            if (objectInput.readBoolean()) {
                this.setNationalPrefixFormattingRule(objectInput.readUTF());
            }
            if (objectInput.readBoolean()) {
                this.setDomesticCarrierCodeFormattingRule(objectInput.readUTF());
            }
            this.setNationalPrefixOptionalWhenFormatting(objectInput.readBoolean());
        }

        public static final class Builder
        extends NumberFormat {
            public NumberFormat build() {
                return this;
            }
        }
    }
}

