/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.MetadataManager;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberMatch;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PhoneNumberMatcher
implements Iterator<PhoneNumberMatch> {
    private static final Pattern PATTERN;
    private static final Pattern PUB_PAGES;
    private static final Pattern SLASH_SEPARATED_DATES;
    private static final Pattern TIME_STAMPS;
    private static final Pattern TIME_STAMPS_SUFFIX;
    private static final Pattern MATCHING_BRACKETS;
    private static final Pattern GROUP_SEPARATOR;
    private static final Pattern LEAD_CLASS;
    private final PhoneNumberUtil phoneUtil;
    private final CharSequence text;
    private final String preferredRegion;
    private final PhoneNumberUtil.Leniency leniency;
    private long maxTries;
    private State state = State.NOT_READY;
    private PhoneNumberMatch lastMatch = null;
    private int searchIndex = 0;

    private static String limit(int n, int n2) {
        if (n < 0 || n2 <= 0 || n2 < n) {
            throw new IllegalArgumentException();
        }
        return "{" + n + "," + n2 + "}";
    }

    PhoneNumberMatcher(PhoneNumberUtil phoneNumberUtil, CharSequence charSequence, String string, PhoneNumberUtil.Leniency leniency, long l) {
        if (phoneNumberUtil == null || leniency == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.phoneUtil = phoneNumberUtil;
        this.text = charSequence != null ? charSequence : "";
        this.preferredRegion = string;
        this.leniency = leniency;
        this.maxTries = l;
    }

    private PhoneNumberMatch find(int n) {
        Matcher matcher = PATTERN.matcher(this.text);
        while (this.maxTries > 0L && matcher.find(n)) {
            int n2 = matcher.start();
            CharSequence charSequence = this.text.subSequence(n2, matcher.end());
            PhoneNumberMatch phoneNumberMatch = this.extractMatch(charSequence = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.SECOND_NUMBER_START_PATTERN, charSequence), n2);
            if (phoneNumberMatch != null) {
                return phoneNumberMatch;
            }
            n = n2 + charSequence.length();
            --this.maxTries;
        }
        return null;
    }

    private static CharSequence trimAfterFirstMatch(Pattern pattern, CharSequence charSequence) {
        Matcher matcher = pattern.matcher(charSequence);
        if (matcher.find()) {
            charSequence = charSequence.subSequence(0, matcher.start());
        }
        return charSequence;
    }

    static boolean isLatinLetter(char c) {
        if (!Character.isLetter(c) && Character.getType(c) != 6) {
            return false;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock.equals(Character.UnicodeBlock.BASIC_LATIN) || unicodeBlock.equals(Character.UnicodeBlock.LATIN_1_SUPPLEMENT) || unicodeBlock.equals(Character.UnicodeBlock.LATIN_EXTENDED_A) || unicodeBlock.equals(Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL) || unicodeBlock.equals(Character.UnicodeBlock.LATIN_EXTENDED_B) || unicodeBlock.equals(Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS);
    }

    private static boolean isInvalidPunctuationSymbol(char c) {
        return c == '%' || Character.getType(c) == 26;
    }

    private PhoneNumberMatch extractMatch(CharSequence charSequence, int n) {
        String string;
        if (PUB_PAGES.matcher(charSequence).find() || SLASH_SEPARATED_DATES.matcher(charSequence).find()) {
            return null;
        }
        if (TIME_STAMPS.matcher(charSequence).find() && TIME_STAMPS_SUFFIX.matcher(string = ((Object)this.text).toString().substring(n + charSequence.length())).lookingAt()) {
            return null;
        }
        string = ((Object)charSequence).toString();
        PhoneNumberMatch phoneNumberMatch = this.parseAndVerify(string, n);
        if (phoneNumberMatch != null) {
            return phoneNumberMatch;
        }
        return this.extractInnerMatch(string, n);
    }

    private PhoneNumberMatch extractInnerMatch(String string, int n) {
        Matcher matcher = GROUP_SEPARATOR.matcher(string);
        if (matcher.find()) {
            CharSequence charSequence = string.substring(0, matcher.start());
            PhoneNumberMatch phoneNumberMatch = this.parseAndVerify((charSequence = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.UNWANTED_END_CHAR_PATTERN, charSequence)).toString(), n);
            if (phoneNumberMatch != null) {
                return phoneNumberMatch;
            }
            --this.maxTries;
            int n2 = matcher.end();
            CharSequence charSequence2 = string.substring(n2);
            phoneNumberMatch = this.parseAndVerify((charSequence2 = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.UNWANTED_END_CHAR_PATTERN, charSequence2)).toString(), n + n2);
            if (phoneNumberMatch != null) {
                return phoneNumberMatch;
            }
            --this.maxTries;
            if (this.maxTries > 0L) {
                int n3 = n2;
                while (matcher.find()) {
                    n3 = matcher.start();
                }
                CharSequence charSequence3 = string.substring(0, n3);
                if ((charSequence3 = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.UNWANTED_END_CHAR_PATTERN, charSequence3)).equals(charSequence)) {
                    return null;
                }
                phoneNumberMatch = this.parseAndVerify(charSequence3.toString(), n);
                if (phoneNumberMatch != null) {
                    return phoneNumberMatch;
                }
                --this.maxTries;
            }
        }
        return null;
    }

    private PhoneNumberMatch parseAndVerify(String string, int n) {
        try {
            Phonenumber.PhoneNumber phoneNumber;
            if (!MATCHING_BRACKETS.matcher(string).matches()) {
                return null;
            }
            if (this.leniency.compareTo(PhoneNumberUtil.Leniency.VALID) >= 0) {
                char c;
                char c2;
                if (n > 0 && !LEAD_CLASS.matcher(string).lookingAt() && (PhoneNumberMatcher.isInvalidPunctuationSymbol(c2 = (char)this.text.charAt(n - 1)) || PhoneNumberMatcher.isLatinLetter(c2))) {
                    return null;
                }
                c2 = n + string.length();
                if (c2 < this.text.length() && (PhoneNumberMatcher.isInvalidPunctuationSymbol(c = this.text.charAt(c2)) || PhoneNumberMatcher.isLatinLetter(c))) {
                    return null;
                }
            }
            if (this.leniency.verify(phoneNumber = this.phoneUtil.parseAndKeepRawInput(string, this.preferredRegion), string, this.phoneUtil)) {
                phoneNumber.clearCountryCodeSource();
                phoneNumber.clearRawInput();
                phoneNumber.clearPreferredDomesticCarrierCode();
                return new PhoneNumberMatch(n, string, phoneNumber);
            }
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        return null;
    }

    static boolean allNumberGroupsRemainGrouped(PhoneNumberUtil phoneNumberUtil, Phonenumber.PhoneNumber phoneNumber, StringBuilder stringBuilder, String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if ((n = stringBuilder.indexOf(stringArray[i], n)) < 0) {
                return false;
            }
            if (i != 0 || (n += stringArray[i].length()) >= stringBuilder.length() || !Character.isDigit(stringBuilder.charAt(n))) continue;
            String string = phoneNumberUtil.getNationalSignificantNumber(phoneNumber);
            return stringBuilder.substring(n - stringArray[i].length()).startsWith(string);
        }
        return stringBuilder.substring(n).contains(phoneNumber.getExtension());
    }

    static boolean allNumberGroupsAreExactlyPresent(PhoneNumberUtil phoneNumberUtil, Phonenumber.PhoneNumber phoneNumber, StringBuilder stringBuilder, String[] stringArray) {
        int n;
        String[] stringArray2 = PhoneNumberUtil.NON_DIGITS_PATTERN.split(stringBuilder.toString());
        int n2 = n = phoneNumber.hasExtension() ? stringArray2.length - 2 : stringArray2.length - 1;
        if (stringArray2.length == 1 || stringArray2[n].contains(phoneNumberUtil.getNationalSignificantNumber(phoneNumber))) {
            return true;
        }
        for (int i = stringArray.length - 1; i > 0 && n >= 0; --i, --n) {
            if (stringArray2[n].equals(stringArray[i])) continue;
            return false;
        }
        return n >= 0 && stringArray2[n].endsWith(stringArray[0]);
    }

    private static String[] getNationalNumberGroups(PhoneNumberUtil phoneNumberUtil, Phonenumber.PhoneNumber phoneNumber, Phonemetadata.NumberFormat numberFormat) {
        if (numberFormat == null) {
            String string = phoneNumberUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.RFC3966);
            int n = string.indexOf(59);
            if (n < 0) {
                n = string.length();
            }
            int n2 = string.indexOf(45) + 1;
            return string.substring(n2, n).split("-");
        }
        String string = phoneNumberUtil.getNationalSignificantNumber(phoneNumber);
        return phoneNumberUtil.formatNsnUsingPattern(string, numberFormat, PhoneNumberUtil.PhoneNumberFormat.RFC3966).split("-");
    }

    static boolean checkNumberGroupingIsValid(Phonenumber.PhoneNumber phoneNumber, String string, PhoneNumberUtil phoneNumberUtil, NumberGroupingChecker numberGroupingChecker) {
        String[] stringArray;
        StringBuilder stringBuilder = PhoneNumberUtil.normalizeDigits(string, true);
        if (numberGroupingChecker.checkGroups(phoneNumberUtil, phoneNumber, stringBuilder, stringArray = PhoneNumberMatcher.getNationalNumberGroups(phoneNumberUtil, phoneNumber, null))) {
            return true;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getAlternateFormatsForCountry(phoneNumber.getCountryCode());
        if (phoneMetadata != null) {
            for (Phonemetadata.NumberFormat numberFormat : phoneMetadata.numberFormats()) {
                stringArray = PhoneNumberMatcher.getNationalNumberGroups(phoneNumberUtil, phoneNumber, numberFormat);
                if (!numberGroupingChecker.checkGroups(phoneNumberUtil, phoneNumber, stringBuilder, stringArray)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsMoreThanOneSlash(String string) {
        int n = string.indexOf(47);
        return n > 0 && string.substring(n + 1).contains("/");
    }

    static boolean containsOnlyValidXChars(Phonenumber.PhoneNumber phoneNumber, String string, PhoneNumberUtil phoneNumberUtil) {
        for (int i = 0; i < string.length() - 1; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 != 'x' && c2 != 'X' || !((c = string.charAt(i + 1)) == 'x' || c == 'X' ? phoneNumberUtil.isNumberMatch(phoneNumber, string.substring(++i)) != PhoneNumberUtil.MatchType.NSN_MATCH : !PhoneNumberUtil.normalizeDigitsOnly(string.substring(i)).equals(phoneNumber.getExtension()))) continue;
            return false;
        }
        return true;
    }

    static boolean isNationalPrefixPresentIfRequired(Phonenumber.PhoneNumber phoneNumber, PhoneNumberUtil phoneNumberUtil) {
        if (phoneNumber.getCountryCodeSource() != Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY) {
            return true;
        }
        String string = phoneNumberUtil.getRegionCodeForCountryCode(phoneNumber.getCountryCode());
        Phonemetadata.PhoneMetadata phoneMetadata = phoneNumberUtil.getMetadataForRegion(string);
        if (phoneMetadata == null) {
            return true;
        }
        String string2 = phoneNumberUtil.getNationalSignificantNumber(phoneNumber);
        Phonemetadata.NumberFormat numberFormat = phoneNumberUtil.chooseFormattingPatternForNumber(phoneMetadata.numberFormats(), string2);
        if (numberFormat != null && numberFormat.getNationalPrefixFormattingRule().length() > 0) {
            if (numberFormat.isNationalPrefixOptionalWhenFormatting()) {
                return true;
            }
            String string3 = numberFormat.getNationalPrefixFormattingRule();
            string3 = string3.substring(0, string3.indexOf("$1"));
            if ((string3 = PhoneNumberUtil.normalizeDigitsOnly(string3)).length() == 0) {
                return true;
            }
            String string4 = PhoneNumberUtil.normalizeDigitsOnly(phoneNumber.getRawInput());
            StringBuilder stringBuilder = new StringBuilder(string4);
            return phoneNumberUtil.maybeStripNationalPrefixAndCarrierCode(stringBuilder, phoneMetadata, null);
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.state == State.NOT_READY) {
            this.lastMatch = this.find(this.searchIndex);
            if (this.lastMatch == null) {
                this.state = State.DONE;
            } else {
                this.searchIndex = this.lastMatch.end();
                this.state = State.READY;
            }
        }
        return this.state == State.READY;
    }

    @Override
    public PhoneNumberMatch next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PhoneNumberMatch phoneNumberMatch = this.lastMatch;
        this.lastMatch = null;
        this.state = State.NOT_READY;
        return phoneNumberMatch;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        PUB_PAGES = Pattern.compile("\\d{1,5}-+\\d{1,5}\\s{0,4}\\(\\d{1,4}");
        SLASH_SEPARATED_DATES = Pattern.compile("(?:(?:[0-3]?\\d/[01]?\\d)|(?:[01]?\\d/[0-3]?\\d))/(?:[12]\\d)?\\d{2}");
        TIME_STAMPS = Pattern.compile("[12]\\d{3}[-/]?[01]\\d[-/]?[0-3]\\d [0-2]\\d$");
        TIME_STAMPS_SUFFIX = Pattern.compile(":[0-5]\\d");
        String string = "(\\[\uff08\uff3b";
        String string2 = ")\\]\uff09\uff3d";
        String string3 = "[^" + string + string2 + "]";
        String string4 = PhoneNumberMatcher.limit(0, 3);
        MATCHING_BRACKETS = Pattern.compile("(?:[" + string + "])?" + "(?:" + string3 + "+" + "[" + string2 + "])?" + string3 + "+" + "(?:[" + string + "]" + string3 + "+[" + string2 + "])" + string4 + string3 + "*");
        String string5 = PhoneNumberMatcher.limit(0, 2);
        String string6 = PhoneNumberMatcher.limit(0, 4);
        int n = 19;
        String string7 = PhoneNumberMatcher.limit(0, n);
        String string8 = "[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]" + string6;
        String string9 = "\\p{Nd}" + PhoneNumberMatcher.limit(1, n);
        String string10 = string + "+\uff0b";
        String string11 = "[" + string10 + "]";
        LEAD_CLASS = Pattern.compile(string11);
        GROUP_SEPARATOR = Pattern.compile("\\p{Z}[^" + string10 + "\\p{Nd}]*");
        PATTERN = Pattern.compile("(?:" + string11 + string8 + ")" + string5 + string9 + "(?:" + string8 + string9 + ")" + string7 + "(?:" + PhoneNumberUtil.EXTN_PATTERNS_FOR_MATCHING + ")?", 66);
    }

    static interface NumberGroupingChecker {
        public boolean checkGroups(PhoneNumberUtil var1, Phonenumber.PhoneNumber var2, StringBuilder var3, String[] var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NOT_READY,
        READY,
        DONE;

    }
}

