/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Arrays;

public final class PhoneNumberMatch {
    private final int start;
    private final String rawString;
    private final Phonenumber.PhoneNumber number;

    PhoneNumberMatch(int n, String string, Phonenumber.PhoneNumber phoneNumber) {
        if (n < 0) {
            throw new IllegalArgumentException("Start index must be >= 0.");
        }
        if (string == null || phoneNumber == null) {
            throw new NullPointerException();
        }
        this.start = n;
        this.rawString = string;
        this.number = phoneNumber;
    }

    public Phonenumber.PhoneNumber number() {
        return this.number;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.start + this.rawString.length();
    }

    public String rawString() {
        return this.rawString;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.start, this.rawString, this.number});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PhoneNumberMatch)) {
            return false;
        }
        PhoneNumberMatch phoneNumberMatch = (PhoneNumberMatch)object;
        return this.rawString.equals(phoneNumberMatch.rawString) && this.start == phoneNumberMatch.start && this.number.equals(phoneNumberMatch.number);
    }

    public String toString() {
        return "PhoneNumberMatch [" + this.start() + "," + this.end() + ") " + this.rawString;
    }
}

