/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.AlternateFormatsCountryCodeSet;
import com.google.i18n.phonenumbers.PhoneNumberMatcher;
import com.google.i18n.phonenumbers.Phonemetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MetadataManager {
    private static final String ALTERNATE_FORMATS_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberAlternateFormatsProto";
    private static final Logger LOGGER = Logger.getLogger(MetadataManager.class.getName());
    private static final Map<Integer, Phonemetadata.PhoneMetadata> callingCodeToAlternateFormatsMap = Collections.synchronizedMap(new HashMap());
    private static final Set<Integer> countryCodeSet = AlternateFormatsCountryCodeSet.getCountryCodeSet();

    private MetadataManager() {
    }

    private static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMetadataFromFile(int n) {
        InputStream inputStream = PhoneNumberMatcher.class.getResourceAsStream("/com/google/i18n/phonenumbers/data/PhoneNumberAlternateFormatsProto_" + n);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            Phonemetadata.PhoneMetadataCollection phoneMetadataCollection = new Phonemetadata.PhoneMetadataCollection();
            phoneMetadataCollection.readExternal(objectInputStream);
            for (Phonemetadata.PhoneMetadata phoneMetadata : phoneMetadataCollection.getMetadataList()) {
                callingCodeToAlternateFormatsMap.put(phoneMetadata.getCountryCode(), phoneMetadata);
            }
        }
        catch (IOException iOException) {
            try {
                LOGGER.log(Level.WARNING, iOException.toString());
            }
            catch (Throwable throwable) {
                MetadataManager.close(objectInputStream);
                throw throwable;
            }
            MetadataManager.close(objectInputStream);
        }
        MetadataManager.close(objectInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Phonemetadata.PhoneMetadata getAlternateFormatsForCountry(int n) {
        if (!countryCodeSet.contains(n)) {
            return null;
        }
        Map<Integer, Phonemetadata.PhoneMetadata> map = callingCodeToAlternateFormatsMap;
        synchronized (map) {
            if (!callingCodeToAlternateFormatsMap.containsKey(n)) {
                MetadataManager.loadMetadataFromFile(n);
            }
        }
        return callingCodeToAlternateFormatsMap.get(n);
    }
}

