/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.RegexCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AsYouTypeFormatter {
    private String currentOutput = "";
    private StringBuilder formattingTemplate = new StringBuilder();
    private String currentFormattingPattern = "";
    private StringBuilder accruedInput = new StringBuilder();
    private StringBuilder accruedInputWithoutFormatting = new StringBuilder();
    private boolean ableToFormat = true;
    private boolean inputHasFormatting = false;
    private boolean isCompleteNumber = false;
    private boolean isExpectingCountryCallingCode = false;
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private String defaultCountry;
    private static final char SEPARATOR_BEFORE_NATIONAL_NUMBER = ' ';
    private static final Phonemetadata.PhoneMetadata EMPTY_METADATA = new Phonemetadata.PhoneMetadata().setInternationalPrefix("NA");
    private Phonemetadata.PhoneMetadata defaultMetaData;
    private Phonemetadata.PhoneMetadata currentMetaData;
    private static final Pattern CHARACTER_CLASS_PATTERN = Pattern.compile("\\[([^\\[\\]])*\\]");
    private static final Pattern STANDALONE_DIGIT_PATTERN = Pattern.compile("\\d(?=[^,}][^,}])");
    private static final Pattern ELIGIBLE_FORMAT_PATTERN = Pattern.compile("[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]*(\\$\\d[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]*)+");
    private static final Pattern NATIONAL_PREFIX_SEPARATORS_PATTERN = Pattern.compile("[- ]");
    private static final int MIN_LEADING_DIGITS_LENGTH = 3;
    private static final String DIGIT_PLACEHOLDER = "\u2008";
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\u2008");
    private int lastMatchPosition = 0;
    private int originalPosition = 0;
    private int positionToRemember = 0;
    private StringBuilder prefixBeforeNationalNumber = new StringBuilder();
    private boolean shouldAddSpaceAfterNationalPrefix = false;
    private String nationalPrefixExtracted = "";
    private StringBuilder nationalNumber = new StringBuilder();
    private List<Phonemetadata.NumberFormat> possibleFormats = new ArrayList<Phonemetadata.NumberFormat>();
    private RegexCache regexCache = new RegexCache(64);

    AsYouTypeFormatter(String string) {
        this.defaultCountry = string;
        this.defaultMetaData = this.currentMetaData = this.getMetadataForRegion(this.defaultCountry);
    }

    private Phonemetadata.PhoneMetadata getMetadataForRegion(String string) {
        int n = this.phoneUtil.getCountryCodeForRegion(string);
        String string2 = this.phoneUtil.getRegionCodeForCountryCode(n);
        Phonemetadata.PhoneMetadata phoneMetadata = this.phoneUtil.getMetadataForRegion(string2);
        if (phoneMetadata != null) {
            return phoneMetadata;
        }
        return EMPTY_METADATA;
    }

    private boolean maybeCreateNewTemplate() {
        Iterator<Phonemetadata.NumberFormat> iterator = this.possibleFormats.iterator();
        while (iterator.hasNext()) {
            Phonemetadata.NumberFormat numberFormat = iterator.next();
            String string = numberFormat.getPattern();
            if (this.currentFormattingPattern.equals(string)) {
                return false;
            }
            if (this.createFormattingTemplate(numberFormat)) {
                this.currentFormattingPattern = string;
                this.shouldAddSpaceAfterNationalPrefix = NATIONAL_PREFIX_SEPARATORS_PATTERN.matcher(numberFormat.getNationalPrefixFormattingRule()).find();
                this.lastMatchPosition = 0;
                return true;
            }
            iterator.remove();
        }
        this.ableToFormat = false;
        return false;
    }

    private void getAvailableFormats(String string) {
        List<Phonemetadata.NumberFormat> list = this.isCompleteNumber && this.currentMetaData.intlNumberFormatSize() > 0 ? this.currentMetaData.intlNumberFormats() : this.currentMetaData.numberFormats();
        boolean bl = this.currentMetaData.hasNationalPrefix();
        for (Phonemetadata.NumberFormat numberFormat : list) {
            if (bl && !this.isCompleteNumber && !numberFormat.isNationalPrefixOptionalWhenFormatting()) {
                if (!PhoneNumberUtil.formattingRuleHasFirstGroupOnly(numberFormat.getNationalPrefixFormattingRule())) continue;
            }
            if (!this.isFormatEligible(numberFormat.getFormat())) continue;
            this.possibleFormats.add(numberFormat);
        }
        this.narrowDownPossibleFormats(string);
    }

    private boolean isFormatEligible(String string) {
        return ELIGIBLE_FORMAT_PATTERN.matcher(string).matches();
    }

    private void narrowDownPossibleFormats(String string) {
        int n = string.length() - 3;
        Iterator<Phonemetadata.NumberFormat> iterator = this.possibleFormats.iterator();
        while (iterator.hasNext()) {
            Pattern pattern;
            Matcher matcher;
            Phonemetadata.NumberFormat numberFormat = iterator.next();
            if (numberFormat.leadingDigitsPatternSize() <= n || (matcher = (pattern = this.regexCache.getPatternForRegex(numberFormat.getLeadingDigitsPattern(n))).matcher(string)).lookingAt()) continue;
            iterator.remove();
        }
    }

    private boolean createFormattingTemplate(Phonemetadata.NumberFormat numberFormat) {
        String string = numberFormat.getPattern();
        if (string.indexOf(124) != -1) {
            return false;
        }
        string = CHARACTER_CLASS_PATTERN.matcher(string).replaceAll("\\\\d");
        string = STANDALONE_DIGIT_PATTERN.matcher(string).replaceAll("\\\\d");
        this.formattingTemplate.setLength(0);
        String string2 = this.getFormattingTemplate(string, numberFormat.getFormat());
        if (string2.length() > 0) {
            this.formattingTemplate.append(string2);
            return true;
        }
        return false;
    }

    private String getFormattingTemplate(String string, String string2) {
        String string3 = "999999999999999";
        Matcher matcher = this.regexCache.getPatternForRegex(string).matcher(string3);
        matcher.find();
        String string4 = matcher.group();
        if (string4.length() < this.nationalNumber.length()) {
            return "";
        }
        String string5 = string4.replaceAll(string, string2);
        string5 = string5.replaceAll("9", DIGIT_PLACEHOLDER);
        return string5;
    }

    public void clear() {
        this.currentOutput = "";
        this.accruedInput.setLength(0);
        this.accruedInputWithoutFormatting.setLength(0);
        this.formattingTemplate.setLength(0);
        this.lastMatchPosition = 0;
        this.currentFormattingPattern = "";
        this.prefixBeforeNationalNumber.setLength(0);
        this.nationalPrefixExtracted = "";
        this.nationalNumber.setLength(0);
        this.ableToFormat = true;
        this.inputHasFormatting = false;
        this.positionToRemember = 0;
        this.originalPosition = 0;
        this.isCompleteNumber = false;
        this.isExpectingCountryCallingCode = false;
        this.possibleFormats.clear();
        this.shouldAddSpaceAfterNationalPrefix = false;
        if (!this.currentMetaData.equals(this.defaultMetaData)) {
            this.currentMetaData = this.getMetadataForRegion(this.defaultCountry);
        }
    }

    public String inputDigit(char c) {
        this.currentOutput = this.inputDigitWithOptionToRememberPosition(c, false);
        return this.currentOutput;
    }

    public String inputDigitAndRememberPosition(char c) {
        this.currentOutput = this.inputDigitWithOptionToRememberPosition(c, true);
        return this.currentOutput;
    }

    private String inputDigitWithOptionToRememberPosition(char c, boolean bl) {
        this.accruedInput.append(c);
        if (bl) {
            this.originalPosition = this.accruedInput.length();
        }
        if (!this.isDigitOrLeadingPlusSign(c)) {
            this.ableToFormat = false;
            this.inputHasFormatting = true;
        } else {
            c = this.normalizeAndAccrueDigitsAndPlusSign(c, bl);
        }
        if (!this.ableToFormat) {
            if (this.inputHasFormatting) {
                return this.accruedInput.toString();
            }
            if (this.attemptToExtractIdd()) {
                if (this.attemptToExtractCountryCallingCode()) {
                    return this.attemptToChoosePatternWithPrefixExtracted();
                }
            } else if (this.ableToExtractLongerNdd()) {
                this.prefixBeforeNationalNumber.append(' ');
                return this.attemptToChoosePatternWithPrefixExtracted();
            }
            return this.accruedInput.toString();
        }
        switch (this.accruedInputWithoutFormatting.length()) {
            case 0: 
            case 1: 
            case 2: {
                return this.accruedInput.toString();
            }
            case 3: {
                if (this.attemptToExtractIdd()) {
                    this.isExpectingCountryCallingCode = true;
                    break;
                }
                this.nationalPrefixExtracted = this.removeNationalPrefixFromNationalNumber();
                return this.attemptToChooseFormattingPattern();
            }
        }
        if (this.isExpectingCountryCallingCode) {
            if (this.attemptToExtractCountryCallingCode()) {
                this.isExpectingCountryCallingCode = false;
            }
            return this.prefixBeforeNationalNumber + this.nationalNumber.toString();
        }
        if (this.possibleFormats.size() > 0) {
            String string = this.inputDigitHelper(c);
            String string2 = this.attemptToFormatAccruedDigits();
            if (string2.length() > 0) {
                return string2;
            }
            this.narrowDownPossibleFormats(this.nationalNumber.toString());
            if (this.maybeCreateNewTemplate()) {
                return this.inputAccruedNationalNumber();
            }
            return this.ableToFormat ? this.appendNationalNumber(string) : this.accruedInput.toString();
        }
        return this.attemptToChooseFormattingPattern();
    }

    private String attemptToChoosePatternWithPrefixExtracted() {
        this.ableToFormat = true;
        this.isExpectingCountryCallingCode = false;
        this.possibleFormats.clear();
        return this.attemptToChooseFormattingPattern();
    }

    private boolean ableToExtractLongerNdd() {
        if (this.nationalPrefixExtracted.length() > 0) {
            this.nationalNumber.insert(0, this.nationalPrefixExtracted);
            int n = this.prefixBeforeNationalNumber.lastIndexOf(this.nationalPrefixExtracted);
            this.prefixBeforeNationalNumber.setLength(n);
        }
        return !this.nationalPrefixExtracted.equals(this.removeNationalPrefixFromNationalNumber());
    }

    private boolean isDigitOrLeadingPlusSign(char c) {
        return Character.isDigit(c) || this.accruedInput.length() == 1 && PhoneNumberUtil.PLUS_CHARS_PATTERN.matcher(Character.toString(c)).matches();
    }

    String attemptToFormatAccruedDigits() {
        for (Phonemetadata.NumberFormat numberFormat : this.possibleFormats) {
            Matcher matcher = this.regexCache.getPatternForRegex(numberFormat.getPattern()).matcher(this.nationalNumber);
            if (!matcher.matches()) continue;
            this.shouldAddSpaceAfterNationalPrefix = NATIONAL_PREFIX_SEPARATORS_PATTERN.matcher(numberFormat.getNationalPrefixFormattingRule()).find();
            String string = matcher.replaceAll(numberFormat.getFormat());
            return this.appendNationalNumber(string);
        }
        return "";
    }

    public int getRememberedPosition() {
        int n;
        if (!this.ableToFormat) {
            return this.originalPosition;
        }
        int n2 = 0;
        for (n = 0; n2 < this.positionToRemember && n < this.currentOutput.length(); ++n) {
            if (this.accruedInputWithoutFormatting.charAt(n2) != this.currentOutput.charAt(n)) continue;
            ++n2;
        }
        return n;
    }

    private String appendNationalNumber(String string) {
        int n = this.prefixBeforeNationalNumber.length();
        if (this.shouldAddSpaceAfterNationalPrefix && n > 0 && this.prefixBeforeNationalNumber.charAt(n - 1) != ' ') {
            return new String(this.prefixBeforeNationalNumber) + ' ' + string;
        }
        return this.prefixBeforeNationalNumber + string;
    }

    private String attemptToChooseFormattingPattern() {
        if (this.nationalNumber.length() >= 3) {
            this.getAvailableFormats(this.nationalNumber.substring(0, 3));
            return this.maybeCreateNewTemplate() ? this.inputAccruedNationalNumber() : this.accruedInput.toString();
        }
        return this.appendNationalNumber(this.nationalNumber.toString());
    }

    private String inputAccruedNationalNumber() {
        int n = this.nationalNumber.length();
        if (n > 0) {
            String string = "";
            for (int i = 0; i < n; ++i) {
                string = this.inputDigitHelper(this.nationalNumber.charAt(i));
            }
            return this.ableToFormat ? this.appendNationalNumber(string) : this.accruedInput.toString();
        }
        return this.prefixBeforeNationalNumber.toString();
    }

    private boolean isNanpaNumberWithNationalPrefix() {
        return this.currentMetaData.getCountryCode() == 1 && this.nationalNumber.charAt(0) == '1' && this.nationalNumber.charAt(1) != '0' && this.nationalNumber.charAt(1) != '1';
    }

    private String removeNationalPrefixFromNationalNumber() {
        Object object;
        Matcher matcher;
        int n = 0;
        if (this.isNanpaNumberWithNationalPrefix()) {
            n = 1;
            this.prefixBeforeNationalNumber.append('1').append(' ');
            this.isCompleteNumber = true;
        } else if (this.currentMetaData.hasNationalPrefixForParsing() && (matcher = ((Pattern)(object = this.regexCache.getPatternForRegex(this.currentMetaData.getNationalPrefixForParsing()))).matcher(this.nationalNumber)).lookingAt()) {
            this.isCompleteNumber = true;
            n = matcher.end();
            this.prefixBeforeNationalNumber.append(this.nationalNumber.substring(0, n));
        }
        object = this.nationalNumber.substring(0, n);
        this.nationalNumber.delete(0, n);
        return object;
    }

    private boolean attemptToExtractIdd() {
        Pattern pattern = this.regexCache.getPatternForRegex("\\+|" + this.currentMetaData.getInternationalPrefix());
        Matcher matcher = pattern.matcher(this.accruedInputWithoutFormatting);
        if (matcher.lookingAt()) {
            this.isCompleteNumber = true;
            int n = matcher.end();
            this.nationalNumber.setLength(0);
            this.nationalNumber.append(this.accruedInputWithoutFormatting.substring(n));
            this.prefixBeforeNationalNumber.setLength(0);
            this.prefixBeforeNationalNumber.append(this.accruedInputWithoutFormatting.substring(0, n));
            if (this.accruedInputWithoutFormatting.charAt(0) != '+') {
                this.prefixBeforeNationalNumber.append(' ');
            }
            return true;
        }
        return false;
    }

    private boolean attemptToExtractCountryCallingCode() {
        if (this.nationalNumber.length() == 0) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.phoneUtil.extractCountryCode(this.nationalNumber, stringBuilder);
        if (n == 0) {
            return false;
        }
        this.nationalNumber.setLength(0);
        this.nationalNumber.append((CharSequence)stringBuilder);
        String string = this.phoneUtil.getRegionCodeForCountryCode(n);
        if ("001".equals(string)) {
            this.currentMetaData = this.phoneUtil.getMetadataForNonGeographicalRegion(n);
        } else if (!string.equals(this.defaultCountry)) {
            this.currentMetaData = this.getMetadataForRegion(string);
        }
        String string2 = Integer.toString(n);
        this.prefixBeforeNationalNumber.append(string2).append(' ');
        return true;
    }

    private char normalizeAndAccrueDigitsAndPlusSign(char c, boolean bl) {
        char c2;
        if (c == '+') {
            c2 = c;
            this.accruedInputWithoutFormatting.append(c);
        } else {
            int n = 10;
            c2 = Character.forDigit(Character.digit(c, n), n);
            this.accruedInputWithoutFormatting.append(c2);
            this.nationalNumber.append(c2);
        }
        if (bl) {
            this.positionToRemember = this.accruedInputWithoutFormatting.length();
        }
        return c2;
    }

    private String inputDigitHelper(char c) {
        Matcher matcher = DIGIT_PATTERN.matcher(this.formattingTemplate);
        if (matcher.find(this.lastMatchPosition)) {
            String string = matcher.replaceFirst(Character.toString(c));
            this.formattingTemplate.replace(0, string.length(), string);
            this.lastMatchPosition = matcher.start();
            return this.formattingTemplate.substring(0, this.lastMatchPosition + 1);
        }
        if (this.possibleFormats.size() == 1) {
            this.ableToFormat = false;
        }
        this.currentFormattingPattern = "";
        return this.accruedInput.toString();
    }
}

