// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/pingcap/tipb/go-mysqlx/Expr/mysqlx_expr.proto

/*
	Package Mysqlx_Expr is a generated protocol buffer package.

	Expression syntax

	expr is the fundamental structure in various places
	of the SQL language:

	* ``SELECT <expr> AS ...``
	* ``WHERE <expr>``

	The structures can be used to:

	* build an Item-tree in the MySQL Server
	* generate SQL from it
	* use as filter condition in CRUD's Find(), Update() and Delete() calls.

	It is generated from these files:
		github.com/pingcap/tipb/go-mysqlx/Expr/mysqlx_expr.proto

	It has these top-level messages:
		Expr
		Identifier
		DocumentPathItem
		ColumnIdentifier
		FunctionCall
		Operator
		Object
		Array
*/
package Mysqlx_Expr

import (
	"fmt"

	proto "github.com/golang/protobuf/proto"

	math "math"

	Mysqlx_Datatypes "github.com/pingcap/tipb/go-mysqlx/Datatypes"

	github_com_golang_protobuf_proto "github.com/golang/protobuf/proto"

	io "io"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Expr_Type int32

const (
	Expr_IDENT       Expr_Type = 1
	Expr_LITERAL     Expr_Type = 2
	Expr_VARIABLE    Expr_Type = 3
	Expr_FUNC_CALL   Expr_Type = 4
	Expr_OPERATOR    Expr_Type = 5
	Expr_PLACEHOLDER Expr_Type = 6
	Expr_OBJECT      Expr_Type = 7
	Expr_ARRAY       Expr_Type = 8
)

var Expr_Type_name = map[int32]string{
	1: "IDENT",
	2: "LITERAL",
	3: "VARIABLE",
	4: "FUNC_CALL",
	5: "OPERATOR",
	6: "PLACEHOLDER",
	7: "OBJECT",
	8: "ARRAY",
}
var Expr_Type_value = map[string]int32{
	"IDENT":       1,
	"LITERAL":     2,
	"VARIABLE":    3,
	"FUNC_CALL":   4,
	"OPERATOR":    5,
	"PLACEHOLDER": 6,
	"OBJECT":      7,
	"ARRAY":       8,
}

func (x Expr_Type) Enum() *Expr_Type {
	p := new(Expr_Type)
	*p = x
	return p
}
func (x Expr_Type) String() string {
	return proto.EnumName(Expr_Type_name, int32(x))
}
func (x *Expr_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Expr_Type_value, data, "Expr_Type")
	if err != nil {
		return err
	}
	*x = Expr_Type(value)
	return nil
}
func (Expr_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{0, 0} }

type DocumentPathItem_Type int32

const (
	DocumentPathItem_MEMBER               DocumentPathItem_Type = 1
	DocumentPathItem_MEMBER_ASTERISK      DocumentPathItem_Type = 2
	DocumentPathItem_ARRAY_INDEX          DocumentPathItem_Type = 3
	DocumentPathItem_ARRAY_INDEX_ASTERISK DocumentPathItem_Type = 4
	DocumentPathItem_DOUBLE_ASTERISK      DocumentPathItem_Type = 5
)

var DocumentPathItem_Type_name = map[int32]string{
	1: "MEMBER",
	2: "MEMBER_ASTERISK",
	3: "ARRAY_INDEX",
	4: "ARRAY_INDEX_ASTERISK",
	5: "DOUBLE_ASTERISK",
}
var DocumentPathItem_Type_value = map[string]int32{
	"MEMBER":               1,
	"MEMBER_ASTERISK":      2,
	"ARRAY_INDEX":          3,
	"ARRAY_INDEX_ASTERISK": 4,
	"DOUBLE_ASTERISK":      5,
}

func (x DocumentPathItem_Type) Enum() *DocumentPathItem_Type {
	p := new(DocumentPathItem_Type)
	*p = x
	return p
}
func (x DocumentPathItem_Type) String() string {
	return proto.EnumName(DocumentPathItem_Type_name, int32(x))
}
func (x *DocumentPathItem_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(DocumentPathItem_Type_value, data, "DocumentPathItem_Type")
	if err != nil {
		return err
	}
	*x = DocumentPathItem_Type(value)
	return nil
}
func (DocumentPathItem_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMysqlxExpr, []int{2, 0}
}

// Expressions
//
// the "root" of the expression tree
//
// .. productionlist::
//   expr: `operator` |
//       : `identifier` |
//       : `function_call` |
//       : variable |
//       : `literal` |
//       : placeholder
//
// If expression type is PLACEHOLDER then it refers to the value of a parameter
// specified when executing a statement (see `args` field of `StmtExecute` command).
// Field `position` (which must be present for such an expression) gives 0-based
// position of the parameter in the parameter list.
//
type Expr struct {
	Type             *Expr_Type               `protobuf:"varint,1,req,name=type,enum=Mysqlx.Expr.Expr_Type" json:"type,omitempty"`
	Identifier       *ColumnIdentifier        `protobuf:"bytes,2,opt,name=identifier" json:"identifier,omitempty"`
	Variable         *string                  `protobuf:"bytes,3,opt,name=variable" json:"variable,omitempty"`
	Literal          *Mysqlx_Datatypes.Scalar `protobuf:"bytes,4,opt,name=literal" json:"literal,omitempty"`
	FunctionCall     *FunctionCall            `protobuf:"bytes,5,opt,name=function_call,json=functionCall" json:"function_call,omitempty"`
	Operator         *Operator                `protobuf:"bytes,6,opt,name=operator" json:"operator,omitempty"`
	Position         *uint32                  `protobuf:"varint,7,opt,name=position" json:"position,omitempty"`
	Object           *Object                  `protobuf:"bytes,8,opt,name=object" json:"object,omitempty"`
	Array            *Array                   `protobuf:"bytes,9,opt,name=array" json:"array,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *Expr) Reset()                    { *m = Expr{} }
func (m *Expr) String() string            { return proto.CompactTextString(m) }
func (*Expr) ProtoMessage()               {}
func (*Expr) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{0} }

func (m *Expr) GetType() Expr_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Expr_IDENT
}

func (m *Expr) GetIdentifier() *ColumnIdentifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (m *Expr) GetVariable() string {
	if m != nil && m.Variable != nil {
		return *m.Variable
	}
	return ""
}

func (m *Expr) GetLiteral() *Mysqlx_Datatypes.Scalar {
	if m != nil {
		return m.Literal
	}
	return nil
}

func (m *Expr) GetFunctionCall() *FunctionCall {
	if m != nil {
		return m.FunctionCall
	}
	return nil
}

func (m *Expr) GetOperator() *Operator {
	if m != nil {
		return m.Operator
	}
	return nil
}

func (m *Expr) GetPosition() uint32 {
	if m != nil && m.Position != nil {
		return *m.Position
	}
	return 0
}

func (m *Expr) GetObject() *Object {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *Expr) GetArray() *Array {
	if m != nil {
		return m.Array
	}
	return nil
}

// identifier: name, schame.name
//
// .. productionlist::
//   identifier: string "." string |
//             : string
type Identifier struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	SchemaName       *string `protobuf:"bytes,2,opt,name=schema_name,json=schemaName" json:"schema_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Identifier) Reset()                    { *m = Identifier{} }
func (m *Identifier) String() string            { return proto.CompactTextString(m) }
func (*Identifier) ProtoMessage()               {}
func (*Identifier) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{1} }

func (m *Identifier) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Identifier) GetSchemaName() string {
	if m != nil && m.SchemaName != nil {
		return *m.SchemaName
	}
	return ""
}

// DocumentPathItem
//
// .. productionlist::
//    document_path: path_item | path_item document_path
//    path_item    : member | array_index | "**"
//    member       : "." string | "." "*"
//    array_index  : "[" number "]" | "[" "*" "]"
//
type DocumentPathItem struct {
	Type             *DocumentPathItem_Type `protobuf:"varint,1,req,name=type,enum=Mysqlx.Expr.DocumentPathItem_Type" json:"type,omitempty"`
	Value            *string                `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	Index            *uint32                `protobuf:"varint,3,opt,name=index" json:"index,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *DocumentPathItem) Reset()                    { *m = DocumentPathItem{} }
func (m *DocumentPathItem) String() string            { return proto.CompactTextString(m) }
func (*DocumentPathItem) ProtoMessage()               {}
func (*DocumentPathItem) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{2} }

func (m *DocumentPathItem) GetType() DocumentPathItem_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return DocumentPathItem_MEMBER
}

func (m *DocumentPathItem) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *DocumentPathItem) GetIndex() uint32 {
	if m != nil && m.Index != nil {
		return *m.Index
	}
	return 0
}

// col_identifier (table): col@doc_path, tbl.col@doc_path col, tbl.col, schema.tbl.col
// col_identifier (document): doc_path
//
// .. productionlist::
//   col_identifier: string "." string "." string |
//             : string "." string |
//             : string |
//             : string "." string "." string "@" document_path |
//             : string "." string "@" document_path |
//             : string "@" document_path |
//             : document_path
//    document_path: member | arrayLocation | doubleAsterisk
//    member = "." string | "." "*"
//    arrayLocation = "[" index "]" | "[" "*" "]"
//    doubleAsterisk = "**"
//
type ColumnIdentifier struct {
	DocumentPath     []*DocumentPathItem `protobuf:"bytes,1,rep,name=document_path,json=documentPath" json:"document_path,omitempty"`
	Name             *string             `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	TableName        *string             `protobuf:"bytes,3,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
	SchemaName       *string             `protobuf:"bytes,4,opt,name=schema_name,json=schemaName" json:"schema_name,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *ColumnIdentifier) Reset()                    { *m = ColumnIdentifier{} }
func (m *ColumnIdentifier) String() string            { return proto.CompactTextString(m) }
func (*ColumnIdentifier) ProtoMessage()               {}
func (*ColumnIdentifier) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{3} }

func (m *ColumnIdentifier) GetDocumentPath() []*DocumentPathItem {
	if m != nil {
		return m.DocumentPath
	}
	return nil
}

func (m *ColumnIdentifier) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ColumnIdentifier) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *ColumnIdentifier) GetSchemaName() string {
	if m != nil && m.SchemaName != nil {
		return *m.SchemaName
	}
	return ""
}

// function call: ``func(a, b, "1", 3)``
//
// .. productionlist::
//   function_call: `identifier` "(" [ `expr` ["," `expr` ]* ] ")"
type FunctionCall struct {
	Name             *Identifier `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Param            []*Expr     `protobuf:"bytes,2,rep,name=param" json:"param,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *FunctionCall) Reset()                    { *m = FunctionCall{} }
func (m *FunctionCall) String() string            { return proto.CompactTextString(m) }
func (*FunctionCall) ProtoMessage()               {}
func (*FunctionCall) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{4} }

func (m *FunctionCall) GetName() *Identifier {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FunctionCall) GetParam() []*Expr {
	if m != nil {
		return m.Param
	}
	return nil
}

// operator: ``<<(a, b)``
//
// .. note::
//
//   Non-authoritative list of operators implemented (case sensitive):
//
//   Nullary
//     * ``*``
//     * ``default``
//
//   Unary
//     * ``!``
//     * ``sign_plus``
//     * ``sign_minus``
//     * ``~``
//
//   Binary
//     * ``&&``
//     * ``||``
//     * ``xor``
//     * ``==``
//     * ``!=``
//     * ``>``
//     * ``>=``
//     * ``<``
//     * ``<=``
//     * ``&``
//     * ``|``
//     * ``^``
//     * ``<<``
//     * ``>>``
//     * ``+``
//     * ``-``
//     * ``*``
//     * ``/``
//     * ``div``
//     * ``%``
//     * ``is``
//     * ``is_not``
//     * ``regexp``
//     * ``not_regexp``
//     * ``like``
//     * ``not_like``
//     * ``cast``
//
//   Using special representation, with more than 2 params
//     * ``in`` (param[0] IN (param[1], param[2], ...))
//     * ``not_in`` (param[0] NOT IN (param[1], param[2], ...))
//
//   Ternary
//     * ``between``
//     * ``between_not``
//     * ``date_add``
//     * ``date_sub``
//
//   Units for date_add/date_sub
//     * ``MICROSECOND``
//     * ``SECOND``
//     * ``MINUTE``
//     * ``HOUR``
//     * ``DAY``
//     * ``WEEK``
//     * ``MONTH``
//     * ``QUARTER``
//     * ``YEAR``
//     * ``SECOND_MICROSECOND``
//     * ``MINUTE_MICROSECOND``
//     * ``MINUTE_SECOND``
//     * ``HOUR_MICROSECOND``
//     * ``HOUR_SECOND``
//     * ``HOUR_MINUTE``
//     * ``DAY_MICROSECOND``
//     * ``DAY_SECOND``
//     * ``DAY_MINUTE``
//     * ``DAY_HOUR``
//
//   Types for cast
//     * ``BINARY[(N)]``
//     * ``CHAR[(N)]``
//     * ``DATE``
//     * ``DATETIME``
//     * ``DECIMAL[(M[,D])]``
//     * ``JSON``
//     * ``SIGNED [INTEGER]``
//     * ``TIME``
//     * ``UNSIGNED [INTEGER]``
//
// .. productionlist::
//   operator: `name` "(" [ `expr` ["," `expr` ]* ] ")"
type Operator struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Param            []*Expr `protobuf:"bytes,2,rep,name=param" json:"param,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Operator) Reset()                    { *m = Operator{} }
func (m *Operator) String() string            { return proto.CompactTextString(m) }
func (*Operator) ProtoMessage()               {}
func (*Operator) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{5} }

func (m *Operator) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Operator) GetParam() []*Expr {
	if m != nil {
		return m.Param
	}
	return nil
}

// an object (with expression values)
type Object struct {
	Fld              []*Object_ObjectField `protobuf:"bytes,1,rep,name=fld" json:"fld,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *Object) Reset()                    { *m = Object{} }
func (m *Object) String() string            { return proto.CompactTextString(m) }
func (*Object) ProtoMessage()               {}
func (*Object) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{6} }

func (m *Object) GetFld() []*Object_ObjectField {
	if m != nil {
		return m.Fld
	}
	return nil
}

type Object_ObjectField struct {
	Key              *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            *Expr   `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Object_ObjectField) Reset()                    { *m = Object_ObjectField{} }
func (m *Object_ObjectField) String() string            { return proto.CompactTextString(m) }
func (*Object_ObjectField) ProtoMessage()               {}
func (*Object_ObjectField) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{6, 0} }

func (m *Object_ObjectField) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *Object_ObjectField) GetValue() *Expr {
	if m != nil {
		return m.Value
	}
	return nil
}

// a Array of expressions
type Array struct {
	Value            []*Expr `protobuf:"bytes,1,rep,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Array) Reset()                    { *m = Array{} }
func (m *Array) String() string            { return proto.CompactTextString(m) }
func (*Array) ProtoMessage()               {}
func (*Array) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxExpr, []int{7} }

func (m *Array) GetValue() []*Expr {
	if m != nil {
		return m.Value
	}
	return nil
}

func init() {
	proto.RegisterType((*Expr)(nil), "Mysqlx.Expr.Expr")
	proto.RegisterType((*Identifier)(nil), "Mysqlx.Expr.Identifier")
	proto.RegisterType((*DocumentPathItem)(nil), "Mysqlx.Expr.DocumentPathItem")
	proto.RegisterType((*ColumnIdentifier)(nil), "Mysqlx.Expr.ColumnIdentifier")
	proto.RegisterType((*FunctionCall)(nil), "Mysqlx.Expr.FunctionCall")
	proto.RegisterType((*Operator)(nil), "Mysqlx.Expr.Operator")
	proto.RegisterType((*Object)(nil), "Mysqlx.Expr.Object")
	proto.RegisterType((*Object_ObjectField)(nil), "Mysqlx.Expr.Object.ObjectField")
	proto.RegisterType((*Array)(nil), "Mysqlx.Expr.Array")
	proto.RegisterEnum("Mysqlx.Expr.Expr_Type", Expr_Type_name, Expr_Type_value)
	proto.RegisterEnum("Mysqlx.Expr.DocumentPathItem_Type", DocumentPathItem_Type_name, DocumentPathItem_Type_value)
}
func (m *Expr) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expr) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(*m.Type))
	}
	if m.Identifier != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(m.Identifier.Size()))
		n1, err := m.Identifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Variable != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(len(*m.Variable)))
		i += copy(dAtA[i:], *m.Variable)
	}
	if m.Literal != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(m.Literal.Size()))
		n2, err := m.Literal.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.FunctionCall != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(m.FunctionCall.Size()))
		n3, err := m.FunctionCall.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Operator != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(m.Operator.Size()))
		n4, err := m.Operator.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Position != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(*m.Position))
	}
	if m.Object != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(m.Object.Size()))
		n5, err := m.Object.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Array != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(m.Array.Size()))
		n6, err := m.Array.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Identifier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Identifier) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.SchemaName != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(len(*m.SchemaName)))
		i += copy(dAtA[i:], *m.SchemaName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DocumentPathItem) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DocumentPathItem) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(*m.Type))
	}
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(len(*m.Value)))
		i += copy(dAtA[i:], *m.Value)
	}
	if m.Index != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(*m.Index))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ColumnIdentifier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ColumnIdentifier) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DocumentPath) > 0 {
		for _, msg := range m.DocumentPath {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMysqlxExpr(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Name != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.TableName != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(len(*m.TableName)))
		i += copy(dAtA[i:], *m.TableName)
	}
	if m.SchemaName != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(len(*m.SchemaName)))
		i += copy(dAtA[i:], *m.SchemaName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FunctionCall) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FunctionCall) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(m.Name.Size()))
		n7, err := m.Name.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if len(m.Param) > 0 {
		for _, msg := range m.Param {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMysqlxExpr(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Operator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Operator) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if len(m.Param) > 0 {
		for _, msg := range m.Param {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMysqlxExpr(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Object) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Object) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Fld) > 0 {
		for _, msg := range m.Fld {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMysqlxExpr(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Object_ObjectField) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Object_ObjectField) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(len(*m.Key)))
		i += copy(dAtA[i:], *m.Key)
	}
	if m.Value == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxExpr(dAtA, i, uint64(m.Value.Size()))
		n8, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Array) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Array) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		for _, msg := range m.Value {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMysqlxExpr(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintMysqlxExpr(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Expr) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMysqlxExpr(uint64(*m.Type))
	}
	if m.Identifier != nil {
		l = m.Identifier.Size()
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.Variable != nil {
		l = len(*m.Variable)
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.Literal != nil {
		l = m.Literal.Size()
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.FunctionCall != nil {
		l = m.FunctionCall.Size()
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.Operator != nil {
		l = m.Operator.Size()
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.Position != nil {
		n += 1 + sovMysqlxExpr(uint64(*m.Position))
	}
	if m.Object != nil {
		l = m.Object.Size()
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.Array != nil {
		l = m.Array.Size()
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Identifier) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.SchemaName != nil {
		l = len(*m.SchemaName)
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DocumentPathItem) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMysqlxExpr(uint64(*m.Type))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.Index != nil {
		n += 1 + sovMysqlxExpr(uint64(*m.Index))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ColumnIdentifier) Size() (n int) {
	var l int
	_ = l
	if len(m.DocumentPath) > 0 {
		for _, e := range m.DocumentPath {
			l = e.Size()
			n += 1 + l + sovMysqlxExpr(uint64(l))
		}
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.TableName != nil {
		l = len(*m.TableName)
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.SchemaName != nil {
		l = len(*m.SchemaName)
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FunctionCall) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = m.Name.Size()
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if len(m.Param) > 0 {
		for _, e := range m.Param {
			l = e.Size()
			n += 1 + l + sovMysqlxExpr(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Operator) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if len(m.Param) > 0 {
		for _, e := range m.Param {
			l = e.Size()
			n += 1 + l + sovMysqlxExpr(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Object) Size() (n int) {
	var l int
	_ = l
	if len(m.Fld) > 0 {
		for _, e := range m.Fld {
			l = e.Size()
			n += 1 + l + sovMysqlxExpr(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Object_ObjectField) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovMysqlxExpr(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Array) Size() (n int) {
	var l int
	_ = l
	if len(m.Value) > 0 {
		for _, e := range m.Value {
			l = e.Size()
			n += 1 + l + sovMysqlxExpr(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMysqlxExpr(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMysqlxExpr(x uint64) (n int) {
	return sovMysqlxExpr(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Expr) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Expr: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Expr: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Expr_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (Expr_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Identifier", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Identifier == nil {
				m.Identifier = &ColumnIdentifier{}
			}
			if err := m.Identifier.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Variable = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Literal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Literal == nil {
				m.Literal = &Mysqlx_Datatypes.Scalar{}
			}
			if err := m.Literal.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FunctionCall", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FunctionCall == nil {
				m.FunctionCall = &FunctionCall{}
			}
			if err := m.FunctionCall.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Operator == nil {
				m.Operator = &Operator{}
			}
			if err := m.Operator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Position", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Position = &v
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Object == nil {
				m.Object = &Object{}
			}
			if err := m.Object.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Array", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Array == nil {
				m.Array = &Array{}
			}
			if err := m.Array.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxExpr(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Identifier) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Identifier: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Identifier: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.SchemaName = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxExpr(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DocumentPathItem) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DocumentPathItem: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DocumentPathItem: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v DocumentPathItem_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (DocumentPathItem_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Index = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxExpr(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ColumnIdentifier) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ColumnIdentifier: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ColumnIdentifier: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DocumentPath", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DocumentPath = append(m.DocumentPath, &DocumentPathItem{})
			if err := m.DocumentPath[len(m.DocumentPath)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.TableName = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.SchemaName = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxExpr(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FunctionCall) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FunctionCall: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FunctionCall: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Name == nil {
				m.Name = &Identifier{}
			}
			if err := m.Name.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Param", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Param = append(m.Param, &Expr{})
			if err := m.Param[len(m.Param)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxExpr(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Operator) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Operator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Operator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Param", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Param = append(m.Param, &Expr{})
			if err := m.Param[len(m.Param)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxExpr(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Object) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Object: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Object: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Fld", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Fld = append(m.Fld, &Object_ObjectField{})
			if err := m.Fld[len(m.Fld)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxExpr(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Object_ObjectField) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ObjectField: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ObjectField: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Key = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Expr{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxExpr(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Array) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Array: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Array: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value, &Expr{})
			if err := m.Value[len(m.Value)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxExpr(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxExpr
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMysqlxExpr(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMysqlxExpr
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMysqlxExpr
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMysqlxExpr
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMysqlxExpr
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMysqlxExpr(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMysqlxExpr = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMysqlxExpr   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/pingcap/tipb/go-mysqlx/Expr/mysqlx_expr.proto", fileDescriptorMysqlxExpr)
}

var fileDescriptorMysqlxExpr = []byte{
	// 752 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x54, 0xdd, 0x72, 0xda, 0x46,
	0x14, 0xae, 0x40, 0xe2, 0xe7, 0x00, 0xb5, 0xba, 0x76, 0x5b, 0xd5, 0x53, 0x63, 0x46, 0x37, 0x66,
	0xea, 0x19, 0x5c, 0x73, 0xd1, 0xbb, 0x76, 0x46, 0x80, 0x5c, 0xd3, 0xca, 0xe0, 0x59, 0xe3, 0x4c,
	0x72, 0xc5, 0xac, 0xa5, 0x25, 0x96, 0x23, 0x21, 0x59, 0x08, 0x0f, 0x3c, 0x40, 0xde, 0x21, 0x93,
	0x47, 0xc8, 0x93, 0xe4, 0x32, 0x6f, 0x90, 0x8c, 0xf3, 0x22, 0x99, 0xdd, 0x15, 0x20, 0xf9, 0x67,
	0x26, 0x37, 0xb0, 0x7b, 0xbe, 0xef, 0x3b, 0x3a, 0xbf, 0x0b, 0x7b, 0x67, 0xcb, 0xd9, 0xad, 0xb7,
	0x38, 0x32, 0x17, 0x61, 0x74, 0xe4, 0xf3, 0xf3, 0x98, 0x2e, 0xc2, 0xa8, 0x15, 0x46, 0x41, 0x1c,
	0xa0, 0x8a, 0x80, 0x5b, 0x0c, 0xde, 0x3d, 0x48, 0xb8, 0x3d, 0x12, 0x93, 0x78, 0x19, 0xd2, 0xd9,
	0x4a, 0xe0, 0xac, 0x0c, 0x42, 0xa5, 0xbf, 0x97, 0x41, 0x66, 0x0a, 0xf4, 0x07, 0xc8, 0xcc, 0xae,
	0x49, 0x8d, 0x5c, 0xf3, 0xc7, 0xf6, 0x2f, 0xad, 0x94, 0x37, 0xf1, 0x33, 0x5a, 0x86, 0x14, 0x73,
	0x0e, 0xfa, 0x1b, 0xc0, 0x75, 0xe8, 0x34, 0x76, 0x27, 0x2e, 0x8d, 0xb4, 0x5c, 0x43, 0x6a, 0x56,
	0xda, 0x7b, 0x19, 0x45, 0x37, 0xf0, 0xe6, 0xfe, 0xb4, 0xbf, 0x26, 0xe1, 0x94, 0x00, 0xed, 0x42,
	0xe9, 0x8e, 0x44, 0x2e, 0xb9, 0xf2, 0xa8, 0x96, 0x6f, 0x48, 0xcd, 0x32, 0x5e, 0xdf, 0x51, 0x1b,
	0x8a, 0x9e, 0x1b, 0xd3, 0x88, 0x78, 0x9a, 0xcc, 0xfd, 0x6a, 0x2b, 0xbf, 0xeb, 0x54, 0x5a, 0x17,
	0x36, 0xf1, 0x48, 0x84, 0x57, 0x44, 0xf4, 0x0f, 0xd4, 0x26, 0xf3, 0xa9, 0x1d, 0xbb, 0xc1, 0x74,
	0x6c, 0x13, 0xcf, 0xd3, 0x14, 0xae, 0xfc, 0x2d, 0x13, 0xd1, 0x49, 0xc2, 0xe8, 0x12, 0xcf, 0xc3,
	0xd5, 0x49, 0xea, 0x86, 0x8e, 0xa1, 0x14, 0x84, 0x34, 0x22, 0x71, 0x10, 0x69, 0x05, 0x2e, 0xfd,
	0x39, 0x23, 0x1d, 0x26, 0x20, 0x5e, 0xd3, 0x58, 0x0a, 0x61, 0x30, 0x73, 0x99, 0x0b, 0xad, 0xd8,
	0x90, 0x9a, 0x35, 0xbc, 0xbe, 0xa3, 0x43, 0x28, 0x04, 0x57, 0x37, 0xd4, 0x8e, 0xb5, 0x12, 0x77,
	0xb6, 0x9d, 0x75, 0xc6, 0x21, 0x9c, 0x50, 0x50, 0x13, 0x14, 0x12, 0x45, 0x64, 0xa9, 0x95, 0x39,
	0x17, 0x65, 0xb8, 0x06, 0x43, 0xb0, 0x20, 0xe8, 0xb7, 0x20, 0xb3, 0x16, 0xa0, 0x32, 0x28, 0xfd,
	0x9e, 0x39, 0x18, 0xa9, 0x12, 0xaa, 0x40, 0xd1, 0xea, 0x8f, 0x4c, 0x6c, 0x58, 0x6a, 0x0e, 0x55,
	0xa1, 0xf4, 0xc2, 0xc0, 0x7d, 0xa3, 0x63, 0x99, 0x6a, 0x1e, 0xd5, 0xa0, 0x7c, 0x72, 0x39, 0xe8,
	0x8e, 0xbb, 0x86, 0x65, 0xa9, 0x32, 0x03, 0x87, 0xe7, 0x26, 0x36, 0x46, 0x43, 0xac, 0x2a, 0x68,
	0x0b, 0x2a, 0xe7, 0x96, 0xd1, 0x35, 0x4f, 0x87, 0x56, 0xcf, 0xc4, 0x6a, 0x01, 0x01, 0x14, 0x86,
	0x9d, 0xff, 0xcc, 0xee, 0x48, 0x2d, 0x32, 0xff, 0x06, 0xc6, 0xc6, 0x2b, 0xb5, 0xa4, 0x1b, 0x00,
	0x9b, 0x16, 0x22, 0x04, 0xf2, 0x94, 0xf8, 0x62, 0x42, 0xca, 0x98, 0x9f, 0xd1, 0x3e, 0x54, 0x66,
	0xf6, 0x35, 0xf5, 0xc9, 0x98, 0x43, 0x39, 0xde, 0x4d, 0x10, 0xa6, 0x01, 0xf1, 0xa9, 0xfe, 0x59,
	0x02, 0xb5, 0x17, 0xd8, 0x73, 0x9f, 0x4e, 0xe3, 0x73, 0x12, 0x5f, 0xf7, 0x63, 0xea, 0xa3, 0xbf,
	0x32, 0xb3, 0xa6, 0x67, 0x72, 0x7e, 0x48, 0x4e, 0xcf, 0xdd, 0x0e, 0x28, 0x77, 0xc4, 0x9b, 0xaf,
	0xbe, 0x23, 0x2e, 0xcc, 0xea, 0x4e, 0x1d, 0xba, 0xe0, 0xb3, 0x54, 0xc3, 0xe2, 0xa2, 0xbf, 0x4e,
	0xca, 0x05, 0x50, 0x38, 0x33, 0xcf, 0x3a, 0x26, 0x56, 0x25, 0xb4, 0x0d, 0x5b, 0xe2, 0x3c, 0x36,
	0x2e, 0x46, 0x26, 0xee, 0x5f, 0xfc, 0xaf, 0xe6, 0x58, 0x31, 0x78, 0xbe, 0xe3, 0xfe, 0xa0, 0x67,
	0xbe, 0x54, 0xf3, 0x48, 0x83, 0x9d, 0x94, 0x61, 0x43, 0x95, 0x99, 0xbe, 0x37, 0xbc, 0xec, 0x58,
	0xe6, 0xc6, 0xa8, 0xe8, 0x1f, 0x24, 0x50, 0x1f, 0x8e, 0x3b, 0xea, 0x40, 0xcd, 0x49, 0x12, 0x19,
	0x87, 0x24, 0xbe, 0xd6, 0xa4, 0x46, 0xfe, 0xd1, 0x92, 0x3c, 0x4c, 0x15, 0x57, 0x9d, 0x94, 0x65,
	0x5d, 0x6f, 0x91, 0xac, 0xa8, 0xf7, 0x1e, 0x40, 0xcc, 0xf6, 0x44, 0x94, 0x5b, 0x2c, 0x4f, 0x99,
	0x5b, 0x06, 0x4f, 0xb4, 0x43, 0x7e, 0xd4, 0x0e, 0x07, 0xaa, 0xe9, 0x45, 0x40, 0x87, 0xa9, 0x9e,
	0x56, 0xda, 0xbf, 0x66, 0xc2, 0x4b, 0x6d, 0xaf, 0xf8, 0xf8, 0x01, 0x28, 0x21, 0x89, 0x88, 0xaf,
	0xe5, 0x78, 0x32, 0x3f, 0x3d, 0x7a, 0x23, 0xb0, 0xc0, 0xf5, 0x7f, 0xa1, 0xb4, 0xda, 0x99, 0x27,
	0xa7, 0xe6, 0xbb, 0x1d, 0xbd, 0x95, 0xa0, 0x20, 0x16, 0x06, 0x1d, 0x43, 0x7e, 0xe2, 0x39, 0x49,
	0x1d, 0xf7, 0x9f, 0x58, 0xa9, 0xe4, 0xef, 0xc4, 0xa5, 0x9e, 0x83, 0x19, 0x77, 0xf7, 0x14, 0x2a,
	0x29, 0x1b, 0x52, 0x21, 0xff, 0x86, 0x2e, 0x93, 0x40, 0xd8, 0x91, 0xc5, 0xb1, 0x9a, 0xa7, 0xdc,
	0x33, 0x71, 0x70, 0x5c, 0xff, 0x13, 0x14, 0xbe, 0x8b, 0x1b, 0x85, 0xf4, 0x6c, 0xe4, 0x1c, 0xef,
	0xb4, 0x3e, 0xde, 0xd7, 0xa5, 0x4f, 0xf7, 0x75, 0xe9, 0xcb, 0x7d, 0x5d, 0x7a, 0xf7, 0xb5, 0xfe,
	0x03, 0xfc, 0x6e, 0x07, 0x7e, 0x8b, 0xbf, 0xc2, 0x2d, 0xfb, 0x46, 0x1c, 0x16, 0xe2, 0x11, 0xbe,
	0x9a, 0x4f, 0xbe, 0x05, 0x00, 0x00, 0xff, 0xff, 0x35, 0x4f, 0xc9, 0xba, 0xdd, 0x05, 0x00, 0x00,
}
