// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/pingcap/tipb/go-mysqlx/Crud/mysqlx_crud.proto

/*
	Package Mysqlx_Crud is a generated protocol buffer package.

	Basic CRUD operations

	It is generated from these files:
		github.com/pingcap/tipb/go-mysqlx/Crud/mysqlx_crud.proto

	It has these top-level messages:
		Column
		Projection
		Collection
		Limit
		Order
		UpdateOperation
		Find
		Insert
		Update
		Delete
		CreateView
		ModifyView
		DropView
*/
package Mysqlx_Crud

import (
	"fmt"

	proto "github.com/golang/protobuf/proto"

	math "math"

	Mysqlx_Expr "github.com/pingcap/tipb/go-mysqlx/Expr"

	Mysqlx_Datatypes "github.com/pingcap/tipb/go-mysqlx/Datatypes"

	github_com_golang_protobuf_proto "github.com/golang/protobuf/proto"

	io "io"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// DataModel to use for filters, names, ...
type DataModel int32

const (
	DataModel_DOCUMENT DataModel = 1
	DataModel_TABLE    DataModel = 2
)

var DataModel_name = map[int32]string{
	1: "DOCUMENT",
	2: "TABLE",
}
var DataModel_value = map[string]int32{
	"DOCUMENT": 1,
	"TABLE":    2,
}

func (x DataModel) Enum() *DataModel {
	p := new(DataModel)
	*p = x
	return p
}
func (x DataModel) String() string {
	return proto.EnumName(DataModel_name, int32(x))
}
func (x *DataModel) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(DataModel_value, data, "DataModel")
	if err != nil {
		return err
	}
	*x = DataModel(value)
	return nil
}
func (DataModel) EnumDescriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{0} }

// ViewAlgorithm defines how MySQL Server processes the view
type ViewAlgorithm int32

const (
	ViewAlgorithm_UNDEFINED ViewAlgorithm = 1
	ViewAlgorithm_MERGE     ViewAlgorithm = 2
	ViewAlgorithm_TEMPTABLE ViewAlgorithm = 3
)

var ViewAlgorithm_name = map[int32]string{
	1: "UNDEFINED",
	2: "MERGE",
	3: "TEMPTABLE",
}
var ViewAlgorithm_value = map[string]int32{
	"UNDEFINED": 1,
	"MERGE":     2,
	"TEMPTABLE": 3,
}

func (x ViewAlgorithm) Enum() *ViewAlgorithm {
	p := new(ViewAlgorithm)
	*p = x
	return p
}
func (x ViewAlgorithm) String() string {
	return proto.EnumName(ViewAlgorithm_name, int32(x))
}
func (x *ViewAlgorithm) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ViewAlgorithm_value, data, "ViewAlgorithm")
	if err != nil {
		return err
	}
	*x = ViewAlgorithm(value)
	return nil
}
func (ViewAlgorithm) EnumDescriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{1} }

// ViewSqlSecurity defines the security context in which the view is going to be
// executed, this means that VIEW can be executed with current user permissions or
// with permissions of the uses who defined the VIEW
type ViewSqlSecurity int32

const (
	ViewSqlSecurity_INVOKER ViewSqlSecurity = 1
	ViewSqlSecurity_DEFINER ViewSqlSecurity = 2
)

var ViewSqlSecurity_name = map[int32]string{
	1: "INVOKER",
	2: "DEFINER",
}
var ViewSqlSecurity_value = map[string]int32{
	"INVOKER": 1,
	"DEFINER": 2,
}

func (x ViewSqlSecurity) Enum() *ViewSqlSecurity {
	p := new(ViewSqlSecurity)
	*p = x
	return p
}
func (x ViewSqlSecurity) String() string {
	return proto.EnumName(ViewSqlSecurity_name, int32(x))
}
func (x *ViewSqlSecurity) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ViewSqlSecurity_value, data, "ViewSqlSecurity")
	if err != nil {
		return err
	}
	*x = ViewSqlSecurity(value)
	return nil
}
func (ViewSqlSecurity) EnumDescriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{2} }

// ViewCheckOption limits the write operations done on a `VIEW`
// (`INSERT`, `UPDATE`, `DELETE`) to rows in which the `WHERE` clause is `TRUE`
type ViewCheckOption int32

const (
	ViewCheckOption_LOCAL    ViewCheckOption = 1
	ViewCheckOption_CASCADED ViewCheckOption = 2
)

var ViewCheckOption_name = map[int32]string{
	1: "LOCAL",
	2: "CASCADED",
}
var ViewCheckOption_value = map[string]int32{
	"LOCAL":    1,
	"CASCADED": 2,
}

func (x ViewCheckOption) Enum() *ViewCheckOption {
	p := new(ViewCheckOption)
	*p = x
	return p
}
func (x ViewCheckOption) String() string {
	return proto.EnumName(ViewCheckOption_name, int32(x))
}
func (x *ViewCheckOption) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ViewCheckOption_value, data, "ViewCheckOption")
	if err != nil {
		return err
	}
	*x = ViewCheckOption(value)
	return nil
}
func (ViewCheckOption) EnumDescriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{3} }

type Order_Direction int32

const (
	Order_ASC  Order_Direction = 1
	Order_DESC Order_Direction = 2
)

var Order_Direction_name = map[int32]string{
	1: "ASC",
	2: "DESC",
}
var Order_Direction_value = map[string]int32{
	"ASC":  1,
	"DESC": 2,
}

func (x Order_Direction) Enum() *Order_Direction {
	p := new(Order_Direction)
	*p = x
	return p
}
func (x Order_Direction) String() string {
	return proto.EnumName(Order_Direction_name, int32(x))
}
func (x *Order_Direction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Order_Direction_value, data, "Order_Direction")
	if err != nil {
		return err
	}
	*x = Order_Direction(value)
	return nil
}
func (Order_Direction) EnumDescriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{4, 0} }

type UpdateOperation_UpdateType int32

const (
	UpdateOperation_SET          UpdateOperation_UpdateType = 1
	UpdateOperation_ITEM_REMOVE  UpdateOperation_UpdateType = 2
	UpdateOperation_ITEM_SET     UpdateOperation_UpdateType = 3
	UpdateOperation_ITEM_REPLACE UpdateOperation_UpdateType = 4
	UpdateOperation_ITEM_MERGE   UpdateOperation_UpdateType = 5
	UpdateOperation_ARRAY_INSERT UpdateOperation_UpdateType = 6
	UpdateOperation_ARRAY_APPEND UpdateOperation_UpdateType = 7
)

var UpdateOperation_UpdateType_name = map[int32]string{
	1: "SET",
	2: "ITEM_REMOVE",
	3: "ITEM_SET",
	4: "ITEM_REPLACE",
	5: "ITEM_MERGE",
	6: "ARRAY_INSERT",
	7: "ARRAY_APPEND",
}
var UpdateOperation_UpdateType_value = map[string]int32{
	"SET":          1,
	"ITEM_REMOVE":  2,
	"ITEM_SET":     3,
	"ITEM_REPLACE": 4,
	"ITEM_MERGE":   5,
	"ARRAY_INSERT": 6,
	"ARRAY_APPEND": 7,
}

func (x UpdateOperation_UpdateType) Enum() *UpdateOperation_UpdateType {
	p := new(UpdateOperation_UpdateType)
	*p = x
	return p
}
func (x UpdateOperation_UpdateType) String() string {
	return proto.EnumName(UpdateOperation_UpdateType_name, int32(x))
}
func (x *UpdateOperation_UpdateType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(UpdateOperation_UpdateType_value, data, "UpdateOperation_UpdateType")
	if err != nil {
		return err
	}
	*x = UpdateOperation_UpdateType(value)
	return nil
}
func (UpdateOperation_UpdateType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMysqlxCrud, []int{5, 0}
}

// column definition
type Column struct {
	Name             *string                         `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Alias            *string                         `protobuf:"bytes,2,opt,name=alias" json:"alias,omitempty"`
	DocumentPath     []*Mysqlx_Expr.DocumentPathItem `protobuf:"bytes,3,rep,name=document_path,json=documentPath" json:"document_path,omitempty"`
	XXX_unrecognized []byte                          `json:"-"`
}

func (m *Column) Reset()                    { *m = Column{} }
func (m *Column) String() string            { return proto.CompactTextString(m) }
func (*Column) ProtoMessage()               {}
func (*Column) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{0} }

func (m *Column) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Column) GetAlias() string {
	if m != nil && m.Alias != nil {
		return *m.Alias
	}
	return ""
}

func (m *Column) GetDocumentPath() []*Mysqlx_Expr.DocumentPathItem {
	if m != nil {
		return m.DocumentPath
	}
	return nil
}

// a projection
//
// :param source: the expression identifying an element from the source data
//                which can include a column identifier or any expression
// :param alias: optional alias. Required for DOCUMENTs (clients may use
//              the source string as default)
type Projection struct {
	Source           *Mysqlx_Expr.Expr `protobuf:"bytes,1,req,name=source" json:"source,omitempty"`
	Alias            *string           `protobuf:"bytes,2,opt,name=alias" json:"alias,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Projection) Reset()                    { *m = Projection{} }
func (m *Projection) String() string            { return proto.CompactTextString(m) }
func (*Projection) ProtoMessage()               {}
func (*Projection) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{1} }

func (m *Projection) GetSource() *Mysqlx_Expr.Expr {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Projection) GetAlias() string {
	if m != nil && m.Alias != nil {
		return *m.Alias
	}
	return ""
}

// collection
type Collection struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Schema           *string `protobuf:"bytes,2,opt,name=schema" json:"schema,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Collection) Reset()                    { *m = Collection{} }
func (m *Collection) String() string            { return proto.CompactTextString(m) }
func (*Collection) ProtoMessage()               {}
func (*Collection) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{2} }

func (m *Collection) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Collection) GetSchema() string {
	if m != nil && m.Schema != nil {
		return *m.Schema
	}
	return ""
}

// limit
//
// :param row_count: maximum rows to filter
// :param offset: maximum rows to skip before applying the row_count
type Limit struct {
	RowCount         *uint64 `protobuf:"varint,1,req,name=row_count,json=rowCount" json:"row_count,omitempty"`
	Offset           *uint64 `protobuf:"varint,2,opt,name=offset" json:"offset,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Limit) Reset()                    { *m = Limit{} }
func (m *Limit) String() string            { return proto.CompactTextString(m) }
func (*Limit) ProtoMessage()               {}
func (*Limit) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{3} }

func (m *Limit) GetRowCount() uint64 {
	if m != nil && m.RowCount != nil {
		return *m.RowCount
	}
	return 0
}

func (m *Limit) GetOffset() uint64 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return 0
}

// sort order
type Order struct {
	Expr             *Mysqlx_Expr.Expr `protobuf:"bytes,1,req,name=expr" json:"expr,omitempty"`
	Direction        *Order_Direction  `protobuf:"varint,2,opt,name=direction,enum=Mysqlx.Crud.Order_Direction,def=1" json:"direction,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Order) Reset()                    { *m = Order{} }
func (m *Order) String() string            { return proto.CompactTextString(m) }
func (*Order) ProtoMessage()               {}
func (*Order) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{4} }

const Default_Order_Direction Order_Direction = Order_ASC

func (m *Order) GetExpr() *Mysqlx_Expr.Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (m *Order) GetDirection() Order_Direction {
	if m != nil && m.Direction != nil {
		return *m.Direction
	}
	return Default_Order_Direction
}

// update operations
//
// :param source: specification of the value to be updated
//      if data_model is TABLE, a column name may be specified and also a document path, if the column has type JSON
//      if data_model is DOCUMENT, only document paths are allowed
//      in both cases, schema and table must be not set
// :param operation: the type of operation to be performed
// :param value: an expression to be computed as the new value for the operation
type UpdateOperation struct {
	Source           *Mysqlx_Expr.ColumnIdentifier `protobuf:"bytes,1,req,name=source" json:"source,omitempty"`
	Operation        *UpdateOperation_UpdateType   `protobuf:"varint,2,req,name=operation,enum=Mysqlx.Crud.UpdateOperation_UpdateType" json:"operation,omitempty"`
	Value            *Mysqlx_Expr.Expr             `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte                        `json:"-"`
}

func (m *UpdateOperation) Reset()                    { *m = UpdateOperation{} }
func (m *UpdateOperation) String() string            { return proto.CompactTextString(m) }
func (*UpdateOperation) ProtoMessage()               {}
func (*UpdateOperation) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{5} }

func (m *UpdateOperation) GetSource() *Mysqlx_Expr.ColumnIdentifier {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *UpdateOperation) GetOperation() UpdateOperation_UpdateType {
	if m != nil && m.Operation != nil {
		return *m.Operation
	}
	return UpdateOperation_SET
}

func (m *UpdateOperation) GetValue() *Mysqlx_Expr.Expr {
	if m != nil {
		return m.Value
	}
	return nil
}

// Find Documents/Rows in a Collection/Table
//
// .. uml::
//
//   client -> server: Find
//   ... one or more Resultset ...
//
// :param collection: collection to insert into
// :param data_model: datamodel that the operations refer to
// :param projection: list of column projections that shall be returned
// :param args: values for parameters used in filter expression
// :param criteria: filter criteria
// :param limit: numbers of rows that shall be skipped and returned
// :param order: sort-order in which the rows/document shall be returned in
// :param grouping: column expression list for aggregation (GROUP BY)
// :param grouping_criteria: filter criteria for aggregated groups
// :Returns: :protobuf:msg:`Mysqlx.Resultset::`
type Find struct {
	Collection       *Collection                `protobuf:"bytes,2,req,name=collection" json:"collection,omitempty"`
	DataModel        *DataModel                 `protobuf:"varint,3,opt,name=data_model,json=dataModel,enum=Mysqlx.Crud.DataModel" json:"data_model,omitempty"`
	Projection       []*Projection              `protobuf:"bytes,4,rep,name=projection" json:"projection,omitempty"`
	Criteria         *Mysqlx_Expr.Expr          `protobuf:"bytes,5,opt,name=criteria" json:"criteria,omitempty"`
	Args             []*Mysqlx_Datatypes.Scalar `protobuf:"bytes,11,rep,name=args" json:"args,omitempty"`
	Limit            *Limit                     `protobuf:"bytes,6,opt,name=limit" json:"limit,omitempty"`
	Order            []*Order                   `protobuf:"bytes,7,rep,name=order" json:"order,omitempty"`
	Grouping         []*Mysqlx_Expr.Expr        `protobuf:"bytes,8,rep,name=grouping" json:"grouping,omitempty"`
	GroupingCriteria *Mysqlx_Expr.Expr          `protobuf:"bytes,9,opt,name=grouping_criteria,json=groupingCriteria" json:"grouping_criteria,omitempty"`
	XXX_unrecognized []byte                     `json:"-"`
}

func (m *Find) Reset()                    { *m = Find{} }
func (m *Find) String() string            { return proto.CompactTextString(m) }
func (*Find) ProtoMessage()               {}
func (*Find) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{6} }

func (m *Find) GetCollection() *Collection {
	if m != nil {
		return m.Collection
	}
	return nil
}

func (m *Find) GetDataModel() DataModel {
	if m != nil && m.DataModel != nil {
		return *m.DataModel
	}
	return DataModel_DOCUMENT
}

func (m *Find) GetProjection() []*Projection {
	if m != nil {
		return m.Projection
	}
	return nil
}

func (m *Find) GetCriteria() *Mysqlx_Expr.Expr {
	if m != nil {
		return m.Criteria
	}
	return nil
}

func (m *Find) GetArgs() []*Mysqlx_Datatypes.Scalar {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *Find) GetLimit() *Limit {
	if m != nil {
		return m.Limit
	}
	return nil
}

func (m *Find) GetOrder() []*Order {
	if m != nil {
		return m.Order
	}
	return nil
}

func (m *Find) GetGrouping() []*Mysqlx_Expr.Expr {
	if m != nil {
		return m.Grouping
	}
	return nil
}

func (m *Find) GetGroupingCriteria() *Mysqlx_Expr.Expr {
	if m != nil {
		return m.GroupingCriteria
	}
	return nil
}

// Insert documents/rows into a collection/table
//
// :param collection: collection to insert into
// :param data_model: datamodel that the operations refer to
// :param projection: name of the columns to insert data into (empty if data_model is DOCUMENT)
// :param row: set of rows to insert into the collection/table (a single expression with a JSON document literal or an OBJECT expression)
// :param args: values for parameters used in row expressions
// :Returns: :protobuf:msg:`Mysqlx.Resultset::`
type Insert struct {
	Collection       *Collection                `protobuf:"bytes,1,req,name=collection" json:"collection,omitempty"`
	DataModel        *DataModel                 `protobuf:"varint,2,opt,name=data_model,json=dataModel,enum=Mysqlx.Crud.DataModel" json:"data_model,omitempty"`
	Projection       []*Column                  `protobuf:"bytes,3,rep,name=projection" json:"projection,omitempty"`
	Row              []*Insert_TypedRow         `protobuf:"bytes,4,rep,name=row" json:"row,omitempty"`
	Args             []*Mysqlx_Datatypes.Scalar `protobuf:"bytes,5,rep,name=args" json:"args,omitempty"`
	XXX_unrecognized []byte                     `json:"-"`
}

func (m *Insert) Reset()                    { *m = Insert{} }
func (m *Insert) String() string            { return proto.CompactTextString(m) }
func (*Insert) ProtoMessage()               {}
func (*Insert) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{7} }

func (m *Insert) GetCollection() *Collection {
	if m != nil {
		return m.Collection
	}
	return nil
}

func (m *Insert) GetDataModel() DataModel {
	if m != nil && m.DataModel != nil {
		return *m.DataModel
	}
	return DataModel_DOCUMENT
}

func (m *Insert) GetProjection() []*Column {
	if m != nil {
		return m.Projection
	}
	return nil
}

func (m *Insert) GetRow() []*Insert_TypedRow {
	if m != nil {
		return m.Row
	}
	return nil
}

func (m *Insert) GetArgs() []*Mysqlx_Datatypes.Scalar {
	if m != nil {
		return m.Args
	}
	return nil
}

type Insert_TypedRow struct {
	Field            []*Mysqlx_Expr.Expr `protobuf:"bytes,1,rep,name=field" json:"field,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *Insert_TypedRow) Reset()                    { *m = Insert_TypedRow{} }
func (m *Insert_TypedRow) String() string            { return proto.CompactTextString(m) }
func (*Insert_TypedRow) ProtoMessage()               {}
func (*Insert_TypedRow) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{7, 0} }

func (m *Insert_TypedRow) GetField() []*Mysqlx_Expr.Expr {
	if m != nil {
		return m.Field
	}
	return nil
}

// Update documents/rows in a collection/table
//
// :param collection: collection to change
// :param data_model: datamodel that the operations refer to
// :param criteria: filter expression to match rows that the operations will apply on
// :param args: values for parameters used in filter expression
// :param limit: limits the number of rows to match
// :param order: specifies order of matched rows
// :param operation: list of operations to be applied. Valid operations will depend on the data_model.
// :Returns: :protobuf:msg:`Mysqlx.Resultset::`
type Update struct {
	Collection       *Collection                `protobuf:"bytes,2,req,name=collection" json:"collection,omitempty"`
	DataModel        *DataModel                 `protobuf:"varint,3,opt,name=data_model,json=dataModel,enum=Mysqlx.Crud.DataModel" json:"data_model,omitempty"`
	Criteria         *Mysqlx_Expr.Expr          `protobuf:"bytes,4,opt,name=criteria" json:"criteria,omitempty"`
	Args             []*Mysqlx_Datatypes.Scalar `protobuf:"bytes,8,rep,name=args" json:"args,omitempty"`
	Limit            *Limit                     `protobuf:"bytes,5,opt,name=limit" json:"limit,omitempty"`
	Order            []*Order                   `protobuf:"bytes,6,rep,name=order" json:"order,omitempty"`
	Operation        []*UpdateOperation         `protobuf:"bytes,7,rep,name=operation" json:"operation,omitempty"`
	XXX_unrecognized []byte                     `json:"-"`
}

func (m *Update) Reset()                    { *m = Update{} }
func (m *Update) String() string            { return proto.CompactTextString(m) }
func (*Update) ProtoMessage()               {}
func (*Update) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{8} }

func (m *Update) GetCollection() *Collection {
	if m != nil {
		return m.Collection
	}
	return nil
}

func (m *Update) GetDataModel() DataModel {
	if m != nil && m.DataModel != nil {
		return *m.DataModel
	}
	return DataModel_DOCUMENT
}

func (m *Update) GetCriteria() *Mysqlx_Expr.Expr {
	if m != nil {
		return m.Criteria
	}
	return nil
}

func (m *Update) GetArgs() []*Mysqlx_Datatypes.Scalar {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *Update) GetLimit() *Limit {
	if m != nil {
		return m.Limit
	}
	return nil
}

func (m *Update) GetOrder() []*Order {
	if m != nil {
		return m.Order
	}
	return nil
}

func (m *Update) GetOperation() []*UpdateOperation {
	if m != nil {
		return m.Operation
	}
	return nil
}

// Delete documents/rows from a Collection/Table
//
// :param collection: collection to change
// :param data_model: datamodel that the operations refer to
// :param criteria: filter expression to match rows that the operations will apply on
// :param args: values for parameters used in filter expression
// :param limit: limits the number of rows to match
// :param order: specifies order of matched rows
// :Returns: :protobuf:msg:`Mysqlx.Resultset::`
type Delete struct {
	Collection       *Collection                `protobuf:"bytes,1,req,name=collection" json:"collection,omitempty"`
	DataModel        *DataModel                 `protobuf:"varint,2,opt,name=data_model,json=dataModel,enum=Mysqlx.Crud.DataModel" json:"data_model,omitempty"`
	Criteria         *Mysqlx_Expr.Expr          `protobuf:"bytes,3,opt,name=criteria" json:"criteria,omitempty"`
	Args             []*Mysqlx_Datatypes.Scalar `protobuf:"bytes,6,rep,name=args" json:"args,omitempty"`
	Limit            *Limit                     `protobuf:"bytes,4,opt,name=limit" json:"limit,omitempty"`
	Order            []*Order                   `protobuf:"bytes,5,rep,name=order" json:"order,omitempty"`
	XXX_unrecognized []byte                     `json:"-"`
}

func (m *Delete) Reset()                    { *m = Delete{} }
func (m *Delete) String() string            { return proto.CompactTextString(m) }
func (*Delete) ProtoMessage()               {}
func (*Delete) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{9} }

func (m *Delete) GetCollection() *Collection {
	if m != nil {
		return m.Collection
	}
	return nil
}

func (m *Delete) GetDataModel() DataModel {
	if m != nil && m.DataModel != nil {
		return *m.DataModel
	}
	return DataModel_DOCUMENT
}

func (m *Delete) GetCriteria() *Mysqlx_Expr.Expr {
	if m != nil {
		return m.Criteria
	}
	return nil
}

func (m *Delete) GetArgs() []*Mysqlx_Datatypes.Scalar {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *Delete) GetLimit() *Limit {
	if m != nil {
		return m.Limit
	}
	return nil
}

func (m *Delete) GetOrder() []*Order {
	if m != nil {
		return m.Order
	}
	return nil
}

type CreateView struct {
	Collection       *Collection      `protobuf:"bytes,1,req,name=collection" json:"collection,omitempty"`
	Definer          *string          `protobuf:"bytes,2,opt,name=definer" json:"definer,omitempty"`
	Algorithm        *ViewAlgorithm   `protobuf:"varint,3,opt,name=algorithm,enum=Mysqlx.Crud.ViewAlgorithm,def=1" json:"algorithm,omitempty"`
	Security         *ViewSqlSecurity `protobuf:"varint,4,opt,name=security,enum=Mysqlx.Crud.ViewSqlSecurity,def=2" json:"security,omitempty"`
	Check            *ViewCheckOption `protobuf:"varint,5,opt,name=check,enum=Mysqlx.Crud.ViewCheckOption" json:"check,omitempty"`
	Column           []string         `protobuf:"bytes,6,rep,name=column" json:"column,omitempty"`
	Stmt             *Find            `protobuf:"bytes,7,req,name=stmt" json:"stmt,omitempty"`
	ReplaceExisting  *bool            `protobuf:"varint,8,opt,name=replace_existing,json=replaceExisting,def=0" json:"replace_existing,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *CreateView) Reset()                    { *m = CreateView{} }
func (m *CreateView) String() string            { return proto.CompactTextString(m) }
func (*CreateView) ProtoMessage()               {}
func (*CreateView) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{10} }

const Default_CreateView_Algorithm ViewAlgorithm = ViewAlgorithm_UNDEFINED
const Default_CreateView_Security ViewSqlSecurity = ViewSqlSecurity_DEFINER
const Default_CreateView_ReplaceExisting bool = false

func (m *CreateView) GetCollection() *Collection {
	if m != nil {
		return m.Collection
	}
	return nil
}

func (m *CreateView) GetDefiner() string {
	if m != nil && m.Definer != nil {
		return *m.Definer
	}
	return ""
}

func (m *CreateView) GetAlgorithm() ViewAlgorithm {
	if m != nil && m.Algorithm != nil {
		return *m.Algorithm
	}
	return Default_CreateView_Algorithm
}

func (m *CreateView) GetSecurity() ViewSqlSecurity {
	if m != nil && m.Security != nil {
		return *m.Security
	}
	return Default_CreateView_Security
}

func (m *CreateView) GetCheck() ViewCheckOption {
	if m != nil && m.Check != nil {
		return *m.Check
	}
	return ViewCheckOption_LOCAL
}

func (m *CreateView) GetColumn() []string {
	if m != nil {
		return m.Column
	}
	return nil
}

func (m *CreateView) GetStmt() *Find {
	if m != nil {
		return m.Stmt
	}
	return nil
}

func (m *CreateView) GetReplaceExisting() bool {
	if m != nil && m.ReplaceExisting != nil {
		return *m.ReplaceExisting
	}
	return Default_CreateView_ReplaceExisting
}

type ModifyView struct {
	Collection       *Collection      `protobuf:"bytes,1,req,name=collection" json:"collection,omitempty"`
	Definer          *string          `protobuf:"bytes,2,opt,name=definer" json:"definer,omitempty"`
	Algorithm        *ViewAlgorithm   `protobuf:"varint,3,opt,name=algorithm,enum=Mysqlx.Crud.ViewAlgorithm" json:"algorithm,omitempty"`
	Security         *ViewSqlSecurity `protobuf:"varint,4,opt,name=security,enum=Mysqlx.Crud.ViewSqlSecurity" json:"security,omitempty"`
	Check            *ViewCheckOption `protobuf:"varint,5,opt,name=check,enum=Mysqlx.Crud.ViewCheckOption" json:"check,omitempty"`
	Column           []string         `protobuf:"bytes,6,rep,name=column" json:"column,omitempty"`
	Stmt             *Find            `protobuf:"bytes,7,opt,name=stmt" json:"stmt,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ModifyView) Reset()                    { *m = ModifyView{} }
func (m *ModifyView) String() string            { return proto.CompactTextString(m) }
func (*ModifyView) ProtoMessage()               {}
func (*ModifyView) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{11} }

func (m *ModifyView) GetCollection() *Collection {
	if m != nil {
		return m.Collection
	}
	return nil
}

func (m *ModifyView) GetDefiner() string {
	if m != nil && m.Definer != nil {
		return *m.Definer
	}
	return ""
}

func (m *ModifyView) GetAlgorithm() ViewAlgorithm {
	if m != nil && m.Algorithm != nil {
		return *m.Algorithm
	}
	return ViewAlgorithm_UNDEFINED
}

func (m *ModifyView) GetSecurity() ViewSqlSecurity {
	if m != nil && m.Security != nil {
		return *m.Security
	}
	return ViewSqlSecurity_INVOKER
}

func (m *ModifyView) GetCheck() ViewCheckOption {
	if m != nil && m.Check != nil {
		return *m.Check
	}
	return ViewCheckOption_LOCAL
}

func (m *ModifyView) GetColumn() []string {
	if m != nil {
		return m.Column
	}
	return nil
}

func (m *ModifyView) GetStmt() *Find {
	if m != nil {
		return m.Stmt
	}
	return nil
}

type DropView struct {
	Collection       *Collection `protobuf:"bytes,1,req,name=collection" json:"collection,omitempty"`
	IfExists         *bool       `protobuf:"varint,2,opt,name=if_exists,json=ifExists,def=0" json:"if_exists,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *DropView) Reset()                    { *m = DropView{} }
func (m *DropView) String() string            { return proto.CompactTextString(m) }
func (*DropView) ProtoMessage()               {}
func (*DropView) Descriptor() ([]byte, []int) { return fileDescriptorMysqlxCrud, []int{12} }

const Default_DropView_IfExists bool = false

func (m *DropView) GetCollection() *Collection {
	if m != nil {
		return m.Collection
	}
	return nil
}

func (m *DropView) GetIfExists() bool {
	if m != nil && m.IfExists != nil {
		return *m.IfExists
	}
	return Default_DropView_IfExists
}

func init() {
	proto.RegisterType((*Column)(nil), "Mysqlx.Crud.Column")
	proto.RegisterType((*Projection)(nil), "Mysqlx.Crud.Projection")
	proto.RegisterType((*Collection)(nil), "Mysqlx.Crud.Collection")
	proto.RegisterType((*Limit)(nil), "Mysqlx.Crud.Limit")
	proto.RegisterType((*Order)(nil), "Mysqlx.Crud.Order")
	proto.RegisterType((*UpdateOperation)(nil), "Mysqlx.Crud.UpdateOperation")
	proto.RegisterType((*Find)(nil), "Mysqlx.Crud.Find")
	proto.RegisterType((*Insert)(nil), "Mysqlx.Crud.Insert")
	proto.RegisterType((*Insert_TypedRow)(nil), "Mysqlx.Crud.Insert.TypedRow")
	proto.RegisterType((*Update)(nil), "Mysqlx.Crud.Update")
	proto.RegisterType((*Delete)(nil), "Mysqlx.Crud.Delete")
	proto.RegisterType((*CreateView)(nil), "Mysqlx.Crud.CreateView")
	proto.RegisterType((*ModifyView)(nil), "Mysqlx.Crud.ModifyView")
	proto.RegisterType((*DropView)(nil), "Mysqlx.Crud.DropView")
	proto.RegisterEnum("Mysqlx.Crud.DataModel", DataModel_name, DataModel_value)
	proto.RegisterEnum("Mysqlx.Crud.ViewAlgorithm", ViewAlgorithm_name, ViewAlgorithm_value)
	proto.RegisterEnum("Mysqlx.Crud.ViewSqlSecurity", ViewSqlSecurity_name, ViewSqlSecurity_value)
	proto.RegisterEnum("Mysqlx.Crud.ViewCheckOption", ViewCheckOption_name, ViewCheckOption_value)
	proto.RegisterEnum("Mysqlx.Crud.Order_Direction", Order_Direction_name, Order_Direction_value)
	proto.RegisterEnum("Mysqlx.Crud.UpdateOperation_UpdateType", UpdateOperation_UpdateType_name, UpdateOperation_UpdateType_value)
}
func (m *Column) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Column) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Alias != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(len(*m.Alias)))
		i += copy(dAtA[i:], *m.Alias)
	}
	if len(m.DocumentPath) > 0 {
		for _, msg := range m.DocumentPath {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Projection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Projection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Source == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Source.Size()))
		n1, err := m.Source.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Alias != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(len(*m.Alias)))
		i += copy(dAtA[i:], *m.Alias)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Collection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Collection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Schema != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(len(*m.Schema)))
		i += copy(dAtA[i:], *m.Schema)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Limit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Limit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RowCount == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.RowCount))
	}
	if m.Offset != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.Offset))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Order) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Order) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Expr == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Expr.Size()))
		n2, err := m.Expr.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Direction != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.Direction))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpdateOperation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateOperation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Source == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Source.Size()))
		n3, err := m.Source.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Operation == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.Operation))
	}
	if m.Value != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Value.Size()))
		n4, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Find) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Find) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Collection == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Collection.Size()))
		n5, err := m.Collection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.DataModel != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.DataModel))
	}
	if len(m.Projection) > 0 {
		for _, msg := range m.Projection {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Criteria != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Criteria.Size()))
		n6, err := m.Criteria.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Limit != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Limit.Size()))
		n7, err := m.Limit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if len(m.Order) > 0 {
		for _, msg := range m.Order {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Grouping) > 0 {
		for _, msg := range m.Grouping {
			dAtA[i] = 0x42
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.GroupingCriteria != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.GroupingCriteria.Size()))
		n8, err := m.GroupingCriteria.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if len(m.Args) > 0 {
		for _, msg := range m.Args {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Insert) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Insert) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Collection == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Collection.Size()))
		n9, err := m.Collection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.DataModel != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.DataModel))
	}
	if len(m.Projection) > 0 {
		for _, msg := range m.Projection {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Row) > 0 {
		for _, msg := range m.Row {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Args) > 0 {
		for _, msg := range m.Args {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Insert_TypedRow) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Insert_TypedRow) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Field) > 0 {
		for _, msg := range m.Field {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Update) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Update) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Collection == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Collection.Size()))
		n10, err := m.Collection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.DataModel != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.DataModel))
	}
	if m.Criteria != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Criteria.Size()))
		n11, err := m.Criteria.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.Limit != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Limit.Size()))
		n12, err := m.Limit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if len(m.Order) > 0 {
		for _, msg := range m.Order {
			dAtA[i] = 0x32
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Operation) > 0 {
		for _, msg := range m.Operation {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Args) > 0 {
		for _, msg := range m.Args {
			dAtA[i] = 0x42
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Delete) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Delete) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Collection == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Collection.Size()))
		n13, err := m.Collection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.DataModel != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.DataModel))
	}
	if m.Criteria != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Criteria.Size()))
		n14, err := m.Criteria.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Limit != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Limit.Size()))
		n15, err := m.Limit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if len(m.Order) > 0 {
		for _, msg := range m.Order {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Args) > 0 {
		for _, msg := range m.Args {
			dAtA[i] = 0x32
			i++
			i = encodeVarintMysqlxCrud(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CreateView) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateView) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Collection == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Collection.Size()))
		n16, err := m.Collection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.Definer != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(len(*m.Definer)))
		i += copy(dAtA[i:], *m.Definer)
	}
	if m.Algorithm != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.Algorithm))
	}
	if m.Security != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.Security))
	}
	if m.Check != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.Check))
	}
	if len(m.Column) > 0 {
		for _, s := range m.Column {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Stmt == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Stmt.Size()))
		n17, err := m.Stmt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.ReplaceExisting != nil {
		dAtA[i] = 0x40
		i++
		if *m.ReplaceExisting {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ModifyView) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ModifyView) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Collection == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Collection.Size()))
		n18, err := m.Collection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.Definer != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(len(*m.Definer)))
		i += copy(dAtA[i:], *m.Definer)
	}
	if m.Algorithm != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.Algorithm))
	}
	if m.Security != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.Security))
	}
	if m.Check != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(*m.Check))
	}
	if len(m.Column) > 0 {
		for _, s := range m.Column {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Stmt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Stmt.Size()))
		n19, err := m.Stmt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DropView) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DropView) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Collection == nil {
		return 0, new(github_com_golang_protobuf_proto.RequiredNotSetError)
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMysqlxCrud(dAtA, i, uint64(m.Collection.Size()))
		n20, err := m.Collection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.IfExists != nil {
		dAtA[i] = 0x10
		i++
		if *m.IfExists {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintMysqlxCrud(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Column) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Alias != nil {
		l = len(*m.Alias)
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if len(m.DocumentPath) > 0 {
		for _, e := range m.DocumentPath {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Projection) Size() (n int) {
	var l int
	_ = l
	if m.Source != nil {
		l = m.Source.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Alias != nil {
		l = len(*m.Alias)
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Collection) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Schema != nil {
		l = len(*m.Schema)
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Limit) Size() (n int) {
	var l int
	_ = l
	if m.RowCount != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.RowCount))
	}
	if m.Offset != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.Offset))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Order) Size() (n int) {
	var l int
	_ = l
	if m.Expr != nil {
		l = m.Expr.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Direction != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.Direction))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateOperation) Size() (n int) {
	var l int
	_ = l
	if m.Source != nil {
		l = m.Source.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Operation != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.Operation))
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Find) Size() (n int) {
	var l int
	_ = l
	if m.Collection != nil {
		l = m.Collection.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.DataModel != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.DataModel))
	}
	if len(m.Projection) > 0 {
		for _, e := range m.Projection {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.Criteria != nil {
		l = m.Criteria.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Limit != nil {
		l = m.Limit.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if len(m.Order) > 0 {
		for _, e := range m.Order {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if len(m.Grouping) > 0 {
		for _, e := range m.Grouping {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.GroupingCriteria != nil {
		l = m.GroupingCriteria.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Insert) Size() (n int) {
	var l int
	_ = l
	if m.Collection != nil {
		l = m.Collection.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.DataModel != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.DataModel))
	}
	if len(m.Projection) > 0 {
		for _, e := range m.Projection {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if len(m.Row) > 0 {
		for _, e := range m.Row {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Insert_TypedRow) Size() (n int) {
	var l int
	_ = l
	if len(m.Field) > 0 {
		for _, e := range m.Field {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Update) Size() (n int) {
	var l int
	_ = l
	if m.Collection != nil {
		l = m.Collection.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.DataModel != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.DataModel))
	}
	if m.Criteria != nil {
		l = m.Criteria.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Limit != nil {
		l = m.Limit.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if len(m.Order) > 0 {
		for _, e := range m.Order {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if len(m.Operation) > 0 {
		for _, e := range m.Operation {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Delete) Size() (n int) {
	var l int
	_ = l
	if m.Collection != nil {
		l = m.Collection.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.DataModel != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.DataModel))
	}
	if m.Criteria != nil {
		l = m.Criteria.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Limit != nil {
		l = m.Limit.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if len(m.Order) > 0 {
		for _, e := range m.Order {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CreateView) Size() (n int) {
	var l int
	_ = l
	if m.Collection != nil {
		l = m.Collection.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Definer != nil {
		l = len(*m.Definer)
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Algorithm != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.Algorithm))
	}
	if m.Security != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.Security))
	}
	if m.Check != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.Check))
	}
	if len(m.Column) > 0 {
		for _, s := range m.Column {
			l = len(s)
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.Stmt != nil {
		l = m.Stmt.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.ReplaceExisting != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ModifyView) Size() (n int) {
	var l int
	_ = l
	if m.Collection != nil {
		l = m.Collection.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Definer != nil {
		l = len(*m.Definer)
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.Algorithm != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.Algorithm))
	}
	if m.Security != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.Security))
	}
	if m.Check != nil {
		n += 1 + sovMysqlxCrud(uint64(*m.Check))
	}
	if len(m.Column) > 0 {
		for _, s := range m.Column {
			l = len(s)
			n += 1 + l + sovMysqlxCrud(uint64(l))
		}
	}
	if m.Stmt != nil {
		l = m.Stmt.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DropView) Size() (n int) {
	var l int
	_ = l
	if m.Collection != nil {
		l = m.Collection.Size()
		n += 1 + l + sovMysqlxCrud(uint64(l))
	}
	if m.IfExists != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMysqlxCrud(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMysqlxCrud(x uint64) (n int) {
	return sovMysqlxCrud(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Column) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Column: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Column: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alias", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Alias = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DocumentPath", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DocumentPath = append(m.DocumentPath, &Mysqlx_Expr.DocumentPathItem{})
			if err := m.DocumentPath[len(m.DocumentPath)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Projection) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Projection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Projection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Source == nil {
				m.Source = &Mysqlx_Expr.Expr{}
			}
			if err := m.Source.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alias", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Alias = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Collection) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Collection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Collection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Schema = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Limit) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Limit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Limit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RowCount = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Offset = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Order) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Order: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Order: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expr == nil {
				m.Expr = &Mysqlx_Expr.Expr{}
			}
			if err := m.Expr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Direction", wireType)
			}
			var v Order_Direction
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (Order_Direction(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Direction = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateOperation) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateOperation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateOperation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Source == nil {
				m.Source = &Mysqlx_Expr.ColumnIdentifier{}
			}
			if err := m.Source.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			var v UpdateOperation_UpdateType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (UpdateOperation_UpdateType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Operation = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Mysqlx_Expr.Expr{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Find) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Find: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Find: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Collection == nil {
				m.Collection = &Collection{}
			}
			if err := m.Collection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataModel", wireType)
			}
			var v DataModel
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (DataModel(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DataModel = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Projection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Projection = append(m.Projection, &Projection{})
			if err := m.Projection[len(m.Projection)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Criteria", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Criteria == nil {
				m.Criteria = &Mysqlx_Expr.Expr{}
			}
			if err := m.Criteria.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limit == nil {
				m.Limit = &Limit{}
			}
			if err := m.Limit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Order", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Order = append(m.Order, &Order{})
			if err := m.Order[len(m.Order)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Grouping", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Grouping = append(m.Grouping, &Mysqlx_Expr.Expr{})
			if err := m.Grouping[len(m.Grouping)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupingCriteria", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GroupingCriteria == nil {
				m.GroupingCriteria = &Mysqlx_Expr.Expr{}
			}
			if err := m.GroupingCriteria.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &Mysqlx_Datatypes.Scalar{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Insert) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Insert: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Insert: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Collection == nil {
				m.Collection = &Collection{}
			}
			if err := m.Collection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataModel", wireType)
			}
			var v DataModel
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (DataModel(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DataModel = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Projection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Projection = append(m.Projection, &Column{})
			if err := m.Projection[len(m.Projection)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Row", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Row = append(m.Row, &Insert_TypedRow{})
			if err := m.Row[len(m.Row)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &Mysqlx_Datatypes.Scalar{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Insert_TypedRow) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TypedRow: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TypedRow: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Field", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Field = append(m.Field, &Mysqlx_Expr.Expr{})
			if err := m.Field[len(m.Field)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Update) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Update: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Update: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Collection == nil {
				m.Collection = &Collection{}
			}
			if err := m.Collection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataModel", wireType)
			}
			var v DataModel
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (DataModel(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DataModel = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Criteria", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Criteria == nil {
				m.Criteria = &Mysqlx_Expr.Expr{}
			}
			if err := m.Criteria.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limit == nil {
				m.Limit = &Limit{}
			}
			if err := m.Limit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Order", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Order = append(m.Order, &Order{})
			if err := m.Order[len(m.Order)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Operation = append(m.Operation, &UpdateOperation{})
			if err := m.Operation[len(m.Operation)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &Mysqlx_Datatypes.Scalar{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Delete) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Delete: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Delete: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Collection == nil {
				m.Collection = &Collection{}
			}
			if err := m.Collection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataModel", wireType)
			}
			var v DataModel
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (DataModel(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DataModel = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Criteria", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Criteria == nil {
				m.Criteria = &Mysqlx_Expr.Expr{}
			}
			if err := m.Criteria.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limit == nil {
				m.Limit = &Limit{}
			}
			if err := m.Limit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Order", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Order = append(m.Order, &Order{})
			if err := m.Order[len(m.Order)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &Mysqlx_Datatypes.Scalar{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateView) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateView: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateView: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Collection == nil {
				m.Collection = &Collection{}
			}
			if err := m.Collection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Definer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Definer = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Algorithm", wireType)
			}
			var v ViewAlgorithm
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (ViewAlgorithm(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Algorithm = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Security", wireType)
			}
			var v ViewSqlSecurity
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (ViewSqlSecurity(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Security = &v
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Check", wireType)
			}
			var v ViewCheckOption
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (ViewCheckOption(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Check = &v
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Column = append(m.Column, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stmt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stmt == nil {
				m.Stmt = &Find{}
			}
			if err := m.Stmt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplaceExisting", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReplaceExisting = &b
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ModifyView) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ModifyView: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ModifyView: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Collection == nil {
				m.Collection = &Collection{}
			}
			if err := m.Collection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Definer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Definer = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Algorithm", wireType)
			}
			var v ViewAlgorithm
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (ViewAlgorithm(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Algorithm = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Security", wireType)
			}
			var v ViewSqlSecurity
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (ViewSqlSecurity(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Security = &v
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Check", wireType)
			}
			var v ViewCheckOption
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (ViewCheckOption(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Check = &v
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Column = append(m.Column, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stmt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stmt == nil {
				m.Stmt = &Find{}
			}
			if err := m.Stmt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DropView) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DropView: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DropView: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Collection == nil {
				m.Collection = &Collection{}
			}
			if err := m.Collection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IfExists", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.IfExists = &b
		default:
			iNdEx = preIndex
			skippy, err := skipMysqlxCrud(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMysqlxCrud
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return new(github_com_golang_protobuf_proto.RequiredNotSetError)
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMysqlxCrud(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMysqlxCrud
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMysqlxCrud
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMysqlxCrud
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMysqlxCrud
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMysqlxCrud(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMysqlxCrud = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMysqlxCrud   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/pingcap/tipb/go-mysqlx/Crud/mysqlx_crud.proto", fileDescriptorMysqlxCrud)
}

var fileDescriptorMysqlxCrud = []byte{
	// 1187 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xdd, 0x8e, 0xdb, 0xc4,
	0x17, 0xff, 0xdb, 0x89, 0x93, 0xf8, 0xa4, 0xdd, 0x75, 0xe7, 0x8f, 0x8a, 0xb5, 0xb4, 0xab, 0x95,
	0x05, 0x6a, 0x58, 0xc0, 0x45, 0xa9, 0x2a, 0x56, 0x2b, 0x04, 0x4a, 0x6d, 0x17, 0x45, 0x6c, 0x3e,
	0x34, 0x49, 0x2b, 0x71, 0x15, 0x19, 0x7b, 0xb2, 0xeb, 0x62, 0xc7, 0xee, 0xd8, 0xe9, 0xee, 0xf2,
	0x0c, 0x48, 0xdc, 0xf2, 0x0a, 0xdc, 0xf3, 0x00, 0x5c, 0x21, 0xee, 0xe0, 0x11, 0x50, 0x11, 0xef,
	0x81, 0x66, 0xc6, 0x4e, 0xe2, 0x74, 0x97, 0x66, 0x8b, 0x96, 0x9b, 0x68, 0x66, 0xce, 0xef, 0x9c,
	0x39, 0xe7, 0x77, 0x3e, 0x32, 0x86, 0xbb, 0xbd, 0xf3, 0xf4, 0x79, 0x78, 0x76, 0xdf, 0xa2, 0x73,
	0xff, 0x7e, 0xc4, 0xd7, 0x13, 0x8f, 0xce, 0x7d, 0x33, 0xa1, 0x71, 0x16, 0xa3, 0xa6, 0x10, 0x9b,
	0x4c, 0xbc, 0x53, 0x60, 0x9d, 0xb3, 0x84, 0x16, 0x58, 0x72, 0x96, 0x50, 0x81, 0xdd, 0xb9, 0x97,
	0x8b, 0x6d, 0x37, 0x73, 0xb3, 0xf3, 0x84, 0xa4, 0x05, 0xc6, 0x2f, 0x0e, 0x04, 0xd0, 0x78, 0x01,
	0x35, 0x2b, 0x0e, 0xe7, 0xd1, 0x0c, 0x21, 0xa8, 0xce, 0xdc, 0x88, 0xe8, 0xd2, 0x9e, 0xd4, 0x52,
	0x31, 0x5f, 0xa3, 0xb7, 0x40, 0x71, 0xc3, 0xc0, 0x4d, 0x75, 0x99, 0x1f, 0x8a, 0x0d, 0x7a, 0x04,
	0x37, 0xfd, 0xd8, 0x9b, 0x47, 0x64, 0x96, 0x4d, 0x12, 0x37, 0x3b, 0xd1, 0x2b, 0x7b, 0x95, 0x56,
	0xb3, 0x7d, 0xd7, 0xcc, 0x1d, 0x64, 0x3e, 0x99, 0x76, 0x8e, 0x18, 0xba, 0xd9, 0x49, 0x37, 0x23,
	0x11, 0xbe, 0xe1, 0xaf, 0x9c, 0x18, 0x3d, 0x80, 0x21, 0x8d, 0x9f, 0x11, 0x2f, 0x0b, 0xe2, 0x19,
	0x7a, 0x1f, 0x6a, 0x69, 0x3c, 0xa7, 0x1e, 0xbb, 0x5d, 0x6e, 0x35, 0xdb, 0xb7, 0x4a, 0xa6, 0xd8,
	0x0f, 0xce, 0x01, 0x17, 0xbb, 0x64, 0x1c, 0x00, 0x58, 0x71, 0x18, 0xe6, 0xe6, 0x96, 0xa1, 0xc8,
	0x8b, 0x50, 0x6e, 0x43, 0x2d, 0xf5, 0x4e, 0x48, 0xe4, 0xe6, 0x8a, 0xf9, 0xce, 0xf8, 0x14, 0x94,
	0xa3, 0x20, 0x0a, 0x32, 0xf4, 0x0e, 0xa8, 0x34, 0x3e, 0x9d, 0x78, 0xf1, 0x7c, 0x96, 0x71, 0xcd,
	0x2a, 0x6e, 0xd0, 0xf8, 0xd4, 0x62, 0x7b, 0xa6, 0x1d, 0x4f, 0xa7, 0x29, 0xc9, 0xb8, 0x76, 0x15,
	0xe7, 0x3b, 0xe3, 0x7b, 0x09, 0x94, 0x01, 0xf5, 0x09, 0x45, 0xef, 0x41, 0x95, 0xf1, 0x7f, 0x79,
	0x00, 0x5c, 0x8c, 0x3e, 0x07, 0xd5, 0x0f, 0xa8, 0xf0, 0x93, 0xdb, 0xda, 0x6a, 0xdf, 0x31, 0x57,
	0x12, 0x6b, 0x72, 0x6b, 0xa6, 0x5d, 0x60, 0x0e, 0x2b, 0x9d, 0x91, 0x85, 0x97, 0x3a, 0xc6, 0x2e,
	0xa8, 0x0b, 0x21, 0xaa, 0x03, 0x13, 0x6b, 0x12, 0x6a, 0x40, 0xd5, 0x76, 0x46, 0x96, 0x26, 0x1b,
	0x3f, 0xc9, 0xb0, 0xfd, 0x24, 0xf1, 0xdd, 0x8c, 0x0c, 0x12, 0x42, 0x5d, 0x0e, 0x7b, 0xb8, 0x46,
	0x6f, 0x39, 0x53, 0x22, 0xff, 0x5d, 0x9f, 0xcc, 0xb2, 0x60, 0x1a, 0x90, 0x25, 0xd5, 0x0e, 0xa8,
	0x71, 0x61, 0x43, 0x97, 0xf7, 0xe4, 0xd6, 0x56, 0xfb, 0x5e, 0xc9, 0xd7, 0xb5, 0x7b, 0xf2, 0xfd,
	0xf8, 0x3c, 0x21, 0x78, 0xa9, 0x89, 0xee, 0x81, 0xf2, 0xc2, 0x0d, 0xe7, 0x44, 0xaf, 0xec, 0x49,
	0x17, 0x53, 0x23, 0xe4, 0xc6, 0xb7, 0x00, 0x4b, 0x0b, 0x2c, 0xb6, 0x91, 0x33, 0xd6, 0x24, 0xb4,
	0x0d, 0xcd, 0xee, 0xd8, 0xe9, 0x4d, 0xb0, 0xd3, 0x1b, 0x3c, 0x75, 0x34, 0x19, 0xdd, 0x80, 0x06,
	0x3f, 0x60, 0xe2, 0x0a, 0xd2, 0xe0, 0x46, 0x2e, 0x1e, 0x1e, 0x75, 0x2c, 0x47, 0xab, 0xa2, 0x2d,
	0x00, 0x7e, 0xd2, 0x73, 0xf0, 0x17, 0x8e, 0xa6, 0x30, 0x44, 0x07, 0xe3, 0xce, 0x57, 0x93, 0x6e,
	0x7f, 0xe4, 0xe0, 0xb1, 0x56, 0x5b, 0x9e, 0x74, 0x86, 0x43, 0xa7, 0x6f, 0x6b, 0x75, 0xe3, 0xb7,
	0x0a, 0x54, 0x1f, 0x07, 0x33, 0x1f, 0x7d, 0x02, 0xe0, 0x2d, 0x2a, 0x89, 0x47, 0xdd, 0x6c, 0xbf,
	0x5d, 0x8a, 0x7a, 0x59, 0x68, 0x78, 0x05, 0x8a, 0x1e, 0x02, 0xb0, 0xe6, 0x9a, 0x44, 0xb1, 0x4f,
	0x42, 0x1e, 0xeb, 0x56, 0xfb, 0x76, 0x49, 0x91, 0x35, 0x63, 0x8f, 0x49, 0xb1, 0xea, 0x17, 0x4b,
	0x76, 0x5f, 0xb2, 0x68, 0x04, 0xbd, 0xca, 0x3b, 0xa9, 0x7c, 0xdf, 0xb2, 0x4f, 0xf0, 0x0a, 0x14,
	0x7d, 0x04, 0x0d, 0x8f, 0x06, 0x19, 0xa1, 0x81, 0xab, 0x2b, 0x97, 0x31, 0xbb, 0x80, 0xa0, 0x16,
	0x28, 0x21, 0xab, 0x73, 0xbd, 0xc6, 0xb1, 0xa8, 0x74, 0x05, 0xef, 0x00, 0x2c, 0x00, 0x0c, 0x19,
	0xb3, 0x22, 0xd4, 0xeb, 0xdc, 0x19, 0xf4, 0x6a, 0x79, 0x62, 0x01, 0x60, 0x2e, 0x1c, 0xd3, 0x78,
	0x9e, 0x04, 0xb3, 0x63, 0xbd, 0xc1, 0xc1, 0x17, 0xb9, 0x50, 0x40, 0xd0, 0x67, 0x70, 0xab, 0x58,
	0x4f, 0x16, 0xae, 0xab, 0x97, 0xb9, 0xae, 0x15, 0x58, 0xab, 0x08, 0xe1, 0x43, 0xa8, 0xba, 0xf4,
	0x38, 0xd5, 0x9b, 0xfc, 0x2a, 0xbd, 0x50, 0x59, 0xcc, 0x38, 0x73, 0xe4, 0xb9, 0xa1, 0x4b, 0x31,
	0x47, 0x19, 0x3f, 0xcb, 0x50, 0xeb, 0xce, 0x52, 0x42, 0xb3, 0xb5, 0x9c, 0x4a, 0x6f, 0x9a, 0x53,
	0x79, 0xd3, 0x9c, 0x3e, 0x28, 0xe5, 0x54, 0x4c, 0xc7, 0xff, 0xaf, 0xdf, 0x37, 0x8f, 0xca, 0xf9,
	0x34, 0xa1, 0x42, 0xe3, 0xd3, 0xbc, 0x02, 0xca, 0x33, 0x41, 0x84, 0x61, 0xb2, 0xb6, 0xf0, 0x71,
	0x7c, 0x8a, 0x19, 0x70, 0xc1, 0x86, 0xb2, 0x09, 0x1b, 0x3b, 0x0f, 0xa0, 0x51, 0xa8, 0xb3, 0x86,
	0x9c, 0x06, 0x24, 0xf4, 0x75, 0xe9, 0xb2, 0x9c, 0x09, 0xb9, 0xf1, 0x97, 0x0c, 0x35, 0xd1, 0x91,
	0xff, 0x79, 0x5b, 0xac, 0x56, 0x77, 0xf5, 0x0a, 0xd5, 0xad, 0x6c, 0x5c, 0xdd, 0xb5, 0xd7, 0x55,
	0xf7, 0xe1, 0xea, 0xf8, 0xab, 0x5f, 0x90, 0x96, 0xb5, 0xf1, 0xb7, 0x3a, 0xf3, 0x8a, 0xe4, 0x34,
	0x36, 0x2a, 0xd5, 0x1f, 0x65, 0xa8, 0xd9, 0x24, 0x24, 0xaf, 0xf0, 0x7c, 0xfd, 0xa5, 0xba, 0xca,
	0x73, 0xe5, 0x0a, 0x3c, 0x57, 0x37, 0xe6, 0x59, 0x79, 0x1d, 0xcf, 0x05, 0x57, 0xb5, 0x8d, 0xb8,
	0xfa, 0xae, 0x02, 0x60, 0x51, 0xe2, 0x66, 0xe4, 0x69, 0x40, 0x4e, 0xdf, 0x9c, 0x2f, 0x1d, 0xea,
	0x3e, 0x99, 0x06, 0x33, 0x42, 0xf3, 0x07, 0x41, 0xb1, 0x45, 0x16, 0xa8, 0x6e, 0x78, 0x1c, 0xd3,
	0x20, 0x3b, 0x89, 0xf2, 0x82, 0xdd, 0x29, 0x59, 0x64, 0x17, 0x77, 0x0a, 0xc4, 0xa1, 0xfa, 0xa4,
	0x6f, 0x3b, 0x8f, 0xbb, 0x7d, 0xc7, 0xc6, 0x4b, 0x3d, 0xd4, 0x81, 0x46, 0x4a, 0xbc, 0x39, 0x0d,
	0xb2, 0x73, 0xce, 0xd5, 0xfa, 0xdf, 0x3c, 0xb3, 0x31, 0x7a, 0x1e, 0x8e, 0x72, 0xcc, 0x61, 0x5d,
	0xd8, 0xc0, 0x78, 0xa1, 0x86, 0xda, 0xa0, 0x78, 0x27, 0xc4, 0xfb, 0x86, 0xd7, 0xf4, 0x45, 0xfa,
	0x16, 0x93, 0x0e, 0x12, 0x1e, 0x9a, 0x80, 0xb2, 0x77, 0x8a, 0xc7, 0x47, 0x0b, 0x67, 0x53, 0xc5,
	0xf9, 0x8e, 0xbd, 0x4e, 0xd2, 0x2c, 0xca, 0xf4, 0x7a, 0xf9, 0x75, 0xc2, 0x4d, 0xb1, 0xbf, 0x3d,
	0xcc, 0xc5, 0xe8, 0x63, 0xd0, 0x28, 0x49, 0x42, 0xd7, 0x23, 0x13, 0x72, 0x16, 0xa4, 0x99, 0x18,
	0xec, 0x52, 0xab, 0x71, 0xa8, 0x4c, 0xdd, 0x30, 0x25, 0x78, 0x3b, 0x17, 0x3b, 0xb9, 0xd4, 0xf8,
	0x45, 0x06, 0xe8, 0xc5, 0x7e, 0x30, 0x3d, 0xbf, 0xae, 0x74, 0x1c, 0x5c, 0x29, 0x1d, 0xab, 0x39,
	0x38, 0xb8, 0x5a, 0x0e, 0xae, 0x9d, 0x7a, 0xe9, 0x1f, 0xa8, 0x37, 0x8e, 0xa1, 0x61, 0xd3, 0x38,
	0xf9, 0x77, 0x2c, 0x1a, 0xa0, 0x06, 0x53, 0x91, 0x3a, 0xf1, 0x40, 0x5e, 0x24, 0xae, 0x11, 0x4c,
	0x79, 0xce, 0xd2, 0xfd, 0x77, 0x41, 0x5d, 0x4c, 0x02, 0xf6, 0x94, 0xb2, 0x07, 0xd6, 0x93, 0x9e,
	0xd3, 0x67, 0x2f, 0x2d, 0x15, 0x94, 0x71, 0xe7, 0xd1, 0x91, 0xa3, 0xc9, 0xfb, 0x07, 0x70, 0xb3,
	0xc4, 0x2b, 0xba, 0x09, 0xcb, 0x42, 0x17, 0x50, 0xf1, 0xbc, 0x92, 0x99, 0x64, 0xec, 0xf4, 0x86,
	0x42, 0xb3, 0xb2, 0xff, 0x01, 0x6c, 0xaf, 0x11, 0x8b, 0x9a, 0x50, 0xef, 0xf6, 0x9f, 0x0e, 0xbe,
	0x74, 0xb0, 0x26, 0xb1, 0x4d, 0x5e, 0xeb, 0x9a, 0xbc, 0xbf, 0x2f, 0xc0, 0x2b, 0x74, 0x32, 0xcb,
	0x47, 0x03, 0xab, 0x73, 0xa4, 0x49, 0xcc, 0x3b, 0xab, 0x33, 0xb2, 0x3a, 0xb6, 0x63, 0x6b, 0xf2,
	0x23, 0xf3, 0xd7, 0x97, 0xbb, 0xd2, 0xef, 0x2f, 0x77, 0xa5, 0x3f, 0x5e, 0xee, 0x4a, 0x3f, 0xfc,
	0xb9, 0xfb, 0x3f, 0xb8, 0xe3, 0xc5, 0x91, 0xc9, 0x3f, 0x6c, 0x4c, 0xef, 0x99, 0x58, 0x9c, 0x89,
	0xef, 0x9a, 0xaf, 0xe7, 0xd3, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xc9, 0x16, 0xd6, 0xa6, 0x4f,
	0x0d, 0x00, 0x00,
}
