// @ts-check
import { check } from 'k6';
import { ShopApiRequest } from '../utils/api-request.js';

const searchQuery = new ShopApiRequest('shop/search.graphql');
const addItemToOrderMutation = new ShopApiRequest('shop/add-to-order.graphql');

export let options = {
    stages: [{ duration: '2m', target: 1 }],
};

// export function setup() {
//     const searchResult = searchQuery.post();
//     return searchResult.data.search.items;
// }

/**
 * Continuously adds random items to a single order for the duration of the test.
 */
export default function () {
    /**
     * This list is generated from the following query:
     *
     * ```
     * select pv.id
     * from product_variant pv
     *          left join public.product p on pv."productId" = p.id
     * left join stock_level sl on pv.id = sl."productVariantId"
     * where pv."deletedAt" is null
     *   and p."deletedAt" is null
     *   and p.enabled = true
     *   and pv.enabled = true
     * and sl."stockOnHand" > 10
     *
     * order by pv."createdAt" desc
     * limit 500
     * ```
     * @type {number[]}
     */
    const productIds = [
        21527, 21526, 21513, 21512, 21511, 21510, 21472, 21469, 21463, 21458, 21457, 21426, 21437, 21427,
        21438, 21412, 21390, 21388, 21364, 21363, 21349, 21346, 21345, 21325, 21327, 21338, 21337, 21320,
        21333, 21324, 21339, 21321, 21323, 21318, 21335, 21330, 21332, 21331, 21326, 21319, 21336, 21340,
        21317, 21322, 21329, 21328, 21299, 21294, 21291, 21295, 21306, 21287, 21286, 21285, 21284, 21282,
        21281, 21280, 21279, 21278, 21270, 21216, 21215, 21197, 21194, 21192, 21191, 21190, 21189, 21188,
        21187, 21186, 21185, 21184, 21182, 21181, 21179, 21178, 21176, 21175, 21174, 21173, 21172, 21171,
        21170, 21169, 21165, 21161, 21160, 21159, 21158, 21157, 21153, 21149, 21152, 21146, 21143, 21137,
        21133, 21132, 21131, 21130, 21129, 21127, 21128, 21126, 21125, 21124, 21122, 21123, 20952, 20947,
        20886, 20885, 20882, 20857, 20799, 20800, 20797, 20791, 20784, 20778, 20777, 20773, 20769, 20770,
        20767, 20765, 20762, 20761, 20763, 20758, 20757, 20760, 20755, 20756, 20751, 20752, 20748, 20747,
        20746, 20745, 20744, 20740, 20738, 20732, 20731, 20730, 20729, 20727, 20726, 20725, 20724, 20723,
        20722, 20721, 20720, 20719, 20718, 20717, 20716, 20715, 20714, 20713, 20712, 20711, 20710, 20707,
        20706, 20667, 20664, 20665, 20658, 20659, 20657, 20655, 20577, 20572, 20567, 20564, 20563, 20562,
        20561, 20560, 20550, 20544, 20539, 20538, 20537, 20536, 20535, 20534, 20531, 20526, 20521, 20517,
        20472, 20478, 20474, 20470, 20471, 20475, 20468, 20467, 20457, 20456, 20455, 20453, 20452, 20451,
        20449, 20448, 20447, 20445, 20444, 20443, 20431, 20426, 20417, 20412, 20410, 20409, 20407, 20405,
        20402, 20398, 20396, 20395, 20393, 20390, 20389, 20386, 20385, 20384, 20383, 20381, 20380, 20379,
        20378, 20375, 20373, 20371, 20359, 20364, 20368, 20353, 20369, 20360, 20357, 20366, 20362, 20361,
        20370, 20358, 20365, 20354, 20355, 20363, 20356, 20351, 20333, 20332, 20330, 20326, 20325, 20324,
        20323, 20321, 20322, 20320, 20313, 20318, 20311, 20316, 20310, 20315, 20169, 20164, 20212, 20203,
        20198, 20183, 20170, 20166, 20175, 20200, 20173, 20148, 20151, 20152, 20143, 20132, 20129, 20131,
        20127, 20126, 20114, 20110, 20104, 20103, 20101, 20086, 20088, 20085, 20059, 20062, 20046, 20049,
        20039, 20032, 20037, 20034, 20033, 20035, 20036, 20028, 20031, 20029, 20027, 20030, 20026, 20023,
        20022, 20021, 20020, 20024, 20025, 20018, 20017, 20015, 20016, 20019, 20008, 20013, 20010, 20009,
        20011, 20012, 20005, 20002, 20006, 20003, 20007, 20001, 20000, 19996, 19995, 19993, 19972, 19971,
        19969, 19947, 19922, 19962, 19927, 19918, 19954, 19952, 19921, 19949, 19950, 19965, 19938, 19968,
        19936, 19923, 19937, 19966, 19953, 19933, 19935, 19956, 19943, 19944, 19945, 19934, 19957, 19959,
        19970, 19919, 19929, 19925, 19963, 19961, 19951, 19940, 19920, 19904, 19901, 19911, 19896, 19892,
        19900, 19895, 19908, 19885, 19905, 19894, 19903, 19889, 19888, 19897, 19902, 19907, 19891, 19906,
        19898, 19909, 19910, 19886, 19887, 19890, 19912, 19893, 19883, 19874, 19865, 19866, 19864, 19862,
        19861, 19850, 19830, 19828, 19824, 19826, 19822, 19833, 19823, 19791, 19789, 19790, 19779, 19755,
        19756, 19733, 17473, 17471, 17424, 17422, 17421, 17420, 17417, 17416, 17415, 17407, 17374, 17373,
        17371, 17370, 17369, 17368, 17367, 17365, 17364, 17356, 17355, 17318, 17317, 17315, 17303, 17300,
        17309, 17307, 17304, 17306, 17311, 17294, 17313, 17297, 17261, 17249, 17068, 17043, 16968, 16966,
        16965, 16964, 16963, 16961, 16958, 16952, 16917, 16911, 16902, 16901, 16900, 16899, 16898, 16897,
        16896, 16895, 16894, 16892, 16891, 16889, 16887, 16886, 16885, 16884,
    ];

    const productIds2 = [
        1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
        29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
        54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
        79, 80,
    ];
    for (let i = 0; i < 1000; i++) {
        addToCart(productIds2[i % productIds2.length]);
    }
}

function addToCart(variantId) {
    const qty = 1;
    const result = addItemToOrderMutation.post({ id: variantId, qty });
    check(result.data, {
        'Product added to cart': r =>
            !!r.addItemToOrder.lines.find(l => +l.productVariant.id === variantId && l.quantity >= qty),
    });
}

function randomItem(items) {
    return items[Math.floor(Math.random() * items.length)];
}
