import Playground from '@site/src/components/Playground';
import Layout from '@theme/Layout';
import React from 'react';
import Link from '@docusaurus/Link';

import styles from './index.module.css';

export default function Home(): JSX.Element {
    return (
        <Layout
            title={`Vendure documentation`}
            description="Developer docs for Vendure: the open-source headless commerce platform"
        >
            <div className={styles.heroBanner}>
                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    fill="none"
                    viewBox="0 0 541 120"
                    style={{ color: '#17C1FF', marginTop: '2rem' }}
                    height="75"
                    width="auto"
                >
                    <path
                        fill="currentColor"
                        d="M69.88 40.575a3.046 3.046 0 0 0-2.496-1.276H56.84c-1.283 0-2.463.828-2.879 2.035L35.995 93.226 17.752 41.3a3.033 3.033 0 0 0-2.879-2.036H4.017c-1.005 0-1.907.483-2.497 1.277a3.113 3.113 0 0 0-.381 2.76l25.873 71.248c.417 1.208 1.561 2.001 2.844 2.001h11.48c1.284 0 2.428-.793 2.845-2.001l26.012-71.248a2.912 2.912 0 0 0-.382-2.76l.07.034ZM144.935 80.357c.104-1.139.174-2.691.174-4.727 0-7.176-1.63-13.767-4.821-19.632-3.191-5.865-7.7-10.592-13.319-14.008-5.653-3.416-12.069-5.176-19.006-5.176-7.353 0-14.047 1.795-19.873 5.314-5.827 3.52-10.405 8.487-13.666 14.733C71.2 63.035 69.57 70.11 69.57 77.873s1.665 14.836 4.925 21.046c3.295 6.245 7.942 11.214 13.804 14.733 5.861 3.519 12.624 5.313 20.081 5.313 8.012 0 15.087-1.621 21.053-4.864 5.931-3.244 10.786-7.764 14.428-13.422a3.058 3.058 0 0 0-.867-4.14l-8.254-5.486c-.694-.449-1.527-.621-2.359-.449a3.063 3.063 0 0 0-1.942 1.38 23.708 23.708 0 0 1-8.602 8.454c-3.537 2.001-8.15 3.036-13.734 3.036-6.659 0-11.758-2.174-15.573-6.694-3.33-3.933-5.376-8.453-6.174-13.766h55.563c1.561 0 2.879-1.173 3.017-2.726v.069ZM87.431 68.522c1.248-4.209 3.364-7.763 6.347-10.764 3.676-3.658 8.289-5.452 14.15-5.452 5.862 0 10.718 1.553 14.151 4.727 2.81 2.622 4.821 6.487 5.931 11.455H87.396l.035.034ZM218.013 50.27c-2.809-4.416-6.625-7.832-11.341-10.109-4.613-2.208-9.746-3.347-15.157-3.347-5.861 0-11.099 1.415-15.607 4.175a28.33 28.33 0 0 0-5.064 4.003v-2.726a3.049 3.049 0 0 0-3.052-3.036h-10.405c-1.665 0-3.052 1.345-3.052 3.036v71.248a3.048 3.048 0 0 0 3.052 3.036h10.405c1.664 0 3.052-1.345 3.052-3.036V77.873c0-8.04 1.665-14.491 4.959-19.115 3.087-4.347 7.7-6.486 14.047-6.486 10.891 0 15.954 5.762 15.954 18.148v43.094a3.049 3.049 0 0 0 3.053 3.036h10.405c1.664 0 3.052-1.345 3.052-3.036V65.866c0-5.935-1.422-11.18-4.197-15.596h-.104ZM306.108 0h-10.405c-1.664 0-3.052 1.346-3.052 3.036v42.06a33.223 33.223 0 0 0-6.486-4.452c-4.751-2.518-10.058-3.76-15.711-3.76-7.353 0-14.047 1.794-19.874 5.313-5.826 3.52-10.404 8.453-13.665 14.663-3.225 6.142-4.855 13.18-4.855 20.978 0 7.798 1.664 15.009 4.925 21.185 3.295 6.245 7.942 11.213 13.804 14.733 5.861 3.519 12.555 5.313 19.942 5.313 5.584 0 10.822-1.277 15.504-3.795 2.289-1.242 4.439-2.692 6.382-4.417v2.726a3.048 3.048 0 0 0 3.052 3.036h10.405c1.664 0 3.052-1.345 3.052-3.036V3.036A3.049 3.049 0 0 0 306.074 0h.034Zm-13.457 77.907c0 5.003-.971 9.523-2.913 13.456-1.908 3.9-4.474 6.832-7.873 8.971-3.364 2.139-7.11 3.174-11.446 3.174-4.335 0-7.907-1.035-11.202-3.174-3.33-2.14-5.897-5.106-7.804-9.005-1.942-3.933-2.913-8.488-2.913-13.594 0-5.107.971-9.489 2.913-13.353 1.907-3.864 4.474-6.762 7.804-8.936 3.295-2.14 6.971-3.174 11.202-3.174 4.232 0 8.082 1.035 11.446 3.174 3.329 2.105 5.965 5.14 7.873 8.97 1.942 3.934 2.913 8.454 2.913 13.457v.034ZM388.308 39.264h-10.405c-1.665 0-3.052 1.346-3.052 3.036v35.607c0 8.04-1.665 14.491-4.96 19.115-3.087 4.347-7.7 6.486-14.047 6.486-10.89 0-15.954-5.762-15.954-18.148V42.266a3.049 3.049 0 0 0-3.052-3.036h-10.405c-1.665 0-3.052 1.345-3.052 3.036v47.648c0 5.935 1.422 11.179 4.196 15.595 2.81 4.417 6.625 7.833 11.342 10.11 4.647 2.208 9.746 3.346 15.156 3.346 5.862 0 11.099-1.414 15.608-4.174a28.289 28.289 0 0 0 5.098-4.003v2.726a3.049 3.049 0 0 0 3.052 3.036h10.405c1.665 0 3.052-1.345 3.052-3.036V42.3a3.048 3.048 0 0 0-3.052-3.036h.07ZM450.737 38.056a26.516 26.516 0 0 0-7.942-1.207c-5.931 0-11.307 1.656-16.058 4.968-2.047 1.415-3.954 3.106-5.723 5.072v-4.554a3.049 3.049 0 0 0-3.052-3.036h-10.405c-1.665 0-3.052 1.345-3.052 3.036v71.248a3.048 3.048 0 0 0 3.052 3.036h10.405c1.665 0 3.052-1.345 3.052-3.036V79.494c0-5.796 1.04-10.834 3.121-15.043 2.047-4.106 4.752-7.245 8.047-9.385 3.295-2.139 6.763-3.174 10.578-3.174 2.116 0 3.989.414 5.723 1.242.936.449 2.046.38 2.913-.172s1.422-1.518 1.422-2.554v-9.453a3.005 3.005 0 0 0-2.115-2.864l.034-.035ZM525.827 80.357c.104-1.139.173-2.657.173-4.727 0-7.176-1.63-13.801-4.786-19.632-3.191-5.865-7.7-10.592-13.319-14.008-5.653-3.416-12.069-5.141-19.006-5.141-7.353 0-14.047 1.794-19.873 5.313-5.827 3.52-10.405 8.488-13.666 14.733-3.225 6.176-4.855 13.25-4.855 21.012 0 7.763 1.664 14.836 4.925 21.047 3.295 6.245 7.942 11.213 13.838 14.733 5.862 3.519 12.625 5.313 20.082 5.313 8.012 0 15.087-1.622 21.053-4.865 5.93-3.243 10.786-7.763 14.428-13.421a3.06 3.06 0 0 0-.867-4.14l-8.255-5.487a3.139 3.139 0 0 0-2.358-.448c-.798.172-1.492.69-1.943 1.38a23.52 23.52 0 0 1-8.636 8.453c-3.537 2.001-8.15 3.036-13.734 3.036-6.659 0-11.758-2.173-15.573-6.693-3.33-3.934-5.376-8.453-6.174-13.767h55.563c1.561 0 2.879-1.173 3.017-2.726l-.034.035Zm-57.505-11.835c1.248-4.209 3.364-7.763 6.347-10.764 3.676-3.658 8.289-5.452 14.151-5.452 5.861 0 10.717 1.553 14.15 4.727 2.81 2.622 4.821 6.487 5.931 11.455h-40.614l.035.034Z"
                    ></path>
                    <path
                        stroke="currentColor"
                        strokeWidth="2"
                        d="M530 39c5.523 0 10-4.477 10-10s-4.477-10-10-10-10 4.477-10 10 4.477 10 10 10Z"
                    ></path>
                    <path
                        fill="currentColor"
                        d="M529.39 28.096c.621 0 1.073-.124 1.344-.361.272-.226.419-.61.419-1.153 0-.531-.147-.904-.419-1.141-.271-.226-.723-.34-1.344-.34h-1.266v2.995h1.266Zm-1.266 2.068v4.407h-3.005V22.92h4.587c1.537 0 2.656.26 3.367.78.724.508 1.074 1.322 1.074 2.44 0 .769-.181 1.401-.554 1.899-.373.485-.926.858-1.683 1.084.418.102.779.317 1.107.644.328.328.655.825.983 1.503l1.638 3.3h-3.197l-1.424-2.893c-.283-.576-.576-.983-.87-1.187-.294-.214-.689-.327-1.175-.327h-.848Z"
                    ></path>
                </svg>
                <h1 className={styles.tagline}>Developer Documentation</h1>
                <div className={styles.description}>
                    Build better multichannel commerce experiences faster. Vendure is the headless commerce platform that is built to adapt to your needs. Not the other way round.
                </div>
            </div>
            <main>
                <div className={styles.ctaButtons}>
                    <Link className="button button--secondary" to="/guides/getting-started/installation/">
                        Get Started
                    </Link>
                    <Link className="button button--secondary" to="/guides/developer-guide/overview/">
                        Learn Vendure
                    </Link>
                    <Link className="button button--secondary" to="/reference/">
                        API Reference
                    </Link>
                </div>
                <div style={{ margin: '20px 50px 7rem 50px' }}>
                    <Playground
                        api={'shop'}
                        minHeight="800px"
                        server={'readonlydemo'}
                        document={`
query GetProductList {
  products(
    options: {
      take: 10
      filter: { name: { contains: "shoe" } }
      sort: { name: ASC }
    }
  ) {
    totalItems
    items {
      id
      name
      slug
      featuredAsset {
        preview
        mimeType
        width
        height
      }
    }
  }
}
`}
                    ></Playground>
                </div>
            </main>
        </Layout>
    );
}
