import { ChangeDetectionStrategy, Component } from '@angular/core';
import { TypedBaseListComponent, SharedModule } from '@vendure/admin-ui/core';

// This is the TypedDocumentNode generated by GraphQL Code Generator
import gql from 'graphql-tag';
import { TypedQueryDocumentNode } from 'graphql/utilities/index';

const getReviewListDocument = gql`
    query GetProductBundleList($options: ProductBundleListOptions) {
        productBundles(options: $options) {
            items {
                id
                createdAt
                updatedAt
                name
                description
            }
            totalItems
        }
    }
` as TypedQueryDocumentNode<
    { productBundles: any },
    {
        options: {
            filter: any;
            sort: any;
        };
    }
>;

@Component({
    selector: 'product-bundle-list',
    templateUrl: './product-bundle-list.component.html',
    changeDetection: ChangeDetectionStrategy.OnPush,
    standalone: true,
    imports: [SharedModule],
})
export class ProductBundleListComponent extends TypedBaseListComponent<
    typeof getReviewListDocument,
    'productBundles'
> {
    // Here we set up the filters that will be available
    // to use in the data table
    // readonly filters = this.createFilterCollection()
    //     .addIdFilter()
    //  //   .addDateFilters()
    //     .addFilter({
    //         name: 'name',
    //         type: { kind: 'text' },
    //         label: 'Name',
    //         filterField: 'name',
    //     })
    //     .addFilter({
    //         name: 'description',
    //         type: { kind: 'text' },
    //         label: 'Description',
    //         filterField: 'description',
    //     })
    //     .connectToRoute(this.route);

    // Here we set up the sorting options that will be available
    // to use in the data table
    readonly sorts = this.createSortCollection()
        .defaultSort('createdAt', 'DESC')
        .addSort({ name: 'createdAt' })
        .addSort({ name: 'updatedAt' })
        .addSort({ name: 'name' })
        .addSort({ name: 'description' })
        .connectToRoute(this.route);

    constructor() {
        super();
        super.configure({
            document: getReviewListDocument,
            getItems: data => (data as any).productBundles,
            setVariables: (skip, take) =>
                ({
                    options: {
                        skip,
                        take,
                        filter: {
                            name: {
                                contains: this.searchTermControl.value,
                            },
                            // ...this.filters.createFilterInput(),
                        },
                        sort: this.sorts.createSortInput(),
                    },
                }) as never,
            refreshListOnChanges: [/* this.filters.valueChanges */ this.sorts.valueChanges],
        });
    }
}
