---
title: "AssetStorageStrategy"
isDefaultIndex: false
generated: true
---
<!-- This file was generated from the Vendure source. Do not modify. Instead, re-run the "docs:build" script -->
import MemberInfo from '@site/src/components/MemberInfo';
import GenerationInfo from '@site/src/components/GenerationInfo';
import MemberDescription from '@site/src/components/MemberDescription';


## AssetStorageStrategy

<GenerationInfo sourceFile="packages/core/src/config/asset-storage-strategy/asset-storage-strategy.ts" sourceLine="32" packageName="@vendure/core" />

The AssetPersistenceStrategy determines how Asset files are physically stored
and retrieved.

:::info

This is configured via the `assetOptions.assetStorageStrategy` property of
your VendureConfig.

:::

```ts title="Signature"
interface AssetStorageStrategy extends InjectableStrategy {
    writeFileFromBuffer(fileName: string, data: Buffer): Promise<string>;
    writeFileFromStream(fileName: string, data: Stream): Promise<string>;
    readFileToBuffer(identifier: string): Promise<Buffer>;
    readFileToStream(identifier: string): Promise<Stream>;
    deleteFile(identifier: string): Promise<void>;
    fileExists(fileName: string): Promise<boolean>;
    toAbsoluteUrl?(request: Request, identifier: string): string;
}
```
* Extends: <code><a href='/reference/typescript-api/common/injectable-strategy#injectablestrategy'>InjectableStrategy</a></code>



<div className="members-wrapper">

### writeFileFromBuffer

<MemberInfo kind="method" type={`(fileName: string, data: Buffer) => Promise&#60;string&#62;`}   />

Writes a buffer to the store and returns a unique identifier for that
file such as a file path or a URL.
### writeFileFromStream

<MemberInfo kind="method" type={`(fileName: string, data: Stream) => Promise&#60;string&#62;`}   />

Writes a readable stream to the store and returns a unique identifier for that
file such as a file path or a URL.
### readFileToBuffer

<MemberInfo kind="method" type={`(identifier: string) => Promise&#60;Buffer&#62;`}   />

Reads a file based on an identifier which was generated by the writeFile
method, and returns the as a Buffer.
### readFileToStream

<MemberInfo kind="method" type={`(identifier: string) => Promise&#60;Stream&#62;`}   />

Reads a file based on an identifier which was generated by the writeFile
method, and returns the file as a Stream.
### deleteFile

<MemberInfo kind="method" type={`(identifier: string) => Promise&#60;void&#62;`}   />

Deletes a file from the storage.
### fileExists

<MemberInfo kind="method" type={`(fileName: string) => Promise&#60;boolean&#62;`}   />

Check whether a file with the given name already exists. Used to avoid
naming conflicts before saving the file.
### toAbsoluteUrl

<MemberInfo kind="method" type={`(request: Request, identifier: string) => string`}   />

Convert an identifier as generated by the writeFile... methods into an absolute
url (if it is not already in that form). If no conversion step is needed
(i.e. the identifier is already an absolute url) then this method
should not be implemented.


</div>
