// This autogenerated skeleton file illustrates how to build a server.
// You should copy it to another filename to avoid overwriting it.

#include "ThriftHive.h"
#include <protocol/TBinaryProtocol.h>
#include <server/TSimpleServer.h>
#include <transport/TServerSocket.h>
#include <transport/TBufferTransports.h>

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;

using boost::shared_ptr;

using namespace Apache::Hadoop::Hive;

class ThriftHiveHandler : virtual public ThriftHiveIf {
 public:
  ThriftHiveHandler() {
    // Your initialization goes here
  }

  void execute(const std::string& query) {
    // Your implementation goes here
    printf("execute\n");
  }

  void fetchOne(std::string& _return) {
    // Your implementation goes here
    printf("fetchOne\n");
  }

  void fetchN(std::vector<std::string> & _return, const int32_t numRows) {
    // Your implementation goes here
    printf("fetchN\n");
  }

  void fetchAll(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("fetchAll\n");
  }

  void getSchema(Apache::Hadoop::Hive::Schema& _return) {
    // Your implementation goes here
    printf("getSchema\n");
  }

  void getThriftSchema(Apache::Hadoop::Hive::Schema& _return) {
    // Your implementation goes here
    printf("getThriftSchema\n");
  }

  void getClusterStatus(HiveClusterStatus& _return) {
    // Your implementation goes here
    printf("getClusterStatus\n");
  }

  void getQueryPlan(Apache::Hadoop::Hive::QueryPlan& _return) {
    // Your implementation goes here
    printf("getQueryPlan\n");
  }

  void clean() {
    // Your implementation goes here
    printf("clean\n");
  }

};

int main(int argc, char **argv) {
  int port = 9090;
  shared_ptr<ThriftHiveHandler> handler(new ThriftHiveHandler());
  shared_ptr<TProcessor> processor(new ThriftHiveProcessor(handler));
  shared_ptr<TServerTransport> serverTransport(new TServerSocket(port));
  shared_ptr<TTransportFactory> transportFactory(new TBufferedTransportFactory());
  shared_ptr<TProtocolFactory> protocolFactory(new TBinaryProtocolFactory());

  TSimpleServer server(processor, serverTransport, transportFactory, protocolFactory);
  server.serve();
  return 0;
}

