/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hive.ql.optimizer.ppr;

import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;

/**
 * The processor context for partition pruner. This contains the table alias
 * that is being currently processed.
 */
public class ExprProcCtx implements NodeProcessorCtx {

  /**
   * The table alias that is being currently processed.
   */
  String tabAlias;

  /**
   * Flag to hold whether there are any non partition columns accessed in the
   * expression.
   */
  boolean hasNonPartCols;

  public ExprProcCtx(String tabAlias) {
    this.tabAlias = tabAlias;
    hasNonPartCols = false;
  }

  public String getTabAlias() {
    return tabAlias;
  }

  public void setTabAlias(String tabAlias) {
    this.tabAlias = tabAlias;
  }

  public boolean getHasNonPartCols() {
    return hasNonPartCols;
  }

  public void setHasNonPartCols(boolean val) {
    hasNonPartCols = val;
  }
}
