#
# Autogenerated by Thrift Compiler (0.7.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#

require 'thrift'
require 'facebook_service'
require 'hive_metastore_types'

module ThriftHiveMetastore
  class Client < FacebookService::Client 
    include ::Thrift::Client

    def create_database(database)
      send_create_database(database)
      recv_create_database()
    end

    def send_create_database(database)
      send_message('create_database', Create_database_args, :database => database)
    end

    def recv_create_database()
      result = receive_message(Create_database_result)
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      return
    end

    def get_database(name)
      send_get_database(name)
      return recv_get_database()
    end

    def send_get_database(name)
      send_message('get_database', Get_database_args, :name => name)
    end

    def recv_get_database()
      result = receive_message(Get_database_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_database failed: unknown result')
    end

    def drop_database(name, deleteData, cascade)
      send_drop_database(name, deleteData, cascade)
      recv_drop_database()
    end

    def send_drop_database(name, deleteData, cascade)
      send_message('drop_database', Drop_database_args, :name => name, :deleteData => deleteData, :cascade => cascade)
    end

    def recv_drop_database()
      result = receive_message(Drop_database_result)
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      return
    end

    def get_databases(pattern)
      send_get_databases(pattern)
      return recv_get_databases()
    end

    def send_get_databases(pattern)
      send_message('get_databases', Get_databases_args, :pattern => pattern)
    end

    def recv_get_databases()
      result = receive_message(Get_databases_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_databases failed: unknown result')
    end

    def get_all_databases()
      send_get_all_databases()
      return recv_get_all_databases()
    end

    def send_get_all_databases()
      send_message('get_all_databases', Get_all_databases_args)
    end

    def recv_get_all_databases()
      result = receive_message(Get_all_databases_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_all_databases failed: unknown result')
    end

    def alter_database(dbname, db)
      send_alter_database(dbname, db)
      recv_alter_database()
    end

    def send_alter_database(dbname, db)
      send_message('alter_database', Alter_database_args, :dbname => dbname, :db => db)
    end

    def recv_alter_database()
      result = receive_message(Alter_database_result)
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      return
    end

    def get_type(name)
      send_get_type(name)
      return recv_get_type()
    end

    def send_get_type(name)
      send_message('get_type', Get_type_args, :name => name)
    end

    def recv_get_type()
      result = receive_message(Get_type_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_type failed: unknown result')
    end

    def create_type(type)
      send_create_type(type)
      return recv_create_type()
    end

    def send_create_type(type)
      send_message('create_type', Create_type_args, :type => type)
    end

    def recv_create_type()
      result = receive_message(Create_type_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'create_type failed: unknown result')
    end

    def drop_type(type)
      send_drop_type(type)
      return recv_drop_type()
    end

    def send_drop_type(type)
      send_message('drop_type', Drop_type_args, :type => type)
    end

    def recv_drop_type()
      result = receive_message(Drop_type_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'drop_type failed: unknown result')
    end

    def get_type_all(name)
      send_get_type_all(name)
      return recv_get_type_all()
    end

    def send_get_type_all(name)
      send_message('get_type_all', Get_type_all_args, :name => name)
    end

    def recv_get_type_all()
      result = receive_message(Get_type_all_result)
      return result.success unless result.success.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_type_all failed: unknown result')
    end

    def get_fields(db_name, table_name)
      send_get_fields(db_name, table_name)
      return recv_get_fields()
    end

    def send_get_fields(db_name, table_name)
      send_message('get_fields', Get_fields_args, :db_name => db_name, :table_name => table_name)
    end

    def recv_get_fields()
      result = receive_message(Get_fields_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_fields failed: unknown result')
    end

    def get_schema(db_name, table_name)
      send_get_schema(db_name, table_name)
      return recv_get_schema()
    end

    def send_get_schema(db_name, table_name)
      send_message('get_schema', Get_schema_args, :db_name => db_name, :table_name => table_name)
    end

    def recv_get_schema()
      result = receive_message(Get_schema_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_schema failed: unknown result')
    end

    def create_table(tbl)
      send_create_table(tbl)
      recv_create_table()
    end

    def send_create_table(tbl)
      send_message('create_table', Create_table_args, :tbl => tbl)
    end

    def recv_create_table()
      result = receive_message(Create_table_result)
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise result.o4 unless result.o4.nil?
      return
    end

    def drop_table(dbname, name, deleteData)
      send_drop_table(dbname, name, deleteData)
      recv_drop_table()
    end

    def send_drop_table(dbname, name, deleteData)
      send_message('drop_table', Drop_table_args, :dbname => dbname, :name => name, :deleteData => deleteData)
    end

    def recv_drop_table()
      result = receive_message(Drop_table_result)
      raise result.o1 unless result.o1.nil?
      raise result.o3 unless result.o3.nil?
      return
    end

    def get_tables(db_name, pattern)
      send_get_tables(db_name, pattern)
      return recv_get_tables()
    end

    def send_get_tables(db_name, pattern)
      send_message('get_tables', Get_tables_args, :db_name => db_name, :pattern => pattern)
    end

    def recv_get_tables()
      result = receive_message(Get_tables_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_tables failed: unknown result')
    end

    def get_all_tables(db_name)
      send_get_all_tables(db_name)
      return recv_get_all_tables()
    end

    def send_get_all_tables(db_name)
      send_message('get_all_tables', Get_all_tables_args, :db_name => db_name)
    end

    def recv_get_all_tables()
      result = receive_message(Get_all_tables_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_all_tables failed: unknown result')
    end

    def get_table(dbname, tbl_name)
      send_get_table(dbname, tbl_name)
      return recv_get_table()
    end

    def send_get_table(dbname, tbl_name)
      send_message('get_table', Get_table_args, :dbname => dbname, :tbl_name => tbl_name)
    end

    def recv_get_table()
      result = receive_message(Get_table_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_table failed: unknown result')
    end

    def get_table_objects_by_name(dbname, tbl_names)
      send_get_table_objects_by_name(dbname, tbl_names)
      return recv_get_table_objects_by_name()
    end

    def send_get_table_objects_by_name(dbname, tbl_names)
      send_message('get_table_objects_by_name', Get_table_objects_by_name_args, :dbname => dbname, :tbl_names => tbl_names)
    end

    def recv_get_table_objects_by_name()
      result = receive_message(Get_table_objects_by_name_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_table_objects_by_name failed: unknown result')
    end

    def get_table_names_by_filter(dbname, filter, max_tables)
      send_get_table_names_by_filter(dbname, filter, max_tables)
      return recv_get_table_names_by_filter()
    end

    def send_get_table_names_by_filter(dbname, filter, max_tables)
      send_message('get_table_names_by_filter', Get_table_names_by_filter_args, :dbname => dbname, :filter => filter, :max_tables => max_tables)
    end

    def recv_get_table_names_by_filter()
      result = receive_message(Get_table_names_by_filter_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_table_names_by_filter failed: unknown result')
    end

    def alter_table(dbname, tbl_name, new_tbl)
      send_alter_table(dbname, tbl_name, new_tbl)
      recv_alter_table()
    end

    def send_alter_table(dbname, tbl_name, new_tbl)
      send_message('alter_table', Alter_table_args, :dbname => dbname, :tbl_name => tbl_name, :new_tbl => new_tbl)
    end

    def recv_alter_table()
      result = receive_message(Alter_table_result)
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      return
    end

    def add_partition(new_part)
      send_add_partition(new_part)
      return recv_add_partition()
    end

    def send_add_partition(new_part)
      send_message('add_partition', Add_partition_args, :new_part => new_part)
    end

    def recv_add_partition()
      result = receive_message(Add_partition_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'add_partition failed: unknown result')
    end

    def add_partitions(new_parts)
      send_add_partitions(new_parts)
      return recv_add_partitions()
    end

    def send_add_partitions(new_parts)
      send_message('add_partitions', Add_partitions_args, :new_parts => new_parts)
    end

    def recv_add_partitions()
      result = receive_message(Add_partitions_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'add_partitions failed: unknown result')
    end

    def append_partition(db_name, tbl_name, part_vals)
      send_append_partition(db_name, tbl_name, part_vals)
      return recv_append_partition()
    end

    def send_append_partition(db_name, tbl_name, part_vals)
      send_message('append_partition', Append_partition_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals)
    end

    def recv_append_partition()
      result = receive_message(Append_partition_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'append_partition failed: unknown result')
    end

    def append_partition_by_name(db_name, tbl_name, part_name)
      send_append_partition_by_name(db_name, tbl_name, part_name)
      return recv_append_partition_by_name()
    end

    def send_append_partition_by_name(db_name, tbl_name, part_name)
      send_message('append_partition_by_name', Append_partition_by_name_args, :db_name => db_name, :tbl_name => tbl_name, :part_name => part_name)
    end

    def recv_append_partition_by_name()
      result = receive_message(Append_partition_by_name_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'append_partition_by_name failed: unknown result')
    end

    def drop_partition(db_name, tbl_name, part_vals, deleteData)
      send_drop_partition(db_name, tbl_name, part_vals, deleteData)
      return recv_drop_partition()
    end

    def send_drop_partition(db_name, tbl_name, part_vals, deleteData)
      send_message('drop_partition', Drop_partition_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals, :deleteData => deleteData)
    end

    def recv_drop_partition()
      result = receive_message(Drop_partition_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'drop_partition failed: unknown result')
    end

    def drop_partition_by_name(db_name, tbl_name, part_name, deleteData)
      send_drop_partition_by_name(db_name, tbl_name, part_name, deleteData)
      return recv_drop_partition_by_name()
    end

    def send_drop_partition_by_name(db_name, tbl_name, part_name, deleteData)
      send_message('drop_partition_by_name', Drop_partition_by_name_args, :db_name => db_name, :tbl_name => tbl_name, :part_name => part_name, :deleteData => deleteData)
    end

    def recv_drop_partition_by_name()
      result = receive_message(Drop_partition_by_name_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'drop_partition_by_name failed: unknown result')
    end

    def get_partition(db_name, tbl_name, part_vals)
      send_get_partition(db_name, tbl_name, part_vals)
      return recv_get_partition()
    end

    def send_get_partition(db_name, tbl_name, part_vals)
      send_message('get_partition', Get_partition_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals)
    end

    def recv_get_partition()
      result = receive_message(Get_partition_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partition failed: unknown result')
    end

    def get_partition_with_auth(db_name, tbl_name, part_vals, user_name, group_names)
      send_get_partition_with_auth(db_name, tbl_name, part_vals, user_name, group_names)
      return recv_get_partition_with_auth()
    end

    def send_get_partition_with_auth(db_name, tbl_name, part_vals, user_name, group_names)
      send_message('get_partition_with_auth', Get_partition_with_auth_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals, :user_name => user_name, :group_names => group_names)
    end

    def recv_get_partition_with_auth()
      result = receive_message(Get_partition_with_auth_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partition_with_auth failed: unknown result')
    end

    def get_partition_by_name(db_name, tbl_name, part_name)
      send_get_partition_by_name(db_name, tbl_name, part_name)
      return recv_get_partition_by_name()
    end

    def send_get_partition_by_name(db_name, tbl_name, part_name)
      send_message('get_partition_by_name', Get_partition_by_name_args, :db_name => db_name, :tbl_name => tbl_name, :part_name => part_name)
    end

    def recv_get_partition_by_name()
      result = receive_message(Get_partition_by_name_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partition_by_name failed: unknown result')
    end

    def get_partitions(db_name, tbl_name, max_parts)
      send_get_partitions(db_name, tbl_name, max_parts)
      return recv_get_partitions()
    end

    def send_get_partitions(db_name, tbl_name, max_parts)
      send_message('get_partitions', Get_partitions_args, :db_name => db_name, :tbl_name => tbl_name, :max_parts => max_parts)
    end

    def recv_get_partitions()
      result = receive_message(Get_partitions_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partitions failed: unknown result')
    end

    def get_partitions_with_auth(db_name, tbl_name, max_parts, user_name, group_names)
      send_get_partitions_with_auth(db_name, tbl_name, max_parts, user_name, group_names)
      return recv_get_partitions_with_auth()
    end

    def send_get_partitions_with_auth(db_name, tbl_name, max_parts, user_name, group_names)
      send_message('get_partitions_with_auth', Get_partitions_with_auth_args, :db_name => db_name, :tbl_name => tbl_name, :max_parts => max_parts, :user_name => user_name, :group_names => group_names)
    end

    def recv_get_partitions_with_auth()
      result = receive_message(Get_partitions_with_auth_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partitions_with_auth failed: unknown result')
    end

    def get_partition_names(db_name, tbl_name, max_parts)
      send_get_partition_names(db_name, tbl_name, max_parts)
      return recv_get_partition_names()
    end

    def send_get_partition_names(db_name, tbl_name, max_parts)
      send_message('get_partition_names', Get_partition_names_args, :db_name => db_name, :tbl_name => tbl_name, :max_parts => max_parts)
    end

    def recv_get_partition_names()
      result = receive_message(Get_partition_names_result)
      return result.success unless result.success.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partition_names failed: unknown result')
    end

    def get_partitions_ps(db_name, tbl_name, part_vals, max_parts)
      send_get_partitions_ps(db_name, tbl_name, part_vals, max_parts)
      return recv_get_partitions_ps()
    end

    def send_get_partitions_ps(db_name, tbl_name, part_vals, max_parts)
      send_message('get_partitions_ps', Get_partitions_ps_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals, :max_parts => max_parts)
    end

    def recv_get_partitions_ps()
      result = receive_message(Get_partitions_ps_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partitions_ps failed: unknown result')
    end

    def get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, user_name, group_names)
      send_get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, user_name, group_names)
      return recv_get_partitions_ps_with_auth()
    end

    def send_get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, user_name, group_names)
      send_message('get_partitions_ps_with_auth', Get_partitions_ps_with_auth_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals, :max_parts => max_parts, :user_name => user_name, :group_names => group_names)
    end

    def recv_get_partitions_ps_with_auth()
      result = receive_message(Get_partitions_ps_with_auth_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partitions_ps_with_auth failed: unknown result')
    end

    def get_partition_names_ps(db_name, tbl_name, part_vals, max_parts)
      send_get_partition_names_ps(db_name, tbl_name, part_vals, max_parts)
      return recv_get_partition_names_ps()
    end

    def send_get_partition_names_ps(db_name, tbl_name, part_vals, max_parts)
      send_message('get_partition_names_ps', Get_partition_names_ps_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals, :max_parts => max_parts)
    end

    def recv_get_partition_names_ps()
      result = receive_message(Get_partition_names_ps_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partition_names_ps failed: unknown result')
    end

    def get_partitions_by_filter(db_name, tbl_name, filter, max_parts)
      send_get_partitions_by_filter(db_name, tbl_name, filter, max_parts)
      return recv_get_partitions_by_filter()
    end

    def send_get_partitions_by_filter(db_name, tbl_name, filter, max_parts)
      send_message('get_partitions_by_filter', Get_partitions_by_filter_args, :db_name => db_name, :tbl_name => tbl_name, :filter => filter, :max_parts => max_parts)
    end

    def recv_get_partitions_by_filter()
      result = receive_message(Get_partitions_by_filter_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partitions_by_filter failed: unknown result')
    end

    def get_partitions_by_names(db_name, tbl_name, names)
      send_get_partitions_by_names(db_name, tbl_name, names)
      return recv_get_partitions_by_names()
    end

    def send_get_partitions_by_names(db_name, tbl_name, names)
      send_message('get_partitions_by_names', Get_partitions_by_names_args, :db_name => db_name, :tbl_name => tbl_name, :names => names)
    end

    def recv_get_partitions_by_names()
      result = receive_message(Get_partitions_by_names_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_partitions_by_names failed: unknown result')
    end

    def alter_partition(db_name, tbl_name, new_part)
      send_alter_partition(db_name, tbl_name, new_part)
      recv_alter_partition()
    end

    def send_alter_partition(db_name, tbl_name, new_part)
      send_message('alter_partition', Alter_partition_args, :db_name => db_name, :tbl_name => tbl_name, :new_part => new_part)
    end

    def recv_alter_partition()
      result = receive_message(Alter_partition_result)
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      return
    end

    def rename_partition(db_name, tbl_name, part_vals, new_part)
      send_rename_partition(db_name, tbl_name, part_vals, new_part)
      recv_rename_partition()
    end

    def send_rename_partition(db_name, tbl_name, part_vals, new_part)
      send_message('rename_partition', Rename_partition_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals, :new_part => new_part)
    end

    def recv_rename_partition()
      result = receive_message(Rename_partition_result)
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      return
    end

    def get_config_value(name, defaultValue)
      send_get_config_value(name, defaultValue)
      return recv_get_config_value()
    end

    def send_get_config_value(name, defaultValue)
      send_message('get_config_value', Get_config_value_args, :name => name, :defaultValue => defaultValue)
    end

    def recv_get_config_value()
      result = receive_message(Get_config_value_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_config_value failed: unknown result')
    end

    def partition_name_to_vals(part_name)
      send_partition_name_to_vals(part_name)
      return recv_partition_name_to_vals()
    end

    def send_partition_name_to_vals(part_name)
      send_message('partition_name_to_vals', Partition_name_to_vals_args, :part_name => part_name)
    end

    def recv_partition_name_to_vals()
      result = receive_message(Partition_name_to_vals_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'partition_name_to_vals failed: unknown result')
    end

    def partition_name_to_spec(part_name)
      send_partition_name_to_spec(part_name)
      return recv_partition_name_to_spec()
    end

    def send_partition_name_to_spec(part_name)
      send_message('partition_name_to_spec', Partition_name_to_spec_args, :part_name => part_name)
    end

    def recv_partition_name_to_spec()
      result = receive_message(Partition_name_to_spec_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'partition_name_to_spec failed: unknown result')
    end

    def markPartitionForEvent(db_name, tbl_name, part_vals, eventType)
      send_markPartitionForEvent(db_name, tbl_name, part_vals, eventType)
      recv_markPartitionForEvent()
    end

    def send_markPartitionForEvent(db_name, tbl_name, part_vals, eventType)
      send_message('markPartitionForEvent', MarkPartitionForEvent_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals, :eventType => eventType)
    end

    def recv_markPartitionForEvent()
      result = receive_message(MarkPartitionForEvent_result)
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise result.o4 unless result.o4.nil?
      raise result.o5 unless result.o5.nil?
      raise result.o6 unless result.o6.nil?
      return
    end

    def isPartitionMarkedForEvent(db_name, tbl_name, part_vals, eventType)
      send_isPartitionMarkedForEvent(db_name, tbl_name, part_vals, eventType)
      return recv_isPartitionMarkedForEvent()
    end

    def send_isPartitionMarkedForEvent(db_name, tbl_name, part_vals, eventType)
      send_message('isPartitionMarkedForEvent', IsPartitionMarkedForEvent_args, :db_name => db_name, :tbl_name => tbl_name, :part_vals => part_vals, :eventType => eventType)
    end

    def recv_isPartitionMarkedForEvent()
      result = receive_message(IsPartitionMarkedForEvent_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise result.o4 unless result.o4.nil?
      raise result.o5 unless result.o5.nil?
      raise result.o6 unless result.o6.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'isPartitionMarkedForEvent failed: unknown result')
    end

    def add_index(new_index, index_table)
      send_add_index(new_index, index_table)
      return recv_add_index()
    end

    def send_add_index(new_index, index_table)
      send_message('add_index', Add_index_args, :new_index => new_index, :index_table => index_table)
    end

    def recv_add_index()
      result = receive_message(Add_index_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise result.o3 unless result.o3.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'add_index failed: unknown result')
    end

    def alter_index(dbname, base_tbl_name, idx_name, new_idx)
      send_alter_index(dbname, base_tbl_name, idx_name, new_idx)
      recv_alter_index()
    end

    def send_alter_index(dbname, base_tbl_name, idx_name, new_idx)
      send_message('alter_index', Alter_index_args, :dbname => dbname, :base_tbl_name => base_tbl_name, :idx_name => idx_name, :new_idx => new_idx)
    end

    def recv_alter_index()
      result = receive_message(Alter_index_result)
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      return
    end

    def drop_index_by_name(db_name, tbl_name, index_name, deleteData)
      send_drop_index_by_name(db_name, tbl_name, index_name, deleteData)
      return recv_drop_index_by_name()
    end

    def send_drop_index_by_name(db_name, tbl_name, index_name, deleteData)
      send_message('drop_index_by_name', Drop_index_by_name_args, :db_name => db_name, :tbl_name => tbl_name, :index_name => index_name, :deleteData => deleteData)
    end

    def recv_drop_index_by_name()
      result = receive_message(Drop_index_by_name_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'drop_index_by_name failed: unknown result')
    end

    def get_index_by_name(db_name, tbl_name, index_name)
      send_get_index_by_name(db_name, tbl_name, index_name)
      return recv_get_index_by_name()
    end

    def send_get_index_by_name(db_name, tbl_name, index_name)
      send_message('get_index_by_name', Get_index_by_name_args, :db_name => db_name, :tbl_name => tbl_name, :index_name => index_name)
    end

    def recv_get_index_by_name()
      result = receive_message(Get_index_by_name_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_index_by_name failed: unknown result')
    end

    def get_indexes(db_name, tbl_name, max_indexes)
      send_get_indexes(db_name, tbl_name, max_indexes)
      return recv_get_indexes()
    end

    def send_get_indexes(db_name, tbl_name, max_indexes)
      send_message('get_indexes', Get_indexes_args, :db_name => db_name, :tbl_name => tbl_name, :max_indexes => max_indexes)
    end

    def recv_get_indexes()
      result = receive_message(Get_indexes_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_indexes failed: unknown result')
    end

    def get_index_names(db_name, tbl_name, max_indexes)
      send_get_index_names(db_name, tbl_name, max_indexes)
      return recv_get_index_names()
    end

    def send_get_index_names(db_name, tbl_name, max_indexes)
      send_message('get_index_names', Get_index_names_args, :db_name => db_name, :tbl_name => tbl_name, :max_indexes => max_indexes)
    end

    def recv_get_index_names()
      result = receive_message(Get_index_names_result)
      return result.success unless result.success.nil?
      raise result.o2 unless result.o2.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_index_names failed: unknown result')
    end

    def create_role(role)
      send_create_role(role)
      return recv_create_role()
    end

    def send_create_role(role)
      send_message('create_role', Create_role_args, :role => role)
    end

    def recv_create_role()
      result = receive_message(Create_role_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'create_role failed: unknown result')
    end

    def drop_role(role_name)
      send_drop_role(role_name)
      return recv_drop_role()
    end

    def send_drop_role(role_name)
      send_message('drop_role', Drop_role_args, :role_name => role_name)
    end

    def recv_drop_role()
      result = receive_message(Drop_role_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'drop_role failed: unknown result')
    end

    def get_role_names()
      send_get_role_names()
      return recv_get_role_names()
    end

    def send_get_role_names()
      send_message('get_role_names', Get_role_names_args)
    end

    def recv_get_role_names()
      result = receive_message(Get_role_names_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_role_names failed: unknown result')
    end

    def grant_role(role_name, principal_name, principal_type, grantor, grantorType, grant_option)
      send_grant_role(role_name, principal_name, principal_type, grantor, grantorType, grant_option)
      return recv_grant_role()
    end

    def send_grant_role(role_name, principal_name, principal_type, grantor, grantorType, grant_option)
      send_message('grant_role', Grant_role_args, :role_name => role_name, :principal_name => principal_name, :principal_type => principal_type, :grantor => grantor, :grantorType => grantorType, :grant_option => grant_option)
    end

    def recv_grant_role()
      result = receive_message(Grant_role_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'grant_role failed: unknown result')
    end

    def revoke_role(role_name, principal_name, principal_type)
      send_revoke_role(role_name, principal_name, principal_type)
      return recv_revoke_role()
    end

    def send_revoke_role(role_name, principal_name, principal_type)
      send_message('revoke_role', Revoke_role_args, :role_name => role_name, :principal_name => principal_name, :principal_type => principal_type)
    end

    def recv_revoke_role()
      result = receive_message(Revoke_role_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'revoke_role failed: unknown result')
    end

    def list_roles(principal_name, principal_type)
      send_list_roles(principal_name, principal_type)
      return recv_list_roles()
    end

    def send_list_roles(principal_name, principal_type)
      send_message('list_roles', List_roles_args, :principal_name => principal_name, :principal_type => principal_type)
    end

    def recv_list_roles()
      result = receive_message(List_roles_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'list_roles failed: unknown result')
    end

    def get_privilege_set(hiveObject, user_name, group_names)
      send_get_privilege_set(hiveObject, user_name, group_names)
      return recv_get_privilege_set()
    end

    def send_get_privilege_set(hiveObject, user_name, group_names)
      send_message('get_privilege_set', Get_privilege_set_args, :hiveObject => hiveObject, :user_name => user_name, :group_names => group_names)
    end

    def recv_get_privilege_set()
      result = receive_message(Get_privilege_set_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_privilege_set failed: unknown result')
    end

    def list_privileges(principal_name, principal_type, hiveObject)
      send_list_privileges(principal_name, principal_type, hiveObject)
      return recv_list_privileges()
    end

    def send_list_privileges(principal_name, principal_type, hiveObject)
      send_message('list_privileges', List_privileges_args, :principal_name => principal_name, :principal_type => principal_type, :hiveObject => hiveObject)
    end

    def recv_list_privileges()
      result = receive_message(List_privileges_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'list_privileges failed: unknown result')
    end

    def grant_privileges(privileges)
      send_grant_privileges(privileges)
      return recv_grant_privileges()
    end

    def send_grant_privileges(privileges)
      send_message('grant_privileges', Grant_privileges_args, :privileges => privileges)
    end

    def recv_grant_privileges()
      result = receive_message(Grant_privileges_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'grant_privileges failed: unknown result')
    end

    def revoke_privileges(privileges)
      send_revoke_privileges(privileges)
      return recv_revoke_privileges()
    end

    def send_revoke_privileges(privileges)
      send_message('revoke_privileges', Revoke_privileges_args, :privileges => privileges)
    end

    def recv_revoke_privileges()
      result = receive_message(Revoke_privileges_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'revoke_privileges failed: unknown result')
    end

    def set_ugi(user_name, group_names)
      send_set_ugi(user_name, group_names)
      return recv_set_ugi()
    end

    def send_set_ugi(user_name, group_names)
      send_message('set_ugi', Set_ugi_args, :user_name => user_name, :group_names => group_names)
    end

    def recv_set_ugi()
      result = receive_message(Set_ugi_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'set_ugi failed: unknown result')
    end

    def get_delegation_token(token_owner, renewer_kerberos_principal_name)
      send_get_delegation_token(token_owner, renewer_kerberos_principal_name)
      return recv_get_delegation_token()
    end

    def send_get_delegation_token(token_owner, renewer_kerberos_principal_name)
      send_message('get_delegation_token', Get_delegation_token_args, :token_owner => token_owner, :renewer_kerberos_principal_name => renewer_kerberos_principal_name)
    end

    def recv_get_delegation_token()
      result = receive_message(Get_delegation_token_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_delegation_token failed: unknown result')
    end

    def renew_delegation_token(token_str_form)
      send_renew_delegation_token(token_str_form)
      return recv_renew_delegation_token()
    end

    def send_renew_delegation_token(token_str_form)
      send_message('renew_delegation_token', Renew_delegation_token_args, :token_str_form => token_str_form)
    end

    def recv_renew_delegation_token()
      result = receive_message(Renew_delegation_token_result)
      return result.success unless result.success.nil?
      raise result.o1 unless result.o1.nil?
      raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'renew_delegation_token failed: unknown result')
    end

    def cancel_delegation_token(token_str_form)
      send_cancel_delegation_token(token_str_form)
      recv_cancel_delegation_token()
    end

    def send_cancel_delegation_token(token_str_form)
      send_message('cancel_delegation_token', Cancel_delegation_token_args, :token_str_form => token_str_form)
    end

    def recv_cancel_delegation_token()
      result = receive_message(Cancel_delegation_token_result)
      raise result.o1 unless result.o1.nil?
      return
    end

  end

  class Processor < FacebookService::Processor 
    include ::Thrift::Processor

    def process_create_database(seqid, iprot, oprot)
      args = read_args(iprot, Create_database_args)
      result = Create_database_result.new()
      begin
        @handler.create_database(args.database)
      rescue AlreadyExistsException => o1
        result.o1 = o1
      rescue InvalidObjectException => o2
        result.o2 = o2
      rescue MetaException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'create_database', seqid)
    end

    def process_get_database(seqid, iprot, oprot)
      args = read_args(iprot, Get_database_args)
      result = Get_database_result.new()
      begin
        result.success = @handler.get_database(args.name)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_database', seqid)
    end

    def process_drop_database(seqid, iprot, oprot)
      args = read_args(iprot, Drop_database_args)
      result = Drop_database_result.new()
      begin
        @handler.drop_database(args.name, args.deleteData, args.cascade)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue InvalidOperationException => o2
        result.o2 = o2
      rescue MetaException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'drop_database', seqid)
    end

    def process_get_databases(seqid, iprot, oprot)
      args = read_args(iprot, Get_databases_args)
      result = Get_databases_result.new()
      begin
        result.success = @handler.get_databases(args.pattern)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'get_databases', seqid)
    end

    def process_get_all_databases(seqid, iprot, oprot)
      args = read_args(iprot, Get_all_databases_args)
      result = Get_all_databases_result.new()
      begin
        result.success = @handler.get_all_databases()
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'get_all_databases', seqid)
    end

    def process_alter_database(seqid, iprot, oprot)
      args = read_args(iprot, Alter_database_args)
      result = Alter_database_result.new()
      begin
        @handler.alter_database(args.dbname, args.db)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'alter_database', seqid)
    end

    def process_get_type(seqid, iprot, oprot)
      args = read_args(iprot, Get_type_args)
      result = Get_type_result.new()
      begin
        result.success = @handler.get_type(args.name)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_type', seqid)
    end

    def process_create_type(seqid, iprot, oprot)
      args = read_args(iprot, Create_type_args)
      result = Create_type_result.new()
      begin
        result.success = @handler.create_type(args.type)
      rescue AlreadyExistsException => o1
        result.o1 = o1
      rescue InvalidObjectException => o2
        result.o2 = o2
      rescue MetaException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'create_type', seqid)
    end

    def process_drop_type(seqid, iprot, oprot)
      args = read_args(iprot, Drop_type_args)
      result = Drop_type_result.new()
      begin
        result.success = @handler.drop_type(args.type)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'drop_type', seqid)
    end

    def process_get_type_all(seqid, iprot, oprot)
      args = read_args(iprot, Get_type_all_args)
      result = Get_type_all_result.new()
      begin
        result.success = @handler.get_type_all(args.name)
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_type_all', seqid)
    end

    def process_get_fields(seqid, iprot, oprot)
      args = read_args(iprot, Get_fields_args)
      result = Get_fields_result.new()
      begin
        result.success = @handler.get_fields(args.db_name, args.table_name)
      rescue MetaException => o1
        result.o1 = o1
      rescue UnknownTableException => o2
        result.o2 = o2
      rescue UnknownDBException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'get_fields', seqid)
    end

    def process_get_schema(seqid, iprot, oprot)
      args = read_args(iprot, Get_schema_args)
      result = Get_schema_result.new()
      begin
        result.success = @handler.get_schema(args.db_name, args.table_name)
      rescue MetaException => o1
        result.o1 = o1
      rescue UnknownTableException => o2
        result.o2 = o2
      rescue UnknownDBException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'get_schema', seqid)
    end

    def process_create_table(seqid, iprot, oprot)
      args = read_args(iprot, Create_table_args)
      result = Create_table_result.new()
      begin
        @handler.create_table(args.tbl)
      rescue AlreadyExistsException => o1
        result.o1 = o1
      rescue InvalidObjectException => o2
        result.o2 = o2
      rescue MetaException => o3
        result.o3 = o3
      rescue NoSuchObjectException => o4
        result.o4 = o4
      end
      write_result(result, oprot, 'create_table', seqid)
    end

    def process_drop_table(seqid, iprot, oprot)
      args = read_args(iprot, Drop_table_args)
      result = Drop_table_result.new()
      begin
        @handler.drop_table(args.dbname, args.name, args.deleteData)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue MetaException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'drop_table', seqid)
    end

    def process_get_tables(seqid, iprot, oprot)
      args = read_args(iprot, Get_tables_args)
      result = Get_tables_result.new()
      begin
        result.success = @handler.get_tables(args.db_name, args.pattern)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'get_tables', seqid)
    end

    def process_get_all_tables(seqid, iprot, oprot)
      args = read_args(iprot, Get_all_tables_args)
      result = Get_all_tables_result.new()
      begin
        result.success = @handler.get_all_tables(args.db_name)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'get_all_tables', seqid)
    end

    def process_get_table(seqid, iprot, oprot)
      args = read_args(iprot, Get_table_args)
      result = Get_table_result.new()
      begin
        result.success = @handler.get_table(args.dbname, args.tbl_name)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_table', seqid)
    end

    def process_get_table_objects_by_name(seqid, iprot, oprot)
      args = read_args(iprot, Get_table_objects_by_name_args)
      result = Get_table_objects_by_name_result.new()
      begin
        result.success = @handler.get_table_objects_by_name(args.dbname, args.tbl_names)
      rescue MetaException => o1
        result.o1 = o1
      rescue InvalidOperationException => o2
        result.o2 = o2
      rescue UnknownDBException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'get_table_objects_by_name', seqid)
    end

    def process_get_table_names_by_filter(seqid, iprot, oprot)
      args = read_args(iprot, Get_table_names_by_filter_args)
      result = Get_table_names_by_filter_result.new()
      begin
        result.success = @handler.get_table_names_by_filter(args.dbname, args.filter, args.max_tables)
      rescue MetaException => o1
        result.o1 = o1
      rescue InvalidOperationException => o2
        result.o2 = o2
      rescue UnknownDBException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'get_table_names_by_filter', seqid)
    end

    def process_alter_table(seqid, iprot, oprot)
      args = read_args(iprot, Alter_table_args)
      result = Alter_table_result.new()
      begin
        @handler.alter_table(args.dbname, args.tbl_name, args.new_tbl)
      rescue InvalidOperationException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'alter_table', seqid)
    end

    def process_add_partition(seqid, iprot, oprot)
      args = read_args(iprot, Add_partition_args)
      result = Add_partition_result.new()
      begin
        result.success = @handler.add_partition(args.new_part)
      rescue InvalidObjectException => o1
        result.o1 = o1
      rescue AlreadyExistsException => o2
        result.o2 = o2
      rescue MetaException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'add_partition', seqid)
    end

    def process_add_partitions(seqid, iprot, oprot)
      args = read_args(iprot, Add_partitions_args)
      result = Add_partitions_result.new()
      begin
        result.success = @handler.add_partitions(args.new_parts)
      rescue InvalidObjectException => o1
        result.o1 = o1
      rescue AlreadyExistsException => o2
        result.o2 = o2
      rescue MetaException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'add_partitions', seqid)
    end

    def process_append_partition(seqid, iprot, oprot)
      args = read_args(iprot, Append_partition_args)
      result = Append_partition_result.new()
      begin
        result.success = @handler.append_partition(args.db_name, args.tbl_name, args.part_vals)
      rescue InvalidObjectException => o1
        result.o1 = o1
      rescue AlreadyExistsException => o2
        result.o2 = o2
      rescue MetaException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'append_partition', seqid)
    end

    def process_append_partition_by_name(seqid, iprot, oprot)
      args = read_args(iprot, Append_partition_by_name_args)
      result = Append_partition_by_name_result.new()
      begin
        result.success = @handler.append_partition_by_name(args.db_name, args.tbl_name, args.part_name)
      rescue InvalidObjectException => o1
        result.o1 = o1
      rescue AlreadyExistsException => o2
        result.o2 = o2
      rescue MetaException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'append_partition_by_name', seqid)
    end

    def process_drop_partition(seqid, iprot, oprot)
      args = read_args(iprot, Drop_partition_args)
      result = Drop_partition_result.new()
      begin
        result.success = @handler.drop_partition(args.db_name, args.tbl_name, args.part_vals, args.deleteData)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'drop_partition', seqid)
    end

    def process_drop_partition_by_name(seqid, iprot, oprot)
      args = read_args(iprot, Drop_partition_by_name_args)
      result = Drop_partition_by_name_result.new()
      begin
        result.success = @handler.drop_partition_by_name(args.db_name, args.tbl_name, args.part_name, args.deleteData)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'drop_partition_by_name', seqid)
    end

    def process_get_partition(seqid, iprot, oprot)
      args = read_args(iprot, Get_partition_args)
      result = Get_partition_result.new()
      begin
        result.success = @handler.get_partition(args.db_name, args.tbl_name, args.part_vals)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partition', seqid)
    end

    def process_get_partition_with_auth(seqid, iprot, oprot)
      args = read_args(iprot, Get_partition_with_auth_args)
      result = Get_partition_with_auth_result.new()
      begin
        result.success = @handler.get_partition_with_auth(args.db_name, args.tbl_name, args.part_vals, args.user_name, args.group_names)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partition_with_auth', seqid)
    end

    def process_get_partition_by_name(seqid, iprot, oprot)
      args = read_args(iprot, Get_partition_by_name_args)
      result = Get_partition_by_name_result.new()
      begin
        result.success = @handler.get_partition_by_name(args.db_name, args.tbl_name, args.part_name)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partition_by_name', seqid)
    end

    def process_get_partitions(seqid, iprot, oprot)
      args = read_args(iprot, Get_partitions_args)
      result = Get_partitions_result.new()
      begin
        result.success = @handler.get_partitions(args.db_name, args.tbl_name, args.max_parts)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partitions', seqid)
    end

    def process_get_partitions_with_auth(seqid, iprot, oprot)
      args = read_args(iprot, Get_partitions_with_auth_args)
      result = Get_partitions_with_auth_result.new()
      begin
        result.success = @handler.get_partitions_with_auth(args.db_name, args.tbl_name, args.max_parts, args.user_name, args.group_names)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partitions_with_auth', seqid)
    end

    def process_get_partition_names(seqid, iprot, oprot)
      args = read_args(iprot, Get_partition_names_args)
      result = Get_partition_names_result.new()
      begin
        result.success = @handler.get_partition_names(args.db_name, args.tbl_name, args.max_parts)
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partition_names', seqid)
    end

    def process_get_partitions_ps(seqid, iprot, oprot)
      args = read_args(iprot, Get_partitions_ps_args)
      result = Get_partitions_ps_result.new()
      begin
        result.success = @handler.get_partitions_ps(args.db_name, args.tbl_name, args.part_vals, args.max_parts)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partitions_ps', seqid)
    end

    def process_get_partitions_ps_with_auth(seqid, iprot, oprot)
      args = read_args(iprot, Get_partitions_ps_with_auth_args)
      result = Get_partitions_ps_with_auth_result.new()
      begin
        result.success = @handler.get_partitions_ps_with_auth(args.db_name, args.tbl_name, args.part_vals, args.max_parts, args.user_name, args.group_names)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partitions_ps_with_auth', seqid)
    end

    def process_get_partition_names_ps(seqid, iprot, oprot)
      args = read_args(iprot, Get_partition_names_ps_args)
      result = Get_partition_names_ps_result.new()
      begin
        result.success = @handler.get_partition_names_ps(args.db_name, args.tbl_name, args.part_vals, args.max_parts)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partition_names_ps', seqid)
    end

    def process_get_partitions_by_filter(seqid, iprot, oprot)
      args = read_args(iprot, Get_partitions_by_filter_args)
      result = Get_partitions_by_filter_result.new()
      begin
        result.success = @handler.get_partitions_by_filter(args.db_name, args.tbl_name, args.filter, args.max_parts)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partitions_by_filter', seqid)
    end

    def process_get_partitions_by_names(seqid, iprot, oprot)
      args = read_args(iprot, Get_partitions_by_names_args)
      result = Get_partitions_by_names_result.new()
      begin
        result.success = @handler.get_partitions_by_names(args.db_name, args.tbl_name, args.names)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_partitions_by_names', seqid)
    end

    def process_alter_partition(seqid, iprot, oprot)
      args = read_args(iprot, Alter_partition_args)
      result = Alter_partition_result.new()
      begin
        @handler.alter_partition(args.db_name, args.tbl_name, args.new_part)
      rescue InvalidOperationException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'alter_partition', seqid)
    end

    def process_rename_partition(seqid, iprot, oprot)
      args = read_args(iprot, Rename_partition_args)
      result = Rename_partition_result.new()
      begin
        @handler.rename_partition(args.db_name, args.tbl_name, args.part_vals, args.new_part)
      rescue InvalidOperationException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'rename_partition', seqid)
    end

    def process_get_config_value(seqid, iprot, oprot)
      args = read_args(iprot, Get_config_value_args)
      result = Get_config_value_result.new()
      begin
        result.success = @handler.get_config_value(args.name, args.defaultValue)
      rescue ConfigValSecurityException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'get_config_value', seqid)
    end

    def process_partition_name_to_vals(seqid, iprot, oprot)
      args = read_args(iprot, Partition_name_to_vals_args)
      result = Partition_name_to_vals_result.new()
      begin
        result.success = @handler.partition_name_to_vals(args.part_name)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'partition_name_to_vals', seqid)
    end

    def process_partition_name_to_spec(seqid, iprot, oprot)
      args = read_args(iprot, Partition_name_to_spec_args)
      result = Partition_name_to_spec_result.new()
      begin
        result.success = @handler.partition_name_to_spec(args.part_name)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'partition_name_to_spec', seqid)
    end

    def process_markPartitionForEvent(seqid, iprot, oprot)
      args = read_args(iprot, MarkPartitionForEvent_args)
      result = MarkPartitionForEvent_result.new()
      begin
        @handler.markPartitionForEvent(args.db_name, args.tbl_name, args.part_vals, args.eventType)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      rescue UnknownDBException => o3
        result.o3 = o3
      rescue UnknownTableException => o4
        result.o4 = o4
      rescue UnknownPartitionException => o5
        result.o5 = o5
      rescue InvalidPartitionException => o6
        result.o6 = o6
      end
      write_result(result, oprot, 'markPartitionForEvent', seqid)
    end

    def process_isPartitionMarkedForEvent(seqid, iprot, oprot)
      args = read_args(iprot, IsPartitionMarkedForEvent_args)
      result = IsPartitionMarkedForEvent_result.new()
      begin
        result.success = @handler.isPartitionMarkedForEvent(args.db_name, args.tbl_name, args.part_vals, args.eventType)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      rescue UnknownDBException => o3
        result.o3 = o3
      rescue UnknownTableException => o4
        result.o4 = o4
      rescue UnknownPartitionException => o5
        result.o5 = o5
      rescue InvalidPartitionException => o6
        result.o6 = o6
      end
      write_result(result, oprot, 'isPartitionMarkedForEvent', seqid)
    end

    def process_add_index(seqid, iprot, oprot)
      args = read_args(iprot, Add_index_args)
      result = Add_index_result.new()
      begin
        result.success = @handler.add_index(args.new_index, args.index_table)
      rescue InvalidObjectException => o1
        result.o1 = o1
      rescue AlreadyExistsException => o2
        result.o2 = o2
      rescue MetaException => o3
        result.o3 = o3
      end
      write_result(result, oprot, 'add_index', seqid)
    end

    def process_alter_index(seqid, iprot, oprot)
      args = read_args(iprot, Alter_index_args)
      result = Alter_index_result.new()
      begin
        @handler.alter_index(args.dbname, args.base_tbl_name, args.idx_name, args.new_idx)
      rescue InvalidOperationException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'alter_index', seqid)
    end

    def process_drop_index_by_name(seqid, iprot, oprot)
      args = read_args(iprot, Drop_index_by_name_args)
      result = Drop_index_by_name_result.new()
      begin
        result.success = @handler.drop_index_by_name(args.db_name, args.tbl_name, args.index_name, args.deleteData)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'drop_index_by_name', seqid)
    end

    def process_get_index_by_name(seqid, iprot, oprot)
      args = read_args(iprot, Get_index_by_name_args)
      result = Get_index_by_name_result.new()
      begin
        result.success = @handler.get_index_by_name(args.db_name, args.tbl_name, args.index_name)
      rescue MetaException => o1
        result.o1 = o1
      rescue NoSuchObjectException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_index_by_name', seqid)
    end

    def process_get_indexes(seqid, iprot, oprot)
      args = read_args(iprot, Get_indexes_args)
      result = Get_indexes_result.new()
      begin
        result.success = @handler.get_indexes(args.db_name, args.tbl_name, args.max_indexes)
      rescue NoSuchObjectException => o1
        result.o1 = o1
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_indexes', seqid)
    end

    def process_get_index_names(seqid, iprot, oprot)
      args = read_args(iprot, Get_index_names_args)
      result = Get_index_names_result.new()
      begin
        result.success = @handler.get_index_names(args.db_name, args.tbl_name, args.max_indexes)
      rescue MetaException => o2
        result.o2 = o2
      end
      write_result(result, oprot, 'get_index_names', seqid)
    end

    def process_create_role(seqid, iprot, oprot)
      args = read_args(iprot, Create_role_args)
      result = Create_role_result.new()
      begin
        result.success = @handler.create_role(args.role)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'create_role', seqid)
    end

    def process_drop_role(seqid, iprot, oprot)
      args = read_args(iprot, Drop_role_args)
      result = Drop_role_result.new()
      begin
        result.success = @handler.drop_role(args.role_name)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'drop_role', seqid)
    end

    def process_get_role_names(seqid, iprot, oprot)
      args = read_args(iprot, Get_role_names_args)
      result = Get_role_names_result.new()
      begin
        result.success = @handler.get_role_names()
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'get_role_names', seqid)
    end

    def process_grant_role(seqid, iprot, oprot)
      args = read_args(iprot, Grant_role_args)
      result = Grant_role_result.new()
      begin
        result.success = @handler.grant_role(args.role_name, args.principal_name, args.principal_type, args.grantor, args.grantorType, args.grant_option)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'grant_role', seqid)
    end

    def process_revoke_role(seqid, iprot, oprot)
      args = read_args(iprot, Revoke_role_args)
      result = Revoke_role_result.new()
      begin
        result.success = @handler.revoke_role(args.role_name, args.principal_name, args.principal_type)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'revoke_role', seqid)
    end

    def process_list_roles(seqid, iprot, oprot)
      args = read_args(iprot, List_roles_args)
      result = List_roles_result.new()
      begin
        result.success = @handler.list_roles(args.principal_name, args.principal_type)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'list_roles', seqid)
    end

    def process_get_privilege_set(seqid, iprot, oprot)
      args = read_args(iprot, Get_privilege_set_args)
      result = Get_privilege_set_result.new()
      begin
        result.success = @handler.get_privilege_set(args.hiveObject, args.user_name, args.group_names)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'get_privilege_set', seqid)
    end

    def process_list_privileges(seqid, iprot, oprot)
      args = read_args(iprot, List_privileges_args)
      result = List_privileges_result.new()
      begin
        result.success = @handler.list_privileges(args.principal_name, args.principal_type, args.hiveObject)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'list_privileges', seqid)
    end

    def process_grant_privileges(seqid, iprot, oprot)
      args = read_args(iprot, Grant_privileges_args)
      result = Grant_privileges_result.new()
      begin
        result.success = @handler.grant_privileges(args.privileges)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'grant_privileges', seqid)
    end

    def process_revoke_privileges(seqid, iprot, oprot)
      args = read_args(iprot, Revoke_privileges_args)
      result = Revoke_privileges_result.new()
      begin
        result.success = @handler.revoke_privileges(args.privileges)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'revoke_privileges', seqid)
    end

    def process_set_ugi(seqid, iprot, oprot)
      args = read_args(iprot, Set_ugi_args)
      result = Set_ugi_result.new()
      begin
        result.success = @handler.set_ugi(args.user_name, args.group_names)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'set_ugi', seqid)
    end

    def process_get_delegation_token(seqid, iprot, oprot)
      args = read_args(iprot, Get_delegation_token_args)
      result = Get_delegation_token_result.new()
      begin
        result.success = @handler.get_delegation_token(args.token_owner, args.renewer_kerberos_principal_name)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'get_delegation_token', seqid)
    end

    def process_renew_delegation_token(seqid, iprot, oprot)
      args = read_args(iprot, Renew_delegation_token_args)
      result = Renew_delegation_token_result.new()
      begin
        result.success = @handler.renew_delegation_token(args.token_str_form)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'renew_delegation_token', seqid)
    end

    def process_cancel_delegation_token(seqid, iprot, oprot)
      args = read_args(iprot, Cancel_delegation_token_args)
      result = Cancel_delegation_token_result.new()
      begin
        @handler.cancel_delegation_token(args.token_str_form)
      rescue MetaException => o1
        result.o1 = o1
      end
      write_result(result, oprot, 'cancel_delegation_token', seqid)
    end

  end

  # HELPER FUNCTIONS AND STRUCTURES

  class Create_database_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DATABASE = 1

    FIELDS = {
      DATABASE => {:type => ::Thrift::Types::STRUCT, :name => 'database', :class => Database}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Create_database_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => AlreadyExistsException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => InvalidObjectException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_database_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    NAME = 1

    FIELDS = {
      NAME => {:type => ::Thrift::Types::STRING, :name => 'name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_database_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Database},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_database_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    NAME = 1
    DELETEDATA = 2
    CASCADE = 3

    FIELDS = {
      NAME => {:type => ::Thrift::Types::STRING, :name => 'name'},
      DELETEDATA => {:type => ::Thrift::Types::BOOL, :name => 'deleteData'},
      CASCADE => {:type => ::Thrift::Types::BOOL, :name => 'cascade'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_database_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => InvalidOperationException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_databases_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    PATTERN = 1

    FIELDS = {
      PATTERN => {:type => ::Thrift::Types::STRING, :name => 'pattern'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_databases_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_all_databases_args
    include ::Thrift::Struct, ::Thrift::Struct_Union

    FIELDS = {

    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_all_databases_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Alter_database_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DBNAME = 1
    DB = 2

    FIELDS = {
      DBNAME => {:type => ::Thrift::Types::STRING, :name => 'dbname'},
      DB => {:type => ::Thrift::Types::STRUCT, :name => 'db', :class => Database}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Alter_database_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O2 = 2

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_type_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    NAME = 1

    FIELDS = {
      NAME => {:type => ::Thrift::Types::STRING, :name => 'name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_type_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Type},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Create_type_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    TYPE = 1

    FIELDS = {
      TYPE => {:type => ::Thrift::Types::STRUCT, :name => 'type', :class => Type}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Create_type_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => AlreadyExistsException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => InvalidObjectException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_type_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    TYPE = 1

    FIELDS = {
      TYPE => {:type => ::Thrift::Types::STRING, :name => 'type'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_type_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_type_all_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    NAME = 1

    FIELDS = {
      NAME => {:type => ::Thrift::Types::STRING, :name => 'name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_type_all_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O2 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::MAP, :name => 'success', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::STRUCT, :class => Type}},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_fields_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TABLE_NAME = 2

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TABLE_NAME => {:type => ::Thrift::Types::STRING, :name => 'table_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_fields_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => FieldSchema}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => UnknownTableException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => UnknownDBException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_schema_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TABLE_NAME = 2

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TABLE_NAME => {:type => ::Thrift::Types::STRING, :name => 'table_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_schema_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => FieldSchema}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => UnknownTableException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => UnknownDBException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Create_table_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    TBL = 1

    FIELDS = {
      TBL => {:type => ::Thrift::Types::STRUCT, :name => 'tbl', :class => Table}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Create_table_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O2 = 2
    O3 = 3
    O4 = 4

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => AlreadyExistsException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => InvalidObjectException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException},
      O4 => {:type => ::Thrift::Types::STRUCT, :name => 'o4', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_table_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DBNAME = 1
    NAME = 2
    DELETEDATA = 3

    FIELDS = {
      DBNAME => {:type => ::Thrift::Types::STRING, :name => 'dbname'},
      NAME => {:type => ::Thrift::Types::STRING, :name => 'name'},
      DELETEDATA => {:type => ::Thrift::Types::BOOL, :name => 'deleteData'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_table_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O3 = 2

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_tables_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    PATTERN = 2

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      PATTERN => {:type => ::Thrift::Types::STRING, :name => 'pattern'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_tables_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_all_tables_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_all_tables_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_table_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DBNAME = 1
    TBL_NAME = 2

    FIELDS = {
      DBNAME => {:type => ::Thrift::Types::STRING, :name => 'dbname'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_table_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Table},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_table_objects_by_name_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DBNAME = 1
    TBL_NAMES = 2

    FIELDS = {
      DBNAME => {:type => ::Thrift::Types::STRING, :name => 'dbname'},
      TBL_NAMES => {:type => ::Thrift::Types::LIST, :name => 'tbl_names', :element => {:type => ::Thrift::Types::STRING}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_table_objects_by_name_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => Table}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => InvalidOperationException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => UnknownDBException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_table_names_by_filter_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DBNAME = 1
    FILTER = 2
    MAX_TABLES = 3

    FIELDS = {
      DBNAME => {:type => ::Thrift::Types::STRING, :name => 'dbname'},
      FILTER => {:type => ::Thrift::Types::STRING, :name => 'filter'},
      MAX_TABLES => {:type => ::Thrift::Types::I16, :name => 'max_tables', :default => -1}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_table_names_by_filter_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => InvalidOperationException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => UnknownDBException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Alter_table_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DBNAME = 1
    TBL_NAME = 2
    NEW_TBL = 3

    FIELDS = {
      DBNAME => {:type => ::Thrift::Types::STRING, :name => 'dbname'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      NEW_TBL => {:type => ::Thrift::Types::STRUCT, :name => 'new_tbl', :class => Table}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Alter_table_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O2 = 2

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => InvalidOperationException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Add_partition_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    NEW_PART = 1

    FIELDS = {
      NEW_PART => {:type => ::Thrift::Types::STRUCT, :name => 'new_part', :class => Partition}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Add_partition_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Partition},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => InvalidObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => AlreadyExistsException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Add_partitions_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    NEW_PARTS = 1

    FIELDS = {
      NEW_PARTS => {:type => ::Thrift::Types::LIST, :name => 'new_parts', :element => {:type => ::Thrift::Types::STRUCT, :class => Partition}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Add_partitions_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::I32, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => InvalidObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => AlreadyExistsException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Append_partition_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::LIST, :name => 'part_vals', :element => {:type => ::Thrift::Types::STRING}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Append_partition_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Partition},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => InvalidObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => AlreadyExistsException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Append_partition_by_name_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_NAME = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_NAME => {:type => ::Thrift::Types::STRING, :name => 'part_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Append_partition_by_name_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Partition},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => InvalidObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => AlreadyExistsException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_partition_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3
    DELETEDATA = 4

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::LIST, :name => 'part_vals', :element => {:type => ::Thrift::Types::STRING}},
      DELETEDATA => {:type => ::Thrift::Types::BOOL, :name => 'deleteData'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_partition_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_partition_by_name_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_NAME = 3
    DELETEDATA = 4

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_NAME => {:type => ::Thrift::Types::STRING, :name => 'part_name'},
      DELETEDATA => {:type => ::Thrift::Types::BOOL, :name => 'deleteData'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_partition_by_name_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::LIST, :name => 'part_vals', :element => {:type => ::Thrift::Types::STRING}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Partition},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_with_auth_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3
    USER_NAME = 4
    GROUP_NAMES = 5

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::LIST, :name => 'part_vals', :element => {:type => ::Thrift::Types::STRING}},
      USER_NAME => {:type => ::Thrift::Types::STRING, :name => 'user_name'},
      GROUP_NAMES => {:type => ::Thrift::Types::LIST, :name => 'group_names', :element => {:type => ::Thrift::Types::STRING}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_with_auth_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Partition},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_by_name_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_NAME = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_NAME => {:type => ::Thrift::Types::STRING, :name => 'part_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_by_name_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Partition},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    MAX_PARTS = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      MAX_PARTS => {:type => ::Thrift::Types::I16, :name => 'max_parts', :default => -1}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => Partition}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_with_auth_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    MAX_PARTS = 3
    USER_NAME = 4
    GROUP_NAMES = 5

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      MAX_PARTS => {:type => ::Thrift::Types::I16, :name => 'max_parts', :default => -1},
      USER_NAME => {:type => ::Thrift::Types::STRING, :name => 'user_name'},
      GROUP_NAMES => {:type => ::Thrift::Types::LIST, :name => 'group_names', :element => {:type => ::Thrift::Types::STRING}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_with_auth_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => Partition}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_names_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    MAX_PARTS = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      MAX_PARTS => {:type => ::Thrift::Types::I16, :name => 'max_parts', :default => -1}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_names_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O2 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_ps_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3
    MAX_PARTS = 4

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::LIST, :name => 'part_vals', :element => {:type => ::Thrift::Types::STRING}},
      MAX_PARTS => {:type => ::Thrift::Types::I16, :name => 'max_parts', :default => -1}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_ps_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => Partition}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_ps_with_auth_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3
    MAX_PARTS = 4
    USER_NAME = 5
    GROUP_NAMES = 6

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::LIST, :name => 'part_vals', :element => {:type => ::Thrift::Types::STRING}},
      MAX_PARTS => {:type => ::Thrift::Types::I16, :name => 'max_parts', :default => -1},
      USER_NAME => {:type => ::Thrift::Types::STRING, :name => 'user_name'},
      GROUP_NAMES => {:type => ::Thrift::Types::LIST, :name => 'group_names', :element => {:type => ::Thrift::Types::STRING}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_ps_with_auth_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => Partition}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_names_ps_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3
    MAX_PARTS = 4

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::LIST, :name => 'part_vals', :element => {:type => ::Thrift::Types::STRING}},
      MAX_PARTS => {:type => ::Thrift::Types::I16, :name => 'max_parts', :default => -1}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partition_names_ps_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_by_filter_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    FILTER = 3
    MAX_PARTS = 4

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      FILTER => {:type => ::Thrift::Types::STRING, :name => 'filter'},
      MAX_PARTS => {:type => ::Thrift::Types::I16, :name => 'max_parts', :default => -1}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_by_filter_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => Partition}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_by_names_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    NAMES = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      NAMES => {:type => ::Thrift::Types::LIST, :name => 'names', :element => {:type => ::Thrift::Types::STRING}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_partitions_by_names_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => Partition}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Alter_partition_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    NEW_PART = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      NEW_PART => {:type => ::Thrift::Types::STRUCT, :name => 'new_part', :class => Partition}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Alter_partition_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O2 = 2

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => InvalidOperationException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Rename_partition_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3
    NEW_PART = 4

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::LIST, :name => 'part_vals', :element => {:type => ::Thrift::Types::STRING}},
      NEW_PART => {:type => ::Thrift::Types::STRUCT, :name => 'new_part', :class => Partition}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Rename_partition_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O2 = 2

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => InvalidOperationException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_config_value_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    NAME = 1
    DEFAULTVALUE = 2

    FIELDS = {
      NAME => {:type => ::Thrift::Types::STRING, :name => 'name'},
      DEFAULTVALUE => {:type => ::Thrift::Types::STRING, :name => 'defaultValue'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_config_value_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => ConfigValSecurityException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Partition_name_to_vals_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    PART_NAME = 1

    FIELDS = {
      PART_NAME => {:type => ::Thrift::Types::STRING, :name => 'part_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Partition_name_to_vals_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Partition_name_to_spec_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    PART_NAME = 1

    FIELDS = {
      PART_NAME => {:type => ::Thrift::Types::STRING, :name => 'part_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Partition_name_to_spec_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::MAP, :name => 'success', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class MarkPartitionForEvent_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3
    EVENTTYPE = 4

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::MAP, :name => 'part_vals', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::STRING}},
      EVENTTYPE => {:type => ::Thrift::Types::I32, :name => 'eventType', :enum_class => PartitionEventType}
    }

    def struct_fields; FIELDS; end

    def validate
      unless @eventType.nil? || PartitionEventType::VALID_VALUES.include?(@eventType)
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field eventType!')
      end
    end

    ::Thrift::Struct.generate_accessors self
  end

  class MarkPartitionForEvent_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O2 = 2
    O3 = 3
    O4 = 4
    O5 = 5
    O6 = 6

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => UnknownDBException},
      O4 => {:type => ::Thrift::Types::STRUCT, :name => 'o4', :class => UnknownTableException},
      O5 => {:type => ::Thrift::Types::STRUCT, :name => 'o5', :class => UnknownPartitionException},
      O6 => {:type => ::Thrift::Types::STRUCT, :name => 'o6', :class => InvalidPartitionException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class IsPartitionMarkedForEvent_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    PART_VALS = 3
    EVENTTYPE = 4

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      PART_VALS => {:type => ::Thrift::Types::MAP, :name => 'part_vals', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::STRING}},
      EVENTTYPE => {:type => ::Thrift::Types::I32, :name => 'eventType', :enum_class => PartitionEventType}
    }

    def struct_fields; FIELDS; end

    def validate
      unless @eventType.nil? || PartitionEventType::VALID_VALUES.include?(@eventType)
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field eventType!')
      end
    end

    ::Thrift::Struct.generate_accessors self
  end

  class IsPartitionMarkedForEvent_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3
    O4 = 4
    O5 = 5
    O6 = 6

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => UnknownDBException},
      O4 => {:type => ::Thrift::Types::STRUCT, :name => 'o4', :class => UnknownTableException},
      O5 => {:type => ::Thrift::Types::STRUCT, :name => 'o5', :class => UnknownPartitionException},
      O6 => {:type => ::Thrift::Types::STRUCT, :name => 'o6', :class => InvalidPartitionException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Add_index_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    NEW_INDEX = 1
    INDEX_TABLE = 2

    FIELDS = {
      NEW_INDEX => {:type => ::Thrift::Types::STRUCT, :name => 'new_index', :class => Index},
      INDEX_TABLE => {:type => ::Thrift::Types::STRUCT, :name => 'index_table', :class => Table}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Add_index_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2
    O3 = 3

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Index},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => InvalidObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => AlreadyExistsException},
      O3 => {:type => ::Thrift::Types::STRUCT, :name => 'o3', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Alter_index_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DBNAME = 1
    BASE_TBL_NAME = 2
    IDX_NAME = 3
    NEW_IDX = 4

    FIELDS = {
      DBNAME => {:type => ::Thrift::Types::STRING, :name => 'dbname'},
      BASE_TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'base_tbl_name'},
      IDX_NAME => {:type => ::Thrift::Types::STRING, :name => 'idx_name'},
      NEW_IDX => {:type => ::Thrift::Types::STRUCT, :name => 'new_idx', :class => Index}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Alter_index_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1
    O2 = 2

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => InvalidOperationException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_index_by_name_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    INDEX_NAME = 3
    DELETEDATA = 4

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      INDEX_NAME => {:type => ::Thrift::Types::STRING, :name => 'index_name'},
      DELETEDATA => {:type => ::Thrift::Types::BOOL, :name => 'deleteData'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_index_by_name_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_index_by_name_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    INDEX_NAME = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      INDEX_NAME => {:type => ::Thrift::Types::STRING, :name => 'index_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_index_by_name_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => Index},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => NoSuchObjectException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_indexes_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    MAX_INDEXES = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      MAX_INDEXES => {:type => ::Thrift::Types::I16, :name => 'max_indexes', :default => -1}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_indexes_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1
    O2 = 2

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => Index}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => NoSuchObjectException},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_index_names_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    DB_NAME = 1
    TBL_NAME = 2
    MAX_INDEXES = 3

    FIELDS = {
      DB_NAME => {:type => ::Thrift::Types::STRING, :name => 'db_name'},
      TBL_NAME => {:type => ::Thrift::Types::STRING, :name => 'tbl_name'},
      MAX_INDEXES => {:type => ::Thrift::Types::I16, :name => 'max_indexes', :default => -1}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_index_names_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O2 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O2 => {:type => ::Thrift::Types::STRUCT, :name => 'o2', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Create_role_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    ROLE = 1

    FIELDS = {
      ROLE => {:type => ::Thrift::Types::STRUCT, :name => 'role', :class => Role}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Create_role_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_role_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    ROLE_NAME = 1

    FIELDS = {
      ROLE_NAME => {:type => ::Thrift::Types::STRING, :name => 'role_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Drop_role_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_role_names_args
    include ::Thrift::Struct, ::Thrift::Struct_Union

    FIELDS = {

    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_role_names_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Grant_role_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    ROLE_NAME = 1
    PRINCIPAL_NAME = 2
    PRINCIPAL_TYPE = 3
    GRANTOR = 4
    GRANTORTYPE = 5
    GRANT_OPTION = 6

    FIELDS = {
      ROLE_NAME => {:type => ::Thrift::Types::STRING, :name => 'role_name'},
      PRINCIPAL_NAME => {:type => ::Thrift::Types::STRING, :name => 'principal_name'},
      PRINCIPAL_TYPE => {:type => ::Thrift::Types::I32, :name => 'principal_type', :enum_class => PrincipalType},
      GRANTOR => {:type => ::Thrift::Types::STRING, :name => 'grantor'},
      GRANTORTYPE => {:type => ::Thrift::Types::I32, :name => 'grantorType', :enum_class => PrincipalType},
      GRANT_OPTION => {:type => ::Thrift::Types::BOOL, :name => 'grant_option'}
    }

    def struct_fields; FIELDS; end

    def validate
      unless @principal_type.nil? || PrincipalType::VALID_VALUES.include?(@principal_type)
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field principal_type!')
      end
      unless @grantorType.nil? || PrincipalType::VALID_VALUES.include?(@grantorType)
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field grantorType!')
      end
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Grant_role_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Revoke_role_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    ROLE_NAME = 1
    PRINCIPAL_NAME = 2
    PRINCIPAL_TYPE = 3

    FIELDS = {
      ROLE_NAME => {:type => ::Thrift::Types::STRING, :name => 'role_name'},
      PRINCIPAL_NAME => {:type => ::Thrift::Types::STRING, :name => 'principal_name'},
      PRINCIPAL_TYPE => {:type => ::Thrift::Types::I32, :name => 'principal_type', :enum_class => PrincipalType}
    }

    def struct_fields; FIELDS; end

    def validate
      unless @principal_type.nil? || PrincipalType::VALID_VALUES.include?(@principal_type)
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field principal_type!')
      end
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Revoke_role_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class List_roles_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    PRINCIPAL_NAME = 1
    PRINCIPAL_TYPE = 2

    FIELDS = {
      PRINCIPAL_NAME => {:type => ::Thrift::Types::STRING, :name => 'principal_name'},
      PRINCIPAL_TYPE => {:type => ::Thrift::Types::I32, :name => 'principal_type', :enum_class => PrincipalType}
    }

    def struct_fields; FIELDS; end

    def validate
      unless @principal_type.nil? || PrincipalType::VALID_VALUES.include?(@principal_type)
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field principal_type!')
      end
    end

    ::Thrift::Struct.generate_accessors self
  end

  class List_roles_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => Role}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_privilege_set_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    HIVEOBJECT = 1
    USER_NAME = 2
    GROUP_NAMES = 3

    FIELDS = {
      HIVEOBJECT => {:type => ::Thrift::Types::STRUCT, :name => 'hiveObject', :class => HiveObjectRef},
      USER_NAME => {:type => ::Thrift::Types::STRING, :name => 'user_name'},
      GROUP_NAMES => {:type => ::Thrift::Types::LIST, :name => 'group_names', :element => {:type => ::Thrift::Types::STRING}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_privilege_set_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => PrincipalPrivilegeSet},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class List_privileges_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    PRINCIPAL_NAME = 1
    PRINCIPAL_TYPE = 2
    HIVEOBJECT = 3

    FIELDS = {
      PRINCIPAL_NAME => {:type => ::Thrift::Types::STRING, :name => 'principal_name'},
      PRINCIPAL_TYPE => {:type => ::Thrift::Types::I32, :name => 'principal_type', :enum_class => PrincipalType},
      HIVEOBJECT => {:type => ::Thrift::Types::STRUCT, :name => 'hiveObject', :class => HiveObjectRef}
    }

    def struct_fields; FIELDS; end

    def validate
      unless @principal_type.nil? || PrincipalType::VALID_VALUES.include?(@principal_type)
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field principal_type!')
      end
    end

    ::Thrift::Struct.generate_accessors self
  end

  class List_privileges_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => HiveObjectPrivilege}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Grant_privileges_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    PRIVILEGES = 1

    FIELDS = {
      PRIVILEGES => {:type => ::Thrift::Types::STRUCT, :name => 'privileges', :class => PrivilegeBag}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Grant_privileges_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Revoke_privileges_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    PRIVILEGES = 1

    FIELDS = {
      PRIVILEGES => {:type => ::Thrift::Types::STRUCT, :name => 'privileges', :class => PrivilegeBag}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Revoke_privileges_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::BOOL, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Set_ugi_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    USER_NAME = 1
    GROUP_NAMES = 2

    FIELDS = {
      USER_NAME => {:type => ::Thrift::Types::STRING, :name => 'user_name'},
      GROUP_NAMES => {:type => ::Thrift::Types::LIST, :name => 'group_names', :element => {:type => ::Thrift::Types::STRING}}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Set_ugi_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_delegation_token_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    TOKEN_OWNER = 1
    RENEWER_KERBEROS_PRINCIPAL_NAME = 2

    FIELDS = {
      TOKEN_OWNER => {:type => ::Thrift::Types::STRING, :name => 'token_owner'},
      RENEWER_KERBEROS_PRINCIPAL_NAME => {:type => ::Thrift::Types::STRING, :name => 'renewer_kerberos_principal_name'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Get_delegation_token_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Renew_delegation_token_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    TOKEN_STR_FORM = 1

    FIELDS = {
      TOKEN_STR_FORM => {:type => ::Thrift::Types::STRING, :name => 'token_str_form'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Renew_delegation_token_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    SUCCESS = 0
    O1 = 1

    FIELDS = {
      SUCCESS => {:type => ::Thrift::Types::I64, :name => 'success'},
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Cancel_delegation_token_args
    include ::Thrift::Struct, ::Thrift::Struct_Union
    TOKEN_STR_FORM = 1

    FIELDS = {
      TOKEN_STR_FORM => {:type => ::Thrift::Types::STRING, :name => 'token_str_form'}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

  class Cancel_delegation_token_result
    include ::Thrift::Struct, ::Thrift::Struct_Union
    O1 = 1

    FIELDS = {
      O1 => {:type => ::Thrift::Types::STRUCT, :name => 'o1', :class => MetaException}
    }

    def struct_fields; FIELDS; end

    def validate
    end

    ::Thrift::Struct.generate_accessors self
  end

end

