/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ImmutableMultisetTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAsList() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testAsList();
}

public void testBuilderAdd() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderAdd();
}

public void testBuilderAddAll() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderAddAll();
}

public void testBuilderAddAllHandlesNullsCorrectly() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderAddAllHandlesNullsCorrectly();
}

public void testBuilderAddAllIterator() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderAddAllIterator();
}

public void testBuilderAddAllMultiset() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderAddAllMultiset();
}

public void testBuilderAddCopies() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderAddCopies();
}

public void testBuilderAddCopiesHandlesNullsCorrectly() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderAddCopiesHandlesNullsCorrectly();
}

public void testBuilderAddCopiesIllegal() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderAddCopiesIllegal();
}

public void testBuilderAddHandlesNullsCorrectly() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderAddHandlesNullsCorrectly();
}

public void testBuilderSetCount() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderSetCount();
}

public void testBuilderSetCountHandlesNullsCorrectly() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderSetCountHandlesNullsCorrectly();
}

public void testBuilderSetCountIllegal() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testBuilderSetCountIllegal();
}

public void testCopyOf_collectionContainingNull() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_collectionContainingNull();
}

public void testCopyOf_collection_empty() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_collection_empty();
}

public void testCopyOf_collection_general() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_collection_general();
}

public void testCopyOf_collection_oneElement() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_collection_oneElement();
}

public void testCopyOf_iteratorContainingNull() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_iteratorContainingNull();
}

public void testCopyOf_iterator_empty() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_iterator_empty();
}

public void testCopyOf_iterator_general() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_iterator_general();
}

public void testCopyOf_iterator_oneElement() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_iterator_oneElement();
}

public void testCopyOf_multisetContainingNull() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_multisetContainingNull();
}

public void testCopyOf_multiset_empty() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_multiset_empty();
}

public void testCopyOf_multiset_general() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_multiset_general();
}

public void testCopyOf_multiset_oneElement() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_multiset_oneElement();
}

public void testCopyOf_plainIterable() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_plainIterable();
}

public void testCopyOf_shortcut_empty() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_shortcut_empty();
}

public void testCopyOf_shortcut_immutableMultiset() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_shortcut_immutableMultiset();
}

public void testCopyOf_shortcut_singleton() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCopyOf_shortcut_singleton();
}

public void testCreation_arrayContainingOnlyNull() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_arrayContainingOnlyNull();
}

public void testCreation_arrayOfArray() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_arrayOfArray();
}

public void testCreation_arrayOfOneElement() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_arrayOfOneElement();
}

public void testCreation_emptyArray() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_emptyArray();
}

public void testCreation_fiveElements() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_fiveElements();
}

public void testCreation_fourElements() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_fourElements();
}

public void testCreation_noArgs() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_noArgs();
}

public void testCreation_oneElement() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_oneElement();
}

public void testCreation_sevenElements() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_sevenElements();
}

public void testCreation_sixElements() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_sixElements();
}

public void testCreation_threeElements() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_threeElements();
}

public void testCreation_twoElements() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testCreation_twoElements();
}

public void testEquals() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testEquals();
}

public void testEquals_immutableMultiset() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testEquals_immutableMultiset();
}

public void testIterationOrder() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testIterationOrder();
}

public void testIterationOrderThroughBuilderRemovals() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testIterationOrderThroughBuilderRemovals();
}

public void testMultisetWrites() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testMultisetWrites();
}

public void testToImmutableMultiset() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testToImmutableMultiset();
}

public void testToImmutableMultisetCountFunction() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testToImmutableMultisetCountFunction();
}

public void testToImmutableMultiset_duplicates() throws Exception {
  com.google.common.collect.ImmutableMultisetTest testCase = new com.google.common.collect.ImmutableMultisetTest();
  testCase.testToImmutableMultiset_duplicates();
}
}
