/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ImmutableMapTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAsMultimap() throws Exception {
  com.google.common.collect.ImmutableMapTest testCase = new com.google.common.collect.ImmutableMapTest();
  testCase.testAsMultimap();
}

public void testAsMultimapCaches() throws Exception {
  com.google.common.collect.ImmutableMapTest testCase = new com.google.common.collect.ImmutableMapTest();
  testCase.testAsMultimapCaches();
}

public void testAsMultimapWhenEmpty() throws Exception {
  com.google.common.collect.ImmutableMapTest testCase = new com.google.common.collect.ImmutableMapTest();
  testCase.testAsMultimapWhenEmpty();
}

public void testCopyOfEnumMap() throws Exception {
  com.google.common.collect.ImmutableMapTest testCase = new com.google.common.collect.ImmutableMapTest();
  testCase.testCopyOfEnumMap();
}

public void testEquals() throws Exception {
  com.google.common.collect.ImmutableMapTest testCase = new com.google.common.collect.ImmutableMapTest();
  testCase.testEquals();
}

public void testMutableValues() throws Exception {
  com.google.common.collect.ImmutableMapTest testCase = new com.google.common.collect.ImmutableMapTest();
  testCase.testMutableValues();
}

public void testNullGet() throws Exception {
  com.google.common.collect.ImmutableMapTest testCase = new com.google.common.collect.ImmutableMapTest();
  testCase.testNullGet();
}

public void testBuilder__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilder();
}

public void testBuilderPutAll__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderPutAll();
}

public void testBuilderPutAllWithEmptyMap__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderPutAllWithEmptyMap();
}

public void testBuilderPutImmutableEntryWithNullKeyFailsAtomically__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderPutImmutableEntryWithNullKeyFailsAtomically();
}

public void testBuilderPutMutableEntryWithNullKeyFailsAtomically__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderPutMutableEntryWithNullKeyFailsAtomically();
}

public void testBuilderPutNullKey__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderPutNullKey();
}

public void testBuilderPutNullKeyFailsAtomically__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderPutNullKeyFailsAtomically();
}

public void testBuilderPutNullKeyViaPutAll__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderPutNullKeyViaPutAll();
}

public void testBuilderPutNullValue__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderPutNullValue();
}

public void testBuilderPutNullValueViaPutAll__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderPutNullValueViaPutAll();
}

public void testBuilderReuse__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilderReuse();
}

public void testBuilder_orderEntriesByValue__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilder_orderEntriesByValue();
}

public void testBuilder_orderEntriesByValueAfterExactSizeBuild__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilder_orderEntriesByValueAfterExactSizeBuild();
}

public void testBuilder_orderEntriesByValue_usedTwiceFails__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilder_orderEntriesByValue_usedTwiceFails();
}

public void testBuilder_withImmutableEntry__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilder_withImmutableEntry();
}

public void testBuilder_withImmutableEntryAndNullContents__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilder_withImmutableEntryAndNullContents();
}

public void testBuilder_withMutableEntry__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testBuilder_withMutableEntry();
}

public void testCopyOf__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testCopyOf();
}

public void testCopyOfEmptyMap__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testCopyOfEmptyMap();
}

public void testCopyOfSingletonMap__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testCopyOfSingletonMap();
}

public void testEmptyBuilder__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testEmptyBuilder();
}

public void testOf__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testOf();
}

public void testOfNullKey__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testOfNullKey();
}

public void testOfNullValue__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testOfNullValue();
}

public void testOfWithDuplicateKey__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testOfWithDuplicateKey();
}

public void testPuttingTheSameKeyTwiceThrowsOnBuild__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testPuttingTheSameKeyTwiceThrowsOnBuild();
}

public void testSingletonBuilder__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testSingletonBuilder();
}

public void testToImmutableMap__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testToImmutableMap();
}

public void testToImmutableMapMerging__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testToImmutableMapMerging();
}

public void testToImmutableMap_exceptionOnDuplicateKey__CreationTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.CreationTests testCase = new com.google.common.collect.ImmutableMapTest.CreationTests();
  testCase.testToImmutableMap_exceptionOnDuplicateKey();
}

public void testClear__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testClear();
}

public void testContainsKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testContainsKey();
}

public void testContainsValue__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testContainsValue();
}

public void testEntrySet__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testEqualsForSmallerMap();
}

public void testGet__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testGet();
}

public void testGetForEmptyMap__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testGetForEmptyMap();
}

public void testGetNull__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testGetNull();
}

public void testHashCode__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testKeySetClear();
}

public void testKeySetRemove__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testPutExistingKey();
}

public void testPutNewKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testPutNewKey();
}

public void testPutNullKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testPutNullKey();
}

public void testPutNullValue__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testRemove();
}

public void testRemoveMissingKey__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testRemoveMissingKey();
}

public void testSize__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testSize();
}

public void testValues__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testValues();
}

public void testValuesClear__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__MapTestsWithBadHashes() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes testCase = new com.google.common.collect.ImmutableMapTest.MapTestsWithBadHashes();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testClear();
}

public void testContainsKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testGetNull();
}

public void testHashCode__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testSize();
}

public void testValues__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testValues();
}

public void testValuesClear__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableMapTest.SingletonMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testClear();
}

public void testContainsKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testContainsKey();
}

public void testContainsValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testContainsValue();
}

public void testEntrySet__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testGetNull();
}

public void testHashCode__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testSize();
}

public void testValues__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testValues();
}

public void testValuesClear__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableMapTest.MapTests testCase = new com.google.common.collect.ImmutableMapTest.MapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}
}
