/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.base;
public class PreconditionsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.base.testModule";
}
public void testCheckArgument_complexMessage_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_complexMessage_failure();
}

public void testCheckArgument_complexMessage_success() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_complexMessage_success();
}

public void testCheckArgument_notEnoughArgs_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_notEnoughArgs_failure();
}

public void testCheckArgument_nullArgs_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_nullArgs_failure();
}

public void testCheckArgument_nullMessageWithArgs_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_nullMessageWithArgs_failure();
}

public void testCheckArgument_nullMessage_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_nullMessage_failure();
}

public void testCheckArgument_simpleMessage_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_simpleMessage_failure();
}

public void testCheckArgument_simpleMessage_success() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_simpleMessage_success();
}

public void testCheckArgument_simple_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_simple_failure();
}

public void testCheckArgument_simple_success() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_simple_success();
}

public void testCheckArgument_singleNullArg_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_singleNullArg_failure();
}

public void testCheckArgument_singleNullArray_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_singleNullArray_failure();
}

public void testCheckArgument_tooManyArgs_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckArgument_tooManyArgs_failure();
}

public void testCheckElementIndex_badSize() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckElementIndex_badSize();
}

public void testCheckElementIndex_negative() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckElementIndex_negative();
}

public void testCheckElementIndex_ok() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckElementIndex_ok();
}

public void testCheckElementIndex_tooHigh() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckElementIndex_tooHigh();
}

public void testCheckElementIndex_withDesc_negative() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckElementIndex_withDesc_negative();
}

public void testCheckElementIndex_withDesc_tooHigh() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckElementIndex_withDesc_tooHigh();
}

public void testCheckNotNull_complexMessage_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckNotNull_complexMessage_failure();
}

public void testCheckNotNull_complexMessage_success() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckNotNull_complexMessage_success();
}

public void testCheckNotNull_simpleMessage_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckNotNull_simpleMessage_failure();
}

public void testCheckNotNull_simpleMessage_success() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckNotNull_simpleMessage_success();
}

public void testCheckNotNull_simple_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckNotNull_simple_failure();
}

public void testCheckNotNull_simple_success() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckNotNull_simple_success();
}

public void testCheckPositionIndex_badSize() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndex_badSize();
}

public void testCheckPositionIndex_negative() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndex_negative();
}

public void testCheckPositionIndex_ok() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndex_ok();
}

public void testCheckPositionIndex_startNegative() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndex_startNegative();
}

public void testCheckPositionIndex_tooHigh() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndex_tooHigh();
}

public void testCheckPositionIndex_withDesc_negative() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndex_withDesc_negative();
}

public void testCheckPositionIndex_withDesc_tooHigh() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndex_withDesc_tooHigh();
}

public void testCheckPositionIndexes_badSize() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndexes_badSize();
}

public void testCheckPositionIndexes_endTooHigh() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndexes_endTooHigh();
}

public void testCheckPositionIndexes_ok() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndexes_ok();
}

public void testCheckPositionIndexes_reversed() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckPositionIndexes_reversed();
}

public void testCheckState_complexMessage_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckState_complexMessage_failure();
}

public void testCheckState_complexMessage_success() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckState_complexMessage_success();
}

public void testCheckState_nullMessage_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckState_nullMessage_failure();
}

public void testCheckState_simpleMessage_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckState_simpleMessage_failure();
}

public void testCheckState_simpleMessage_success() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckState_simpleMessage_success();
}

public void testCheckState_simple_failure() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckState_simple_failure();
}

public void testCheckState_simple_success() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testCheckState_simple_success();
}

public void testFormat() throws Exception {
  com.google.common.base.PreconditionsTest testCase = new com.google.common.base.PreconditionsTest();
  testCase.testFormat();
}
}
