Follow the news and releases on our [twitter](https://twitter.com/golangci) and our [blog](https://medium.com/golangci).
There is the most valuable changes log:

## December 2020

1. new linters:
   * `forbidigo`: https://github.com/ashanbrown/forbidigo
   * `makezero`: https://github.com/ashanbrown/makezero
   * `thelper`: https://github.com/kulti/thelper
2. update linters:
   * `go-header` from v0.3.1 to v0.4.2
   * `go-mnd` from v2.0.0 to v2.2.0
   * `godot` from v1.3.0 to v1.3.2
   * `gci` from v0.2.4 to v0.2.7
   * `gomodguard` from v1.1.0 to v1.2.0
   * `go-errorlint` from v0.0.0-20201006195004-351e25ade6e3 to v0.0.0-20201127212506-19bd8db6546f
   * `gofumpt` from v0.0.0-20200802201014-ab5a8192947d to v0.0.0-20201129102820-5c11c50e9475
   * `nolintlint` fix comment analysis. (#1571)
3. result/processors: treat all non-Go source as special autogenerated files
4. throw an error on panic. (#1540)
5. resolve custom linters' path relative to config file directory (#1572)
6. treat all non-Go source as special autogenerated files
7. documentation:
   * add settings examples for `gocritic` (#1562)
   * removing reference to no-longer-existing linter-in-the-cloud (#1553)
8. others:
   * bump `gopkg.in/yaml.v2` from 2.3.0 to 2.4.0 (#1528)
   * bump `gatsby-remark-responsive-iframe` in /docs (#1533)
   * bump `gatsby-remark-images` from 3.3.29 to 3.6.0 in /docs (#1531)
   * bump `ini` from 1.3.5 to 1.3.8 in /tools (#1560)
   * bump `react-headroom` from 3.0.0 to 3.0.1 in /docs (#1532)
   * bump `react-live` from 2.2.2 to 2.2.3 in /docs (#1534)

### November 2020

1. new linters:
   * `paralleltest`: https://github.com/kunwardeep/paralleltest
2. update linters:
   * `godot` from v0.4.9 to v1.3.0
   * `exportloopref` from v0.1.7 to v0.1.8
   * `gosec` from 2.4.0 to 2.5.0
   * `goconst` using upstream https://github.com/jgautheron/goconst
3. `DefaultExcludePatterns` should only be used for specified linter (#1494)
4. unknown linter breaks //nolint (#1497)
5. report all unknown linters at once (#1477)
6. CI:
   * fix Docker tag for Alpine build
7. documentation:
   * missing sort-results in the docs (#1514)
   * add description of Homebrew's official formula (#1421)
8. others:
   * bump `golang.org/x/text` to v0.3.4 (#1293)
   * bump `github.com/fatih/color` to from 1.9.0 to 1.10.0 (#1485)
   * bump `lodash` from 4.17.15 to 4.17.19 in /.github/peril (#1252)
   * bump `polished` from 3.6.6 to 4.0.3 in /docs (#1482)
   * bump `gatsby-alias-imports` from 1.0.4 to 1.0.6 in /docs (#1479)
   * bump `puppeteer` from 5.3.1 to 5.4.1 in /docs (#1480)
   * bump `gatsby-remark-embedder` from 3.0.0 to 4.0.0 in /docs (#1478)

### October 2020

1. new linters:
   * `exhaustivestruct`: https://github.com/mbilski/exhaustivestruct
   * `go-errorlint`: https://github.com/polyfloyd/go-errorlint
   * `tparallel`: https://github.com/moricho/tparallel
   * `wrapcheck`: https://github.com/tomarrell/wrapcheck
2. update linters:
   * `honnef.co/go/tools` from 2020.1.5 to 2020.1.6
   * `exhaustivestruct` from v1.0.1 to v1.1.0
   * `exhaustive` to v0.1.0
   * `gochecknoglobals`: use https://github.com/leighmcculloch/gochecknoglobals
3. add support for powershell completion (#1408)
4. add `.golangci.yaml` to list of configuration files searched on startup (#1364)
5. support for only specifying default severity (#1396)
6. documentation:
   * mention macports installation procedure on macOS (#1352)
   * sort linters (#1451)
7. CI:
   * add codeQL scanning (#1405)
   * fix version details in Docker image (#1471)
   * releasing docker image for arm64 (#1383)
   * change interval for npm to monthly (#1424)
8. others:
   * use tag version for cobra (#1458)
   * bump `nancy` to 1.0.1 (#1410)
   * bump `gatsby-plugin-catch-links` in /docs (#1415)
   * bump `gatsby-plugin-mdx` from 1.2.40 to 1.2.43 in /docs (#1419)
   * bump `gatsby-plugin-sharp` from 2.6.31 to 2.6.40 in /docs (#1423)
   * bump `gatsby-plugin-sitemap` from 2.4.12 to 2.4.14 in /docs (#1417)
   * bump `github.com/mattn/go-colorable` from 0.1.7 to 0.1.8 (#1413)
   * bump `github.com/sirupsen/logrus` from 1.6.0 to 1.7.0 (#1412)
   * bump `github.com/sourcegraph/go-diff` from 0.6.0 to 0.6.1 (#1414)
   * bump `golangci/golangci-lint-action` from v2 to v2.3.0  (#1447) (#1469)
   * bump `puppeteer` from 3.3.0 to 5.3.1 in /docs (#1418)

### September 2020

1. update linters:
   * `godot` from 0.4.8 to 0.4.9
   * `exhaustive` from v0.0.0-20200708172631-8866003e3856 to v0.0.0-20200811152831-6cf413ae40e0
   * `gofumpt` from v0.0.0-20200709182408-4fd085cb6d5f to v0.0.0-20200802201014-ab5a8192947d
2. add support for fish completion (#1201)
3. documentation:
   * fix typo in performance docs (#1350)
4. CI:
   * prevent macos to be marked as passing upon failure (#1381)
   * check only for go.mod file (#1397)
   * check if go.mod and go.sum are up to dated (#1377)
   * trigger Netlify (#1358)
5. others:
   * bump `github.com/sourcegraph/go-diff` from 0.5.3 to 0.6.0 (#1353)
   * bump `github.com/valyala/quicktemplate` from 1.6.2 to 1.6.3 (#1385)
   * ignore known dependency failure in nancy (#1378)
   * bump `@mdx-js/mdx` from 1.6.16 to 1.6.18 in /docs (#1401)
   * bump `gatsby` from 2.24.52 to 2.24.65 in /docs (#1400)
   * bump `gatsby-plugin-canonical-urls` in /docs (#1390)
   * bump `gatsby-plugin-google-analytics` in /docs (#1388)
   * bump `gatsby-plugin-manifest` from 2.4.23 to 2.4.27 in /docs (#1355)
   * bump `gatsby-plugin-mdx` from 1.2.35 to 1.2.40 in /docs (#1386)
   * bump `gatsby-plugin-offline` from 3.2.23 to 3.2.27 in /docs (#1368)
   * bump `gatsby-plugin-sharp` from 2.6.25 to 2.6.31 in /docs (#1354)
   * bump `gatsby-plugin-sitemap` from 2.4.11 to 2.4.12 in /docs (#1344)
   * bump `gatsby-remark-autolink-headers` in /docs (#1387)
   * bump `gatsby-remark-images` from 3.3.25 to 3.3.28 in /docs (#1345)
   * bump `gatsby-remark-images` from 3.3.28 to 3.3.29 in /docs (#1365)
   * bump `gatsby-remark-mermaid` from 2.0.0 to 2.1.0 in /docs (#1369)
   * bump `gatsby-source-filesystem` in /docs (#1366)
   * bump `gatsby-source-filesystem` in /docs (#1389)
   * bump `gatsby-transformer-sharp` in /docs (#1402)
   * bump `gatsby-transformer-yaml` from 2.4.10 to 2.4.11 in /docs (#1367)
   * bump `node-fetch` in /.github/contributors (#1363)
   * bump `polished` from 3.6.5 to 3.6.6 in /docs (#1347)
   
### August 2020

1. new `nlreturn` linter: https://github.com/ssgreg/nlreturn
2. new `gci` linter: https://github.com/daixiang0/gci
3. support `latest` version of golangci-lint in golangci-lint-action
4. update `gosec` linter from 2.3.0 to 2.4.0
5. update `godot` linter from 0.4.2 to 0.4.8
6. update `go-critic` from 0.5.0 to 0.5.2 (#1307)
7. update `nlreturn` from 2.0.1 to 2.0.2 (#1287), 2.0.2 to 2.1.0 (#1327)
8. update `gci` to v0.2.1 (#1292), to v0.2.2 (#1305), to v0.2.4 (#1337),
9. update `funlen` from 0.0.2 to 0.0.3 (#1341)
10. upgrade to golang 1.15 for smaller binary (#1303)
11. support short and json formats for version cmd (#1315)
12. add home directory to config file search paths (#1325)
13. allow for serializing multiple golangci-lint invocations (#1302)

### July 2020

1. `gofumpt` linter:
    * update linter
    * add `extra-rules` option
    * support auto-fixing
2. upgrade `exhaustive` linter
3. upgrade `exportloopref` linter
4. improve 'no such linter' error message
5. sorting result.Issues implementation
6. enhancements in CI:
    * Run `nancy` validation for all dependencies
    * Move dependabot config to `.github` folder
7. other
    * bump `lodash` from 4.17.15 to 4.17.19 in /tools
    * bump `golangci/golangci-lint-action` from v1.2.2 to v2
    * bump `github.com/valyala/quicktemplate` from 1.5.0 to 1.5.1


### June 2020

1. Add new linters: `gofumpt`

### May 2020

1. Add new linters: `nolintlint`, `goerr113`
2. Updated linters: `godot`, `staticcheck`
3. Launch a [website](https://golangci-lint.run)

### April 2020

1. Add new linters: `testpackage`, `nestif`, `godot`, `gomodguard`, `asciicheck`
2. Add github actions output format
3. Update linters: `wsl`, `gomodguard`, `gosec`
4. Support `disabled-tags` setting for `gocritic`
5. Mitigate OOM and "failed prerequisites"
6. Self-isolate due to unexpected pandemics
7. Support case-sensitive excludes
8. Allow granular re-enabling excludes by ID, e.g. `EXC0002`

### September 2019

1. Support go1.13
2. Add new linters: `funlen`, `whitespace` (with auto-fix) and `godox`
3. Update linters: `gochecknoglobals`, `scopelint`, `gosec`
4. Provide pre-built binary for ARM and FreeBSD
5. 2. Fix false-positives in `unused`
6. Support `--skip-dirs-use-default`
7. Add support for bash completions

### July 2019

1. Fix parallel writes race condition
2. Update bodyclose with fixed panic

### June 2019

1. Treat Go source files as a plain text by `misspell`: it allows detecting issues in strings, variable names, etc.
2. Implement richer and more stable auto-fix of `misspell` issues.

### May 2019

1. Add [bodyclose](https://github.com/timakin/bodyclose) linter.
2. Support junit-xml output.

### April 2019

1. Update go-critic, new checkers were added: badCall, dupImports, evalOrder, newDeref
2. Fix staticcheck panic on packages that do not compile
3. Make install script work on Windows
4. Fix compatibility with the latest x/tools version and update golang.org/x/tools
5. Correct import path of module sourcegraph/go-diff
6. Fix `max-issues-per-linter` name
7. Fix linting of preprocessed files (e.g. `*.qtpl.go`, goyacc)
8. Enable auto-fixing when running via pre-commit

### March 2019

1. Support the newest `go vet` (with `go/analysis`)
2. Support configuration of `go vet`: e.g. you can set print functions by `linters-settings.govet.settings.printf.funcs`
3. Update megacheck (staticcheck) to 2019.1.1
4. Add [information](https://github.com/golangci/golangci-lint#memory-usage-of-golangci-lint) about controlling space-time trade-off into README
5. Exclude issues by source code line regexp by `issues.exclude-rules[i].source`
6. Build and test on go 1.12
7. Support `--color` option
8. Update x/tools to fix c++ issues
9. Include support for log level
10. Sort linters list in help commands
