package com.github.dreamhead.moco.extractor;

import io.netty.handler.codec.http.FullHttpRequest;
import org.junit.Before;
import org.junit.Test;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class UriRequestExtractorTest {
    private UriRequestExtractor extractor;
    private FullHttpRequest request;

    @Before
    public void setUp() throws Exception {
        extractor = new UriRequestExtractor();
        request = mock(FullHttpRequest.class);
    }

    @Test
    public void should_return_all_uri_while_uri_has_no_parameter() {
        when(request.getUri()).thenReturn("/foo");
        assertThat(extractor.extract(request).get(), is("/foo"));
    }

    @Test
    public void should_return_path_part_while_uri_has_parameters() {
        when(request.getUri()).thenReturn("/foo?param=bar");
        assertThat(extractor.extract(request).get(), is("/foo"));
    }
}
