---
title: "Enums"
isDefaultIndex: false
generated: true
---
<!-- This file was generated from the Vendure source. Do not modify. Instead, re-run the "docs:build" script -->
import MemberInfo from '@site/src/components/MemberInfo';
import GenerationInfo from '@site/src/components/GenerationInfo';
import MemberDescription from '@site/src/components/MemberDescription';



## AdjustmentType

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">AdjustmentType</span> &#123;</div>
<div class="graphql-code-line ">PROMOTION</div>
<div class="graphql-code-line ">DISTRIBUTED_ORDER_PROMOTION</div>
<div class="graphql-code-line ">OTHER</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## AssetType

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">AssetType</span> &#123;</div>
<div class="graphql-code-line ">IMAGE</div>
<div class="graphql-code-line ">VIDEO</div>
<div class="graphql-code-line ">BINARY</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## CurrencyCode

<div class="graphql-code-block">
<div class="graphql-code-line comment">"""</div>
<div class="graphql-code-line comment">ISO 4217 currency code</div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment"></div>
<div class="graphql-code-line comment">"""</div>

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">CurrencyCode</span> &#123;</div>
<div class="graphql-code-line comment">"""United Arab Emirates dirham"""</div>
<div class="graphql-code-line ">AED</div>
<div class="graphql-code-line comment">"""Afghan afghani"""</div>
<div class="graphql-code-line ">AFN</div>
<div class="graphql-code-line comment">"""Albanian lek"""</div>
<div class="graphql-code-line ">ALL</div>
<div class="graphql-code-line comment">"""Armenian dram"""</div>
<div class="graphql-code-line ">AMD</div>
<div class="graphql-code-line comment">"""Netherlands Antillean guilder"""</div>
<div class="graphql-code-line ">ANG</div>
<div class="graphql-code-line comment">"""Angolan kwanza"""</div>
<div class="graphql-code-line ">AOA</div>
<div class="graphql-code-line comment">"""Argentine peso"""</div>
<div class="graphql-code-line ">ARS</div>
<div class="graphql-code-line comment">"""Australian dollar"""</div>
<div class="graphql-code-line ">AUD</div>
<div class="graphql-code-line comment">"""Aruban florin"""</div>
<div class="graphql-code-line ">AWG</div>
<div class="graphql-code-line comment">"""Azerbaijani manat"""</div>
<div class="graphql-code-line ">AZN</div>
<div class="graphql-code-line comment">"""Bosnia and Herzegovina convertible mark"""</div>
<div class="graphql-code-line ">BAM</div>
<div class="graphql-code-line comment">"""Barbados dollar"""</div>
<div class="graphql-code-line ">BBD</div>
<div class="graphql-code-line comment">"""Bangladeshi taka"""</div>
<div class="graphql-code-line ">BDT</div>
<div class="graphql-code-line comment">"""Bulgarian lev"""</div>
<div class="graphql-code-line ">BGN</div>
<div class="graphql-code-line comment">"""Bahraini dinar"""</div>
<div class="graphql-code-line ">BHD</div>
<div class="graphql-code-line comment">"""Burundian franc"""</div>
<div class="graphql-code-line ">BIF</div>
<div class="graphql-code-line comment">"""Bermudian dollar"""</div>
<div class="graphql-code-line ">BMD</div>
<div class="graphql-code-line comment">"""Brunei dollar"""</div>
<div class="graphql-code-line ">BND</div>
<div class="graphql-code-line comment">"""Boliviano"""</div>
<div class="graphql-code-line ">BOB</div>
<div class="graphql-code-line comment">"""Brazilian real"""</div>
<div class="graphql-code-line ">BRL</div>
<div class="graphql-code-line comment">"""Bahamian dollar"""</div>
<div class="graphql-code-line ">BSD</div>
<div class="graphql-code-line comment">"""Bhutanese ngultrum"""</div>
<div class="graphql-code-line ">BTN</div>
<div class="graphql-code-line comment">"""Botswana pula"""</div>
<div class="graphql-code-line ">BWP</div>
<div class="graphql-code-line comment">"""Belarusian ruble"""</div>
<div class="graphql-code-line ">BYN</div>
<div class="graphql-code-line comment">"""Belize dollar"""</div>
<div class="graphql-code-line ">BZD</div>
<div class="graphql-code-line comment">"""Canadian dollar"""</div>
<div class="graphql-code-line ">CAD</div>
<div class="graphql-code-line comment">"""Congolese franc"""</div>
<div class="graphql-code-line ">CDF</div>
<div class="graphql-code-line comment">"""Swiss franc"""</div>
<div class="graphql-code-line ">CHF</div>
<div class="graphql-code-line comment">"""Chilean peso"""</div>
<div class="graphql-code-line ">CLP</div>
<div class="graphql-code-line comment">"""Renminbi (Chinese) yuan"""</div>
<div class="graphql-code-line ">CNY</div>
<div class="graphql-code-line comment">"""Colombian peso"""</div>
<div class="graphql-code-line ">COP</div>
<div class="graphql-code-line comment">"""Costa Rican colon"""</div>
<div class="graphql-code-line ">CRC</div>
<div class="graphql-code-line comment">"""Cuban convertible peso"""</div>
<div class="graphql-code-line ">CUC</div>
<div class="graphql-code-line comment">"""Cuban peso"""</div>
<div class="graphql-code-line ">CUP</div>
<div class="graphql-code-line comment">"""Cape Verde escudo"""</div>
<div class="graphql-code-line ">CVE</div>
<div class="graphql-code-line comment">"""Czech koruna"""</div>
<div class="graphql-code-line ">CZK</div>
<div class="graphql-code-line comment">"""Djiboutian franc"""</div>
<div class="graphql-code-line ">DJF</div>
<div class="graphql-code-line comment">"""Danish krone"""</div>
<div class="graphql-code-line ">DKK</div>
<div class="graphql-code-line comment">"""Dominican peso"""</div>
<div class="graphql-code-line ">DOP</div>
<div class="graphql-code-line comment">"""Algerian dinar"""</div>
<div class="graphql-code-line ">DZD</div>
<div class="graphql-code-line comment">"""Egyptian pound"""</div>
<div class="graphql-code-line ">EGP</div>
<div class="graphql-code-line comment">"""Eritrean nakfa"""</div>
<div class="graphql-code-line ">ERN</div>
<div class="graphql-code-line comment">"""Ethiopian birr"""</div>
<div class="graphql-code-line ">ETB</div>
<div class="graphql-code-line comment">"""Euro"""</div>
<div class="graphql-code-line ">EUR</div>
<div class="graphql-code-line comment">"""Fiji dollar"""</div>
<div class="graphql-code-line ">FJD</div>
<div class="graphql-code-line comment">"""Falkland Islands pound"""</div>
<div class="graphql-code-line ">FKP</div>
<div class="graphql-code-line comment">"""Pound sterling"""</div>
<div class="graphql-code-line ">GBP</div>
<div class="graphql-code-line comment">"""Georgian lari"""</div>
<div class="graphql-code-line ">GEL</div>
<div class="graphql-code-line comment">"""Ghanaian cedi"""</div>
<div class="graphql-code-line ">GHS</div>
<div class="graphql-code-line comment">"""Gibraltar pound"""</div>
<div class="graphql-code-line ">GIP</div>
<div class="graphql-code-line comment">"""Gambian dalasi"""</div>
<div class="graphql-code-line ">GMD</div>
<div class="graphql-code-line comment">"""Guinean franc"""</div>
<div class="graphql-code-line ">GNF</div>
<div class="graphql-code-line comment">"""Guatemalan quetzal"""</div>
<div class="graphql-code-line ">GTQ</div>
<div class="graphql-code-line comment">"""Guyanese dollar"""</div>
<div class="graphql-code-line ">GYD</div>
<div class="graphql-code-line comment">"""Hong Kong dollar"""</div>
<div class="graphql-code-line ">HKD</div>
<div class="graphql-code-line comment">"""Honduran lempira"""</div>
<div class="graphql-code-line ">HNL</div>
<div class="graphql-code-line comment">"""Croatian kuna"""</div>
<div class="graphql-code-line ">HRK</div>
<div class="graphql-code-line comment">"""Haitian gourde"""</div>
<div class="graphql-code-line ">HTG</div>
<div class="graphql-code-line comment">"""Hungarian forint"""</div>
<div class="graphql-code-line ">HUF</div>
<div class="graphql-code-line comment">"""Indonesian rupiah"""</div>
<div class="graphql-code-line ">IDR</div>
<div class="graphql-code-line comment">"""Israeli new shekel"""</div>
<div class="graphql-code-line ">ILS</div>
<div class="graphql-code-line comment">"""Indian rupee"""</div>
<div class="graphql-code-line ">INR</div>
<div class="graphql-code-line comment">"""Iraqi dinar"""</div>
<div class="graphql-code-line ">IQD</div>
<div class="graphql-code-line comment">"""Iranian rial"""</div>
<div class="graphql-code-line ">IRR</div>
<div class="graphql-code-line comment">"""Icelandic króna"""</div>
<div class="graphql-code-line ">ISK</div>
<div class="graphql-code-line comment">"""Jamaican dollar"""</div>
<div class="graphql-code-line ">JMD</div>
<div class="graphql-code-line comment">"""Jordanian dinar"""</div>
<div class="graphql-code-line ">JOD</div>
<div class="graphql-code-line comment">"""Japanese yen"""</div>
<div class="graphql-code-line ">JPY</div>
<div class="graphql-code-line comment">"""Kenyan shilling"""</div>
<div class="graphql-code-line ">KES</div>
<div class="graphql-code-line comment">"""Kyrgyzstani som"""</div>
<div class="graphql-code-line ">KGS</div>
<div class="graphql-code-line comment">"""Cambodian riel"""</div>
<div class="graphql-code-line ">KHR</div>
<div class="graphql-code-line comment">"""Comoro franc"""</div>
<div class="graphql-code-line ">KMF</div>
<div class="graphql-code-line comment">"""North Korean won"""</div>
<div class="graphql-code-line ">KPW</div>
<div class="graphql-code-line comment">"""South Korean won"""</div>
<div class="graphql-code-line ">KRW</div>
<div class="graphql-code-line comment">"""Kuwaiti dinar"""</div>
<div class="graphql-code-line ">KWD</div>
<div class="graphql-code-line comment">"""Cayman Islands dollar"""</div>
<div class="graphql-code-line ">KYD</div>
<div class="graphql-code-line comment">"""Kazakhstani tenge"""</div>
<div class="graphql-code-line ">KZT</div>
<div class="graphql-code-line comment">"""Lao kip"""</div>
<div class="graphql-code-line ">LAK</div>
<div class="graphql-code-line comment">"""Lebanese pound"""</div>
<div class="graphql-code-line ">LBP</div>
<div class="graphql-code-line comment">"""Sri Lankan rupee"""</div>
<div class="graphql-code-line ">LKR</div>
<div class="graphql-code-line comment">"""Liberian dollar"""</div>
<div class="graphql-code-line ">LRD</div>
<div class="graphql-code-line comment">"""Lesotho loti"""</div>
<div class="graphql-code-line ">LSL</div>
<div class="graphql-code-line comment">"""Libyan dinar"""</div>
<div class="graphql-code-line ">LYD</div>
<div class="graphql-code-line comment">"""Moroccan dirham"""</div>
<div class="graphql-code-line ">MAD</div>
<div class="graphql-code-line comment">"""Moldovan leu"""</div>
<div class="graphql-code-line ">MDL</div>
<div class="graphql-code-line comment">"""Malagasy ariary"""</div>
<div class="graphql-code-line ">MGA</div>
<div class="graphql-code-line comment">"""Macedonian denar"""</div>
<div class="graphql-code-line ">MKD</div>
<div class="graphql-code-line comment">"""Myanmar kyat"""</div>
<div class="graphql-code-line ">MMK</div>
<div class="graphql-code-line comment">"""Mongolian tögrög"""</div>
<div class="graphql-code-line ">MNT</div>
<div class="graphql-code-line comment">"""Macanese pataca"""</div>
<div class="graphql-code-line ">MOP</div>
<div class="graphql-code-line comment">"""Mauritanian ouguiya"""</div>
<div class="graphql-code-line ">MRU</div>
<div class="graphql-code-line comment">"""Mauritian rupee"""</div>
<div class="graphql-code-line ">MUR</div>
<div class="graphql-code-line comment">"""Maldivian rufiyaa"""</div>
<div class="graphql-code-line ">MVR</div>
<div class="graphql-code-line comment">"""Malawian kwacha"""</div>
<div class="graphql-code-line ">MWK</div>
<div class="graphql-code-line comment">"""Mexican peso"""</div>
<div class="graphql-code-line ">MXN</div>
<div class="graphql-code-line comment">"""Malaysian ringgit"""</div>
<div class="graphql-code-line ">MYR</div>
<div class="graphql-code-line comment">"""Mozambican metical"""</div>
<div class="graphql-code-line ">MZN</div>
<div class="graphql-code-line comment">"""Namibian dollar"""</div>
<div class="graphql-code-line ">NAD</div>
<div class="graphql-code-line comment">"""Nigerian naira"""</div>
<div class="graphql-code-line ">NGN</div>
<div class="graphql-code-line comment">"""Nicaraguan córdoba"""</div>
<div class="graphql-code-line ">NIO</div>
<div class="graphql-code-line comment">"""Norwegian krone"""</div>
<div class="graphql-code-line ">NOK</div>
<div class="graphql-code-line comment">"""Nepalese rupee"""</div>
<div class="graphql-code-line ">NPR</div>
<div class="graphql-code-line comment">"""New Zealand dollar"""</div>
<div class="graphql-code-line ">NZD</div>
<div class="graphql-code-line comment">"""Omani rial"""</div>
<div class="graphql-code-line ">OMR</div>
<div class="graphql-code-line comment">"""Panamanian balboa"""</div>
<div class="graphql-code-line ">PAB</div>
<div class="graphql-code-line comment">"""Peruvian sol"""</div>
<div class="graphql-code-line ">PEN</div>
<div class="graphql-code-line comment">"""Papua New Guinean kina"""</div>
<div class="graphql-code-line ">PGK</div>
<div class="graphql-code-line comment">"""Philippine peso"""</div>
<div class="graphql-code-line ">PHP</div>
<div class="graphql-code-line comment">"""Pakistani rupee"""</div>
<div class="graphql-code-line ">PKR</div>
<div class="graphql-code-line comment">"""Polish złoty"""</div>
<div class="graphql-code-line ">PLN</div>
<div class="graphql-code-line comment">"""Paraguayan guaraní"""</div>
<div class="graphql-code-line ">PYG</div>
<div class="graphql-code-line comment">"""Qatari riyal"""</div>
<div class="graphql-code-line ">QAR</div>
<div class="graphql-code-line comment">"""Romanian leu"""</div>
<div class="graphql-code-line ">RON</div>
<div class="graphql-code-line comment">"""Serbian dinar"""</div>
<div class="graphql-code-line ">RSD</div>
<div class="graphql-code-line comment">"""Russian ruble"""</div>
<div class="graphql-code-line ">RUB</div>
<div class="graphql-code-line comment">"""Rwandan franc"""</div>
<div class="graphql-code-line ">RWF</div>
<div class="graphql-code-line comment">"""Saudi riyal"""</div>
<div class="graphql-code-line ">SAR</div>
<div class="graphql-code-line comment">"""Solomon Islands dollar"""</div>
<div class="graphql-code-line ">SBD</div>
<div class="graphql-code-line comment">"""Seychelles rupee"""</div>
<div class="graphql-code-line ">SCR</div>
<div class="graphql-code-line comment">"""Sudanese pound"""</div>
<div class="graphql-code-line ">SDG</div>
<div class="graphql-code-line comment">"""Swedish krona/kronor"""</div>
<div class="graphql-code-line ">SEK</div>
<div class="graphql-code-line comment">"""Singapore dollar"""</div>
<div class="graphql-code-line ">SGD</div>
<div class="graphql-code-line comment">"""Saint Helena pound"""</div>
<div class="graphql-code-line ">SHP</div>
<div class="graphql-code-line comment">"""Sierra Leonean leone"""</div>
<div class="graphql-code-line ">SLL</div>
<div class="graphql-code-line comment">"""Somali shilling"""</div>
<div class="graphql-code-line ">SOS</div>
<div class="graphql-code-line comment">"""Surinamese dollar"""</div>
<div class="graphql-code-line ">SRD</div>
<div class="graphql-code-line comment">"""South Sudanese pound"""</div>
<div class="graphql-code-line ">SSP</div>
<div class="graphql-code-line comment">"""São Tomé and Príncipe dobra"""</div>
<div class="graphql-code-line ">STN</div>
<div class="graphql-code-line comment">"""Salvadoran colón"""</div>
<div class="graphql-code-line ">SVC</div>
<div class="graphql-code-line comment">"""Syrian pound"""</div>
<div class="graphql-code-line ">SYP</div>
<div class="graphql-code-line comment">"""Swazi lilangeni"""</div>
<div class="graphql-code-line ">SZL</div>
<div class="graphql-code-line comment">"""Thai baht"""</div>
<div class="graphql-code-line ">THB</div>
<div class="graphql-code-line comment">"""Tajikistani somoni"""</div>
<div class="graphql-code-line ">TJS</div>
<div class="graphql-code-line comment">"""Turkmenistan manat"""</div>
<div class="graphql-code-line ">TMT</div>
<div class="graphql-code-line comment">"""Tunisian dinar"""</div>
<div class="graphql-code-line ">TND</div>
<div class="graphql-code-line comment">"""Tongan paʻanga"""</div>
<div class="graphql-code-line ">TOP</div>
<div class="graphql-code-line comment">"""Turkish lira"""</div>
<div class="graphql-code-line ">TRY</div>
<div class="graphql-code-line comment">"""Trinidad and Tobago dollar"""</div>
<div class="graphql-code-line ">TTD</div>
<div class="graphql-code-line comment">"""New Taiwan dollar"""</div>
<div class="graphql-code-line ">TWD</div>
<div class="graphql-code-line comment">"""Tanzanian shilling"""</div>
<div class="graphql-code-line ">TZS</div>
<div class="graphql-code-line comment">"""Ukrainian hryvnia"""</div>
<div class="graphql-code-line ">UAH</div>
<div class="graphql-code-line comment">"""Ugandan shilling"""</div>
<div class="graphql-code-line ">UGX</div>
<div class="graphql-code-line comment">"""United States dollar"""</div>
<div class="graphql-code-line ">USD</div>
<div class="graphql-code-line comment">"""Uruguayan peso"""</div>
<div class="graphql-code-line ">UYU</div>
<div class="graphql-code-line comment">"""Uzbekistan som"""</div>
<div class="graphql-code-line ">UZS</div>
<div class="graphql-code-line comment">"""Venezuelan bolívar soberano"""</div>
<div class="graphql-code-line ">VES</div>
<div class="graphql-code-line comment">"""Vietnamese đồng"""</div>
<div class="graphql-code-line ">VND</div>
<div class="graphql-code-line comment">"""Vanuatu vatu"""</div>
<div class="graphql-code-line ">VUV</div>
<div class="graphql-code-line comment">"""Samoan tala"""</div>
<div class="graphql-code-line ">WST</div>
<div class="graphql-code-line comment">"""CFA franc BEAC"""</div>
<div class="graphql-code-line ">XAF</div>
<div class="graphql-code-line comment">"""East Caribbean dollar"""</div>
<div class="graphql-code-line ">XCD</div>
<div class="graphql-code-line comment">"""CFA franc BCEAO"""</div>
<div class="graphql-code-line ">XOF</div>
<div class="graphql-code-line comment">"""CFP franc (franc Pacifique)"""</div>
<div class="graphql-code-line ">XPF</div>
<div class="graphql-code-line comment">"""Yemeni rial"""</div>
<div class="graphql-code-line ">YER</div>
<div class="graphql-code-line comment">"""South African rand"""</div>
<div class="graphql-code-line ">ZAR</div>
<div class="graphql-code-line comment">"""Zambian kwacha"""</div>
<div class="graphql-code-line ">ZMW</div>
<div class="graphql-code-line comment">"""Zimbabwean dollar"""</div>
<div class="graphql-code-line ">ZWL</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## DeletionResult

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">DeletionResult</span> &#123;</div>
<div class="graphql-code-line comment">"""The entity was successfully deleted"""</div>
<div class="graphql-code-line ">DELETED</div>
<div class="graphql-code-line comment">"""Deletion did not take place, reason given in message"""</div>
<div class="graphql-code-line ">NOT_DELETED</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## ErrorCode

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">ErrorCode</span> &#123;</div>
<div class="graphql-code-line ">UNKNOWN_ERROR</div>
<div class="graphql-code-line ">MIME_TYPE_ERROR</div>
<div class="graphql-code-line ">LANGUAGE_NOT_AVAILABLE_ERROR</div>
<div class="graphql-code-line ">DUPLICATE_ENTITY_ERROR</div>
<div class="graphql-code-line ">FACET_IN_USE_ERROR</div>
<div class="graphql-code-line ">CHANNEL_DEFAULT_LANGUAGE_ERROR</div>
<div class="graphql-code-line ">SETTLE_PAYMENT_ERROR</div>
<div class="graphql-code-line ">CANCEL_PAYMENT_ERROR</div>
<div class="graphql-code-line ">EMPTY_ORDER_LINE_SELECTION_ERROR</div>
<div class="graphql-code-line ">ITEMS_ALREADY_FULFILLED_ERROR</div>
<div class="graphql-code-line ">INVALID_FULFILLMENT_HANDLER_ERROR</div>
<div class="graphql-code-line ">CREATE_FULFILLMENT_ERROR</div>
<div class="graphql-code-line ">INSUFFICIENT_STOCK_ON_HAND_ERROR</div>
<div class="graphql-code-line ">MULTIPLE_ORDER_ERROR</div>
<div class="graphql-code-line ">CANCEL_ACTIVE_ORDER_ERROR</div>
<div class="graphql-code-line ">PAYMENT_ORDER_MISMATCH_ERROR</div>
<div class="graphql-code-line ">REFUND_ORDER_STATE_ERROR</div>
<div class="graphql-code-line ">NOTHING_TO_REFUND_ERROR</div>
<div class="graphql-code-line ">ALREADY_REFUNDED_ERROR</div>
<div class="graphql-code-line ">QUANTITY_TOO_GREAT_ERROR</div>
<div class="graphql-code-line ">REFUND_AMOUNT_ERROR</div>
<div class="graphql-code-line ">REFUND_STATE_TRANSITION_ERROR</div>
<div class="graphql-code-line ">PAYMENT_STATE_TRANSITION_ERROR</div>
<div class="graphql-code-line ">FULFILLMENT_STATE_TRANSITION_ERROR</div>
<div class="graphql-code-line ">ORDER_MODIFICATION_STATE_ERROR</div>
<div class="graphql-code-line ">NO_CHANGES_SPECIFIED_ERROR</div>
<div class="graphql-code-line ">PAYMENT_METHOD_MISSING_ERROR</div>
<div class="graphql-code-line ">REFUND_PAYMENT_ID_MISSING_ERROR</div>
<div class="graphql-code-line ">MANUAL_PAYMENT_STATE_ERROR</div>
<div class="graphql-code-line ">PRODUCT_OPTION_IN_USE_ERROR</div>
<div class="graphql-code-line ">MISSING_CONDITIONS_ERROR</div>
<div class="graphql-code-line ">NATIVE_AUTH_STRATEGY_ERROR</div>
<div class="graphql-code-line ">INVALID_CREDENTIALS_ERROR</div>
<div class="graphql-code-line ">ORDER_STATE_TRANSITION_ERROR</div>
<div class="graphql-code-line ">EMAIL_ADDRESS_CONFLICT_ERROR</div>
<div class="graphql-code-line ">GUEST_CHECKOUT_ERROR</div>
<div class="graphql-code-line ">ORDER_LIMIT_ERROR</div>
<div class="graphql-code-line ">NEGATIVE_QUANTITY_ERROR</div>
<div class="graphql-code-line ">INSUFFICIENT_STOCK_ERROR</div>
<div class="graphql-code-line ">COUPON_CODE_INVALID_ERROR</div>
<div class="graphql-code-line ">COUPON_CODE_EXPIRED_ERROR</div>
<div class="graphql-code-line ">COUPON_CODE_LIMIT_ERROR</div>
<div class="graphql-code-line ">ORDER_MODIFICATION_ERROR</div>
<div class="graphql-code-line ">INELIGIBLE_SHIPPING_METHOD_ERROR</div>
<div class="graphql-code-line ">NO_ACTIVE_ORDER_ERROR</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## GlobalFlag

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">GlobalFlag</span> &#123;</div>
<div class="graphql-code-line ">TRUE</div>
<div class="graphql-code-line ">FALSE</div>
<div class="graphql-code-line ">INHERIT</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## HistoryEntryType

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">HistoryEntryType</span> &#123;</div>
<div class="graphql-code-line ">CUSTOMER_REGISTERED</div>
<div class="graphql-code-line ">CUSTOMER_VERIFIED</div>
<div class="graphql-code-line ">CUSTOMER_DETAIL_UPDATED</div>
<div class="graphql-code-line ">CUSTOMER_ADDED_TO_GROUP</div>
<div class="graphql-code-line ">CUSTOMER_REMOVED_FROM_GROUP</div>
<div class="graphql-code-line ">CUSTOMER_ADDRESS_CREATED</div>
<div class="graphql-code-line ">CUSTOMER_ADDRESS_UPDATED</div>
<div class="graphql-code-line ">CUSTOMER_ADDRESS_DELETED</div>
<div class="graphql-code-line ">CUSTOMER_PASSWORD_UPDATED</div>
<div class="graphql-code-line ">CUSTOMER_PASSWORD_RESET_REQUESTED</div>
<div class="graphql-code-line ">CUSTOMER_PASSWORD_RESET_VERIFIED</div>
<div class="graphql-code-line ">CUSTOMER_EMAIL_UPDATE_REQUESTED</div>
<div class="graphql-code-line ">CUSTOMER_EMAIL_UPDATE_VERIFIED</div>
<div class="graphql-code-line ">CUSTOMER_NOTE</div>
<div class="graphql-code-line ">ORDER_STATE_TRANSITION</div>
<div class="graphql-code-line ">ORDER_PAYMENT_TRANSITION</div>
<div class="graphql-code-line ">ORDER_FULFILLMENT</div>
<div class="graphql-code-line ">ORDER_CANCELLATION</div>
<div class="graphql-code-line ">ORDER_REFUND_TRANSITION</div>
<div class="graphql-code-line ">ORDER_FULFILLMENT_TRANSITION</div>
<div class="graphql-code-line ">ORDER_NOTE</div>
<div class="graphql-code-line ">ORDER_COUPON_APPLIED</div>
<div class="graphql-code-line ">ORDER_COUPON_REMOVED</div>
<div class="graphql-code-line ">ORDER_MODIFIED</div>
<div class="graphql-code-line ">ORDER_CUSTOMER_UPDATED</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## JobState

<div class="graphql-code-block">
<div class="graphql-code-line comment">"""</div>
<div class="graphql-code-line comment">The state of a Job in the JobQueue</div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment"></div>
<div class="graphql-code-line comment">"""</div>

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">JobState</span> &#123;</div>
<div class="graphql-code-line ">PENDING</div>
<div class="graphql-code-line ">RUNNING</div>
<div class="graphql-code-line ">COMPLETED</div>
<div class="graphql-code-line ">RETRYING</div>
<div class="graphql-code-line ">FAILED</div>
<div class="graphql-code-line ">CANCELLED</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## LanguageCode

<div class="graphql-code-block">
<div class="graphql-code-line comment">"""</div>
<div class="graphql-code-line comment">Languages in the form of a ISO 639-1 language code with optional</div>

<div class="graphql-code-line comment">region or script modifier (e.g. de_AT). The selection available is based</div>

<div class="graphql-code-line comment">on the [Unicode CLDR summary list](https://unicode-org.github.io/cldr-staging/charts/37/summary/root.html)</div>

<div class="graphql-code-line comment">and includes the major spoken languages of the world and any widely-used variants.</div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment"></div>
<div class="graphql-code-line comment">"""</div>

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">LanguageCode</span> &#123;</div>
<div class="graphql-code-line comment">"""Afrikaans"""</div>
<div class="graphql-code-line ">af</div>
<div class="graphql-code-line comment">"""Akan"""</div>
<div class="graphql-code-line ">ak</div>
<div class="graphql-code-line comment">"""Albanian"""</div>
<div class="graphql-code-line ">sq</div>
<div class="graphql-code-line comment">"""Amharic"""</div>
<div class="graphql-code-line ">am</div>
<div class="graphql-code-line comment">"""Arabic"""</div>
<div class="graphql-code-line ">ar</div>
<div class="graphql-code-line comment">"""Armenian"""</div>
<div class="graphql-code-line ">hy</div>
<div class="graphql-code-line comment">"""Assamese"""</div>
<div class="graphql-code-line ">as</div>
<div class="graphql-code-line comment">"""Azerbaijani"""</div>
<div class="graphql-code-line ">az</div>
<div class="graphql-code-line comment">"""Bambara"""</div>
<div class="graphql-code-line ">bm</div>
<div class="graphql-code-line comment">"""Bangla"""</div>
<div class="graphql-code-line ">bn</div>
<div class="graphql-code-line comment">"""Basque"""</div>
<div class="graphql-code-line ">eu</div>
<div class="graphql-code-line comment">"""Belarusian"""</div>
<div class="graphql-code-line ">be</div>
<div class="graphql-code-line comment">"""Bosnian"""</div>
<div class="graphql-code-line ">bs</div>
<div class="graphql-code-line comment">"""Breton"""</div>
<div class="graphql-code-line ">br</div>
<div class="graphql-code-line comment">"""Bulgarian"""</div>
<div class="graphql-code-line ">bg</div>
<div class="graphql-code-line comment">"""Burmese"""</div>
<div class="graphql-code-line ">my</div>
<div class="graphql-code-line comment">"""Catalan"""</div>
<div class="graphql-code-line ">ca</div>
<div class="graphql-code-line comment">"""Chechen"""</div>
<div class="graphql-code-line ">ce</div>
<div class="graphql-code-line comment">"""Chinese"""</div>
<div class="graphql-code-line ">zh</div>
<div class="graphql-code-line comment">"""Simplified Chinese"""</div>
<div class="graphql-code-line ">zh_Hans</div>
<div class="graphql-code-line comment">"""Traditional Chinese"""</div>
<div class="graphql-code-line ">zh_Hant</div>
<div class="graphql-code-line comment">"""Church Slavic"""</div>
<div class="graphql-code-line ">cu</div>
<div class="graphql-code-line comment">"""Cornish"""</div>
<div class="graphql-code-line ">kw</div>
<div class="graphql-code-line comment">"""Corsican"""</div>
<div class="graphql-code-line ">co</div>
<div class="graphql-code-line comment">"""Croatian"""</div>
<div class="graphql-code-line ">hr</div>
<div class="graphql-code-line comment">"""Czech"""</div>
<div class="graphql-code-line ">cs</div>
<div class="graphql-code-line comment">"""Danish"""</div>
<div class="graphql-code-line ">da</div>
<div class="graphql-code-line comment">"""Dutch"""</div>
<div class="graphql-code-line ">nl</div>
<div class="graphql-code-line comment">"""Flemish"""</div>
<div class="graphql-code-line ">nl_BE</div>
<div class="graphql-code-line comment">"""Dzongkha"""</div>
<div class="graphql-code-line ">dz</div>
<div class="graphql-code-line comment">"""English"""</div>
<div class="graphql-code-line ">en</div>
<div class="graphql-code-line comment">"""Australian English"""</div>
<div class="graphql-code-line ">en_AU</div>
<div class="graphql-code-line comment">"""Canadian English"""</div>
<div class="graphql-code-line ">en_CA</div>
<div class="graphql-code-line comment">"""British English"""</div>
<div class="graphql-code-line ">en_GB</div>
<div class="graphql-code-line comment">"""American English"""</div>
<div class="graphql-code-line ">en_US</div>
<div class="graphql-code-line comment">"""Esperanto"""</div>
<div class="graphql-code-line ">eo</div>
<div class="graphql-code-line comment">"""Estonian"""</div>
<div class="graphql-code-line ">et</div>
<div class="graphql-code-line comment">"""Ewe"""</div>
<div class="graphql-code-line ">ee</div>
<div class="graphql-code-line comment">"""Faroese"""</div>
<div class="graphql-code-line ">fo</div>
<div class="graphql-code-line comment">"""Finnish"""</div>
<div class="graphql-code-line ">fi</div>
<div class="graphql-code-line comment">"""French"""</div>
<div class="graphql-code-line ">fr</div>
<div class="graphql-code-line comment">"""Canadian French"""</div>
<div class="graphql-code-line ">fr_CA</div>
<div class="graphql-code-line comment">"""Swiss French"""</div>
<div class="graphql-code-line ">fr_CH</div>
<div class="graphql-code-line comment">"""Fulah"""</div>
<div class="graphql-code-line ">ff</div>
<div class="graphql-code-line comment">"""Galician"""</div>
<div class="graphql-code-line ">gl</div>
<div class="graphql-code-line comment">"""Ganda"""</div>
<div class="graphql-code-line ">lg</div>
<div class="graphql-code-line comment">"""Georgian"""</div>
<div class="graphql-code-line ">ka</div>
<div class="graphql-code-line comment">"""German"""</div>
<div class="graphql-code-line ">de</div>
<div class="graphql-code-line comment">"""Austrian German"""</div>
<div class="graphql-code-line ">de_AT</div>
<div class="graphql-code-line comment">"""Swiss High German"""</div>
<div class="graphql-code-line ">de_CH</div>
<div class="graphql-code-line comment">"""Greek"""</div>
<div class="graphql-code-line ">el</div>
<div class="graphql-code-line comment">"""Gujarati"""</div>
<div class="graphql-code-line ">gu</div>
<div class="graphql-code-line comment">"""Haitian Creole"""</div>
<div class="graphql-code-line ">ht</div>
<div class="graphql-code-line comment">"""Hausa"""</div>
<div class="graphql-code-line ">ha</div>
<div class="graphql-code-line comment">"""Hebrew"""</div>
<div class="graphql-code-line ">he</div>
<div class="graphql-code-line comment">"""Hindi"""</div>
<div class="graphql-code-line ">hi</div>
<div class="graphql-code-line comment">"""Hungarian"""</div>
<div class="graphql-code-line ">hu</div>
<div class="graphql-code-line comment">"""Icelandic"""</div>
<div class="graphql-code-line ">is</div>
<div class="graphql-code-line comment">"""Igbo"""</div>
<div class="graphql-code-line ">ig</div>
<div class="graphql-code-line comment">"""Indonesian"""</div>
<div class="graphql-code-line ">id</div>
<div class="graphql-code-line comment">"""Interlingua"""</div>
<div class="graphql-code-line ">ia</div>
<div class="graphql-code-line comment">"""Irish"""</div>
<div class="graphql-code-line ">ga</div>
<div class="graphql-code-line comment">"""Italian"""</div>
<div class="graphql-code-line ">it</div>
<div class="graphql-code-line comment">"""Japanese"""</div>
<div class="graphql-code-line ">ja</div>
<div class="graphql-code-line comment">"""Javanese"""</div>
<div class="graphql-code-line ">jv</div>
<div class="graphql-code-line comment">"""Kalaallisut"""</div>
<div class="graphql-code-line ">kl</div>
<div class="graphql-code-line comment">"""Kannada"""</div>
<div class="graphql-code-line ">kn</div>
<div class="graphql-code-line comment">"""Kashmiri"""</div>
<div class="graphql-code-line ">ks</div>
<div class="graphql-code-line comment">"""Kazakh"""</div>
<div class="graphql-code-line ">kk</div>
<div class="graphql-code-line comment">"""Khmer"""</div>
<div class="graphql-code-line ">km</div>
<div class="graphql-code-line comment">"""Kikuyu"""</div>
<div class="graphql-code-line ">ki</div>
<div class="graphql-code-line comment">"""Kinyarwanda"""</div>
<div class="graphql-code-line ">rw</div>
<div class="graphql-code-line comment">"""Korean"""</div>
<div class="graphql-code-line ">ko</div>
<div class="graphql-code-line comment">"""Kurdish"""</div>
<div class="graphql-code-line ">ku</div>
<div class="graphql-code-line comment">"""Kyrgyz"""</div>
<div class="graphql-code-line ">ky</div>
<div class="graphql-code-line comment">"""Lao"""</div>
<div class="graphql-code-line ">lo</div>
<div class="graphql-code-line comment">"""Latin"""</div>
<div class="graphql-code-line ">la</div>
<div class="graphql-code-line comment">"""Latvian"""</div>
<div class="graphql-code-line ">lv</div>
<div class="graphql-code-line comment">"""Lingala"""</div>
<div class="graphql-code-line ">ln</div>
<div class="graphql-code-line comment">"""Lithuanian"""</div>
<div class="graphql-code-line ">lt</div>
<div class="graphql-code-line comment">"""Luba-Katanga"""</div>
<div class="graphql-code-line ">lu</div>
<div class="graphql-code-line comment">"""Luxembourgish"""</div>
<div class="graphql-code-line ">lb</div>
<div class="graphql-code-line comment">"""Macedonian"""</div>
<div class="graphql-code-line ">mk</div>
<div class="graphql-code-line comment">"""Malagasy"""</div>
<div class="graphql-code-line ">mg</div>
<div class="graphql-code-line comment">"""Malay"""</div>
<div class="graphql-code-line ">ms</div>
<div class="graphql-code-line comment">"""Malayalam"""</div>
<div class="graphql-code-line ">ml</div>
<div class="graphql-code-line comment">"""Maltese"""</div>
<div class="graphql-code-line ">mt</div>
<div class="graphql-code-line comment">"""Manx"""</div>
<div class="graphql-code-line ">gv</div>
<div class="graphql-code-line comment">"""Maori"""</div>
<div class="graphql-code-line ">mi</div>
<div class="graphql-code-line comment">"""Marathi"""</div>
<div class="graphql-code-line ">mr</div>
<div class="graphql-code-line comment">"""Mongolian"""</div>
<div class="graphql-code-line ">mn</div>
<div class="graphql-code-line comment">"""Nepali"""</div>
<div class="graphql-code-line ">ne</div>
<div class="graphql-code-line comment">"""North Ndebele"""</div>
<div class="graphql-code-line ">nd</div>
<div class="graphql-code-line comment">"""Northern Sami"""</div>
<div class="graphql-code-line ">se</div>
<div class="graphql-code-line comment">"""Norwegian Bokmål"""</div>
<div class="graphql-code-line ">nb</div>
<div class="graphql-code-line comment">"""Norwegian Nynorsk"""</div>
<div class="graphql-code-line ">nn</div>
<div class="graphql-code-line comment">"""Nyanja"""</div>
<div class="graphql-code-line ">ny</div>
<div class="graphql-code-line comment">"""Odia"""</div>
<div class="graphql-code-line ">or</div>
<div class="graphql-code-line comment">"""Oromo"""</div>
<div class="graphql-code-line ">om</div>
<div class="graphql-code-line comment">"""Ossetic"""</div>
<div class="graphql-code-line ">os</div>
<div class="graphql-code-line comment">"""Pashto"""</div>
<div class="graphql-code-line ">ps</div>
<div class="graphql-code-line comment">"""Persian"""</div>
<div class="graphql-code-line ">fa</div>
<div class="graphql-code-line comment">"""Dari"""</div>
<div class="graphql-code-line ">fa_AF</div>
<div class="graphql-code-line comment">"""Polish"""</div>
<div class="graphql-code-line ">pl</div>
<div class="graphql-code-line comment">"""Portuguese"""</div>
<div class="graphql-code-line ">pt</div>
<div class="graphql-code-line comment">"""Brazilian Portuguese"""</div>
<div class="graphql-code-line ">pt_BR</div>
<div class="graphql-code-line comment">"""European Portuguese"""</div>
<div class="graphql-code-line ">pt_PT</div>
<div class="graphql-code-line comment">"""Punjabi"""</div>
<div class="graphql-code-line ">pa</div>
<div class="graphql-code-line comment">"""Quechua"""</div>
<div class="graphql-code-line ">qu</div>
<div class="graphql-code-line comment">"""Romanian"""</div>
<div class="graphql-code-line ">ro</div>
<div class="graphql-code-line comment">"""Moldavian"""</div>
<div class="graphql-code-line ">ro_MD</div>
<div class="graphql-code-line comment">"""Romansh"""</div>
<div class="graphql-code-line ">rm</div>
<div class="graphql-code-line comment">"""Rundi"""</div>
<div class="graphql-code-line ">rn</div>
<div class="graphql-code-line comment">"""Russian"""</div>
<div class="graphql-code-line ">ru</div>
<div class="graphql-code-line comment">"""Samoan"""</div>
<div class="graphql-code-line ">sm</div>
<div class="graphql-code-line comment">"""Sango"""</div>
<div class="graphql-code-line ">sg</div>
<div class="graphql-code-line comment">"""Sanskrit"""</div>
<div class="graphql-code-line ">sa</div>
<div class="graphql-code-line comment">"""Scottish Gaelic"""</div>
<div class="graphql-code-line ">gd</div>
<div class="graphql-code-line comment">"""Serbian"""</div>
<div class="graphql-code-line ">sr</div>
<div class="graphql-code-line comment">"""Shona"""</div>
<div class="graphql-code-line ">sn</div>
<div class="graphql-code-line comment">"""Sichuan Yi"""</div>
<div class="graphql-code-line ">ii</div>
<div class="graphql-code-line comment">"""Sindhi"""</div>
<div class="graphql-code-line ">sd</div>
<div class="graphql-code-line comment">"""Sinhala"""</div>
<div class="graphql-code-line ">si</div>
<div class="graphql-code-line comment">"""Slovak"""</div>
<div class="graphql-code-line ">sk</div>
<div class="graphql-code-line comment">"""Slovenian"""</div>
<div class="graphql-code-line ">sl</div>
<div class="graphql-code-line comment">"""Somali"""</div>
<div class="graphql-code-line ">so</div>
<div class="graphql-code-line comment">"""Southern Sotho"""</div>
<div class="graphql-code-line ">st</div>
<div class="graphql-code-line comment">"""Spanish"""</div>
<div class="graphql-code-line ">es</div>
<div class="graphql-code-line comment">"""European Spanish"""</div>
<div class="graphql-code-line ">es_ES</div>
<div class="graphql-code-line comment">"""Mexican Spanish"""</div>
<div class="graphql-code-line ">es_MX</div>
<div class="graphql-code-line comment">"""Sundanese"""</div>
<div class="graphql-code-line ">su</div>
<div class="graphql-code-line comment">"""Swahili"""</div>
<div class="graphql-code-line ">sw</div>
<div class="graphql-code-line comment">"""Congo Swahili"""</div>
<div class="graphql-code-line ">sw_CD</div>
<div class="graphql-code-line comment">"""Swedish"""</div>
<div class="graphql-code-line ">sv</div>
<div class="graphql-code-line comment">"""Tajik"""</div>
<div class="graphql-code-line ">tg</div>
<div class="graphql-code-line comment">"""Tamil"""</div>
<div class="graphql-code-line ">ta</div>
<div class="graphql-code-line comment">"""Tatar"""</div>
<div class="graphql-code-line ">tt</div>
<div class="graphql-code-line comment">"""Telugu"""</div>
<div class="graphql-code-line ">te</div>
<div class="graphql-code-line comment">"""Thai"""</div>
<div class="graphql-code-line ">th</div>
<div class="graphql-code-line comment">"""Tibetan"""</div>
<div class="graphql-code-line ">bo</div>
<div class="graphql-code-line comment">"""Tigrinya"""</div>
<div class="graphql-code-line ">ti</div>
<div class="graphql-code-line comment">"""Tongan"""</div>
<div class="graphql-code-line ">to</div>
<div class="graphql-code-line comment">"""Turkish"""</div>
<div class="graphql-code-line ">tr</div>
<div class="graphql-code-line comment">"""Turkmen"""</div>
<div class="graphql-code-line ">tk</div>
<div class="graphql-code-line comment">"""Ukrainian"""</div>
<div class="graphql-code-line ">uk</div>
<div class="graphql-code-line comment">"""Urdu"""</div>
<div class="graphql-code-line ">ur</div>
<div class="graphql-code-line comment">"""Uyghur"""</div>
<div class="graphql-code-line ">ug</div>
<div class="graphql-code-line comment">"""Uzbek"""</div>
<div class="graphql-code-line ">uz</div>
<div class="graphql-code-line comment">"""Vietnamese"""</div>
<div class="graphql-code-line ">vi</div>
<div class="graphql-code-line comment">"""Volapük"""</div>
<div class="graphql-code-line ">vo</div>
<div class="graphql-code-line comment">"""Welsh"""</div>
<div class="graphql-code-line ">cy</div>
<div class="graphql-code-line comment">"""Western Frisian"""</div>
<div class="graphql-code-line ">fy</div>
<div class="graphql-code-line comment">"""Wolof"""</div>
<div class="graphql-code-line ">wo</div>
<div class="graphql-code-line comment">"""Xhosa"""</div>
<div class="graphql-code-line ">xh</div>
<div class="graphql-code-line comment">"""Yiddish"""</div>
<div class="graphql-code-line ">yi</div>
<div class="graphql-code-line comment">"""Yoruba"""</div>
<div class="graphql-code-line ">yo</div>
<div class="graphql-code-line comment">"""Zulu"""</div>
<div class="graphql-code-line ">zu</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## LogicalOperator

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">LogicalOperator</span> &#123;</div>
<div class="graphql-code-line ">AND</div>
<div class="graphql-code-line ">OR</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## MetricInterval

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">MetricInterval</span> &#123;</div>
<div class="graphql-code-line ">Daily</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## MetricType

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">MetricType</span> &#123;</div>
<div class="graphql-code-line ">OrderCount</div>
<div class="graphql-code-line ">OrderTotal</div>
<div class="graphql-code-line ">AverageOrderValue</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## OrderType

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">OrderType</span> &#123;</div>
<div class="graphql-code-line ">Regular</div>
<div class="graphql-code-line ">Seller</div>
<div class="graphql-code-line ">Aggregate</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## Permission

<div class="graphql-code-block">
<div class="graphql-code-line comment">"""</div>
<div class="graphql-code-line comment">Permissions for administrators and customers. Used to control access to</div>

<div class="graphql-code-line comment">GraphQL resolvers via the &#123;@link Allow&#125; decorator.</div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment">## Understanding Permission.Owner</div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment">`Permission.Owner` is a special permission which is used in some Vendure resolvers to indicate that that resolver should only</div>

<div class="graphql-code-line comment">be accessible to the "owner" of that resource.</div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment">For example, the Shop API <code>activeCustomer</code> query resolver should only return the Customer object for the "owner" of that Customer, i.e.</div>

<div class="graphql-code-line comment">based on the activeUserId of the current session. As a result, the resolver code looks like this:</div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment">@example</div>

<div class="graphql-code-line comment">```TypeScript</div>

<div class="graphql-code-line comment">\@Query()</div>

<div class="graphql-code-line comment">\@Allow(Permission.Owner)</div>

<div class="graphql-code-line comment">async activeCustomer(\@Ctx() ctx: RequestContext): Promise&lt;Customer | undefined&gt; &#123;</div>

<div class="graphql-code-line comment">  const userId = ctx.activeUserId;</div>

<div class="graphql-code-line comment">  if (userId) &#123;</div>

<div class="graphql-code-line comment">    return this.customerService.findOneByUserId(ctx, userId);</div>

<div class="graphql-code-line comment">  &#125;</div>

<div class="graphql-code-line comment">&#125;</div>

<div class="graphql-code-line comment">```</div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment">Here we can see that the "ownership" must be enforced by custom logic inside the resolver. Since "ownership" cannot be defined generally</div>

<div class="graphql-code-line comment">nor statically encoded at build-time, any resolvers using <code>Permission.Owner</code> **must** include logic to enforce that only the owner</div>

<div class="graphql-code-line comment">of the resource has access. If not, then it is the equivalent of using `Permission.Public`.</div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment"></div>

<div class="graphql-code-line comment"></div>
<div class="graphql-code-line comment">"""</div>

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">Permission</span> &#123;</div>
<div class="graphql-code-line comment">"""Authenticated means simply that the user is logged in"""</div>
<div class="graphql-code-line ">Authenticated</div>
<div class="graphql-code-line comment">"""SuperAdmin has unrestricted access to all operations"""</div>
<div class="graphql-code-line ">SuperAdmin</div>
<div class="graphql-code-line comment">"""Owner means the user owns this entity, e.g. a Customer's own Order"""</div>
<div class="graphql-code-line ">Owner</div>
<div class="graphql-code-line comment">"""Public means any unauthenticated user may perform the operation"""</div>
<div class="graphql-code-line ">Public</div>
<div class="graphql-code-line comment">"""Grants permission to update GlobalSettings"""</div>
<div class="graphql-code-line ">UpdateGlobalSettings</div>
<div class="graphql-code-line comment">"""Grants permission to create Products, Facets, Assets, Collections"""</div>
<div class="graphql-code-line ">CreateCatalog</div>
<div class="graphql-code-line comment">"""Grants permission to read Products, Facets, Assets, Collections"""</div>
<div class="graphql-code-line ">ReadCatalog</div>
<div class="graphql-code-line comment">"""Grants permission to update Products, Facets, Assets, Collections"""</div>
<div class="graphql-code-line ">UpdateCatalog</div>
<div class="graphql-code-line comment">"""Grants permission to delete Products, Facets, Assets, Collections"""</div>
<div class="graphql-code-line ">DeleteCatalog</div>
<div class="graphql-code-line comment">"""Grants permission to create PaymentMethods, ShippingMethods, TaxCategories, TaxRates, Zones, Countries, System & GlobalSettings"""</div>
<div class="graphql-code-line ">CreateSettings</div>
<div class="graphql-code-line comment">"""Grants permission to read PaymentMethods, ShippingMethods, TaxCategories, TaxRates, Zones, Countries, System & GlobalSettings"""</div>
<div class="graphql-code-line ">ReadSettings</div>
<div class="graphql-code-line comment">"""Grants permission to update PaymentMethods, ShippingMethods, TaxCategories, TaxRates, Zones, Countries, System & GlobalSettings"""</div>
<div class="graphql-code-line ">UpdateSettings</div>
<div class="graphql-code-line comment">"""Grants permission to delete PaymentMethods, ShippingMethods, TaxCategories, TaxRates, Zones, Countries, System & GlobalSettings"""</div>
<div class="graphql-code-line ">DeleteSettings</div>
<div class="graphql-code-line comment">"""Grants permission to create Administrator"""</div>
<div class="graphql-code-line ">CreateAdministrator</div>
<div class="graphql-code-line comment">"""Grants permission to read Administrator"""</div>
<div class="graphql-code-line ">ReadAdministrator</div>
<div class="graphql-code-line comment">"""Grants permission to update Administrator"""</div>
<div class="graphql-code-line ">UpdateAdministrator</div>
<div class="graphql-code-line comment">"""Grants permission to delete Administrator"""</div>
<div class="graphql-code-line ">DeleteAdministrator</div>
<div class="graphql-code-line comment">"""Grants permission to create Asset"""</div>
<div class="graphql-code-line ">CreateAsset</div>
<div class="graphql-code-line comment">"""Grants permission to read Asset"""</div>
<div class="graphql-code-line ">ReadAsset</div>
<div class="graphql-code-line comment">"""Grants permission to update Asset"""</div>
<div class="graphql-code-line ">UpdateAsset</div>
<div class="graphql-code-line comment">"""Grants permission to delete Asset"""</div>
<div class="graphql-code-line ">DeleteAsset</div>
<div class="graphql-code-line comment">"""Grants permission to create Channel"""</div>
<div class="graphql-code-line ">CreateChannel</div>
<div class="graphql-code-line comment">"""Grants permission to read Channel"""</div>
<div class="graphql-code-line ">ReadChannel</div>
<div class="graphql-code-line comment">"""Grants permission to update Channel"""</div>
<div class="graphql-code-line ">UpdateChannel</div>
<div class="graphql-code-line comment">"""Grants permission to delete Channel"""</div>
<div class="graphql-code-line ">DeleteChannel</div>
<div class="graphql-code-line comment">"""Grants permission to create Collection"""</div>
<div class="graphql-code-line ">CreateCollection</div>
<div class="graphql-code-line comment">"""Grants permission to read Collection"""</div>
<div class="graphql-code-line ">ReadCollection</div>
<div class="graphql-code-line comment">"""Grants permission to update Collection"""</div>
<div class="graphql-code-line ">UpdateCollection</div>
<div class="graphql-code-line comment">"""Grants permission to delete Collection"""</div>
<div class="graphql-code-line ">DeleteCollection</div>
<div class="graphql-code-line comment">"""Grants permission to create Country"""</div>
<div class="graphql-code-line ">CreateCountry</div>
<div class="graphql-code-line comment">"""Grants permission to read Country"""</div>
<div class="graphql-code-line ">ReadCountry</div>
<div class="graphql-code-line comment">"""Grants permission to update Country"""</div>
<div class="graphql-code-line ">UpdateCountry</div>
<div class="graphql-code-line comment">"""Grants permission to delete Country"""</div>
<div class="graphql-code-line ">DeleteCountry</div>
<div class="graphql-code-line comment">"""Grants permission to create Customer"""</div>
<div class="graphql-code-line ">CreateCustomer</div>
<div class="graphql-code-line comment">"""Grants permission to read Customer"""</div>
<div class="graphql-code-line ">ReadCustomer</div>
<div class="graphql-code-line comment">"""Grants permission to update Customer"""</div>
<div class="graphql-code-line ">UpdateCustomer</div>
<div class="graphql-code-line comment">"""Grants permission to delete Customer"""</div>
<div class="graphql-code-line ">DeleteCustomer</div>
<div class="graphql-code-line comment">"""Grants permission to create CustomerGroup"""</div>
<div class="graphql-code-line ">CreateCustomerGroup</div>
<div class="graphql-code-line comment">"""Grants permission to read CustomerGroup"""</div>
<div class="graphql-code-line ">ReadCustomerGroup</div>
<div class="graphql-code-line comment">"""Grants permission to update CustomerGroup"""</div>
<div class="graphql-code-line ">UpdateCustomerGroup</div>
<div class="graphql-code-line comment">"""Grants permission to delete CustomerGroup"""</div>
<div class="graphql-code-line ">DeleteCustomerGroup</div>
<div class="graphql-code-line comment">"""Grants permission to create Facet"""</div>
<div class="graphql-code-line ">CreateFacet</div>
<div class="graphql-code-line comment">"""Grants permission to read Facet"""</div>
<div class="graphql-code-line ">ReadFacet</div>
<div class="graphql-code-line comment">"""Grants permission to update Facet"""</div>
<div class="graphql-code-line ">UpdateFacet</div>
<div class="graphql-code-line comment">"""Grants permission to delete Facet"""</div>
<div class="graphql-code-line ">DeleteFacet</div>
<div class="graphql-code-line comment">"""Grants permission to create Order"""</div>
<div class="graphql-code-line ">CreateOrder</div>
<div class="graphql-code-line comment">"""Grants permission to read Order"""</div>
<div class="graphql-code-line ">ReadOrder</div>
<div class="graphql-code-line comment">"""Grants permission to update Order"""</div>
<div class="graphql-code-line ">UpdateOrder</div>
<div class="graphql-code-line comment">"""Grants permission to delete Order"""</div>
<div class="graphql-code-line ">DeleteOrder</div>
<div class="graphql-code-line comment">"""Grants permission to create PaymentMethod"""</div>
<div class="graphql-code-line ">CreatePaymentMethod</div>
<div class="graphql-code-line comment">"""Grants permission to read PaymentMethod"""</div>
<div class="graphql-code-line ">ReadPaymentMethod</div>
<div class="graphql-code-line comment">"""Grants permission to update PaymentMethod"""</div>
<div class="graphql-code-line ">UpdatePaymentMethod</div>
<div class="graphql-code-line comment">"""Grants permission to delete PaymentMethod"""</div>
<div class="graphql-code-line ">DeletePaymentMethod</div>
<div class="graphql-code-line comment">"""Grants permission to create Product"""</div>
<div class="graphql-code-line ">CreateProduct</div>
<div class="graphql-code-line comment">"""Grants permission to read Product"""</div>
<div class="graphql-code-line ">ReadProduct</div>
<div class="graphql-code-line comment">"""Grants permission to update Product"""</div>
<div class="graphql-code-line ">UpdateProduct</div>
<div class="graphql-code-line comment">"""Grants permission to delete Product"""</div>
<div class="graphql-code-line ">DeleteProduct</div>
<div class="graphql-code-line comment">"""Grants permission to create Promotion"""</div>
<div class="graphql-code-line ">CreatePromotion</div>
<div class="graphql-code-line comment">"""Grants permission to read Promotion"""</div>
<div class="graphql-code-line ">ReadPromotion</div>
<div class="graphql-code-line comment">"""Grants permission to update Promotion"""</div>
<div class="graphql-code-line ">UpdatePromotion</div>
<div class="graphql-code-line comment">"""Grants permission to delete Promotion"""</div>
<div class="graphql-code-line ">DeletePromotion</div>
<div class="graphql-code-line comment">"""Grants permission to create ShippingMethod"""</div>
<div class="graphql-code-line ">CreateShippingMethod</div>
<div class="graphql-code-line comment">"""Grants permission to read ShippingMethod"""</div>
<div class="graphql-code-line ">ReadShippingMethod</div>
<div class="graphql-code-line comment">"""Grants permission to update ShippingMethod"""</div>
<div class="graphql-code-line ">UpdateShippingMethod</div>
<div class="graphql-code-line comment">"""Grants permission to delete ShippingMethod"""</div>
<div class="graphql-code-line ">DeleteShippingMethod</div>
<div class="graphql-code-line comment">"""Grants permission to create Tag"""</div>
<div class="graphql-code-line ">CreateTag</div>
<div class="graphql-code-line comment">"""Grants permission to read Tag"""</div>
<div class="graphql-code-line ">ReadTag</div>
<div class="graphql-code-line comment">"""Grants permission to update Tag"""</div>
<div class="graphql-code-line ">UpdateTag</div>
<div class="graphql-code-line comment">"""Grants permission to delete Tag"""</div>
<div class="graphql-code-line ">DeleteTag</div>
<div class="graphql-code-line comment">"""Grants permission to create TaxCategory"""</div>
<div class="graphql-code-line ">CreateTaxCategory</div>
<div class="graphql-code-line comment">"""Grants permission to read TaxCategory"""</div>
<div class="graphql-code-line ">ReadTaxCategory</div>
<div class="graphql-code-line comment">"""Grants permission to update TaxCategory"""</div>
<div class="graphql-code-line ">UpdateTaxCategory</div>
<div class="graphql-code-line comment">"""Grants permission to delete TaxCategory"""</div>
<div class="graphql-code-line ">DeleteTaxCategory</div>
<div class="graphql-code-line comment">"""Grants permission to create TaxRate"""</div>
<div class="graphql-code-line ">CreateTaxRate</div>
<div class="graphql-code-line comment">"""Grants permission to read TaxRate"""</div>
<div class="graphql-code-line ">ReadTaxRate</div>
<div class="graphql-code-line comment">"""Grants permission to update TaxRate"""</div>
<div class="graphql-code-line ">UpdateTaxRate</div>
<div class="graphql-code-line comment">"""Grants permission to delete TaxRate"""</div>
<div class="graphql-code-line ">DeleteTaxRate</div>
<div class="graphql-code-line comment">"""Grants permission to create Seller"""</div>
<div class="graphql-code-line ">CreateSeller</div>
<div class="graphql-code-line comment">"""Grants permission to read Seller"""</div>
<div class="graphql-code-line ">ReadSeller</div>
<div class="graphql-code-line comment">"""Grants permission to update Seller"""</div>
<div class="graphql-code-line ">UpdateSeller</div>
<div class="graphql-code-line comment">"""Grants permission to delete Seller"""</div>
<div class="graphql-code-line ">DeleteSeller</div>
<div class="graphql-code-line comment">"""Grants permission to create StockLocation"""</div>
<div class="graphql-code-line ">CreateStockLocation</div>
<div class="graphql-code-line comment">"""Grants permission to read StockLocation"""</div>
<div class="graphql-code-line ">ReadStockLocation</div>
<div class="graphql-code-line comment">"""Grants permission to update StockLocation"""</div>
<div class="graphql-code-line ">UpdateStockLocation</div>
<div class="graphql-code-line comment">"""Grants permission to delete StockLocation"""</div>
<div class="graphql-code-line ">DeleteStockLocation</div>
<div class="graphql-code-line comment">"""Grants permission to create System"""</div>
<div class="graphql-code-line ">CreateSystem</div>
<div class="graphql-code-line comment">"""Grants permission to read System"""</div>
<div class="graphql-code-line ">ReadSystem</div>
<div class="graphql-code-line comment">"""Grants permission to update System"""</div>
<div class="graphql-code-line ">UpdateSystem</div>
<div class="graphql-code-line comment">"""Grants permission to delete System"""</div>
<div class="graphql-code-line ">DeleteSystem</div>
<div class="graphql-code-line comment">"""Grants permission to create Zone"""</div>
<div class="graphql-code-line ">CreateZone</div>
<div class="graphql-code-line comment">"""Grants permission to read Zone"""</div>
<div class="graphql-code-line ">ReadZone</div>
<div class="graphql-code-line comment">"""Grants permission to update Zone"""</div>
<div class="graphql-code-line ">UpdateZone</div>
<div class="graphql-code-line comment">"""Grants permission to delete Zone"""</div>
<div class="graphql-code-line ">DeleteZone</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## SortOrder

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">SortOrder</span> &#123;</div>
<div class="graphql-code-line ">ASC</div>
<div class="graphql-code-line ">DESC</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>

## StockMovementType

<div class="graphql-code-block">

<div class="graphql-code-line top-level">enum <span class="graphql-code-identifier">StockMovementType</span> &#123;</div>
<div class="graphql-code-line ">ADJUSTMENT</div>
<div class="graphql-code-line ">ALLOCATION</div>
<div class="graphql-code-line ">RELEASE</div>
<div class="graphql-code-line ">SALE</div>
<div class="graphql-code-line ">CANCELLATION</div>
<div class="graphql-code-line ">RETURN</div>
<div class="graphql-code-line top-level">&#125;</div>
</div>
