/***********************************************************************
 * Copyright (c) 2013-2025 General Atomics Integrated Intelligence, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * https://www.apache.org/licenses/LICENSE-2.0
 ***********************************************************************/

package org.locationtech.geomesa.utils.conf

import com.typesafe.scalalogging.LazyLogging

import java.util.Properties

object GeoMesaProperties extends LazyLogging {

  private val EmbeddedFile = "/org/locationtech/geomesa/geomesa.properties"

  private val props: Properties = {
    val resource = getClass.getResourceAsStream(EmbeddedFile)
    val props = new Properties
    if (resource == null) {
      logger.warn(s"Couldn't load $EmbeddedFile")
      props
    } else {
      try {
        props.load(resource)
      } finally {
        resource.close()
      }
      props
    }
  }

  val ProjectVersion = props.getProperty("geomesa.project.version")
  val BuildDate      = props.getProperty("geomesa.build.date")
  val GitCommit      = props.getProperty("geomesa.build.commit.id")
  val GitBranch      = props.getProperty("geomesa.build.branch")
}
