/***********************************************************************
 * Copyright (c) 2013-2025 General Atomics Integrated Intelligence, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * https://www.apache.org/licenses/LICENSE-2.0
 ***********************************************************************/

package org.locationtech.geomesa.redis.tools.schema

import com.beust.jcommander.Parameters
import org.locationtech.geomesa.redis.data.RedisDataStore
import org.locationtech.geomesa.redis.tools.RedisDataStoreCommand
import org.locationtech.geomesa.redis.tools.RedisDataStoreCommand.RedisDataStoreParams
import org.locationtech.geomesa.redis.tools.schema.RedisRemoveSchemaCommand.RedisRemoveSchemaParams
import org.locationtech.geomesa.tools.data.{RemoveSchemaCommand, RemoveSchemaParams}

class RedisRemoveSchemaCommand extends RemoveSchemaCommand[RedisDataStore] with RedisDataStoreCommand {
  override val params = new RedisRemoveSchemaParams
}

object RedisRemoveSchemaCommand {
  @Parameters(commandDescription = "Remove a schema and all associated features")
  class RedisRemoveSchemaParams extends RemoveSchemaParams with RedisDataStoreParams
}
