/***********************************************************************
 * Copyright (c) 2013-2025 General Atomics Integrated Intelligence, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * https://www.apache.org/licenses/LICENSE-2.0
 ***********************************************************************/

package org.locationtech.geomesa.kafka.tools

import org.locationtech.geomesa.kafka.tools.ingest.KafkaPlaybackCommand
import org.locationtech.geomesa.tools.{Command, Runner}

object KafkaRunner extends Runner {

  override val name: String = "geomesa-kafka"

  override protected def commands: Seq[Command] = {
    super.commands ++ Seq(
      new data.KafkaCreateSchemaCommand,
      new data.KafkaMigrateZkCommand,
      new data.KafkaRemoveSchemaCommand,
      new data.KafkaUpdateSchemaCommand,
      new export.KafkaListenCommand,
      new export.KafkaExportCommand,
      new ingest.KafkaIngestCommand,
      new KafkaPlaybackCommand,
      new status.KafkaDescribeSchemaCommand,
      new status.KafkaGetSftConfigCommand,
      new status.KafkaGetTypeNamesCommand
    )
  }

  override protected def classpathEnvironments: Seq[String] = Seq("KAFKA_HOME")
}
