/***********************************************************************
 * Copyright (c) 2013-2025 General Atomics Integrated Intelligence, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * https://www.apache.org/licenses/LICENSE-2.0
 ***********************************************************************/

package org.locationtech.geomesa.geotools.tools.data

import com.beust.jcommander.Parameters
import org.geotools.api.data.DataStore
import org.locationtech.geomesa.geotools.tools.GeoToolsDataStoreCommand
import org.locationtech.geomesa.geotools.tools.GeoToolsDataStoreCommand.GeoToolsDataStoreParams
import org.locationtech.geomesa.geotools.tools.data.GeoToolsDeleteFeaturesCommand.GeoToolsDeleteFeaturesParams
import org.locationtech.geomesa.tools.data.DeleteFeaturesCommand
import org.locationtech.geomesa.tools.data.DeleteFeaturesCommand.DeleteFeaturesParams

class GeoToolsDeleteFeaturesCommand extends DeleteFeaturesCommand[DataStore] with GeoToolsDataStoreCommand {
  override val params: GeoToolsDeleteFeaturesParams = new GeoToolsDeleteFeaturesParams()
}

object GeoToolsDeleteFeaturesCommand {
  @Parameters(commandDescription = "Delete features from a schema")
  class GeoToolsDeleteFeaturesParams extends DeleteFeaturesParams with GeoToolsDataStoreParams
}
