/***********************************************************************
 * Copyright (c) 2013-2025 General Atomics Integrated Intelligence, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * https://www.apache.org/licenses/LICENSE-2.0
 ***********************************************************************/

package org.locationtech.geomesa.gt.partition.postgis.dialect
package functions

/**
 * Truncates a timestamp to the nearest ten-minute boundary. For example, 05:45:23 -> 05:40:00
 */
object TruncateToTenMinutes extends TruncateToTenMinutes with AdvisoryLock {
  override protected val lockId: Long = 2276984964099379703L
}

class TruncateToTenMinutes extends SqlStatements {

  override protected def createStatements(info: TypeInfo): Seq[String] = {
    Seq(
      s"""CREATE OR REPLACE FUNCTION ${info.schema.quoted}.truncate_to_ten_minutes(dtg timestamp without time zone)
         |RETURNS timestamp without time zone AS
         |  $$BODY$$
         |    SELECT date_trunc('hour', dtg) + INTERVAL '10 MINUTES' * floor(date_part('minute', dtg) / 10);
         |  $$BODY$$
         |LANGUAGE sql;""".stripMargin
    )
  }

  override protected def dropStatements(info: TypeInfo): Seq[String] = Seq.empty // function is shared between types
}
