/***********************************************************************
 * Copyright (c) 2013-2025 General Atomics Integrated Intelligence, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * https://www.apache.org/licenses/LICENSE-2.0
 ***********************************************************************/

package org.locationtech.geomesa.filter.function

import org.geotools.api.feature.simple.SimpleFeature
import org.geotools.filter.FunctionExpressionImpl
import org.geotools.filter.capability.FunctionNameImpl

class FastProperty extends FunctionExpressionImpl(FastProperty.Name) {

  private var idx: Int = -1

  def this(i: Int) = {
    this()
    idx = i
  }

  override def evaluate(o: AnyRef): AnyRef = {
    if (idx == -1) {
      idx = getExpression(0).evaluate(null).asInstanceOf[Long].toInt
    }
    o.asInstanceOf[SimpleFeature].getAttribute(idx)
  }
}

object FastProperty {
  val Name = new FunctionNameImpl(
    "fastproperty",
    FunctionNameImpl.parameter("propertyValue", classOf[Object]),
    FunctionNameImpl.parameter("propertyIndex", classOf[Integer])
  )
}
