/***********************************************************************
 * Copyright (c) 2013-2025 General Atomics Integrated Intelligence, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * https://www.apache.org/licenses/LICENSE-2.0
 ***********************************************************************/

package org.locationtech.geomesa.cassandra.tools

import com.beust.jcommander.Parameter
import org.locationtech.geomesa.tools.CredentialsParams

trait CassandraConnectionParams extends CredentialsParams {
  @Parameter(names = Array("-P", "--contact-point"), description = "Cassandra contact point (address of a Cassandra node)", required = true)
  var contactPoint: String = _

  @Parameter(names = Array("-k", "--key-space"), description = "Cassandra key space (must already exist)", required = true)
  var keySpace: String = _
}
