/***********************************************************************
 * Copyright (c) 2013-2025 General Atomics Integrated Intelligence, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * https://www.apache.org/licenses/LICENSE-2.0
 ***********************************************************************/

package org.locationtech.geomesa.accumulo.tools.stats

import com.beust.jcommander.Parameters
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore
import org.locationtech.geomesa.accumulo.tools.stats.AccumuloStatsBoundsCommand.AccumuloStatsBoundsParams
import org.locationtech.geomesa.accumulo.tools.{AccumuloDataStoreCommand, AccumuloDataStoreParams}
import org.locationtech.geomesa.tools.RequiredTypeNameParam
import org.locationtech.geomesa.tools.stats.StatsBoundsCommand
import org.locationtech.geomesa.tools.stats.StatsBoundsCommand.StatsBoundsParams

class AccumuloStatsBoundsCommand extends StatsBoundsCommand[AccumuloDataStore] with AccumuloDataStoreCommand {
  override val params = new AccumuloStatsBoundsParams
}

object AccumuloStatsBoundsCommand {
  @Parameters(commandDescription = "View or calculate bounds on attributes in a GeoMesa feature type")
  class AccumuloStatsBoundsParams extends StatsBoundsParams with AccumuloDataStoreParams with RequiredTypeNameParam
}
