/***********************************************************************
 * Copyright (c) 2013-2025 General Atomics Integrated Intelligence, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * https://www.apache.org/licenses/LICENSE-2.0
 ***********************************************************************/

package org.locationtech.geomesa.accumulo

import org.geotools.api.feature.simple.SimpleFeatureType
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes

import java.util.concurrent.atomic.AtomicInteger

/**
 * Trait to simplify tests that require reading and writing features from an AccumuloDataStore
 */
trait TestWithMultipleSfts extends TestWithDataStore {

  private val sftCounter = new AtomicInteger(0)

  /**
   * Create a new schema
   *
   * @param spec simple feature type spec
   * @return
   */
  def createNewSchema(spec: String): SimpleFeatureType = {
    val sftName = s"${getClass.getSimpleName}${sftCounter.getAndIncrement()}"
    ds.createSchema(SimpleFeatureTypes.createType(sftName, spec))
    ds.getSchema(sftName) // reload the sft from the ds to ensure all user data is set properly
  }
}
