# Command Line Operation

:::{index} Command Line Operation
:::

## Running Arelle on the Command Line

| Method or System      | Command                                                             |
| --------------------- | ------------------------------------------------------------------- |
| Python source code    | `python arelleCmdLine.py [arguments]`                               |
| Windows x64 or 32 bit | `"c:\Program Files\arelleCmdLine.exe" [arguments]`                  |
| MacOS App             | `/Applications/Arelle.app/contents/MacOS/arelleCmdLine [arguments]` |
| Linux/Unix            | `./arelleCmdLine [arguments]`                                       |

## Arguments

### General Arguments

| Flag                | Description                                                 |
| ------------------- | ----------------------------------------------------------- |
| `-a` _or_ `--about` | Prints build, copyright, and license information then exits |
| `-h` _or_ `--help`  | Prints help message and exits                               |
| `--diagnostics`     | Prints diagnostic information                               |
| `--version`         | Prints Arelle's version number and exits                    |

### Input File Arguments

| Flag                                | Description                                                                                                                                                                                                                                 |
| ----------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `-f FILE` _or_ <br/>`--file FILE`   | The `FILE` for Arelle to process. <br>The `FILE` may be an entry point to be loaded, instance, schema, linkbase, inline XBRL instance, testcase file, or testcase index file. <br/> The `FILE` may be local or a URL to a web-located file. |
| `--username USERNAME`               | The `USERNAME` if needed (with the password flag) for web file retrieval .                                                                                                                                                                  |
| `--password PASSWORD`               | The `PASSWORD` if needed (with username flag) for web file retrieval.                                                                                                                                                                       |
| `-i FILE` _or_ <br/>`--import FILE` | Imports a `v` to the DTS, such as additional formula or label linkbases. <br> `FILE` may contain multiple files separated by the `\|` character.                                                                                            |
| `-d DTS` _or_ <br/>`--diff DTS`     | Compares a second DTS for versioning report generation. <br/> The -f file is the fromDTS and the -d `DTS` is the toDTS.                                                                                                                     |
| `-r FILE` _or_ <br/>`--report FILE` | Saves the versioning report (with the diff flag) to the specified `FILE`.                                                                                                                                                                   |

### Validation Arguments

| Flag                                                                | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| ------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `-v` or `--validate`                                                | Validate the file according to the entry file type. <br/>For an XBRL file, it is validated according to XBRL validation 2.1 <br/> Performs calculation linkbase validation if either \\--calcDecimals or \\--calcPrecision are specified<br/> Performs SEC EDGAR Filing Manual validations (if \\--efm selected) <br/>Performs Global Filer Manual disclosure system validation (if \\--gfm=XXX selected). <br/>If a test suite or testcase, the test case variations are individually so validated. <br/>If formulae are present they will be validated and run unless \\--formula=none is specified. |
| `--baseTaxonomyValidation` *or* <br/>`--basetaxonomyvalidation`     | Specify if base taxonomies should be validated. <br/>Skipping validation of base taxonomy files which are known to be valid can significantly reduce validation time. <br/>disclosureSystem - (default) skip validation of base taxonomy files which are known to be valid by the disclosure system <br/> none - skip validation of all base taxonomies <br/>all - validate all base taxonomies                                                                                                                                                                                                        |
| `--noValidateTestcaseSchema` _or_ <br/>`--novalidatetestcaseschema` | Validate testcases against their schemas.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--calc=CALCS`                                                      | Specify calculations validations: <br/> `CALCS` can be one of:<br/>`none` – no calculations validation. <br/> `c10` or `xbrl21` – Calc 1.0 (XBRL 2.1) calculations. <br/>`c10d` or `xbrl21-dedup` – Calc 1.0 (XBRL 2.1) calculations with de-duplication<br/>`c11r` or `round-to-nearest` – Calc 1.1 round-to-nearest mode<br/>`c11t` or `truncation` - Calc 1.1 truncation mode                                                                                                                                                                                                                       |
| `--calcDecimals` _or_ <br/>`--calcdecimals`                         | DEPRECATED - XBRL v2.1 calculation linkbase validation inferring decimals.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `--calcPrecision` _or_ <br/>`--calcprecision`                       | DEPRECATED - pre-2010 XBRL v2.1 calculation linkbase validation inferring precision.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `--calcDeduplicate` _or_ <br/>`--calcdeduplicate`                   | DEPRECATED - de-duplication of consistent facts when performing calculation validation, chooses most accurate fact.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `--efm`                                                             | Select Edgar Filer Manual (U.S. SEC) disclosure system validation (strict).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| `--efm-skip-calc-tree`                                              | Skip walking of calculation tree during EFM validation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `--disclosureSystem=NAME` _or_ <br/>`--disclosuresystem=NAME`       | Specify a disclosure system, and enable disclosure system-specific validation. <br/>Enter `--disclosureSystem=help` for list of names or help-verbose for list of names and descriptions.                                                                                                                                                                                                                                                                                                                                                                                                              |
| `--hmrc`                                                            | Select U.K. HMRC disclosure system validation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--utr`                                                             | Select validation with respect to Unit Type Registry.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `--utrUrl=UTRURL` _or_ <br/>`--utrurl=UTRURL`                       | Used with `--utr` flag. Override disclosure systems Unit Type Registry.<br/>`UTRURL` is the location (URL or file path).                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `--infoset`                                                         | Select validation with respect testcase infosets.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |

### Output Arguments

These arguments can override the system language settings for the output options below.

| Flag                                                      | Description                                                                                                                                                      |
| --------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--labelLang=LABELLANG` _or_ <br/>`--labellang=LABELLANG` | provides an `xml:lang` language code to override the system language settings for labels output by the following file options, e.g. `--labelLang=en-US`          |
| `--disableRtl`                                            | Disable reversing string read order for right to left languages, useful for some locale settings                                                                 |
| `--labelRole=LABELROLE` _or_ <br/>`--labelrole=LABELROLE` | overrides the standard XBRL 2.1 label role for the labels output by the following file options. <br/>e.g. `--labelRole=http://www.xbrl.org/2003/role/terseLabel` |

The following file options determine the type of file saved by the extension of the file name, the extension may be any of:
`.html`, `.htm`, `.xhtml`, `.json` or `.csv`

| Flag                                                                            | Description                                                                                                                                                                                                                                                                                                                                                                                                                |
| ------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--DTS=DTSFILE` _or_ <br/>DEPRECATED `--csvDTS=DTSFILE`                         | Write DTS tree into `DTSFILE`. May be .csv or .html.                                                                                                                                                                                                                                                                                                                                                                       |
| `--facts=FACTSFILE` _or_ <br/>DEPRECATED `--csvFacts=FACTSFILE`                 | Write fact list into `FACTSFILE`.                                                                                                                                                                                                                                                                                                                                                                                          |
| `--factListCols=FACTLISTCOLS`                                                   | Columns for fact list file. <br/>The `FACTLISTCOLS` are comma separated and can be any of these: `Label`, `Name`, `contextRef`, `unitRef`, `Dec`, `Prec`, `Lang`, `Value`, `EntityScheme`, `EntityIdentifier`, `Period`, or `Dimensions`. <br/>The default columns list is `Label,contextRef,unitRef,Dec,Prec,Lang,Value`.                                                                                                 |
| `--factTable=FACTTABLEFILE` _or_ <br/>DEPRECATED `--csvFactTable=FACTTABLEFILE` | Write fact table into `FACTTABLEFILE`                                                                                                                                                                                                                                                                                                                                                                                      |
| `--factListCols=FACTLISTCOLS`                                                   | Columns for fact list file                                                                                                                                                                                                                                                                                                                                                                                                 |
| `--factTable=FACTTABLEFILE` _or_ <br/>DEPRECATED `--csvFactTable=FACTTABLEFILE` | Write fact table into FILE `FACTTABLEFILE`                                                                                                                                                                                                                                                                                                                                                                                 |
| `--factTableCols=FACTTABLECOLS`                                                 | Columns for fact table file                                                                                                                                                                                                                                                                                                                                                                                                |
| `--concepts=CONCEPTSFILE` _or_ <br/>DEPRECATED `--csvConcepts=CONCEPTSFILE`     | Write concepts into `CONCEPTSFILE`                                                                                                                                                                                                                                                                                                                                                                                         |
| `--pre=PREFILE` _or_ <br/>`--csvPre=PREFILE`                                    | Write presentation linkbase into `PREFILE`                                                                                                                                                                                                                                                                                                                                                                                 |
| `--table=TABLEFILE` _or_ <br/>`--csvTable=TABLEFILE`                            | Write table linkbase into `TABLEFILE`                                                                                                                                                                                                                                                                                                                                                                                      |
| `--cal=CALFILE` _or_ <br/> `--csvCal=CALFILE`                                   | Write calculation linkbase into `CALFILE`                                                                                                                                                                                                                                                                                                                                                                                  |
| `--dim=DIMFILE` _or_ <br/> `--csvDim=DIMFILE`                                   | Write dimensions (of definitions) into `DIMFILE`                                                                                                                                                                                                                                                                                                                                                                           |
| `--anch=ANCHFILE`                                                               | Write anchoring relationships (of definition) linkbase into `ANCHFILE` <br/> The wider-narrower hierarchy is shown in a tree view. <br/>For each anchored concept, if there are multiple parent (wider) concepts, the others are shown in a second column, “wider”. <br/>To additionally show name, documentation, and references on this view, specify one or all of `--relationshipCols “Name,Documentation,References”` |
| `--formulae=FORMULAEFILE` _or_ <br/>`--htmlFormulae=FORMULAEFILE`               | Write formulae linkbase into `FORMULAEFILE`                                                                                                                                                                                                                                                                                                                                                                                |
| `--viewArcrole=ARCROLE` _or_ <br/>`--viewarcrole=ARCROLE`                       | Store relationships for the `ARCROLE` in the file specified by `--viewFile` argument.                                                                                                                                                                                                                                                                                                                                      |
| `--viewFile=FILE`                                                               | Specifies the file to store the \\--viewArcrole relationships.                                                                                                                                                                                                                                                                                                                                                             |
| `--roleTypes=FILE`                                                              | Store defined role types in specified `FILE`                                                                                                                                                                                                                                                                                                                                                                               |
| `--arcroleTypes=`FILE`                                                          | Store defined arcrole types in specified `FILE`                                                                                                                                                                                                                                                                                                                                                                            |
| `--testReport=FILE`                                                             | Write a test report of validation (of test cases) in specified `FILE`                                                                                                                                                                                                                                                                                                                                                      |
| `--testReportCols=REPORTCOLS`                                                   | Used with `--testReport` argument. Specifies columns for test report. <br/>`REPORTCOLS` are comma separated and can be any of these: Index, Testcase, ID, Name, Reference, ReadMeFirst, Status, Expected, Actual“.                                                                                                                                                                                                         |
| `--rssReport=FILE`                                                              | Write a test report of RSS feed processing in specified `FILE`                                                                                                                                                                                                                                                                                                                                                             |
| `--rssReportCols=RSSCOLS`                                                       | Used with `--rssReport` argument. Specifies columns for RSS processing.<br/>`RSSCOLS` are comma separated and can be any of these: Company Name, Accession Number, Form, Filing Date, CIK, Status, Period, Yr End, Results”.                                                                                                                                                                                               |

### Logging Arguments

| Flag                       | Description                                                                                                                                                                                                                                                                                                                                                            |
| -------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--logFile=FILE`           | Write log messages into `FILE`, otherwise they go to standard output. If `FILE` ends in .xml it is xml-formatted, otherwise it is text. <br/>XML log files contain significant additional details not provided in the text files. <br/>Default files named logToPrint, logToStdOut.xml and logToStdError provide output on standard output and standard error streams. |
| `--logFormat=FORMAT`       | Specify the Python logger `FORMAT` for the text description of messages, if absent the default is `[%(messageCode)s] %(message)s - %(file)s`.                                                                                                                                                                                                                          |
| `--logLevel=LEVEL`         | Minimum `LEVEL` for messages capture, otherwise the message is ignored. <br/>Current order of levels are: debug, info, info-semantic, warning, warning-semantic, warning, assertion-satisfied, inconsistency, error-semantic, assertion-not-satisfied, and error.                                                                                                      |
| `--logLevelFilter=LOGREGX` | Regular expression filter for logLevel. (E.g., to not match \\_-semantic levels, `--logLevelFilter=(?!^._-semantic$)(.+)`.                                                                                                                                                                                                                                             |
| `--collectProfileStats`    | Collect profile statistics, such as timing of validation activities and formulae.                                                                                                                                                                                                                                                                                      |

### Validation and Formula Options

| Flag                                         | Description                                                                                                                                                                                                                                                                                          |
| -------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--parameters`                               | Specifies parameters for formula and validation (name=value[,name=value]).                                                                                                                                                                                                                           |
| `--parameterSeparator`                       | Used with \\--parameters argument. Specify parameters separator string (if other than comma, may be a multi-character separator).                                                                                                                                                                    |
| `--formula`                                  | Specify formula action, If this option is not specified, `-v` or `--validate` will validate and run formulas if present:<br/> `validate` - validate only, without running<br/>`run` - validate and run<br/>`none` - prevent formula validation or running when also specifying `-v` or `--validate`. |
| `--formulaParamExprResult`                   | Enable ParamExprResult formula tracing.                                                                                                                                                                                                                                                              |
| `--formulaParamInputValue`                   | Enable ParamInputValue formula tracing.                                                                                                                                                                                                                                                              |
| `--formulaMaximumMessageInterpolationLength` | Truncate interpolated expressions in formula messages to this length.                                                                                                                                                                                                                                |
| `--formulaCallExprSource`                    | Enable CallExprSource formula tracing.                                                                                                                                                                                                                                                               |
| `--formulaCallExprCode`                      | Enable CallExprCode formula tracing.                                                                                                                                                                                                                                                                 |
| `--formulaCallExprEval`                      | Enable CallExprEval formula tracing.                                                                                                                                                                                                                                                                 |
| `--formulaCallExprResult`                    | Enable CallExprResult formula tracing.                                                                                                                                                                                                                                                               |
| `--formulaVarSetExprEval`                    | Enable VarSetExprEval formula tracing.                                                                                                                                                                                                                                                               |
| `--formulaVarSetExprResult`                  | Enable VarSetExprResult formula tracing.                                                                                                                                                                                                                                                             |
| `--formulaVarSetTiming`                      | Show times of variable set evaluation                                                                                                                                                                                                                                                                |
| `--formulaAsserResultCounts`                 | Enable AsserResultCounts formula tracing.                                                                                                                                                                                                                                                            |
| `--formulaFormulaRules`                      | Enable FormulaRules formula tracing.                                                                                                                                                                                                                                                                 |
| `--formulaVarsOrder`                         | Enable VarsOrder formula tracing.                                                                                                                                                                                                                                                                    |
| `--formulaVarExpressionSource`               | Enable VarExpressionSource formula tracing.                                                                                                                                                                                                                                                          |
| `--formulaVarExpressionCode`                 | Enable VarExpressionCode formula tracing.                                                                                                                                                                                                                                                            |
| `--formulaVarExpressionEvaluation`           | Enable VarExpressionEvaluation formula tracing.                                                                                                                                                                                                                                                      |
| `--formulaVarExpressionResult`               | Enable VarExpressionResult formula tracing.                                                                                                                                                                                                                                                          |
| `--formulaVarFiltersResult`                  | Enable VarFiltersResult formula tracing.                                                                                                                                                                                                                                                             |
| `--formulaVarFiltersWinnowing`               | Show winnowing process of successive application of formulas, helpful in debugging to find out which filter affects the facts that pass a filtering step                                                                                                                                             |
| `--formulaVarFiltersResult`                  | Show result of filters.                                                                                                                                                                                                                                                                              |

### Configuration options

It is possible to specify options to be defaults for the web server, such as disclosureSystem and validations, but not including file names.

| Flag                                          | Description                                                                                                                                                                                                                                                                                                                                                      |
| --------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--uiLang`                                    | Language for user interface (override system settings, such as program messages). <br/>Does not save setting. Does not affect labels language of above reports (see `--labelLang`)                                                                                                                                                                               |
| `--proxy`                                     | Modify and re-save proxy settings configuration. Enter system to use system proxy setting, none to use no proxy, a specific proxy in the format http://[user[:password]@]host[:port] <br/>(e.g., `http://192.168.1.253`, `http://example.com:8080`, `http://joe:secret@example.com:8080`), or show to `show` current (saved)setting.                             |
| `--internetConnectivity`                      | Specify internet connectivity: `online` or `offline`.                                                                                                                                                                                                                                                                                                            |
| `--internetTimeout`                           | Specify internet connection timeout in seconds (0 means unlimited).                                                                                                                                                                                                                                                                                              |
| `--internetRecheck`                           | Specify frequency of rechecking web file’s time stamps to cached file copy and determine if newer file to be reloaded: `weekly` (default), `daily` or `never`.                                                                                                                                                                                                   |
| `--noCertificateCheck`                        | Skip https SSL certificate checking.                                                                                                                                                                                                                                                                                                                             |
| `--internetLogDownloads`                      | Log an info message for downloads to the web cache.                                                                                                                                                                                                                                                                                                              |
| `--xdgConfigHome`                             | Specify non-standard location for configuration and cache files (overrides environment parameter `XDG_CONFIG_HOME`, if also provided).                                                                                                                                                                                                                           |
| `--plugin` or `--plugins`                     | Specify plugins to load (no longer saved or shared with GUI)<br/> Module urls are `\|` separated. <br/>Standard plugin modules do not need “.py” specified. <br/>Relative URLs are relative to installation plug-in directory. <br/>Packaged plug-in urls are their directory’s url.                                                                             |
| `--packages=FILE` _or_ <br/> `--packages=URL` | Load XBRL taxonomy packages. Option can be repeated to specify multiple packages. Specifying a directory will attempt to load all `.zip` files in the directory.<br />Command line taxonomy package configuration is not persisted or shared with the GUI.<br/>URLs must be full absolute paths. Multiple packages may also be specified as `\|`-separated list. |
| `--abortOnMajorError`                         | Abort process on major error, such as when load is unable to find an entry or discovered file.                                                                                                                                                                                                                                                                   |
| `--webserver`                                 | Start web server on host:port[:server] for REST and web access. <br/>(e.g., `--webserver locahost:8080`, or specify nondefault a server name, such as cheroot, `--webserver locahost:8080:cheroot`.)                                                                                                                                                           |

### Standard Plugins and Options

Many of the plug-ins add command line (in addition to GUI menu) options.
For additional detail see the plug-in documentation. A summary of standard plugin options is provided [here](./plugins/plugins.md).

| inlineDocumentSet | Specify an inline XBRL document set by JSON parameter: \\--file ‘[{“ixDocumentSet”:[{“file”:file1},{“file”:file2}…]}]’                                                                                                                             |
| ----------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--saveInstance`  | Provides a file name into which to save an XBRL instance document derived from a loaded manifest (Japan FSA) of a document set of inline documents, or loaded single inline document. <br/>(Currently supports one target instance document only.) |

| loadFromExcel | Load from Excel file                                                                                             |
| ------------- | ---------------------------------------------------------------------------------------------------------------- |
|               | No command line options, but the `-f` and `--file` options can specify an Excel document which represents a DTS. |

| profileCmdLine           | Profiles command line operation                                                                                                                                                                                                                                                                                    |
| ------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `--save-profiler-report` | Specifies file into which to save a Python profiler report of the timings of Arelle Python methods and routines for the operations performed by the other command line functions.<br/>Useful to determine if a long running function is spending excessive time in a function that needs implementation attention. |

| saveDTS         | Produces a Taxonomy Package.                                                        |
| --------------- | ----------------------------------------------------------------------------------- |
| `--package-DTS` | Specifies a file into which to save a Taxonomy Package representing the loaded DTS. |

| saveHtmlEBAtables      | EBA Table Sets.                                                                                                                                                                        |
| ---------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--save-EBA-tablesets` | Specifies an index file (usually index.html) to represent an html page that holds a table of contents to the EBA tables generated for all loaded EBA Table Linkbase tables in the DTS. |

| saveLoadableExcel       | Saves an Excel workbook                                                                                    |
| ----------------------- | ---------------------------------------------------------------------------------------------------------- |
| `--save-loadable-excel` | Saves an Excel workbook representing the DTS (which can be subsequently loaded by loadFromExcel.py plugin. |

| saveSKOS      | Saves a SKOS (OMG standard OWL file).                                                                                                                               |
| ------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--save-skos` | Saves a SKOS (OMG standard OWL file) representing a semantic view of a DTS based on presentation linkbase entries (for US-GAAP, IFRS, and EDInet style taxonomies). |

| xbrlDB                     | Saves XBRL data to a database.                                                                                                                                                                                                                                                                                                                                  |
| -------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--store-to-XBRL-DB=DBSTR` | Store into XBRL DB. Provides connection string: host,[port], user, password, database, [timeout], technology.                                                                                                                                                                                                                                                   |
|                            | _technology_ can be:<br/>`postgres` - XBRL-US Postgres SQL<br/> `mssqlSemantic` - Semantic MSSQL SQL<br/> `mysqlSemantic` - Semantic MySQL SQL<br/> `orclSemantic` - Semantic Oracle SQL<br/> `pgSemantic` - Semantic Postgres SQL<br/>`rexster` - Rexter (Titan Cassandra)<br/>`rdfDB` - RDF (Turtle, NanoSparqlServer)<br/>`json` - JSON (JSON, MongoDB)<br/> |
|                            | For `rdfDB` if hostname is `rdfTurtleFile` or `rdfXmlFile`, then database specifies a local file system pathname to store a file. <br/>For `json`, if hostname is `jsonFile` then database specifies a local file system path name to store into a file.<br/>                                                                                                   |

Example storing into postgres database using XBRL-US schema:

```pwsh
arelleCmdLine -f c:\temp\test.rss -v --disclosureSystem efm-pragmatic-all-years --store-to-XBRL-DB "myhost.com,8084,pgUserId,pgPassword,test_db,90,postgres"
```

Example storing into local MSSQL database using SQLEXPRESS instance:

```pwsh
arelleCmdLine -f c:\temp\test.rss -v --disclosureSystem efm-pragmatic-all-years --store-to-XBRL-DB "localhost\SQLEXPRESS,,sqlLogin,sqlPassword,,90,mssqlSemantic"
```

### Disclosure System Selections

Run with `--disclosureSystem=help` to list the disclosure systems that are available for the currently loaded plugins.
