Contributing to Flutter
=======================

[![Build Status](https://api.cirrus-ci.com/github/flutter/flutter.svg)](https://cirrus-ci.org/flutter/flutter)

_See also: [Flutter's code of conduct](CODE_OF_CONDUCT.md)_

Welcome
-------

We invite you to join our team! Everyone is welcome to contribute code
via pull requests, to file issues on GitHub, to help people asking for
help on our mailing lists or on Stack Overflow, to help triage,
reproduce, or fix bugs that people have filed, to add to our
documentation, or to help out in any other way.

We grant commit access (which includes full rights to the issue
database, such as being able to edit labels) to people who have gained
our trust and demonstrated a commitment to Flutter.

This document focuses on what is needed to contribute by writing code
and submitting pull requests for the Flutter framework. For
information on contributing in other ways, see [the community page
on flutter.io](https://flutter.io/community).

Developing for Flutter
----------------------

To develop for Flutter, you will eventually need to become familiar
with our processes and conventions. This section lists the documents
that describe these methodologies. The following list is ordered: you
are strongly recommended to go through these documents in the order
presented.

1. [Our code of conduct](CODE_OF_CONDUCT.md), which stipulates explicitly
   that everyone must be gracious, respectful, and professional. This
   also documents our conflict resolution policy and encourages people
   to ask questions.

2. [Values](https://github.com/flutter/flutter/wiki/Values),
   which talks about what we care most about.

3. [Setting up your engine development environment](https://github.com/flutter/flutter/wiki/Setting-up-the-Engine-development-environment),
   which describes the steps you need to configure your computer to
   work on Flutter's engine. If you only want to write code for the
   Flutter framework, you can skip this step. Flutter's engine uses
   mainly C++, Java, and ObjectiveC.

4. [Setting up your framework development environment](https://github.com/flutter/flutter/wiki/Setting-up-the-Framework-development-environment),
   which describes the steps you need to configure your computer to
   work on Flutter's framework. Flutter's framework uses mainly Dart.

4. [Tree hygiene](https://github.com/flutter/flutter/wiki/Tree-hygiene),
   which covers how to land a PR, how to do code review, how to
   handle breaking changes, how to handle regressions, and how to
   handle post-commit test failures.

3. [Issue hygiene](https://github.com/flutter/flutter/wiki/Issue-hygiene),
   which covers our processes around triaging bugs, escalating high
   priority bugs, assigning bugs, and our GitHub labels and
   milestones.

5. [Our style guide](https://github.com/flutter/flutter/wiki/Style-guide-for-Flutter-repo),
   which includes advice for designing APIs for Flutter, and how to
   format code in the framework.

In addition to the above, there are many pages on [our
Wiki](https://github.com/flutter/flutter/wiki/) that may be of
interest. For a curated list of pages see the sidebar on the wiki's
home page. They are more or less listed in order of importance.

If you would like to chat to other people who work on Flutter, consider joining the
https://gitter.im/flutter/contributors chat channel. We also have a [general chat
channel](https://gitter.im/flutter/flutter) for people who aren't working on Flutter
but who use Flutter.
