# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](http://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [3.1.0] - 2022-04-27
### Added
- `b2bstoreqa.seller-selector-custom` dependency and blocks
## [3.0.0] - 2022-04-26

### Added

- `vtex.storefront-permissions-ui@1.x` dependency
- `vtex.b2b-quotes` dependency and `quotes-locking-modal` block
- `vtex.b2b-organizations` dependency and `b2b-user-widget` block

### Removed

- `b2bstoreqa.seller-selector-custom` dependency and blocks
- `vtex.storefront-permissions-ui@0.x` peer dependency

## [2.1.0] - 2022-04-25

### Added

- `seller-selector-custom` to PDP

## [2.0.2] - 2022-02-03

### Fixed

- Added `!` to beginning of anonymous function at the top of `checkout6-custom.js` to ensure it can work in conjunction with other apps that inject checkout JS
- Apply Prettier formatting to changelog

## [2.0.1] - 2022-01-13

### Removed

- Information regarding old Organizations app

## [2.0.0] - 2021-11-11

## [1.3.0] - 2021-11-11

### Added

- New B2B apps

## [1.2.0] - 2021-10-21

## [1.1.0] - 2021-10-19

### Changed

- Add buyer organization sign up block
- Add approved status block

## [1.0.1] - 2021-10-05

### Changed

- Updated documentation on README.md file.

## [1.0.0] - 2021-04-09

## [4.12.6] - 2021-03-25

### Changed

- Docs: Removed easy setup steps

## [4.12.5] - 2021-03-02

### Added

- Power Tools and Security menu items

## [4.12.4] - 2021-02-12

### Fixed

- Hide sticky buy if user is not logged-in

## [4.12.3] - 2021-02-12

### Fixed

- Hide product comparison selector
- Coomputer typo

## [4.12.2] - 2021-02-11

### Fixed

- Style login to view prices message

## [4.12.1] - 2021-02-11

### Fixed

- Shipping simulator estimate name

## [4.12.0] - 2021-02-11

### Removed

- Shipping simulator radio button

## [4.11.0] - 2021-02-04

### Added

- Checkout UI Custom builder and files (PO Number)

## [4.10.1] - 2021-02-04

### Fixed

- Search results breadcrumb and filters spacing
- Product summary ratings summary alignment
- Popular and trending product comparison
- Make orderquote routes private
- Drawer login position

## [4.10.0] - 2021-02-03

### Fixed

- Product comparison in custom search pages

### Added

- Make Quick Order a private route

## [4.9.0] - 2021-02-03

### Added

- Add quickorder textarea and upload fields

## [4.8.0] - 2021-02-03

### Added

- Styles for native `breadcrumb` block

## [4.7.0] - 2021-02-02

### Removed

- `pickup-availability` blocks

## [4.6.1] - 2021-02-02

### Added

- Wishlist my account link

## [4.6.0] - 2021-02-01

### Added

- My Account Wishlist blocks

### Fixed

- Small CSS fixes

## [4.5.0] - 2021-01-29

### Added

- Reseller form

## [4.4.2] - 2021-01-29

### Fixed

- Org challeng disallowed message

## [4.4.1] - 2021-01-29

### Removed

- Deprecated blocks

### Fixed

- Blog alignment

## [4.4.0] - 2021-01-28

### Added

- Product summary price organization challenge

### Removed

- Shop by brand block
- Trade policy challenge
- Currency selector and locale switcher

## [4.3.5] - 2021-01-21

### Fixed

- Add back mistakenly removed `product-name` block

## [4.3.4] - 2021-01-12

### Added

- Institutional pages

### Fixed

- Newsletter in search pages
- Sliders arrows misalignment

## [4.3.3] - 2021-01-11

### Fixed

- Minicart product image size
- Minicart items size and styles
- Minicart empty icon

## [4.3.2] - 2021-01-04

### Fixed

- Remove duplicated `product-comparison-drawer` block
- Telemarketing container sizing

## [4.3.1] - 2021-01-04

### Fixed

- Buy box spacing

## [4.3.0] - 2021-01-04

### Added

- New `store-newsletter` blocks

### Removed

- Old `newsletter` block

## [4.2.0] - 2021-01-04

### Added

- Opens minicart when items are added

### Fixed

- Some z-indexes overlaping

## [4.1.0] - 2020-12-23

### Added

- Custom pages

## [4.0.0] - 2020-12-22

### Added

- Wordpress Integration

### Changed

- Shop By Category icons

### Fixed

- Fullbanner mobile

## [3.9.9] - 2020-12-21

### Fixes

- Full banner width
- Blog SEO text overflow

## [3.9.8] - 2020-12-21

### Changed

- `product-summary-buy-button` to `add-to-cart-button`
- Minicart `product-name` interface

## [3.9.7] - 2020-12-21

### Fixed

- Fix search page content stretch

## [3.9.6] - 2020-12-17

### Fixed

- Quickorder page spacing

## [3.9.5] - 2020-12-17

### Fixed

- Buybox z-index
- Rename `specificationGroups` to "Product especification"
- `telemarketing` block background

## [3.9.4] - 2020-12-16

### Removed

- Removed seller component from product detail page

## [3.9.3] - 2020-12-16

## [3.9.2] - 2020-12-11

### Fix

- Category page margins

## [3.9.1] - 2020-12-11

### Fixed

- Header width

## [3.9.0] - 2020-12-10

### Added

- Product specification bullet list

## [3.8.0] - 2020-11-25

### Added

- `link-seller` and `seller-name` blocks and styles

## [3.7.0] - 2020-11-25

### Added

- Added `Shopper Locator`
- Added Sellers Page
- Added Fake Currency Selector on Footer

## [3.6.0] - 2020-11-19

### Added

- Shipping options modal

## [3.5.0] - 2020-11-17

### Added

- `selectorType` dropdown to `product-quantity`

## [3.4.0] - 2020-11-13

### Added

- Price with taxes

## [3.3.0] - 2020-11-12

### Added

- Product customizer assembly options blocks

## [3.2.0] - 2020-11-12

### Added

- OrderQuote link

### Fix

- Sliders behaviors
- Login render on mobile

## [3.1.0] - 2020-11-12

### Added

- Sku List & Conditional Layout

## [3.0.0] - 2020-11-11

### Added

- Telemarketing
- Orderquote

## [2.6.0] - 2020-11-11

### Added

- Responsive product page
- B2B colour pattern
- Sticky button to edge of page
- Carousel on product page

## [2.5.0] - 2020-11-10

### Added

- Biggy Search missing blocks
- Search summary style

## [2.4.2] - 2020-11-10

### Added

- Locale Switcher into menu drawer

## [2.4.1] - 2020-11-09

### Fixed

- Fixed Carousel Behavior

## [2.4.0] - 2020-11-09

### Added

- Auth Challenges blocks
- vtex.auth-challenge

## [2.3.1] - 2020-11-05

### Added

- Added Savings

## [2.3.0] - 2020-11-03

### Added

- Store Form
- Redirect Page for not allowed users

## [2.2.0] - 2020-11-03

### Added

- Quickorder components and its related files

## [2.1.0] - 2020-10-27

### Fixed

- General Issues

### Added

- Product Quickview
- Shopper Location

### Removed

- Product Comparison interface from summaries in Home Page since it won't work

## [2.0.0] - 2020-10-26

### Added

- Product page styles

## [1.1.0] - 2020-10-26

### Fixed

- Footer CTAs structure
- Checkboxes border colors

### Added

- Product Comparison Page, blocks, interfaces and routes.
- vtex.store-video
- vtex.store-icons
- Departament Page

## [1.0.0] - 2020-10-20

### Added

- vtex.checkout-summary
- vtex.product-availability
- vtex.product-list
- vtex.store-icons
- vtex.wish-list
- vtex.reviews-and-ratings
- vtex.quickorder

## [0.0.0] - 2020-10-15

### Added

- Dotfiles
- Project bootstrap
