# Class `tensorflow::TensorShapeUtils` <a class="md-anchor" id="AUTOGENERATED-class--tensorflow--tensorshapeutils-"></a>

Static helper routines for TensorShape . Includes a few common predicates on a tensor shape.



##Member Summary <a class="md-anchor" id="AUTOGENERATED-member-summary"></a>

* [`static bool tensorflow::TensorShapeUtils::IsScalar(const TensorShape &shape)`](#static_bool_tensorflow_TensorShapeUtils_IsScalar)
* [`static bool tensorflow::TensorShapeUtils::IsVector(const TensorShape &shape)`](#static_bool_tensorflow_TensorShapeUtils_IsVector)
* [`static bool tensorflow::TensorShapeUtils::IsLegacyScalar(const TensorShape &shape)`](#static_bool_tensorflow_TensorShapeUtils_IsLegacyScalar)
* [`static bool tensorflow::TensorShapeUtils::IsLegacyVector(const TensorShape &shape)`](#static_bool_tensorflow_TensorShapeUtils_IsLegacyVector)
* [`static bool tensorflow::TensorShapeUtils::IsVectorOrHigher(const TensorShape &shape)`](#static_bool_tensorflow_TensorShapeUtils_IsVectorOrHigher)
* [`static bool tensorflow::TensorShapeUtils::IsMatrix(const TensorShape &shape)`](#static_bool_tensorflow_TensorShapeUtils_IsMatrix)
* [`static bool tensorflow::TensorShapeUtils::IsMatrixOrHigher(const TensorShape &shape)`](#static_bool_tensorflow_TensorShapeUtils_IsMatrixOrHigher)
* [`static TensorShape tensorflow::TensorShapeUtils::MakeShape(const T *dims, int n)`](#static_TensorShape_tensorflow_TensorShapeUtils_MakeShape)
  * Returns a TensorShape whose dimensions are dims[0], dims[1], ..., dims[n-1].
* [`static string tensorflow::TensorShapeUtils::ShapeListString(const gtl::ArraySlice< TensorShape > &shapes)`](#static_string_tensorflow_TensorShapeUtils_ShapeListString)
* [`static bool tensorflow::TensorShapeUtils::StartsWith(const TensorShape &shape0, const TensorShape &shape1)`](#static_bool_tensorflow_TensorShapeUtils_StartsWith)

##Member Details <a class="md-anchor" id="AUTOGENERATED-member-details"></a>

#### `static bool tensorflow::TensorShapeUtils::IsScalar(const TensorShape &shape)` <a class="md-anchor" id="static_bool_tensorflow_TensorShapeUtils_IsScalar"></a>





#### `static bool tensorflow::TensorShapeUtils::IsVector(const TensorShape &shape)` <a class="md-anchor" id="static_bool_tensorflow_TensorShapeUtils_IsVector"></a>





#### `static bool tensorflow::TensorShapeUtils::IsLegacyScalar(const TensorShape &shape)` <a class="md-anchor" id="static_bool_tensorflow_TensorShapeUtils_IsLegacyScalar"></a>





#### `static bool tensorflow::TensorShapeUtils::IsLegacyVector(const TensorShape &shape)` <a class="md-anchor" id="static_bool_tensorflow_TensorShapeUtils_IsLegacyVector"></a>





#### `static bool tensorflow::TensorShapeUtils::IsVectorOrHigher(const TensorShape &shape)` <a class="md-anchor" id="static_bool_tensorflow_TensorShapeUtils_IsVectorOrHigher"></a>





#### `static bool tensorflow::TensorShapeUtils::IsMatrix(const TensorShape &shape)` <a class="md-anchor" id="static_bool_tensorflow_TensorShapeUtils_IsMatrix"></a>





#### `static bool tensorflow::TensorShapeUtils::IsMatrixOrHigher(const TensorShape &shape)` <a class="md-anchor" id="static_bool_tensorflow_TensorShapeUtils_IsMatrixOrHigher"></a>





#### `static TensorShape tensorflow::TensorShapeUtils::MakeShape(const T *dims, int n)` <a class="md-anchor" id="static_TensorShape_tensorflow_TensorShapeUtils_MakeShape"></a>

Returns a TensorShape whose dimensions are dims[0], dims[1], ..., dims[n-1].



#### `static string tensorflow::TensorShapeUtils::ShapeListString(const gtl::ArraySlice< TensorShape > &shapes)` <a class="md-anchor" id="static_string_tensorflow_TensorShapeUtils_ShapeListString"></a>





#### `static bool tensorflow::TensorShapeUtils::StartsWith(const TensorShape &shape0, const TensorShape &shape1)` <a class="md-anchor" id="static_bool_tensorflow_TensorShapeUtils_StartsWith"></a>




