<?php

/***************************************************************
 *  Copyright notice
 *
 *  (c) 2013 AOE GmbH <dev@aoe.com>
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * @package FeatureFlag
 * @subpackage Tests_Domain_Repository
 * @author Kevin Schu <kevin.schu@aoe.com>
 */
class Tx_FeatureFlag_Domain_Repository_FeatureFlagTest extends Tx_FeatureFlag_Tests_BaseTest
{
    /**
     * @var Tx_FeatureFlag_Domain_Repository_FeatureFlag
     */
    private $featureFlag;

    /**
     * (non-PHPdoc)
     * @see PHPUnit_Framework_TestCase::setUp()
     */
    protected function setUp()
    {
        $sqlFactory = $this->getMock(
            'Tx_FeatureFlag_System_Db_SqlFactory',
            array('getSelectStatementForContentElements', 'getUpdateStatementForContentElements')
        );
        $sqlFactory->expects($this->exactly(4))->method('getSelectStatementForContentElements');

        $mockQuerySettings = $this->getMock('Tx_Extbase_Persistence_Typo3QuerySettings');
        $mockQuerySettings->expects($this->any())->method('setIgnoreEnableFields')->will($this->returnValue($mockQuerySettings));
        $mockQuerySettings->expects($this->any())->method('setIncludeDeleted')->will($this->returnValue($mockQuerySettings));

        $mockQuery = $this->getMock('Tx_Extbase_Persistence_Query', array('execute', 'getQuerySettings'));
        $mockQuery->expects($this->any())->method('execute')->will($this->returnValue(array()));
        $mockQuery->expects($this->any())->method('getQuerySettings')->will($this->returnValue($mockQuerySettings));
        $this->inject($mockQuery, 'qomFactory', $this->getMock('Tx_Extbase_Persistence_QOM_QueryObjectModelFactory'));

        $mockPersistenceManager = $this->getMock('\TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager', array('createQueryForType'));
        $mockPersistenceManager->expects($this->any())->method('createQueryForType')->will($this->returnValue($mockQuery));

        $mockObjectManager = $this->getMock('Tx_Extbase_Object_ObjectManager', array('get'));

        $this->featureFlag = new Tx_FeatureFlag_Domain_Repository_FeatureFlag($mockObjectManager);
        $this->inject($this->featureFlag, 'persistenceManager', $mockPersistenceManager);
        $this->inject($this->featureFlag, 'sqlFactory', $sqlFactory);
    }

    /**
     * (non-PHPdoc)
     * @see PHPUnit_Framework_TestCase::tearDown()
     */
    protected function tearDown()
    {
        unset($this->featureFlag);
    }

    /**
     * @test
     */
    public function factoryShouldBeCalled()
    {
        $this->featureFlag->updateFeatureFlagStatusForTable('my_table');
    }
}