---
template: overrides/main.html
---

# Minification 

The [mkdocs-minify-plugin][1] will minify all `*.html` files generated by
`mkdocs build` in a post-processing step, stripping all unnecessary characters
to reduce the payload served to the client.

!!! success "Bundled with the official Docker image"

    This plugin is already installed for your convenience when you use the
    official [Docker image][2], so the installation step can be skipped. Read
    the [getting started guide][3] to get up and running with Docker.

  [1]: https://github.com/byrnereese/mkdocs-minify-plugin
  [2]: https://hub.docker.com/r/squidfunk/mkdocs-material/
  [3]: ../getting-started.md#with-docker-recommended

## Installation

Install the plugin using `pip`:

``` sh
pip install mkdocs-minify-plugin
```

## Configuration

Add the following lines to `mkdocs.yml`:

``` yaml
plugins:
  - search # necessary for search to work
  - minify:
      minify_html: true
```

## Usage

When enabled, all `*.html` will be minified automatically.
