<p align="center">
  <a href="https://squidfunk.github.io/mkdocs-material">
    <img src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/logo.png" width="320" alt="Material for MkDocs">
  </a>
</p>

<p align="center">
  <strong>
    A 
    <a href="https://material.io/">Material Design</a> 
    theme for 
    <a href="https://www.mkdocs.org/">MkDocs</a>
  </strong>
</p>

<p align="center">
  <a href="https://github.com/squidfunk/mkdocs-material/actions">
    <img
      src="https://github.com/squidfunk/mkdocs-material/workflows/ci/badge.svg?branch=master"
      alt="GitHub Action"
    />
  </a>
  <a href="https://pypistats.org/packages/mkdocs-material">
    <img
      src="https://img.shields.io/pypi/dm/mkdocs-material.svg" 
      alt="Downloads"
    />
  </a>
  <a href="https://gitter.im/squidfunk/mkdocs-material">
    <img 
      src="https://badges.gitter.im/squidfunk/mkdocs-material.svg" 
      alt="Chat on Gitter"
    />
  </a>
  <a href="https://pypi.org/project/mkdocs-material">
    <img 
      src="https://img.shields.io/pypi/v/mkdocs-material.svg" 
      alt="Python Package Index"
    />
  </a>
  <a href="https://amzn.to/353WRpj">
    <img src="https://img.shields.io/static/v1?label=amazon&message=wish%20list&color=orange" />
  </a>
</p>

<p align="center">
  Create a branded static site from a set of Markdown files to host the
  documentation of your Open Source or commercial project – customizable,
  searchable, mobile-friendly, 40+ languages. Set up in 5 minutes.
</p>

<p align="center">
  <a href="https://squidfunk.github.io/mkdocs-material/getting-started/">
    <img src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/screenshot.png" width=700 />
  </a>
</p>

<p align="center">
  <em>
    A demo is worth a thousand words — check it out at
    <a
      href="https://squidfunk.github.io/mkdocs-material/"
    >squidfunk.github.io/mkdocs-material</a>.
  </em>
</p>

## Features

* **It's just Markdown** — write your technical documentation in plain Markdown
  – no need to know HTML, JavaScript, or CSS. Material for MkDocs will do the
  heavy lifting and convert your writing to a beautiful and functional website.

* **Responsive by design** — built from the ground up to work on all sorts of 
  devices – from mobile phones to widescreens. The underlying fluid layout will 
  always adapt perfectly to the available screen space.

* **Static, yet searchable** — almost magically, your technical documentation 
  website will be searchable without any further ado. Material for MkDocs comes
  with built-in search – no server needed – that will instantly answer your
  users' queries.

* **Many configuration options** — change the color palette, font families, 
  language, icons, favicon and logo. Add a source repository link, links to your
  social profiles, Google Analytics and Disqus - all with a few lines of code.

* **Truly international** — thanks to many contributors, Material for MkDocs 
  includes translations for more than 40 languages and offers full native RTL 
  (right-to-left) support for languages such as Arabic, Persian (Farsi) and
  Hebrew.

* **Accessible** — Material for MkDocs provides extensible keyboard navigation
  and semantic markup including role attributes and landmarks. Furthermore, the
  layout is entirely based on `rem` values, respecting the user's default font
  size.

* **Beyond GitHub Markdown** — integrates natively with Python Markdown
  Extensions, offering additional elements like callouts, tabbed content
  containers, mathematical formulas, critic markup, task lists, and emojis.

* **Modern architecture** — Material for MkDocs's underlying codebase is built
  with TypeScript, RxJS, and SCSS, and is compiled with Webpack, bringing
  excellent possibilities for theme extension and customization.

## Quick start

Material for MkDocs can be installed with `pip`:

``` sh
pip install mkdocs-material
```

Add the following line to `mkdocs.yml`:

``` yaml
theme:
  name: material
```

For other installation methods, configuration options, and a demo, visit
[squidfunk.github.io/mkdocs-material][1]

  [1]: https://squidfunk.github.io/mkdocs-material/

## Users

* **Companies** — 
  [Amazon Web Services](https://awssecworkshops.com/),
  [ING Bank](https://ing-bank.github.io/baker/),
  [Netflix](https://netflix.github.io/titus/),
  [Uber](https://uber.github.io/ludwig/getting_started/),
  [SAP](https://sap.github.io/ui5-tooling/),
  [Sipgate](https://developer.sipgate.io/),
  [Spotify](https://spotify.github.io/mkdocs-monorepo-plugin/),
  [Square](https://square.github.io/okhttp/),
  [Zalando](https://opensource.zalando.com/skipper/)

* **Open Source** —
  [AutoKeras](https://autokeras.com/),
  [FastAPI](https://fastapi.tiangolo.com/),
  [OpenFaaS](https://docs.openfaas.com/),
  [Pi-Hole](https://docs.pi-hole.net/),
  [Pydantic](https://pydantic-docs.helpmanual.io/),
  [Traefik](https://docs.traefik.io/),
  [Vapor](https://docs.vapor.codes/),
  [ZeroNet](https://zeronet.io/docs/)

## License

**MIT License**

Copyright (c) 2016-2020 Martin Donath

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.
