"use client";

import { useTheme } from "next-themes";
import { useEffect, useState } from "react";
import { sizingString } from "./sizing-string";

export const RemoteCachingGraphic = () => {
  const { resolvedTheme } = useTheme();

  const [mounted, setMounted] = useState(false);

  useEffect(() => {
    setMounted(true);
  }, []);

  if (!mounted) return <div className={sizingString}></div>;

  if (resolvedTheme === "dark") {
    return <RemoteCachingDark />;
  }
  return <RemoteCachingLight />;
};

const RemoteCachingDark = () => {
  return (
    <div className={sizingString}>
      <svg
        className={sizingString}
        viewBox="0 0 307 200"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <mask
          id="mask0_17_1176"
          style={{ maskType: "alpha" }}
          maskUnits="userSpaceOnUse"
          x="0"
          y="0"
          width="307"
          height="200"
        >
          <rect width="307" height="200" fill="#0A0A0A" />
        </mask>
        <g mask="url(#mask0_17_1176)">
          <circle
            cx="153.5"
            cy="49.5"
            r="42"
            stroke="white"
            strokeOpacity="0.066"
          />
          <path d="M154 131.5L154.5 44" stroke="#8657A7" strokeWidth="2" />
          <g filter="url(#filter0_d_17_1176)">
            <path
              d="M136 46C136 39.3726 141.373 34 148 34H160C166.627 34 172 39.3726 172 46V58C172 64.6274 166.627 70 160 70H148C141.373 70 136 64.6274 136 58V46Z"
              fill="black"
            />
            <path
              d="M160 33.5C166.904 33.5 172.5 39.0964 172.5 46V58C172.5 64.9036 166.904 70.5 160 70.5H148C141.096 70.5 135.5 64.9036 135.5 58V46C135.5 39.0964 141.096 33.5 148 33.5H160Z"
              stroke="white"
              strokeOpacity="0.145"
            />
            <path
              d="M159 52.5C160.381 52.5 161.5 53.6193 161.5 55V56.5C161.5 57.8807 160.381 59 159 59H149C147.619 59 146.5 57.8807 146.5 56.5V55C146.5 53.6193 147.619 52.5 149 52.5H159ZM149 54C148.448 54 148 54.4477 148 55V56.5C148 57.0523 148.448 57.5 149 57.5H159C159.552 57.5 160 57.0523 160 56.5V55C160 54.4477 159.552 54 159 54H149ZM159 45C160.381 45 161.5 46.1193 161.5 47.5V49C161.5 50.3807 160.381 51.5 159 51.5H149C147.619 51.5 146.5 50.3807 146.5 49V47.5C146.5 46.1193 147.619 45 149 45H159ZM149 46.5C148.448 46.5 148 46.9477 148 47.5V49C148 49.5523 148.448 50 149 50H159C159.552 50 160 49.5523 160 49V47.5C160 46.9477 159.552 46.5 159 46.5H149ZM150.25 47.5C150.664 47.5 151 47.8358 151 48.25C151 48.6642 150.664 49 150.25 49C149.836 49 149.5 48.6642 149.5 48.25C149.5 47.8358 149.836 47.5 150.25 47.5ZM152.75 47.5C153.164 47.5 153.5 47.8358 153.5 48.25C153.5 48.6642 153.164 49 152.75 49C152.336 49 152 48.6642 152 48.25C152 47.8358 152.336 47.5 152.75 47.5Z"
              fill="#A0A0A0"
            />
          </g>
          <path
            d="M158 92C158 94.2091 156.209 96 154 96C151.791 96 150 94.2091 150 92C150 89.7909 151.791 88 154 88C156.209 88 158 89.7909 158 92Z"
            fill="#0A0A0A"
          />
          <path
            d="M154 87.5C156.485 87.5 158.5 89.5147 158.5 92C158.5 94.4853 156.485 96.5 154 96.5C151.515 96.5 149.5 94.4853 149.5 92C149.5 89.5147 151.515 87.5 154 87.5Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <circle
            opacity="0.7"
            cx="153.5"
            cy="49.5"
            r="71"
            stroke="white"
            strokeOpacity="0.066"
          />
          <circle
            opacity="0.5"
            cx="153.5"
            cy="49.5"
            r="102"
            stroke="white"
            strokeOpacity="0.066"
          />
          <circle
            opacity="0.5"
            cx="153.5"
            cy="49.5"
            r="135"
            stroke="white"
            strokeOpacity="0.066"
          />
        </g>
        <g filter="url(#filter1_d_17_1176)">
          <path
            d="M50 105C50 98.3726 55.3726 93 62 93H246C252.627 93 258 98.3726 258 105V173C258 179.627 252.627 185 246 185H62C55.3726 185 50 179.627 50 173V105Z"
            fill="black"
          />
          <path
            d="M246 92.5C252.904 92.5 258.5 98.0964 258.5 105V173C258.5 179.904 252.904 185.5 246 185.5H62C55.0964 185.5 49.5 179.904 49.5 173V105C49.5 98.0964 55.0964 92.5 62 92.5H246Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <circle cx="66" cy="109" r="4" fill="white" fillOpacity="0.145" />
          <circle cx="78" cy="109" r="4" fill="white" fillOpacity="0.145" />
          <circle cx="90" cy="109" r="4" fill="white" fillOpacity="0.145" />
          <path
            d="M62.696 136.016H65.288V130.664H63.188V129.812H64.196C65.108 129.812 65.504 129.404 65.504 128.48H66.296V136.016H68.684V137H62.696V136.016ZM69.9753 131.024C70.2033 129.44 71.3193 128.288 73.0233 128.288C74.5713 128.288 75.7233 129.32 75.7233 130.712C75.7233 131.936 74.7513 132.788 73.4553 133.58C72.7353 134 71.1033 135.152 71.0673 136.016H75.7833V137H69.8193C69.8193 134.504 71.6073 133.556 73.0953 132.632C74.0193 132.044 74.6673 131.384 74.6673 130.712C74.6673 129.872 73.9953 129.272 73.0233 129.272C71.9673 129.272 71.2593 129.92 71.0313 131.096L69.9753 131.024ZM78.0346 135.104C78.2866 135.8 78.8866 136.208 79.6786 136.208C80.9626 136.208 81.7426 135.092 81.9106 133.064C81.4426 133.844 80.6626 134.276 79.7506 134.276C78.0706 134.276 76.9306 133.064 76.9306 131.312C76.9306 129.464 78.1786 128.288 79.9186 128.288C80.6626 128.288 81.4186 128.564 82.0426 129.188C82.6426 129.836 82.9426 130.892 82.9426 132.236C82.9426 134.78 82.1266 137.192 79.6786 137.192C78.4066 137.192 77.3626 136.484 76.9786 135.176L78.0346 135.104ZM77.9866 131.312C77.9866 132.476 78.7546 133.292 79.8226 133.292C80.9866 133.292 81.8266 132.476 81.8386 131.312C81.8626 130.124 81.0586 129.272 79.8946 129.272C78.7786 129.272 77.9866 130.124 77.9866 131.312ZM95.9533 132.596C95.8093 131.864 95.1133 131.432 94.2973 131.432C93.6133 131.432 93.0013 131.78 93.0013 132.44C93.0013 133.136 93.8053 133.292 94.5373 133.496C95.7493 133.796 96.9853 134.18 96.9853 135.38C96.9853 136.616 95.7733 137.144 94.5133 137.144C93.0493 137.144 91.8613 136.316 91.7653 135.008L92.7853 134.936C92.9053 135.704 93.6133 136.208 94.5133 136.208C95.2213 136.208 95.9533 136.016 95.9533 135.332C95.9533 134.612 95.0413 134.516 94.3573 134.348C93.1813 134.06 91.9693 133.652 91.9693 132.5C91.9693 131.216 93.0973 130.496 94.4053 130.496C95.7253 130.496 96.7333 131.3 96.9373 132.524L95.9533 132.596ZM104.025 137H103.089L103.077 135.932C102.753 136.76 102.009 137.144 101.169 137.144C99.7526 137.144 99.0566 136.076 99.0566 134.732V130.64H100.041V134.432C100.041 135.62 100.437 136.268 101.373 136.268C102.369 136.268 103.041 135.62 103.041 134.432V130.64H104.025V137ZM110.548 132.764C110.404 131.924 109.708 131.432 108.928 131.432C107.752 131.432 107.056 132.332 107.056 133.82C107.056 135.308 107.752 136.208 108.928 136.208C109.744 136.208 110.44 135.668 110.596 134.756L111.628 134.816C111.424 136.256 110.284 137.144 108.928 137.144C107.164 137.144 106.024 135.836 106.024 133.82C106.024 131.804 107.164 130.496 108.928 130.496C110.236 130.496 111.4 131.336 111.58 132.692L110.548 132.764ZM117.743 132.764C117.599 131.924 116.903 131.432 116.123 131.432C114.947 131.432 114.251 132.332 114.251 133.82C114.251 135.308 114.947 136.208 116.123 136.208C116.939 136.208 117.635 135.668 117.791 134.756L118.823 134.816C118.619 136.256 117.479 137.144 116.123 137.144C114.359 137.144 113.219 135.836 113.219 133.82C113.219 131.804 114.359 130.496 116.123 130.496C117.431 130.496 118.595 131.336 118.775 132.692L117.743 132.764ZM120.367 133.82C120.367 131.804 121.507 130.496 123.271 130.496C124.687 130.496 125.923 131.444 126.019 133.688L126.031 134.132H121.411C121.495 135.44 122.167 136.208 123.271 136.208C123.955 136.208 124.591 135.8 124.879 135.128L125.935 135.2C125.562 136.4 124.483 137.144 123.271 137.144C121.507 137.144 120.367 135.836 120.367 133.82ZM121.435 133.256H124.963C124.783 131.912 124.063 131.432 123.271 131.432C122.251 131.432 121.591 132.104 121.435 133.256ZM131.93 132.596C131.786 131.864 131.09 131.432 130.274 131.432C129.59 131.432 128.978 131.78 128.978 132.44C128.978 133.136 129.782 133.292 130.514 133.496C131.726 133.796 132.962 134.18 132.962 135.38C132.962 136.616 131.75 137.144 130.49 137.144C129.026 137.144 127.838 136.316 127.742 135.008L128.762 134.936C128.882 135.704 129.59 136.208 130.49 136.208C131.198 136.208 131.93 136.016 131.93 135.332C131.93 134.612 131.018 134.516 130.334 134.348C129.158 134.06 127.946 133.652 127.946 132.5C127.946 131.216 129.074 130.496 130.382 130.496C131.702 130.496 132.71 131.3 132.914 132.524L131.93 132.596ZM139.125 132.596C138.981 131.864 138.285 131.432 137.469 131.432C136.785 131.432 136.173 131.78 136.173 132.44C136.173 133.136 136.977 133.292 137.709 133.496C138.921 133.796 140.157 134.18 140.157 135.38C140.157 136.616 138.945 137.144 137.685 137.144C136.221 137.144 135.033 136.316 134.937 135.008L135.957 134.936C136.077 135.704 136.785 136.208 137.685 136.208C138.393 136.208 139.125 136.016 139.125 135.332C139.125 134.612 138.213 134.516 137.529 134.348C136.353 134.06 135.141 133.652 135.141 132.5C135.141 131.216 136.269 130.496 137.577 130.496C138.897 130.496 139.905 131.3 140.109 132.524L139.125 132.596ZM143.704 130.208C143.704 129.164 144.244 128.48 145.408 128.48H146.98V129.344H145.408C144.988 129.344 144.688 129.68 144.688 130.208V131H146.908V131.876H144.688V137H143.704V131.876H142.24V131H143.704V130.208ZM154.392 137H153.456L153.444 135.932C153.12 136.76 152.376 137.144 151.536 137.144C150.12 137.144 149.424 136.076 149.424 134.732V130.64H150.408V134.432C150.408 135.62 150.804 136.268 151.74 136.268C152.736 136.268 153.408 135.62 153.408 134.432V130.64H154.392V137ZM156.775 136.124H159.007V130.088C159.007 129.572 158.791 129.344 158.299 129.344H156.787V128.48H158.299C159.379 128.48 159.991 129.056 159.991 130.088V136.124H161.995V137H156.775V136.124ZM177.821 136.016H180.413V130.664H178.313V129.812H179.321C180.233 129.812 180.629 129.404 180.629 128.48H181.421V136.016H183.809V137H177.821V136.016ZM185.1 131.024C185.328 129.44 186.444 128.288 188.148 128.288C189.696 128.288 190.848 129.32 190.848 130.712C190.848 131.936 189.876 132.788 188.58 133.58C187.86 134 186.228 135.152 186.192 136.016H190.908V137H184.944C184.944 134.504 186.732 133.556 188.22 132.632C189.144 132.044 189.792 131.384 189.792 130.712C189.792 129.872 189.12 129.272 188.148 129.272C187.092 129.272 186.384 129.92 186.156 131.096L185.1 131.024ZM193.16 135.104C193.412 135.8 194.012 136.208 194.804 136.208C196.088 136.208 196.868 135.092 197.036 133.064C196.568 133.844 195.788 134.276 194.876 134.276C193.196 134.276 192.056 133.064 192.056 131.312C192.056 129.464 193.304 128.288 195.044 128.288C195.788 128.288 196.544 128.564 197.168 129.188C197.768 129.836 198.068 130.892 198.068 132.236C198.068 134.78 197.252 137.192 194.804 137.192C193.532 137.192 192.488 136.484 192.104 135.176L193.16 135.104ZM193.112 131.312C193.112 132.476 193.88 133.292 194.948 133.292C196.112 133.292 196.952 132.476 196.964 131.312C196.988 130.124 196.184 129.272 195.02 129.272C193.904 129.272 193.112 130.124 193.112 131.312ZM62.696 152.016H65.288V146.664H63.188V145.812H64.196C65.108 145.812 65.504 145.404 65.504 144.48H66.296V152.016H68.684V153H62.696V152.016ZM69.9753 147.024C70.2033 145.44 71.3193 144.288 73.0233 144.288C74.5713 144.288 75.7233 145.32 75.7233 146.712C75.7233 147.936 74.7513 148.788 73.4553 149.58C72.7353 150 71.1033 151.152 71.0673 152.016H75.7833V153H69.8193C69.8193 150.504 71.6073 149.556 73.0953 148.632C74.0193 148.044 74.6673 147.384 74.6673 146.712C74.6673 145.872 73.9953 145.272 73.0233 145.272C71.9673 145.272 71.2593 145.92 71.0313 147.096L69.9753 147.024ZM78.0346 151.104C78.2866 151.8 78.8866 152.208 79.6786 152.208C80.9626 152.208 81.7426 151.092 81.9106 149.064C81.4426 149.844 80.6626 150.276 79.7506 150.276C78.0706 150.276 76.9306 149.064 76.9306 147.312C76.9306 145.464 78.1786 144.288 79.9186 144.288C80.6626 144.288 81.4186 144.564 82.0426 145.188C82.6426 145.836 82.9426 146.892 82.9426 148.236C82.9426 150.78 82.1266 153.192 79.6786 153.192C78.4066 153.192 77.3626 152.484 76.9786 151.176L78.0346 151.104ZM77.9866 147.312C77.9866 148.476 78.7546 149.292 79.8226 149.292C80.9866 149.292 81.8266 148.476 81.8386 147.312C81.8626 146.124 81.0586 145.272 79.8946 145.272C78.7786 145.272 77.9866 146.124 77.9866 147.312ZM96.1573 148.764C96.0133 147.924 95.3173 147.432 94.5373 147.432C93.3613 147.432 92.6653 148.332 92.6653 149.82C92.6653 151.308 93.3613 152.208 94.5373 152.208C95.3533 152.208 96.0493 151.668 96.2053 150.756L97.2373 150.816C97.0333 152.256 95.8933 153.144 94.5373 153.144C92.7733 153.144 91.6333 151.836 91.6333 149.82C91.6333 147.804 92.7733 146.496 94.5373 146.496C95.8453 146.496 97.0093 147.336 97.1893 148.692L96.1573 148.764ZM98.8766 148.512C99.1046 147.312 100.137 146.496 101.457 146.496C102.993 146.496 104.013 147.384 104.013 149.16V151.716C104.013 152.004 104.133 152.124 104.409 152.124H104.673V153H104.349C103.605 153 103.149 152.604 103.041 152.004C102.789 152.604 102.057 153.144 101.037 153.144C99.7766 153.144 98.7686 152.472 98.7686 151.344C98.7686 150.036 99.7526 149.7 101.145 149.424L103.029 149.064C103.017 147.96 102.405 147.432 101.457 147.432C100.665 147.432 100.089 147.912 99.9326 148.596L98.8766 148.512ZM99.8006 151.344C99.8006 151.86 100.233 152.28 101.169 152.268C102.225 152.268 103.053 151.524 103.053 150.276V149.94L101.529 150.204C100.593 150.372 99.8006 150.444 99.8006 151.344ZM110.548 148.764C110.404 147.924 109.708 147.432 108.928 147.432C107.752 147.432 107.056 148.332 107.056 149.82C107.056 151.308 107.752 152.208 108.928 152.208C109.744 152.208 110.44 151.668 110.596 150.756L111.628 150.816C111.424 152.256 110.284 153.144 108.928 153.144C107.164 153.144 106.024 151.836 106.024 149.82C106.024 147.804 107.164 146.496 108.928 146.496C110.236 146.496 111.4 147.336 111.58 148.692L110.548 148.764ZM113.579 144.48H114.563V147.528C114.935 146.82 115.679 146.496 116.471 146.496C117.923 146.496 118.619 147.564 118.619 148.908V153H117.635V149.268C117.635 148.08 117.239 147.432 116.267 147.432C115.235 147.432 114.563 148.08 114.563 149.268V153H113.579V144.48ZM120.367 149.82C120.367 147.804 121.507 146.496 123.271 146.496C124.687 146.496 125.923 147.444 126.019 149.688L126.031 150.132H121.411C121.495 151.44 122.167 152.208 123.271 152.208C123.955 152.208 124.591 151.8 124.879 151.128L125.935 151.2C125.562 152.4 124.483 153.144 123.271 153.144C121.507 153.144 120.367 151.836 120.367 149.82ZM121.435 149.256H124.963C124.783 147.912 124.063 147.432 123.271 147.432C122.251 147.432 121.591 148.104 121.435 149.256ZM132.986 144.48V153H132.098L132.062 152.064C131.702 152.736 131.018 153.144 130.034 153.144C128.198 153.144 127.346 151.584 127.346 149.82C127.346 148.056 128.198 146.496 130.034 146.496C130.97 146.496 131.642 146.856 132.002 147.504V144.48H132.986ZM128.378 149.82C128.378 151.056 128.906 152.208 130.238 152.208C131.534 152.208 132.086 151.032 132.086 149.82C132.086 148.56 131.534 147.396 130.238 147.396C128.906 147.396 128.378 148.548 128.378 149.82ZM65.6 169.192C63.884 169.192 62.588 168.22 62.588 166.66C62.588 165.604 63.212 164.788 64.232 164.38C63.452 164.044 62.996 163.48 62.996 162.628C62.996 161.284 64.136 160.288 65.6 160.288C67.076 160.288 68.204 161.284 68.204 162.628C68.204 163.48 67.748 164.044 66.968 164.38C68 164.8 68.612 165.616 68.612 166.66C68.612 168.22 67.316 169.192 65.6 169.192ZM63.644 166.576C63.644 167.548 64.448 168.208 65.6 168.208C66.752 168.208 67.556 167.548 67.556 166.576C67.556 165.628 66.752 164.968 65.6 164.968C64.448 164.968 63.644 165.628 63.644 166.576ZM64.052 162.628C64.052 163.408 64.688 163.948 65.6 163.948C66.512 163.948 67.148 163.408 67.148 162.628C67.148 161.824 66.512 161.272 65.6 161.272C64.688 161.272 64.052 161.824 64.052 162.628ZM72.7953 169.192C70.9473 169.192 69.7833 167.464 69.7833 164.752C69.7833 162.016 70.9473 160.288 72.7953 160.288C74.6433 160.288 75.8073 162.016 75.8073 164.752C75.8073 167.464 74.6433 169.192 72.7953 169.192ZM70.8273 164.752C70.8273 166.864 71.5953 168.208 72.7953 168.208C73.9953 168.208 74.7633 166.864 74.7633 164.752C74.7633 162.616 73.9953 161.272 72.7953 161.272C71.5953 161.272 70.8273 162.616 70.8273 164.752ZM76.9666 162.64H77.8546L77.8906 163.528C78.1306 162.856 78.5746 162.496 79.2106 162.496C79.7746 162.496 80.0986 162.868 80.3026 163.696C80.5186 162.952 81.0466 162.496 81.6946 162.496C82.6666 162.496 83.0866 163.312 83.0866 165.184V169H82.1026V165.184C82.1026 163.864 81.9226 163.372 81.4186 163.372C80.8546 163.372 80.5186 164.032 80.5186 165.184V169H79.5346V165.184C79.5346 163.888 79.3186 163.372 78.7666 163.372C78.2746 163.372 77.9506 164.032 77.9506 165.184V169H76.9666V162.64ZM88.7579 164.596C88.6139 163.864 87.9179 163.432 87.1019 163.432C86.4179 163.432 85.8059 163.78 85.8059 164.44C85.8059 165.136 86.6099 165.292 87.3419 165.496C88.5539 165.796 89.7899 166.18 89.7899 167.38C89.7899 168.616 88.5779 169.144 87.3179 169.144C85.8539 169.144 84.6659 168.316 84.5699 167.008L85.5899 166.936C85.7099 167.704 86.4179 168.208 87.3179 168.208C88.0259 168.208 88.7579 168.016 88.7579 167.332C88.7579 166.612 87.8459 166.516 87.1619 166.348C85.9859 166.06 84.7739 165.652 84.7739 164.5C84.7739 163.216 85.9019 162.496 87.2099 162.496C88.5299 162.496 89.5379 163.3 89.7419 164.524L88.7579 164.596Z"
            fill="#EDEDED"
          />
          <path
            d="M167.042 137L166.214 138.908H165.614L166.214 137H165.638V135.644H167.03V137H167.042ZM208.498 128.96H209.482V130.64H211.918V131.516H209.482V135.272C209.482 135.8 209.782 136.124 210.31 136.124H211.894V137H210.31C209.038 137 208.498 136.316 208.498 135.26V131.516H206.794V130.64H208.498V128.96ZM216.702 137.144C214.938 137.144 213.798 135.836 213.798 133.82C213.798 131.804 214.938 130.496 216.702 130.496C218.466 130.496 219.606 131.804 219.606 133.82C219.606 135.836 218.466 137.144 216.702 137.144ZM214.83 133.82C214.83 135.308 215.526 136.208 216.702 136.208C217.89 136.208 218.574 135.308 218.574 133.82C218.574 132.332 217.89 131.432 216.702 131.432C215.526 131.432 214.83 132.332 214.83 133.82ZM222.889 128.96H223.873V130.64H226.309V131.516H223.873V135.272C223.873 135.8 224.173 136.124 224.701 136.124H226.285V137H224.701C223.429 137 222.889 136.316 222.889 135.26V131.516H221.185V130.64H222.889V128.96ZM228.392 132.512C228.62 131.312 229.652 130.496 230.972 130.496C232.508 130.496 233.528 131.384 233.528 133.16V135.716C233.528 136.004 233.648 136.124 233.924 136.124H234.188V137H233.864C233.12 137 232.664 136.604 232.556 136.004C232.304 136.604 231.572 137.144 230.552 137.144C229.292 137.144 228.284 136.472 228.284 135.344C228.284 134.036 229.268 133.7 230.66 133.424L232.544 133.064C232.532 131.96 231.92 131.432 230.972 131.432C230.18 131.432 229.604 131.912 229.448 132.596L228.392 132.512ZM229.316 135.344C229.316 135.86 229.748 136.28 230.684 136.268C231.74 136.268 232.568 135.524 232.568 134.276V133.94L231.044 134.204C230.108 134.372 229.316 134.444 229.316 135.344ZM235.924 136.124H238.156V130.088C238.156 129.572 237.94 129.344 237.448 129.344H235.936V128.48H237.448C238.528 128.48 239.14 129.056 239.14 130.088V136.124H241.144V137H235.924V136.124ZM138.261 153L137.433 154.908H136.833L137.433 153H136.857V151.644H138.249V153H138.261ZM149.04 152.016H151.632V146.664H149.532V145.812H150.54C151.452 145.812 151.848 145.404 151.848 144.48H152.64V152.016H155.028V153H149.04V152.016ZM156.319 147.024C156.547 145.44 157.663 144.288 159.367 144.288C160.915 144.288 162.067 145.32 162.067 146.712C162.067 147.936 161.095 148.788 159.799 149.58C159.079 150 157.447 151.152 157.411 152.016H162.127V153H156.163C156.163 150.504 157.951 149.556 159.439 148.632C160.363 148.044 161.011 147.384 161.011 146.712C161.011 145.872 160.339 145.272 159.367 145.272C158.311 145.272 157.603 145.92 157.375 147.096L156.319 147.024ZM164.378 151.104C164.63 151.8 165.23 152.208 166.022 152.208C167.306 152.208 168.086 151.092 168.254 149.064C167.786 149.844 167.006 150.276 166.094 150.276C164.414 150.276 163.274 149.064 163.274 147.312C163.274 145.464 164.522 144.288 166.262 144.288C167.006 144.288 167.762 144.564 168.386 145.188C168.986 145.836 169.286 146.892 169.286 148.236C169.286 150.78 168.47 153.192 166.022 153.192C164.75 153.192 163.706 152.484 163.322 151.176L164.378 151.104ZM164.33 147.312C164.33 148.476 165.098 149.292 166.166 149.292C167.33 149.292 168.17 148.476 168.182 147.312C168.206 146.124 167.402 145.272 166.238 145.272C165.122 145.272 164.33 146.124 164.33 147.312ZM179.717 144.96H180.701V146.64H183.137V147.516H180.701V151.272C180.701 151.8 181.001 152.124 181.529 152.124H183.113V153H181.529C180.257 153 179.717 152.316 179.717 151.26V147.516H178.013V146.64H179.717V144.96ZM187.92 153.144C186.156 153.144 185.016 151.836 185.016 149.82C185.016 147.804 186.156 146.496 187.92 146.496C189.684 146.496 190.824 147.804 190.824 149.82C190.824 151.836 189.684 153.144 187.92 153.144ZM186.048 149.82C186.048 151.308 186.744 152.208 187.92 152.208C189.108 152.208 189.792 151.308 189.792 149.82C189.792 148.332 189.108 147.432 187.92 147.432C186.744 147.432 186.048 148.332 186.048 149.82ZM194.108 144.96H195.092V146.64H197.528V147.516H195.092V151.272C195.092 151.8 195.392 152.124 195.92 152.124H197.504V153H195.92C194.648 153 194.108 152.316 194.108 151.26V147.516H192.404V146.64H194.108V144.96ZM199.611 148.512C199.839 147.312 200.871 146.496 202.191 146.496C203.727 146.496 204.747 147.384 204.747 149.16V151.716C204.747 152.004 204.867 152.124 205.143 152.124H205.407V153H205.083C204.339 153 203.883 152.604 203.775 152.004C203.523 152.604 202.791 153.144 201.771 153.144C200.511 153.144 199.503 152.472 199.503 151.344C199.503 150.036 200.487 149.7 201.879 149.424L203.763 149.064C203.751 147.96 203.139 147.432 202.191 147.432C201.399 147.432 200.823 147.912 200.667 148.596L199.611 148.512ZM200.535 151.344C200.535 151.86 200.967 152.28 201.903 152.268C202.959 152.268 203.787 151.524 203.787 150.276V149.94L202.263 150.204C201.327 150.372 200.535 150.444 200.535 151.344ZM207.142 152.124H209.374V146.088C209.374 145.572 209.158 145.344 208.666 145.344H207.154V144.48H208.666C209.746 144.48 210.358 145.056 210.358 146.088V152.124H212.362V153H207.142V152.124Z"
            fill="#A0A0A0"
          />
          <path
            d="M98.8526 162.22L104.313 164.668V165.904L98.8526 168.352V167.344L103.437 165.292L98.8526 163.228V162.22ZM106.048 162.22L111.508 164.668V165.904L106.048 168.352V167.344L110.632 165.292L106.048 163.228V162.22ZM113.243 162.22L118.703 164.668V165.904L113.243 168.352V167.344L117.827 165.292L113.243 163.228V162.22ZM127.886 160.48H133.106V161.464H128.894V164.344H132.89V165.316H128.894V169H127.886V160.48ZM140.397 166.024C140.397 167.968 139.341 169.192 137.553 169.192C135.765 169.192 134.709 167.968 134.709 166.024V160.468H135.717V166.024C135.717 167.416 136.341 168.208 137.553 168.208C138.777 168.208 139.389 167.416 139.389 166.024V160.468H140.397V166.024ZM142.24 169V160.48H143.248V168.016H147.76V169H142.24ZM149.436 169V160.48H150.444V168.016H154.956V169H149.436ZM169.442 160.48V161.464H166.838V169H165.83V161.464H163.226V160.48H169.442ZM176.374 166.024C176.374 167.968 175.318 169.192 173.53 169.192C171.742 169.192 170.686 167.968 170.686 166.024V160.468H171.694V166.024C171.694 167.416 172.318 168.208 173.53 168.208C174.754 168.208 175.366 167.416 175.366 166.024V160.468H176.374V166.024ZM180.689 160.48C182.489 160.48 183.593 161.464 183.593 163.048C183.593 164.032 182.945 164.8 182.213 165.04C183.005 165.196 183.353 165.628 183.437 166.492L183.677 169H182.657L182.441 166.588C182.369 165.82 181.853 165.556 180.593 165.556H179.021V169H178.013V160.48H180.689ZM179.021 164.572H180.689C181.877 164.572 182.537 164.02 182.537 163.024C182.537 162.028 181.877 161.464 180.689 161.464H179.021V164.572ZM185.268 169V160.48H187.608C189.552 160.48 190.632 161.332 190.632 162.832C190.632 163.744 190.02 164.428 189.108 164.596C190.272 164.752 190.992 165.496 190.992 166.6C190.992 168.076 189.876 169 188.088 169H185.268ZM186.276 168.016H188.088C189.228 168.016 189.936 167.476 189.936 166.6C189.936 165.688 189.264 165.16 188.088 165.16H186.276V168.016ZM186.276 164.176H187.608C188.88 164.176 189.576 163.696 189.576 162.832C189.576 161.956 188.88 161.464 187.608 161.464H186.276V164.176ZM195.116 169.192C193.148 169.192 191.984 167.476 191.984 164.752C191.984 162.004 193.148 160.288 195.116 160.288C197.084 160.288 198.248 162.004 198.248 164.752C198.248 167.476 197.084 169.192 195.116 169.192ZM193.028 164.752C193.028 166.864 193.796 168.208 195.116 168.208C196.436 168.208 197.204 166.864 197.204 164.752C197.204 162.616 196.436 161.272 195.116 161.272C193.796 161.272 193.028 162.616 193.028 164.752Z"
            fill="url(#paint2_linear_17_1176)"
          />
        </g>
        <defs>
          <filter
            id="filter0_d_17_1176"
            x="133"
            y="32"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1176"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1176"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_17_1176"
            x="47"
            y="91"
            width="214"
            height="98"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1176"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1176"
              result="shape"
            />
          </filter>
          <linearGradient
            id="paint0_linear_17_1176"
            x1="154"
            y1="179.692"
            x2="154"
            y2="164.923"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#0A0A0A" />
            <stop offset="1" stopOpacity="0" />
          </linearGradient>
          <linearGradient
            id="paint1_linear_17_1176"
            x1="462"
            y1="51.6923"
            x2="462"
            y2="36.9231"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#0A0A0A" />
            <stop offset="1" stopOpacity="0" />
          </linearGradient>
          <linearGradient
            id="paint2_linear_17_1176"
            x1="203.231"
            y1="166"
            x2="93.5524"
            y2="171.105"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#FF1E56" />
            <stop offset="1" stopColor="#0096FF" />
          </linearGradient>
        </defs>
      </svg>
    </div>
  );
};
const RemoteCachingLight = () => {
  return (
    <div className={sizingString}>
      <svg
        className={sizingString}
        viewBox="0 0 307 200"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <mask
          id="mask0_16_1371"
          style={{ maskType: "alpha" }}
          maskUnits="userSpaceOnUse"
          x="0"
          y="0"
          width="307"
          height="200"
        >
          <rect width="307" height="200" fill="white" />
        </mask>
        <g mask="url(#mask0_16_1371)">
          <circle
            cx="153.5"
            cy="49.5"
            r="42"
            stroke="black"
            strokeOpacity="0.05"
          />
          <path d="M154 131.5L154.5 44" stroke="#8657A7" strokeWidth="2" />
          <g filter="url(#filter0_d_16_1371)">
            <path
              d="M136 46C136 39.3726 141.373 34 148 34H160C166.627 34 172 39.3726 172 46V58C172 64.6274 166.627 70 160 70H148C141.373 70 136 64.6274 136 58V46Z"
              fill="#FAFAFA"
            />
            <path
              d="M160 33.5C166.904 33.5 172.5 39.0964 172.5 46V58C172.5 64.9036 166.904 70.5 160 70.5H148C141.096 70.5 135.5 64.9036 135.5 58V46C135.5 39.0964 141.096 33.5 148 33.5H160Z"
              stroke="black"
              strokeOpacity="0.08"
            />
            <path
              d="M159 52.5C160.381 52.5 161.5 53.6193 161.5 55V56.5C161.5 57.8807 160.381 59 159 59H149C147.619 59 146.5 57.8807 146.5 56.5V55C146.5 53.6193 147.619 52.5 149 52.5H159ZM149 54C148.448 54 148 54.4477 148 55V56.5C148 57.0523 148.448 57.5 149 57.5H159C159.552 57.5 160 57.0523 160 56.5V55C160 54.4477 159.552 54 159 54H149ZM159 45C160.381 45 161.5 46.1193 161.5 47.5V49C161.5 50.3807 160.381 51.5 159 51.5H149C147.619 51.5 146.5 50.3807 146.5 49V47.5C146.5 46.1193 147.619 45 149 45H159ZM149 46.5C148.448 46.5 148 46.9477 148 47.5V49C148 49.5523 148.448 50 149 50H159C159.552 50 160 49.5523 160 49V47.5C160 46.9477 159.552 46.5 159 46.5H149ZM150.25 47.5C150.664 47.5 151 47.8358 151 48.25C151 48.6642 150.664 49 150.25 49C149.836 49 149.5 48.6642 149.5 48.25C149.5 47.8358 149.836 47.5 150.25 47.5ZM152.75 47.5C153.164 47.5 153.5 47.8358 153.5 48.25C153.5 48.6642 153.164 49 152.75 49C152.336 49 152 48.6642 152 48.25C152 47.8358 152.336 47.5 152.75 47.5Z"
              fill="#666666"
            />
          </g>
          <path
            d="M158 92C158 94.2091 156.209 96 154 96C151.791 96 150 94.2091 150 92C150 89.7909 151.791 88 154 88C156.209 88 158 89.7909 158 92Z"
            fill="white"
          />
          <path
            d="M154 87.5C156.485 87.5 158.5 89.5147 158.5 92C158.5 94.4853 156.485 96.5 154 96.5C151.515 96.5 149.5 94.4853 149.5 92C149.5 89.5147 151.515 87.5 154 87.5Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <circle
            opacity="0.7"
            cx="153.5"
            cy="49.5"
            r="71"
            stroke="black"
            strokeOpacity="0.05"
          />
          <circle
            opacity="0.5"
            cx="153.5"
            cy="49.5"
            r="102"
            stroke="black"
            strokeOpacity="0.05"
          />
          <circle
            opacity="0.5"
            cx="153.5"
            cy="49.5"
            r="135"
            stroke="black"
            strokeOpacity="0.05"
          />
        </g>
        <g filter="url(#filter1_d_16_1371)">
          <path
            d="M50 105C50 98.3726 55.3726 93 62 93H246C252.627 93 258 98.3726 258 105V173C258 179.627 252.627 185 246 185H62C55.3726 185 50 179.627 50 173V105Z"
            fill="#FAFAFA"
          />
          <path
            d="M246 92.5C252.904 92.5 258.5 98.0964 258.5 105V173C258.5 179.904 252.904 185.5 246 185.5H62C55.0964 185.5 49.5 179.904 49.5 173V105C49.5 98.0964 55.0964 92.5 62 92.5H246Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <circle cx="66" cy="109" r="4" fill="black" fillOpacity="0.08" />
          <circle cx="78" cy="109" r="4" fill="black" fillOpacity="0.08" />
          <circle cx="90" cy="109" r="4" fill="black" fillOpacity="0.08" />
          <path
            d="M62.696 136.016H65.288V130.664H63.188V129.812H64.196C65.108 129.812 65.504 129.404 65.504 128.48H66.296V136.016H68.684V137H62.696V136.016ZM69.9753 131.024C70.2033 129.44 71.3193 128.288 73.0233 128.288C74.5713 128.288 75.7233 129.32 75.7233 130.712C75.7233 131.936 74.7513 132.788 73.4553 133.58C72.7353 134 71.1033 135.152 71.0673 136.016H75.7833V137H69.8193C69.8193 134.504 71.6073 133.556 73.0953 132.632C74.0193 132.044 74.6673 131.384 74.6673 130.712C74.6673 129.872 73.9953 129.272 73.0233 129.272C71.9673 129.272 71.2593 129.92 71.0313 131.096L69.9753 131.024ZM78.0346 135.104C78.2866 135.8 78.8866 136.208 79.6786 136.208C80.9626 136.208 81.7426 135.092 81.9106 133.064C81.4426 133.844 80.6626 134.276 79.7506 134.276C78.0706 134.276 76.9306 133.064 76.9306 131.312C76.9306 129.464 78.1786 128.288 79.9186 128.288C80.6626 128.288 81.4186 128.564 82.0426 129.188C82.6426 129.836 82.9426 130.892 82.9426 132.236C82.9426 134.78 82.1266 137.192 79.6786 137.192C78.4066 137.192 77.3626 136.484 76.9786 135.176L78.0346 135.104ZM77.9866 131.312C77.9866 132.476 78.7546 133.292 79.8226 133.292C80.9866 133.292 81.8266 132.476 81.8386 131.312C81.8626 130.124 81.0586 129.272 79.8946 129.272C78.7786 129.272 77.9866 130.124 77.9866 131.312ZM95.9533 132.596C95.8093 131.864 95.1133 131.432 94.2973 131.432C93.6133 131.432 93.0013 131.78 93.0013 132.44C93.0013 133.136 93.8053 133.292 94.5373 133.496C95.7493 133.796 96.9853 134.18 96.9853 135.38C96.9853 136.616 95.7733 137.144 94.5133 137.144C93.0493 137.144 91.8613 136.316 91.7653 135.008L92.7853 134.936C92.9053 135.704 93.6133 136.208 94.5133 136.208C95.2213 136.208 95.9533 136.016 95.9533 135.332C95.9533 134.612 95.0413 134.516 94.3573 134.348C93.1813 134.06 91.9693 133.652 91.9693 132.5C91.9693 131.216 93.0973 130.496 94.4053 130.496C95.7253 130.496 96.7333 131.3 96.9373 132.524L95.9533 132.596ZM104.025 137H103.089L103.077 135.932C102.753 136.76 102.009 137.144 101.169 137.144C99.7526 137.144 99.0566 136.076 99.0566 134.732V130.64H100.041V134.432C100.041 135.62 100.437 136.268 101.373 136.268C102.369 136.268 103.041 135.62 103.041 134.432V130.64H104.025V137ZM110.548 132.764C110.404 131.924 109.708 131.432 108.928 131.432C107.752 131.432 107.056 132.332 107.056 133.82C107.056 135.308 107.752 136.208 108.928 136.208C109.744 136.208 110.44 135.668 110.596 134.756L111.628 134.816C111.424 136.256 110.284 137.144 108.928 137.144C107.164 137.144 106.024 135.836 106.024 133.82C106.024 131.804 107.164 130.496 108.928 130.496C110.236 130.496 111.4 131.336 111.58 132.692L110.548 132.764ZM117.743 132.764C117.599 131.924 116.903 131.432 116.123 131.432C114.947 131.432 114.251 132.332 114.251 133.82C114.251 135.308 114.947 136.208 116.123 136.208C116.939 136.208 117.635 135.668 117.791 134.756L118.823 134.816C118.619 136.256 117.479 137.144 116.123 137.144C114.359 137.144 113.219 135.836 113.219 133.82C113.219 131.804 114.359 130.496 116.123 130.496C117.431 130.496 118.595 131.336 118.775 132.692L117.743 132.764ZM120.367 133.82C120.367 131.804 121.507 130.496 123.271 130.496C124.687 130.496 125.923 131.444 126.019 133.688L126.031 134.132H121.411C121.495 135.44 122.167 136.208 123.271 136.208C123.955 136.208 124.591 135.8 124.879 135.128L125.935 135.2C125.562 136.4 124.483 137.144 123.271 137.144C121.507 137.144 120.367 135.836 120.367 133.82ZM121.435 133.256H124.963C124.783 131.912 124.063 131.432 123.271 131.432C122.251 131.432 121.591 132.104 121.435 133.256ZM131.93 132.596C131.786 131.864 131.09 131.432 130.274 131.432C129.59 131.432 128.978 131.78 128.978 132.44C128.978 133.136 129.782 133.292 130.514 133.496C131.726 133.796 132.962 134.18 132.962 135.38C132.962 136.616 131.75 137.144 130.49 137.144C129.026 137.144 127.838 136.316 127.742 135.008L128.762 134.936C128.882 135.704 129.59 136.208 130.49 136.208C131.198 136.208 131.93 136.016 131.93 135.332C131.93 134.612 131.018 134.516 130.334 134.348C129.158 134.06 127.946 133.652 127.946 132.5C127.946 131.216 129.074 130.496 130.382 130.496C131.702 130.496 132.71 131.3 132.914 132.524L131.93 132.596ZM139.125 132.596C138.981 131.864 138.285 131.432 137.469 131.432C136.785 131.432 136.173 131.78 136.173 132.44C136.173 133.136 136.977 133.292 137.709 133.496C138.921 133.796 140.157 134.18 140.157 135.38C140.157 136.616 138.945 137.144 137.685 137.144C136.221 137.144 135.033 136.316 134.937 135.008L135.957 134.936C136.077 135.704 136.785 136.208 137.685 136.208C138.393 136.208 139.125 136.016 139.125 135.332C139.125 134.612 138.213 134.516 137.529 134.348C136.353 134.06 135.141 133.652 135.141 132.5C135.141 131.216 136.269 130.496 137.577 130.496C138.897 130.496 139.905 131.3 140.109 132.524L139.125 132.596ZM143.704 130.208C143.704 129.164 144.244 128.48 145.408 128.48H146.98V129.344H145.408C144.988 129.344 144.688 129.68 144.688 130.208V131H146.908V131.876H144.688V137H143.704V131.876H142.24V131H143.704V130.208ZM154.392 137H153.456L153.444 135.932C153.12 136.76 152.376 137.144 151.536 137.144C150.12 137.144 149.424 136.076 149.424 134.732V130.64H150.408V134.432C150.408 135.62 150.804 136.268 151.74 136.268C152.736 136.268 153.408 135.62 153.408 134.432V130.64H154.392V137ZM156.775 136.124H159.007V130.088C159.007 129.572 158.791 129.344 158.299 129.344H156.787V128.48H158.299C159.379 128.48 159.991 129.056 159.991 130.088V136.124H161.995V137H156.775V136.124ZM177.821 136.016H180.413V130.664H178.313V129.812H179.321C180.233 129.812 180.629 129.404 180.629 128.48H181.421V136.016H183.809V137H177.821V136.016ZM185.1 131.024C185.328 129.44 186.444 128.288 188.148 128.288C189.696 128.288 190.848 129.32 190.848 130.712C190.848 131.936 189.876 132.788 188.58 133.58C187.86 134 186.228 135.152 186.192 136.016H190.908V137H184.944C184.944 134.504 186.732 133.556 188.22 132.632C189.144 132.044 189.792 131.384 189.792 130.712C189.792 129.872 189.12 129.272 188.148 129.272C187.092 129.272 186.384 129.92 186.156 131.096L185.1 131.024ZM193.16 135.104C193.412 135.8 194.012 136.208 194.804 136.208C196.088 136.208 196.868 135.092 197.036 133.064C196.568 133.844 195.788 134.276 194.876 134.276C193.196 134.276 192.056 133.064 192.056 131.312C192.056 129.464 193.304 128.288 195.044 128.288C195.788 128.288 196.544 128.564 197.168 129.188C197.768 129.836 198.068 130.892 198.068 132.236C198.068 134.78 197.252 137.192 194.804 137.192C193.532 137.192 192.488 136.484 192.104 135.176L193.16 135.104ZM193.112 131.312C193.112 132.476 193.88 133.292 194.948 133.292C196.112 133.292 196.952 132.476 196.964 131.312C196.988 130.124 196.184 129.272 195.02 129.272C193.904 129.272 193.112 130.124 193.112 131.312ZM62.696 152.016H65.288V146.664H63.188V145.812H64.196C65.108 145.812 65.504 145.404 65.504 144.48H66.296V152.016H68.684V153H62.696V152.016ZM69.9753 147.024C70.2033 145.44 71.3193 144.288 73.0233 144.288C74.5713 144.288 75.7233 145.32 75.7233 146.712C75.7233 147.936 74.7513 148.788 73.4553 149.58C72.7353 150 71.1033 151.152 71.0673 152.016H75.7833V153H69.8193C69.8193 150.504 71.6073 149.556 73.0953 148.632C74.0193 148.044 74.6673 147.384 74.6673 146.712C74.6673 145.872 73.9953 145.272 73.0233 145.272C71.9673 145.272 71.2593 145.92 71.0313 147.096L69.9753 147.024ZM78.0346 151.104C78.2866 151.8 78.8866 152.208 79.6786 152.208C80.9626 152.208 81.7426 151.092 81.9106 149.064C81.4426 149.844 80.6626 150.276 79.7506 150.276C78.0706 150.276 76.9306 149.064 76.9306 147.312C76.9306 145.464 78.1786 144.288 79.9186 144.288C80.6626 144.288 81.4186 144.564 82.0426 145.188C82.6426 145.836 82.9426 146.892 82.9426 148.236C82.9426 150.78 82.1266 153.192 79.6786 153.192C78.4066 153.192 77.3626 152.484 76.9786 151.176L78.0346 151.104ZM77.9866 147.312C77.9866 148.476 78.7546 149.292 79.8226 149.292C80.9866 149.292 81.8266 148.476 81.8386 147.312C81.8626 146.124 81.0586 145.272 79.8946 145.272C78.7786 145.272 77.9866 146.124 77.9866 147.312ZM96.1573 148.764C96.0133 147.924 95.3173 147.432 94.5373 147.432C93.3613 147.432 92.6653 148.332 92.6653 149.82C92.6653 151.308 93.3613 152.208 94.5373 152.208C95.3533 152.208 96.0493 151.668 96.2053 150.756L97.2373 150.816C97.0333 152.256 95.8933 153.144 94.5373 153.144C92.7733 153.144 91.6333 151.836 91.6333 149.82C91.6333 147.804 92.7733 146.496 94.5373 146.496C95.8453 146.496 97.0093 147.336 97.1893 148.692L96.1573 148.764ZM98.8766 148.512C99.1046 147.312 100.137 146.496 101.457 146.496C102.993 146.496 104.013 147.384 104.013 149.16V151.716C104.013 152.004 104.133 152.124 104.409 152.124H104.673V153H104.349C103.605 153 103.149 152.604 103.041 152.004C102.789 152.604 102.057 153.144 101.037 153.144C99.7766 153.144 98.7686 152.472 98.7686 151.344C98.7686 150.036 99.7526 149.7 101.145 149.424L103.029 149.064C103.017 147.96 102.405 147.432 101.457 147.432C100.665 147.432 100.089 147.912 99.9326 148.596L98.8766 148.512ZM99.8006 151.344C99.8006 151.86 100.233 152.28 101.169 152.268C102.225 152.268 103.053 151.524 103.053 150.276V149.94L101.529 150.204C100.593 150.372 99.8006 150.444 99.8006 151.344ZM110.548 148.764C110.404 147.924 109.708 147.432 108.928 147.432C107.752 147.432 107.056 148.332 107.056 149.82C107.056 151.308 107.752 152.208 108.928 152.208C109.744 152.208 110.44 151.668 110.596 150.756L111.628 150.816C111.424 152.256 110.284 153.144 108.928 153.144C107.164 153.144 106.024 151.836 106.024 149.82C106.024 147.804 107.164 146.496 108.928 146.496C110.236 146.496 111.4 147.336 111.58 148.692L110.548 148.764ZM113.579 144.48H114.563V147.528C114.935 146.82 115.679 146.496 116.471 146.496C117.923 146.496 118.619 147.564 118.619 148.908V153H117.635V149.268C117.635 148.08 117.239 147.432 116.267 147.432C115.235 147.432 114.563 148.08 114.563 149.268V153H113.579V144.48ZM120.367 149.82C120.367 147.804 121.507 146.496 123.271 146.496C124.687 146.496 125.923 147.444 126.019 149.688L126.031 150.132H121.411C121.495 151.44 122.167 152.208 123.271 152.208C123.955 152.208 124.591 151.8 124.879 151.128L125.935 151.2C125.562 152.4 124.483 153.144 123.271 153.144C121.507 153.144 120.367 151.836 120.367 149.82ZM121.435 149.256H124.963C124.783 147.912 124.063 147.432 123.271 147.432C122.251 147.432 121.591 148.104 121.435 149.256ZM132.986 144.48V153H132.098L132.062 152.064C131.702 152.736 131.018 153.144 130.034 153.144C128.198 153.144 127.346 151.584 127.346 149.82C127.346 148.056 128.198 146.496 130.034 146.496C130.97 146.496 131.642 146.856 132.002 147.504V144.48H132.986ZM128.378 149.82C128.378 151.056 128.906 152.208 130.238 152.208C131.534 152.208 132.086 151.032 132.086 149.82C132.086 148.56 131.534 147.396 130.238 147.396C128.906 147.396 128.378 148.548 128.378 149.82ZM65.6 169.192C63.884 169.192 62.588 168.22 62.588 166.66C62.588 165.604 63.212 164.788 64.232 164.38C63.452 164.044 62.996 163.48 62.996 162.628C62.996 161.284 64.136 160.288 65.6 160.288C67.076 160.288 68.204 161.284 68.204 162.628C68.204 163.48 67.748 164.044 66.968 164.38C68 164.8 68.612 165.616 68.612 166.66C68.612 168.22 67.316 169.192 65.6 169.192ZM63.644 166.576C63.644 167.548 64.448 168.208 65.6 168.208C66.752 168.208 67.556 167.548 67.556 166.576C67.556 165.628 66.752 164.968 65.6 164.968C64.448 164.968 63.644 165.628 63.644 166.576ZM64.052 162.628C64.052 163.408 64.688 163.948 65.6 163.948C66.512 163.948 67.148 163.408 67.148 162.628C67.148 161.824 66.512 161.272 65.6 161.272C64.688 161.272 64.052 161.824 64.052 162.628ZM72.7953 169.192C70.9473 169.192 69.7833 167.464 69.7833 164.752C69.7833 162.016 70.9473 160.288 72.7953 160.288C74.6433 160.288 75.8073 162.016 75.8073 164.752C75.8073 167.464 74.6433 169.192 72.7953 169.192ZM70.8273 164.752C70.8273 166.864 71.5953 168.208 72.7953 168.208C73.9953 168.208 74.7633 166.864 74.7633 164.752C74.7633 162.616 73.9953 161.272 72.7953 161.272C71.5953 161.272 70.8273 162.616 70.8273 164.752ZM76.9666 162.64H77.8546L77.8906 163.528C78.1306 162.856 78.5746 162.496 79.2106 162.496C79.7746 162.496 80.0986 162.868 80.3026 163.696C80.5186 162.952 81.0466 162.496 81.6946 162.496C82.6666 162.496 83.0866 163.312 83.0866 165.184V169H82.1026V165.184C82.1026 163.864 81.9226 163.372 81.4186 163.372C80.8546 163.372 80.5186 164.032 80.5186 165.184V169H79.5346V165.184C79.5346 163.888 79.3186 163.372 78.7666 163.372C78.2746 163.372 77.9506 164.032 77.9506 165.184V169H76.9666V162.64ZM88.7579 164.596C88.6139 163.864 87.9179 163.432 87.1019 163.432C86.4179 163.432 85.8059 163.78 85.8059 164.44C85.8059 165.136 86.6099 165.292 87.3419 165.496C88.5539 165.796 89.7899 166.18 89.7899 167.38C89.7899 168.616 88.5779 169.144 87.3179 169.144C85.8539 169.144 84.6659 168.316 84.5699 167.008L85.5899 166.936C85.7099 167.704 86.4179 168.208 87.3179 168.208C88.0259 168.208 88.7579 168.016 88.7579 167.332C88.7579 166.612 87.8459 166.516 87.1619 166.348C85.9859 166.06 84.7739 165.652 84.7739 164.5C84.7739 163.216 85.9019 162.496 87.2099 162.496C88.5299 162.496 89.5379 163.3 89.7419 164.524L88.7579 164.596Z"
            fill="#171717"
          />
          <path
            d="M167.042 137L166.214 138.908H165.614L166.214 137H165.638V135.644H167.03V137H167.042ZM208.498 128.96H209.482V130.64H211.918V131.516H209.482V135.272C209.482 135.8 209.782 136.124 210.31 136.124H211.894V137H210.31C209.038 137 208.498 136.316 208.498 135.26V131.516H206.794V130.64H208.498V128.96ZM216.702 137.144C214.938 137.144 213.798 135.836 213.798 133.82C213.798 131.804 214.938 130.496 216.702 130.496C218.466 130.496 219.606 131.804 219.606 133.82C219.606 135.836 218.466 137.144 216.702 137.144ZM214.83 133.82C214.83 135.308 215.526 136.208 216.702 136.208C217.89 136.208 218.574 135.308 218.574 133.82C218.574 132.332 217.89 131.432 216.702 131.432C215.526 131.432 214.83 132.332 214.83 133.82ZM222.889 128.96H223.873V130.64H226.309V131.516H223.873V135.272C223.873 135.8 224.173 136.124 224.701 136.124H226.285V137H224.701C223.429 137 222.889 136.316 222.889 135.26V131.516H221.185V130.64H222.889V128.96ZM228.392 132.512C228.62 131.312 229.652 130.496 230.972 130.496C232.508 130.496 233.528 131.384 233.528 133.16V135.716C233.528 136.004 233.648 136.124 233.924 136.124H234.188V137H233.864C233.12 137 232.664 136.604 232.556 136.004C232.304 136.604 231.572 137.144 230.552 137.144C229.292 137.144 228.284 136.472 228.284 135.344C228.284 134.036 229.268 133.7 230.66 133.424L232.544 133.064C232.532 131.96 231.92 131.432 230.972 131.432C230.18 131.432 229.604 131.912 229.448 132.596L228.392 132.512ZM229.316 135.344C229.316 135.86 229.748 136.28 230.684 136.268C231.74 136.268 232.568 135.524 232.568 134.276V133.94L231.044 134.204C230.108 134.372 229.316 134.444 229.316 135.344ZM235.924 136.124H238.156V130.088C238.156 129.572 237.94 129.344 237.448 129.344H235.936V128.48H237.448C238.528 128.48 239.14 129.056 239.14 130.088V136.124H241.144V137H235.924V136.124ZM138.261 153L137.433 154.908H136.833L137.433 153H136.857V151.644H138.249V153H138.261ZM149.04 152.016H151.632V146.664H149.532V145.812H150.54C151.452 145.812 151.848 145.404 151.848 144.48H152.64V152.016H155.028V153H149.04V152.016ZM156.319 147.024C156.547 145.44 157.663 144.288 159.367 144.288C160.915 144.288 162.067 145.32 162.067 146.712C162.067 147.936 161.095 148.788 159.799 149.58C159.079 150 157.447 151.152 157.411 152.016H162.127V153H156.163C156.163 150.504 157.951 149.556 159.439 148.632C160.363 148.044 161.011 147.384 161.011 146.712C161.011 145.872 160.339 145.272 159.367 145.272C158.311 145.272 157.603 145.92 157.375 147.096L156.319 147.024ZM164.378 151.104C164.63 151.8 165.23 152.208 166.022 152.208C167.306 152.208 168.086 151.092 168.254 149.064C167.786 149.844 167.006 150.276 166.094 150.276C164.414 150.276 163.274 149.064 163.274 147.312C163.274 145.464 164.522 144.288 166.262 144.288C167.006 144.288 167.762 144.564 168.386 145.188C168.986 145.836 169.286 146.892 169.286 148.236C169.286 150.78 168.47 153.192 166.022 153.192C164.75 153.192 163.706 152.484 163.322 151.176L164.378 151.104ZM164.33 147.312C164.33 148.476 165.098 149.292 166.166 149.292C167.33 149.292 168.17 148.476 168.182 147.312C168.206 146.124 167.402 145.272 166.238 145.272C165.122 145.272 164.33 146.124 164.33 147.312ZM179.717 144.96H180.701V146.64H183.137V147.516H180.701V151.272C180.701 151.8 181.001 152.124 181.529 152.124H183.113V153H181.529C180.257 153 179.717 152.316 179.717 151.26V147.516H178.013V146.64H179.717V144.96ZM187.92 153.144C186.156 153.144 185.016 151.836 185.016 149.82C185.016 147.804 186.156 146.496 187.92 146.496C189.684 146.496 190.824 147.804 190.824 149.82C190.824 151.836 189.684 153.144 187.92 153.144ZM186.048 149.82C186.048 151.308 186.744 152.208 187.92 152.208C189.108 152.208 189.792 151.308 189.792 149.82C189.792 148.332 189.108 147.432 187.92 147.432C186.744 147.432 186.048 148.332 186.048 149.82ZM194.108 144.96H195.092V146.64H197.528V147.516H195.092V151.272C195.092 151.8 195.392 152.124 195.92 152.124H197.504V153H195.92C194.648 153 194.108 152.316 194.108 151.26V147.516H192.404V146.64H194.108V144.96ZM199.611 148.512C199.839 147.312 200.871 146.496 202.191 146.496C203.727 146.496 204.747 147.384 204.747 149.16V151.716C204.747 152.004 204.867 152.124 205.143 152.124H205.407V153H205.083C204.339 153 203.883 152.604 203.775 152.004C203.523 152.604 202.791 153.144 201.771 153.144C200.511 153.144 199.503 152.472 199.503 151.344C199.503 150.036 200.487 149.7 201.879 149.424L203.763 149.064C203.751 147.96 203.139 147.432 202.191 147.432C201.399 147.432 200.823 147.912 200.667 148.596L199.611 148.512ZM200.535 151.344C200.535 151.86 200.967 152.28 201.903 152.268C202.959 152.268 203.787 151.524 203.787 150.276V149.94L202.263 150.204C201.327 150.372 200.535 150.444 200.535 151.344ZM207.142 152.124H209.374V146.088C209.374 145.572 209.158 145.344 208.666 145.344H207.154V144.48H208.666C209.746 144.48 210.358 145.056 210.358 146.088V152.124H212.362V153H207.142V152.124Z"
            fill="#666666"
          />
          <path
            d="M98.8526 162.22L104.313 164.668V165.904L98.8526 168.352V167.344L103.437 165.292L98.8526 163.228V162.22ZM106.048 162.22L111.508 164.668V165.904L106.048 168.352V167.344L110.632 165.292L106.048 163.228V162.22ZM113.243 162.22L118.703 164.668V165.904L113.243 168.352V167.344L117.827 165.292L113.243 163.228V162.22ZM127.886 160.48H133.106V161.464H128.894V164.344H132.89V165.316H128.894V169H127.886V160.48ZM140.397 166.024C140.397 167.968 139.341 169.192 137.553 169.192C135.765 169.192 134.709 167.968 134.709 166.024V160.468H135.717V166.024C135.717 167.416 136.341 168.208 137.553 168.208C138.777 168.208 139.389 167.416 139.389 166.024V160.468H140.397V166.024ZM142.24 169V160.48H143.248V168.016H147.76V169H142.24ZM149.436 169V160.48H150.444V168.016H154.956V169H149.436ZM169.442 160.48V161.464H166.838V169H165.83V161.464H163.226V160.48H169.442ZM176.374 166.024C176.374 167.968 175.318 169.192 173.53 169.192C171.742 169.192 170.686 167.968 170.686 166.024V160.468H171.694V166.024C171.694 167.416 172.318 168.208 173.53 168.208C174.754 168.208 175.366 167.416 175.366 166.024V160.468H176.374V166.024ZM180.689 160.48C182.489 160.48 183.593 161.464 183.593 163.048C183.593 164.032 182.945 164.8 182.213 165.04C183.005 165.196 183.353 165.628 183.437 166.492L183.677 169H182.657L182.441 166.588C182.369 165.82 181.853 165.556 180.593 165.556H179.021V169H178.013V160.48H180.689ZM179.021 164.572H180.689C181.877 164.572 182.537 164.02 182.537 163.024C182.537 162.028 181.877 161.464 180.689 161.464H179.021V164.572ZM185.268 169V160.48H187.608C189.552 160.48 190.632 161.332 190.632 162.832C190.632 163.744 190.02 164.428 189.108 164.596C190.272 164.752 190.992 165.496 190.992 166.6C190.992 168.076 189.876 169 188.088 169H185.268ZM186.276 168.016H188.088C189.228 168.016 189.936 167.476 189.936 166.6C189.936 165.688 189.264 165.16 188.088 165.16H186.276V168.016ZM186.276 164.176H187.608C188.88 164.176 189.576 163.696 189.576 162.832C189.576 161.956 188.88 161.464 187.608 161.464H186.276V164.176ZM195.116 169.192C193.148 169.192 191.984 167.476 191.984 164.752C191.984 162.004 193.148 160.288 195.116 160.288C197.084 160.288 198.248 162.004 198.248 164.752C198.248 167.476 197.084 169.192 195.116 169.192ZM193.028 164.752C193.028 166.864 193.796 168.208 195.116 168.208C196.436 168.208 197.204 166.864 197.204 164.752C197.204 162.616 196.436 161.272 195.116 161.272C193.796 161.272 193.028 162.616 193.028 164.752Z"
            fill="url(#paint2_linear_16_1371)"
          />
        </g>
        <defs>
          <filter
            id="filter0_d_16_1371"
            x="133"
            y="32"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1371"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1371"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_16_1371"
            x="47"
            y="91"
            width="214"
            height="98"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1371"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1371"
              result="shape"
            />
          </filter>
          <linearGradient
            id="paint0_linear_16_1371"
            x1="154"
            y1="179.692"
            x2="154"
            y2="164.923"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="white" />
            <stop offset="1" stopColor="white" stopOpacity="0" />
          </linearGradient>
          <linearGradient
            id="paint1_linear_16_1371"
            x1="462"
            y1="51.6923"
            x2="462"
            y2="36.9231"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="white" />
            <stop offset="1" stopColor="white" stopOpacity="0" />
          </linearGradient>
          <linearGradient
            id="paint2_linear_16_1371"
            x1="203.231"
            y1="166"
            x2="93.5524"
            y2="171.105"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#FF1E56" />
            <stop offset="1" stopColor="#0096FF" />
          </linearGradient>
        </defs>
      </svg>
    </div>
  );
};
