const { createPreset } = require("fumadocs-ui/tailwind-plugin");

/** @type {import('tailwindcss').Config} */
module.exports = {
  darkMode: ["class"],
  content: [
    "./components/**/*.{ts,tsx}",
    "./app/**/*.{ts,tsx}",
    "./content/**/*.{md,mdx}",
    "./mdx-components.{ts,tsx}",
    "./node_modules/fumadocs-ui/dist/**/*.js",
    "./node_modules/fumadocs-openapi/dist/**/*.js",
  ],
  theme: {
    screens: {
      xs: "400px",
      sm: "640px",
      md: "768px",
      lg: "1024px",
      xl: "1280px",
      "2xl": "1536px",
    },
    colors: {
      transparent: "transparent",
      white: "#fff",
      black: "#000",
      gray: {
        100: "hsla(var(--ds-gray-100-value), <alpha-value>)",
        200: "hsla(var(--ds-gray-200-value), <alpha-value>)",
        300: "hsla(var(--ds-gray-300-value), <alpha-value>)",
        400: "hsla(var(--ds-gray-400-value), <alpha-value>)",
        500: "hsla(var(--ds-gray-500-value), <alpha-value>)",
        600: "hsla(var(--ds-gray-600-value), <alpha-value>)",
        700: "hsla(var(--ds-gray-700-value), <alpha-value>)",
        800: "hsla(var(--ds-gray-800-value), <alpha-value>)",
        900: "hsla(var(--ds-gray-900-value), <alpha-value>)",
        1000: "hsla(var(--ds-gray-1000-value), <alpha-value>)",
        "alpha-100": "var(--ds-gray-alpha-100)",
        "alpha-200": "var(--ds-gray-alpha-200)",
        "alpha-300": "var(--ds-gray-alpha-300)",
        "alpha-400": "var(--ds-gray-alpha-400)",
        "alpha-500": "var(--ds-gray-alpha-500)",
        "alpha-600": "var(--ds-gray-alpha-600)",
        "alpha-700": "var(--ds-gray-alpha-700)",
        "alpha-800": "var(--ds-gray-alpha-800)",
        "alpha-900": "var(--ds-gray-alpha-900)",
        "alpha-1000": "var(--ds-gray-alpha-1000)",
      },
      blue: {
        100: "var(--ds-blue-100)",
        200: "var(--ds-blue-200)",
        300: "var(--ds-blue-300)",
        400: "var(--ds-blue-400)",
        500: "var(--ds-blue-500)",
        600: "var(--ds-blue-600)",
        700: "var(--ds-blue-700)",
        800: "var(--ds-blue-800)",
        900: "var(--ds-blue-900)",
        1000: "var(--ds-blue-1000)",
      },
      red: {
        100: "var(--ds-red-100)",
        200: "var(--ds-red-200)",
        300: "var(--ds-red-300)",
        400: "var(--ds-red-400)",
        500: "var(--ds-red-500)",
        600: "var(--ds-red-600)",
        700: "var(--ds-red-700)",
        800: "var(--ds-red-800)",
        900: "var(--ds-red-900)",
        1000: "var(--ds-red-1000)",
      },
      amber: {
        100: "var(--ds-amber-100)",
        200: "var(--ds-amber-200)",
        300: "var(--ds-amber-300)",
        400: "var(--ds-amber-400)",
        500: "var(--ds-amber-500)",
        600: "var(--ds-amber-600)",
        700: "var(--ds-amber-700)",
        800: "var(--ds-amber-800)",
        900: "var(--ds-amber-900)",
        1000: "var(--ds-amber-1000)",
      },
      green: {
        100: "var(--ds-green-100)",
        200: "var(--ds-green-200)",
        300: "var(--ds-green-300)",
        400: "var(--ds-green-400)",
        500: "var(--ds-green-500)",
        600: "var(--ds-green-600)",
        700: "var(--ds-green-700)",
        800: "var(--ds-green-800)",
        900: "var(--ds-green-900)",
        1000: "var(--ds-green-1000)",
      },
      teal: {
        100: "var(--ds-teal-100)",
        200: "var(--ds-teal-200)",
        300: "var(--ds-teal-300)",
        400: "var(--ds-teal-400)",
        500: "var(--ds-teal-500)",
        600: "var(--ds-teal-600)",
        700: "var(--ds-teal-700)",
        800: "var(--ds-teal-800)",
        900: "var(--ds-teal-900)",
        1000: "var(--ds-teal-1000)",
      },
      purple: {
        100: "var(--ds-purple-100)",
        200: "var(--ds-purple-200)",
        300: "var(--ds-purple-300)",
        400: "var(--ds-purple-400)",
        500: "var(--ds-purple-500)",
        600: "var(--ds-purple-600)",
        700: "var(--ds-purple-700)",
        800: "var(--ds-purple-800)",
        900: "var(--ds-purple-900)",
        1000: "var(--ds-purple-1000)",
      },
      pink: {
        100: "var(--ds-pink-100)",
        200: "var(--ds-pink-200)",
        300: "var(--ds-pink-300)",
        400: "var(--ds-pink-400)",
        500: "var(--ds-pink-500)",
        600: "var(--ds-pink-600)",
        700: "var(--ds-pink-700)",
        800: "var(--ds-pink-800)",
        900: "var(--ds-pink-900)",
        1000: "var(--ds-pink-1000)",
      },
      boxShadow: {
        none: "none",
        "border-inset": "var(--ds-shadow-border-inset)",
        DEFAULT: "var(--ds-shadow-border-medium)",
        border: "var(--ds-shadow-border)",
        base: "var(--ds-shadow-base)",
        sm: "var(--ds-shadow-border-small)",
        md: "var(--ds-shadow-border-medium)",
        lg: "var(--ds-shadow-border-large)",
        tooltip: "var(--ds-shadow-tooltip)",
        menu: "var(--ds-shadow-menu)",
        modal: "var(--ds-shadow-modal)",
        fullscreen: "var(--ds-shadow-fullscreen)",
        "focus-ring": "var(--ds-focus-ring)",
        "focus-border": "var(--ds-focus-border)",
      },
    },
    extend: {
      fontFamily: {
        sans: "var(--font-geist-sans)",
        mono: "var(--font-geist-mono)",
      },
      borderRadius: {
        lg: "var(--radius)",
        md: "calc(var(--radius) - 2px)",
        sm: "calc(var(--radius) - 4px)",
      },
      colors: {
        foreground: "hsl(var(--foreground))",
        background: {
          DEFAULT: "hsl(var(--ds-background))",
          100: "hsla(var(--ds-background-100-value), <alpha-value>)",
          200: "hsla(var(--ds-background-200-value), <alpha-value>)",
        },
        card: {
          DEFAULT: "hsl(var(--card))",
          foreground: "hsl(var(--card-foreground))",
        },
        popover: {
          DEFAULT: "hsl(var(--popover))",
          foreground: "hsl(var(--popover-foreground))",
        },
        primary: {
          DEFAULT: "hsl(var(--primary))",
          foreground: "hsl(var(--primary-foreground))",
        },
        secondary: {
          DEFAULT: "hsl(var(--secondary))",
          foreground: "hsl(var(--secondary-foreground))",
        },
        muted: {
          DEFAULT: "hsl(var(--muted))",
          foreground: "hsl(var(--muted-foreground))",
        },
        accent: {
          DEFAULT: "hsl(var(--accent))",
          foreground: "hsl(var(--accent-foreground))",
        },
        destructive: {
          DEFAULT: "hsl(var(--destructive))",
          foreground: "hsl(var(--destructive-foreground))",
        },
        border: "hsl(var(--border))",
        input: "hsl(var(--input))",
        ring: "hsl(var(--ring))",
        chart: {
          1: "hsl(var(--chart-1))",
          2: "hsl(var(--chart-2))",
          3: "hsl(var(--chart-3))",
          4: "hsl(var(--chart-4))",
          5: "hsl(var(--chart-5))",
        },
      },
    },
  },
  presets: [createPreset(), require("./typography-plugin.cjs")],
};
