"use client";

import { useTheme } from "next-themes";
import { useEffect, useState } from "react";
import { sizingString } from "./sizing-string";

export const EffortlessGraphic = () => {
  const { resolvedTheme } = useTheme();

  const [mounted, setMounted] = useState(false);

  useEffect(() => {
    setMounted(true);
  }, []);

  if (!mounted) return <div className={sizingString}></div>;

  if (resolvedTheme === "dark") {
    return <EffortlessDark />;
  }
  return <EffortlessLight />;
};

const EffortlessLight = () => {
  return (
    <div className={sizingString}>
      <svg
        className={sizingString}
        viewBox="0 0 312 200"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <g filter="url(#filter0_d_16_1393)">
          <path
            d="M3 43C3 38.5817 6.58172 35 11 35H137C141.418 35 145 38.5817 145 43V158C145 162.418 141.418 166 137 166H11C6.58172 166 3 162.418 3 158V43Z"
            fill="white"
          />
          <path
            d="M137 34.5C141.694 34.5 145.5 38.3056 145.5 43V158C145.5 162.694 141.694 166.5 137 166.5H11C6.30558 166.5 2.5 162.694 2.5 158V43C2.5 38.3056 6.30558 34.5 11 34.5H137Z"
            stroke="black"
            strokeOpacity="0.08"
          />
        </g>
        <line x1="3" y1="69.5" x2="146" y2="69.5" stroke="#EAEAEA" />
        <line
          x1="129"
          y1="146"
          x2="179"
          y2="146"
          stroke="#0196FF"
          strokeWidth="2"
        />
        <path
          d="M129 119.5H135.093C140.762 119.5 146.166 117.094 149.959 112.879L156.041 106.121C159.834 101.906 165.238 99.5 170.907 99.5H179"
          stroke="#8657A7"
          strokeWidth="2"
        />
        <path
          d="M129 92.5V92.5C138.175 92.5 146.552 87.2687 150.575 79.0222L157.425 64.9778C161.448 56.7313 169.825 51.5 179 51.5V51.5"
          stroke="#FF1E56"
          strokeWidth="2"
        />
        <path
          d="M132 92C132 94.2091 130.209 96 128 96C125.791 96 124 94.2091 124 92C124 89.7909 125.791 88 128 88C130.209 88 132 89.7909 132 92Z"
          fill="white"
        />
        <path
          d="M128 87.5C130.485 87.5 132.5 89.5147 132.5 92C132.5 94.4853 130.485 96.5 128 96.5C125.515 96.5 123.5 94.4853 123.5 92C123.5 89.5147 125.515 87.5 128 87.5Z"
          stroke="black"
          strokeOpacity="0.08"
        />
        <path
          d="M132 119C132 121.209 130.209 123 128 123C125.791 123 124 121.209 124 119C124 116.791 125.791 115 128 115C130.209 115 132 116.791 132 119Z"
          fill="white"
        />
        <path
          d="M128 114.5C130.485 114.5 132.5 116.515 132.5 119C132.5 121.485 130.485 123.5 128 123.5C125.515 123.5 123.5 121.485 123.5 119C123.5 116.515 125.515 114.5 128 114.5Z"
          stroke="black"
          strokeOpacity="0.08"
        />
        <path
          d="M132 146C132 148.209 130.209 150 128 150C125.791 150 124 148.209 124 146C124 143.791 125.791 142 128 142C130.209 142 132 143.791 132 146Z"
          fill="white"
        />
        <path
          d="M128 141.5C130.485 141.5 132.5 143.515 132.5 146C132.5 148.485 130.485 150.5 128 150.5C125.515 150.5 123.5 148.485 123.5 146C123.5 143.515 125.515 141.5 128 141.5Z"
          stroke="black"
          strokeOpacity="0.08"
        />
        <g filter="url(#filter1_d_16_1393)">
          <path
            d="M177 46C177 39.3726 182.373 34 189 34H297C303.627 34 309 39.3726 309 46V58C309 64.6274 303.627 70 297 70H189C182.373 70 177 64.6274 177 58V46Z"
            fill="#FAFAFA"
          />
          <path
            d="M297 33.5C303.904 33.5 309.5 39.0964 309.5 46V58C309.5 64.9036 303.904 70.5 297 70.5H189C182.096 70.5 176.5 64.9036 176.5 58V46C176.5 39.0964 182.096 33.5 189 33.5H297Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <g clipPath="url(#clip0_16_1393)">
            <circle
              cx="199"
              cy="52"
              r="7.375"
              fill="black"
              stroke="black"
              strokeWidth="1.25"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M201.63 55V49"
              stroke="url(#paint0_linear_16_1393)"
              strokeWidth="1.25"
              strokeMiterlimit="1.41421"
            />
            <path
              d="M196.995 49.001L204.352 57.9443C204.042 58.2233 203.71 58.4777 203.359 58.7061L196.995 50.9688V55H195.745V49H196.995V49.001Z"
              fill="url(#paint1_linear_16_1393)"
            />
          </g>
          <path
            d="M218.817 50.94L219.598 54.504L220.335 50.17H221.424L220.247 56H219.059L218.3 52.568L217.541 56H216.353L215.176 50.17H216.265L217.002 54.504L217.783 50.94H218.817ZM225.413 50.94L226.194 54.504L226.931 50.17H228.02L226.843 56H225.655L224.896 52.568L224.137 56H222.949L221.772 50.17H222.861L223.598 54.504L224.379 50.94H225.413ZM232.008 50.94L232.789 54.504L233.526 50.17H234.615L233.438 56H232.25L231.491 52.568L230.732 56H229.544L228.367 50.17H229.456L230.193 54.504L230.974 50.94H232.008ZM237.394 54.658H238.78V56H237.394V54.658ZM242.175 51.897C242.406 50.775 243.363 50.038 244.595 50.038C246.014 50.038 246.949 50.863 246.949 52.48V54.713C246.949 54.966 247.059 55.076 247.301 55.076H247.543V56H247.246C246.542 56 246.124 55.626 246.014 55.109C245.783 55.648 245.112 56.132 244.199 56.132C243.033 56.132 242.076 55.516 242.076 54.471C242.076 53.261 242.978 52.931 244.309 52.667L245.893 52.359C245.882 51.457 245.376 51.017 244.584 51.017C243.913 51.017 243.429 51.413 243.297 51.974L242.175 51.897ZM243.187 54.449C243.187 54.867 243.55 55.208 244.331 55.208C245.222 55.208 245.915 54.592 245.915 53.525V53.272L244.65 53.492C243.825 53.646 243.176 53.701 243.187 54.449ZM252.808 52.194C252.687 51.457 252.093 51.017 251.422 51.017C250.41 51.017 249.816 51.787 249.816 53.085C249.816 54.372 250.41 55.153 251.422 55.153C252.126 55.153 252.72 54.68 252.841 53.888L253.952 53.954C253.776 55.296 252.687 56.132 251.422 56.132C249.783 56.132 248.716 54.944 248.716 53.085C248.716 51.226 249.783 50.038 251.422 50.038C252.654 50.038 253.754 50.841 253.908 52.117L252.808 52.194ZM255.047 50.17H255.982L256.015 50.962C256.235 50.368 256.631 50.038 257.203 50.038C257.72 50.038 258.028 50.368 258.215 51.105C258.413 50.445 258.875 50.038 259.469 50.038C260.36 50.038 260.756 50.786 260.756 52.458V56H259.722V52.458C259.722 51.347 259.568 50.929 259.15 50.929C258.688 50.929 258.424 51.468 258.424 52.458V56H257.379V52.458C257.379 51.347 257.214 50.929 256.752 50.929C256.334 50.929 256.092 51.468 256.092 52.458V56H255.047V50.17ZM261.863 53.085C261.863 51.226 262.93 50.038 264.558 50.038C265.867 50.038 267.044 50.885 267.132 52.975L267.143 53.393H262.974C263.062 54.504 263.623 55.153 264.558 55.153C265.152 55.153 265.68 54.812 265.933 54.229L267.055 54.317C266.714 55.439 265.713 56.132 264.558 56.132C262.93 56.132 261.863 54.944 261.863 53.085ZM262.996 52.535H265.999C265.834 51.402 265.229 51.017 264.558 51.017C263.7 51.017 263.15 51.578 262.996 52.535ZM270.373 54.658H271.759V56H270.373V54.658ZM279.19 52.194C279.069 51.457 278.475 51.017 277.804 51.017C276.792 51.017 276.198 51.787 276.198 53.085C276.198 54.372 276.792 55.153 277.804 55.153C278.508 55.153 279.102 54.68 279.223 53.888L280.334 53.954C280.158 55.296 279.069 56.132 277.804 56.132C276.165 56.132 275.098 54.944 275.098 53.085C275.098 51.226 276.165 50.038 277.804 50.038C279.036 50.038 280.136 50.841 280.29 52.117L279.19 52.194ZM284.257 56.132C282.64 56.132 281.562 54.933 281.562 53.085C281.562 51.237 282.64 50.038 284.257 50.038C285.874 50.038 286.952 51.237 286.952 53.085C286.952 54.933 285.874 56.132 284.257 56.132ZM282.662 53.085C282.662 54.372 283.245 55.153 284.257 55.153C285.269 55.153 285.852 54.372 285.852 53.085C285.852 51.787 285.269 51.017 284.257 51.017C283.245 51.017 282.662 51.787 282.662 53.085ZM288.026 50.17H288.961L288.994 50.962C289.214 50.368 289.61 50.038 290.182 50.038C290.699 50.038 291.007 50.368 291.194 51.105C291.392 50.445 291.854 50.038 292.448 50.038C293.339 50.038 293.735 50.786 293.735 52.458V56H292.701V52.458C292.701 51.347 292.547 50.929 292.129 50.929C291.667 50.929 291.403 51.468 291.403 52.458V56H290.358V52.458C290.358 51.347 290.193 50.929 289.731 50.929C289.313 50.929 289.071 51.468 289.071 52.458V56H288.026V50.17Z"
            fill="#666666"
          />
        </g>
        <g filter="url(#filter2_d_16_1393)">
          <path
            d="M177 140C177 133.373 182.373 128 189 128H297C303.627 128 309 133.373 309 140V152C309 158.627 303.627 164 297 164H189C182.373 164 177 158.627 177 152V140Z"
            fill="#FAFAFA"
          />
          <path
            d="M297 127.5C303.904 127.5 309.5 133.096 309.5 140V152C309.5 158.904 303.904 164.5 297 164.5H189C182.096 164.5 176.5 158.904 176.5 152V140C176.5 133.096 182.096 127.5 189 127.5H297Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <path
            d="M196.976 151.333H202.924C203.113 151.333 203.299 151.284 203.462 151.19C203.626 151.097 203.762 150.962 203.856 150.8C203.95 150.638 204 150.454 204 150.267C204 150.079 203.95 149.895 203.856 149.733L199.861 142.876C199.767 142.714 199.631 142.579 199.467 142.486C199.304 142.392 199.118 142.343 198.929 142.343C198.74 142.343 198.555 142.392 198.391 142.486C198.228 142.579 198.092 142.714 197.998 142.876L196.976 144.631L194.979 141.2C194.885 141.038 194.749 140.903 194.585 140.81C194.422 140.716 194.236 140.667 194.047 140.667C193.858 140.667 193.673 140.716 193.509 140.81C193.345 140.903 193.21 141.038 193.115 141.2L188.144 149.733C188.05 149.895 188 150.079 188 150.267C188 150.454 188.05 150.638 188.144 150.8C188.238 150.962 188.374 151.097 188.538 151.19C188.701 151.284 188.887 151.333 189.076 151.333H192.81C194.289 151.333 195.38 150.689 196.13 149.433L197.953 146.305L198.929 144.631L201.859 149.659H197.953L196.976 151.333ZM192.749 149.658L190.143 149.657L194.049 142.953L195.998 146.305L194.693 148.545C194.194 149.361 193.628 149.658 192.749 149.658Z"
            fill="#00DC82"
          />
          <path
            d="M212.858 142.19H213.903V144.929C214.233 144.346 214.816 144.038 215.652 144.038C217.302 144.038 218.083 145.457 218.083 147.085C218.083 148.713 217.302 150.132 215.652 150.132C214.772 150.132 214.178 149.78 213.848 149.186L213.815 150H212.858V142.19ZM213.815 147.085C213.815 148.141 214.266 149.153 215.399 149.153C216.532 149.153 216.983 148.152 216.983 147.085C216.983 145.974 216.532 144.973 215.399 144.973C214.266 144.973 213.815 145.985 213.815 147.085ZM219.674 149.076H221.698V143.774C221.698 143.323 221.5 143.114 221.071 143.114H219.685V142.19H221.071C222.149 142.19 222.743 142.751 222.743 143.774V149.076H224.547V150H219.674V149.076ZM228.491 150.132C226.874 150.132 225.796 148.933 225.796 147.085C225.796 145.237 226.874 144.038 228.491 144.038C230.108 144.038 231.186 145.237 231.186 147.085C231.186 148.933 230.108 150.132 228.491 150.132ZM226.896 147.085C226.896 148.372 227.479 149.153 228.491 149.153C229.503 149.153 230.086 148.372 230.086 147.085C230.086 145.787 229.503 145.017 228.491 145.017C227.479 145.017 226.896 145.787 226.896 147.085ZM235.01 149.692C233.448 149.692 232.436 148.515 232.436 146.887C232.436 145.226 233.47 144.038 235.01 144.038C235.78 144.038 236.385 144.445 236.649 145.072V144.17H237.65V149.373C237.65 150.957 236.627 151.782 235.065 151.782C233.8 151.782 232.876 151.111 232.601 150.088L233.701 150.022C233.932 150.539 234.394 150.836 235.065 150.836C236.022 150.836 236.605 150.407 236.605 149.604V148.724C236.264 149.362 235.615 149.692 235.01 149.692ZM233.536 146.887C233.536 147.987 234.119 148.757 235.098 148.757C236.033 148.757 236.616 147.987 236.627 146.887C236.649 145.787 236.066 145.006 235.098 145.006C234.119 145.006 233.536 145.787 233.536 146.887ZM240.99 148.658H242.376V150H240.99V148.658ZM245.771 145.897C246.002 144.775 246.959 144.038 248.191 144.038C249.61 144.038 250.545 144.863 250.545 146.48V148.713C250.545 148.966 250.655 149.076 250.897 149.076H251.139V150H250.842C250.138 150 249.72 149.626 249.61 149.109C249.379 149.648 248.708 150.132 247.795 150.132C246.629 150.132 245.672 149.516 245.672 148.471C245.672 147.261 246.574 146.931 247.905 146.667L249.489 146.359C249.478 145.457 248.972 145.017 248.18 145.017C247.509 145.017 247.025 145.413 246.893 145.974L245.771 145.897ZM246.783 148.449C246.783 148.867 247.146 149.208 247.927 149.208C248.818 149.208 249.511 148.592 249.511 147.525V147.272L248.246 147.492C247.421 147.646 246.772 147.701 246.783 148.449ZM256.403 146.194C256.282 145.457 255.688 145.017 255.017 145.017C254.005 145.017 253.411 145.787 253.411 147.085C253.411 148.372 254.005 149.153 255.017 149.153C255.721 149.153 256.315 148.68 256.436 147.888L257.547 147.954C257.371 149.296 256.282 150.132 255.017 150.132C253.378 150.132 252.311 148.944 252.311 147.085C252.311 145.226 253.378 144.038 255.017 144.038C256.249 144.038 257.349 144.841 257.503 146.117L256.403 146.194ZM258.643 144.17H259.578L259.611 144.962C259.831 144.368 260.227 144.038 260.799 144.038C261.316 144.038 261.624 144.368 261.811 145.105C262.009 144.445 262.471 144.038 263.065 144.038C263.956 144.038 264.352 144.786 264.352 146.458V150H263.318V146.458C263.318 145.347 263.164 144.929 262.746 144.929C262.284 144.929 262.02 145.468 262.02 146.458V150H260.975V146.458C260.975 145.347 260.81 144.929 260.348 144.929C259.93 144.929 259.688 145.468 259.688 146.458V150H258.643V144.17ZM265.459 147.085C265.459 145.226 266.526 144.038 268.154 144.038C269.463 144.038 270.64 144.885 270.728 146.975L270.739 147.393H266.57C266.658 148.504 267.219 149.153 268.154 149.153C268.748 149.153 269.276 148.812 269.529 148.229L270.651 148.317C270.31 149.439 269.309 150.132 268.154 150.132C266.526 150.132 265.459 148.944 265.459 147.085ZM266.592 146.535H269.595C269.43 145.402 268.825 145.017 268.154 145.017C267.296 145.017 266.746 145.578 266.592 146.535ZM273.968 148.658H275.354V150H273.968V148.658ZM282.786 146.194C282.665 145.457 282.071 145.017 281.4 145.017C280.388 145.017 279.794 145.787 279.794 147.085C279.794 148.372 280.388 149.153 281.4 149.153C282.104 149.153 282.698 148.68 282.819 147.888L283.93 147.954C283.754 149.296 282.665 150.132 281.4 150.132C279.761 150.132 278.694 148.944 278.694 147.085C278.694 145.226 279.761 144.038 281.4 144.038C282.632 144.038 283.732 144.841 283.886 146.117L282.786 146.194ZM287.853 150.132C286.236 150.132 285.158 148.933 285.158 147.085C285.158 145.237 286.236 144.038 287.853 144.038C289.47 144.038 290.548 145.237 290.548 147.085C290.548 148.933 289.47 150.132 287.853 150.132ZM286.258 147.085C286.258 148.372 286.841 149.153 287.853 149.153C288.865 149.153 289.448 148.372 289.448 147.085C289.448 145.787 288.865 145.017 287.853 145.017C286.841 145.017 286.258 145.787 286.258 147.085ZM291.621 144.17H292.556L292.589 144.962C292.809 144.368 293.205 144.038 293.777 144.038C294.294 144.038 294.602 144.368 294.789 145.105C294.987 144.445 295.449 144.038 296.043 144.038C296.934 144.038 297.33 144.786 297.33 146.458V150H296.296V146.458C296.296 145.347 296.142 144.929 295.724 144.929C295.262 144.929 294.998 145.468 294.998 146.458V150H293.953V146.458C293.953 145.347 293.788 144.929 293.326 144.929C292.908 144.929 292.666 145.468 292.666 146.458V150H291.621V144.17Z"
            fill="#666666"
          />
        </g>
        <g filter="url(#filter3_d_16_1393)">
          <path
            d="M177 94C177 87.3726 182.373 82 189 82H297C303.627 82 309 87.3726 309 94V106C309 112.627 303.627 118 297 118H189C182.373 118 177 112.627 177 106V94Z"
            fill="#FAFAFA"
          />
          <path
            d="M297 81.5C303.904 81.5 309.5 87.0964 309.5 94V106C309.5 112.904 303.904 118.5 297 118.5H189C182.096 118.5 176.5 112.904 176.5 106V94C176.5 87.0964 182.096 81.5 189 81.5H297Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <g clipPath="url(#clip1_16_1393)">
            <path
              d="M204.798 94.1153C203.32 91.9865 200.377 91.3627 198.262 92.7051L194.533 95.0915C193.516 95.7288 192.811 96.7729 192.608 97.9526C192.431 98.9424 192.581 99.9593 193.055 100.841C192.73 101.329 192.513 101.871 192.418 102.441C192.201 103.647 192.486 104.895 193.191 105.885C194.682 108.014 197.611 108.637 199.726 107.295L203.455 104.922C204.472 104.285 205.177 103.241 205.381 102.061C205.557 101.071 205.408 100.054 204.933 99.1729C205.259 98.6848 205.476 98.1424 205.57 97.5729C205.801 96.3526 205.516 95.1051 204.798 94.1153Z"
              fill="#FF3E00"
            />
            <path
              d="M197.896 106.088C196.689 106.4 195.428 105.925 194.723 104.908C194.289 104.312 194.126 103.566 194.248 102.834C194.275 102.712 194.303 102.603 194.33 102.481L194.397 102.264L194.587 102.4C195.035 102.725 195.523 102.97 196.052 103.132L196.187 103.173L196.174 103.308C196.16 103.498 196.214 103.702 196.323 103.864C196.54 104.176 196.92 104.325 197.286 104.231C197.367 104.203 197.448 104.176 197.516 104.136L201.231 101.763C201.421 101.641 201.543 101.464 201.584 101.247C201.625 101.031 201.57 100.8 201.448 100.624C201.231 100.312 200.852 100.176 200.486 100.271C200.404 100.298 200.323 100.325 200.255 100.366L198.831 101.275C198.601 101.424 198.343 101.532 198.072 101.6C196.865 101.912 195.604 101.437 194.899 100.42C194.479 99.8238 194.303 99.078 194.438 98.3458C194.56 97.6407 194.994 97.0034 195.604 96.6238L199.333 94.2509C199.564 94.1017 199.821 93.9932 200.092 93.9119C201.299 93.6 202.56 94.0746 203.265 95.0915C203.699 95.6882 203.862 96.4339 203.74 97.1661C203.713 97.2882 203.686 97.3966 203.645 97.5187L203.577 97.7356L203.387 97.6C202.94 97.2746 202.452 97.0305 201.923 96.8678L201.787 96.8271L201.801 96.6915C201.814 96.5017 201.76 96.2983 201.652 96.1356C201.435 95.8238 201.055 95.6882 200.689 95.7831C200.608 95.8102 200.526 95.8373 200.459 95.878L196.743 98.2509C196.553 98.3729 196.431 98.5492 196.391 98.7661C196.35 98.9831 196.404 99.2136 196.526 99.3899C196.743 99.7017 197.123 99.8373 197.489 99.7424C197.57 99.7153 197.652 99.6882 197.72 99.6475L199.143 98.739C199.374 98.5899 199.631 98.4814 199.903 98.4C201.109 98.0882 202.37 98.5627 203.075 99.5797C203.509 100.176 203.672 100.922 203.55 101.654C203.428 102.359 202.994 102.997 202.384 103.376L198.655 105.749C198.425 105.898 198.167 106.007 197.896 106.088Z"
              fill="white"
            />
          </g>
          <path
            d="M215.792 99.897C216.023 98.775 216.98 98.038 218.212 98.038C219.631 98.038 220.566 98.863 220.566 100.48V102.713C220.566 102.966 220.676 103.076 220.918 103.076H221.16V104H220.863C220.159 104 219.741 103.626 219.631 103.109C219.4 103.648 218.729 104.132 217.816 104.132C216.65 104.132 215.693 103.516 215.693 102.471C215.693 101.261 216.595 100.931 217.926 100.667L219.51 100.359C219.499 99.457 218.993 99.017 218.201 99.017C217.53 99.017 217.046 99.413 216.914 99.974L215.792 99.897ZM216.804 102.449C216.804 102.867 217.167 103.208 217.948 103.208C218.839 103.208 219.532 102.592 219.532 101.525V101.272L218.267 101.492C217.442 101.646 216.793 101.701 216.804 102.449ZM226.425 100.194C226.304 99.457 225.71 99.017 225.039 99.017C224.027 99.017 223.433 99.787 223.433 101.085C223.433 102.372 224.027 103.153 225.039 103.153C225.743 103.153 226.337 102.68 226.458 101.888L227.569 101.954C227.393 103.296 226.304 104.132 225.039 104.132C223.4 104.132 222.333 102.944 222.333 101.085C222.333 99.226 223.4 98.038 225.039 98.038C226.271 98.038 227.371 98.841 227.525 100.117L226.425 100.194ZM228.664 98.17H229.599L229.632 98.962C229.852 98.368 230.248 98.038 230.82 98.038C231.337 98.038 231.645 98.368 231.832 99.105C232.03 98.445 232.492 98.038 233.086 98.038C233.977 98.038 234.373 98.786 234.373 100.458V104H233.339V100.458C233.339 99.347 233.185 98.929 232.767 98.929C232.305 98.929 232.041 99.468 232.041 100.458V104H230.996V100.458C230.996 99.347 230.831 98.929 230.369 98.929C229.951 98.929 229.709 99.468 229.709 100.458V104H228.664V98.17ZM235.48 101.085C235.48 99.226 236.547 98.038 238.175 98.038C239.484 98.038 240.661 98.885 240.749 100.975L240.76 101.393H236.591C236.679 102.504 237.24 103.153 238.175 103.153C238.769 103.153 239.297 102.812 239.55 102.229L240.672 102.317C240.331 103.439 239.33 104.132 238.175 104.132C236.547 104.132 235.48 102.944 235.48 101.085ZM236.613 100.535H239.616C239.451 99.402 238.846 99.017 238.175 99.017C237.317 99.017 236.767 99.578 236.613 100.535ZM243.99 102.658H245.376V104H243.99V102.658ZM252.808 100.194C252.687 99.457 252.093 99.017 251.422 99.017C250.41 99.017 249.816 99.787 249.816 101.085C249.816 102.372 250.41 103.153 251.422 103.153C252.126 103.153 252.72 102.68 252.841 101.888L253.952 101.954C253.776 103.296 252.687 104.132 251.422 104.132C249.783 104.132 248.716 102.944 248.716 101.085C248.716 99.226 249.783 98.038 251.422 98.038C252.654 98.038 253.754 98.841 253.908 100.117L252.808 100.194ZM257.874 104.132C256.257 104.132 255.179 102.933 255.179 101.085C255.179 99.237 256.257 98.038 257.874 98.038C259.491 98.038 260.569 99.237 260.569 101.085C260.569 102.933 259.491 104.132 257.874 104.132ZM256.279 101.085C256.279 102.372 256.862 103.153 257.874 103.153C258.886 103.153 259.469 102.372 259.469 101.085C259.469 99.787 258.886 99.017 257.874 99.017C256.862 99.017 256.279 99.787 256.279 101.085ZM261.643 98.17H262.578L262.611 98.962C262.831 98.368 263.227 98.038 263.799 98.038C264.316 98.038 264.624 98.368 264.811 99.105C265.009 98.445 265.471 98.038 266.065 98.038C266.956 98.038 267.352 98.786 267.352 100.458V104H266.318V100.458C266.318 99.347 266.164 98.929 265.746 98.929C265.284 98.929 265.02 99.468 265.02 100.458V104H263.975V100.458C263.975 99.347 263.81 98.929 263.348 98.929C262.93 98.929 262.688 99.468 262.688 100.458V104H261.643V98.17ZM268.899 104.99L272.155 95.585H273.222L269.966 104.99H268.899ZM275.153 99.897C275.384 98.775 276.341 98.038 277.573 98.038C278.992 98.038 279.927 98.863 279.927 100.48V102.713C279.927 102.966 280.037 103.076 280.279 103.076H280.521V104H280.224C279.52 104 279.102 103.626 278.992 103.109C278.761 103.648 278.09 104.132 277.177 104.132C276.011 104.132 275.054 103.516 275.054 102.471C275.054 101.261 275.956 100.931 277.287 100.667L278.871 100.359C278.86 99.457 278.354 99.017 277.562 99.017C276.891 99.017 276.407 99.413 276.275 99.974L275.153 99.897ZM276.165 102.449C276.165 102.867 276.528 103.208 277.309 103.208C278.2 103.208 278.893 102.592 278.893 101.525V101.272L277.628 101.492C276.803 101.646 276.154 101.701 276.165 102.449ZM281.815 105.65V98.17H282.772L282.805 99.028C283.124 98.39 283.729 98.038 284.565 98.038C286.259 98.038 287.04 99.457 287.04 101.085C287.04 102.713 286.259 104.132 284.565 104.132C283.773 104.132 283.19 103.813 282.86 103.208V105.65H281.815ZM282.75 101.085C282.75 102.141 283.223 103.153 284.334 103.153C285.456 103.153 285.918 102.152 285.918 101.085C285.918 100.018 285.456 99.017 284.334 99.017C283.223 99.017 282.75 100.029 282.75 101.085ZM288.411 105.65V98.17H289.368L289.401 99.028C289.72 98.39 290.325 98.038 291.161 98.038C292.855 98.038 293.636 99.457 293.636 101.085C293.636 102.713 292.855 104.132 291.161 104.132C290.369 104.132 289.786 103.813 289.456 103.208V105.65H288.411ZM289.346 101.085C289.346 102.141 289.819 103.153 290.93 103.153C292.052 103.153 292.514 102.152 292.514 101.085C292.514 100.018 292.052 99.017 290.93 99.017C289.819 99.017 289.346 100.029 289.346 101.085Z"
            fill="#666666"
          />
        </g>
        <path
          d="M27 57.5C27.2761 57.5 27.5 57.7239 27.5 58V62L25.5 60.75L23.5 62V58C23.5 57.7239 23.7239 57.5 24 57.5H27ZM32.5 60H29V58.5H31V56H23C22.4477 56 22 56.4477 22 57V59.7891C21.192 59.4355 20.6056 58.6697 20.5127 57.7559L20.5 57.5V48.25C20.5 47.0074 21.5074 46 22.75 46H32.5V60ZM22.75 47.5C22.3358 47.5 22 47.8358 22 48.25V54.71C22.2321 54.6085 22.4817 54.5394 22.7441 54.5127L23 54.5H31V47.5H22.75Z"
          fill="#666666"
        />
        <path
          d="M43.292 53.897C43.523 52.775 44.48 52.038 45.712 52.038C47.131 52.038 48.066 52.863 48.066 54.48V56.713C48.066 56.966 48.176 57.076 48.418 57.076H48.66V58H48.363C47.659 58 47.241 57.626 47.131 57.109C46.9 57.648 46.229 58.132 45.316 58.132C44.15 58.132 43.193 57.516 43.193 56.471C43.193 55.261 44.095 54.931 45.426 54.667L47.01 54.359C46.999 53.457 46.493 53.017 45.701 53.017C45.03 53.017 44.546 53.413 44.414 53.974L43.292 53.897ZM44.304 56.449C44.304 56.867 44.667 57.208 45.448 57.208C46.339 57.208 47.032 56.592 47.032 55.525V55.272L45.767 55.492C44.942 55.646 44.293 55.701 44.304 56.449ZM53.9247 54.194C53.8037 53.457 53.2097 53.017 52.5387 53.017C51.5267 53.017 50.9327 53.787 50.9327 55.085C50.9327 56.372 51.5267 57.153 52.5387 57.153C53.2427 57.153 53.8367 56.68 53.9577 55.888L55.0687 55.954C54.8927 57.296 53.8037 58.132 52.5387 58.132C50.8997 58.132 49.8327 56.944 49.8327 55.085C49.8327 53.226 50.8997 52.038 52.5387 52.038C53.7707 52.038 54.8707 52.841 55.0247 54.117L53.9247 54.194ZM56.1644 52.17H57.0994L57.1324 52.962C57.3524 52.368 57.7484 52.038 58.3204 52.038C58.8374 52.038 59.1454 52.368 59.3324 53.105C59.5304 52.445 59.9924 52.038 60.5864 52.038C61.4774 52.038 61.8734 52.786 61.8734 54.458V58H60.8394V54.458C60.8394 53.347 60.6854 52.929 60.2674 52.929C59.8054 52.929 59.5414 53.468 59.5414 54.458V58H58.4964V54.458C58.4964 53.347 58.3314 52.929 57.8694 52.929C57.4514 52.929 57.2094 53.468 57.2094 54.458V58H56.1644V52.17ZM62.9801 55.085C62.9801 53.226 64.0471 52.038 65.6751 52.038C66.9841 52.038 68.1611 52.885 68.2491 54.975L68.2601 55.393H64.0911C64.1791 56.504 64.7401 57.153 65.6751 57.153C66.2691 57.153 66.7971 56.812 67.0501 56.229L68.1721 56.317C67.8311 57.439 66.8301 58.132 65.6751 58.132C64.0471 58.132 62.9801 56.944 62.9801 55.085ZM64.1131 54.535H67.1161C66.9511 53.402 66.3461 53.017 65.6751 53.017C64.8171 53.017 64.2671 53.578 64.1131 54.535ZM70.0158 58.99L73.2718 49.585H74.3388L71.0828 58.99H70.0158ZM79.2955 52.94L80.0765 56.504L80.8135 52.17H81.9025L80.7255 58H79.5375L78.7785 54.568L78.0195 58H76.8315L75.6545 52.17H76.7435L77.4805 56.504L78.2615 52.94H79.2955ZM82.7672 55.085C82.7672 53.226 83.8342 52.038 85.4622 52.038C86.7712 52.038 87.9482 52.885 88.0362 54.975L88.0472 55.393H83.8782C83.9662 56.504 84.5272 57.153 85.4622 57.153C86.0562 57.153 86.5842 56.812 86.8372 56.229L87.9592 56.317C87.6182 57.439 86.6172 58.132 85.4622 58.132C83.8342 58.132 82.7672 56.944 82.7672 55.085ZM83.9002 54.535H86.9032C86.7382 53.402 86.1332 53.017 85.4622 53.017C84.6042 53.017 84.0542 53.578 83.9002 54.535ZM89.5279 50.19H90.5729V52.929C90.9029 52.346 91.4859 52.038 92.3219 52.038C93.9719 52.038 94.7529 53.457 94.7529 55.085C94.7529 56.713 93.9719 58.132 92.3219 58.132C91.4419 58.132 90.8479 57.78 90.5179 57.186L90.4849 58H89.5279V50.19ZM90.4849 55.085C90.4849 56.141 90.9359 57.153 92.0689 57.153C93.2019 57.153 93.6529 56.152 93.6529 55.085C93.6529 53.974 93.2019 52.973 92.0689 52.973C90.9359 52.973 90.4849 53.985 90.4849 55.085Z"
          fill="#171717"
        />
        <g clipPath="url(#clip2_16_1393)">
          <path
            d="M24.8271 86.0127C24.9858 86.0385 25.1367 86.1028 25.2666 86.2002L26.7334 87.2998C26.8633 87.3972 27.0142 87.4615 27.1729 87.4873L27.333 87.5H34.5V97.5L34.4873 97.7559C34.3677 98.9323 33.4323 99.8677 32.2559 99.9873L32 100H21L20.7441 99.9873C19.5677 99.8677 18.6323 98.9323 18.5127 97.7559L18.5 97.5V86H24.667L24.8271 86.0127ZM20 92.5V97.5C20 98.0523 20.4477 98.5 21 98.5H32C32.5523 98.5 33 98.0523 33 97.5V92.5H20ZM20 91H33V89H27.333C26.8598 88.9999 26.398 88.8652 26 88.6143L25.833 88.5L24.499 87.5H20V91Z"
            fill="#666666"
          />
        </g>
        <path
          d="M47.12 92.985C46.999 92.369 46.416 92.017 45.723 92.017C45.151 92.017 44.634 92.292 44.634 92.842C44.645 93.436 45.349 93.568 45.998 93.733C47.109 93.997 48.22 94.404 48.22 95.493C48.22 96.637 47.12 97.132 45.921 97.132C44.557 97.132 43.457 96.362 43.369 95.152L44.458 95.086C44.568 95.746 45.162 96.153 45.921 96.153C46.515 96.153 47.12 96.01 47.12 95.438C47.12 94.855 46.372 94.756 45.734 94.613C44.645 94.349 43.534 93.942 43.534 92.886C43.534 91.709 44.601 91.038 45.822 91.038C47.054 91.038 48 91.775 48.187 92.919L47.12 92.985ZM53.3087 91.17V96.076H55.0467V97H50.1957V96.076H52.2527V92.094H50.1957V91.17H53.3087ZM52.1537 90.345V89.19H53.3087V90.345H52.1537ZM58.0124 89.63H59.0684V91.17H61.2574V92.094H59.0684V95.295C59.0684 95.779 59.3324 96.076 59.8164 96.076H61.2354V97H59.7614C58.5404 97 58.0124 96.362 58.0124 95.328V92.094H56.4504V91.17H58.0124V89.63ZM62.9801 94.085C62.9801 92.226 64.0471 91.038 65.6751 91.038C66.9841 91.038 68.1611 91.885 68.2491 93.975L68.2601 94.393H64.0911C64.1791 95.504 64.7401 96.153 65.6751 96.153C66.2691 96.153 66.7971 95.812 67.0501 95.229L68.1721 95.317C67.8311 96.439 66.8301 97.132 65.6751 97.132C64.0471 97.132 62.9801 95.944 62.9801 94.085ZM64.1131 93.535H67.1161C66.9511 92.402 66.3461 92.017 65.6751 92.017C64.8171 92.017 64.2671 92.578 64.1131 93.535Z"
          fill="#171717"
        />
        <g clipPath="url(#clip3_16_1393)">
          <path
            d="M24.8271 113.013C24.9858 113.038 25.1367 113.103 25.2666 113.2L26.7334 114.3C26.8633 114.397 27.0142 114.462 27.1729 114.487L27.333 114.5H34.5V124.5L34.4873 124.756C34.3677 125.932 33.4323 126.868 32.2559 126.987L32 127H21L20.7441 126.987C19.5677 126.868 18.6323 125.932 18.5127 124.756L18.5 124.5V113H24.667L24.8271 113.013ZM20 119.5V124.5C20 125.052 20.4477 125.5 21 125.5H32C32.5523 125.5 33 125.052 33 124.5V119.5H20ZM20 118H33V116H27.333C26.8598 116 26.398 115.865 26 115.614L25.833 115.5L24.499 114.5H20V118Z"
            fill="#666666"
          />
        </g>
        <path
          d="M48.242 116.19V124H47.285L47.252 123.186C46.922 123.78 46.328 124.132 45.448 124.132C43.798 124.132 43.017 122.713 43.017 121.085C43.017 119.457 43.798 118.038 45.448 118.038C46.284 118.038 46.867 118.346 47.197 118.929V116.19H48.242ZM44.117 121.085C44.117 122.152 44.568 123.153 45.701 123.153C46.834 123.153 47.285 122.141 47.285 121.085C47.285 119.985 46.834 118.973 45.701 118.973C44.568 118.973 44.117 119.974 44.117 121.085ZM49.8877 119.897C50.1187 118.775 51.0757 118.038 52.3077 118.038C53.7267 118.038 54.6617 118.863 54.6617 120.48V122.713C54.6617 122.966 54.7717 123.076 55.0137 123.076H55.2557V124H54.9587C54.2547 124 53.8367 123.626 53.7267 123.109C53.4957 123.648 52.8247 124.132 51.9117 124.132C50.7457 124.132 49.7887 123.516 49.7887 122.471C49.7887 121.261 50.6907 120.931 52.0217 120.667L53.6057 120.359C53.5947 119.457 53.0887 119.017 52.2967 119.017C51.6257 119.017 51.1417 119.413 51.0097 119.974L49.8877 119.897ZM50.8997 122.449C50.8997 122.867 51.2627 123.208 52.0437 123.208C52.9347 123.208 53.6277 122.592 53.6277 121.525V121.272L52.3627 121.492C51.5377 121.646 50.8887 121.701 50.8997 122.449ZM60.3114 119.985C60.1904 119.369 59.6074 119.017 58.9144 119.017C58.3424 119.017 57.8254 119.292 57.8254 119.842C57.8364 120.436 58.5404 120.568 59.1894 120.733C60.3004 120.997 61.4114 121.404 61.4114 122.493C61.4114 123.637 60.3114 124.132 59.1124 124.132C57.7484 124.132 56.6484 123.362 56.5604 122.152L57.6494 122.086C57.7594 122.746 58.3534 123.153 59.1124 123.153C59.7064 123.153 60.3114 123.01 60.3114 122.438C60.3114 121.855 59.5634 121.756 58.9254 121.613C57.8364 121.349 56.7254 120.942 56.7254 119.886C56.7254 118.709 57.7924 118.038 59.0134 118.038C60.2454 118.038 61.1914 118.775 61.3784 119.919L60.3114 119.985ZM63.3761 116.19H64.4211V118.929C64.7621 118.324 65.4111 118.038 66.1151 118.038C67.4131 118.038 68.0511 118.995 68.0511 120.249V124H66.9951V120.579C66.9951 119.545 66.6651 118.995 65.8401 118.995C64.9821 118.995 64.4211 119.545 64.4211 120.579V124H63.3761V116.19ZM69.7408 116.19H70.7858V118.929C71.1158 118.346 71.6988 118.038 72.5348 118.038C74.1848 118.038 74.9658 119.457 74.9658 121.085C74.9658 122.713 74.1848 124.132 72.5348 124.132C71.6548 124.132 71.0608 123.78 70.7308 123.186L70.6978 124H69.7408V116.19ZM70.6978 121.085C70.6978 122.141 71.1488 123.153 72.2818 123.153C73.4148 123.153 73.8658 122.152 73.8658 121.085C73.8658 119.974 73.4148 118.973 72.2818 118.973C71.1488 118.973 70.6978 119.985 70.6978 121.085ZM78.7785 124.132C77.1615 124.132 76.0835 122.933 76.0835 121.085C76.0835 119.237 77.1615 118.038 78.7785 118.038C80.3955 118.038 81.4735 119.237 81.4735 121.085C81.4735 122.933 80.3955 124.132 78.7785 124.132ZM77.1835 121.085C77.1835 122.372 77.7665 123.153 78.7785 123.153C79.7905 123.153 80.3735 122.372 80.3735 121.085C80.3735 119.787 79.7905 119.017 78.7785 119.017C77.7665 119.017 77.1835 119.787 77.1835 121.085ZM82.8662 119.897C83.0972 118.775 84.0542 118.038 85.2862 118.038C86.7052 118.038 87.6402 118.863 87.6402 120.48V122.713C87.6402 122.966 87.7502 123.076 87.9922 123.076H88.2342V124H87.9372C87.2332 124 86.8152 123.626 86.7052 123.109C86.4742 123.648 85.8032 124.132 84.8902 124.132C83.7242 124.132 82.7672 123.516 82.7672 122.471C82.7672 121.261 83.6692 120.931 85.0002 120.667L86.5842 120.359C86.5732 119.457 86.0672 119.017 85.2752 119.017C84.6042 119.017 84.1202 119.413 83.9882 119.974L82.8662 119.897ZM83.8782 122.449C83.8782 122.867 84.2412 123.208 85.0222 123.208C85.9132 123.208 86.6062 122.592 86.6062 121.525V121.272L85.3412 121.492C84.5162 121.646 83.8672 121.701 83.8782 122.449ZM91.8819 118.17L91.9589 119.248C92.1569 118.511 92.6299 118.17 93.3999 118.17H94.5879V119.094H93.4329C92.5529 119.094 92.1569 119.578 92.1569 120.546V123.076H94.0269V124H89.6159V123.076H91.1119V119.094H89.6159V118.17H91.8819ZM101.008 116.19V124H100.051L100.018 123.186C99.6876 123.78 99.0936 124.132 98.2136 124.132C96.5636 124.132 95.7826 122.713 95.7826 121.085C95.7826 119.457 96.5636 118.038 98.2136 118.038C99.0496 118.038 99.6326 118.346 99.9626 118.929V116.19H101.008ZM96.8826 121.085C96.8826 122.152 97.3336 123.153 98.4666 123.153C99.5996 123.153 100.051 122.141 100.051 121.085C100.051 119.985 99.5996 118.973 98.4666 118.973C97.3336 118.973 96.8826 119.974 96.8826 121.085Z"
          fill="#171717"
        />
        <g clipPath="url(#clip4_16_1393)">
          <path
            d="M24.8271 140.013C24.9858 140.038 25.1367 140.103 25.2666 140.2L26.7334 141.3C26.8633 141.397 27.0142 141.462 27.1729 141.487L27.333 141.5H34.5V151.5L34.4873 151.756C34.3677 152.932 33.4323 153.868 32.2559 153.987L32 154H21L20.7441 153.987C19.5677 153.868 18.6323 152.932 18.5127 151.756L18.5 151.5V140H24.667L24.8271 140.013ZM20 146.5V151.5C20 152.052 20.4477 152.5 21 152.5H32C32.5523 152.5 33 152.052 33 151.5V146.5H20ZM20 145H33V143H27.333C26.8598 143 26.398 142.865 26 142.614L25.833 142.5L24.499 141.5H20V145Z"
            fill="#666666"
          />
        </g>
        <path
          d="M43.358 152.65V145.17H44.315L44.348 146.028C44.667 145.39 45.272 145.038 46.108 145.038C47.802 145.038 48.583 146.457 48.583 148.085C48.583 149.713 47.802 151.132 46.108 151.132C45.316 151.132 44.733 150.813 44.403 150.208V152.65H43.358ZM44.293 148.085C44.293 149.141 44.766 150.153 45.877 150.153C46.999 150.153 47.461 149.152 47.461 148.085C47.461 147.018 46.999 146.017 45.877 146.017C44.766 146.017 44.293 147.029 44.293 148.085ZM52.3957 151.132C50.7787 151.132 49.7007 149.933 49.7007 148.085C49.7007 146.237 50.7787 145.038 52.3957 145.038C54.0127 145.038 55.0907 146.237 55.0907 148.085C55.0907 149.933 54.0127 151.132 52.3957 151.132ZM50.8007 148.085C50.8007 149.372 51.3837 150.153 52.3957 150.153C53.4077 150.153 53.9907 149.372 53.9907 148.085C53.9907 146.787 53.4077 146.017 52.3957 146.017C51.3837 146.017 50.8007 146.787 50.8007 148.085ZM60.3114 146.985C60.1904 146.369 59.6074 146.017 58.9144 146.017C58.3424 146.017 57.8254 146.292 57.8254 146.842C57.8364 147.436 58.5404 147.568 59.1894 147.733C60.3004 147.997 61.4114 148.404 61.4114 149.493C61.4114 150.637 60.3114 151.132 59.1124 151.132C57.7484 151.132 56.6484 150.362 56.5604 149.152L57.6494 149.086C57.7594 149.746 58.3534 150.153 59.1124 150.153C59.7064 150.153 60.3114 150.01 60.3114 149.438C60.3114 148.855 59.5634 148.756 58.9254 148.613C57.8364 148.349 56.7254 147.942 56.7254 146.886C56.7254 145.709 57.7924 145.038 59.0134 145.038C60.2454 145.038 61.1914 145.775 61.3784 146.919L60.3114 146.985ZM64.6081 143.63H65.6641V145.17H67.8531V146.094H65.6641V149.295C65.6641 149.779 65.9281 150.076 66.4121 150.076H67.8311V151H66.3571C65.1361 151 64.6081 150.362 64.6081 149.328V146.094H63.0461V145.17H64.6081V143.63ZM73.5028 146.985C73.3818 146.369 72.7988 146.017 72.1058 146.017C71.5338 146.017 71.0168 146.292 71.0168 146.842C71.0278 147.436 71.7318 147.568 72.3808 147.733C73.4918 147.997 74.6028 148.404 74.6028 149.493C74.6028 150.637 73.5028 151.132 72.3038 151.132C70.9398 151.132 69.8398 150.362 69.7518 149.152L70.8408 149.086C70.9508 149.746 71.5448 150.153 72.3038 150.153C72.8978 150.153 73.5028 150.01 73.5028 149.438C73.5028 148.855 72.7548 148.756 72.1168 148.613C71.0278 148.349 69.9168 147.942 69.9168 146.886C69.9168 145.709 70.9838 145.038 72.2048 145.038C73.4368 145.038 74.3828 145.775 74.5698 146.919L73.5028 146.985Z"
          fill="#171717"
        />
        <defs>
          <filter
            id="filter0_d_16_1393"
            x="0"
            y="33"
            width="148"
            height="137"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1393"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1393"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_16_1393"
            x="174"
            y="32"
            width="138"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1393"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1393"
              result="shape"
            />
          </filter>
          <filter
            id="filter2_d_16_1393"
            x="174"
            y="126"
            width="138"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1393"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1393"
              result="shape"
            />
          </filter>
          <filter
            id="filter3_d_16_1393"
            x="174"
            y="80"
            width="138"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1393"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1393"
              result="shape"
            />
          </filter>
          <linearGradient
            id="paint0_linear_16_1393"
            x1="202.13"
            y1="49"
            x2="202.13"
            y2="55"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="white" />
            <stop offset="0.609375" stopColor="white" stopOpacity="0.57" />
            <stop offset="0.796875" stopColor="white" stopOpacity="0" />
            <stop offset="1" stopColor="white" stopOpacity="0" />
          </linearGradient>
          <linearGradient
            id="paint1_linear_16_1393"
            x1="200.701"
            y1="54.4728"
            x2="203.79"
            y2="58.4122"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="white" />
            <stop offset="0.604072" stopColor="white" stopOpacity="0" />
            <stop offset="1" stopColor="white" stopOpacity="0" />
          </linearGradient>
          <clipPath id="clip0_16_1393">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(191 44)"
            />
          </clipPath>
          <clipPath id="clip1_16_1393">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(191 92)"
            />
          </clipPath>
          <clipPath id="clip2_16_1393">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(18.5 85)"
            />
          </clipPath>
          <clipPath id="clip3_16_1393">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(18.5 112)"
            />
          </clipPath>
          <clipPath id="clip4_16_1393">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(18.5 139)"
            />
          </clipPath>
        </defs>
      </svg>
    </div>
  );
};

const EffortlessDark = () => {
  return (
    <div className={sizingString}>
      <svg
        className={sizingString}
        viewBox="0 0 312 200"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <g filter="url(#filter0_d_17_1198)">
          <path
            d="M3 43C3 38.5817 6.58172 35 11 35H137C141.418 35 145 38.5817 145 43V158C145 162.418 141.418 166 137 166H11C6.58172 166 3 162.418 3 158V43Z"
            fill="#0A0A0A"
          />
          <path
            d="M137 34.5C141.694 34.5 145.5 38.3056 145.5 43V158C145.5 162.694 141.694 166.5 137 166.5H11C6.30558 166.5 2.5 162.694 2.5 158V43C2.5 38.3056 6.30558 34.5 11 34.5H137Z"
            stroke="white"
            strokeOpacity="0.145"
          />
        </g>
        <line x1="3" y1="69.5" x2="146" y2="69.5" stroke="#2E2E2E" />
        <line
          x1="129"
          y1="146"
          x2="179"
          y2="146"
          stroke="#0196FF"
          strokeWidth="2"
        />
        <path
          d="M129 119.5H135.093C140.762 119.5 146.166 117.094 149.959 112.879L156.041 106.121C159.834 101.906 165.238 99.5 170.907 99.5H179"
          stroke="#8657A7"
          strokeWidth="2"
        />
        <path
          d="M129 92.5V92.5C138.175 92.5 146.552 87.2687 150.575 79.0222L157.425 64.9778C161.448 56.7313 169.825 51.5 179 51.5V51.5"
          stroke="#FF1E56"
          strokeWidth="2"
        />
        <path
          d="M132 92C132 94.2091 130.209 96 128 96C125.791 96 124 94.2091 124 92C124 89.7909 125.791 88 128 88C130.209 88 132 89.7909 132 92Z"
          fill="#0A0A0A"
        />
        <path
          d="M128 87.5C130.485 87.5 132.5 89.5147 132.5 92C132.5 94.4853 130.485 96.5 128 96.5C125.515 96.5 123.5 94.4853 123.5 92C123.5 89.5147 125.515 87.5 128 87.5Z"
          stroke="white"
          strokeOpacity="0.145"
        />
        <path
          d="M132 119C132 121.209 130.209 123 128 123C125.791 123 124 121.209 124 119C124 116.791 125.791 115 128 115C130.209 115 132 116.791 132 119Z"
          fill="#0A0A0A"
        />
        <path
          d="M128 114.5C130.485 114.5 132.5 116.515 132.5 119C132.5 121.485 130.485 123.5 128 123.5C125.515 123.5 123.5 121.485 123.5 119C123.5 116.515 125.515 114.5 128 114.5Z"
          stroke="white"
          strokeOpacity="0.145"
        />
        <path
          d="M132 146C132 148.209 130.209 150 128 150C125.791 150 124 148.209 124 146C124 143.791 125.791 142 128 142C130.209 142 132 143.791 132 146Z"
          fill="#0A0A0A"
        />
        <path
          d="M128 141.5C130.485 141.5 132.5 143.515 132.5 146C132.5 148.485 130.485 150.5 128 150.5C125.515 150.5 123.5 148.485 123.5 146C123.5 143.515 125.515 141.5 128 141.5Z"
          stroke="white"
          strokeOpacity="0.145"
        />
        <g filter="url(#filter1_d_17_1198)">
          <path
            d="M177 46C177 39.3726 182.373 34 189 34H297C303.627 34 309 39.3726 309 46V58C309 64.6274 303.627 70 297 70H189C182.373 70 177 64.6274 177 58V46Z"
            fill="black"
          />
          <path
            d="M297 33.5C303.904 33.5 309.5 39.0964 309.5 46V58C309.5 64.9036 303.904 70.5 297 70.5H189C182.096 70.5 176.5 64.9036 176.5 58V46C176.5 39.0964 182.096 33.5 189 33.5H297Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <g clipPath="url(#clip0_17_1198)">
            <circle
              cx="199"
              cy="52"
              r="7.375"
              fill="black"
              stroke="white"
              strokeWidth="1.25"
              strokeLinecap="round"
              strokeLinejoin="round"
            />
            <path
              d="M201.63 55V49"
              stroke="url(#paint0_linear_17_1198)"
              strokeWidth="1.25"
              strokeMiterlimit="1.41421"
            />
            <path
              d="M196.995 49.001L204.352 57.9443C204.042 58.2233 203.71 58.4777 203.359 58.7061L196.995 50.9688V55H195.745V49H196.995V49.001Z"
              fill="url(#paint1_linear_17_1198)"
            />
          </g>
          <path
            d="M218.817 50.94L219.598 54.504L220.335 50.17H221.424L220.247 56H219.059L218.3 52.568L217.541 56H216.353L215.176 50.17H216.265L217.002 54.504L217.783 50.94H218.817ZM225.413 50.94L226.194 54.504L226.931 50.17H228.02L226.843 56H225.655L224.896 52.568L224.137 56H222.949L221.772 50.17H222.861L223.598 54.504L224.379 50.94H225.413ZM232.008 50.94L232.789 54.504L233.526 50.17H234.615L233.438 56H232.25L231.491 52.568L230.732 56H229.544L228.367 50.17H229.456L230.193 54.504L230.974 50.94H232.008ZM237.394 54.658H238.78V56H237.394V54.658ZM242.175 51.897C242.406 50.775 243.363 50.038 244.595 50.038C246.014 50.038 246.949 50.863 246.949 52.48V54.713C246.949 54.966 247.059 55.076 247.301 55.076H247.543V56H247.246C246.542 56 246.124 55.626 246.014 55.109C245.783 55.648 245.112 56.132 244.199 56.132C243.033 56.132 242.076 55.516 242.076 54.471C242.076 53.261 242.978 52.931 244.309 52.667L245.893 52.359C245.882 51.457 245.376 51.017 244.584 51.017C243.913 51.017 243.429 51.413 243.297 51.974L242.175 51.897ZM243.187 54.449C243.187 54.867 243.55 55.208 244.331 55.208C245.222 55.208 245.915 54.592 245.915 53.525V53.272L244.65 53.492C243.825 53.646 243.176 53.701 243.187 54.449ZM252.808 52.194C252.687 51.457 252.093 51.017 251.422 51.017C250.41 51.017 249.816 51.787 249.816 53.085C249.816 54.372 250.41 55.153 251.422 55.153C252.126 55.153 252.72 54.68 252.841 53.888L253.952 53.954C253.776 55.296 252.687 56.132 251.422 56.132C249.783 56.132 248.716 54.944 248.716 53.085C248.716 51.226 249.783 50.038 251.422 50.038C252.654 50.038 253.754 50.841 253.908 52.117L252.808 52.194ZM255.047 50.17H255.982L256.015 50.962C256.235 50.368 256.631 50.038 257.203 50.038C257.72 50.038 258.028 50.368 258.215 51.105C258.413 50.445 258.875 50.038 259.469 50.038C260.36 50.038 260.756 50.786 260.756 52.458V56H259.722V52.458C259.722 51.347 259.568 50.929 259.15 50.929C258.688 50.929 258.424 51.468 258.424 52.458V56H257.379V52.458C257.379 51.347 257.214 50.929 256.752 50.929C256.334 50.929 256.092 51.468 256.092 52.458V56H255.047V50.17ZM261.863 53.085C261.863 51.226 262.93 50.038 264.558 50.038C265.867 50.038 267.044 50.885 267.132 52.975L267.143 53.393H262.974C263.062 54.504 263.623 55.153 264.558 55.153C265.152 55.153 265.68 54.812 265.933 54.229L267.055 54.317C266.714 55.439 265.713 56.132 264.558 56.132C262.93 56.132 261.863 54.944 261.863 53.085ZM262.996 52.535H265.999C265.834 51.402 265.229 51.017 264.558 51.017C263.7 51.017 263.15 51.578 262.996 52.535ZM270.373 54.658H271.759V56H270.373V54.658ZM279.19 52.194C279.069 51.457 278.475 51.017 277.804 51.017C276.792 51.017 276.198 51.787 276.198 53.085C276.198 54.372 276.792 55.153 277.804 55.153C278.508 55.153 279.102 54.68 279.223 53.888L280.334 53.954C280.158 55.296 279.069 56.132 277.804 56.132C276.165 56.132 275.098 54.944 275.098 53.085C275.098 51.226 276.165 50.038 277.804 50.038C279.036 50.038 280.136 50.841 280.29 52.117L279.19 52.194ZM284.257 56.132C282.64 56.132 281.562 54.933 281.562 53.085C281.562 51.237 282.64 50.038 284.257 50.038C285.874 50.038 286.952 51.237 286.952 53.085C286.952 54.933 285.874 56.132 284.257 56.132ZM282.662 53.085C282.662 54.372 283.245 55.153 284.257 55.153C285.269 55.153 285.852 54.372 285.852 53.085C285.852 51.787 285.269 51.017 284.257 51.017C283.245 51.017 282.662 51.787 282.662 53.085ZM288.026 50.17H288.961L288.994 50.962C289.214 50.368 289.61 50.038 290.182 50.038C290.699 50.038 291.007 50.368 291.194 51.105C291.392 50.445 291.854 50.038 292.448 50.038C293.339 50.038 293.735 50.786 293.735 52.458V56H292.701V52.458C292.701 51.347 292.547 50.929 292.129 50.929C291.667 50.929 291.403 51.468 291.403 52.458V56H290.358V52.458C290.358 51.347 290.193 50.929 289.731 50.929C289.313 50.929 289.071 51.468 289.071 52.458V56H288.026V50.17Z"
            fill="#A0A0A0"
          />
        </g>
        <g filter="url(#filter2_d_17_1198)">
          <path
            d="M177 140C177 133.373 182.373 128 189 128H297C303.627 128 309 133.373 309 140V152C309 158.627 303.627 164 297 164H189C182.373 164 177 158.627 177 152V140Z"
            fill="black"
          />
          <path
            d="M297 127.5C303.904 127.5 309.5 133.096 309.5 140V152C309.5 158.904 303.904 164.5 297 164.5H189C182.096 164.5 176.5 158.904 176.5 152V140C176.5 133.096 182.096 127.5 189 127.5H297Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <path
            d="M196.976 151.333H202.924C203.113 151.333 203.299 151.284 203.462 151.19C203.626 151.097 203.762 150.962 203.856 150.8C203.95 150.638 204 150.454 204 150.267C204 150.079 203.95 149.895 203.856 149.733L199.861 142.876C199.767 142.714 199.631 142.579 199.467 142.486C199.304 142.392 199.118 142.343 198.929 142.343C198.74 142.343 198.555 142.392 198.391 142.486C198.228 142.579 198.092 142.714 197.998 142.876L196.976 144.631L194.979 141.2C194.885 141.038 194.749 140.903 194.585 140.81C194.422 140.716 194.236 140.667 194.047 140.667C193.858 140.667 193.673 140.716 193.509 140.81C193.345 140.903 193.21 141.038 193.115 141.2L188.144 149.733C188.05 149.895 188 150.079 188 150.267C188 150.454 188.05 150.638 188.144 150.8C188.238 150.962 188.374 151.097 188.538 151.19C188.701 151.284 188.887 151.333 189.076 151.333H192.81C194.289 151.333 195.38 150.689 196.13 149.433L197.953 146.305L198.929 144.631L201.859 149.659H197.953L196.976 151.333ZM192.749 149.658L190.143 149.657L194.049 142.953L195.998 146.305L194.693 148.545C194.194 149.361 193.628 149.658 192.749 149.658Z"
            fill="#00DC82"
          />
          <path
            d="M212.858 142.19H213.903V144.929C214.233 144.346 214.816 144.038 215.652 144.038C217.302 144.038 218.083 145.457 218.083 147.085C218.083 148.713 217.302 150.132 215.652 150.132C214.772 150.132 214.178 149.78 213.848 149.186L213.815 150H212.858V142.19ZM213.815 147.085C213.815 148.141 214.266 149.153 215.399 149.153C216.532 149.153 216.983 148.152 216.983 147.085C216.983 145.974 216.532 144.973 215.399 144.973C214.266 144.973 213.815 145.985 213.815 147.085ZM219.674 149.076H221.698V143.774C221.698 143.323 221.5 143.114 221.071 143.114H219.685V142.19H221.071C222.149 142.19 222.743 142.751 222.743 143.774V149.076H224.547V150H219.674V149.076ZM228.491 150.132C226.874 150.132 225.796 148.933 225.796 147.085C225.796 145.237 226.874 144.038 228.491 144.038C230.108 144.038 231.186 145.237 231.186 147.085C231.186 148.933 230.108 150.132 228.491 150.132ZM226.896 147.085C226.896 148.372 227.479 149.153 228.491 149.153C229.503 149.153 230.086 148.372 230.086 147.085C230.086 145.787 229.503 145.017 228.491 145.017C227.479 145.017 226.896 145.787 226.896 147.085ZM235.01 149.692C233.448 149.692 232.436 148.515 232.436 146.887C232.436 145.226 233.47 144.038 235.01 144.038C235.78 144.038 236.385 144.445 236.649 145.072V144.17H237.65V149.373C237.65 150.957 236.627 151.782 235.065 151.782C233.8 151.782 232.876 151.111 232.601 150.088L233.701 150.022C233.932 150.539 234.394 150.836 235.065 150.836C236.022 150.836 236.605 150.407 236.605 149.604V148.724C236.264 149.362 235.615 149.692 235.01 149.692ZM233.536 146.887C233.536 147.987 234.119 148.757 235.098 148.757C236.033 148.757 236.616 147.987 236.627 146.887C236.649 145.787 236.066 145.006 235.098 145.006C234.119 145.006 233.536 145.787 233.536 146.887ZM240.99 148.658H242.376V150H240.99V148.658ZM245.771 145.897C246.002 144.775 246.959 144.038 248.191 144.038C249.61 144.038 250.545 144.863 250.545 146.48V148.713C250.545 148.966 250.655 149.076 250.897 149.076H251.139V150H250.842C250.138 150 249.72 149.626 249.61 149.109C249.379 149.648 248.708 150.132 247.795 150.132C246.629 150.132 245.672 149.516 245.672 148.471C245.672 147.261 246.574 146.931 247.905 146.667L249.489 146.359C249.478 145.457 248.972 145.017 248.18 145.017C247.509 145.017 247.025 145.413 246.893 145.974L245.771 145.897ZM246.783 148.449C246.783 148.867 247.146 149.208 247.927 149.208C248.818 149.208 249.511 148.592 249.511 147.525V147.272L248.246 147.492C247.421 147.646 246.772 147.701 246.783 148.449ZM256.403 146.194C256.282 145.457 255.688 145.017 255.017 145.017C254.005 145.017 253.411 145.787 253.411 147.085C253.411 148.372 254.005 149.153 255.017 149.153C255.721 149.153 256.315 148.68 256.436 147.888L257.547 147.954C257.371 149.296 256.282 150.132 255.017 150.132C253.378 150.132 252.311 148.944 252.311 147.085C252.311 145.226 253.378 144.038 255.017 144.038C256.249 144.038 257.349 144.841 257.503 146.117L256.403 146.194ZM258.643 144.17H259.578L259.611 144.962C259.831 144.368 260.227 144.038 260.799 144.038C261.316 144.038 261.624 144.368 261.811 145.105C262.009 144.445 262.471 144.038 263.065 144.038C263.956 144.038 264.352 144.786 264.352 146.458V150H263.318V146.458C263.318 145.347 263.164 144.929 262.746 144.929C262.284 144.929 262.02 145.468 262.02 146.458V150H260.975V146.458C260.975 145.347 260.81 144.929 260.348 144.929C259.93 144.929 259.688 145.468 259.688 146.458V150H258.643V144.17ZM265.459 147.085C265.459 145.226 266.526 144.038 268.154 144.038C269.463 144.038 270.64 144.885 270.728 146.975L270.739 147.393H266.57C266.658 148.504 267.219 149.153 268.154 149.153C268.748 149.153 269.276 148.812 269.529 148.229L270.651 148.317C270.31 149.439 269.309 150.132 268.154 150.132C266.526 150.132 265.459 148.944 265.459 147.085ZM266.592 146.535H269.595C269.43 145.402 268.825 145.017 268.154 145.017C267.296 145.017 266.746 145.578 266.592 146.535ZM273.968 148.658H275.354V150H273.968V148.658ZM282.786 146.194C282.665 145.457 282.071 145.017 281.4 145.017C280.388 145.017 279.794 145.787 279.794 147.085C279.794 148.372 280.388 149.153 281.4 149.153C282.104 149.153 282.698 148.68 282.819 147.888L283.93 147.954C283.754 149.296 282.665 150.132 281.4 150.132C279.761 150.132 278.694 148.944 278.694 147.085C278.694 145.226 279.761 144.038 281.4 144.038C282.632 144.038 283.732 144.841 283.886 146.117L282.786 146.194ZM287.853 150.132C286.236 150.132 285.158 148.933 285.158 147.085C285.158 145.237 286.236 144.038 287.853 144.038C289.47 144.038 290.548 145.237 290.548 147.085C290.548 148.933 289.47 150.132 287.853 150.132ZM286.258 147.085C286.258 148.372 286.841 149.153 287.853 149.153C288.865 149.153 289.448 148.372 289.448 147.085C289.448 145.787 288.865 145.017 287.853 145.017C286.841 145.017 286.258 145.787 286.258 147.085ZM291.621 144.17H292.556L292.589 144.962C292.809 144.368 293.205 144.038 293.777 144.038C294.294 144.038 294.602 144.368 294.789 145.105C294.987 144.445 295.449 144.038 296.043 144.038C296.934 144.038 297.33 144.786 297.33 146.458V150H296.296V146.458C296.296 145.347 296.142 144.929 295.724 144.929C295.262 144.929 294.998 145.468 294.998 146.458V150H293.953V146.458C293.953 145.347 293.788 144.929 293.326 144.929C292.908 144.929 292.666 145.468 292.666 146.458V150H291.621V144.17Z"
            fill="#A0A0A0"
          />
        </g>
        <g filter="url(#filter3_d_17_1198)">
          <path
            d="M177 94C177 87.3726 182.373 82 189 82H297C303.627 82 309 87.3726 309 94V106C309 112.627 303.627 118 297 118H189C182.373 118 177 112.627 177 106V94Z"
            fill="black"
          />
          <path
            d="M297 81.5C303.904 81.5 309.5 87.0964 309.5 94V106C309.5 112.904 303.904 118.5 297 118.5H189C182.096 118.5 176.5 112.904 176.5 106V94C176.5 87.0964 182.096 81.5 189 81.5H297Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <g clipPath="url(#clip1_17_1198)">
            <path
              d="M204.798 94.1153C203.32 91.9865 200.377 91.3627 198.262 92.7051L194.533 95.0915C193.516 95.7288 192.811 96.7729 192.608 97.9526C192.431 98.9424 192.581 99.9593 193.055 100.841C192.73 101.329 192.513 101.871 192.418 102.441C192.201 103.647 192.486 104.895 193.191 105.885C194.682 108.014 197.611 108.637 199.726 107.295L203.455 104.922C204.472 104.285 205.177 103.241 205.381 102.061C205.557 101.071 205.408 100.054 204.933 99.1729C205.259 98.6848 205.476 98.1424 205.57 97.5729C205.801 96.3526 205.516 95.1051 204.798 94.1153Z"
              fill="#FF3E00"
            />
            <path
              d="M197.896 106.088C196.689 106.4 195.428 105.925 194.723 104.908C194.289 104.312 194.126 103.566 194.248 102.834C194.275 102.712 194.303 102.603 194.33 102.481L194.397 102.264L194.587 102.4C195.035 102.725 195.523 102.97 196.052 103.132L196.187 103.173L196.174 103.308C196.16 103.498 196.214 103.702 196.323 103.864C196.54 104.176 196.92 104.325 197.286 104.231C197.367 104.203 197.448 104.176 197.516 104.136L201.231 101.763C201.421 101.641 201.543 101.464 201.584 101.247C201.625 101.031 201.57 100.8 201.448 100.624C201.231 100.312 200.852 100.176 200.486 100.271C200.404 100.298 200.323 100.325 200.255 100.366L198.831 101.275C198.601 101.424 198.343 101.532 198.072 101.6C196.865 101.912 195.604 101.437 194.899 100.42C194.479 99.8238 194.303 99.078 194.438 98.3458C194.56 97.6407 194.994 97.0034 195.604 96.6238L199.333 94.2509C199.564 94.1017 199.821 93.9932 200.092 93.9119C201.299 93.6 202.56 94.0746 203.265 95.0915C203.699 95.6882 203.862 96.4339 203.74 97.1661C203.713 97.2882 203.686 97.3966 203.645 97.5187L203.577 97.7356L203.387 97.6C202.94 97.2746 202.452 97.0305 201.923 96.8678L201.787 96.8271L201.801 96.6915C201.814 96.5017 201.76 96.2983 201.652 96.1356C201.435 95.8238 201.055 95.6882 200.689 95.7831C200.608 95.8102 200.526 95.8373 200.459 95.878L196.743 98.2509C196.553 98.3729 196.431 98.5492 196.391 98.7661C196.35 98.9831 196.404 99.2136 196.526 99.3899C196.743 99.7017 197.123 99.8373 197.489 99.7424C197.57 99.7153 197.652 99.6882 197.72 99.6475L199.143 98.739C199.374 98.5899 199.631 98.4814 199.903 98.4C201.109 98.0882 202.37 98.5627 203.075 99.5797C203.509 100.176 203.672 100.922 203.55 101.654C203.428 102.359 202.994 102.997 202.384 103.376L198.655 105.749C198.425 105.898 198.167 106.007 197.896 106.088Z"
              fill="white"
            />
          </g>
          <path
            d="M215.792 99.897C216.023 98.775 216.98 98.038 218.212 98.038C219.631 98.038 220.566 98.863 220.566 100.48V102.713C220.566 102.966 220.676 103.076 220.918 103.076H221.16V104H220.863C220.159 104 219.741 103.626 219.631 103.109C219.4 103.648 218.729 104.132 217.816 104.132C216.65 104.132 215.693 103.516 215.693 102.471C215.693 101.261 216.595 100.931 217.926 100.667L219.51 100.359C219.499 99.457 218.993 99.017 218.201 99.017C217.53 99.017 217.046 99.413 216.914 99.974L215.792 99.897ZM216.804 102.449C216.804 102.867 217.167 103.208 217.948 103.208C218.839 103.208 219.532 102.592 219.532 101.525V101.272L218.267 101.492C217.442 101.646 216.793 101.701 216.804 102.449ZM226.425 100.194C226.304 99.457 225.71 99.017 225.039 99.017C224.027 99.017 223.433 99.787 223.433 101.085C223.433 102.372 224.027 103.153 225.039 103.153C225.743 103.153 226.337 102.68 226.458 101.888L227.569 101.954C227.393 103.296 226.304 104.132 225.039 104.132C223.4 104.132 222.333 102.944 222.333 101.085C222.333 99.226 223.4 98.038 225.039 98.038C226.271 98.038 227.371 98.841 227.525 100.117L226.425 100.194ZM228.664 98.17H229.599L229.632 98.962C229.852 98.368 230.248 98.038 230.82 98.038C231.337 98.038 231.645 98.368 231.832 99.105C232.03 98.445 232.492 98.038 233.086 98.038C233.977 98.038 234.373 98.786 234.373 100.458V104H233.339V100.458C233.339 99.347 233.185 98.929 232.767 98.929C232.305 98.929 232.041 99.468 232.041 100.458V104H230.996V100.458C230.996 99.347 230.831 98.929 230.369 98.929C229.951 98.929 229.709 99.468 229.709 100.458V104H228.664V98.17ZM235.48 101.085C235.48 99.226 236.547 98.038 238.175 98.038C239.484 98.038 240.661 98.885 240.749 100.975L240.76 101.393H236.591C236.679 102.504 237.24 103.153 238.175 103.153C238.769 103.153 239.297 102.812 239.55 102.229L240.672 102.317C240.331 103.439 239.33 104.132 238.175 104.132C236.547 104.132 235.48 102.944 235.48 101.085ZM236.613 100.535H239.616C239.451 99.402 238.846 99.017 238.175 99.017C237.317 99.017 236.767 99.578 236.613 100.535ZM243.99 102.658H245.376V104H243.99V102.658ZM252.808 100.194C252.687 99.457 252.093 99.017 251.422 99.017C250.41 99.017 249.816 99.787 249.816 101.085C249.816 102.372 250.41 103.153 251.422 103.153C252.126 103.153 252.72 102.68 252.841 101.888L253.952 101.954C253.776 103.296 252.687 104.132 251.422 104.132C249.783 104.132 248.716 102.944 248.716 101.085C248.716 99.226 249.783 98.038 251.422 98.038C252.654 98.038 253.754 98.841 253.908 100.117L252.808 100.194ZM257.874 104.132C256.257 104.132 255.179 102.933 255.179 101.085C255.179 99.237 256.257 98.038 257.874 98.038C259.491 98.038 260.569 99.237 260.569 101.085C260.569 102.933 259.491 104.132 257.874 104.132ZM256.279 101.085C256.279 102.372 256.862 103.153 257.874 103.153C258.886 103.153 259.469 102.372 259.469 101.085C259.469 99.787 258.886 99.017 257.874 99.017C256.862 99.017 256.279 99.787 256.279 101.085ZM261.643 98.17H262.578L262.611 98.962C262.831 98.368 263.227 98.038 263.799 98.038C264.316 98.038 264.624 98.368 264.811 99.105C265.009 98.445 265.471 98.038 266.065 98.038C266.956 98.038 267.352 98.786 267.352 100.458V104H266.318V100.458C266.318 99.347 266.164 98.929 265.746 98.929C265.284 98.929 265.02 99.468 265.02 100.458V104H263.975V100.458C263.975 99.347 263.81 98.929 263.348 98.929C262.93 98.929 262.688 99.468 262.688 100.458V104H261.643V98.17ZM268.899 104.99L272.155 95.585H273.222L269.966 104.99H268.899ZM275.153 99.897C275.384 98.775 276.341 98.038 277.573 98.038C278.992 98.038 279.927 98.863 279.927 100.48V102.713C279.927 102.966 280.037 103.076 280.279 103.076H280.521V104H280.224C279.52 104 279.102 103.626 278.992 103.109C278.761 103.648 278.09 104.132 277.177 104.132C276.011 104.132 275.054 103.516 275.054 102.471C275.054 101.261 275.956 100.931 277.287 100.667L278.871 100.359C278.86 99.457 278.354 99.017 277.562 99.017C276.891 99.017 276.407 99.413 276.275 99.974L275.153 99.897ZM276.165 102.449C276.165 102.867 276.528 103.208 277.309 103.208C278.2 103.208 278.893 102.592 278.893 101.525V101.272L277.628 101.492C276.803 101.646 276.154 101.701 276.165 102.449ZM281.815 105.65V98.17H282.772L282.805 99.028C283.124 98.39 283.729 98.038 284.565 98.038C286.259 98.038 287.04 99.457 287.04 101.085C287.04 102.713 286.259 104.132 284.565 104.132C283.773 104.132 283.19 103.813 282.86 103.208V105.65H281.815ZM282.75 101.085C282.75 102.141 283.223 103.153 284.334 103.153C285.456 103.153 285.918 102.152 285.918 101.085C285.918 100.018 285.456 99.017 284.334 99.017C283.223 99.017 282.75 100.029 282.75 101.085ZM288.411 105.65V98.17H289.368L289.401 99.028C289.72 98.39 290.325 98.038 291.161 98.038C292.855 98.038 293.636 99.457 293.636 101.085C293.636 102.713 292.855 104.132 291.161 104.132C290.369 104.132 289.786 103.813 289.456 103.208V105.65H288.411ZM289.346 101.085C289.346 102.141 289.819 103.153 290.93 103.153C292.052 103.153 292.514 102.152 292.514 101.085C292.514 100.018 292.052 99.017 290.93 99.017C289.819 99.017 289.346 100.029 289.346 101.085Z"
            fill="#A0A0A0"
          />
        </g>
        <path
          d="M27 57.5C27.2761 57.5 27.5 57.7239 27.5 58V62L25.5 60.75L23.5 62V58C23.5 57.7239 23.7239 57.5 24 57.5H27ZM32.5 60H29V58.5H31V56H23C22.4477 56 22 56.4477 22 57V59.7891C21.192 59.4355 20.6056 58.6697 20.5127 57.7559L20.5 57.5V48.25C20.5 47.0074 21.5074 46 22.75 46H32.5V60ZM22.75 47.5C22.3358 47.5 22 47.8358 22 48.25V54.71C22.2321 54.6085 22.4817 54.5394 22.7441 54.5127L23 54.5H31V47.5H22.75Z"
          fill="#A0A0A0"
        />
        <path
          d="M43.292 53.897C43.523 52.775 44.48 52.038 45.712 52.038C47.131 52.038 48.066 52.863 48.066 54.48V56.713C48.066 56.966 48.176 57.076 48.418 57.076H48.66V58H48.363C47.659 58 47.241 57.626 47.131 57.109C46.9 57.648 46.229 58.132 45.316 58.132C44.15 58.132 43.193 57.516 43.193 56.471C43.193 55.261 44.095 54.931 45.426 54.667L47.01 54.359C46.999 53.457 46.493 53.017 45.701 53.017C45.03 53.017 44.546 53.413 44.414 53.974L43.292 53.897ZM44.304 56.449C44.304 56.867 44.667 57.208 45.448 57.208C46.339 57.208 47.032 56.592 47.032 55.525V55.272L45.767 55.492C44.942 55.646 44.293 55.701 44.304 56.449ZM53.9247 54.194C53.8037 53.457 53.2097 53.017 52.5387 53.017C51.5267 53.017 50.9327 53.787 50.9327 55.085C50.9327 56.372 51.5267 57.153 52.5387 57.153C53.2427 57.153 53.8367 56.68 53.9577 55.888L55.0687 55.954C54.8927 57.296 53.8037 58.132 52.5387 58.132C50.8997 58.132 49.8327 56.944 49.8327 55.085C49.8327 53.226 50.8997 52.038 52.5387 52.038C53.7707 52.038 54.8707 52.841 55.0247 54.117L53.9247 54.194ZM56.1644 52.17H57.0994L57.1324 52.962C57.3524 52.368 57.7484 52.038 58.3204 52.038C58.8374 52.038 59.1454 52.368 59.3324 53.105C59.5304 52.445 59.9924 52.038 60.5864 52.038C61.4774 52.038 61.8734 52.786 61.8734 54.458V58H60.8394V54.458C60.8394 53.347 60.6854 52.929 60.2674 52.929C59.8054 52.929 59.5414 53.468 59.5414 54.458V58H58.4964V54.458C58.4964 53.347 58.3314 52.929 57.8694 52.929C57.4514 52.929 57.2094 53.468 57.2094 54.458V58H56.1644V52.17ZM62.9801 55.085C62.9801 53.226 64.0471 52.038 65.6751 52.038C66.9841 52.038 68.1611 52.885 68.2491 54.975L68.2601 55.393H64.0911C64.1791 56.504 64.7401 57.153 65.6751 57.153C66.2691 57.153 66.7971 56.812 67.0501 56.229L68.1721 56.317C67.8311 57.439 66.8301 58.132 65.6751 58.132C64.0471 58.132 62.9801 56.944 62.9801 55.085ZM64.1131 54.535H67.1161C66.9511 53.402 66.3461 53.017 65.6751 53.017C64.8171 53.017 64.2671 53.578 64.1131 54.535ZM70.0158 58.99L73.2718 49.585H74.3388L71.0828 58.99H70.0158ZM79.2955 52.94L80.0765 56.504L80.8135 52.17H81.9025L80.7255 58H79.5375L78.7785 54.568L78.0195 58H76.8315L75.6545 52.17H76.7435L77.4805 56.504L78.2615 52.94H79.2955ZM82.7672 55.085C82.7672 53.226 83.8342 52.038 85.4622 52.038C86.7712 52.038 87.9482 52.885 88.0362 54.975L88.0472 55.393H83.8782C83.9662 56.504 84.5272 57.153 85.4622 57.153C86.0562 57.153 86.5842 56.812 86.8372 56.229L87.9592 56.317C87.6182 57.439 86.6172 58.132 85.4622 58.132C83.8342 58.132 82.7672 56.944 82.7672 55.085ZM83.9002 54.535H86.9032C86.7382 53.402 86.1332 53.017 85.4622 53.017C84.6042 53.017 84.0542 53.578 83.9002 54.535ZM89.5279 50.19H90.5729V52.929C90.9029 52.346 91.4859 52.038 92.3219 52.038C93.9719 52.038 94.7529 53.457 94.7529 55.085C94.7529 56.713 93.9719 58.132 92.3219 58.132C91.4419 58.132 90.8479 57.78 90.5179 57.186L90.4849 58H89.5279V50.19ZM90.4849 55.085C90.4849 56.141 90.9359 57.153 92.0689 57.153C93.2019 57.153 93.6529 56.152 93.6529 55.085C93.6529 53.974 93.2019 52.973 92.0689 52.973C90.9359 52.973 90.4849 53.985 90.4849 55.085Z"
          fill="#EDEDED"
        />
        <g clipPath="url(#clip2_17_1198)">
          <path
            d="M24.8271 86.0127C24.9858 86.0385 25.1367 86.1028 25.2666 86.2002L26.7334 87.2998C26.8633 87.3972 27.0142 87.4615 27.1729 87.4873L27.333 87.5H34.5V97.5L34.4873 97.7559C34.3677 98.9323 33.4323 99.8677 32.2559 99.9873L32 100H21L20.7441 99.9873C19.5677 99.8677 18.6323 98.9323 18.5127 97.7559L18.5 97.5V86H24.667L24.8271 86.0127ZM20 92.5V97.5C20 98.0523 20.4477 98.5 21 98.5H32C32.5523 98.5 33 98.0523 33 97.5V92.5H20ZM20 91H33V89H27.333C26.8598 88.9999 26.398 88.8652 26 88.6143L25.833 88.5L24.499 87.5H20V91Z"
            fill="#A0A0A0"
          />
        </g>
        <path
          d="M47.12 92.985C46.999 92.369 46.416 92.017 45.723 92.017C45.151 92.017 44.634 92.292 44.634 92.842C44.645 93.436 45.349 93.568 45.998 93.733C47.109 93.997 48.22 94.404 48.22 95.493C48.22 96.637 47.12 97.132 45.921 97.132C44.557 97.132 43.457 96.362 43.369 95.152L44.458 95.086C44.568 95.746 45.162 96.153 45.921 96.153C46.515 96.153 47.12 96.01 47.12 95.438C47.12 94.855 46.372 94.756 45.734 94.613C44.645 94.349 43.534 93.942 43.534 92.886C43.534 91.709 44.601 91.038 45.822 91.038C47.054 91.038 48 91.775 48.187 92.919L47.12 92.985ZM53.3087 91.17V96.076H55.0467V97H50.1957V96.076H52.2527V92.094H50.1957V91.17H53.3087ZM52.1537 90.345V89.19H53.3087V90.345H52.1537ZM58.0124 89.63H59.0684V91.17H61.2574V92.094H59.0684V95.295C59.0684 95.779 59.3324 96.076 59.8164 96.076H61.2354V97H59.7614C58.5404 97 58.0124 96.362 58.0124 95.328V92.094H56.4504V91.17H58.0124V89.63ZM62.9801 94.085C62.9801 92.226 64.0471 91.038 65.6751 91.038C66.9841 91.038 68.1611 91.885 68.2491 93.975L68.2601 94.393H64.0911C64.1791 95.504 64.7401 96.153 65.6751 96.153C66.2691 96.153 66.7971 95.812 67.0501 95.229L68.1721 95.317C67.8311 96.439 66.8301 97.132 65.6751 97.132C64.0471 97.132 62.9801 95.944 62.9801 94.085ZM64.1131 93.535H67.1161C66.9511 92.402 66.3461 92.017 65.6751 92.017C64.8171 92.017 64.2671 92.578 64.1131 93.535Z"
          fill="#EDEDED"
        />
        <g clipPath="url(#clip3_17_1198)">
          <path
            d="M24.8271 113.013C24.9858 113.038 25.1367 113.103 25.2666 113.2L26.7334 114.3C26.8633 114.397 27.0142 114.462 27.1729 114.487L27.333 114.5H34.5V124.5L34.4873 124.756C34.3677 125.932 33.4323 126.868 32.2559 126.987L32 127H21L20.7441 126.987C19.5677 126.868 18.6323 125.932 18.5127 124.756L18.5 124.5V113H24.667L24.8271 113.013ZM20 119.5V124.5C20 125.052 20.4477 125.5 21 125.5H32C32.5523 125.5 33 125.052 33 124.5V119.5H20ZM20 118H33V116H27.333C26.8598 116 26.398 115.865 26 115.614L25.833 115.5L24.499 114.5H20V118Z"
            fill="#A0A0A0"
          />
        </g>
        <path
          d="M48.242 116.19V124H47.285L47.252 123.186C46.922 123.78 46.328 124.132 45.448 124.132C43.798 124.132 43.017 122.713 43.017 121.085C43.017 119.457 43.798 118.038 45.448 118.038C46.284 118.038 46.867 118.346 47.197 118.929V116.19H48.242ZM44.117 121.085C44.117 122.152 44.568 123.153 45.701 123.153C46.834 123.153 47.285 122.141 47.285 121.085C47.285 119.985 46.834 118.973 45.701 118.973C44.568 118.973 44.117 119.974 44.117 121.085ZM49.8877 119.897C50.1187 118.775 51.0757 118.038 52.3077 118.038C53.7267 118.038 54.6617 118.863 54.6617 120.48V122.713C54.6617 122.966 54.7717 123.076 55.0137 123.076H55.2557V124H54.9587C54.2547 124 53.8367 123.626 53.7267 123.109C53.4957 123.648 52.8247 124.132 51.9117 124.132C50.7457 124.132 49.7887 123.516 49.7887 122.471C49.7887 121.261 50.6907 120.931 52.0217 120.667L53.6057 120.359C53.5947 119.457 53.0887 119.017 52.2967 119.017C51.6257 119.017 51.1417 119.413 51.0097 119.974L49.8877 119.897ZM50.8997 122.449C50.8997 122.867 51.2627 123.208 52.0437 123.208C52.9347 123.208 53.6277 122.592 53.6277 121.525V121.272L52.3627 121.492C51.5377 121.646 50.8887 121.701 50.8997 122.449ZM60.3114 119.985C60.1904 119.369 59.6074 119.017 58.9144 119.017C58.3424 119.017 57.8254 119.292 57.8254 119.842C57.8364 120.436 58.5404 120.568 59.1894 120.733C60.3004 120.997 61.4114 121.404 61.4114 122.493C61.4114 123.637 60.3114 124.132 59.1124 124.132C57.7484 124.132 56.6484 123.362 56.5604 122.152L57.6494 122.086C57.7594 122.746 58.3534 123.153 59.1124 123.153C59.7064 123.153 60.3114 123.01 60.3114 122.438C60.3114 121.855 59.5634 121.756 58.9254 121.613C57.8364 121.349 56.7254 120.942 56.7254 119.886C56.7254 118.709 57.7924 118.038 59.0134 118.038C60.2454 118.038 61.1914 118.775 61.3784 119.919L60.3114 119.985ZM63.3761 116.19H64.4211V118.929C64.7621 118.324 65.4111 118.038 66.1151 118.038C67.4131 118.038 68.0511 118.995 68.0511 120.249V124H66.9951V120.579C66.9951 119.545 66.6651 118.995 65.8401 118.995C64.9821 118.995 64.4211 119.545 64.4211 120.579V124H63.3761V116.19ZM69.7408 116.19H70.7858V118.929C71.1158 118.346 71.6988 118.038 72.5348 118.038C74.1848 118.038 74.9658 119.457 74.9658 121.085C74.9658 122.713 74.1848 124.132 72.5348 124.132C71.6548 124.132 71.0608 123.78 70.7308 123.186L70.6978 124H69.7408V116.19ZM70.6978 121.085C70.6978 122.141 71.1488 123.153 72.2818 123.153C73.4148 123.153 73.8658 122.152 73.8658 121.085C73.8658 119.974 73.4148 118.973 72.2818 118.973C71.1488 118.973 70.6978 119.985 70.6978 121.085ZM78.7785 124.132C77.1615 124.132 76.0835 122.933 76.0835 121.085C76.0835 119.237 77.1615 118.038 78.7785 118.038C80.3955 118.038 81.4735 119.237 81.4735 121.085C81.4735 122.933 80.3955 124.132 78.7785 124.132ZM77.1835 121.085C77.1835 122.372 77.7665 123.153 78.7785 123.153C79.7905 123.153 80.3735 122.372 80.3735 121.085C80.3735 119.787 79.7905 119.017 78.7785 119.017C77.7665 119.017 77.1835 119.787 77.1835 121.085ZM82.8662 119.897C83.0972 118.775 84.0542 118.038 85.2862 118.038C86.7052 118.038 87.6402 118.863 87.6402 120.48V122.713C87.6402 122.966 87.7502 123.076 87.9922 123.076H88.2342V124H87.9372C87.2332 124 86.8152 123.626 86.7052 123.109C86.4742 123.648 85.8032 124.132 84.8902 124.132C83.7242 124.132 82.7672 123.516 82.7672 122.471C82.7672 121.261 83.6692 120.931 85.0002 120.667L86.5842 120.359C86.5732 119.457 86.0672 119.017 85.2752 119.017C84.6042 119.017 84.1202 119.413 83.9882 119.974L82.8662 119.897ZM83.8782 122.449C83.8782 122.867 84.2412 123.208 85.0222 123.208C85.9132 123.208 86.6062 122.592 86.6062 121.525V121.272L85.3412 121.492C84.5162 121.646 83.8672 121.701 83.8782 122.449ZM91.8819 118.17L91.9589 119.248C92.1569 118.511 92.6299 118.17 93.3999 118.17H94.5879V119.094H93.4329C92.5529 119.094 92.1569 119.578 92.1569 120.546V123.076H94.0269V124H89.6159V123.076H91.1119V119.094H89.6159V118.17H91.8819ZM101.008 116.19V124H100.051L100.018 123.186C99.6876 123.78 99.0936 124.132 98.2136 124.132C96.5636 124.132 95.7826 122.713 95.7826 121.085C95.7826 119.457 96.5636 118.038 98.2136 118.038C99.0496 118.038 99.6326 118.346 99.9626 118.929V116.19H101.008ZM96.8826 121.085C96.8826 122.152 97.3336 123.153 98.4666 123.153C99.5996 123.153 100.051 122.141 100.051 121.085C100.051 119.985 99.5996 118.973 98.4666 118.973C97.3336 118.973 96.8826 119.974 96.8826 121.085Z"
          fill="#EDEDED"
        />
        <g clipPath="url(#clip4_17_1198)">
          <path
            d="M24.8271 140.013C24.9858 140.038 25.1367 140.103 25.2666 140.2L26.7334 141.3C26.8633 141.397 27.0142 141.462 27.1729 141.487L27.333 141.5H34.5V151.5L34.4873 151.756C34.3677 152.932 33.4323 153.868 32.2559 153.987L32 154H21L20.7441 153.987C19.5677 153.868 18.6323 152.932 18.5127 151.756L18.5 151.5V140H24.667L24.8271 140.013ZM20 146.5V151.5C20 152.052 20.4477 152.5 21 152.5H32C32.5523 152.5 33 152.052 33 151.5V146.5H20ZM20 145H33V143H27.333C26.8598 143 26.398 142.865 26 142.614L25.833 142.5L24.499 141.5H20V145Z"
            fill="#A0A0A0"
          />
        </g>
        <path
          d="M43.358 152.65V145.17H44.315L44.348 146.028C44.667 145.39 45.272 145.038 46.108 145.038C47.802 145.038 48.583 146.457 48.583 148.085C48.583 149.713 47.802 151.132 46.108 151.132C45.316 151.132 44.733 150.813 44.403 150.208V152.65H43.358ZM44.293 148.085C44.293 149.141 44.766 150.153 45.877 150.153C46.999 150.153 47.461 149.152 47.461 148.085C47.461 147.018 46.999 146.017 45.877 146.017C44.766 146.017 44.293 147.029 44.293 148.085ZM52.3957 151.132C50.7787 151.132 49.7007 149.933 49.7007 148.085C49.7007 146.237 50.7787 145.038 52.3957 145.038C54.0127 145.038 55.0907 146.237 55.0907 148.085C55.0907 149.933 54.0127 151.132 52.3957 151.132ZM50.8007 148.085C50.8007 149.372 51.3837 150.153 52.3957 150.153C53.4077 150.153 53.9907 149.372 53.9907 148.085C53.9907 146.787 53.4077 146.017 52.3957 146.017C51.3837 146.017 50.8007 146.787 50.8007 148.085ZM60.3114 146.985C60.1904 146.369 59.6074 146.017 58.9144 146.017C58.3424 146.017 57.8254 146.292 57.8254 146.842C57.8364 147.436 58.5404 147.568 59.1894 147.733C60.3004 147.997 61.4114 148.404 61.4114 149.493C61.4114 150.637 60.3114 151.132 59.1124 151.132C57.7484 151.132 56.6484 150.362 56.5604 149.152L57.6494 149.086C57.7594 149.746 58.3534 150.153 59.1124 150.153C59.7064 150.153 60.3114 150.01 60.3114 149.438C60.3114 148.855 59.5634 148.756 58.9254 148.613C57.8364 148.349 56.7254 147.942 56.7254 146.886C56.7254 145.709 57.7924 145.038 59.0134 145.038C60.2454 145.038 61.1914 145.775 61.3784 146.919L60.3114 146.985ZM64.6081 143.63H65.6641V145.17H67.8531V146.094H65.6641V149.295C65.6641 149.779 65.9281 150.076 66.4121 150.076H67.8311V151H66.3571C65.1361 151 64.6081 150.362 64.6081 149.328V146.094H63.0461V145.17H64.6081V143.63ZM73.5028 146.985C73.3818 146.369 72.7988 146.017 72.1058 146.017C71.5338 146.017 71.0168 146.292 71.0168 146.842C71.0278 147.436 71.7318 147.568 72.3808 147.733C73.4918 147.997 74.6028 148.404 74.6028 149.493C74.6028 150.637 73.5028 151.132 72.3038 151.132C70.9398 151.132 69.8398 150.362 69.7518 149.152L70.8408 149.086C70.9508 149.746 71.5448 150.153 72.3038 150.153C72.8978 150.153 73.5028 150.01 73.5028 149.438C73.5028 148.855 72.7548 148.756 72.1168 148.613C71.0278 148.349 69.9168 147.942 69.9168 146.886C69.9168 145.709 70.9838 145.038 72.2048 145.038C73.4368 145.038 74.3828 145.775 74.5698 146.919L73.5028 146.985Z"
          fill="#EDEDED"
        />
        <defs>
          <filter
            id="filter0_d_17_1198"
            x="0"
            y="33"
            width="148"
            height="137"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1198"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1198"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_17_1198"
            x="174"
            y="32"
            width="138"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1198"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1198"
              result="shape"
            />
          </filter>
          <filter
            id="filter2_d_17_1198"
            x="174"
            y="126"
            width="138"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1198"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1198"
              result="shape"
            />
          </filter>
          <filter
            id="filter3_d_17_1198"
            x="174"
            y="80"
            width="138"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1198"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1198"
              result="shape"
            />
          </filter>
          <linearGradient
            id="paint0_linear_17_1198"
            x1="202.13"
            y1="49"
            x2="202.13"
            y2="55"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="white" />
            <stop offset="0.609375" stopColor="white" stopOpacity="0.57" />
            <stop offset="0.796875" stopColor="white" stopOpacity="0" />
            <stop offset="1" stopColor="white" stopOpacity="0" />
          </linearGradient>
          <linearGradient
            id="paint1_linear_17_1198"
            x1="200.701"
            y1="54.4728"
            x2="203.79"
            y2="58.4122"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="white" />
            <stop offset="0.604072" stopColor="white" stopOpacity="0" />
            <stop offset="1" stopColor="white" stopOpacity="0" />
          </linearGradient>
          <clipPath id="clip0_17_1198">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(191 44)"
            />
          </clipPath>
          <clipPath id="clip1_17_1198">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(191 92)"
            />
          </clipPath>
          <clipPath id="clip2_17_1198">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(18.5 85)"
            />
          </clipPath>
          <clipPath id="clip3_17_1198">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(18.5 112)"
            />
          </clipPath>
          <clipPath id="clip4_17_1198">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(18.5 139)"
            />
          </clipPath>
        </defs>
      </svg>
    </div>
  );
};
