/* tslint:disable */
/* eslint-disable */

/* auto-generated by NAPI-RS */

export class Package {
  name: string;
  /** The absolute path to the package root. */
  readonly absolutePath: string;
  /** The relative path from the workspace root to the package root. */
  readonly relativePath: string;
}
/**
 * Wrapper for dependents and dependencies.
 * Each are a list of package paths, relative to the workspace root.
 */
export class PackageDetails {
  /** the package's dependencies */
  readonly dependencies: Array<string>;
  /** the packages that depend on this package */
  readonly dependents: Array<string>;
}
export class PackageManager {
  /** The package manager name in lower case. */
  readonly name: string;
}
export class Workspace {
  /** The absolute path to the workspace root. */
  readonly absolutePath: string;
  /** `true` when the workspace is a multi-package workspace. */
  readonly isMultiPackage: boolean;
  /** The package manager used by the workspace. */
  readonly packageManager: PackageManager;
  /**
   * Finds the workspace root from the given path, and returns a new
   * Workspace.
   */
  static find(path?: string | undefined | null): Promise<Workspace>;
  /** Finds and returns packages within the workspace. */
  findPackages(): Promise<Array<Package>>;
  /**
   * Returns a map of packages within the workspace, its dependencies and
   * dependents. The response looks like this:
   *  {
   *    "package-path": {
   *      "dependents": ["dependent1_path", "dependent2_path"],
   *      "dependencies": ["dependency1_path", "dependency2_path"]
   *      }
   *  }
   */
  findPackagesWithGraph(): Promise<Record<string, PackageDetails>>;
  /**
   * Given a set of "changed" files, returns a set of packages that are
   * "affected" by the changes. The `files` argument is expected to be a list
   * of strings relative to the monorepo root and use the current system's
   * path separator.
   */
  affectedPackages(
    files: Array<string>,
    base?: string | undefined | null,
    optimizeGlobalInvalidations?: boolean | undefined | null
  ): Promise<Array<Package>>;
  /**
   * Given a path (relative to the workspace root), returns the
   * package that contains it.
   *
   * This is a naive implementation that simply "iterates-up". If this function is
   * expected to be called many times for files that are deep within the same
   * package, we could optimize this by caching the containing-package of
   * every ancestor.
   */
  findPackageByPath(path: string): Promise<Package>;
}
