"use client";
import { useTheme } from "next-themes";
import { useEffect, useState } from "react";
import { sizingString } from "./sizing-string";

export const CiProviders = () => {
  const { resolvedTheme } = useTheme();

  const [mounted, setMounted] = useState(false);

  useEffect(() => {
    setMounted(true);
  }, []);

  if (!mounted) return <div className={sizingString}></div>;

  if (resolvedTheme === "dark") {
    return <ProvidersDark />;
  }
  return <ProvidersLight />;
};

const ProvidersLight = () => {
  return (
    <div className={sizingString}>
      <svg
        className={sizingString}
        viewBox="0 0 307 200"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M153.75 142.5C153.945 108.329 154.055 89.1709 154.25 55"
          stroke="#8657A7"
          strokeWidth="2"
        />
        <path
          d="M97.125 49.5L97.125 81.5C97.125 94.7548 107.87 105.5 121.125 105.5L129.125 105.5C142.38 105.5 153.125 116.245 153.125 129.5L153.125 161.5"
          stroke="#CD3678"
          strokeWidth="2"
        />
        <path
          d="M211.125 49.5L211.125 81.5C211.125 94.7548 200.38 105.5 187.125 105.5L179.125 105.5C165.87 105.5 155.125 116.245 155.125 129.5L155.125 141.5"
          stroke="#3F79D5"
          strokeWidth="2"
        />
        <path
          d="M42.125 62.5002L42.125 81.5002C42.125 94.7551 52.8702 105.5 66.125 105.5L129.125 105.5C142.38 105.5 153.125 116.245 153.125 129.5L153.125 149"
          stroke="#FF1E56"
          strokeWidth="2"
        />
        <path
          d="M266.125 62.5002L266.125 81.5002C266.125 94.7551 255.38 105.5 242.125 105.5L179.125 105.5C165.87 105.5 155.125 116.245 155.125 129.5L155.125 149"
          stroke="#0196FF"
          strokeWidth="2"
        />
        <g filter="url(#filter0_d_16_1331)">
          <rect x="126" y="131" width="54" height="54" rx="27" fill="#FAFAFA" />
          <rect
            x="125.569"
            y="130.569"
            width="54.8621"
            height="54.8621"
            rx="27.431"
            stroke="black"
            strokeOpacity="0.08"
            strokeWidth="0.862069"
          />
        </g>
        <g filter="url(#filter1_d_16_1331)">
          <path
            d="M24 51C24 44.3726 29.3726 39 36 39H48C54.6274 39 60 44.3726 60 51V63C60 69.6274 54.6274 75 48 75H36C29.3726 75 24 69.6274 24 63V51Z"
            fill="#FAFAFA"
          />
          <path
            d="M48 38.5C54.9036 38.5 60.5 44.0964 60.5 51V63C60.5 69.9036 54.9036 75.5 48 75.5H36C29.0964 75.5 23.5 69.9036 23.5 63V51C23.5 44.0964 29.0964 38.5 36 38.5H48Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <g clipPath="url(#clip0_16_1331)">
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M42 49C37.58 49 34 52.5788 34 56.9973C34 60.5361 36.29 63.5251 39.47 64.5847C39.87 64.6547 40.02 64.4148 40.02 64.2049C40.02 64.0149 40.01 63.3851 40.01 62.7154C38 63.0852 37.48 62.2255 37.32 61.7757C37.23 61.5458 36.84 60.836 36.5 60.6461C36.22 60.4961 35.82 60.1262 36.49 60.1162C37.12 60.1062 37.57 60.696 37.72 60.936C38.44 62.1455 39.59 61.8057 40.05 61.5957C40.12 61.0759 40.33 60.726 40.56 60.5261C38.78 60.3262 36.92 59.6364 36.92 56.5774C36.92 55.7077 37.23 54.988 37.74 54.4282C37.66 54.2282 37.38 53.4085 37.82 52.3089C37.82 52.3089 38.49 52.099 40.02 53.1286C40.66 52.9487 41.34 52.8587 42.02 52.8587C42.7 52.8587 43.38 52.9487 44.02 53.1286C45.55 52.089 46.22 52.3089 46.22 52.3089C46.66 53.4085 46.38 54.2282 46.3 54.4282C46.81 54.988 47.12 55.6977 47.12 56.5774C47.12 59.6464 45.25 60.3262 43.47 60.5261C43.76 60.776 44.01 61.2558 44.01 62.0056C44.01 63.0752 44 63.9349 44 64.2049C44 64.4148 44.15 64.6647 44.55 64.5847C46.1381 64.0488 47.5182 63.0284 48.4958 61.6673C49.4735 60.3062 49.9996 58.6729 50 56.9973C50 52.5788 46.42 49 42 49Z"
              fill="black"
            />
          </g>
        </g>
        <g filter="url(#filter2_d_16_1331)">
          <path
            d="M80 51C80 44.3726 85.3726 39 92 39H104C110.627 39 116 44.3726 116 51V63C116 69.6274 110.627 75 104 75H92C85.3726 75 80 69.6274 80 63V51Z"
            fill="#FAFAFA"
          />
          <path
            d="M104 38.5C110.904 38.5 116.5 44.0964 116.5 51V63C116.5 69.9036 110.904 75.5 104 75.5H92C85.0964 75.5 79.5 69.9036 79.5 63V51C79.5 44.0964 85.0964 38.5 92 38.5H104Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <g clipPath="url(#clip1_16_1331)">
            <path
              d="M105.528 55.6866L105.506 55.6307L103.386 50.0989C103.343 49.9905 103.267 49.8985 103.168 49.8362C103.069 49.7749 102.954 49.7454 102.838 49.7516C102.722 49.7579 102.611 49.7995 102.519 49.871C102.429 49.9446 102.363 50.0443 102.331 50.1565L100.9 54.5352H95.1048L93.6736 50.1565C93.6426 50.0436 93.5767 49.9435 93.4855 49.8702C93.3939 49.7987 93.2826 49.7571 93.1666 49.7508C93.0506 49.7446 92.9355 49.7741 92.8368 49.8354C92.7384 49.8979 92.6621 49.9898 92.6187 50.0981L90.495 55.6274L90.4739 55.6834C90.1688 56.4806 90.1311 57.3555 90.3666 58.176C90.6021 58.9966 91.0979 59.7183 91.7794 60.2324L91.7867 60.2381L91.8062 60.2519L95.0351 62.6699L96.6325 63.8789L97.6055 64.6136C97.7194 64.7 97.8583 64.7468 98.0012 64.7468C98.1442 64.7468 98.2831 64.7 98.397 64.6136L99.37 63.8789L100.967 62.6699L104.216 60.2373L104.224 60.2308C104.904 59.7166 105.399 58.9956 105.634 58.1762C105.869 57.3567 105.832 56.4831 105.528 55.6866Z"
              fill="#E24329"
            />
            <path
              d="M105.527 55.6866L105.505 55.6307C104.473 55.8427 103.499 56.2802 102.655 56.9119L98 60.4319C99.5853 61.6311 100.965 62.6731 100.965 62.6731L104.214 60.2405L104.222 60.234C104.903 59.7198 105.398 58.9984 105.634 58.1782C105.869 57.3581 105.832 56.4837 105.527 55.6866Z"
              fill="#FC6D26"
            />
            <path
              d="M95.0342 62.6731L96.6316 63.8821L97.6047 64.6167C97.7185 64.7032 97.8575 64.7499 98.0004 64.7499C98.1433 64.7499 98.2822 64.7032 98.3961 64.6167L99.3691 63.8821L100.967 62.6731C100.967 62.6731 99.5848 61.6279 97.9995 60.4318C96.4143 61.6279 95.0342 62.6731 95.0342 62.6731Z"
              fill="#FCA326"
            />
            <path
              d="M93.3444 56.9119C92.5009 56.2789 91.5279 55.8402 90.495 55.6274L90.4739 55.6834C90.1688 56.4806 90.1311 57.3555 90.3666 58.176C90.6021 58.9966 91.0979 59.7183 91.7794 60.2324L91.7867 60.2381L91.8062 60.2519L95.0351 62.6699C95.0351 62.6699 96.4136 61.6279 98.0004 60.4286L93.3444 56.9119Z"
              fill="#FC6D26"
            />
          </g>
        </g>
        <g filter="url(#filter3_d_16_1331)">
          <path
            d="M136 51C136 44.3726 141.373 39 148 39H160C166.627 39 172 44.3726 172 51V63C172 69.6274 166.627 75 160 75H148C141.373 75 136 69.6274 136 63V51Z"
            fill="#FAFAFA"
          />
          <path
            d="M160 38.5C166.904 38.5 172.5 44.0964 172.5 51V63C172.5 69.9036 166.904 75.5 160 75.5H148C141.096 75.5 135.5 69.9036 135.5 63V51C135.5 44.0964 141.096 38.5 148 38.5H160Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M154 50L162 64H146L154 50Z"
            fill="black"
          />
        </g>
        <g filter="url(#filter4_d_16_1331)">
          <path
            d="M192 51C192 44.3726 197.373 39 204 39H216C222.627 39 228 44.3726 228 51V63C228 69.6274 222.627 75 216 75H204C197.373 75 192 69.6274 192 63V51Z"
            fill="#FAFAFA"
          />
          <path
            d="M216 38.5C222.904 38.5 228.5 44.0964 228.5 51V63C228.5 69.9036 222.904 75.5 216 75.5H204C197.096 75.5 191.5 69.9036 191.5 63V51C191.5 44.0964 197.096 38.5 204 38.5H216Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <path
            d="M219.029 54.3223C219.021 54.2562 219.011 54.1901 218.997 54.1254C218.985 54.0574 218.969 53.9901 218.95 53.9237L218.9 53.8435C218.691 53.68 218.467 53.5565 218.239 53.4473C218.05 53.3584 217.859 53.2809 217.666 53.2096C217.126 51.7131 216.2 50.3861 214.981 49.4615C213.721 48.5059 212.239 48 210.696 48C209.153 48 207.672 48.5059 206.412 49.4616C205.193 50.3861 204.266 51.7131 203.727 53.21C203.534 53.2811 203.342 53.3588 203.154 53.4473C202.926 53.5565 202.701 53.68 202.493 53.8435L202.442 53.9237C202.424 53.9903 202.409 54.0576 202.395 54.1253C202.382 54.1902 202.373 54.2561 202.363 54.3223C202.345 54.4532 202.332 54.5849 202.325 54.7169C202.312 54.9813 202.32 55.2463 202.349 55.5095C202.377 55.7732 202.426 56.0344 202.495 56.2904C202.532 56.4193 202.574 56.5463 202.623 56.6711C202.647 56.734 202.674 56.7966 202.704 56.8591C202.718 56.8902 202.734 56.9205 202.751 56.9523C202.787 57.0157 202.793 57.0281 202.809 57.0506L202.877 57.1136C202.922 57.1365 202.958 57.1539 202.999 57.173L203.117 57.2258C203.138 57.2348 203.159 57.2436 203.181 57.2526C202.646 57.7471 202.065 58.3896 201.562 59.1837L200.927 60.186L201.819 59.4031C201.834 59.3899 202.582 58.7424 203.829 58.0089L203.847 58.1523C203.765 58.1947 203.373 58.4005 203.256 58.4981C203.063 58.6585 203.054 58.9075 203.105 59.3721C203.132 59.6102 203.221 60.0725 203.342 60.4963C203.549 61.2256 203.701 61.3546 203.835 61.3848C203.895 61.3992 203.973 61.4058 204.06 61.4058C204.299 61.4058 204.605 61.3593 204.805 61.299C205.039 62.0274 205.371 62.685 205.775 63.2621C205.756 63.2674 205.736 63.2737 205.717 63.2792C205.473 63.1664 204.623 62.7724 204.337 62.6438L203.739 62.3748L204.093 62.9266C204.119 62.9664 204.729 63.9176 205.227 64.5587C205.692 65.1566 206.33 65.7686 207.534 65.7686C207.679 65.7686 207.83 65.7592 207.986 65.742C208.345 65.7008 208.615 65.6684 208.82 65.6421C210.083 66.1063 211.476 66.1349 212.799 65.6339C213.145 65.5023 213.478 65.3379 213.793 65.1429C214.302 65.0205 214.86 64.8877 215.135 64.8103C215.18 64.7983 215.235 64.7852 215.292 64.7716C215.676 64.6834 216.317 64.5345 216.659 63.8504C217.004 63.1602 217.566 62.1026 217.572 62.0918L217.835 61.5985L217.323 61.8211C217.295 61.8335 216.647 62.116 216.309 62.2927C216.544 61.7535 216.682 61.3072 216.73 61.1358C216.918 61.1813 217.198 61.1755 217.404 61.1755C217.505 61.1755 217.609 61.1579 217.677 61.1407C217.811 61.1067 217.914 61.0178 218.108 60.2653C218.221 59.8278 218.302 59.3516 218.325 59.1067C218.368 58.6303 218.354 58.3749 218.159 58.2138C218.062 58.1337 217.778 57.9806 217.633 57.9052C217.714 57.8706 217.754 57.8808 217.757 57.8816L217.888 57.3838C217.935 57.364 217.983 57.3442 218.039 57.3229C218.118 57.2913 218.198 57.26 218.277 57.2258L218.394 57.1729C218.435 57.1538 218.471 57.1365 218.516 57.1135L218.585 57.0505C218.599 57.028 218.607 57.0156 218.616 56.9984C218.66 56.9204 218.675 56.8901 218.689 56.8591C218.719 56.7965 218.745 56.734 218.77 56.671C218.819 56.5462 218.861 56.4192 218.898 56.2904C218.967 56.0343 219.016 55.7732 219.045 55.5094C219.074 55.2464 219.081 54.9814 219.067 54.7169C219.061 54.5848 219.048 54.4532 219.029 54.3223Z"
            fill="#0E0F0D"
          />
          <path
            d="M211.523 64.5744C211.427 64.5889 211.33 64.6007 211.235 64.6084C211.172 64.6114 211.107 64.6176 211.048 64.6176L211.025 64.6182C211.1 64.4518 211.157 64.3224 211.199 64.2245C211.287 64.3224 211.398 64.4435 211.523 64.5744Z"
            fill="#E1C5A2"
          />
          <path
            d="M211.407 57.1365C211.255 57.2592 211.096 57.3735 210.93 57.4737L210.377 57.8074C210.03 57.8498 209.729 57.9355 209.712 57.9407C209.702 57.9429 209.692 57.9476 209.683 57.953C209.656 57.9692 209.636 57.995 209.626 58.0254L209.063 59.8816L206.052 60.5512L205.103 59.8869L204.827 57.6518C205.366 57.5529 206.086 57.4387 206.951 57.3416C206.857 57.4543 206.768 57.5709 206.683 57.6912L206.168 58.4305L206.918 57.9305C206.93 57.9227 207.407 57.6085 208.188 57.2262C209.039 57.1624 209.893 57.1304 210.746 57.1302C210.971 57.1302 211.191 57.1329 211.407 57.1366V57.1365ZM206.72 59.6545C206.934 59.5388 207.175 59.5558 207.554 59.5567C207.594 59.5574 207.636 59.557 207.68 59.5558C207.717 59.5558 207.754 59.5551 207.794 59.554C208.184 59.5501 208.508 59.587 208.502 58.9752C208.496 58.3633 208.224 57.8685 207.834 57.8723C207.445 57.8758 207.068 58.3772 207.091 58.9888C207.097 59.1481 207.121 59.2632 207.158 59.3458C206.819 59.4312 206.725 59.6413 206.72 59.6545ZM216.626 57.6445L216.354 59.545L215.398 60.2148L212.391 59.873L211.83 58.0253C211.824 58.0052 211.813 57.9869 211.798 57.9721C211.783 57.9573 211.764 57.9465 211.744 57.9407C211.725 57.9351 211.353 57.8286 210.958 57.7945L211.031 57.7898C211.093 57.7851 212.13 57.6581 213.369 57.2313C214.74 57.3365 215.86 57.5048 216.626 57.6445ZM214.704 59.4036C214.7 59.3888 214.618 59.143 214.256 59.1862C214.297 59.0952 214.316 58.9724 214.303 58.8039C214.255 58.1933 213.9 57.7079 213.51 57.7217C213.121 57.7352 212.871 58.2414 212.893 58.8541C212.914 59.4653 213.241 59.4611 213.631 59.4472C214.154 59.4373 214.441 59.2766 214.704 59.4036Z"
            fill="#A89983"
          />
          <path
            d="M213.676 58.3042C213.677 58.357 213.657 58.408 213.62 58.446C213.583 58.484 213.533 58.5059 213.48 58.5069C213.454 58.5074 213.428 58.5027 213.404 58.4931C213.38 58.4836 213.357 58.4693 213.339 58.4511C213.32 58.433 213.305 58.4113 213.294 58.3873C213.284 58.3633 213.278 58.3375 213.278 58.3114C213.277 58.2853 213.282 58.2593 213.292 58.235C213.301 58.2107 213.315 58.1885 213.333 58.1697C213.352 58.1508 213.373 58.1358 213.397 58.1253C213.421 58.1149 213.447 58.1093 213.473 58.1088C213.499 58.1082 213.525 58.1128 213.55 58.1224C213.574 58.1319 213.596 58.1462 213.615 58.1644C213.634 58.1825 213.649 58.2042 213.659 58.2283C213.67 58.2523 213.675 58.2781 213.676 58.3043M208.094 58.4507C208.095 58.5034 208.076 58.5544 208.039 58.5927C208.003 58.6309 207.953 58.6532 207.9 58.6547C207.874 58.6555 207.848 58.6511 207.824 58.6418C207.799 58.6324 207.777 58.6184 207.758 58.6004C207.739 58.5823 207.723 58.5608 207.713 58.5368C207.702 58.5129 207.696 58.4871 207.695 58.4608C207.695 58.4347 207.699 58.4087 207.709 58.3842C207.718 58.3598 207.732 58.3375 207.75 58.3185C207.768 58.2996 207.79 58.2844 207.814 58.2738C207.838 58.2632 207.863 58.2574 207.89 58.2568C207.942 58.2555 207.994 58.2751 208.032 58.3115C208.07 58.3478 208.092 58.3979 208.094 58.4507Z"
            fill="white"
          />
          <path
            d="M217.938 58.4806C217.891 58.4417 217.734 58.352 217.581 58.2693L217.329 60.0359C217.327 60.0529 217.321 60.0692 217.312 60.0839C217.302 60.0985 217.291 60.1112 217.276 60.1212L216.916 60.3734C216.907 60.416 216.901 60.4517 216.894 60.485C217.249 60.5722 217.593 60.3167 217.786 60.1324C217.875 59.7843 217.953 59.3712 217.98 59.0754C218.021 58.6171 217.985 58.5186 217.938 58.4806ZM212.369 65.1919C212.135 65.1087 211.921 64.9729 211.734 64.7884C211.718 64.7725 211.704 64.7573 211.688 64.7418C211.542 64.7716 211.394 64.7928 211.246 64.8053C211.182 64.8082 211.122 64.8136 211.056 64.8136L210.958 64.8144L210.92 64.8136C210.696 65.1457 210.321 65.3282 210.026 65.4254C210.901 65.5756 211.864 65.3458 212.369 65.1919ZM204.665 60.8655C204.658 60.8389 204.649 60.8125 204.642 60.7858L204.173 60.4578C204.159 60.4476 204.147 60.4345 204.138 60.4194C204.128 60.4042 204.123 60.3873 204.12 60.3698L203.892 58.5148C203.723 58.605 203.527 58.7163 203.476 58.7599C203.43 58.7972 203.396 58.8923 203.445 59.3343C203.482 59.6666 203.599 60.1771 203.718 60.5596C203.955 60.7411 204.304 60.9324 204.665 60.8655ZM211.669 60.7809C211.644 60.7781 211.621 60.7681 211.602 60.7523C211.583 60.7365 211.569 60.7154 211.562 60.6918L210.984 58.7867C210.887 58.774 210.801 58.7669 210.729 58.7669C210.656 58.7669 210.57 58.774 210.473 58.7867L209.911 60.637C209.905 60.6583 209.893 60.6775 209.876 60.6926C209.86 60.7078 209.84 60.7183 209.818 60.7231L209.549 60.783C209.527 60.8779 209.449 61.0172 209.2 61.0935C208.798 61.2162 206.253 61.9749 205.962 61.9336C205.793 61.9098 205.47 61.7319 205.232 61.5881C205.136 61.3633 205.084 61.2105 205.071 61.1743V61.1736L205.071 61.1743C205.105 61.273 205.437 62.229 206.112 63.1642C206.835 62.951 207.46 62.7523 207.66 62.6891C208.067 62.0615 208.646 61.4388 209.058 61.4176C209.131 61.4139 209.203 61.412 209.276 61.4119C209.478 61.4119 209.67 61.4262 209.849 61.4473C209.697 61.3095 209.666 61.1483 209.644 61.0767C209.644 61.0767 210.17 61.4881 210.839 61.4016C211.509 61.3158 211.924 60.93 211.924 60.93L211.938 60.8114L211.669 60.7809"
            fill="#E1C5A2"
          />
          <path
            d="M212.212 61.022C212.073 60.9861 211.986 60.9289 211.93 60.8692L211.923 60.9301C211.923 60.9301 211.921 61.2112 211.63 61.429C212.191 61.2591 212.423 61.2015 212.582 61.2015C212.757 61.2015 212.843 61.2746 212.919 61.3387C212.933 61.3506 212.948 61.3632 212.965 61.3766C213.333 61.6665 213.7 61.9575 214.066 62.2496C214.242 62.2699 214.799 62.3336 215.15 62.3656C215.352 62.3845 215.535 62.3997 215.714 62.3997C215.772 62.3997 215.826 62.3977 215.878 62.3942C216.063 62.0399 216.233 61.6481 216.384 61.216C216.177 61.3615 215.704 61.68 215.483 61.721C215.195 61.775 212.618 61.1274 212.212 61.022Z"
            fill="#E1C5A2"
          />
          <path
            d="M218.696 54.3596C218.691 54.2987 218.684 54.238 218.677 54.1774C218.672 54.1341 218.665 54.091 218.658 54.0481C218.495 53.9112 218.31 53.7893 218.117 53.679C217.909 53.5566 217.69 53.4477 217.468 53.3464C217.247 53.2419 217.019 53.1474 216.791 53.0554C216.677 53.0088 216.562 52.9641 216.446 52.9214C216.331 52.8764 216.215 52.8344 216.098 52.792C216.343 52.8326 216.585 52.8885 216.825 52.9502C216.982 52.9902 217.137 53.0356 217.292 53.0842C216.192 50.2117 213.565 48.3413 210.696 48.3413C207.827 48.3413 205.2 50.2118 204.101 53.0842C204.256 53.0356 204.411 52.9902 204.567 52.9502C204.807 52.8884 205.05 52.8326 205.295 52.7921C205.177 52.8344 205.062 52.8764 204.946 52.9215C204.83 52.9643 204.716 53.009 204.602 53.0554C204.373 53.1474 204.146 53.2419 203.925 53.3464C203.702 53.4477 203.484 53.5566 203.275 53.679C203.083 53.7893 202.898 53.9112 202.735 54.0481C202.728 54.0911 202.722 54.1342 202.716 54.1774C202.708 54.238 202.702 54.2988 202.697 54.3596C202.686 54.4821 202.681 54.605 202.681 54.728C202.678 54.9742 202.695 55.2204 202.726 55.4638C202.76 55.7081 202.805 55.9508 202.871 56.1856C202.903 56.3024 202.94 56.4176 202.983 56.5308C203.005 56.5868 203.028 56.6423 203.053 56.6957C203.065 56.7224 203.077 56.7488 203.09 56.7741L203.106 56.8039C203.124 56.813 203.143 56.8226 203.161 56.8312L203.27 56.8833C203.331 56.9113 203.415 56.9513 203.485 56.9824C203.489 56.9789 203.493 56.9753 203.496 56.9719L203.293 56.1995C203.336 56.1879 203.721 56.0884 204.385 55.9618C204.331 55.9518 204.278 55.9404 204.225 55.9277C204.074 55.8899 203.924 55.8441 203.78 55.7858C203.708 55.7554 203.638 55.7225 203.57 55.6844C203.503 55.6456 203.437 55.602 203.386 55.5438C204.115 55.7819 205.621 55.6743 206.961 55.5357C208.185 55.4094 209.413 55.3278 210.647 55.3251C211.881 55.3278 213.11 55.4094 214.334 55.5357C215.673 55.6743 217.18 55.7819 217.909 55.5438C217.858 55.6021 217.791 55.6456 217.725 55.6844C217.657 55.7224 217.586 55.7555 217.515 55.7858C217.37 55.8441 217.222 55.8899 217.07 55.9277C217.048 55.933 217.025 55.9377 217.003 55.9428C217.731 56.0777 218.154 56.1875 218.199 56.1995L218.006 56.9352C218.045 56.9182 218.084 56.9011 218.122 56.8832L218.232 56.8311C218.25 56.8225 218.269 56.8129 218.287 56.8039L218.302 56.774C218.315 56.7488 218.328 56.7223 218.34 56.6956C218.364 56.6423 218.388 56.5867 218.409 56.5307C218.452 56.4174 218.489 56.3023 218.522 56.1855C218.588 55.9507 218.633 55.7079 218.666 55.4637C218.698 55.2203 218.715 54.9741 218.712 54.7279C218.712 54.605 218.706 54.4821 218.696 54.3596"
            fill="#E0D896"
          />
          <path
            d="M213.715 52.9307C213.726 53.2593 213.718 53.8556 213.565 54.4135C213.559 54.4348 213.56 54.4571 213.565 54.4777C213.37 54.4573 213.175 54.4393 212.98 54.4237C213.199 53.9651 213.247 53.4769 213.257 53.3048C213.425 53.1856 213.592 53.0422 213.715 52.9307ZM208.137 53.3048C208.147 53.4768 208.194 53.9639 208.413 54.4225C208.218 54.438 208.023 54.4559 207.828 54.4766C207.834 54.4568 207.834 54.4349 207.828 54.4136C207.676 53.8565 207.668 53.2602 207.678 52.9308C207.801 53.0422 207.968 53.1856 208.137 53.3048ZM216.11 54.9329C216.109 54.9384 216.108 54.9439 216.106 54.9492C216.127 54.9554 216.148 54.9617 216.17 54.9686C216.35 55.0277 216.53 55.0895 216.703 55.1691C216.415 54.9821 216.233 54.4428 216.131 54.0305C216.159 54.5702 216.113 54.9125 216.11 54.9329ZM207.438 52.827L205.577 53.3564C205.465 54.0804 205.499 54.6334 205.517 54.8253L205.527 54.8196C205.527 54.8196 205.587 54.0309 205.711 53.7282C205.775 53.5728 206.164 53.4737 206.461 53.4027C206.759 53.332 207.234 53.1903 207.326 53.6082C207.383 53.8665 207.461 54.0812 207.536 54.2396C207.416 53.6654 207.424 53.104 207.438 52.827ZM213.955 52.827C213.97 53.1148 213.977 53.7096 213.842 54.3067C213.927 54.1445 214.021 53.9052 214.086 53.6082C214.178 53.1903 214.653 53.332 214.95 53.4028C215.248 53.4738 215.637 53.5728 215.701 53.7282C215.806 53.9844 215.865 54.5884 215.881 54.7681C215.899 54.5371 215.918 54.018 215.817 53.3563L213.955 52.827ZM208.122 52.9882C208.187 53.0408 208.255 53.0908 208.324 53.1382C208.357 53.1608 208.377 53.1976 208.377 53.2373C208.378 53.2434 208.392 53.8567 208.663 54.379C208.667 54.3868 208.67 54.3953 208.672 54.4034C209.346 54.3576 210.022 54.339 210.697 54.3386C211.371 54.339 212.047 54.3588 212.721 54.405C212.724 54.3961 212.726 54.3875 212.731 54.379C213.002 53.8567 213.016 53.2434 213.016 53.2373C213.017 53.2177 213.022 53.1985 213.031 53.1813C213.04 53.164 213.053 53.1493 213.07 53.1382C213.136 53.0924 213.201 53.0441 213.265 52.9933L213.273 52.9695C213.414 51.5977 213.155 50.3335 212.991 49.7089C212.983 50.136 212.881 53.7955 211.973 53.7955H209.467C208.502 53.7955 208.425 49.6695 208.425 49.6695L208.375 49.816C208.211 50.4739 207.985 51.6832 208.122 52.9882ZM205.287 54.9489C205.287 54.9435 205.285 54.9384 205.284 54.9329C205.281 54.9125 205.234 54.5698 205.262 54.0295C205.161 54.4422 204.978 54.9824 204.689 55.1693C204.862 55.0893 205.043 55.0274 205.224 54.9683C205.245 54.9617 205.266 54.9554 205.287 54.9489Z"
            fill="#D7C184"
          />
          <path
            d="M216.894 60.485C216.879 60.5662 216.861 60.647 216.841 60.7271C217.048 60.7753 217.386 60.8127 217.547 60.7812C217.616 60.706 217.706 60.4454 217.786 60.1323C217.593 60.3167 217.248 60.5722 216.894 60.4849M209.486 65.5447C209.98 65.6799 210.484 65.7386 210.981 65.7057C211.48 65.6718 212.127 65.5642 212.814 65.2853C212.662 65.2743 212.512 65.2429 212.369 65.192C211.864 65.3459 210.901 65.5757 210.026 65.4256C209.794 65.5018 209.613 65.5255 209.595 65.5277C209.558 65.5319 209.528 65.537 209.486 65.5448M204.698 60.9762C204.687 60.9395 204.676 60.9024 204.665 60.8655C204.304 60.9324 203.955 60.7411 203.718 60.5598C203.795 60.8053 203.872 60.9983 203.93 61.057C204.109 61.0883 204.504 61.0334 204.698 60.9762ZM205.232 61.5881C205.47 61.7319 205.793 61.9099 205.962 61.9336C206.252 61.9748 208.798 61.2162 209.2 61.0935C209.449 61.0172 209.526 60.8779 209.549 60.783L205.877 61.6007C205.868 61.6024 205.859 61.6033 205.849 61.6034H205.849C205.824 61.6034 205.798 61.5956 205.777 61.5806L205.634 61.4808L205.205 61.1804V61.1798L205.032 61.0589C205.035 61.0687 205.038 61.0785 205.041 61.0881C205.051 61.1166 205.061 61.1455 205.071 61.1735V61.1742C205.083 61.2105 205.136 61.3633 205.232 61.5879M216.496 60.8827C216.52 60.7959 216.543 60.7081 216.564 60.6195L216.436 60.7091L216.093 60.9494L215.722 61.2095C215.703 61.2227 215.681 61.2306 215.658 61.2323C215.65 61.2328 215.643 61.2326 215.635 61.2318L211.937 60.8114L211.931 60.869C211.986 60.9288 212.074 60.986 212.213 61.0219C212.619 61.1273 215.195 61.7748 215.483 61.7207C215.705 61.6798 216.178 61.3613 216.385 61.2158C216.387 61.2107 216.389 61.2058 216.39 61.2009C216.427 61.0953 216.462 60.9892 216.496 60.8827Z"
            fill="#9F8F78"
          />
          <path
            d="M212.583 55.9008C212.554 55.9384 212.522 55.9797 212.488 56.0227C212.313 56.2446 212.069 56.5277 211.781 56.8054C211.436 56.7946 211.091 56.7892 210.746 56.7892C210.16 56.7892 209.598 56.8046 209.064 56.8303C209.819 56.5176 210.725 56.2119 211.706 56.0285C211.996 55.9731 212.289 55.9306 212.583 55.9008ZM208.17 56.2384C207.9 56.4276 207.596 56.6687 207.302 56.9616C206.647 57.027 205.994 57.1119 205.345 57.2164C206.18 56.8327 207.133 56.4792 208.17 56.2384ZM217.394 57.797L217.087 59.9451L215.616 60.9759L211.779 60.5396L211.202 58.6376C211.195 58.6149 211.182 58.5947 211.164 58.5791C211.146 58.5635 211.124 58.5532 211.101 58.5494C210.959 58.5265 210.833 58.5153 210.728 58.5153C210.623 58.5153 210.498 58.5265 210.355 58.5494C210.332 58.5534 210.31 58.5638 210.292 58.5794C210.274 58.5949 210.261 58.6151 210.254 58.6376L209.691 60.4934L205.876 61.3422L204.364 60.2831L204.066 57.8723C204.132 57.8356 204.198 57.7991 204.264 57.7627C204.357 57.7425 204.463 57.7212 204.579 57.6991L204.86 59.974C204.864 60.0094 204.884 60.0409 204.913 60.0612L205.953 60.7901C205.974 60.8045 206 60.8127 206.025 60.8127C206.034 60.8127 206.043 60.8114 206.053 60.8096L209.19 60.1117C209.2 60.1091 209.211 60.1052 209.221 60.1003C209.25 60.0847 209.273 60.0581 209.282 60.0252L209.848 58.1655C209.999 58.1268 210.387 58.0358 210.728 58.0358C211.069 58.0358 211.457 58.1268 211.609 58.1655L212.174 60.0252C212.188 60.0733 212.23 60.1084 212.28 60.1141L215.417 60.4705C215.447 60.4741 215.478 60.4657 215.503 60.4482L216.544 59.7207C216.572 59.7004 216.591 59.669 216.596 59.6348L216.874 57.6909C217.082 57.7308 217.257 57.7674 217.394 57.797ZM217.781 56.4496L217.511 57.4741C216.959 57.3523 215.746 57.1132 214.095 56.9523C214.634 56.7223 215.184 56.4342 215.685 56.0732C216.668 56.212 217.389 56.361 217.781 56.4496ZM203.712 56.4496L203.787 56.7333C203.97 56.5875 204.158 56.4485 204.352 56.3166C204.087 56.3673 203.872 56.4135 203.712 56.4496Z"
            fill="#6E6A67"
          />
          <path
            d="M214.304 55.8783C213.891 55.8548 213.478 55.8351 213.064 55.8179C213.018 55.8862 212.97 55.9536 212.921 56.02C212.7 56.3199 212.263 56.8666 211.703 57.3356C212.124 57.2021 213.796 56.6413 214.643 55.8991C214.53 55.8918 214.417 55.8848 214.304 55.8783ZM211.275 55.7691L211.276 55.7687C211.067 55.766 210.857 55.7637 210.647 55.7629H210.647C210.339 55.7638 210.031 55.7677 209.722 55.773L209.154 56.0426C209.151 56.0438 209.148 56.0454 209.145 56.0473C209.06 56.0889 208.313 56.4656 207.61 57.1378C207.672 57.1054 207.737 57.0718 207.804 57.0378C208.189 56.7794 209.214 56.1677 210.808 55.7645C210.964 55.7655 211.119 55.7664 211.275 55.7691ZM207.78 55.8378C207.516 55.8499 207.253 55.8634 206.99 55.8783C206.685 55.8954 206.381 55.916 206.077 55.9389C205.925 55.9505 205.774 55.9635 205.623 55.9792C205.58 55.9835 205.537 55.9882 205.494 55.9937C205.097 56.231 203.577 57.1851 202.533 58.4337C202.551 58.4121 202.57 58.3907 202.588 58.3693C204.521 56.72 206.641 56.0781 207.78 55.8378ZM216.525 62.6201L216.491 62.638C216.297 62.74 216.043 62.7898 215.714 62.7898C215.519 62.7898 215.327 62.7735 215.115 62.7543C214.691 62.7155 213.973 62.631 213.966 62.6296L213.911 62.6239L213.867 62.5888C213.861 62.5845 213.232 62.083 212.724 61.6834C212.703 61.6667 212.684 61.6507 212.667 61.6372C212.614 61.5914 212.614 61.5914 212.582 61.5914C212.418 61.5914 211.945 61.7385 210.907 62.0601L210.843 62.0805L210.78 62.0565C210.773 62.0547 210.092 61.8022 209.276 61.8022C209.209 61.8022 209.142 61.8039 209.077 61.8071C208.996 61.8113 208.537 62.0292 207.95 62.9573L207.912 63.0172L207.845 63.0388C207.835 63.042 206.825 63.3678 205.754 63.6742L205.685 63.6937L205.618 63.6632C205.612 63.6609 205.193 63.4663 204.795 63.2836C204.824 63.2972 204.854 63.3106 204.883 63.3243C205.277 63.6639 206.03 64.3172 206.114 64.4077C206.125 64.4207 206.142 64.4367 206.161 64.4547C206.141 64.4326 206.122 64.4102 206.104 64.3873L206.103 64.3865L206.103 64.3866C206.277 64.5512 206.471 64.6934 206.682 64.7935C206.788 64.8432 206.899 64.8816 207.011 64.9003C207.068 64.9096 207.123 64.9142 207.181 64.9142C207.239 64.9142 207.299 64.9125 207.358 64.9096C207.593 64.8975 207.831 64.8795 208.068 64.8565C208.305 64.8352 208.542 64.8115 208.778 64.7828C209.015 64.7574 209.251 64.7276 209.485 64.6913C209.602 64.6742 209.719 64.6548 209.833 64.6296C209.889 64.6164 209.947 64.6018 209.991 64.5819C210.032 64.5626 210.081 64.5237 210.124 64.4866C210.212 64.4108 210.297 64.3267 210.381 64.2428C210.466 64.1583 210.549 64.0724 210.63 63.9852C210.769 63.8399 210.888 63.6857 211.022 63.5362C211.039 63.5176 211.057 63.4978 211.075 63.4786C211.075 63.479 211.075 63.479 211.075 63.479L211.077 63.4807C211.105 63.5008 211.133 63.5212 211.16 63.5427C211.322 63.6632 211.488 63.7937 211.649 63.9063C211.857 64.0521 212.067 64.1982 212.284 64.3197C212.339 64.3499 212.395 64.3782 212.448 64.3959C212.455 64.3984 212.461 64.3996 212.466 64.4004C212.47 64.4028 212.485 64.4051 212.486 64.4051C212.497 64.4067 212.511 64.4074 212.525 64.4083C212.554 64.4087 212.584 64.4074 212.615 64.406C212.737 64.3974 212.861 64.3796 212.986 64.3601C213.234 64.3214 213.484 64.2766 213.731 64.227C213.979 64.1795 214.227 64.1286 214.474 64.0738C214.721 64.0212 214.967 63.9639 215.213 63.9019C215.334 63.8692 215.456 63.8389 215.565 63.7868C215.675 63.7352 215.778 63.6644 215.873 63.5832C216.064 63.4204 216.225 63.2185 216.359 62.9986L216.358 62.9993C216.424 62.8775 216.48 62.7507 216.525 62.6201ZM211.891 50.9385H212.329V50.0506H209.132V50.9385H209.57V50.4876H210.473V53.2299H210.101V53.7389H211.36V53.2299H210.987V50.4876H211.891V50.9385Z"
            fill="#93232C"
          />
          <path
            d="M215.198 55.9384C215.198 55.9379 215.197 55.9377 215.196 55.9376C215.015 55.924 214.834 55.9114 214.653 55.8997L214.642 55.8991C213.796 56.6413 212.124 57.2021 211.703 57.3356C211.694 57.3426 211.686 57.3495 211.678 57.3564C212.221 57.2587 213.031 57.065 213.872 56.6926C214.286 56.5095 214.707 56.2833 215.107 56.0038C215.138 55.9823 215.168 55.9598 215.198 55.9384ZM210.808 55.7645C209.214 56.1675 208.189 56.7793 207.804 57.0376C208.159 56.857 208.521 56.6896 208.888 56.5357C208.932 56.5173 208.977 56.499 209.021 56.4808C209.035 56.4751 209.049 56.4695 209.063 56.4638C209.1 56.4489 209.137 56.4342 209.175 56.4192C209.195 56.4111 209.216 56.4028 209.237 56.3947C209.271 56.3815 209.305 56.3684 209.339 56.3553C209.365 56.3455 209.39 56.3357 209.416 56.3261C209.448 56.3141 209.479 56.3023 209.511 56.2906C209.541 56.2796 209.571 56.2687 209.601 56.2579C209.631 56.2471 209.66 56.2366 209.69 56.2259C209.724 56.214 209.758 56.2022 209.792 56.1901C209.82 56.1808 209.847 56.1714 209.874 56.1621C209.914 56.1486 209.955 56.1351 209.995 56.1217C210.018 56.1143 210.04 56.1069 210.062 56.0996C210.126 56.079 210.191 56.0585 210.255 56.0387C210.397 55.9952 210.541 55.9538 210.688 55.9139C210.883 55.8609 211.078 55.8126 211.275 55.769C211.119 55.7664 210.964 55.7655 210.808 55.7645ZM207.78 55.8378C206.641 56.078 204.521 56.72 202.588 58.3693C202.57 58.3906 202.551 58.412 202.533 58.4337C203.516 57.7506 205.205 56.7351 207.293 56.1174C207.36 56.0974 207.428 56.078 207.497 56.0588C207.85 55.9599 208.206 55.8754 208.566 55.8056C208.304 55.8149 208.042 55.8258 207.78 55.8378ZM216.902 62.438C216.882 62.4472 216.862 62.4565 216.842 62.4659C216.831 62.4709 216.821 62.4759 216.81 62.4808L216.784 62.4931L216.744 62.512C216.739 62.5148 216.733 62.5173 216.727 62.5202C216.712 62.5273 216.698 62.5342 216.683 62.5414L216.673 62.5462C216.658 62.5541 216.642 62.5617 216.627 62.5693L216.622 62.5716C216.588 62.5884 216.556 62.6046 216.525 62.62C216.48 62.7507 216.424 62.8777 216.358 62.9996L216.358 62.9987C216.358 62.9991 216.358 62.9994 216.358 63C216.224 63.219 216.064 63.4203 215.873 63.5829C215.778 63.6641 215.675 63.7349 215.564 63.7865C215.456 63.8387 215.334 63.8688 215.212 63.9016C214.968 63.9632 214.721 64.0211 214.474 64.0735C214.227 64.1282 213.979 64.1793 213.731 64.2267C213.483 64.2765 213.234 64.3211 212.986 64.3598C212.861 64.3793 212.737 64.3971 212.614 64.4056C212.584 64.4073 212.554 64.4081 212.524 64.4079C212.512 64.4074 212.499 64.4063 212.486 64.4047C212.479 64.4041 212.473 64.4026 212.466 64.4001C212.46 64.3993 212.454 64.3978 212.448 64.3955C212.394 64.378 212.338 64.3495 212.284 64.3194C212.067 64.1977 211.857 64.0518 211.649 63.906C211.488 63.7933 211.321 63.6628 211.16 63.5424L211.146 63.5623L211.147 63.5634C211.157 63.5725 211.167 63.5809 211.177 63.5897L211.176 63.5893C211.169 63.5837 211.162 63.5783 211.155 63.5733L211.29 63.7349C211.291 63.7354 211.296 63.7416 211.306 63.7532C211.375 63.8344 211.664 64.1699 212.007 64.5105C212.269 64.7696 212.584 64.9005 212.946 64.9005C213.069 64.9005 213.199 64.8843 213.33 64.8531C213.452 64.8233 213.584 64.7919 213.719 64.7592C214.12 64.6638 214.564 64.5574 214.859 64.4808C214.879 64.4756 214.898 64.4707 214.916 64.4658C214.958 64.4548 214.996 64.4447 215.03 64.4353C215.087 64.4193 215.145 64.405 215.204 64.3923C215.561 64.3093 216.05 64.1959 216.309 63.6767C216.387 63.5219 216.465 63.3675 216.545 63.2135C216.674 62.9615 216.805 62.71 216.937 62.459C216.937 62.4589 216.937 62.4589 216.937 62.4589L216.963 62.4097L216.902 62.438ZM211.046 63.5579L211.022 63.5359C210.888 63.6855 210.769 63.8397 210.63 63.985C210.549 64.0723 210.466 64.1581 210.381 64.2426C210.297 64.3265 210.212 64.4109 210.124 64.4864C210.081 64.5235 210.032 64.5625 209.991 64.5817C209.947 64.6016 209.889 64.6162 209.833 64.6294C209.719 64.6547 209.602 64.674 209.485 64.6912C209.251 64.7274 209.015 64.7573 208.778 64.7826C208.542 64.8113 208.305 64.835 208.068 64.8563C207.831 64.8793 207.593 64.8973 207.358 64.9095C207.299 64.9122 207.239 64.9141 207.181 64.9141C207.123 64.9141 207.068 64.9095 207.011 64.9001C206.899 64.8815 206.788 64.8429 206.682 64.7934C206.471 64.6933 206.277 64.551 206.103 64.3865L206.104 64.387C206.127 64.4159 206.153 64.443 206.178 64.4705C206.172 64.465 206.166 64.4595 206.161 64.4544C206.142 64.4364 206.125 64.4205 206.114 64.4075C206.03 64.3169 205.276 63.6637 204.883 63.324C204.853 63.3103 204.824 63.297 204.795 63.2833C204.869 63.3935 204.944 63.5033 205.02 63.6125C205.136 63.78 205.254 63.9457 205.375 64.1096C205.427 64.18 205.48 64.2498 205.534 64.319C205.962 64.8694 206.5 65.3781 207.533 65.3781C207.663 65.3781 207.8 65.3701 207.942 65.3541C207.975 65.3506 208.007 65.3469 208.038 65.3431C208.069 65.3397 208.098 65.3364 208.127 65.333C209.026 65.2297 209.272 65.1856 209.409 65.162C209.444 65.1559 209.475 65.1505 209.507 65.1457C209.52 65.1439 209.533 65.1419 209.547 65.14C209.552 65.1396 209.856 65.1006 210.153 64.956C210.357 64.8567 210.559 64.7072 210.657 64.4863C210.906 63.9301 210.956 63.7971 210.958 63.7922L211.046 63.5579Z"
            fill="#731B2A"
          />
          <path
            d="M213.48 58.507C213.533 58.5059 213.583 58.484 213.62 58.446C213.656 58.4081 213.676 58.3571 213.676 58.3044C213.675 58.2782 213.67 58.2524 213.659 58.2283C213.649 58.2043 213.634 58.1826 213.615 58.1644C213.596 58.1462 213.574 58.132 213.549 58.1225C213.525 58.1129 213.499 58.1083 213.473 58.1089C213.447 58.1094 213.421 58.115 213.397 58.1254C213.373 58.1359 213.351 58.1509 213.333 58.1698C213.315 58.1886 213.301 58.2108 213.291 58.2352C213.282 58.2595 213.277 58.2855 213.278 58.3117C213.279 58.3644 213.3 58.4146 213.338 58.4513C213.376 58.4879 213.427 58.508 213.48 58.507ZM214.704 59.4037C214.442 59.2766 214.154 59.4374 213.631 59.4472C213.241 59.4612 212.915 59.4654 212.893 58.8541C212.872 58.2414 213.121 57.7351 213.51 57.7216C213.9 57.708 214.255 58.1933 214.303 58.8039C214.316 58.9724 214.298 59.0952 214.256 59.1862C214.618 59.143 214.701 59.3888 214.704 59.4037ZM207.9 58.6547C207.953 58.6533 208.003 58.631 208.039 58.5927C208.076 58.5545 208.095 58.5034 208.094 58.4507C208.092 58.3979 208.07 58.3478 208.032 58.3114C207.994 58.2751 207.942 58.2554 207.89 58.2568C207.863 58.2575 207.838 58.2633 207.814 58.274C207.79 58.2846 207.768 58.2999 207.75 58.3189C207.733 58.3378 207.718 58.3602 207.709 58.3846C207.7 58.409 207.695 58.435 207.696 58.4611C207.697 58.4872 207.703 58.513 207.713 58.5368C207.724 58.5607 207.739 58.5822 207.758 58.6002C207.777 58.6182 207.799 58.6322 207.824 58.6416C207.848 58.6509 207.874 58.6554 207.9 58.6547V58.6547ZM208.502 58.9751C208.508 59.5869 208.184 59.5501 207.794 59.5539C207.754 59.5552 207.717 59.5557 207.68 59.5557C207.636 59.5569 207.594 59.5574 207.554 59.5566C207.175 59.5557 206.934 59.5389 206.72 59.6545C206.725 59.6412 206.819 59.4312 207.158 59.3456C207.121 59.2629 207.097 59.1479 207.091 58.9887C207.068 58.3772 207.445 57.8757 207.835 57.8722C208.224 57.8683 208.496 58.3633 208.502 58.9751ZM215.881 54.7681C215.878 54.8058 215.875 54.8434 215.87 54.8809C215.716 54.8392 215.561 54.8004 215.405 54.7643C214.89 54.6513 214.369 54.5674 213.846 54.5077C213.828 54.5053 213.809 54.5041 213.791 54.5018C213.794 54.494 213.798 54.4863 213.8 54.4785C213.816 54.4214 213.829 54.3641 213.842 54.3068C213.977 53.7097 213.97 53.1149 213.955 52.8271L215.817 53.3565C215.918 54.0181 215.899 54.5372 215.881 54.7681ZM213.565 54.4135C213.559 54.4349 213.56 54.4571 213.565 54.4777C213.37 54.4573 213.175 54.4393 212.98 54.4237C213.199 53.9652 213.247 53.4769 213.257 53.3048C213.425 53.1856 213.592 53.0422 213.715 52.9308C213.726 53.2593 213.718 53.8556 213.565 54.4135H213.565ZM207.829 54.4765C207.834 54.4568 207.834 54.4349 207.829 54.4135C207.676 53.8564 207.668 53.2602 207.678 52.9308C207.801 53.0422 207.968 53.1856 208.137 53.3048C208.147 53.4769 208.194 53.964 208.413 54.4226C208.218 54.4379 208.023 54.4558 207.829 54.4765ZM207.547 54.5072C207.286 54.5391 207.025 54.572 206.765 54.6151C206.505 54.6596 206.245 54.7068 205.988 54.7639C205.832 54.8002 205.678 54.8386 205.523 54.8805C205.521 54.8682 205.519 54.8494 205.517 54.8251C205.499 54.6332 205.465 54.0804 205.577 53.3563L207.438 52.8268C207.424 53.1039 207.416 53.6653 207.536 54.2394C207.553 54.3191 207.572 54.3989 207.593 54.4782C207.596 54.486 207.599 54.4939 207.602 54.5008C207.584 54.5032 207.566 54.5048 207.547 54.5072L207.547 54.5072ZM216.879 55.2589C216.863 55.2513 216.847 55.2436 216.832 55.2362C216.809 55.2251 216.784 55.2124 216.755 55.1982C216.737 55.1896 216.719 55.1799 216.703 55.1691C216.53 55.0895 216.35 55.0278 216.17 54.9686C216.148 54.9616 216.127 54.9554 216.106 54.9491C216.108 54.9438 216.109 54.9384 216.11 54.9328C216.113 54.9124 216.159 54.5701 216.131 54.0304C216.119 53.8 216.094 53.5335 216.045 53.2407C216.042 53.2179 216.031 53.1967 216.016 53.1794C216.001 53.1621 215.981 53.1496 215.959 53.1432L215.693 53.0681C215.636 51.0146 214.791 50.0496 214.764 50.0197C215.519 51.2353 215.513 52.677 215.5 53.0129L213.854 52.5452C213.853 52.5452 213.852 52.5452 213.85 52.5445C213.844 52.543 213.836 52.542 213.829 52.5414C213.828 52.5414 213.826 52.5411 213.823 52.5411C213.814 52.5407 213.805 52.5414 213.796 52.5434C213.795 52.5434 213.794 52.5446 213.792 52.5446C213.785 52.5461 213.778 52.5486 213.771 52.5519C213.768 52.5531 213.766 52.5548 213.763 52.5555C213.758 52.5592 213.753 52.5624 213.747 52.5663C213.746 52.5671 213.744 52.5678 213.743 52.569C213.742 52.5701 213.741 52.5713 213.74 52.5721C213.738 52.5737 213.737 52.5748 213.735 52.576C213.734 52.5777 213.689 52.621 213.621 52.686C213.625 52.5321 213.627 52.2966 213.609 52.009L213.604 51.926C213.552 51.2036 213.381 50.1888 212.871 49.3004C212.875 49.3132 212.926 49.4605 212.991 49.7088C213.155 50.3334 213.414 51.5976 213.273 52.9694C213.272 52.9757 213.272 52.9819 213.271 52.9882C213.269 52.99 213.267 52.9916 213.265 52.9933C213.201 53.044 213.136 53.0923 213.07 53.1381C213.053 53.1492 213.04 53.164 213.031 53.1812C213.022 53.1985 213.016 53.2176 213.016 53.2372C213.016 53.2434 213.001 53.8567 212.731 54.3789C212.726 54.3874 212.724 54.396 212.721 54.4049C212.047 54.3587 211.371 54.339 210.697 54.3385C210.022 54.339 209.346 54.3575 208.672 54.4034C208.67 54.3952 208.667 54.3867 208.663 54.3788C208.392 53.8567 208.378 53.2434 208.377 53.2372C208.377 53.2176 208.372 53.1984 208.363 53.1812C208.354 53.164 208.34 53.1492 208.324 53.1381C208.255 53.0908 208.187 53.0408 208.122 52.9881C207.985 51.6831 208.211 50.4739 208.375 49.8159C208.453 49.5035 208.518 49.3147 208.523 49.3003C207.782 50.5889 207.757 52.1437 207.773 52.6859C207.703 52.6209 207.659 52.5777 207.658 52.5759C207.657 52.5747 207.655 52.5737 207.653 52.572L207.651 52.5688C207.649 52.5678 207.648 52.5671 207.646 52.5662C207.641 52.5625 207.636 52.5592 207.63 52.5562C207.627 52.5547 207.625 52.5531 207.622 52.5518C207.616 52.5485 207.609 52.5462 207.602 52.5452C207.6 52.5445 207.598 52.5433 207.597 52.5433C207.588 52.5414 207.579 52.5407 207.57 52.541C207.568 52.541 207.565 52.5413 207.563 52.5413C207.556 52.542 207.55 52.5428 207.543 52.5445C207.541 52.5452 207.54 52.5452 207.539 52.5452L205.894 53.0129C205.881 52.6768 205.874 51.2352 206.629 50.0196C206.603 50.0497 205.758 51.0148 205.7 53.0682L205.436 53.1432C205.413 53.1494 205.393 53.1619 205.378 53.1792C205.362 53.1965 205.352 53.2179 205.348 53.2409C205.305 53.502 205.276 53.7654 205.262 54.0297C205.235 54.5699 205.281 54.9126 205.284 54.933C205.285 54.9384 205.287 54.9437 205.287 54.949C205.266 54.9555 205.245 54.9618 205.224 54.9684C205.043 55.0275 204.862 55.0895 204.69 55.1694C204.674 55.1795 204.658 55.1887 204.641 55.1969L204.638 55.1984C204.609 55.2126 204.583 55.2252 204.56 55.2363L204.52 55.2561C204.511 55.2611 204.503 55.2653 204.494 55.2704C204.616 55.2225 204.742 55.1875 204.869 55.1565C204.995 55.125 205.122 55.0972 205.25 55.0729C205.506 55.0253 205.763 54.9839 206.021 54.9525C206.279 54.9186 206.538 54.8907 206.797 54.869C207.056 54.8469 207.315 54.8251 207.574 54.8101C208.613 54.7486 209.655 54.7292 210.697 54.7288C211.739 54.7295 212.78 54.7459 213.819 54.8097C214.079 54.8247 214.338 54.8464 214.597 54.8684C214.857 54.8904 215.114 54.9187 215.372 54.9525C215.63 54.9836 215.888 55.0248 216.143 55.0727C216.271 55.0968 216.398 55.1247 216.524 55.1565C216.651 55.1876 216.777 55.2225 216.899 55.2704C216.892 55.2663 216.886 55.2628 216.879 55.2589Z"
            fill="#0E0F0D"
          />
          <path
            d="M210.988 50.4875V53.2298H211.36V53.7388H210.102V53.2298H210.474V50.4875H209.57V50.9385H209.133V50.0506H212.329V50.9385H211.892V50.4874L210.988 50.4875ZM212.658 51.2668V49.7218H208.805V51.2668H209.899V50.8158H210.145V52.9008H209.774V54.0666H211.689V52.9007H211.316V50.8157H211.563V51.2667L212.658 51.2668Z"
            fill="#0E0F0D"
          />
        </g>
        <g filter="url(#filter5_d_16_1331)">
          <path
            d="M248 51C248 44.3726 253.373 39 260 39H272C278.627 39 284 44.3726 284 51V63C284 69.6274 278.627 75 272 75H260C253.373 75 248 69.6274 248 63V51Z"
            fill="#FAFAFA"
          />
          <path
            d="M272 38.5C278.904 38.5 284.5 44.0964 284.5 51V63C284.5 69.9036 278.904 75.5 272 75.5H260C253.096 75.5 247.5 69.9036 247.5 63V51C247.5 44.0964 253.096 38.5 260 38.5H272Z"
            stroke="black"
            strokeOpacity="0.08"
          />
          <g clipPath="url(#clip2_16_1331)">
            <path
              d="M265.825 55.116C264.769 55.116 263.903 55.9765 263.903 57.0252C263.903 58.1008 264.742 58.9344 265.825 58.9344C266.88 58.9344 267.746 58.0739 267.746 57.0252C267.746 55.9765 266.88 55.116 265.825 55.116Z"
              fill="black"
            />
            <path
              d="M258.003 55.0622C258.896 51.5933 262.063 49.0386 265.825 49.0386C270.263 49.0386 273.863 52.6151 273.863 57.0521C273.863 61.4621 270.263 65.0386 265.825 65.0386C262.063 65.0386 258.896 62.484 258.003 59.0151V58.9344C258.003 58.7193 258.165 58.558 258.382 58.5849H261.63C261.792 58.5849 261.927 58.6656 261.981 58.8C262.658 60.2521 264.12 61.247 265.825 61.247C268.152 61.247 270.047 59.3647 270.047 57.0521C270.047 54.7395 268.152 52.8571 265.825 52.8571C264.12 52.8571 262.658 53.8521 261.981 55.3042C261.927 55.4386 261.792 55.5193 261.63 55.5193H258.382C258.165 55.5193 258.003 55.3579 258.003 55.1428V55.0622Z"
              fill="black"
            />
          </g>
        </g>
        <g clipPath="url(#clip3_16_1331)">
          <path
            d="M152.987 147.594C147.254 147.594 142.59 152.262 142.59 158C142.59 163.738 147.254 168.406 152.987 168.406C158.721 168.406 163.385 163.738 163.385 158C163.385 152.262 158.721 147.594 152.987 147.594ZM152.987 163.385C150.015 163.385 147.607 160.974 147.607 158C147.607 155.026 150.015 152.615 152.987 152.615C155.959 152.615 158.368 155.026 158.368 158C158.368 160.974 155.959 163.385 152.987 163.385Z"
            fill="black"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M153.859 145.885V142C162.297 142.451 169 149.443 169 158C169 166.557 162.297 173.547 153.859 174V170.115C160.148 169.665 165.128 164.406 165.128 158C165.128 151.594 160.148 146.335 153.859 145.885ZM143.817 165.945C142.15 164.019 141.076 161.565 140.884 158.872H137C137.201 162.641 138.708 166.061 141.068 168.694L143.816 165.945H143.817ZM152.116 174V170.115C149.423 169.923 146.972 168.85 145.047 167.179L142.299 169.929C144.933 172.293 148.35 173.798 152.114 174H152.116Z"
            fill="url(#paint0_linear_16_1331)"
          />
        </g>
        <defs>
          <filter
            id="filter0_d_16_1331"
            x="123.414"
            y="129.276"
            width="59.1729"
            height="59.1724"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="0.862069" />
            <feGaussianBlur stdDeviation="0.862069" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1331"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1331"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_16_1331"
            x="21"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1331"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1331"
              result="shape"
            />
          </filter>
          <filter
            id="filter2_d_16_1331"
            x="77"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1331"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1331"
              result="shape"
            />
          </filter>
          <filter
            id="filter3_d_16_1331"
            x="133"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1331"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1331"
              result="shape"
            />
          </filter>
          <filter
            id="filter4_d_16_1331"
            x="189"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1331"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1331"
              result="shape"
            />
          </filter>
          <filter
            id="filter5_d_16_1331"
            x="245"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_16_1331"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_16_1331"
              result="shape"
            />
          </filter>
          <linearGradient
            id="paint0_linear_16_1331"
            x1="154.486"
            y1="144.25"
            x2="138.736"
            y2="159.988"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#0096FF" />
            <stop offset="1" stopColor="#FF1E56" />
          </linearGradient>
          <clipPath id="clip0_16_1331">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(34 49)"
            />
          </clipPath>
          <clipPath id="clip1_16_1331">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(90 49)"
            />
          </clipPath>
          <clipPath id="clip2_16_1331">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(258 49)"
            />
          </clipPath>
          <clipPath id="clip3_16_1331">
            <rect
              width="32"
              height="32"
              fill="white"
              transform="translate(137 142)"
            />
          </clipPath>
        </defs>
      </svg>
    </div>
  );
};

export const ProvidersDark = () => {
  return (
    <div className={sizingString}>
      <svg className={sizingString} viewBox="0 0 307 200" fill="none">
        <path
          d="M153.75 142.5C153.945 108.329 154.055 89.1709 154.25 55"
          stroke="#8657A7"
          strokeWidth="2"
        />
        <path
          d="M97.125 49.5L97.125 81.5C97.125 94.7548 107.87 105.5 121.125 105.5L129.125 105.5C142.38 105.5 153.125 116.245 153.125 129.5L153.125 161.5"
          stroke="#CD3678"
          strokeWidth="2"
        />
        <path
          d="M211.125 49.5L211.125 81.5C211.125 94.7548 200.38 105.5 187.125 105.5L179.125 105.5C165.87 105.5 155.125 116.245 155.125 129.5L155.125 141.5"
          stroke="#3F79D5"
          strokeWidth="2"
        />
        <path
          d="M42.125 62.5002L42.125 81.5002C42.125 94.7551 52.8702 105.5 66.125 105.5L129.125 105.5C142.38 105.5 153.125 116.245 153.125 129.5L153.125 149"
          stroke="#FF1E56"
          strokeWidth="2"
        />
        <path
          d="M266.125 62.5002L266.125 81.5002C266.125 94.7551 255.38 105.5 242.125 105.5L179.125 105.5C165.87 105.5 155.125 116.245 155.125 129.5L155.125 149"
          stroke="#0196FF"
          strokeWidth="2"
        />
        <g filter="url(#filter0_d_17_1136)">
          <rect x="126" y="131" width="54" height="54" rx="27" fill="black" />
          <rect
            x="125.569"
            y="130.569"
            width="54.8621"
            height="54.8621"
            rx="27.431"
            stroke="white"
            strokeOpacity="0.145"
            strokeWidth="0.862069"
          />
        </g>
        <g filter="url(#filter1_d_17_1136)">
          <path
            d="M24 51C24 44.3726 29.3726 39 36 39H48C54.6274 39 60 44.3726 60 51V63C60 69.6274 54.6274 75 48 75H36C29.3726 75 24 69.6274 24 63V51Z"
            fill="black"
          />
          <path
            d="M48 38.5C54.9036 38.5 60.5 44.0964 60.5 51V63C60.5 69.9036 54.9036 75.5 48 75.5H36C29.0964 75.5 23.5 69.9036 23.5 63V51C23.5 44.0964 29.0964 38.5 36 38.5H48Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <g clipPath="url(#clip0_17_1136)">
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M42 49C37.58 49 34 52.5788 34 56.9973C34 60.5361 36.29 63.5251 39.47 64.5847C39.87 64.6547 40.02 64.4148 40.02 64.2049C40.02 64.0149 40.01 63.3851 40.01 62.7154C38 63.0852 37.48 62.2255 37.32 61.7757C37.23 61.5458 36.84 60.836 36.5 60.6461C36.22 60.4961 35.82 60.1262 36.49 60.1162C37.12 60.1062 37.57 60.696 37.72 60.936C38.44 62.1455 39.59 61.8057 40.05 61.5957C40.12 61.0759 40.33 60.726 40.56 60.5261C38.78 60.3262 36.92 59.6364 36.92 56.5774C36.92 55.7077 37.23 54.988 37.74 54.4282C37.66 54.2282 37.38 53.4085 37.82 52.3089C37.82 52.3089 38.49 52.099 40.02 53.1286C40.66 52.9487 41.34 52.8587 42.02 52.8587C42.7 52.8587 43.38 52.9487 44.02 53.1286C45.55 52.089 46.22 52.3089 46.22 52.3089C46.66 53.4085 46.38 54.2282 46.3 54.4282C46.81 54.988 47.12 55.6977 47.12 56.5774C47.12 59.6464 45.25 60.3262 43.47 60.5261C43.76 60.776 44.01 61.2558 44.01 62.0056C44.01 63.0752 44 63.9349 44 64.2049C44 64.4148 44.15 64.6647 44.55 64.5847C46.1381 64.0488 47.5182 63.0284 48.4958 61.6673C49.4735 60.3062 49.9996 58.6729 50 56.9973C50 52.5788 46.42 49 42 49Z"
              fill="white"
            />
          </g>
        </g>
        <g filter="url(#filter2_d_17_1136)">
          <path
            d="M80 51C80 44.3726 85.3726 39 92 39H104C110.627 39 116 44.3726 116 51V63C116 69.6274 110.627 75 104 75H92C85.3726 75 80 69.6274 80 63V51Z"
            fill="black"
          />
          <path
            d="M104 38.5C110.904 38.5 116.5 44.0964 116.5 51V63C116.5 69.9036 110.904 75.5 104 75.5H92C85.0964 75.5 79.5 69.9036 79.5 63V51C79.5 44.0964 85.0964 38.5 92 38.5H104Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <g clipPath="url(#clip1_17_1136)">
            <path
              d="M105.528 55.6866L105.506 55.6307L103.386 50.0989C103.343 49.9905 103.267 49.8985 103.168 49.8362C103.069 49.7749 102.954 49.7454 102.838 49.7516C102.722 49.7579 102.611 49.7995 102.519 49.871C102.429 49.9446 102.363 50.0443 102.331 50.1565L100.9 54.5352H95.1048L93.6736 50.1565C93.6426 50.0436 93.5767 49.9435 93.4855 49.8702C93.3939 49.7987 93.2826 49.7571 93.1666 49.7508C93.0506 49.7446 92.9355 49.7741 92.8368 49.8354C92.7384 49.8979 92.6621 49.9898 92.6187 50.0981L90.495 55.6274L90.4739 55.6834C90.1688 56.4806 90.1311 57.3555 90.3666 58.176C90.6021 58.9966 91.0979 59.7183 91.7794 60.2324L91.7867 60.2381L91.8062 60.2519L95.0351 62.6699L96.6325 63.8789L97.6055 64.6136C97.7194 64.7 97.8583 64.7468 98.0012 64.7468C98.1442 64.7468 98.2831 64.7 98.397 64.6136L99.37 63.8789L100.967 62.6699L104.216 60.2373L104.224 60.2308C104.904 59.7166 105.399 58.9956 105.634 58.1762C105.869 57.3567 105.832 56.4831 105.528 55.6866Z"
              fill="#E24329"
            />
            <path
              d="M105.527 55.6866L105.505 55.6307C104.473 55.8427 103.499 56.2802 102.655 56.9119L98 60.4319C99.5853 61.6311 100.965 62.6731 100.965 62.6731L104.214 60.2405L104.222 60.234C104.903 59.7198 105.398 58.9984 105.634 58.1782C105.869 57.3581 105.832 56.4837 105.527 55.6866Z"
              fill="#FC6D26"
            />
            <path
              d="M95.0342 62.6731L96.6316 63.8821L97.6047 64.6167C97.7185 64.7032 97.8575 64.7499 98.0004 64.7499C98.1433 64.7499 98.2822 64.7032 98.3961 64.6167L99.3691 63.8821L100.967 62.6731C100.967 62.6731 99.5848 61.6279 97.9995 60.4318C96.4143 61.6279 95.0342 62.6731 95.0342 62.6731Z"
              fill="#FCA326"
            />
            <path
              d="M93.3444 56.9119C92.5009 56.2789 91.5279 55.8402 90.495 55.6274L90.4739 55.6834C90.1688 56.4806 90.1311 57.3555 90.3666 58.176C90.6021 58.9966 91.0979 59.7183 91.7794 60.2324L91.7867 60.2381L91.8062 60.2519L95.0351 62.6699C95.0351 62.6699 96.4136 61.6279 98.0004 60.4286L93.3444 56.9119Z"
              fill="#FC6D26"
            />
          </g>
        </g>
        <g filter="url(#filter3_d_17_1136)">
          <path
            d="M136 51C136 44.3726 141.373 39 148 39H160C166.627 39 172 44.3726 172 51V63C172 69.6274 166.627 75 160 75H148C141.373 75 136 69.6274 136 63V51Z"
            fill="black"
          />
          <path
            d="M160 38.5C166.904 38.5 172.5 44.0964 172.5 51V63C172.5 69.9036 166.904 75.5 160 75.5H148C141.096 75.5 135.5 69.9036 135.5 63V51C135.5 44.0964 141.096 38.5 148 38.5H160Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M154 50L162 64H146L154 50Z"
            fill="white"
          />
        </g>
        <g filter="url(#filter4_d_17_1136)">
          <path
            d="M192 51C192 44.3726 197.373 39 204 39H216C222.627 39 228 44.3726 228 51V63C228 69.6274 222.627 75 216 75H204C197.373 75 192 69.6274 192 63V51Z"
            fill="black"
          />
          <path
            d="M216 38.5C222.904 38.5 228.5 44.0964 228.5 51V63C228.5 69.9036 222.904 75.5 216 75.5H204C197.096 75.5 191.5 69.9036 191.5 63V51C191.5 44.0964 197.096 38.5 204 38.5H216Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <path
            d="M219.029 54.3223C219.021 54.2562 219.011 54.1901 218.997 54.1254C218.985 54.0574 218.969 53.9901 218.95 53.9237L218.9 53.8435C218.691 53.68 218.467 53.5565 218.239 53.4473C218.05 53.3584 217.859 53.2809 217.666 53.2096C217.126 51.7131 216.2 50.3861 214.981 49.4615C213.721 48.5059 212.239 48 210.696 48C209.153 48 207.672 48.5059 206.412 49.4616C205.193 50.3861 204.266 51.7131 203.727 53.21C203.534 53.2811 203.342 53.3588 203.154 53.4473C202.926 53.5565 202.701 53.68 202.493 53.8435L202.442 53.9237C202.424 53.9903 202.409 54.0576 202.395 54.1253C202.382 54.1902 202.373 54.2561 202.363 54.3223C202.345 54.4532 202.332 54.5849 202.325 54.7169C202.312 54.9813 202.32 55.2463 202.349 55.5095C202.377 55.7732 202.426 56.0344 202.495 56.2904C202.532 56.4193 202.574 56.5463 202.623 56.6711C202.647 56.734 202.674 56.7966 202.704 56.8591C202.718 56.8902 202.734 56.9205 202.751 56.9523C202.787 57.0157 202.793 57.0281 202.809 57.0506L202.877 57.1136C202.922 57.1365 202.958 57.1539 202.999 57.173L203.117 57.2258C203.138 57.2348 203.159 57.2436 203.181 57.2526C202.646 57.7471 202.065 58.3896 201.562 59.1837L200.927 60.186L201.819 59.4031C201.834 59.3899 202.582 58.7424 203.829 58.0089L203.847 58.1523C203.765 58.1947 203.373 58.4005 203.256 58.4981C203.063 58.6585 203.054 58.9075 203.105 59.3721C203.132 59.6102 203.221 60.0725 203.342 60.4963C203.549 61.2256 203.701 61.3546 203.835 61.3848C203.895 61.3992 203.973 61.4058 204.06 61.4058C204.299 61.4058 204.605 61.3593 204.805 61.299C205.039 62.0274 205.371 62.685 205.775 63.2621C205.756 63.2674 205.736 63.2737 205.717 63.2792C205.473 63.1664 204.623 62.7724 204.337 62.6438L203.739 62.3748L204.093 62.9266C204.119 62.9664 204.729 63.9176 205.227 64.5587C205.692 65.1566 206.33 65.7686 207.534 65.7686C207.679 65.7686 207.83 65.7592 207.986 65.742C208.345 65.7008 208.615 65.6684 208.82 65.6421C210.083 66.1063 211.476 66.1349 212.799 65.6339C213.145 65.5023 213.478 65.3379 213.793 65.1429C214.302 65.0205 214.86 64.8877 215.135 64.8103C215.18 64.7983 215.235 64.7852 215.292 64.7716C215.676 64.6834 216.317 64.5345 216.659 63.8504C217.004 63.1602 217.566 62.1026 217.572 62.0918L217.835 61.5985L217.323 61.8211C217.295 61.8335 216.647 62.116 216.309 62.2927C216.544 61.7535 216.682 61.3072 216.73 61.1358C216.918 61.1813 217.198 61.1755 217.404 61.1755C217.505 61.1755 217.609 61.1579 217.677 61.1407C217.811 61.1067 217.914 61.0178 218.108 60.2653C218.221 59.8278 218.302 59.3516 218.325 59.1067C218.368 58.6303 218.354 58.3749 218.159 58.2138C218.062 58.1337 217.778 57.9806 217.633 57.9052C217.714 57.8706 217.754 57.8808 217.757 57.8816L217.888 57.3838C217.935 57.364 217.983 57.3442 218.039 57.3229C218.118 57.2913 218.198 57.26 218.277 57.2258L218.394 57.1729C218.435 57.1538 218.471 57.1365 218.516 57.1135L218.585 57.0505C218.599 57.028 218.607 57.0156 218.616 56.9984C218.66 56.9204 218.675 56.8901 218.689 56.8591C218.719 56.7965 218.745 56.734 218.77 56.671C218.819 56.5462 218.861 56.4192 218.898 56.2904C218.967 56.0343 219.016 55.7732 219.045 55.5094C219.074 55.2464 219.081 54.9814 219.067 54.7169C219.061 54.5848 219.048 54.4532 219.029 54.3223Z"
            fill="#0E0F0D"
          />
          <path
            d="M211.523 64.5744C211.427 64.5889 211.33 64.6007 211.235 64.6084C211.172 64.6114 211.107 64.6176 211.048 64.6176L211.025 64.6182C211.1 64.4518 211.157 64.3224 211.199 64.2245C211.287 64.3224 211.398 64.4435 211.523 64.5744Z"
            fill="#E1C5A2"
          />
          <path
            d="M211.407 57.1365C211.255 57.2592 211.096 57.3735 210.93 57.4737L210.377 57.8074C210.03 57.8498 209.729 57.9355 209.712 57.9407C209.702 57.9429 209.692 57.9476 209.683 57.953C209.656 57.9692 209.636 57.995 209.626 58.0254L209.063 59.8816L206.052 60.5512L205.103 59.8869L204.827 57.6518C205.366 57.5529 206.086 57.4387 206.951 57.3416C206.857 57.4543 206.768 57.5709 206.683 57.6912L206.168 58.4305L206.918 57.9305C206.93 57.9227 207.407 57.6085 208.188 57.2262C209.039 57.1624 209.893 57.1304 210.746 57.1302C210.971 57.1302 211.191 57.1329 211.407 57.1366V57.1365ZM206.72 59.6545C206.934 59.5388 207.175 59.5558 207.554 59.5567C207.594 59.5574 207.636 59.557 207.68 59.5558C207.717 59.5558 207.754 59.5551 207.794 59.554C208.184 59.5501 208.508 59.587 208.502 58.9752C208.496 58.3633 208.224 57.8685 207.834 57.8723C207.445 57.8758 207.068 58.3772 207.091 58.9888C207.097 59.1481 207.121 59.2632 207.158 59.3458C206.819 59.4312 206.725 59.6413 206.72 59.6545ZM216.626 57.6445L216.354 59.545L215.398 60.2148L212.391 59.873L211.83 58.0253C211.824 58.0052 211.813 57.9869 211.798 57.9721C211.783 57.9573 211.764 57.9465 211.744 57.9407C211.725 57.9351 211.353 57.8286 210.958 57.7945L211.031 57.7898C211.093 57.7851 212.13 57.6581 213.369 57.2313C214.74 57.3365 215.86 57.5048 216.626 57.6445ZM214.704 59.4036C214.7 59.3888 214.618 59.143 214.256 59.1862C214.297 59.0952 214.316 58.9724 214.303 58.8039C214.255 58.1933 213.9 57.7079 213.51 57.7217C213.121 57.7352 212.871 58.2414 212.893 58.8541C212.914 59.4653 213.241 59.4611 213.631 59.4472C214.154 59.4373 214.441 59.2766 214.704 59.4036Z"
            fill="#A89983"
          />
          <path
            d="M213.676 58.3042C213.677 58.357 213.657 58.408 213.62 58.446C213.583 58.484 213.533 58.5059 213.48 58.5069C213.454 58.5074 213.428 58.5027 213.404 58.4931C213.38 58.4836 213.357 58.4693 213.339 58.4511C213.32 58.433 213.305 58.4113 213.294 58.3873C213.284 58.3633 213.278 58.3375 213.278 58.3114C213.277 58.2853 213.282 58.2593 213.292 58.235C213.301 58.2107 213.315 58.1885 213.333 58.1697C213.352 58.1508 213.373 58.1358 213.397 58.1253C213.421 58.1149 213.447 58.1093 213.473 58.1088C213.499 58.1082 213.525 58.1128 213.55 58.1224C213.574 58.1319 213.596 58.1462 213.615 58.1644C213.634 58.1825 213.649 58.2042 213.659 58.2283C213.67 58.2523 213.675 58.2781 213.676 58.3043M208.094 58.4507C208.095 58.5034 208.076 58.5544 208.039 58.5927C208.003 58.6309 207.953 58.6532 207.9 58.6547C207.874 58.6555 207.848 58.6511 207.824 58.6418C207.799 58.6324 207.777 58.6184 207.758 58.6004C207.739 58.5823 207.723 58.5608 207.713 58.5368C207.702 58.5129 207.696 58.4871 207.695 58.4608C207.695 58.4347 207.699 58.4087 207.709 58.3842C207.718 58.3598 207.732 58.3375 207.75 58.3185C207.768 58.2996 207.79 58.2844 207.814 58.2738C207.838 58.2632 207.863 58.2574 207.89 58.2568C207.942 58.2555 207.994 58.2751 208.032 58.3115C208.07 58.3478 208.092 58.3979 208.094 58.4507Z"
            fill="white"
          />
          <path
            d="M217.938 58.4806C217.891 58.4417 217.734 58.352 217.581 58.2693L217.329 60.0359C217.327 60.0529 217.321 60.0692 217.312 60.0839C217.302 60.0985 217.291 60.1112 217.276 60.1212L216.916 60.3734C216.907 60.416 216.901 60.4517 216.894 60.485C217.249 60.5722 217.593 60.3167 217.786 60.1324C217.875 59.7843 217.953 59.3712 217.98 59.0754C218.021 58.6171 217.985 58.5186 217.938 58.4806ZM212.369 65.1919C212.135 65.1087 211.921 64.9729 211.734 64.7884C211.718 64.7725 211.704 64.7573 211.688 64.7418C211.542 64.7716 211.394 64.7928 211.246 64.8053C211.182 64.8082 211.122 64.8136 211.056 64.8136L210.958 64.8144L210.92 64.8136C210.696 65.1457 210.321 65.3282 210.026 65.4254C210.901 65.5756 211.864 65.3458 212.369 65.1919ZM204.665 60.8655C204.658 60.8389 204.649 60.8125 204.642 60.7858L204.173 60.4578C204.159 60.4476 204.147 60.4345 204.138 60.4194C204.128 60.4042 204.123 60.3873 204.12 60.3698L203.892 58.5148C203.723 58.605 203.527 58.7163 203.476 58.7599C203.43 58.7972 203.396 58.8923 203.445 59.3343C203.482 59.6666 203.599 60.1771 203.718 60.5596C203.955 60.7411 204.304 60.9324 204.665 60.8655ZM211.669 60.7809C211.644 60.7781 211.621 60.7681 211.602 60.7523C211.583 60.7365 211.569 60.7154 211.562 60.6918L210.984 58.7867C210.887 58.774 210.801 58.7669 210.729 58.7669C210.656 58.7669 210.57 58.774 210.473 58.7867L209.911 60.637C209.905 60.6583 209.893 60.6775 209.876 60.6926C209.86 60.7078 209.84 60.7183 209.818 60.7231L209.549 60.783C209.527 60.8779 209.449 61.0172 209.2 61.0935C208.798 61.2162 206.253 61.9749 205.962 61.9336C205.793 61.9098 205.47 61.7319 205.232 61.5881C205.136 61.3633 205.084 61.2105 205.071 61.1743V61.1736L205.071 61.1743C205.105 61.273 205.437 62.229 206.112 63.1642C206.835 62.951 207.46 62.7523 207.66 62.6891C208.067 62.0615 208.646 61.4388 209.058 61.4176C209.131 61.4139 209.203 61.412 209.276 61.4119C209.478 61.4119 209.67 61.4262 209.849 61.4473C209.697 61.3095 209.666 61.1483 209.644 61.0767C209.644 61.0767 210.17 61.4881 210.839 61.4016C211.509 61.3158 211.924 60.93 211.924 60.93L211.938 60.8114L211.669 60.7809"
            fill="#E1C5A2"
          />
          <path
            d="M212.212 61.022C212.073 60.9861 211.986 60.9289 211.93 60.8692L211.923 60.9301C211.923 60.9301 211.921 61.2112 211.63 61.429C212.191 61.2591 212.423 61.2015 212.582 61.2015C212.757 61.2015 212.843 61.2746 212.919 61.3387C212.933 61.3506 212.948 61.3632 212.965 61.3766C213.333 61.6665 213.7 61.9575 214.066 62.2496C214.242 62.2699 214.799 62.3336 215.15 62.3656C215.352 62.3845 215.535 62.3997 215.714 62.3997C215.772 62.3997 215.826 62.3977 215.878 62.3942C216.063 62.0399 216.233 61.6481 216.384 61.216C216.177 61.3615 215.704 61.68 215.483 61.721C215.195 61.775 212.618 61.1274 212.212 61.022Z"
            fill="#E1C5A2"
          />
          <path
            d="M218.696 54.3596C218.691 54.2987 218.684 54.238 218.677 54.1774C218.672 54.1341 218.665 54.091 218.658 54.0481C218.495 53.9112 218.31 53.7893 218.117 53.679C217.909 53.5566 217.69 53.4477 217.468 53.3464C217.247 53.2419 217.019 53.1474 216.791 53.0554C216.677 53.0088 216.562 52.9641 216.446 52.9214C216.331 52.8764 216.215 52.8344 216.098 52.792C216.343 52.8326 216.585 52.8885 216.825 52.9502C216.982 52.9902 217.137 53.0356 217.292 53.0842C216.192 50.2117 213.565 48.3413 210.696 48.3413C207.827 48.3413 205.2 50.2118 204.101 53.0842C204.256 53.0356 204.411 52.9902 204.567 52.9502C204.807 52.8884 205.05 52.8326 205.295 52.7921C205.177 52.8344 205.062 52.8764 204.946 52.9215C204.83 52.9643 204.716 53.009 204.602 53.0554C204.373 53.1474 204.146 53.2419 203.925 53.3464C203.702 53.4477 203.484 53.5566 203.275 53.679C203.083 53.7893 202.898 53.9112 202.735 54.0481C202.728 54.0911 202.722 54.1342 202.716 54.1774C202.708 54.238 202.702 54.2988 202.697 54.3596C202.686 54.4821 202.681 54.605 202.681 54.728C202.678 54.9742 202.695 55.2204 202.726 55.4638C202.76 55.7081 202.805 55.9508 202.871 56.1856C202.903 56.3024 202.94 56.4176 202.983 56.5308C203.005 56.5868 203.028 56.6423 203.053 56.6957C203.065 56.7224 203.077 56.7488 203.09 56.7741L203.106 56.8039C203.124 56.813 203.143 56.8226 203.161 56.8312L203.27 56.8833C203.331 56.9113 203.415 56.9513 203.485 56.9824C203.489 56.9789 203.493 56.9753 203.496 56.9719L203.293 56.1995C203.336 56.1879 203.721 56.0884 204.385 55.9618C204.331 55.9518 204.278 55.9404 204.225 55.9277C204.074 55.8899 203.924 55.8441 203.78 55.7858C203.708 55.7554 203.638 55.7225 203.57 55.6844C203.503 55.6456 203.437 55.602 203.386 55.5438C204.115 55.7819 205.621 55.6743 206.961 55.5357C208.185 55.4094 209.413 55.3278 210.647 55.3251C211.881 55.3278 213.11 55.4094 214.334 55.5357C215.673 55.6743 217.18 55.7819 217.909 55.5438C217.858 55.6021 217.791 55.6456 217.725 55.6844C217.657 55.7224 217.586 55.7555 217.515 55.7858C217.37 55.8441 217.222 55.8899 217.07 55.9277C217.048 55.933 217.025 55.9377 217.003 55.9428C217.731 56.0777 218.154 56.1875 218.199 56.1995L218.006 56.9352C218.045 56.9182 218.084 56.9011 218.122 56.8832L218.232 56.8311C218.25 56.8225 218.269 56.8129 218.287 56.8039L218.302 56.774C218.315 56.7488 218.328 56.7223 218.34 56.6956C218.364 56.6423 218.388 56.5867 218.409 56.5307C218.452 56.4174 218.489 56.3023 218.522 56.1855C218.588 55.9507 218.633 55.7079 218.666 55.4637C218.698 55.2203 218.715 54.9741 218.712 54.7279C218.712 54.605 218.706 54.4821 218.696 54.3596"
            fill="#E0D896"
          />
          <path
            d="M213.715 52.9307C213.726 53.2593 213.718 53.8556 213.565 54.4135C213.559 54.4348 213.56 54.4571 213.565 54.4777C213.37 54.4573 213.175 54.4393 212.98 54.4237C213.199 53.9651 213.247 53.4769 213.257 53.3048C213.425 53.1856 213.592 53.0422 213.715 52.9307ZM208.137 53.3048C208.147 53.4768 208.194 53.9639 208.413 54.4225C208.218 54.438 208.023 54.4559 207.828 54.4766C207.834 54.4568 207.834 54.4349 207.828 54.4136C207.676 53.8565 207.668 53.2602 207.678 52.9308C207.801 53.0422 207.968 53.1856 208.137 53.3048ZM216.11 54.9329C216.109 54.9384 216.108 54.9439 216.106 54.9492C216.127 54.9554 216.148 54.9617 216.17 54.9686C216.35 55.0277 216.53 55.0895 216.703 55.1691C216.415 54.9821 216.233 54.4428 216.131 54.0305C216.159 54.5702 216.113 54.9125 216.11 54.9329ZM207.438 52.827L205.577 53.3564C205.465 54.0804 205.499 54.6334 205.517 54.8253L205.527 54.8196C205.527 54.8196 205.587 54.0309 205.711 53.7282C205.775 53.5728 206.164 53.4737 206.461 53.4027C206.759 53.332 207.234 53.1903 207.326 53.6082C207.383 53.8665 207.461 54.0812 207.536 54.2396C207.416 53.6654 207.424 53.104 207.438 52.827ZM213.955 52.827C213.97 53.1148 213.977 53.7096 213.842 54.3067C213.927 54.1445 214.021 53.9052 214.086 53.6082C214.178 53.1903 214.653 53.332 214.95 53.4028C215.248 53.4738 215.637 53.5728 215.701 53.7282C215.806 53.9844 215.865 54.5884 215.881 54.7681C215.899 54.5371 215.918 54.018 215.817 53.3563L213.955 52.827ZM208.122 52.9882C208.187 53.0408 208.255 53.0908 208.324 53.1382C208.357 53.1608 208.377 53.1976 208.377 53.2373C208.378 53.2434 208.392 53.8567 208.663 54.379C208.667 54.3868 208.67 54.3953 208.672 54.4034C209.346 54.3576 210.022 54.339 210.697 54.3386C211.371 54.339 212.047 54.3588 212.721 54.405C212.724 54.3961 212.726 54.3875 212.731 54.379C213.002 53.8567 213.016 53.2434 213.016 53.2373C213.017 53.2177 213.022 53.1985 213.031 53.1813C213.04 53.164 213.053 53.1493 213.07 53.1382C213.136 53.0924 213.201 53.0441 213.265 52.9933L213.273 52.9695C213.414 51.5977 213.155 50.3335 212.991 49.7089C212.983 50.136 212.881 53.7955 211.973 53.7955H209.467C208.502 53.7955 208.425 49.6695 208.425 49.6695L208.375 49.816C208.211 50.4739 207.985 51.6832 208.122 52.9882ZM205.287 54.9489C205.287 54.9435 205.285 54.9384 205.284 54.9329C205.281 54.9125 205.234 54.5698 205.262 54.0295C205.161 54.4422 204.978 54.9824 204.689 55.1693C204.862 55.0893 205.043 55.0274 205.224 54.9683C205.245 54.9617 205.266 54.9554 205.287 54.9489Z"
            fill="#D7C184"
          />
          <path
            d="M216.894 60.485C216.879 60.5662 216.861 60.647 216.841 60.7271C217.048 60.7753 217.386 60.8127 217.547 60.7812C217.616 60.706 217.706 60.4454 217.786 60.1323C217.593 60.3167 217.248 60.5722 216.894 60.4849M209.486 65.5447C209.98 65.6799 210.484 65.7386 210.981 65.7057C211.48 65.6718 212.127 65.5642 212.814 65.2853C212.662 65.2743 212.512 65.2429 212.369 65.192C211.864 65.3459 210.901 65.5757 210.026 65.4256C209.794 65.5018 209.613 65.5255 209.595 65.5277C209.558 65.5319 209.528 65.537 209.486 65.5448M204.698 60.9762C204.687 60.9395 204.676 60.9024 204.665 60.8655C204.304 60.9324 203.955 60.7411 203.718 60.5598C203.795 60.8053 203.872 60.9983 203.93 61.057C204.109 61.0883 204.504 61.0334 204.698 60.9762ZM205.232 61.5881C205.47 61.7319 205.793 61.9099 205.962 61.9336C206.252 61.9748 208.798 61.2162 209.2 61.0935C209.449 61.0172 209.526 60.8779 209.549 60.783L205.877 61.6007C205.868 61.6024 205.859 61.6033 205.849 61.6034H205.849C205.824 61.6034 205.798 61.5956 205.777 61.5806L205.634 61.4808L205.205 61.1804V61.1798L205.032 61.0589C205.035 61.0687 205.038 61.0785 205.041 61.0881C205.051 61.1166 205.061 61.1455 205.071 61.1735V61.1742C205.083 61.2105 205.136 61.3633 205.232 61.5879M216.496 60.8827C216.52 60.7959 216.543 60.7081 216.564 60.6195L216.436 60.7091L216.093 60.9494L215.722 61.2095C215.703 61.2227 215.681 61.2306 215.658 61.2323C215.65 61.2328 215.643 61.2326 215.635 61.2318L211.937 60.8114L211.931 60.869C211.986 60.9288 212.074 60.986 212.213 61.0219C212.619 61.1273 215.195 61.7748 215.483 61.7207C215.705 61.6798 216.178 61.3613 216.385 61.2158C216.387 61.2107 216.389 61.2058 216.39 61.2009C216.427 61.0953 216.462 60.9892 216.496 60.8827Z"
            fill="#9F8F78"
          />
          <path
            d="M212.583 55.9008C212.554 55.9384 212.522 55.9797 212.488 56.0227C212.313 56.2446 212.069 56.5277 211.781 56.8054C211.436 56.7946 211.091 56.7892 210.746 56.7892C210.16 56.7892 209.598 56.8046 209.064 56.8303C209.819 56.5176 210.725 56.2119 211.706 56.0285C211.996 55.9731 212.289 55.9306 212.583 55.9008ZM208.17 56.2384C207.9 56.4276 207.596 56.6687 207.302 56.9616C206.647 57.027 205.994 57.1119 205.345 57.2164C206.18 56.8327 207.133 56.4792 208.17 56.2384ZM217.394 57.797L217.087 59.9451L215.616 60.9759L211.779 60.5396L211.202 58.6376C211.195 58.6149 211.182 58.5947 211.164 58.5791C211.146 58.5635 211.124 58.5532 211.101 58.5494C210.959 58.5265 210.833 58.5153 210.728 58.5153C210.623 58.5153 210.498 58.5265 210.355 58.5494C210.332 58.5534 210.31 58.5638 210.292 58.5794C210.274 58.5949 210.261 58.6151 210.254 58.6376L209.691 60.4934L205.876 61.3422L204.364 60.2831L204.066 57.8723C204.132 57.8356 204.198 57.7991 204.264 57.7627C204.357 57.7425 204.463 57.7212 204.579 57.6991L204.86 59.974C204.864 60.0094 204.884 60.0409 204.913 60.0612L205.953 60.7901C205.974 60.8045 206 60.8127 206.025 60.8127C206.034 60.8127 206.043 60.8114 206.053 60.8096L209.19 60.1117C209.2 60.1091 209.211 60.1052 209.221 60.1003C209.25 60.0847 209.273 60.0581 209.282 60.0252L209.848 58.1655C209.999 58.1268 210.387 58.0358 210.728 58.0358C211.069 58.0358 211.457 58.1268 211.609 58.1655L212.174 60.0252C212.188 60.0733 212.23 60.1084 212.28 60.1141L215.417 60.4705C215.447 60.4741 215.478 60.4657 215.503 60.4482L216.544 59.7207C216.572 59.7004 216.591 59.669 216.596 59.6348L216.874 57.6909C217.082 57.7308 217.257 57.7674 217.394 57.797ZM217.781 56.4496L217.511 57.4741C216.959 57.3523 215.746 57.1132 214.095 56.9523C214.634 56.7223 215.184 56.4342 215.685 56.0732C216.668 56.212 217.389 56.361 217.781 56.4496ZM203.712 56.4496L203.787 56.7333C203.97 56.5875 204.158 56.4485 204.352 56.3166C204.087 56.3673 203.872 56.4135 203.712 56.4496Z"
            fill="#6E6A67"
          />
          <path
            d="M214.304 55.8783C213.891 55.8548 213.478 55.8351 213.064 55.8179C213.018 55.8862 212.97 55.9536 212.921 56.02C212.7 56.3199 212.263 56.8666 211.703 57.3356C212.124 57.2021 213.796 56.6413 214.643 55.8991C214.53 55.8918 214.417 55.8848 214.304 55.8783ZM211.275 55.7691L211.276 55.7687C211.067 55.766 210.857 55.7637 210.647 55.7629H210.647C210.339 55.7638 210.031 55.7677 209.722 55.773L209.154 56.0426C209.151 56.0438 209.148 56.0454 209.145 56.0473C209.06 56.0889 208.313 56.4656 207.61 57.1378C207.672 57.1054 207.737 57.0718 207.804 57.0378C208.189 56.7794 209.214 56.1677 210.808 55.7645C210.964 55.7655 211.119 55.7664 211.275 55.7691ZM207.78 55.8378C207.516 55.8499 207.253 55.8634 206.99 55.8783C206.685 55.8954 206.381 55.916 206.077 55.9389C205.925 55.9505 205.774 55.9635 205.623 55.9792C205.58 55.9835 205.537 55.9882 205.494 55.9937C205.097 56.231 203.577 57.1851 202.533 58.4337C202.551 58.4121 202.57 58.3907 202.588 58.3693C204.521 56.72 206.641 56.0781 207.78 55.8378ZM216.525 62.6201L216.491 62.638C216.297 62.74 216.043 62.7898 215.714 62.7898C215.519 62.7898 215.327 62.7735 215.115 62.7543C214.691 62.7155 213.973 62.631 213.966 62.6296L213.911 62.6239L213.867 62.5888C213.861 62.5845 213.232 62.083 212.724 61.6834C212.703 61.6667 212.684 61.6507 212.667 61.6372C212.614 61.5914 212.614 61.5914 212.582 61.5914C212.418 61.5914 211.945 61.7385 210.907 62.0601L210.843 62.0805L210.78 62.0565C210.773 62.0547 210.092 61.8022 209.276 61.8022C209.209 61.8022 209.142 61.8039 209.077 61.8071C208.996 61.8113 208.537 62.0292 207.95 62.9573L207.912 63.0172L207.845 63.0388C207.835 63.042 206.825 63.3678 205.754 63.6742L205.685 63.6937L205.618 63.6632C205.612 63.6609 205.193 63.4663 204.795 63.2836C204.824 63.2972 204.854 63.3106 204.883 63.3243C205.277 63.6639 206.03 64.3172 206.114 64.4077C206.125 64.4207 206.142 64.4367 206.161 64.4547C206.141 64.4326 206.122 64.4102 206.104 64.3873L206.103 64.3865L206.103 64.3866C206.277 64.5512 206.471 64.6934 206.682 64.7935C206.788 64.8432 206.899 64.8816 207.011 64.9003C207.068 64.9096 207.123 64.9142 207.181 64.9142C207.239 64.9142 207.299 64.9125 207.358 64.9096C207.593 64.8975 207.831 64.8795 208.068 64.8565C208.305 64.8352 208.542 64.8115 208.778 64.7828C209.015 64.7574 209.251 64.7276 209.485 64.6913C209.602 64.6742 209.719 64.6548 209.833 64.6296C209.889 64.6164 209.947 64.6018 209.991 64.5819C210.032 64.5626 210.081 64.5237 210.124 64.4866C210.212 64.4108 210.297 64.3267 210.381 64.2428C210.466 64.1583 210.549 64.0724 210.63 63.9852C210.769 63.8399 210.888 63.6857 211.022 63.5362C211.039 63.5176 211.057 63.4978 211.075 63.4786C211.075 63.479 211.075 63.479 211.075 63.479L211.077 63.4807C211.105 63.5008 211.133 63.5212 211.16 63.5427C211.322 63.6632 211.488 63.7937 211.649 63.9063C211.857 64.0521 212.067 64.1982 212.284 64.3197C212.339 64.3499 212.395 64.3782 212.448 64.3959C212.455 64.3984 212.461 64.3996 212.466 64.4004C212.47 64.4028 212.485 64.4051 212.486 64.4051C212.497 64.4067 212.511 64.4074 212.525 64.4083C212.554 64.4087 212.584 64.4074 212.615 64.406C212.737 64.3974 212.861 64.3796 212.986 64.3601C213.234 64.3214 213.484 64.2766 213.731 64.227C213.979 64.1795 214.227 64.1286 214.474 64.0738C214.721 64.0212 214.967 63.9639 215.213 63.9019C215.334 63.8692 215.456 63.8389 215.565 63.7868C215.675 63.7352 215.778 63.6644 215.873 63.5832C216.064 63.4204 216.225 63.2185 216.359 62.9986L216.358 62.9993C216.424 62.8775 216.48 62.7507 216.525 62.6201ZM211.891 50.9385H212.329V50.0506H209.132V50.9385H209.57V50.4876H210.473V53.2299H210.101V53.7389H211.36V53.2299H210.987V50.4876H211.891V50.9385Z"
            fill="#93232C"
          />
          <path
            d="M215.198 55.9384C215.198 55.9379 215.197 55.9377 215.196 55.9376C215.015 55.924 214.834 55.9114 214.653 55.8997L214.642 55.8991C213.796 56.6413 212.124 57.2021 211.703 57.3356C211.694 57.3426 211.686 57.3495 211.678 57.3564C212.221 57.2587 213.031 57.065 213.872 56.6926C214.286 56.5095 214.707 56.2833 215.107 56.0038C215.138 55.9823 215.168 55.9598 215.198 55.9384ZM210.808 55.7645C209.214 56.1675 208.189 56.7793 207.804 57.0376C208.159 56.857 208.521 56.6896 208.888 56.5357C208.932 56.5173 208.977 56.499 209.021 56.4808C209.035 56.4751 209.049 56.4695 209.063 56.4638C209.1 56.4489 209.137 56.4342 209.175 56.4192C209.195 56.4111 209.216 56.4028 209.237 56.3947C209.271 56.3815 209.305 56.3684 209.339 56.3553C209.365 56.3455 209.39 56.3357 209.416 56.3261C209.448 56.3141 209.479 56.3023 209.511 56.2906C209.541 56.2796 209.571 56.2687 209.601 56.2579C209.631 56.2471 209.66 56.2366 209.69 56.2259C209.724 56.214 209.758 56.2022 209.792 56.1901C209.82 56.1808 209.847 56.1714 209.874 56.1621C209.914 56.1486 209.955 56.1351 209.995 56.1217C210.018 56.1143 210.04 56.1069 210.062 56.0996C210.126 56.079 210.191 56.0585 210.255 56.0387C210.397 55.9952 210.541 55.9538 210.688 55.9139C210.883 55.8609 211.078 55.8126 211.275 55.769C211.119 55.7664 210.964 55.7655 210.808 55.7645ZM207.78 55.8378C206.641 56.078 204.521 56.72 202.588 58.3693C202.57 58.3906 202.551 58.412 202.533 58.4337C203.516 57.7506 205.205 56.7351 207.293 56.1174C207.36 56.0974 207.428 56.078 207.497 56.0588C207.85 55.9599 208.206 55.8754 208.566 55.8056C208.304 55.8149 208.042 55.8258 207.78 55.8378ZM216.902 62.438C216.882 62.4472 216.862 62.4565 216.842 62.4659C216.831 62.4709 216.821 62.4759 216.81 62.4808L216.784 62.4931L216.744 62.512C216.739 62.5148 216.733 62.5173 216.727 62.5202C216.712 62.5273 216.698 62.5342 216.683 62.5414L216.673 62.5462C216.658 62.5541 216.642 62.5617 216.627 62.5693L216.622 62.5716C216.588 62.5884 216.556 62.6046 216.525 62.62C216.48 62.7507 216.424 62.8777 216.358 62.9996L216.358 62.9987C216.358 62.9991 216.358 62.9994 216.358 63C216.224 63.219 216.064 63.4203 215.873 63.5829C215.778 63.6641 215.675 63.7349 215.564 63.7865C215.456 63.8387 215.334 63.8688 215.212 63.9016C214.968 63.9632 214.721 64.0211 214.474 64.0735C214.227 64.1282 213.979 64.1793 213.731 64.2267C213.483 64.2765 213.234 64.3211 212.986 64.3598C212.861 64.3793 212.737 64.3971 212.614 64.4056C212.584 64.4073 212.554 64.4081 212.524 64.4079C212.512 64.4074 212.499 64.4063 212.486 64.4047C212.479 64.4041 212.473 64.4026 212.466 64.4001C212.46 64.3993 212.454 64.3978 212.448 64.3955C212.394 64.378 212.338 64.3495 212.284 64.3194C212.067 64.1977 211.857 64.0518 211.649 63.906C211.488 63.7933 211.321 63.6628 211.16 63.5424L211.146 63.5623L211.147 63.5634C211.157 63.5725 211.167 63.5809 211.177 63.5897L211.176 63.5893C211.169 63.5837 211.162 63.5783 211.155 63.5733L211.29 63.7349C211.291 63.7354 211.296 63.7416 211.306 63.7532C211.375 63.8344 211.664 64.1699 212.007 64.5105C212.269 64.7696 212.584 64.9005 212.946 64.9005C213.069 64.9005 213.199 64.8843 213.33 64.8531C213.452 64.8233 213.584 64.7919 213.719 64.7592C214.12 64.6638 214.564 64.5574 214.859 64.4808C214.879 64.4756 214.898 64.4707 214.916 64.4658C214.958 64.4548 214.996 64.4447 215.03 64.4353C215.087 64.4193 215.145 64.405 215.204 64.3923C215.561 64.3093 216.05 64.1959 216.309 63.6767C216.387 63.5219 216.465 63.3675 216.545 63.2135C216.674 62.9615 216.805 62.71 216.937 62.459C216.937 62.4589 216.937 62.4589 216.937 62.4589L216.963 62.4097L216.902 62.438ZM211.046 63.5579L211.022 63.5359C210.888 63.6855 210.769 63.8397 210.63 63.985C210.549 64.0723 210.466 64.1581 210.381 64.2426C210.297 64.3265 210.212 64.4109 210.124 64.4864C210.081 64.5235 210.032 64.5625 209.991 64.5817C209.947 64.6016 209.889 64.6162 209.833 64.6294C209.719 64.6547 209.602 64.674 209.485 64.6912C209.251 64.7274 209.015 64.7573 208.778 64.7826C208.542 64.8113 208.305 64.835 208.068 64.8563C207.831 64.8793 207.593 64.8973 207.358 64.9095C207.299 64.9122 207.239 64.9141 207.181 64.9141C207.123 64.9141 207.068 64.9095 207.011 64.9001C206.899 64.8815 206.788 64.8429 206.682 64.7934C206.471 64.6933 206.277 64.551 206.103 64.3865L206.104 64.387C206.127 64.4159 206.153 64.443 206.178 64.4705C206.172 64.465 206.166 64.4595 206.161 64.4544C206.142 64.4364 206.125 64.4205 206.114 64.4075C206.03 64.3169 205.276 63.6637 204.883 63.324C204.853 63.3103 204.824 63.297 204.795 63.2833C204.869 63.3935 204.944 63.5033 205.02 63.6125C205.136 63.78 205.254 63.9457 205.375 64.1096C205.427 64.18 205.48 64.2498 205.534 64.319C205.962 64.8694 206.5 65.3781 207.533 65.3781C207.663 65.3781 207.8 65.3701 207.942 65.3541C207.975 65.3506 208.007 65.3469 208.038 65.3431C208.069 65.3397 208.098 65.3364 208.127 65.333C209.026 65.2297 209.272 65.1856 209.409 65.162C209.444 65.1559 209.475 65.1505 209.507 65.1457C209.52 65.1439 209.533 65.1419 209.547 65.14C209.552 65.1396 209.856 65.1006 210.153 64.956C210.357 64.8567 210.559 64.7072 210.657 64.4863C210.906 63.9301 210.956 63.7971 210.958 63.7922L211.046 63.5579Z"
            fill="#731B2A"
          />
          <path
            d="M213.48 58.507C213.533 58.5059 213.583 58.484 213.62 58.446C213.656 58.4081 213.676 58.3571 213.676 58.3044C213.675 58.2782 213.67 58.2524 213.659 58.2283C213.649 58.2043 213.634 58.1826 213.615 58.1644C213.596 58.1462 213.574 58.132 213.549 58.1225C213.525 58.1129 213.499 58.1083 213.473 58.1089C213.447 58.1094 213.421 58.115 213.397 58.1254C213.373 58.1359 213.351 58.1509 213.333 58.1698C213.315 58.1886 213.301 58.2108 213.291 58.2352C213.282 58.2595 213.277 58.2855 213.278 58.3117C213.279 58.3644 213.3 58.4146 213.338 58.4513C213.376 58.4879 213.427 58.508 213.48 58.507ZM214.704 59.4037C214.442 59.2766 214.154 59.4374 213.631 59.4472C213.241 59.4612 212.915 59.4654 212.893 58.8541C212.872 58.2414 213.121 57.7351 213.51 57.7216C213.9 57.708 214.255 58.1933 214.303 58.8039C214.316 58.9724 214.298 59.0952 214.256 59.1862C214.618 59.143 214.701 59.3888 214.704 59.4037ZM207.9 58.6547C207.953 58.6533 208.003 58.631 208.039 58.5927C208.076 58.5545 208.095 58.5034 208.094 58.4507C208.092 58.3979 208.07 58.3478 208.032 58.3114C207.994 58.2751 207.942 58.2554 207.89 58.2568C207.863 58.2575 207.838 58.2633 207.814 58.274C207.79 58.2846 207.768 58.2999 207.75 58.3189C207.733 58.3378 207.718 58.3602 207.709 58.3846C207.7 58.409 207.695 58.435 207.696 58.4611C207.697 58.4872 207.703 58.513 207.713 58.5368C207.724 58.5607 207.739 58.5822 207.758 58.6002C207.777 58.6182 207.799 58.6322 207.824 58.6416C207.848 58.6509 207.874 58.6554 207.9 58.6547V58.6547ZM208.502 58.9751C208.508 59.5869 208.184 59.5501 207.794 59.5539C207.754 59.5552 207.717 59.5557 207.68 59.5557C207.636 59.5569 207.594 59.5574 207.554 59.5566C207.175 59.5557 206.934 59.5389 206.72 59.6545C206.725 59.6412 206.819 59.4312 207.158 59.3456C207.121 59.2629 207.097 59.1479 207.091 58.9887C207.068 58.3772 207.445 57.8757 207.835 57.8722C208.224 57.8683 208.496 58.3633 208.502 58.9751ZM215.881 54.7681C215.878 54.8058 215.875 54.8434 215.87 54.8809C215.716 54.8392 215.561 54.8004 215.405 54.7643C214.89 54.6513 214.369 54.5674 213.846 54.5077C213.828 54.5053 213.809 54.5041 213.791 54.5018C213.794 54.494 213.798 54.4863 213.8 54.4785C213.816 54.4214 213.829 54.3641 213.842 54.3068C213.977 53.7097 213.97 53.1149 213.955 52.8271L215.817 53.3565C215.918 54.0181 215.899 54.5372 215.881 54.7681ZM213.565 54.4135C213.559 54.4349 213.56 54.4571 213.565 54.4777C213.37 54.4573 213.175 54.4393 212.98 54.4237C213.199 53.9652 213.247 53.4769 213.257 53.3048C213.425 53.1856 213.592 53.0422 213.715 52.9308C213.726 53.2593 213.718 53.8556 213.565 54.4135H213.565ZM207.829 54.4765C207.834 54.4568 207.834 54.4349 207.829 54.4135C207.676 53.8564 207.668 53.2602 207.678 52.9308C207.801 53.0422 207.968 53.1856 208.137 53.3048C208.147 53.4769 208.194 53.964 208.413 54.4226C208.218 54.4379 208.023 54.4558 207.829 54.4765ZM207.547 54.5072C207.286 54.5391 207.025 54.572 206.765 54.6151C206.505 54.6596 206.245 54.7068 205.988 54.7639C205.832 54.8002 205.678 54.8386 205.523 54.8805C205.521 54.8682 205.519 54.8494 205.517 54.8251C205.499 54.6332 205.465 54.0804 205.577 53.3563L207.438 52.8268C207.424 53.1039 207.416 53.6653 207.536 54.2394C207.553 54.3191 207.572 54.3989 207.593 54.4782C207.596 54.486 207.599 54.4939 207.602 54.5008C207.584 54.5032 207.566 54.5048 207.547 54.5072L207.547 54.5072ZM216.879 55.2589C216.863 55.2513 216.847 55.2436 216.832 55.2362C216.809 55.2251 216.784 55.2124 216.755 55.1982C216.737 55.1896 216.719 55.1799 216.703 55.1691C216.53 55.0895 216.35 55.0278 216.17 54.9686C216.148 54.9616 216.127 54.9554 216.106 54.9491C216.108 54.9438 216.109 54.9384 216.11 54.9328C216.113 54.9124 216.159 54.5701 216.131 54.0304C216.119 53.8 216.094 53.5335 216.045 53.2407C216.042 53.2179 216.031 53.1967 216.016 53.1794C216.001 53.1621 215.981 53.1496 215.959 53.1432L215.693 53.0681C215.636 51.0146 214.791 50.0496 214.764 50.0197C215.519 51.2353 215.513 52.677 215.5 53.0129L213.854 52.5452C213.853 52.5452 213.852 52.5452 213.85 52.5445C213.844 52.543 213.836 52.542 213.829 52.5414C213.828 52.5414 213.826 52.5411 213.823 52.5411C213.814 52.5407 213.805 52.5414 213.796 52.5434C213.795 52.5434 213.794 52.5446 213.792 52.5446C213.785 52.5461 213.778 52.5486 213.771 52.5519C213.768 52.5531 213.766 52.5548 213.763 52.5555C213.758 52.5592 213.753 52.5624 213.747 52.5663C213.746 52.5671 213.744 52.5678 213.743 52.569C213.742 52.5701 213.741 52.5713 213.74 52.5721C213.738 52.5737 213.737 52.5748 213.735 52.576C213.734 52.5777 213.689 52.621 213.621 52.686C213.625 52.5321 213.627 52.2966 213.609 52.009L213.604 51.926C213.552 51.2036 213.381 50.1888 212.871 49.3004C212.875 49.3132 212.926 49.4605 212.991 49.7088C213.155 50.3334 213.414 51.5976 213.273 52.9694C213.272 52.9757 213.272 52.9819 213.271 52.9882C213.269 52.99 213.267 52.9916 213.265 52.9933C213.201 53.044 213.136 53.0923 213.07 53.1381C213.053 53.1492 213.04 53.164 213.031 53.1812C213.022 53.1985 213.016 53.2176 213.016 53.2372C213.016 53.2434 213.001 53.8567 212.731 54.3789C212.726 54.3874 212.724 54.396 212.721 54.4049C212.047 54.3587 211.371 54.339 210.697 54.3385C210.022 54.339 209.346 54.3575 208.672 54.4034C208.67 54.3952 208.667 54.3867 208.663 54.3788C208.392 53.8567 208.378 53.2434 208.377 53.2372C208.377 53.2176 208.372 53.1984 208.363 53.1812C208.354 53.164 208.34 53.1492 208.324 53.1381C208.255 53.0908 208.187 53.0408 208.122 52.9881C207.985 51.6831 208.211 50.4739 208.375 49.8159C208.453 49.5035 208.518 49.3147 208.523 49.3003C207.782 50.5889 207.757 52.1437 207.773 52.6859C207.703 52.6209 207.659 52.5777 207.658 52.5759C207.657 52.5747 207.655 52.5737 207.653 52.572L207.651 52.5688C207.649 52.5678 207.648 52.5671 207.646 52.5662C207.641 52.5625 207.636 52.5592 207.63 52.5562C207.627 52.5547 207.625 52.5531 207.622 52.5518C207.616 52.5485 207.609 52.5462 207.602 52.5452C207.6 52.5445 207.598 52.5433 207.597 52.5433C207.588 52.5414 207.579 52.5407 207.57 52.541C207.568 52.541 207.565 52.5413 207.563 52.5413C207.556 52.542 207.55 52.5428 207.543 52.5445C207.541 52.5452 207.54 52.5452 207.539 52.5452L205.894 53.0129C205.881 52.6768 205.874 51.2352 206.629 50.0196C206.603 50.0497 205.758 51.0148 205.7 53.0682L205.436 53.1432C205.413 53.1494 205.393 53.1619 205.378 53.1792C205.362 53.1965 205.352 53.2179 205.348 53.2409C205.305 53.502 205.276 53.7654 205.262 54.0297C205.235 54.5699 205.281 54.9126 205.284 54.933C205.285 54.9384 205.287 54.9437 205.287 54.949C205.266 54.9555 205.245 54.9618 205.224 54.9684C205.043 55.0275 204.862 55.0895 204.69 55.1694C204.674 55.1795 204.658 55.1887 204.641 55.1969L204.638 55.1984C204.609 55.2126 204.583 55.2252 204.56 55.2363L204.52 55.2561C204.511 55.2611 204.503 55.2653 204.494 55.2704C204.616 55.2225 204.742 55.1875 204.869 55.1565C204.995 55.125 205.122 55.0972 205.25 55.0729C205.506 55.0253 205.763 54.9839 206.021 54.9525C206.279 54.9186 206.538 54.8907 206.797 54.869C207.056 54.8469 207.315 54.8251 207.574 54.8101C208.613 54.7486 209.655 54.7292 210.697 54.7288C211.739 54.7295 212.78 54.7459 213.819 54.8097C214.079 54.8247 214.338 54.8464 214.597 54.8684C214.857 54.8904 215.114 54.9187 215.372 54.9525C215.63 54.9836 215.888 55.0248 216.143 55.0727C216.271 55.0968 216.398 55.1247 216.524 55.1565C216.651 55.1876 216.777 55.2225 216.899 55.2704C216.892 55.2663 216.886 55.2628 216.879 55.2589Z"
            fill="#0E0F0D"
          />
          <path
            d="M210.988 50.4875V53.2298H211.36V53.7388H210.102V53.2298H210.474V50.4875H209.57V50.9385H209.133V50.0506H212.329V50.9385H211.892V50.4874L210.988 50.4875ZM212.658 51.2668V49.7218H208.805V51.2668H209.899V50.8158H210.145V52.9008H209.774V54.0666H211.689V52.9007H211.316V50.8157H211.563V51.2667L212.658 51.2668Z"
            fill="#0E0F0D"
          />
        </g>
        <g filter="url(#filter5_d_17_1136)">
          <path
            d="M248 51C248 44.3726 253.373 39 260 39H272C278.627 39 284 44.3726 284 51V63C284 69.6274 278.627 75 272 75H260C253.373 75 248 69.6274 248 63V51Z"
            fill="black"
          />
          <path
            d="M272 38.5C278.904 38.5 284.5 44.0964 284.5 51V63C284.5 69.9036 278.904 75.5 272 75.5H260C253.096 75.5 247.5 69.9036 247.5 63V51C247.5 44.0964 253.096 38.5 260 38.5H272Z"
            stroke="white"
            strokeOpacity="0.145"
          />
          <g clipPath="url(#clip2_17_1136)">
            <path
              d="M265.825 55.116C264.769 55.116 263.903 55.9765 263.903 57.0252C263.903 58.1008 264.742 58.9344 265.825 58.9344C266.88 58.9344 267.746 58.0739 267.746 57.0252C267.746 55.9765 266.88 55.116 265.825 55.116Z"
              fill="white"
            />
            <path
              d="M258.003 55.0622C258.896 51.5933 262.063 49.0386 265.825 49.0386C270.263 49.0386 273.863 52.6151 273.863 57.0521C273.863 61.4621 270.263 65.0386 265.825 65.0386C262.063 65.0386 258.896 62.484 258.003 59.0151V58.9344C258.003 58.7193 258.165 58.558 258.382 58.5849H261.63C261.792 58.5849 261.927 58.6656 261.981 58.8C262.658 60.2521 264.12 61.247 265.825 61.247C268.152 61.247 270.047 59.3647 270.047 57.0521C270.047 54.7395 268.152 52.8571 265.825 52.8571C264.12 52.8571 262.658 53.8521 261.981 55.3042C261.927 55.4386 261.792 55.5193 261.63 55.5193H258.382C258.165 55.5193 258.003 55.3579 258.003 55.1428V55.0622Z"
              fill="white"
            />
          </g>
        </g>
        <g clipPath="url(#clip3_17_1136)">
          <path
            d="M152.987 147.594C147.254 147.594 142.59 152.262 142.59 158C142.59 163.738 147.254 168.406 152.987 168.406C158.721 168.406 163.385 163.738 163.385 158C163.385 152.262 158.721 147.594 152.987 147.594ZM152.987 163.385C150.015 163.385 147.607 160.974 147.607 158C147.607 155.026 150.015 152.615 152.987 152.615C155.959 152.615 158.368 155.026 158.368 158C158.368 160.974 155.959 163.385 152.987 163.385Z"
            fill="white"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M153.859 145.885V142C162.297 142.451 169 149.443 169 158C169 166.557 162.297 173.547 153.859 174V170.115C160.148 169.665 165.128 164.406 165.128 158C165.128 151.594 160.148 146.335 153.859 145.885ZM143.817 165.945C142.15 164.019 141.076 161.565 140.884 158.872H137C137.201 162.641 138.708 166.061 141.068 168.694L143.816 165.945H143.817ZM152.116 174V170.115C149.423 169.923 146.972 168.85 145.047 167.179L142.299 169.929C144.933 172.293 148.35 173.798 152.114 174H152.116Z"
            fill="url(#paint0_linear_17_1136)"
          />
        </g>
        <defs>
          <filter
            id="filter0_d_17_1136"
            x="123.414"
            y="129.276"
            width="59.1729"
            height="59.1724"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="0.862069" />
            <feGaussianBlur stdDeviation="0.862069" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1136"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1136"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_17_1136"
            x="21"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1136"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1136"
              result="shape"
            />
          </filter>
          <filter
            id="filter2_d_17_1136"
            x="77"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1136"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1136"
              result="shape"
            />
          </filter>
          <filter
            id="filter3_d_17_1136"
            x="133"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1136"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1136"
              result="shape"
            />
          </filter>
          <filter
            id="filter4_d_17_1136"
            x="189"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1136"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1136"
              result="shape"
            />
          </filter>
          <filter
            id="filter5_d_17_1136"
            x="245"
            y="37"
            width="42"
            height="42"
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity="0" result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy="1" />
            <feGaussianBlur stdDeviation="1" />
            <feColorMatrix
              type="matrix"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
            />
            <feBlend
              mode="normal"
              in2="BackgroundImageFix"
              result="effect1_dropShadow_17_1136"
            />
            <feBlend
              mode="normal"
              in="SourceGraphic"
              in2="effect1_dropShadow_17_1136"
              result="shape"
            />
          </filter>
          <linearGradient
            id="paint0_linear_17_1136"
            x1="154.486"
            y1="144.25"
            x2="138.736"
            y2="159.988"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#0096FF" />
            <stop offset="1" stopColor="#FF1E56" />
          </linearGradient>
          <clipPath id="clip0_17_1136">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(34 49)"
            />
          </clipPath>
          <clipPath id="clip1_17_1136">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(90 49)"
            />
          </clipPath>
          <clipPath id="clip2_17_1136">
            <rect
              width="16"
              height="16"
              fill="white"
              transform="translate(258 49)"
            />
          </clipPath>
          <clipPath id="clip3_17_1136">
            <rect
              width="32"
              height="32"
              fill="white"
              transform="translate(137 142)"
            />
          </clipPath>
        </defs>
      </svg>
    </div>
  );
};
