// Copyright © 2023 OpenIM. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.26.0
// source: user/user.proto

package user

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	User_GetDesignateUsers_FullMethodName             = "/openim.user.user/getDesignateUsers"
	User_UpdateUserInfo_FullMethodName                = "/openim.user.user/updateUserInfo"
	User_UpdateUserInfoEx_FullMethodName              = "/openim.user.user/updateUserInfoEx"
	User_SetGlobalRecvMessageOpt_FullMethodName       = "/openim.user.user/setGlobalRecvMessageOpt"
	User_GetGlobalRecvMessageOpt_FullMethodName       = "/openim.user.user/getGlobalRecvMessageOpt"
	User_AccountCheck_FullMethodName                  = "/openim.user.user/accountCheck"
	User_GetPaginationUsers_FullMethodName            = "/openim.user.user/getPaginationUsers"
	User_UserRegister_FullMethodName                  = "/openim.user.user/userRegister"
	User_GetAllUserID_FullMethodName                  = "/openim.user.user/getAllUserID"
	User_UserRegisterCount_FullMethodName             = "/openim.user.user/userRegisterCount"
	User_SubscribeOrCancelUsersStatus_FullMethodName  = "/openim.user.user/subscribeOrCancelUsersStatus"
	User_GetSubscribeUsersStatus_FullMethodName       = "/openim.user.user/getSubscribeUsersStatus"
	User_GetUserStatus_FullMethodName                 = "/openim.user.user/getUserStatus"
	User_SetUserStatus_FullMethodName                 = "/openim.user.user/setUserStatus"
	User_ProcessUserCommandAdd_FullMethodName         = "/openim.user.user/processUserCommandAdd"
	User_ProcessUserCommandUpdate_FullMethodName      = "/openim.user.user/processUserCommandUpdate"
	User_ProcessUserCommandDelete_FullMethodName      = "/openim.user.user/processUserCommandDelete"
	User_ProcessUserCommandGet_FullMethodName         = "/openim.user.user/processUserCommandGet"
	User_ProcessUserCommandGetAll_FullMethodName      = "/openim.user.user/processUserCommandGetAll"
	User_AddNotificationAccount_FullMethodName        = "/openim.user.user/addNotificationAccount"
	User_UpdateNotificationAccountInfo_FullMethodName = "/openim.user.user/updateNotificationAccountInfo"
	User_SearchNotificationAccount_FullMethodName     = "/openim.user.user/searchNotificationAccount"
	User_GetNotificationAccount_FullMethodName        = "/openim.user.user/getNotificationAccount"
	User_SortQuery_FullMethodName                     = "/openim.user.user/sortQuery"
	User_SetUserOnlineStatus_FullMethodName           = "/openim.user.user/setUserOnlineStatus"
	User_GetAllOnlineUsers_FullMethodName             = "/openim.user.user/getAllOnlineUsers"
)

// UserClient is the client API for User service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type UserClient interface {
	// Get the specified user information full field
	GetDesignateUsers(ctx context.Context, in *GetDesignateUsersReq, opts ...grpc.CallOption) (*GetDesignateUsersResp, error)
	// update user information
	UpdateUserInfo(ctx context.Context, in *UpdateUserInfoReq, opts ...grpc.CallOption) (*UpdateUserInfoResp, error)
	UpdateUserInfoEx(ctx context.Context, in *UpdateUserInfoExReq, opts ...grpc.CallOption) (*UpdateUserInfoExResp, error)
	// Set user message receiving options
	SetGlobalRecvMessageOpt(ctx context.Context, in *SetGlobalRecvMessageOptReq, opts ...grpc.CallOption) (*SetGlobalRecvMessageOptResp, error)
	// Get the user message receiving option If not found, no error will be returned
	GetGlobalRecvMessageOpt(ctx context.Context, in *GetGlobalRecvMessageOptReq, opts ...grpc.CallOption) (*GetGlobalRecvMessageOptResp, error)
	// Check if userID exists
	AccountCheck(ctx context.Context, in *AccountCheckReq, opts ...grpc.CallOption) (*AccountCheckResp, error)
	// Turn the page (or specify userID, nickname) to pull user information Full field
	GetPaginationUsers(ctx context.Context, in *GetPaginationUsersReq, opts ...grpc.CallOption) (*GetPaginationUsersResp, error)
	// user registration
	UserRegister(ctx context.Context, in *UserRegisterReq, opts ...grpc.CallOption) (*UserRegisterResp, error)
	// Get all user IDs
	GetAllUserID(ctx context.Context, in *GetAllUserIDReq, opts ...grpc.CallOption) (*GetAllUserIDResp, error)
	// Get the total number of users and the user increment within a specified time period
	UserRegisterCount(ctx context.Context, in *UserRegisterCountReq, opts ...grpc.CallOption) (*UserRegisterCountResp, error)
	// Subscribe or unsubscribe user presence
	SubscribeOrCancelUsersStatus(ctx context.Context, in *SubscribeOrCancelUsersStatusReq, opts ...grpc.CallOption) (*SubscribeOrCancelUsersStatusResp, error)
	// Get the online status of subscribers
	GetSubscribeUsersStatus(ctx context.Context, in *GetSubscribeUsersStatusReq, opts ...grpc.CallOption) (*GetSubscribeUsersStatusResp, error)
	// Get user online status
	GetUserStatus(ctx context.Context, in *GetUserStatusReq, opts ...grpc.CallOption) (*GetUserStatusResp, error)
	// The gateway synchronizes the online status of users in redis
	SetUserStatus(ctx context.Context, in *SetUserStatusReq, opts ...grpc.CallOption) (*SetUserStatusResp, error)
	// add a general function for add
	ProcessUserCommandAdd(ctx context.Context, in *ProcessUserCommandAddReq, opts ...grpc.CallOption) (*ProcessUserCommandAddResp, error)
	// add a general function for update
	ProcessUserCommandUpdate(ctx context.Context, in *ProcessUserCommandUpdateReq, opts ...grpc.CallOption) (*ProcessUserCommandUpdateResp, error)
	// add a general function for delete
	ProcessUserCommandDelete(ctx context.Context, in *ProcessUserCommandDeleteReq, opts ...grpc.CallOption) (*ProcessUserCommandDeleteResp, error)
	// add a general function for get
	ProcessUserCommandGet(ctx context.Context, in *ProcessUserCommandGetReq, opts ...grpc.CallOption) (*ProcessUserCommandGetResp, error)
	// add a general function for get all
	ProcessUserCommandGetAll(ctx context.Context, in *ProcessUserCommandGetAllReq, opts ...grpc.CallOption) (*ProcessUserCommandGetAllResp, error)
	// add a system notification account
	AddNotificationAccount(ctx context.Context, in *AddNotificationAccountReq, opts ...grpc.CallOption) (*AddNotificationAccountResp, error)
	// update the system notification info
	UpdateNotificationAccountInfo(ctx context.Context, in *UpdateNotificationAccountInfoReq, opts ...grpc.CallOption) (*UpdateNotificationAccountInfoResp, error)
	// search the system notification account
	SearchNotificationAccount(ctx context.Context, in *SearchNotificationAccountReq, opts ...grpc.CallOption) (*SearchNotificationAccountResp, error)
	// getNotificationAccount by userID
	GetNotificationAccount(ctx context.Context, in *GetNotificationAccountReq, opts ...grpc.CallOption) (*GetNotificationAccountResp, error)
	SortQuery(ctx context.Context, in *SortQueryReq, opts ...grpc.CallOption) (*SortQueryResp, error)
	SetUserOnlineStatus(ctx context.Context, in *SetUserOnlineStatusReq, opts ...grpc.CallOption) (*SetUserOnlineStatusResp, error)
	// get all online users
	GetAllOnlineUsers(ctx context.Context, in *GetAllOnlineUsersReq, opts ...grpc.CallOption) (*GetAllOnlineUsersResp, error)
}

type userClient struct {
	cc grpc.ClientConnInterface
}

func NewUserClient(cc grpc.ClientConnInterface) UserClient {
	return &userClient{cc}
}

func (c *userClient) GetDesignateUsers(ctx context.Context, in *GetDesignateUsersReq, opts ...grpc.CallOption) (*GetDesignateUsersResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetDesignateUsersResp)
	err := c.cc.Invoke(ctx, User_GetDesignateUsers_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) UpdateUserInfo(ctx context.Context, in *UpdateUserInfoReq, opts ...grpc.CallOption) (*UpdateUserInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpdateUserInfoResp)
	err := c.cc.Invoke(ctx, User_UpdateUserInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) UpdateUserInfoEx(ctx context.Context, in *UpdateUserInfoExReq, opts ...grpc.CallOption) (*UpdateUserInfoExResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpdateUserInfoExResp)
	err := c.cc.Invoke(ctx, User_UpdateUserInfoEx_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) SetGlobalRecvMessageOpt(ctx context.Context, in *SetGlobalRecvMessageOptReq, opts ...grpc.CallOption) (*SetGlobalRecvMessageOptResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetGlobalRecvMessageOptResp)
	err := c.cc.Invoke(ctx, User_SetGlobalRecvMessageOpt_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) GetGlobalRecvMessageOpt(ctx context.Context, in *GetGlobalRecvMessageOptReq, opts ...grpc.CallOption) (*GetGlobalRecvMessageOptResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetGlobalRecvMessageOptResp)
	err := c.cc.Invoke(ctx, User_GetGlobalRecvMessageOpt_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) AccountCheck(ctx context.Context, in *AccountCheckReq, opts ...grpc.CallOption) (*AccountCheckResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(AccountCheckResp)
	err := c.cc.Invoke(ctx, User_AccountCheck_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) GetPaginationUsers(ctx context.Context, in *GetPaginationUsersReq, opts ...grpc.CallOption) (*GetPaginationUsersResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetPaginationUsersResp)
	err := c.cc.Invoke(ctx, User_GetPaginationUsers_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) UserRegister(ctx context.Context, in *UserRegisterReq, opts ...grpc.CallOption) (*UserRegisterResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserRegisterResp)
	err := c.cc.Invoke(ctx, User_UserRegister_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) GetAllUserID(ctx context.Context, in *GetAllUserIDReq, opts ...grpc.CallOption) (*GetAllUserIDResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetAllUserIDResp)
	err := c.cc.Invoke(ctx, User_GetAllUserID_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) UserRegisterCount(ctx context.Context, in *UserRegisterCountReq, opts ...grpc.CallOption) (*UserRegisterCountResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserRegisterCountResp)
	err := c.cc.Invoke(ctx, User_UserRegisterCount_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) SubscribeOrCancelUsersStatus(ctx context.Context, in *SubscribeOrCancelUsersStatusReq, opts ...grpc.CallOption) (*SubscribeOrCancelUsersStatusResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SubscribeOrCancelUsersStatusResp)
	err := c.cc.Invoke(ctx, User_SubscribeOrCancelUsersStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) GetSubscribeUsersStatus(ctx context.Context, in *GetSubscribeUsersStatusReq, opts ...grpc.CallOption) (*GetSubscribeUsersStatusResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetSubscribeUsersStatusResp)
	err := c.cc.Invoke(ctx, User_GetSubscribeUsersStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) GetUserStatus(ctx context.Context, in *GetUserStatusReq, opts ...grpc.CallOption) (*GetUserStatusResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetUserStatusResp)
	err := c.cc.Invoke(ctx, User_GetUserStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) SetUserStatus(ctx context.Context, in *SetUserStatusReq, opts ...grpc.CallOption) (*SetUserStatusResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetUserStatusResp)
	err := c.cc.Invoke(ctx, User_SetUserStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) ProcessUserCommandAdd(ctx context.Context, in *ProcessUserCommandAddReq, opts ...grpc.CallOption) (*ProcessUserCommandAddResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ProcessUserCommandAddResp)
	err := c.cc.Invoke(ctx, User_ProcessUserCommandAdd_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) ProcessUserCommandUpdate(ctx context.Context, in *ProcessUserCommandUpdateReq, opts ...grpc.CallOption) (*ProcessUserCommandUpdateResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ProcessUserCommandUpdateResp)
	err := c.cc.Invoke(ctx, User_ProcessUserCommandUpdate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) ProcessUserCommandDelete(ctx context.Context, in *ProcessUserCommandDeleteReq, opts ...grpc.CallOption) (*ProcessUserCommandDeleteResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ProcessUserCommandDeleteResp)
	err := c.cc.Invoke(ctx, User_ProcessUserCommandDelete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) ProcessUserCommandGet(ctx context.Context, in *ProcessUserCommandGetReq, opts ...grpc.CallOption) (*ProcessUserCommandGetResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ProcessUserCommandGetResp)
	err := c.cc.Invoke(ctx, User_ProcessUserCommandGet_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) ProcessUserCommandGetAll(ctx context.Context, in *ProcessUserCommandGetAllReq, opts ...grpc.CallOption) (*ProcessUserCommandGetAllResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ProcessUserCommandGetAllResp)
	err := c.cc.Invoke(ctx, User_ProcessUserCommandGetAll_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) AddNotificationAccount(ctx context.Context, in *AddNotificationAccountReq, opts ...grpc.CallOption) (*AddNotificationAccountResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(AddNotificationAccountResp)
	err := c.cc.Invoke(ctx, User_AddNotificationAccount_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) UpdateNotificationAccountInfo(ctx context.Context, in *UpdateNotificationAccountInfoReq, opts ...grpc.CallOption) (*UpdateNotificationAccountInfoResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpdateNotificationAccountInfoResp)
	err := c.cc.Invoke(ctx, User_UpdateNotificationAccountInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) SearchNotificationAccount(ctx context.Context, in *SearchNotificationAccountReq, opts ...grpc.CallOption) (*SearchNotificationAccountResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SearchNotificationAccountResp)
	err := c.cc.Invoke(ctx, User_SearchNotificationAccount_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) GetNotificationAccount(ctx context.Context, in *GetNotificationAccountReq, opts ...grpc.CallOption) (*GetNotificationAccountResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetNotificationAccountResp)
	err := c.cc.Invoke(ctx, User_GetNotificationAccount_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) SortQuery(ctx context.Context, in *SortQueryReq, opts ...grpc.CallOption) (*SortQueryResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SortQueryResp)
	err := c.cc.Invoke(ctx, User_SortQuery_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) SetUserOnlineStatus(ctx context.Context, in *SetUserOnlineStatusReq, opts ...grpc.CallOption) (*SetUserOnlineStatusResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetUserOnlineStatusResp)
	err := c.cc.Invoke(ctx, User_SetUserOnlineStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userClient) GetAllOnlineUsers(ctx context.Context, in *GetAllOnlineUsersReq, opts ...grpc.CallOption) (*GetAllOnlineUsersResp, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetAllOnlineUsersResp)
	err := c.cc.Invoke(ctx, User_GetAllOnlineUsers_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserServer is the server API for User service.
// All implementations must embed UnimplementedUserServer
// for forward compatibility.
type UserServer interface {
	// Get the specified user information full field
	GetDesignateUsers(context.Context, *GetDesignateUsersReq) (*GetDesignateUsersResp, error)
	// update user information
	UpdateUserInfo(context.Context, *UpdateUserInfoReq) (*UpdateUserInfoResp, error)
	UpdateUserInfoEx(context.Context, *UpdateUserInfoExReq) (*UpdateUserInfoExResp, error)
	// Set user message receiving options
	SetGlobalRecvMessageOpt(context.Context, *SetGlobalRecvMessageOptReq) (*SetGlobalRecvMessageOptResp, error)
	// Get the user message receiving option If not found, no error will be returned
	GetGlobalRecvMessageOpt(context.Context, *GetGlobalRecvMessageOptReq) (*GetGlobalRecvMessageOptResp, error)
	// Check if userID exists
	AccountCheck(context.Context, *AccountCheckReq) (*AccountCheckResp, error)
	// Turn the page (or specify userID, nickname) to pull user information Full field
	GetPaginationUsers(context.Context, *GetPaginationUsersReq) (*GetPaginationUsersResp, error)
	// user registration
	UserRegister(context.Context, *UserRegisterReq) (*UserRegisterResp, error)
	// Get all user IDs
	GetAllUserID(context.Context, *GetAllUserIDReq) (*GetAllUserIDResp, error)
	// Get the total number of users and the user increment within a specified time period
	UserRegisterCount(context.Context, *UserRegisterCountReq) (*UserRegisterCountResp, error)
	// Subscribe or unsubscribe user presence
	SubscribeOrCancelUsersStatus(context.Context, *SubscribeOrCancelUsersStatusReq) (*SubscribeOrCancelUsersStatusResp, error)
	// Get the online status of subscribers
	GetSubscribeUsersStatus(context.Context, *GetSubscribeUsersStatusReq) (*GetSubscribeUsersStatusResp, error)
	// Get user online status
	GetUserStatus(context.Context, *GetUserStatusReq) (*GetUserStatusResp, error)
	// The gateway synchronizes the online status of users in redis
	SetUserStatus(context.Context, *SetUserStatusReq) (*SetUserStatusResp, error)
	// add a general function for add
	ProcessUserCommandAdd(context.Context, *ProcessUserCommandAddReq) (*ProcessUserCommandAddResp, error)
	// add a general function for update
	ProcessUserCommandUpdate(context.Context, *ProcessUserCommandUpdateReq) (*ProcessUserCommandUpdateResp, error)
	// add a general function for delete
	ProcessUserCommandDelete(context.Context, *ProcessUserCommandDeleteReq) (*ProcessUserCommandDeleteResp, error)
	// add a general function for get
	ProcessUserCommandGet(context.Context, *ProcessUserCommandGetReq) (*ProcessUserCommandGetResp, error)
	// add a general function for get all
	ProcessUserCommandGetAll(context.Context, *ProcessUserCommandGetAllReq) (*ProcessUserCommandGetAllResp, error)
	// add a system notification account
	AddNotificationAccount(context.Context, *AddNotificationAccountReq) (*AddNotificationAccountResp, error)
	// update the system notification info
	UpdateNotificationAccountInfo(context.Context, *UpdateNotificationAccountInfoReq) (*UpdateNotificationAccountInfoResp, error)
	// search the system notification account
	SearchNotificationAccount(context.Context, *SearchNotificationAccountReq) (*SearchNotificationAccountResp, error)
	// getNotificationAccount by userID
	GetNotificationAccount(context.Context, *GetNotificationAccountReq) (*GetNotificationAccountResp, error)
	SortQuery(context.Context, *SortQueryReq) (*SortQueryResp, error)
	SetUserOnlineStatus(context.Context, *SetUserOnlineStatusReq) (*SetUserOnlineStatusResp, error)
	// get all online users
	GetAllOnlineUsers(context.Context, *GetAllOnlineUsersReq) (*GetAllOnlineUsersResp, error)
	mustEmbedUnimplementedUserServer()
}

// UnimplementedUserServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedUserServer struct{}

func (UnimplementedUserServer) GetDesignateUsers(context.Context, *GetDesignateUsersReq) (*GetDesignateUsersResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDesignateUsers not implemented")
}
func (UnimplementedUserServer) UpdateUserInfo(context.Context, *UpdateUserInfoReq) (*UpdateUserInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUserInfo not implemented")
}
func (UnimplementedUserServer) UpdateUserInfoEx(context.Context, *UpdateUserInfoExReq) (*UpdateUserInfoExResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUserInfoEx not implemented")
}
func (UnimplementedUserServer) SetGlobalRecvMessageOpt(context.Context, *SetGlobalRecvMessageOptReq) (*SetGlobalRecvMessageOptResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetGlobalRecvMessageOpt not implemented")
}
func (UnimplementedUserServer) GetGlobalRecvMessageOpt(context.Context, *GetGlobalRecvMessageOptReq) (*GetGlobalRecvMessageOptResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlobalRecvMessageOpt not implemented")
}
func (UnimplementedUserServer) AccountCheck(context.Context, *AccountCheckReq) (*AccountCheckResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AccountCheck not implemented")
}
func (UnimplementedUserServer) GetPaginationUsers(context.Context, *GetPaginationUsersReq) (*GetPaginationUsersResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPaginationUsers not implemented")
}
func (UnimplementedUserServer) UserRegister(context.Context, *UserRegisterReq) (*UserRegisterResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserRegister not implemented")
}
func (UnimplementedUserServer) GetAllUserID(context.Context, *GetAllUserIDReq) (*GetAllUserIDResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAllUserID not implemented")
}
func (UnimplementedUserServer) UserRegisterCount(context.Context, *UserRegisterCountReq) (*UserRegisterCountResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserRegisterCount not implemented")
}
func (UnimplementedUserServer) SubscribeOrCancelUsersStatus(context.Context, *SubscribeOrCancelUsersStatusReq) (*SubscribeOrCancelUsersStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubscribeOrCancelUsersStatus not implemented")
}
func (UnimplementedUserServer) GetSubscribeUsersStatus(context.Context, *GetSubscribeUsersStatusReq) (*GetSubscribeUsersStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubscribeUsersStatus not implemented")
}
func (UnimplementedUserServer) GetUserStatus(context.Context, *GetUserStatusReq) (*GetUserStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserStatus not implemented")
}
func (UnimplementedUserServer) SetUserStatus(context.Context, *SetUserStatusReq) (*SetUserStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetUserStatus not implemented")
}
func (UnimplementedUserServer) ProcessUserCommandAdd(context.Context, *ProcessUserCommandAddReq) (*ProcessUserCommandAddResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessUserCommandAdd not implemented")
}
func (UnimplementedUserServer) ProcessUserCommandUpdate(context.Context, *ProcessUserCommandUpdateReq) (*ProcessUserCommandUpdateResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessUserCommandUpdate not implemented")
}
func (UnimplementedUserServer) ProcessUserCommandDelete(context.Context, *ProcessUserCommandDeleteReq) (*ProcessUserCommandDeleteResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessUserCommandDelete not implemented")
}
func (UnimplementedUserServer) ProcessUserCommandGet(context.Context, *ProcessUserCommandGetReq) (*ProcessUserCommandGetResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessUserCommandGet not implemented")
}
func (UnimplementedUserServer) ProcessUserCommandGetAll(context.Context, *ProcessUserCommandGetAllReq) (*ProcessUserCommandGetAllResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessUserCommandGetAll not implemented")
}
func (UnimplementedUserServer) AddNotificationAccount(context.Context, *AddNotificationAccountReq) (*AddNotificationAccountResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddNotificationAccount not implemented")
}
func (UnimplementedUserServer) UpdateNotificationAccountInfo(context.Context, *UpdateNotificationAccountInfoReq) (*UpdateNotificationAccountInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNotificationAccountInfo not implemented")
}
func (UnimplementedUserServer) SearchNotificationAccount(context.Context, *SearchNotificationAccountReq) (*SearchNotificationAccountResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchNotificationAccount not implemented")
}
func (UnimplementedUserServer) GetNotificationAccount(context.Context, *GetNotificationAccountReq) (*GetNotificationAccountResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotificationAccount not implemented")
}
func (UnimplementedUserServer) SortQuery(context.Context, *SortQueryReq) (*SortQueryResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SortQuery not implemented")
}
func (UnimplementedUserServer) SetUserOnlineStatus(context.Context, *SetUserOnlineStatusReq) (*SetUserOnlineStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetUserOnlineStatus not implemented")
}
func (UnimplementedUserServer) GetAllOnlineUsers(context.Context, *GetAllOnlineUsersReq) (*GetAllOnlineUsersResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAllOnlineUsers not implemented")
}
func (UnimplementedUserServer) mustEmbedUnimplementedUserServer() {}
func (UnimplementedUserServer) testEmbeddedByValue()              {}

// UnsafeUserServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UserServer will
// result in compilation errors.
type UnsafeUserServer interface {
	mustEmbedUnimplementedUserServer()
}

func RegisterUserServer(s grpc.ServiceRegistrar, srv UserServer) {
	// If the following call pancis, it indicates UnimplementedUserServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&User_ServiceDesc, srv)
}

func _User_GetDesignateUsers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDesignateUsersReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).GetDesignateUsers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_GetDesignateUsers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).GetDesignateUsers(ctx, req.(*GetDesignateUsersReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_UpdateUserInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).UpdateUserInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_UpdateUserInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).UpdateUserInfo(ctx, req.(*UpdateUserInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_UpdateUserInfoEx_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserInfoExReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).UpdateUserInfoEx(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_UpdateUserInfoEx_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).UpdateUserInfoEx(ctx, req.(*UpdateUserInfoExReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_SetGlobalRecvMessageOpt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetGlobalRecvMessageOptReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).SetGlobalRecvMessageOpt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_SetGlobalRecvMessageOpt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).SetGlobalRecvMessageOpt(ctx, req.(*SetGlobalRecvMessageOptReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_GetGlobalRecvMessageOpt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalRecvMessageOptReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).GetGlobalRecvMessageOpt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_GetGlobalRecvMessageOpt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).GetGlobalRecvMessageOpt(ctx, req.(*GetGlobalRecvMessageOptReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_AccountCheck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccountCheckReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).AccountCheck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_AccountCheck_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).AccountCheck(ctx, req.(*AccountCheckReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_GetPaginationUsers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPaginationUsersReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).GetPaginationUsers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_GetPaginationUsers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).GetPaginationUsers(ctx, req.(*GetPaginationUsersReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_UserRegister_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserRegisterReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).UserRegister(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_UserRegister_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).UserRegister(ctx, req.(*UserRegisterReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_GetAllUserID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAllUserIDReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).GetAllUserID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_GetAllUserID_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).GetAllUserID(ctx, req.(*GetAllUserIDReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_UserRegisterCount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserRegisterCountReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).UserRegisterCount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_UserRegisterCount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).UserRegisterCount(ctx, req.(*UserRegisterCountReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_SubscribeOrCancelUsersStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubscribeOrCancelUsersStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).SubscribeOrCancelUsersStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_SubscribeOrCancelUsersStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).SubscribeOrCancelUsersStatus(ctx, req.(*SubscribeOrCancelUsersStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_GetSubscribeUsersStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscribeUsersStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).GetSubscribeUsersStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_GetSubscribeUsersStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).GetSubscribeUsersStatus(ctx, req.(*GetSubscribeUsersStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_GetUserStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).GetUserStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_GetUserStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).GetUserStatus(ctx, req.(*GetUserStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_SetUserStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetUserStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).SetUserStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_SetUserStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).SetUserStatus(ctx, req.(*SetUserStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_ProcessUserCommandAdd_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessUserCommandAddReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).ProcessUserCommandAdd(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_ProcessUserCommandAdd_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).ProcessUserCommandAdd(ctx, req.(*ProcessUserCommandAddReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_ProcessUserCommandUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessUserCommandUpdateReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).ProcessUserCommandUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_ProcessUserCommandUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).ProcessUserCommandUpdate(ctx, req.(*ProcessUserCommandUpdateReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_ProcessUserCommandDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessUserCommandDeleteReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).ProcessUserCommandDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_ProcessUserCommandDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).ProcessUserCommandDelete(ctx, req.(*ProcessUserCommandDeleteReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_ProcessUserCommandGet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessUserCommandGetReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).ProcessUserCommandGet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_ProcessUserCommandGet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).ProcessUserCommandGet(ctx, req.(*ProcessUserCommandGetReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_ProcessUserCommandGetAll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessUserCommandGetAllReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).ProcessUserCommandGetAll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_ProcessUserCommandGetAll_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).ProcessUserCommandGetAll(ctx, req.(*ProcessUserCommandGetAllReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_AddNotificationAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddNotificationAccountReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).AddNotificationAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_AddNotificationAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).AddNotificationAccount(ctx, req.(*AddNotificationAccountReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_UpdateNotificationAccountInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotificationAccountInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).UpdateNotificationAccountInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_UpdateNotificationAccountInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).UpdateNotificationAccountInfo(ctx, req.(*UpdateNotificationAccountInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_SearchNotificationAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchNotificationAccountReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).SearchNotificationAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_SearchNotificationAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).SearchNotificationAccount(ctx, req.(*SearchNotificationAccountReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_GetNotificationAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationAccountReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).GetNotificationAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_GetNotificationAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).GetNotificationAccount(ctx, req.(*GetNotificationAccountReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_SortQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SortQueryReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).SortQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_SortQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).SortQuery(ctx, req.(*SortQueryReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_SetUserOnlineStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetUserOnlineStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).SetUserOnlineStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_SetUserOnlineStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).SetUserOnlineStatus(ctx, req.(*SetUserOnlineStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _User_GetAllOnlineUsers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAllOnlineUsersReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServer).GetAllOnlineUsers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: User_GetAllOnlineUsers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServer).GetAllOnlineUsers(ctx, req.(*GetAllOnlineUsersReq))
	}
	return interceptor(ctx, in, info, handler)
}

// User_ServiceDesc is the grpc.ServiceDesc for User service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var User_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "openim.user.user",
	HandlerType: (*UserServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "getDesignateUsers",
			Handler:    _User_GetDesignateUsers_Handler,
		},
		{
			MethodName: "updateUserInfo",
			Handler:    _User_UpdateUserInfo_Handler,
		},
		{
			MethodName: "updateUserInfoEx",
			Handler:    _User_UpdateUserInfoEx_Handler,
		},
		{
			MethodName: "setGlobalRecvMessageOpt",
			Handler:    _User_SetGlobalRecvMessageOpt_Handler,
		},
		{
			MethodName: "getGlobalRecvMessageOpt",
			Handler:    _User_GetGlobalRecvMessageOpt_Handler,
		},
		{
			MethodName: "accountCheck",
			Handler:    _User_AccountCheck_Handler,
		},
		{
			MethodName: "getPaginationUsers",
			Handler:    _User_GetPaginationUsers_Handler,
		},
		{
			MethodName: "userRegister",
			Handler:    _User_UserRegister_Handler,
		},
		{
			MethodName: "getAllUserID",
			Handler:    _User_GetAllUserID_Handler,
		},
		{
			MethodName: "userRegisterCount",
			Handler:    _User_UserRegisterCount_Handler,
		},
		{
			MethodName: "subscribeOrCancelUsersStatus",
			Handler:    _User_SubscribeOrCancelUsersStatus_Handler,
		},
		{
			MethodName: "getSubscribeUsersStatus",
			Handler:    _User_GetSubscribeUsersStatus_Handler,
		},
		{
			MethodName: "getUserStatus",
			Handler:    _User_GetUserStatus_Handler,
		},
		{
			MethodName: "setUserStatus",
			Handler:    _User_SetUserStatus_Handler,
		},
		{
			MethodName: "processUserCommandAdd",
			Handler:    _User_ProcessUserCommandAdd_Handler,
		},
		{
			MethodName: "processUserCommandUpdate",
			Handler:    _User_ProcessUserCommandUpdate_Handler,
		},
		{
			MethodName: "processUserCommandDelete",
			Handler:    _User_ProcessUserCommandDelete_Handler,
		},
		{
			MethodName: "processUserCommandGet",
			Handler:    _User_ProcessUserCommandGet_Handler,
		},
		{
			MethodName: "processUserCommandGetAll",
			Handler:    _User_ProcessUserCommandGetAll_Handler,
		},
		{
			MethodName: "addNotificationAccount",
			Handler:    _User_AddNotificationAccount_Handler,
		},
		{
			MethodName: "updateNotificationAccountInfo",
			Handler:    _User_UpdateNotificationAccountInfo_Handler,
		},
		{
			MethodName: "searchNotificationAccount",
			Handler:    _User_SearchNotificationAccount_Handler,
		},
		{
			MethodName: "getNotificationAccount",
			Handler:    _User_GetNotificationAccount_Handler,
		},
		{
			MethodName: "sortQuery",
			Handler:    _User_SortQuery_Handler,
		},
		{
			MethodName: "setUserOnlineStatus",
			Handler:    _User_SetUserOnlineStatus_Handler,
		},
		{
			MethodName: "getAllOnlineUsers",
			Handler:    _User_GetAllOnlineUsers_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "user/user.proto",
}
