// Copyright © 2023 OpenIM. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.2
// 	protoc        v5.26.0
// source: sdkws/sdkws.proto

package sdkws

import (
	wrapperspb "github.com/openimsdk/protocol/wrapperspb"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// /////////////////////////////////base end/////////////////////////////////////
type PullOrder int32

const (
	PullOrder_PullOrderAsc  PullOrder = 0
	PullOrder_PullOrderDesc PullOrder = 1
)

// Enum value maps for PullOrder.
var (
	PullOrder_name = map[int32]string{
		0: "PullOrderAsc",
		1: "PullOrderDesc",
	}
	PullOrder_value = map[string]int32{
		"PullOrderAsc":  0,
		"PullOrderDesc": 1,
	}
)

func (x PullOrder) Enum() *PullOrder {
	p := new(PullOrder)
	*p = x
	return p
}

func (x PullOrder) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PullOrder) Descriptor() protoreflect.EnumDescriptor {
	return file_sdkws_sdkws_proto_enumTypes[0].Descriptor()
}

func (PullOrder) Type() protoreflect.EnumType {
	return &file_sdkws_sdkws_proto_enumTypes[0]
}

func (x PullOrder) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PullOrder.Descriptor instead.
func (PullOrder) EnumDescriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{0}
}

type GroupInfo struct {
	state                  protoimpl.MessageState `protogen:"open.v1"`
	GroupID                string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	GroupName              string                 `protobuf:"bytes,2,opt,name=groupName,proto3" json:"groupName"`
	Notification           string                 `protobuf:"bytes,3,opt,name=notification,proto3" json:"notification"`
	Introduction           string                 `protobuf:"bytes,4,opt,name=introduction,proto3" json:"introduction"`
	FaceURL                string                 `protobuf:"bytes,5,opt,name=faceURL,proto3" json:"faceURL"`
	OwnerUserID            string                 `protobuf:"bytes,6,opt,name=ownerUserID,proto3" json:"ownerUserID"`
	CreateTime             int64                  `protobuf:"varint,7,opt,name=createTime,proto3" json:"createTime"`
	MemberCount            uint32                 `protobuf:"varint,8,opt,name=memberCount,proto3" json:"memberCount"`
	Ex                     string                 `protobuf:"bytes,9,opt,name=ex,proto3" json:"ex"`
	Status                 int32                  `protobuf:"varint,10,opt,name=status,proto3" json:"status"`
	CreatorUserID          string                 `protobuf:"bytes,11,opt,name=creatorUserID,proto3" json:"creatorUserID"`
	GroupType              int32                  `protobuf:"varint,12,opt,name=groupType,proto3" json:"groupType"`
	NeedVerification       int32                  `protobuf:"varint,13,opt,name=needVerification,proto3" json:"needVerification"`
	LookMemberInfo         int32                  `protobuf:"varint,14,opt,name=lookMemberInfo,proto3" json:"lookMemberInfo"`
	ApplyMemberFriend      int32                  `protobuf:"varint,15,opt,name=applyMemberFriend,proto3" json:"applyMemberFriend"`
	NotificationUpdateTime int64                  `protobuf:"varint,16,opt,name=notificationUpdateTime,proto3" json:"notificationUpdateTime"`
	NotificationUserID     string                 `protobuf:"bytes,17,opt,name=notificationUserID,proto3" json:"notificationUserID"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *GroupInfo) Reset() {
	*x = GroupInfo{}
	mi := &file_sdkws_sdkws_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupInfo) ProtoMessage() {}

func (x *GroupInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupInfo.ProtoReflect.Descriptor instead.
func (*GroupInfo) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{0}
}

func (x *GroupInfo) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GroupInfo) GetGroupName() string {
	if x != nil {
		return x.GroupName
	}
	return ""
}

func (x *GroupInfo) GetNotification() string {
	if x != nil {
		return x.Notification
	}
	return ""
}

func (x *GroupInfo) GetIntroduction() string {
	if x != nil {
		return x.Introduction
	}
	return ""
}

func (x *GroupInfo) GetFaceURL() string {
	if x != nil {
		return x.FaceURL
	}
	return ""
}

func (x *GroupInfo) GetOwnerUserID() string {
	if x != nil {
		return x.OwnerUserID
	}
	return ""
}

func (x *GroupInfo) GetCreateTime() int64 {
	if x != nil {
		return x.CreateTime
	}
	return 0
}

func (x *GroupInfo) GetMemberCount() uint32 {
	if x != nil {
		return x.MemberCount
	}
	return 0
}

func (x *GroupInfo) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

func (x *GroupInfo) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *GroupInfo) GetCreatorUserID() string {
	if x != nil {
		return x.CreatorUserID
	}
	return ""
}

func (x *GroupInfo) GetGroupType() int32 {
	if x != nil {
		return x.GroupType
	}
	return 0
}

func (x *GroupInfo) GetNeedVerification() int32 {
	if x != nil {
		return x.NeedVerification
	}
	return 0
}

func (x *GroupInfo) GetLookMemberInfo() int32 {
	if x != nil {
		return x.LookMemberInfo
	}
	return 0
}

func (x *GroupInfo) GetApplyMemberFriend() int32 {
	if x != nil {
		return x.ApplyMemberFriend
	}
	return 0
}

func (x *GroupInfo) GetNotificationUpdateTime() int64 {
	if x != nil {
		return x.NotificationUpdateTime
	}
	return 0
}

func (x *GroupInfo) GetNotificationUserID() string {
	if x != nil {
		return x.NotificationUserID
	}
	return ""
}

type GroupInfoForSet struct {
	state             protoimpl.MessageState  `protogen:"open.v1"`
	GroupID           string                  `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	GroupName         string                  `protobuf:"bytes,2,opt,name=groupName,proto3" json:"groupName"`
	Notification      string                  `protobuf:"bytes,3,opt,name=notification,proto3" json:"notification"`
	Introduction      string                  `protobuf:"bytes,4,opt,name=introduction,proto3" json:"introduction"`
	FaceURL           string                  `protobuf:"bytes,5,opt,name=faceURL,proto3" json:"faceURL"`
	Ex                *wrapperspb.StringValue `protobuf:"bytes,6,opt,name=ex,proto3" json:"ex"`
	NeedVerification  *wrapperspb.Int32Value  `protobuf:"bytes,7,opt,name=needVerification,proto3" json:"needVerification"`
	LookMemberInfo    *wrapperspb.Int32Value  `protobuf:"bytes,8,opt,name=lookMemberInfo,proto3" json:"lookMemberInfo"`
	ApplyMemberFriend *wrapperspb.Int32Value  `protobuf:"bytes,9,opt,name=applyMemberFriend,proto3" json:"applyMemberFriend"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *GroupInfoForSet) Reset() {
	*x = GroupInfoForSet{}
	mi := &file_sdkws_sdkws_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupInfoForSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupInfoForSet) ProtoMessage() {}

func (x *GroupInfoForSet) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupInfoForSet.ProtoReflect.Descriptor instead.
func (*GroupInfoForSet) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{1}
}

func (x *GroupInfoForSet) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GroupInfoForSet) GetGroupName() string {
	if x != nil {
		return x.GroupName
	}
	return ""
}

func (x *GroupInfoForSet) GetNotification() string {
	if x != nil {
		return x.Notification
	}
	return ""
}

func (x *GroupInfoForSet) GetIntroduction() string {
	if x != nil {
		return x.Introduction
	}
	return ""
}

func (x *GroupInfoForSet) GetFaceURL() string {
	if x != nil {
		return x.FaceURL
	}
	return ""
}

func (x *GroupInfoForSet) GetEx() *wrapperspb.StringValue {
	if x != nil {
		return x.Ex
	}
	return nil
}

func (x *GroupInfoForSet) GetNeedVerification() *wrapperspb.Int32Value {
	if x != nil {
		return x.NeedVerification
	}
	return nil
}

func (x *GroupInfoForSet) GetLookMemberInfo() *wrapperspb.Int32Value {
	if x != nil {
		return x.LookMemberInfo
	}
	return nil
}

func (x *GroupInfoForSet) GetApplyMemberFriend() *wrapperspb.Int32Value {
	if x != nil {
		return x.ApplyMemberFriend
	}
	return nil
}

type GroupMemberFullInfo struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	GroupID        string                 `protobuf:"bytes,1,opt,name=groupID,proto3" json:"groupID"`
	UserID         string                 `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	RoleLevel      int32                  `protobuf:"varint,3,opt,name=roleLevel,proto3" json:"roleLevel"`
	JoinTime       int64                  `protobuf:"varint,4,opt,name=joinTime,proto3" json:"joinTime"`
	Nickname       string                 `protobuf:"bytes,5,opt,name=nickname,proto3" json:"nickname"`
	FaceURL        string                 `protobuf:"bytes,6,opt,name=faceURL,proto3" json:"faceURL"`
	AppMangerLevel int32                  `protobuf:"varint,7,opt,name=appMangerLevel,proto3" json:"appMangerLevel"` //if >0
	JoinSource     int32                  `protobuf:"varint,8,opt,name=joinSource,proto3" json:"joinSource"`
	OperatorUserID string                 `protobuf:"bytes,9,opt,name=operatorUserID,proto3" json:"operatorUserID"`
	Ex             string                 `protobuf:"bytes,10,opt,name=ex,proto3" json:"ex"`
	MuteEndTime    int64                  `protobuf:"varint,11,opt,name=muteEndTime,proto3" json:"muteEndTime"`
	InviterUserID  string                 `protobuf:"bytes,12,opt,name=inviterUserID,proto3" json:"inviterUserID"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GroupMemberFullInfo) Reset() {
	*x = GroupMemberFullInfo{}
	mi := &file_sdkws_sdkws_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupMemberFullInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupMemberFullInfo) ProtoMessage() {}

func (x *GroupMemberFullInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupMemberFullInfo.ProtoReflect.Descriptor instead.
func (*GroupMemberFullInfo) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{2}
}

func (x *GroupMemberFullInfo) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *GroupMemberFullInfo) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *GroupMemberFullInfo) GetRoleLevel() int32 {
	if x != nil {
		return x.RoleLevel
	}
	return 0
}

func (x *GroupMemberFullInfo) GetJoinTime() int64 {
	if x != nil {
		return x.JoinTime
	}
	return 0
}

func (x *GroupMemberFullInfo) GetNickname() string {
	if x != nil {
		return x.Nickname
	}
	return ""
}

func (x *GroupMemberFullInfo) GetFaceURL() string {
	if x != nil {
		return x.FaceURL
	}
	return ""
}

func (x *GroupMemberFullInfo) GetAppMangerLevel() int32 {
	if x != nil {
		return x.AppMangerLevel
	}
	return 0
}

func (x *GroupMemberFullInfo) GetJoinSource() int32 {
	if x != nil {
		return x.JoinSource
	}
	return 0
}

func (x *GroupMemberFullInfo) GetOperatorUserID() string {
	if x != nil {
		return x.OperatorUserID
	}
	return ""
}

func (x *GroupMemberFullInfo) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

func (x *GroupMemberFullInfo) GetMuteEndTime() int64 {
	if x != nil {
		return x.MuteEndTime
	}
	return 0
}

func (x *GroupMemberFullInfo) GetInviterUserID() string {
	if x != nil {
		return x.InviterUserID
	}
	return ""
}

type PublicUserInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	Nickname      string                 `protobuf:"bytes,2,opt,name=nickname,proto3" json:"nickname"`
	FaceURL       string                 `protobuf:"bytes,3,opt,name=faceURL,proto3" json:"faceURL"`
	Ex            string                 `protobuf:"bytes,4,opt,name=ex,proto3" json:"ex"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PublicUserInfo) Reset() {
	*x = PublicUserInfo{}
	mi := &file_sdkws_sdkws_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublicUserInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicUserInfo) ProtoMessage() {}

func (x *PublicUserInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicUserInfo.ProtoReflect.Descriptor instead.
func (*PublicUserInfo) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{3}
}

func (x *PublicUserInfo) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *PublicUserInfo) GetNickname() string {
	if x != nil {
		return x.Nickname
	}
	return ""
}

func (x *PublicUserInfo) GetFaceURL() string {
	if x != nil {
		return x.FaceURL
	}
	return ""
}

func (x *PublicUserInfo) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

type UserInfo struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	UserID           string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	Nickname         string                 `protobuf:"bytes,2,opt,name=nickname,proto3" json:"nickname"`
	FaceURL          string                 `protobuf:"bytes,3,opt,name=faceURL,proto3" json:"faceURL"`
	Ex               string                 `protobuf:"bytes,4,opt,name=ex,proto3" json:"ex"`
	CreateTime       int64                  `protobuf:"varint,5,opt,name=createTime,proto3" json:"createTime"`
	AppMangerLevel   int32                  `protobuf:"varint,6,opt,name=appMangerLevel,proto3" json:"appMangerLevel"`
	GlobalRecvMsgOpt int32                  `protobuf:"varint,7,opt,name=globalRecvMsgOpt,proto3" json:"globalRecvMsgOpt"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *UserInfo) Reset() {
	*x = UserInfo{}
	mi := &file_sdkws_sdkws_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInfo) ProtoMessage() {}

func (x *UserInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInfo.ProtoReflect.Descriptor instead.
func (*UserInfo) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{4}
}

func (x *UserInfo) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UserInfo) GetNickname() string {
	if x != nil {
		return x.Nickname
	}
	return ""
}

func (x *UserInfo) GetFaceURL() string {
	if x != nil {
		return x.FaceURL
	}
	return ""
}

func (x *UserInfo) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

func (x *UserInfo) GetCreateTime() int64 {
	if x != nil {
		return x.CreateTime
	}
	return 0
}

func (x *UserInfo) GetAppMangerLevel() int32 {
	if x != nil {
		return x.AppMangerLevel
	}
	return 0
}

func (x *UserInfo) GetGlobalRecvMsgOpt() int32 {
	if x != nil {
		return x.GlobalRecvMsgOpt
	}
	return 0
}

type UserInfoWithEx struct {
	state            protoimpl.MessageState  `protogen:"open.v1"`
	UserID           string                  `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	Nickname         *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=nickname,proto3" json:"nickname"`
	FaceURL          *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=faceURL,proto3" json:"faceURL"`
	Ex               *wrapperspb.StringValue `protobuf:"bytes,4,opt,name=ex,proto3" json:"ex"`
	GlobalRecvMsgOpt *wrapperspb.Int32Value  `protobuf:"bytes,7,opt,name=globalRecvMsgOpt,proto3" json:"globalRecvMsgOpt"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *UserInfoWithEx) Reset() {
	*x = UserInfoWithEx{}
	mi := &file_sdkws_sdkws_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserInfoWithEx) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInfoWithEx) ProtoMessage() {}

func (x *UserInfoWithEx) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInfoWithEx.ProtoReflect.Descriptor instead.
func (*UserInfoWithEx) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{5}
}

func (x *UserInfoWithEx) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UserInfoWithEx) GetNickname() *wrapperspb.StringValue {
	if x != nil {
		return x.Nickname
	}
	return nil
}

func (x *UserInfoWithEx) GetFaceURL() *wrapperspb.StringValue {
	if x != nil {
		return x.FaceURL
	}
	return nil
}

func (x *UserInfoWithEx) GetEx() *wrapperspb.StringValue {
	if x != nil {
		return x.Ex
	}
	return nil
}

func (x *UserInfoWithEx) GetGlobalRecvMsgOpt() *wrapperspb.Int32Value {
	if x != nil {
		return x.GlobalRecvMsgOpt
	}
	return nil
}

type FriendInfo struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	OwnerUserID    string                 `protobuf:"bytes,1,opt,name=ownerUserID,proto3" json:"ownerUserID"`
	Remark         string                 `protobuf:"bytes,2,opt,name=remark,proto3" json:"remark"`
	CreateTime     int64                  `protobuf:"varint,3,opt,name=createTime,proto3" json:"createTime"`
	FriendUser     *UserInfo              `protobuf:"bytes,4,opt,name=friendUser,proto3" json:"friendUser"`
	AddSource      int32                  `protobuf:"varint,5,opt,name=addSource,proto3" json:"addSource"`
	OperatorUserID string                 `protobuf:"bytes,6,opt,name=operatorUserID,proto3" json:"operatorUserID"`
	Ex             string                 `protobuf:"bytes,7,opt,name=ex,proto3" json:"ex"`
	IsPinned       bool                   `protobuf:"varint,8,opt,name=isPinned,proto3" json:"isPinned"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *FriendInfo) Reset() {
	*x = FriendInfo{}
	mi := &file_sdkws_sdkws_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendInfo) ProtoMessage() {}

func (x *FriendInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendInfo.ProtoReflect.Descriptor instead.
func (*FriendInfo) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{6}
}

func (x *FriendInfo) GetOwnerUserID() string {
	if x != nil {
		return x.OwnerUserID
	}
	return ""
}

func (x *FriendInfo) GetRemark() string {
	if x != nil {
		return x.Remark
	}
	return ""
}

func (x *FriendInfo) GetCreateTime() int64 {
	if x != nil {
		return x.CreateTime
	}
	return 0
}

func (x *FriendInfo) GetFriendUser() *UserInfo {
	if x != nil {
		return x.FriendUser
	}
	return nil
}

func (x *FriendInfo) GetAddSource() int32 {
	if x != nil {
		return x.AddSource
	}
	return 0
}

func (x *FriendInfo) GetOperatorUserID() string {
	if x != nil {
		return x.OperatorUserID
	}
	return ""
}

func (x *FriendInfo) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

func (x *FriendInfo) GetIsPinned() bool {
	if x != nil {
		return x.IsPinned
	}
	return false
}

type BlackInfo struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	OwnerUserID    string                 `protobuf:"bytes,1,opt,name=ownerUserID,proto3" json:"ownerUserID"`
	CreateTime     int64                  `protobuf:"varint,2,opt,name=createTime,proto3" json:"createTime"`
	BlackUserInfo  *PublicUserInfo        `protobuf:"bytes,3,opt,name=blackUserInfo,proto3" json:"blackUserInfo"`
	AddSource      int32                  `protobuf:"varint,4,opt,name=addSource,proto3" json:"addSource"`
	OperatorUserID string                 `protobuf:"bytes,5,opt,name=operatorUserID,proto3" json:"operatorUserID"`
	Ex             string                 `protobuf:"bytes,6,opt,name=ex,proto3" json:"ex"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *BlackInfo) Reset() {
	*x = BlackInfo{}
	mi := &file_sdkws_sdkws_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BlackInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlackInfo) ProtoMessage() {}

func (x *BlackInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlackInfo.ProtoReflect.Descriptor instead.
func (*BlackInfo) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{7}
}

func (x *BlackInfo) GetOwnerUserID() string {
	if x != nil {
		return x.OwnerUserID
	}
	return ""
}

func (x *BlackInfo) GetCreateTime() int64 {
	if x != nil {
		return x.CreateTime
	}
	return 0
}

func (x *BlackInfo) GetBlackUserInfo() *PublicUserInfo {
	if x != nil {
		return x.BlackUserInfo
	}
	return nil
}

func (x *BlackInfo) GetAddSource() int32 {
	if x != nil {
		return x.AddSource
	}
	return 0
}

func (x *BlackInfo) GetOperatorUserID() string {
	if x != nil {
		return x.OperatorUserID
	}
	return ""
}

func (x *BlackInfo) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

type GroupRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserInfo      *PublicUserInfo        `protobuf:"bytes,1,opt,name=userInfo,proto3" json:"userInfo"`
	GroupInfo     *GroupInfo             `protobuf:"bytes,2,opt,name=groupInfo,proto3" json:"groupInfo"`
	HandleResult  int32                  `protobuf:"varint,3,opt,name=handleResult,proto3" json:"handleResult"`
	ReqMsg        string                 `protobuf:"bytes,4,opt,name=reqMsg,proto3" json:"reqMsg"`
	HandleMsg     string                 `protobuf:"bytes,5,opt,name=handleMsg,proto3" json:"handleMsg"`
	ReqTime       int64                  `protobuf:"varint,6,opt,name=reqTime,proto3" json:"reqTime"`
	HandleUserID  string                 `protobuf:"bytes,7,opt,name=handleUserID,proto3" json:"handleUserID"`
	HandleTime    int64                  `protobuf:"varint,8,opt,name=handleTime,proto3" json:"handleTime"`
	Ex            string                 `protobuf:"bytes,9,opt,name=ex,proto3" json:"ex"`
	JoinSource    int32                  `protobuf:"varint,10,opt,name=joinSource,proto3" json:"joinSource"`
	InviterUserID string                 `protobuf:"bytes,11,opt,name=inviterUserID,proto3" json:"inviterUserID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupRequest) Reset() {
	*x = GroupRequest{}
	mi := &file_sdkws_sdkws_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupRequest) ProtoMessage() {}

func (x *GroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupRequest.ProtoReflect.Descriptor instead.
func (*GroupRequest) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{8}
}

func (x *GroupRequest) GetUserInfo() *PublicUserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

func (x *GroupRequest) GetGroupInfo() *GroupInfo {
	if x != nil {
		return x.GroupInfo
	}
	return nil
}

func (x *GroupRequest) GetHandleResult() int32 {
	if x != nil {
		return x.HandleResult
	}
	return 0
}

func (x *GroupRequest) GetReqMsg() string {
	if x != nil {
		return x.ReqMsg
	}
	return ""
}

func (x *GroupRequest) GetHandleMsg() string {
	if x != nil {
		return x.HandleMsg
	}
	return ""
}

func (x *GroupRequest) GetReqTime() int64 {
	if x != nil {
		return x.ReqTime
	}
	return 0
}

func (x *GroupRequest) GetHandleUserID() string {
	if x != nil {
		return x.HandleUserID
	}
	return ""
}

func (x *GroupRequest) GetHandleTime() int64 {
	if x != nil {
		return x.HandleTime
	}
	return 0
}

func (x *GroupRequest) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

func (x *GroupRequest) GetJoinSource() int32 {
	if x != nil {
		return x.JoinSource
	}
	return 0
}

func (x *GroupRequest) GetInviterUserID() string {
	if x != nil {
		return x.InviterUserID
	}
	return ""
}

type FriendRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromUserID    string                 `protobuf:"bytes,1,opt,name=fromUserID,proto3" json:"fromUserID"`
	FromNickname  string                 `protobuf:"bytes,2,opt,name=fromNickname,proto3" json:"fromNickname"`
	FromFaceURL   string                 `protobuf:"bytes,3,opt,name=fromFaceURL,proto3" json:"fromFaceURL"`
	ToUserID      string                 `protobuf:"bytes,4,opt,name=toUserID,proto3" json:"toUserID"`
	ToNickname    string                 `protobuf:"bytes,5,opt,name=toNickname,proto3" json:"toNickname"`
	ToFaceURL     string                 `protobuf:"bytes,6,opt,name=toFaceURL,proto3" json:"toFaceURL"`
	HandleResult  int32                  `protobuf:"varint,7,opt,name=handleResult,proto3" json:"handleResult"`
	ReqMsg        string                 `protobuf:"bytes,8,opt,name=reqMsg,proto3" json:"reqMsg"`
	CreateTime    int64                  `protobuf:"varint,9,opt,name=createTime,proto3" json:"createTime"`
	HandlerUserID string                 `protobuf:"bytes,10,opt,name=handlerUserID,proto3" json:"handlerUserID"`
	HandleMsg     string                 `protobuf:"bytes,11,opt,name=handleMsg,proto3" json:"handleMsg"`
	HandleTime    int64                  `protobuf:"varint,12,opt,name=handleTime,proto3" json:"handleTime"`
	Ex            string                 `protobuf:"bytes,13,opt,name=ex,proto3" json:"ex"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FriendRequest) Reset() {
	*x = FriendRequest{}
	mi := &file_sdkws_sdkws_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendRequest) ProtoMessage() {}

func (x *FriendRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendRequest.ProtoReflect.Descriptor instead.
func (*FriendRequest) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{9}
}

func (x *FriendRequest) GetFromUserID() string {
	if x != nil {
		return x.FromUserID
	}
	return ""
}

func (x *FriendRequest) GetFromNickname() string {
	if x != nil {
		return x.FromNickname
	}
	return ""
}

func (x *FriendRequest) GetFromFaceURL() string {
	if x != nil {
		return x.FromFaceURL
	}
	return ""
}

func (x *FriendRequest) GetToUserID() string {
	if x != nil {
		return x.ToUserID
	}
	return ""
}

func (x *FriendRequest) GetToNickname() string {
	if x != nil {
		return x.ToNickname
	}
	return ""
}

func (x *FriendRequest) GetToFaceURL() string {
	if x != nil {
		return x.ToFaceURL
	}
	return ""
}

func (x *FriendRequest) GetHandleResult() int32 {
	if x != nil {
		return x.HandleResult
	}
	return 0
}

func (x *FriendRequest) GetReqMsg() string {
	if x != nil {
		return x.ReqMsg
	}
	return ""
}

func (x *FriendRequest) GetCreateTime() int64 {
	if x != nil {
		return x.CreateTime
	}
	return 0
}

func (x *FriendRequest) GetHandlerUserID() string {
	if x != nil {
		return x.HandlerUserID
	}
	return ""
}

func (x *FriendRequest) GetHandleMsg() string {
	if x != nil {
		return x.HandleMsg
	}
	return ""
}

func (x *FriendRequest) GetHandleTime() int64 {
	if x != nil {
		return x.HandleTime
	}
	return 0
}

func (x *FriendRequest) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

type PullMessageBySeqsReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	SeqRanges     []*SeqRange            `protobuf:"bytes,2,rep,name=seqRanges,proto3" json:"seqRanges"`
	Order         PullOrder              `protobuf:"varint,3,opt,name=order,proto3,enum=openim.sdkws.PullOrder" json:"order"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PullMessageBySeqsReq) Reset() {
	*x = PullMessageBySeqsReq{}
	mi := &file_sdkws_sdkws_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PullMessageBySeqsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullMessageBySeqsReq) ProtoMessage() {}

func (x *PullMessageBySeqsReq) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullMessageBySeqsReq.ProtoReflect.Descriptor instead.
func (*PullMessageBySeqsReq) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{10}
}

func (x *PullMessageBySeqsReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *PullMessageBySeqsReq) GetSeqRanges() []*SeqRange {
	if x != nil {
		return x.SeqRanges
	}
	return nil
}

func (x *PullMessageBySeqsReq) GetOrder() PullOrder {
	if x != nil {
		return x.Order
	}
	return PullOrder_PullOrderAsc
}

type SeqRange struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	ConversationID string                 `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	Begin          int64                  `protobuf:"varint,2,opt,name=begin,proto3" json:"begin"`
	End            int64                  `protobuf:"varint,3,opt,name=end,proto3" json:"end"`
	Num            int64                  `protobuf:"varint,4,opt,name=num,proto3" json:"num"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *SeqRange) Reset() {
	*x = SeqRange{}
	mi := &file_sdkws_sdkws_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SeqRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SeqRange) ProtoMessage() {}

func (x *SeqRange) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SeqRange.ProtoReflect.Descriptor instead.
func (*SeqRange) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{11}
}

func (x *SeqRange) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *SeqRange) GetBegin() int64 {
	if x != nil {
		return x.Begin
	}
	return 0
}

func (x *SeqRange) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *SeqRange) GetNum() int64 {
	if x != nil {
		return x.Num
	}
	return 0
}

type PullMsgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Msgs          []*MsgData             `protobuf:"bytes,1,rep,name=Msgs,proto3" json:"Msgs"`
	IsEnd         bool                   `protobuf:"varint,2,opt,name=isEnd,proto3" json:"isEnd"`
	EndSeq        int64                  `protobuf:"varint,3,opt,name=endSeq,proto3" json:"endSeq"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PullMsgs) Reset() {
	*x = PullMsgs{}
	mi := &file_sdkws_sdkws_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PullMsgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullMsgs) ProtoMessage() {}

func (x *PullMsgs) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullMsgs.ProtoReflect.Descriptor instead.
func (*PullMsgs) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{12}
}

func (x *PullMsgs) GetMsgs() []*MsgData {
	if x != nil {
		return x.Msgs
	}
	return nil
}

func (x *PullMsgs) GetIsEnd() bool {
	if x != nil {
		return x.IsEnd
	}
	return false
}

func (x *PullMsgs) GetEndSeq() int64 {
	if x != nil {
		return x.EndSeq
	}
	return 0
}

type PullMessageBySeqsResp struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Msgs             map[string]*PullMsgs   `protobuf:"bytes,1,rep,name=msgs,proto3" json:"msgs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	NotificationMsgs map[string]*PullMsgs   `protobuf:"bytes,2,rep,name=notificationMsgs,proto3" json:"notificationMsgs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *PullMessageBySeqsResp) Reset() {
	*x = PullMessageBySeqsResp{}
	mi := &file_sdkws_sdkws_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PullMessageBySeqsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullMessageBySeqsResp) ProtoMessage() {}

func (x *PullMessageBySeqsResp) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullMessageBySeqsResp.ProtoReflect.Descriptor instead.
func (*PullMessageBySeqsResp) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{13}
}

func (x *PullMessageBySeqsResp) GetMsgs() map[string]*PullMsgs {
	if x != nil {
		return x.Msgs
	}
	return nil
}

func (x *PullMessageBySeqsResp) GetNotificationMsgs() map[string]*PullMsgs {
	if x != nil {
		return x.NotificationMsgs
	}
	return nil
}

type GetMaxSeqReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMaxSeqReq) Reset() {
	*x = GetMaxSeqReq{}
	mi := &file_sdkws_sdkws_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMaxSeqReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMaxSeqReq) ProtoMessage() {}

func (x *GetMaxSeqReq) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMaxSeqReq.ProtoReflect.Descriptor instead.
func (*GetMaxSeqReq) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{14}
}

func (x *GetMaxSeqReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GetMaxSeqResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MaxSeqs       map[string]int64       `protobuf:"bytes,1,rep,name=maxSeqs,proto3" json:"maxSeqs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	MinSeqs       map[string]int64       `protobuf:"bytes,2,rep,name=minSeqs,proto3" json:"minSeqs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMaxSeqResp) Reset() {
	*x = GetMaxSeqResp{}
	mi := &file_sdkws_sdkws_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMaxSeqResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMaxSeqResp) ProtoMessage() {}

func (x *GetMaxSeqResp) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMaxSeqResp.ProtoReflect.Descriptor instead.
func (*GetMaxSeqResp) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{15}
}

func (x *GetMaxSeqResp) GetMaxSeqs() map[string]int64 {
	if x != nil {
		return x.MaxSeqs
	}
	return nil
}

func (x *GetMaxSeqResp) GetMinSeqs() map[string]int64 {
	if x != nil {
		return x.MinSeqs
	}
	return nil
}

type UserSendMsgResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ServerMsgID   string                 `protobuf:"bytes,1,opt,name=serverMsgID,proto3" json:"serverMsgID"`
	ClientMsgID   string                 `protobuf:"bytes,2,opt,name=clientMsgID,proto3" json:"clientMsgID"`
	SendTime      int64                  `protobuf:"varint,3,opt,name=sendTime,proto3" json:"sendTime"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserSendMsgResp) Reset() {
	*x = UserSendMsgResp{}
	mi := &file_sdkws_sdkws_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserSendMsgResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSendMsgResp) ProtoMessage() {}

func (x *UserSendMsgResp) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSendMsgResp.ProtoReflect.Descriptor instead.
func (*UserSendMsgResp) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{16}
}

func (x *UserSendMsgResp) GetServerMsgID() string {
	if x != nil {
		return x.ServerMsgID
	}
	return ""
}

func (x *UserSendMsgResp) GetClientMsgID() string {
	if x != nil {
		return x.ClientMsgID
	}
	return ""
}

func (x *UserSendMsgResp) GetSendTime() int64 {
	if x != nil {
		return x.SendTime
	}
	return 0
}

type MsgData struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	SendID           string                 `protobuf:"bytes,1,opt,name=sendID,proto3" json:"sendID"`
	RecvID           string                 `protobuf:"bytes,2,opt,name=recvID,proto3" json:"recvID"`
	GroupID          string                 `protobuf:"bytes,3,opt,name=groupID,proto3" json:"groupID"`
	ClientMsgID      string                 `protobuf:"bytes,4,opt,name=clientMsgID,proto3" json:"clientMsgID"`
	ServerMsgID      string                 `protobuf:"bytes,5,opt,name=serverMsgID,proto3" json:"serverMsgID"`
	SenderPlatformID int32                  `protobuf:"varint,6,opt,name=senderPlatformID,proto3" json:"senderPlatformID"`
	SenderNickname   string                 `protobuf:"bytes,7,opt,name=senderNickname,proto3" json:"senderNickname"`
	SenderFaceURL    string                 `protobuf:"bytes,8,opt,name=senderFaceURL,proto3" json:"senderFaceURL"`
	SessionType      int32                  `protobuf:"varint,9,opt,name=sessionType,proto3" json:"sessionType"`
	MsgFrom          int32                  `protobuf:"varint,10,opt,name=msgFrom,proto3" json:"msgFrom"`
	ContentType      int32                  `protobuf:"varint,11,opt,name=contentType,proto3" json:"contentType"`
	Content          []byte                 `protobuf:"bytes,12,opt,name=content,proto3" json:"content"`
	Seq              int64                  `protobuf:"varint,14,opt,name=seq,proto3" json:"seq"`
	SendTime         int64                  `protobuf:"varint,15,opt,name=sendTime,proto3" json:"sendTime"`
	CreateTime       int64                  `protobuf:"varint,16,opt,name=createTime,proto3" json:"createTime"`
	Status           int32                  `protobuf:"varint,17,opt,name=status,proto3" json:"status"`
	IsRead           bool                   `protobuf:"varint,18,opt,name=isRead,proto3" json:"isRead"`
	Options          map[string]bool        `protobuf:"bytes,19,rep,name=options,proto3" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	OfflinePushInfo  *OfflinePushInfo       `protobuf:"bytes,20,opt,name=offlinePushInfo,proto3" json:"offlinePushInfo"`
	AtUserIDList     []string               `protobuf:"bytes,21,rep,name=atUserIDList,proto3" json:"atUserIDList"`
	AttachedInfo     string                 `protobuf:"bytes,22,opt,name=attachedInfo,proto3" json:"attachedInfo"`
	Ex               string                 `protobuf:"bytes,23,opt,name=ex,proto3" json:"ex"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *MsgData) Reset() {
	*x = MsgData{}
	mi := &file_sdkws_sdkws_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MsgData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MsgData) ProtoMessage() {}

func (x *MsgData) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MsgData.ProtoReflect.Descriptor instead.
func (*MsgData) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{17}
}

func (x *MsgData) GetSendID() string {
	if x != nil {
		return x.SendID
	}
	return ""
}

func (x *MsgData) GetRecvID() string {
	if x != nil {
		return x.RecvID
	}
	return ""
}

func (x *MsgData) GetGroupID() string {
	if x != nil {
		return x.GroupID
	}
	return ""
}

func (x *MsgData) GetClientMsgID() string {
	if x != nil {
		return x.ClientMsgID
	}
	return ""
}

func (x *MsgData) GetServerMsgID() string {
	if x != nil {
		return x.ServerMsgID
	}
	return ""
}

func (x *MsgData) GetSenderPlatformID() int32 {
	if x != nil {
		return x.SenderPlatformID
	}
	return 0
}

func (x *MsgData) GetSenderNickname() string {
	if x != nil {
		return x.SenderNickname
	}
	return ""
}

func (x *MsgData) GetSenderFaceURL() string {
	if x != nil {
		return x.SenderFaceURL
	}
	return ""
}

func (x *MsgData) GetSessionType() int32 {
	if x != nil {
		return x.SessionType
	}
	return 0
}

func (x *MsgData) GetMsgFrom() int32 {
	if x != nil {
		return x.MsgFrom
	}
	return 0
}

func (x *MsgData) GetContentType() int32 {
	if x != nil {
		return x.ContentType
	}
	return 0
}

func (x *MsgData) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *MsgData) GetSeq() int64 {
	if x != nil {
		return x.Seq
	}
	return 0
}

func (x *MsgData) GetSendTime() int64 {
	if x != nil {
		return x.SendTime
	}
	return 0
}

func (x *MsgData) GetCreateTime() int64 {
	if x != nil {
		return x.CreateTime
	}
	return 0
}

func (x *MsgData) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *MsgData) GetIsRead() bool {
	if x != nil {
		return x.IsRead
	}
	return false
}

func (x *MsgData) GetOptions() map[string]bool {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *MsgData) GetOfflinePushInfo() *OfflinePushInfo {
	if x != nil {
		return x.OfflinePushInfo
	}
	return nil
}

func (x *MsgData) GetAtUserIDList() []string {
	if x != nil {
		return x.AtUserIDList
	}
	return nil
}

func (x *MsgData) GetAttachedInfo() string {
	if x != nil {
		return x.AttachedInfo
	}
	return ""
}

func (x *MsgData) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

type PushMessages struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Msgs             map[string]*PullMsgs   `protobuf:"bytes,1,rep,name=msgs,proto3" json:"msgs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	NotificationMsgs map[string]*PullMsgs   `protobuf:"bytes,2,rep,name=notificationMsgs,proto3" json:"notificationMsgs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *PushMessages) Reset() {
	*x = PushMessages{}
	mi := &file_sdkws_sdkws_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushMessages) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushMessages) ProtoMessage() {}

func (x *PushMessages) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushMessages.ProtoReflect.Descriptor instead.
func (*PushMessages) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{18}
}

func (x *PushMessages) GetMsgs() map[string]*PullMsgs {
	if x != nil {
		return x.Msgs
	}
	return nil
}

func (x *PushMessages) GetNotificationMsgs() map[string]*PullMsgs {
	if x != nil {
		return x.NotificationMsgs
	}
	return nil
}

type OfflinePushInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Title         string                 `protobuf:"bytes,1,opt,name=title,proto3" json:"title"`
	Desc          string                 `protobuf:"bytes,2,opt,name=desc,proto3" json:"desc"`
	Ex            string                 `protobuf:"bytes,3,opt,name=ex,proto3" json:"ex"`
	IOSPushSound  string                 `protobuf:"bytes,4,opt,name=iOSPushSound,proto3" json:"iOSPushSound"`
	IOSBadgeCount bool                   `protobuf:"varint,5,opt,name=iOSBadgeCount,proto3" json:"iOSBadgeCount"`
	SignalInfo    string                 `protobuf:"bytes,6,opt,name=signalInfo,proto3" json:"signalInfo"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OfflinePushInfo) Reset() {
	*x = OfflinePushInfo{}
	mi := &file_sdkws_sdkws_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OfflinePushInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfflinePushInfo) ProtoMessage() {}

func (x *OfflinePushInfo) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfflinePushInfo.ProtoReflect.Descriptor instead.
func (*OfflinePushInfo) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{19}
}

func (x *OfflinePushInfo) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *OfflinePushInfo) GetDesc() string {
	if x != nil {
		return x.Desc
	}
	return ""
}

func (x *OfflinePushInfo) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

func (x *OfflinePushInfo) GetIOSPushSound() string {
	if x != nil {
		return x.IOSPushSound
	}
	return ""
}

func (x *OfflinePushInfo) GetIOSBadgeCount() bool {
	if x != nil {
		return x.IOSBadgeCount
	}
	return false
}

func (x *OfflinePushInfo) GetSignalInfo() string {
	if x != nil {
		return x.SignalInfo
	}
	return ""
}

type TipsComm struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Detail        []byte                 `protobuf:"bytes,1,opt,name=detail,proto3" json:"detail"`
	DefaultTips   string                 `protobuf:"bytes,2,opt,name=defaultTips,proto3" json:"defaultTips"`
	JsonDetail    string                 `protobuf:"bytes,3,opt,name=jsonDetail,proto3" json:"jsonDetail"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TipsComm) Reset() {
	*x = TipsComm{}
	mi := &file_sdkws_sdkws_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TipsComm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TipsComm) ProtoMessage() {}

func (x *TipsComm) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TipsComm.ProtoReflect.Descriptor instead.
func (*TipsComm) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{20}
}

func (x *TipsComm) GetDetail() []byte {
	if x != nil {
		return x.Detail
	}
	return nil
}

func (x *TipsComm) GetDefaultTips() string {
	if x != nil {
		return x.DefaultTips
	}
	return ""
}

func (x *TipsComm) GetJsonDetail() string {
	if x != nil {
		return x.JsonDetail
	}
	return ""
}

// OnGroupCreated()
type GroupCreatedTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	MemberList           []*GroupMemberFullInfo `protobuf:"bytes,3,rep,name=memberList,proto3" json:"memberList"`
	OperationTime        int64                  `protobuf:"varint,4,opt,name=operationTime,proto3" json:"operationTime"`
	GroupOwnerUser       *GroupMemberFullInfo   `protobuf:"bytes,5,opt,name=groupOwnerUser,proto3" json:"groupOwnerUser"`
	GroupMemberVersion   uint64                 `protobuf:"varint,6,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,7,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupCreatedTips) Reset() {
	*x = GroupCreatedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupCreatedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupCreatedTips) ProtoMessage() {}

func (x *GroupCreatedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupCreatedTips.ProtoReflect.Descriptor instead.
func (*GroupCreatedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{21}
}

func (x *GroupCreatedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupCreatedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupCreatedTips) GetMemberList() []*GroupMemberFullInfo {
	if x != nil {
		return x.MemberList
	}
	return nil
}

func (x *GroupCreatedTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *GroupCreatedTips) GetGroupOwnerUser() *GroupMemberFullInfo {
	if x != nil {
		return x.GroupOwnerUser
	}
	return nil
}

func (x *GroupCreatedTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupCreatedTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

// OnGroupInfoSet()
type GroupInfoSetTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,1,opt,name=opUser,proto3" json:"opUser"` //who do this
	MuteTime             int64                  `protobuf:"varint,2,opt,name=muteTime,proto3" json:"muteTime"`
	Group                *GroupInfo             `protobuf:"bytes,3,opt,name=group,proto3" json:"group"`
	GroupMemberVersion   uint64                 `protobuf:"varint,4,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,5,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupInfoSetTips) Reset() {
	*x = GroupInfoSetTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupInfoSetTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupInfoSetTips) ProtoMessage() {}

func (x *GroupInfoSetTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupInfoSetTips.ProtoReflect.Descriptor instead.
func (*GroupInfoSetTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{22}
}

func (x *GroupInfoSetTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupInfoSetTips) GetMuteTime() int64 {
	if x != nil {
		return x.MuteTime
	}
	return 0
}

func (x *GroupInfoSetTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupInfoSetTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupInfoSetTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

type GroupInfoSetNameTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,1,opt,name=opUser,proto3" json:"opUser"` //who do this
	Group                *GroupInfo             `protobuf:"bytes,2,opt,name=group,proto3" json:"group"`
	GroupMemberVersion   uint64                 `protobuf:"varint,3,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,4,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupInfoSetNameTips) Reset() {
	*x = GroupInfoSetNameTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupInfoSetNameTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupInfoSetNameTips) ProtoMessage() {}

func (x *GroupInfoSetNameTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupInfoSetNameTips.ProtoReflect.Descriptor instead.
func (*GroupInfoSetNameTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{23}
}

func (x *GroupInfoSetNameTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupInfoSetNameTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupInfoSetNameTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupInfoSetNameTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

type GroupInfoSetAnnouncementTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,1,opt,name=opUser,proto3" json:"opUser"` //who do this
	Group                *GroupInfo             `protobuf:"bytes,2,opt,name=group,proto3" json:"group"`
	GroupMemberVersion   uint64                 `protobuf:"varint,3,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,4,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupInfoSetAnnouncementTips) Reset() {
	*x = GroupInfoSetAnnouncementTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupInfoSetAnnouncementTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupInfoSetAnnouncementTips) ProtoMessage() {}

func (x *GroupInfoSetAnnouncementTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupInfoSetAnnouncementTips.ProtoReflect.Descriptor instead.
func (*GroupInfoSetAnnouncementTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{24}
}

func (x *GroupInfoSetAnnouncementTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupInfoSetAnnouncementTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupInfoSetAnnouncementTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupInfoSetAnnouncementTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

// OnJoinGroupApplication()
type JoinGroupApplicationTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Group         *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	Applicant     *PublicUserInfo        `protobuf:"bytes,2,opt,name=applicant,proto3" json:"applicant"`
	ReqMsg        string                 `protobuf:"bytes,3,opt,name=reqMsg,proto3" json:"reqMsg"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JoinGroupApplicationTips) Reset() {
	*x = JoinGroupApplicationTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JoinGroupApplicationTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinGroupApplicationTips) ProtoMessage() {}

func (x *JoinGroupApplicationTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinGroupApplicationTips.ProtoReflect.Descriptor instead.
func (*JoinGroupApplicationTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{25}
}

func (x *JoinGroupApplicationTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *JoinGroupApplicationTips) GetApplicant() *PublicUserInfo {
	if x != nil {
		return x.Applicant
	}
	return nil
}

func (x *JoinGroupApplicationTips) GetReqMsg() string {
	if x != nil {
		return x.ReqMsg
	}
	return ""
}

//	OnQuitGroup()
//
// Actively leave the group
type MemberQuitTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	QuitUser             *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=quitUser,proto3" json:"quitUser"`
	OperationTime        int64                  `protobuf:"varint,3,opt,name=operationTime,proto3" json:"operationTime"`
	GroupMemberVersion   uint64                 `protobuf:"varint,4,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,5,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *MemberQuitTips) Reset() {
	*x = MemberQuitTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MemberQuitTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MemberQuitTips) ProtoMessage() {}

func (x *MemberQuitTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MemberQuitTips.ProtoReflect.Descriptor instead.
func (*MemberQuitTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{26}
}

func (x *MemberQuitTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *MemberQuitTips) GetQuitUser() *GroupMemberFullInfo {
	if x != nil {
		return x.QuitUser
	}
	return nil
}

func (x *MemberQuitTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *MemberQuitTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *MemberQuitTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

// OnApplicationGroupAccepted()
type GroupApplicationAcceptedTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Group         *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser        *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	HandleMsg     string                 `protobuf:"bytes,4,opt,name=handleMsg,proto3" json:"handleMsg"`
	ReceiverAs    int32                  `protobuf:"varint,5,opt,name=receiverAs,proto3" json:"receiverAs"` // admin(==1) or applicant(==0)
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupApplicationAcceptedTips) Reset() {
	*x = GroupApplicationAcceptedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupApplicationAcceptedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupApplicationAcceptedTips) ProtoMessage() {}

func (x *GroupApplicationAcceptedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupApplicationAcceptedTips.ProtoReflect.Descriptor instead.
func (*GroupApplicationAcceptedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{27}
}

func (x *GroupApplicationAcceptedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupApplicationAcceptedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupApplicationAcceptedTips) GetHandleMsg() string {
	if x != nil {
		return x.HandleMsg
	}
	return ""
}

func (x *GroupApplicationAcceptedTips) GetReceiverAs() int32 {
	if x != nil {
		return x.ReceiverAs
	}
	return 0
}

// OnApplicationGroupRejected()
type GroupApplicationRejectedTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Group         *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser        *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	HandleMsg     string                 `protobuf:"bytes,4,opt,name=handleMsg,proto3" json:"handleMsg"`
	ReceiverAs    int32                  `protobuf:"varint,5,opt,name=receiverAs,proto3" json:"receiverAs"` // admin(==1) or applicant(==0)
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupApplicationRejectedTips) Reset() {
	*x = GroupApplicationRejectedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupApplicationRejectedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupApplicationRejectedTips) ProtoMessage() {}

func (x *GroupApplicationRejectedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupApplicationRejectedTips.ProtoReflect.Descriptor instead.
func (*GroupApplicationRejectedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{28}
}

func (x *GroupApplicationRejectedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupApplicationRejectedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupApplicationRejectedTips) GetHandleMsg() string {
	if x != nil {
		return x.HandleMsg
	}
	return ""
}

func (x *GroupApplicationRejectedTips) GetReceiverAs() int32 {
	if x != nil {
		return x.ReceiverAs
	}
	return 0
}

// OnTransferGroupOwner()
type GroupOwnerTransferredTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	NewGroupOwner        *GroupMemberFullInfo   `protobuf:"bytes,3,opt,name=newGroupOwner,proto3" json:"newGroupOwner"`
	OldGroupOwner        string                 `protobuf:"bytes,4,opt,name=oldGroupOwner,proto3" json:"oldGroupOwner"`
	OperationTime        int64                  `protobuf:"varint,5,opt,name=operationTime,proto3" json:"operationTime"`
	OldGroupOwnerInfo    *GroupMemberFullInfo   `protobuf:"bytes,6,opt,name=oldGroupOwnerInfo,proto3" json:"oldGroupOwnerInfo"`
	GroupMemberVersion   uint64                 `protobuf:"varint,7,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,8,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupOwnerTransferredTips) Reset() {
	*x = GroupOwnerTransferredTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupOwnerTransferredTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupOwnerTransferredTips) ProtoMessage() {}

func (x *GroupOwnerTransferredTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupOwnerTransferredTips.ProtoReflect.Descriptor instead.
func (*GroupOwnerTransferredTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{29}
}

func (x *GroupOwnerTransferredTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupOwnerTransferredTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupOwnerTransferredTips) GetNewGroupOwner() *GroupMemberFullInfo {
	if x != nil {
		return x.NewGroupOwner
	}
	return nil
}

func (x *GroupOwnerTransferredTips) GetOldGroupOwner() string {
	if x != nil {
		return x.OldGroupOwner
	}
	return ""
}

func (x *GroupOwnerTransferredTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *GroupOwnerTransferredTips) GetOldGroupOwnerInfo() *GroupMemberFullInfo {
	if x != nil {
		return x.OldGroupOwnerInfo
	}
	return nil
}

func (x *GroupOwnerTransferredTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupOwnerTransferredTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

// OnMemberKicked()
type MemberKickedTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	KickedUserList       []*GroupMemberFullInfo `protobuf:"bytes,3,rep,name=kickedUserList,proto3" json:"kickedUserList"`
	OperationTime        int64                  `protobuf:"varint,4,opt,name=operationTime,proto3" json:"operationTime"`
	GroupMemberVersion   uint64                 `protobuf:"varint,5,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,6,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *MemberKickedTips) Reset() {
	*x = MemberKickedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MemberKickedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MemberKickedTips) ProtoMessage() {}

func (x *MemberKickedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MemberKickedTips.ProtoReflect.Descriptor instead.
func (*MemberKickedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{30}
}

func (x *MemberKickedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *MemberKickedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *MemberKickedTips) GetKickedUserList() []*GroupMemberFullInfo {
	if x != nil {
		return x.KickedUserList
	}
	return nil
}

func (x *MemberKickedTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *MemberKickedTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *MemberKickedTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

// OnMemberInvited()
type MemberInvitedTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	InvitedUserList      []*GroupMemberFullInfo `protobuf:"bytes,3,rep,name=invitedUserList,proto3" json:"invitedUserList"`
	OperationTime        int64                  `protobuf:"varint,4,opt,name=operationTime,proto3" json:"operationTime"`
	GroupMemberVersion   uint64                 `protobuf:"varint,5,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,6,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	InviterUser          *GroupMemberFullInfo   `protobuf:"bytes,7,opt,name=inviterUser,proto3" json:"inviterUser"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *MemberInvitedTips) Reset() {
	*x = MemberInvitedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MemberInvitedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MemberInvitedTips) ProtoMessage() {}

func (x *MemberInvitedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MemberInvitedTips.ProtoReflect.Descriptor instead.
func (*MemberInvitedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{31}
}

func (x *MemberInvitedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *MemberInvitedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *MemberInvitedTips) GetInvitedUserList() []*GroupMemberFullInfo {
	if x != nil {
		return x.InvitedUserList
	}
	return nil
}

func (x *MemberInvitedTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *MemberInvitedTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *MemberInvitedTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

func (x *MemberInvitedTips) GetInviterUser() *GroupMemberFullInfo {
	if x != nil {
		return x.InviterUser
	}
	return nil
}

// Actively join the group
type MemberEnterTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	EntrantUser          *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=entrantUser,proto3" json:"entrantUser"`
	OperationTime        int64                  `protobuf:"varint,3,opt,name=operationTime,proto3" json:"operationTime"`
	GroupMemberVersion   uint64                 `protobuf:"varint,5,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,6,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *MemberEnterTips) Reset() {
	*x = MemberEnterTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MemberEnterTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MemberEnterTips) ProtoMessage() {}

func (x *MemberEnterTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MemberEnterTips.ProtoReflect.Descriptor instead.
func (*MemberEnterTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{32}
}

func (x *MemberEnterTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *MemberEnterTips) GetEntrantUser() *GroupMemberFullInfo {
	if x != nil {
		return x.EntrantUser
	}
	return nil
}

func (x *MemberEnterTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *MemberEnterTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *MemberEnterTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

type GroupDismissedTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Group         *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser        *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	OperationTime int64                  `protobuf:"varint,3,opt,name=operationTime,proto3" json:"operationTime"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupDismissedTips) Reset() {
	*x = GroupDismissedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupDismissedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupDismissedTips) ProtoMessage() {}

func (x *GroupDismissedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupDismissedTips.ProtoReflect.Descriptor instead.
func (*GroupDismissedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{33}
}

func (x *GroupDismissedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupDismissedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupDismissedTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

type GroupMemberMutedTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	OperationTime        int64                  `protobuf:"varint,3,opt,name=operationTime,proto3" json:"operationTime"`
	MutedUser            *GroupMemberFullInfo   `protobuf:"bytes,4,opt,name=mutedUser,proto3" json:"mutedUser"`
	MutedSeconds         uint32                 `protobuf:"varint,5,opt,name=mutedSeconds,proto3" json:"mutedSeconds"`
	GroupMemberVersion   uint64                 `protobuf:"varint,6,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,7,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupMemberMutedTips) Reset() {
	*x = GroupMemberMutedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupMemberMutedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupMemberMutedTips) ProtoMessage() {}

func (x *GroupMemberMutedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupMemberMutedTips.ProtoReflect.Descriptor instead.
func (*GroupMemberMutedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{34}
}

func (x *GroupMemberMutedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupMemberMutedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupMemberMutedTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *GroupMemberMutedTips) GetMutedUser() *GroupMemberFullInfo {
	if x != nil {
		return x.MutedUser
	}
	return nil
}

func (x *GroupMemberMutedTips) GetMutedSeconds() uint32 {
	if x != nil {
		return x.MutedSeconds
	}
	return 0
}

func (x *GroupMemberMutedTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupMemberMutedTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

type GroupMemberCancelMutedTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	OperationTime        int64                  `protobuf:"varint,3,opt,name=operationTime,proto3" json:"operationTime"`
	MutedUser            *GroupMemberFullInfo   `protobuf:"bytes,4,opt,name=mutedUser,proto3" json:"mutedUser"`
	GroupMemberVersion   uint64                 `protobuf:"varint,5,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,6,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupMemberCancelMutedTips) Reset() {
	*x = GroupMemberCancelMutedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupMemberCancelMutedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupMemberCancelMutedTips) ProtoMessage() {}

func (x *GroupMemberCancelMutedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupMemberCancelMutedTips.ProtoReflect.Descriptor instead.
func (*GroupMemberCancelMutedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{35}
}

func (x *GroupMemberCancelMutedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupMemberCancelMutedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupMemberCancelMutedTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *GroupMemberCancelMutedTips) GetMutedUser() *GroupMemberFullInfo {
	if x != nil {
		return x.MutedUser
	}
	return nil
}

func (x *GroupMemberCancelMutedTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupMemberCancelMutedTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

type GroupMutedTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	OperationTime        int64                  `protobuf:"varint,3,opt,name=operationTime,proto3" json:"operationTime"`
	GroupMemberVersion   uint64                 `protobuf:"varint,4,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,5,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupMutedTips) Reset() {
	*x = GroupMutedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupMutedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupMutedTips) ProtoMessage() {}

func (x *GroupMutedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupMutedTips.ProtoReflect.Descriptor instead.
func (*GroupMutedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{36}
}

func (x *GroupMutedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupMutedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupMutedTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *GroupMutedTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupMutedTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

type GroupCancelMutedTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	OperationTime        int64                  `protobuf:"varint,3,opt,name=operationTime,proto3" json:"operationTime"`
	GroupMemberVersion   uint64                 `protobuf:"varint,4,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,5,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupCancelMutedTips) Reset() {
	*x = GroupCancelMutedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupCancelMutedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupCancelMutedTips) ProtoMessage() {}

func (x *GroupCancelMutedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupCancelMutedTips.ProtoReflect.Descriptor instead.
func (*GroupCancelMutedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{37}
}

func (x *GroupCancelMutedTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupCancelMutedTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupCancelMutedTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *GroupCancelMutedTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupCancelMutedTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

type GroupMemberInfoSetTips struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Group                *GroupInfo             `protobuf:"bytes,1,opt,name=group,proto3" json:"group"`
	OpUser               *GroupMemberFullInfo   `protobuf:"bytes,2,opt,name=opUser,proto3" json:"opUser"`
	OperationTime        int64                  `protobuf:"varint,3,opt,name=operationTime,proto3" json:"operationTime"`
	ChangedUser          *GroupMemberFullInfo   `protobuf:"bytes,4,opt,name=changedUser,proto3" json:"changedUser"`
	GroupMemberVersion   uint64                 `protobuf:"varint,5,opt,name=groupMemberVersion,proto3" json:"groupMemberVersion"`
	GroupMemberVersionID string                 `protobuf:"bytes,6,opt,name=groupMemberVersionID,proto3" json:"groupMemberVersionID"`
	GroupSortVersion     uint64                 `protobuf:"varint,7,opt,name=groupSortVersion,proto3" json:"groupSortVersion"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GroupMemberInfoSetTips) Reset() {
	*x = GroupMemberInfoSetTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupMemberInfoSetTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupMemberInfoSetTips) ProtoMessage() {}

func (x *GroupMemberInfoSetTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupMemberInfoSetTips.ProtoReflect.Descriptor instead.
func (*GroupMemberInfoSetTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{38}
}

func (x *GroupMemberInfoSetTips) GetGroup() *GroupInfo {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *GroupMemberInfoSetTips) GetOpUser() *GroupMemberFullInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *GroupMemberInfoSetTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *GroupMemberInfoSetTips) GetChangedUser() *GroupMemberFullInfo {
	if x != nil {
		return x.ChangedUser
	}
	return nil
}

func (x *GroupMemberInfoSetTips) GetGroupMemberVersion() uint64 {
	if x != nil {
		return x.GroupMemberVersion
	}
	return 0
}

func (x *GroupMemberInfoSetTips) GetGroupMemberVersionID() string {
	if x != nil {
		return x.GroupMemberVersionID
	}
	return ""
}

func (x *GroupMemberInfoSetTips) GetGroupSortVersion() uint64 {
	if x != nil {
		return x.GroupSortVersion
	}
	return 0
}

type FriendApplication struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	AddTime       int64                  `protobuf:"varint,1,opt,name=addTime,proto3" json:"addTime"`
	AddSource     string                 `protobuf:"bytes,2,opt,name=addSource,proto3" json:"addSource"`
	AddWording    string                 `protobuf:"bytes,3,opt,name=addWording,proto3" json:"addWording"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FriendApplication) Reset() {
	*x = FriendApplication{}
	mi := &file_sdkws_sdkws_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendApplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendApplication) ProtoMessage() {}

func (x *FriendApplication) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendApplication.ProtoReflect.Descriptor instead.
func (*FriendApplication) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{39}
}

func (x *FriendApplication) GetAddTime() int64 {
	if x != nil {
		return x.AddTime
	}
	return 0
}

func (x *FriendApplication) GetAddSource() string {
	if x != nil {
		return x.AddSource
	}
	return ""
}

func (x *FriendApplication) GetAddWording() string {
	if x != nil {
		return x.AddWording
	}
	return ""
}

type FromToUserID struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromUserID    string                 `protobuf:"bytes,1,opt,name=fromUserID,proto3" json:"fromUserID"`
	ToUserID      string                 `protobuf:"bytes,2,opt,name=toUserID,proto3" json:"toUserID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FromToUserID) Reset() {
	*x = FromToUserID{}
	mi := &file_sdkws_sdkws_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FromToUserID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromToUserID) ProtoMessage() {}

func (x *FromToUserID) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromToUserID.ProtoReflect.Descriptor instead.
func (*FromToUserID) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{40}
}

func (x *FromToUserID) GetFromUserID() string {
	if x != nil {
		return x.FromUserID
	}
	return ""
}

func (x *FromToUserID) GetToUserID() string {
	if x != nil {
		return x.ToUserID
	}
	return ""
}

// FromUserID apply to add ToUserID
type FriendApplicationTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromToUserID  *FromToUserID          `protobuf:"bytes,1,opt,name=fromToUserID,proto3" json:"fromToUserID"` //from：发起者； to：接收者
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FriendApplicationTips) Reset() {
	*x = FriendApplicationTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendApplicationTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendApplicationTips) ProtoMessage() {}

func (x *FriendApplicationTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendApplicationTips.ProtoReflect.Descriptor instead.
func (*FriendApplicationTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{41}
}

func (x *FriendApplicationTips) GetFromToUserID() *FromToUserID {
	if x != nil {
		return x.FromToUserID
	}
	return nil
}

// FromUserID accept or reject ToUserID
type FriendApplicationApprovedTips struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	FromToUserID    *FromToUserID          `protobuf:"bytes,1,opt,name=fromToUserID,proto3" json:"fromToUserID"` //from：同意者；to：请求发起者
	HandleMsg       string                 `protobuf:"bytes,2,opt,name=handleMsg,proto3" json:"handleMsg"`
	FriendVersion   uint64                 `protobuf:"varint,3,opt,name=friendVersion,proto3" json:"friendVersion"`
	FriendVersionID string                 `protobuf:"bytes,4,opt,name=friendVersionID,proto3" json:"friendVersionID"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *FriendApplicationApprovedTips) Reset() {
	*x = FriendApplicationApprovedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendApplicationApprovedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendApplicationApprovedTips) ProtoMessage() {}

func (x *FriendApplicationApprovedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendApplicationApprovedTips.ProtoReflect.Descriptor instead.
func (*FriendApplicationApprovedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{42}
}

func (x *FriendApplicationApprovedTips) GetFromToUserID() *FromToUserID {
	if x != nil {
		return x.FromToUserID
	}
	return nil
}

func (x *FriendApplicationApprovedTips) GetHandleMsg() string {
	if x != nil {
		return x.HandleMsg
	}
	return ""
}

func (x *FriendApplicationApprovedTips) GetFriendVersion() uint64 {
	if x != nil {
		return x.FriendVersion
	}
	return 0
}

func (x *FriendApplicationApprovedTips) GetFriendVersionID() string {
	if x != nil {
		return x.FriendVersionID
	}
	return ""
}

// FromUserID accept or reject ToUserID
type FriendApplicationRejectedTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromToUserID  *FromToUserID          `protobuf:"bytes,1,opt,name=fromToUserID,proto3" json:"fromToUserID"` //from：拒绝者；to：请求发起者
	HandleMsg     string                 `protobuf:"bytes,2,opt,name=handleMsg,proto3" json:"handleMsg"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FriendApplicationRejectedTips) Reset() {
	*x = FriendApplicationRejectedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendApplicationRejectedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendApplicationRejectedTips) ProtoMessage() {}

func (x *FriendApplicationRejectedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendApplicationRejectedTips.ProtoReflect.Descriptor instead.
func (*FriendApplicationRejectedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{43}
}

func (x *FriendApplicationRejectedTips) GetFromToUserID() *FromToUserID {
	if x != nil {
		return x.FromToUserID
	}
	return nil
}

func (x *FriendApplicationRejectedTips) GetHandleMsg() string {
	if x != nil {
		return x.HandleMsg
	}
	return ""
}

// FromUserID  Added a friend ToUserID
type FriendAddedTips struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Friend          *FriendInfo            `protobuf:"bytes,1,opt,name=friend,proto3" json:"friend"`
	OperationTime   int64                  `protobuf:"varint,2,opt,name=operationTime,proto3" json:"operationTime"`
	OpUser          *PublicUserInfo        `protobuf:"bytes,3,opt,name=opUser,proto3" json:"opUser"` //who do this
	FriendVersion   uint64                 `protobuf:"varint,4,opt,name=friendVersion,proto3" json:"friendVersion"`
	FriendVersionID string                 `protobuf:"bytes,5,opt,name=friendVersionID,proto3" json:"friendVersionID"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *FriendAddedTips) Reset() {
	*x = FriendAddedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendAddedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendAddedTips) ProtoMessage() {}

func (x *FriendAddedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendAddedTips.ProtoReflect.Descriptor instead.
func (*FriendAddedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{44}
}

func (x *FriendAddedTips) GetFriend() *FriendInfo {
	if x != nil {
		return x.Friend
	}
	return nil
}

func (x *FriendAddedTips) GetOperationTime() int64 {
	if x != nil {
		return x.OperationTime
	}
	return 0
}

func (x *FriendAddedTips) GetOpUser() *PublicUserInfo {
	if x != nil {
		return x.OpUser
	}
	return nil
}

func (x *FriendAddedTips) GetFriendVersion() uint64 {
	if x != nil {
		return x.FriendVersion
	}
	return 0
}

func (x *FriendAddedTips) GetFriendVersionID() string {
	if x != nil {
		return x.FriendVersionID
	}
	return ""
}

// FromUserID  deleted a friend ToUserID
type FriendDeletedTips struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	FromToUserID    *FromToUserID          `protobuf:"bytes,1,opt,name=fromToUserID,proto3" json:"fromToUserID"` //from：owner； to：friend
	FriendVersion   uint64                 `protobuf:"varint,2,opt,name=friendVersion,proto3" json:"friendVersion"`
	FriendVersionID string                 `protobuf:"bytes,3,opt,name=friendVersionID,proto3" json:"friendVersionID"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *FriendDeletedTips) Reset() {
	*x = FriendDeletedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendDeletedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendDeletedTips) ProtoMessage() {}

func (x *FriendDeletedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendDeletedTips.ProtoReflect.Descriptor instead.
func (*FriendDeletedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{45}
}

func (x *FriendDeletedTips) GetFromToUserID() *FromToUserID {
	if x != nil {
		return x.FromToUserID
	}
	return nil
}

func (x *FriendDeletedTips) GetFriendVersion() uint64 {
	if x != nil {
		return x.FriendVersion
	}
	return 0
}

func (x *FriendDeletedTips) GetFriendVersionID() string {
	if x != nil {
		return x.FriendVersionID
	}
	return ""
}

type BlackAddedTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromToUserID  *FromToUserID          `protobuf:"bytes,1,opt,name=fromToUserID,proto3" json:"fromToUserID"` //from：owner； to：black
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BlackAddedTips) Reset() {
	*x = BlackAddedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BlackAddedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlackAddedTips) ProtoMessage() {}

func (x *BlackAddedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlackAddedTips.ProtoReflect.Descriptor instead.
func (*BlackAddedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{46}
}

func (x *BlackAddedTips) GetFromToUserID() *FromToUserID {
	if x != nil {
		return x.FromToUserID
	}
	return nil
}

type BlackDeletedTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromToUserID  *FromToUserID          `protobuf:"bytes,1,opt,name=fromToUserID,proto3" json:"fromToUserID"` //from：owner； to：black
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BlackDeletedTips) Reset() {
	*x = BlackDeletedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BlackDeletedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlackDeletedTips) ProtoMessage() {}

func (x *BlackDeletedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlackDeletedTips.ProtoReflect.Descriptor instead.
func (*BlackDeletedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{47}
}

func (x *BlackDeletedTips) GetFromToUserID() *FromToUserID {
	if x != nil {
		return x.FromToUserID
	}
	return nil
}

type FriendInfoChangedTips struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	FromToUserID      *FromToUserID          `protobuf:"bytes,1,opt,name=fromToUserID,proto3" json:"fromToUserID"` //from：changed； to：friend
	FriendVersion     uint64                 `protobuf:"varint,2,opt,name=friendVersion,proto3" json:"friendVersion"`
	FriendVersionID   string                 `protobuf:"bytes,3,opt,name=friendVersionID,proto3" json:"friendVersionID"`
	FriendSortVersion uint64                 `protobuf:"varint,4,opt,name=friendSortVersion,proto3" json:"friendSortVersion"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *FriendInfoChangedTips) Reset() {
	*x = FriendInfoChangedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendInfoChangedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendInfoChangedTips) ProtoMessage() {}

func (x *FriendInfoChangedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendInfoChangedTips.ProtoReflect.Descriptor instead.
func (*FriendInfoChangedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{48}
}

func (x *FriendInfoChangedTips) GetFromToUserID() *FromToUserID {
	if x != nil {
		return x.FromToUserID
	}
	return nil
}

func (x *FriendInfoChangedTips) GetFriendVersion() uint64 {
	if x != nil {
		return x.FriendVersion
	}
	return 0
}

func (x *FriendInfoChangedTips) GetFriendVersionID() string {
	if x != nil {
		return x.FriendVersionID
	}
	return ""
}

func (x *FriendInfoChangedTips) GetFriendSortVersion() uint64 {
	if x != nil {
		return x.FriendSortVersion
	}
	return 0
}

// ////////////////////user/////////////////////
type UserInfoUpdatedTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserInfoUpdatedTips) Reset() {
	*x = UserInfoUpdatedTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserInfoUpdatedTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInfoUpdatedTips) ProtoMessage() {}

func (x *UserInfoUpdatedTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInfoUpdatedTips.ProtoReflect.Descriptor instead.
func (*UserInfoUpdatedTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{49}
}

func (x *UserInfoUpdatedTips) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type UserStatusChangeTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromUserID    string                 `protobuf:"bytes,1,opt,name=fromUserID,proto3" json:"fromUserID"`
	ToUserID      string                 `protobuf:"bytes,2,opt,name=toUserID,proto3" json:"toUserID"`
	Status        int32                  `protobuf:"varint,3,opt,name=status,proto3" json:"status"`
	PlatformID    int32                  `protobuf:"varint,4,opt,name=platformID,proto3" json:"platformID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserStatusChangeTips) Reset() {
	*x = UserStatusChangeTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserStatusChangeTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserStatusChangeTips) ProtoMessage() {}

func (x *UserStatusChangeTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserStatusChangeTips.ProtoReflect.Descriptor instead.
func (*UserStatusChangeTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{50}
}

func (x *UserStatusChangeTips) GetFromUserID() string {
	if x != nil {
		return x.FromUserID
	}
	return ""
}

func (x *UserStatusChangeTips) GetToUserID() string {
	if x != nil {
		return x.ToUserID
	}
	return ""
}

func (x *UserStatusChangeTips) GetStatus() int32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *UserStatusChangeTips) GetPlatformID() int32 {
	if x != nil {
		return x.PlatformID
	}
	return 0
}

type UserCommandAddTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromUserID    string                 `protobuf:"bytes,1,opt,name=fromUserID,proto3" json:"fromUserID"`
	ToUserID      string                 `protobuf:"bytes,2,opt,name=toUserID,proto3" json:"toUserID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserCommandAddTips) Reset() {
	*x = UserCommandAddTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCommandAddTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCommandAddTips) ProtoMessage() {}

func (x *UserCommandAddTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCommandAddTips.ProtoReflect.Descriptor instead.
func (*UserCommandAddTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{51}
}

func (x *UserCommandAddTips) GetFromUserID() string {
	if x != nil {
		return x.FromUserID
	}
	return ""
}

func (x *UserCommandAddTips) GetToUserID() string {
	if x != nil {
		return x.ToUserID
	}
	return ""
}

type UserCommandUpdateTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromUserID    string                 `protobuf:"bytes,1,opt,name=fromUserID,proto3" json:"fromUserID"`
	ToUserID      string                 `protobuf:"bytes,2,opt,name=toUserID,proto3" json:"toUserID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserCommandUpdateTips) Reset() {
	*x = UserCommandUpdateTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCommandUpdateTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCommandUpdateTips) ProtoMessage() {}

func (x *UserCommandUpdateTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCommandUpdateTips.ProtoReflect.Descriptor instead.
func (*UserCommandUpdateTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{52}
}

func (x *UserCommandUpdateTips) GetFromUserID() string {
	if x != nil {
		return x.FromUserID
	}
	return ""
}

func (x *UserCommandUpdateTips) GetToUserID() string {
	if x != nil {
		return x.ToUserID
	}
	return ""
}

type UserCommandDeleteTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	FromUserID    string                 `protobuf:"bytes,1,opt,name=fromUserID,proto3" json:"fromUserID"`
	ToUserID      string                 `protobuf:"bytes,2,opt,name=toUserID,proto3" json:"toUserID"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserCommandDeleteTips) Reset() {
	*x = UserCommandDeleteTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCommandDeleteTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCommandDeleteTips) ProtoMessage() {}

func (x *UserCommandDeleteTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCommandDeleteTips.ProtoReflect.Descriptor instead.
func (*UserCommandDeleteTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{53}
}

func (x *UserCommandDeleteTips) GetFromUserID() string {
	if x != nil {
		return x.FromUserID
	}
	return ""
}

func (x *UserCommandDeleteTips) GetToUserID() string {
	if x != nil {
		return x.ToUserID
	}
	return ""
}

// ////////////////////conversation/////////////////////
type ConversationUpdateTips struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	UserID             string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	ConversationIDList []string               `protobuf:"bytes,2,rep,name=conversationIDList,proto3" json:"conversationIDList"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ConversationUpdateTips) Reset() {
	*x = ConversationUpdateTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationUpdateTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationUpdateTips) ProtoMessage() {}

func (x *ConversationUpdateTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationUpdateTips.ProtoReflect.Descriptor instead.
func (*ConversationUpdateTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{54}
}

func (x *ConversationUpdateTips) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *ConversationUpdateTips) GetConversationIDList() []string {
	if x != nil {
		return x.ConversationIDList
	}
	return nil
}

type ConversationSetPrivateTips struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	RecvID         string                 `protobuf:"bytes,1,opt,name=recvID,proto3" json:"recvID"`
	SendID         string                 `protobuf:"bytes,2,opt,name=sendID,proto3" json:"sendID"`
	IsPrivate      bool                   `protobuf:"varint,3,opt,name=isPrivate,proto3" json:"isPrivate"`
	ConversationID string                 `protobuf:"bytes,4,opt,name=conversationID,proto3" json:"conversationID"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ConversationSetPrivateTips) Reset() {
	*x = ConversationSetPrivateTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationSetPrivateTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationSetPrivateTips) ProtoMessage() {}

func (x *ConversationSetPrivateTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationSetPrivateTips.ProtoReflect.Descriptor instead.
func (*ConversationSetPrivateTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{55}
}

func (x *ConversationSetPrivateTips) GetRecvID() string {
	if x != nil {
		return x.RecvID
	}
	return ""
}

func (x *ConversationSetPrivateTips) GetSendID() string {
	if x != nil {
		return x.SendID
	}
	return ""
}

func (x *ConversationSetPrivateTips) GetIsPrivate() bool {
	if x != nil {
		return x.IsPrivate
	}
	return false
}

func (x *ConversationSetPrivateTips) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

type ConversationHasReadTips struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	UserID          string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	ConversationID  string                 `protobuf:"bytes,2,opt,name=conversationID,proto3" json:"conversationID"`
	HasReadSeq      int64                  `protobuf:"varint,3,opt,name=hasReadSeq,proto3" json:"hasReadSeq"`
	UnreadCountTime int64                  `protobuf:"varint,4,opt,name=unreadCountTime,proto3" json:"unreadCountTime"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ConversationHasReadTips) Reset() {
	*x = ConversationHasReadTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationHasReadTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationHasReadTips) ProtoMessage() {}

func (x *ConversationHasReadTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationHasReadTips.ProtoReflect.Descriptor instead.
func (*ConversationHasReadTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{56}
}

func (x *ConversationHasReadTips) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *ConversationHasReadTips) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *ConversationHasReadTips) GetHasReadSeq() int64 {
	if x != nil {
		return x.HasReadSeq
	}
	return 0
}

func (x *ConversationHasReadTips) GetUnreadCountTime() int64 {
	if x != nil {
		return x.UnreadCountTime
	}
	return 0
}

type NotificationElem struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Detail        string                 `protobuf:"bytes,1,opt,name=detail,proto3" json:"detail"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NotificationElem) Reset() {
	*x = NotificationElem{}
	mi := &file_sdkws_sdkws_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotificationElem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationElem) ProtoMessage() {}

func (x *NotificationElem) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationElem.ProtoReflect.Descriptor instead.
func (*NotificationElem) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{57}
}

func (x *NotificationElem) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

// //////////////////message///////////////////////
type Seqs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Seqs          []int64                `protobuf:"varint,1,rep,packed,name=seqs,proto3" json:"seqs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Seqs) Reset() {
	*x = Seqs{}
	mi := &file_sdkws_sdkws_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Seqs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Seqs) ProtoMessage() {}

func (x *Seqs) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Seqs.ProtoReflect.Descriptor instead.
func (*Seqs) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{58}
}

func (x *Seqs) GetSeqs() []int64 {
	if x != nil {
		return x.Seqs
	}
	return nil
}

type DeleteMessageTips struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	OpUserID      string                 `protobuf:"bytes,1,opt,name=opUserID,proto3" json:"opUserID"`
	UserID        string                 `protobuf:"bytes,2,opt,name=userID,proto3" json:"userID"`
	Seqs          []int64                `protobuf:"varint,3,rep,packed,name=seqs,proto3" json:"seqs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteMessageTips) Reset() {
	*x = DeleteMessageTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteMessageTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMessageTips) ProtoMessage() {}

func (x *DeleteMessageTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMessageTips.ProtoReflect.Descriptor instead.
func (*DeleteMessageTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{59}
}

func (x *DeleteMessageTips) GetOpUserID() string {
	if x != nil {
		return x.OpUserID
	}
	return ""
}

func (x *DeleteMessageTips) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *DeleteMessageTips) GetSeqs() []int64 {
	if x != nil {
		return x.Seqs
	}
	return nil
}

type RevokeMsgTips struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	RevokerUserID  string                 `protobuf:"bytes,1,opt,name=revokerUserID,proto3" json:"revokerUserID"`
	ClientMsgID    string                 `protobuf:"bytes,2,opt,name=clientMsgID,proto3" json:"clientMsgID"`
	RevokeTime     int64                  `protobuf:"varint,3,opt,name=revokeTime,proto3" json:"revokeTime"`
	SesstionType   int32                  `protobuf:"varint,5,opt,name=sesstionType,proto3" json:"sesstionType"`
	Seq            int64                  `protobuf:"varint,6,opt,name=seq,proto3" json:"seq"`
	ConversationID string                 `protobuf:"bytes,7,opt,name=conversationID,proto3" json:"conversationID"`
	IsAdminRevoke  bool                   `protobuf:"varint,8,opt,name=isAdminRevoke,proto3" json:"isAdminRevoke"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *RevokeMsgTips) Reset() {
	*x = RevokeMsgTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RevokeMsgTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevokeMsgTips) ProtoMessage() {}

func (x *RevokeMsgTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevokeMsgTips.ProtoReflect.Descriptor instead.
func (*RevokeMsgTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{60}
}

func (x *RevokeMsgTips) GetRevokerUserID() string {
	if x != nil {
		return x.RevokerUserID
	}
	return ""
}

func (x *RevokeMsgTips) GetClientMsgID() string {
	if x != nil {
		return x.ClientMsgID
	}
	return ""
}

func (x *RevokeMsgTips) GetRevokeTime() int64 {
	if x != nil {
		return x.RevokeTime
	}
	return 0
}

func (x *RevokeMsgTips) GetSesstionType() int32 {
	if x != nil {
		return x.SesstionType
	}
	return 0
}

func (x *RevokeMsgTips) GetSeq() int64 {
	if x != nil {
		return x.Seq
	}
	return 0
}

func (x *RevokeMsgTips) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *RevokeMsgTips) GetIsAdminRevoke() bool {
	if x != nil {
		return x.IsAdminRevoke
	}
	return false
}

type MessageRevokedContent struct {
	state                       protoimpl.MessageState `protogen:"open.v1"`
	RevokerID                   string                 `protobuf:"bytes,1,opt,name=revokerID,proto3" json:"revokerID"`
	RevokerRole                 int32                  `protobuf:"varint,2,opt,name=revokerRole,proto3" json:"revokerRole"`
	ClientMsgID                 string                 `protobuf:"bytes,3,opt,name=clientMsgID,proto3" json:"clientMsgID"`
	RevokerNickname             string                 `protobuf:"bytes,4,opt,name=revokerNickname,proto3" json:"revokerNickname"`
	RevokeTime                  int64                  `protobuf:"varint,5,opt,name=revokeTime,proto3" json:"revokeTime"`
	SourceMessageSendTime       int64                  `protobuf:"varint,6,opt,name=sourceMessageSendTime,proto3" json:"sourceMessageSendTime"`
	SourceMessageSendID         string                 `protobuf:"bytes,7,opt,name=sourceMessageSendID,proto3" json:"sourceMessageSendID"`
	SourceMessageSenderNickname string                 `protobuf:"bytes,8,opt,name=sourceMessageSenderNickname,proto3" json:"sourceMessageSenderNickname"`
	SessionType                 int32                  `protobuf:"varint,10,opt,name=sessionType,proto3" json:"sessionType"`
	Seq                         int64                  `protobuf:"varint,11,opt,name=seq,proto3" json:"seq"`
	Ex                          string                 `protobuf:"bytes,12,opt,name=ex,proto3" json:"ex"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *MessageRevokedContent) Reset() {
	*x = MessageRevokedContent{}
	mi := &file_sdkws_sdkws_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageRevokedContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageRevokedContent) ProtoMessage() {}

func (x *MessageRevokedContent) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageRevokedContent.ProtoReflect.Descriptor instead.
func (*MessageRevokedContent) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{61}
}

func (x *MessageRevokedContent) GetRevokerID() string {
	if x != nil {
		return x.RevokerID
	}
	return ""
}

func (x *MessageRevokedContent) GetRevokerRole() int32 {
	if x != nil {
		return x.RevokerRole
	}
	return 0
}

func (x *MessageRevokedContent) GetClientMsgID() string {
	if x != nil {
		return x.ClientMsgID
	}
	return ""
}

func (x *MessageRevokedContent) GetRevokerNickname() string {
	if x != nil {
		return x.RevokerNickname
	}
	return ""
}

func (x *MessageRevokedContent) GetRevokeTime() int64 {
	if x != nil {
		return x.RevokeTime
	}
	return 0
}

func (x *MessageRevokedContent) GetSourceMessageSendTime() int64 {
	if x != nil {
		return x.SourceMessageSendTime
	}
	return 0
}

func (x *MessageRevokedContent) GetSourceMessageSendID() string {
	if x != nil {
		return x.SourceMessageSendID
	}
	return ""
}

func (x *MessageRevokedContent) GetSourceMessageSenderNickname() string {
	if x != nil {
		return x.SourceMessageSenderNickname
	}
	return ""
}

func (x *MessageRevokedContent) GetSessionType() int32 {
	if x != nil {
		return x.SessionType
	}
	return 0
}

func (x *MessageRevokedContent) GetSeq() int64 {
	if x != nil {
		return x.Seq
	}
	return 0
}

func (x *MessageRevokedContent) GetEx() string {
	if x != nil {
		return x.Ex
	}
	return ""
}

type ClearConversationTips struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	UserID          string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	ConversationIDs []string               `protobuf:"bytes,2,rep,name=conversationIDs,proto3" json:"conversationIDs"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ClearConversationTips) Reset() {
	*x = ClearConversationTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClearConversationTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClearConversationTips) ProtoMessage() {}

func (x *ClearConversationTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClearConversationTips.ProtoReflect.Descriptor instead.
func (*ClearConversationTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{62}
}

func (x *ClearConversationTips) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *ClearConversationTips) GetConversationIDs() []string {
	if x != nil {
		return x.ConversationIDs
	}
	return nil
}

type DeleteMsgsTips struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	UserID         string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	ConversationID string                 `protobuf:"bytes,2,opt,name=conversationID,proto3" json:"conversationID"`
	Seqs           []int64                `protobuf:"varint,3,rep,packed,name=seqs,proto3" json:"seqs"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *DeleteMsgsTips) Reset() {
	*x = DeleteMsgsTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteMsgsTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMsgsTips) ProtoMessage() {}

func (x *DeleteMsgsTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMsgsTips.ProtoReflect.Descriptor instead.
func (*DeleteMsgsTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{63}
}

func (x *DeleteMsgsTips) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *DeleteMsgsTips) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *DeleteMsgsTips) GetSeqs() []int64 {
	if x != nil {
		return x.Seqs
	}
	return nil
}

type MarkAsReadTips struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	MarkAsReadUserID string                 `protobuf:"bytes,1,opt,name=markAsReadUserID,proto3" json:"markAsReadUserID"`
	ConversationID   string                 `protobuf:"bytes,2,opt,name=conversationID,proto3" json:"conversationID"`
	Seqs             []int64                `protobuf:"varint,3,rep,packed,name=seqs,proto3" json:"seqs"`
	HasReadSeq       int64                  `protobuf:"varint,4,opt,name=hasReadSeq,proto3" json:"hasReadSeq"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *MarkAsReadTips) Reset() {
	*x = MarkAsReadTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MarkAsReadTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MarkAsReadTips) ProtoMessage() {}

func (x *MarkAsReadTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MarkAsReadTips.ProtoReflect.Descriptor instead.
func (*MarkAsReadTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{64}
}

func (x *MarkAsReadTips) GetMarkAsReadUserID() string {
	if x != nil {
		return x.MarkAsReadUserID
	}
	return ""
}

func (x *MarkAsReadTips) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *MarkAsReadTips) GetSeqs() []int64 {
	if x != nil {
		return x.Seqs
	}
	return nil
}

func (x *MarkAsReadTips) GetHasReadSeq() int64 {
	if x != nil {
		return x.HasReadSeq
	}
	return 0
}

type SetAppBackgroundStatusReq struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	IsBackground  bool                   `protobuf:"varint,2,opt,name=isBackground,proto3" json:"isBackground"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetAppBackgroundStatusReq) Reset() {
	*x = SetAppBackgroundStatusReq{}
	mi := &file_sdkws_sdkws_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetAppBackgroundStatusReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetAppBackgroundStatusReq) ProtoMessage() {}

func (x *SetAppBackgroundStatusReq) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetAppBackgroundStatusReq.ProtoReflect.Descriptor instead.
func (*SetAppBackgroundStatusReq) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{65}
}

func (x *SetAppBackgroundStatusReq) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *SetAppBackgroundStatusReq) GetIsBackground() bool {
	if x != nil {
		return x.IsBackground
	}
	return false
}

type SetAppBackgroundStatusResp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetAppBackgroundStatusResp) Reset() {
	*x = SetAppBackgroundStatusResp{}
	mi := &file_sdkws_sdkws_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetAppBackgroundStatusResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetAppBackgroundStatusResp) ProtoMessage() {}

func (x *SetAppBackgroundStatusResp) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetAppBackgroundStatusResp.ProtoReflect.Descriptor instead.
func (*SetAppBackgroundStatusResp) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{66}
}

type ProcessUserCommand struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	UserID        string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	Type          int32                  `protobuf:"varint,2,opt,name=type,proto3" json:"type"`
	CreateTime    int64                  `protobuf:"varint,3,opt,name=createTime,proto3" json:"createTime"`
	Uuid          string                 `protobuf:"bytes,4,opt,name=uuid,proto3" json:"uuid"`
	Value         string                 `protobuf:"bytes,5,opt,name=value,proto3" json:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessUserCommand) Reset() {
	*x = ProcessUserCommand{}
	mi := &file_sdkws_sdkws_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessUserCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessUserCommand) ProtoMessage() {}

func (x *ProcessUserCommand) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessUserCommand.ProtoReflect.Descriptor instead.
func (*ProcessUserCommand) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{67}
}

func (x *ProcessUserCommand) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *ProcessUserCommand) GetType() int32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *ProcessUserCommand) GetCreateTime() int64 {
	if x != nil {
		return x.CreateTime
	}
	return 0
}

func (x *ProcessUserCommand) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *ProcessUserCommand) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type RequestPagination struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PageNumber    int32                  `protobuf:"varint,1,opt,name=pageNumber,proto3" json:"pageNumber"`
	ShowNumber    int32                  `protobuf:"varint,2,opt,name=showNumber,proto3" json:"showNumber"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RequestPagination) Reset() {
	*x = RequestPagination{}
	mi := &file_sdkws_sdkws_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RequestPagination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestPagination) ProtoMessage() {}

func (x *RequestPagination) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestPagination.ProtoReflect.Descriptor instead.
func (*RequestPagination) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{68}
}

func (x *RequestPagination) GetPageNumber() int32 {
	if x != nil {
		return x.PageNumber
	}
	return 0
}

func (x *RequestPagination) GetShowNumber() int32 {
	if x != nil {
		return x.ShowNumber
	}
	return 0
}

type FriendsInfoUpdateTips struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	FromToUserID    *FromToUserID          `protobuf:"bytes,1,opt,name=fromToUserID,proto3" json:"fromToUserID"`
	FriendIDs       []string               `protobuf:"bytes,2,rep,name=friendIDs,proto3" json:"friendIDs"`
	FriendVersion   uint64                 `protobuf:"varint,3,opt,name=friendVersion,proto3" json:"friendVersion"`
	FriendVersionID string                 `protobuf:"bytes,4,opt,name=friendVersionID,proto3" json:"friendVersionID"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *FriendsInfoUpdateTips) Reset() {
	*x = FriendsInfoUpdateTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FriendsInfoUpdateTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FriendsInfoUpdateTips) ProtoMessage() {}

func (x *FriendsInfoUpdateTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FriendsInfoUpdateTips.ProtoReflect.Descriptor instead.
func (*FriendsInfoUpdateTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{69}
}

func (x *FriendsInfoUpdateTips) GetFromToUserID() *FromToUserID {
	if x != nil {
		return x.FromToUserID
	}
	return nil
}

func (x *FriendsInfoUpdateTips) GetFriendIDs() []string {
	if x != nil {
		return x.FriendIDs
	}
	return nil
}

func (x *FriendsInfoUpdateTips) GetFriendVersion() uint64 {
	if x != nil {
		return x.FriendVersion
	}
	return 0
}

func (x *FriendsInfoUpdateTips) GetFriendVersionID() string {
	if x != nil {
		return x.FriendVersionID
	}
	return ""
}

type SubUserOnlineStatusElem struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	UserID            string                 `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID"`
	OnlinePlatformIDs []int32                `protobuf:"varint,2,rep,packed,name=onlinePlatformIDs,proto3" json:"onlinePlatformIDs"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *SubUserOnlineStatusElem) Reset() {
	*x = SubUserOnlineStatusElem{}
	mi := &file_sdkws_sdkws_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SubUserOnlineStatusElem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubUserOnlineStatusElem) ProtoMessage() {}

func (x *SubUserOnlineStatusElem) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubUserOnlineStatusElem.ProtoReflect.Descriptor instead.
func (*SubUserOnlineStatusElem) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{70}
}

func (x *SubUserOnlineStatusElem) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *SubUserOnlineStatusElem) GetOnlinePlatformIDs() []int32 {
	if x != nil {
		return x.OnlinePlatformIDs
	}
	return nil
}

type SubUserOnlineStatusTips struct {
	state         protoimpl.MessageState     `protogen:"open.v1"`
	Subscribers   []*SubUserOnlineStatusElem `protobuf:"bytes,1,rep,name=subscribers,proto3" json:"subscribers"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SubUserOnlineStatusTips) Reset() {
	*x = SubUserOnlineStatusTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SubUserOnlineStatusTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubUserOnlineStatusTips) ProtoMessage() {}

func (x *SubUserOnlineStatusTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubUserOnlineStatusTips.ProtoReflect.Descriptor instead.
func (*SubUserOnlineStatusTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{71}
}

func (x *SubUserOnlineStatusTips) GetSubscribers() []*SubUserOnlineStatusElem {
	if x != nil {
		return x.Subscribers
	}
	return nil
}

type SubUserOnlineStatus struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	SubscribeUserID   []string               `protobuf:"bytes,1,rep,name=subscribeUserID,proto3" json:"subscribeUserID"`
	UnsubscribeUserID []string               `protobuf:"bytes,2,rep,name=unsubscribeUserID,proto3" json:"unsubscribeUserID"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *SubUserOnlineStatus) Reset() {
	*x = SubUserOnlineStatus{}
	mi := &file_sdkws_sdkws_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SubUserOnlineStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubUserOnlineStatus) ProtoMessage() {}

func (x *SubUserOnlineStatus) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubUserOnlineStatus.ProtoReflect.Descriptor instead.
func (*SubUserOnlineStatus) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{72}
}

func (x *SubUserOnlineStatus) GetSubscribeUserID() []string {
	if x != nil {
		return x.SubscribeUserID
	}
	return nil
}

func (x *SubUserOnlineStatus) GetUnsubscribeUserID() []string {
	if x != nil {
		return x.UnsubscribeUserID
	}
	return nil
}

type StreamMsgTips struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	ConversationID string                 `protobuf:"bytes,1,opt,name=conversationID,proto3" json:"conversationID"`
	ClientMsgID    string                 `protobuf:"bytes,2,opt,name=clientMsgID,proto3" json:"clientMsgID"`
	StartIndex     int64                  `protobuf:"varint,3,opt,name=startIndex,proto3" json:"startIndex"`
	Packets        []string               `protobuf:"bytes,4,rep,name=packets,proto3" json:"packets"`
	End            bool                   `protobuf:"varint,5,opt,name=end,proto3" json:"end"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *StreamMsgTips) Reset() {
	*x = StreamMsgTips{}
	mi := &file_sdkws_sdkws_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamMsgTips) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamMsgTips) ProtoMessage() {}

func (x *StreamMsgTips) ProtoReflect() protoreflect.Message {
	mi := &file_sdkws_sdkws_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamMsgTips.ProtoReflect.Descriptor instead.
func (*StreamMsgTips) Descriptor() ([]byte, []int) {
	return file_sdkws_sdkws_proto_rawDescGZIP(), []int{73}
}

func (x *StreamMsgTips) GetConversationID() string {
	if x != nil {
		return x.ConversationID
	}
	return ""
}

func (x *StreamMsgTips) GetClientMsgID() string {
	if x != nil {
		return x.ClientMsgID
	}
	return ""
}

func (x *StreamMsgTips) GetStartIndex() int64 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *StreamMsgTips) GetPackets() []string {
	if x != nil {
		return x.Packets
	}
	return nil
}

func (x *StreamMsgTips) GetEnd() bool {
	if x != nil {
		return x.End
	}
	return false
}

var File_sdkws_sdkws_proto protoreflect.FileDescriptor

var file_sdkws_sdkws_proto_rawDesc = []byte{
	0x0a, 0x11, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77,
	0x73, 0x1a, 0x1b, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x70, 0x62, 0x2f, 0x77, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x70, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdf,
	0x04, 0x0a, 0x09, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x18, 0x0a, 0x07,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x66, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66,
	0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x65, 0x78,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x6f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x54, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x6e, 0x65, 0x65, 0x64, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x10, 0x6e, 0x65, 0x65, 0x64, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0e, 0x6c, 0x6f, 0x6f, 0x6b, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6c, 0x6f, 0x6f, 0x6b,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x11, 0x61, 0x70,
	0x70, 0x6c, 0x79, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x46, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x12, 0x36, 0x0a, 0x16, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x2e, 0x0a, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x22, 0xb2, 0x03, 0x0a, 0x0f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x46, 0x6f,
	0x72, 0x53, 0x65, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x1c,
	0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x12, 0x2c,
	0x0a, 0x02, 0x65, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x02, 0x65, 0x78, 0x12, 0x47, 0x0a, 0x10,
	0x6e, 0x65, 0x65, 0x64, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x10, 0x6e, 0x65, 0x65, 0x64, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x0e, 0x6c, 0x6f, 0x6f, 0x6b, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x6c, 0x6f, 0x6f, 0x6b,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x49, 0x0a, 0x11, 0x61, 0x70,
	0x70, 0x6c, 0x79, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x11, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x22, 0xff, 0x02, 0x0a, 0x13, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x18, 0x0a,
	0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12,
	0x1c, 0x0a, 0x09, 0x72, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1a, 0x0a,
	0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x69, 0x63,
	0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x69, 0x63,
	0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x12,
	0x26, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x4d, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x4d, 0x61, 0x6e, 0x67,
	0x65, 0x72, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1e, 0x0a, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6a, 0x6f, 0x69,
	0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12,
	0x0e, 0x0a, 0x02, 0x65, 0x78, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x12,
	0x20, 0x0a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x24, 0x0a, 0x0d, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65,
	0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x6e, 0x0a, 0x0e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x66, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x66, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x12, 0x0e, 0x0a, 0x02, 0x65, 0x78, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x22, 0xdc, 0x01, 0x0a, 0x08, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1a, 0x0a, 0x08,
	0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x61, 0x63, 0x65,
	0x55, 0x52, 0x4c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x61, 0x63, 0x65, 0x55,
	0x52, 0x4c, 0x12, 0x0e, 0x0a, 0x02, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x65, 0x78, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x4d, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x4d,
	0x61, 0x6e, 0x67, 0x65, 0x72, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x2a, 0x0a, 0x10, 0x67, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x52, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x52, 0x65, 0x63, 0x76,
	0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x22, 0x91, 0x02, 0x0a, 0x0e, 0x55, 0x73, 0x65, 0x72, 0x49,
	0x6e, 0x66, 0x6f, 0x57, 0x69, 0x74, 0x68, 0x45, 0x78, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x12, 0x38, 0x0a, 0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x08, 0x6e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x07, 0x66,
	0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x66, 0x61, 0x63, 0x65,
	0x55, 0x52, 0x4c, 0x12, 0x2c, 0x0a, 0x02, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x02, 0x65,
	0x78, 0x12, 0x47, 0x0a, 0x10, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x52, 0x65, 0x63, 0x76, 0x4d,
	0x73, 0x67, 0x4f, 0x70, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
	0x52, 0x65, 0x63, 0x76, 0x4d, 0x73, 0x67, 0x4f, 0x70, 0x74, 0x22, 0x90, 0x02, 0x0a, 0x0a, 0x46,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x72,
	0x65, 0x6d, 0x61, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x6d,
	0x61, 0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x0a, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x55, 0x73, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0a, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x61,
	0x64, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x61, 0x64, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x12, 0x0e, 0x0a, 0x02, 0x65, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65,
	0x78, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x73, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x22, 0xe7, 0x01,
	0x0a, 0x09, 0x42, 0x6c, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1e, 0x0a,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a,
	0x0d, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64,
	0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0d, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x61, 0x64, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x26, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x0e, 0x0a, 0x02, 0x65, 0x78, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x22, 0x8d, 0x03, 0x0a, 0x0c, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x35, 0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73,
	0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0c, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x72, 0x65, 0x71, 0x4d, 0x73, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72,
	0x65, 0x71, 0x4d, 0x73, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x4d,
	0x73, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x4d, 0x73, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x72, 0x65, 0x71, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a,
	0x0c, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x0e, 0x0a, 0x02, 0x65, 0x78, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65,
	0x78, 0x12, 0x1e, 0x0a, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6a, 0x6f, 0x69, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x24, 0x0a, 0x0d, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65,
	0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x9f, 0x03, 0x0a, 0x0d, 0x46, 0x72, 0x69, 0x65,
	0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x72, 0x6f,
	0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66,
	0x72, 0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x22, 0x0a, 0x0c, 0x66, 0x72, 0x6f,
	0x6d, 0x4e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x4e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x66, 0x72, 0x6f, 0x6d, 0x46, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x66, 0x72, 0x6f, 0x6d, 0x46, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x12,
	0x1a, 0x0a, 0x08, 0x74, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x74, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x74,
	0x6f, 0x4e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x74, 0x6f, 0x4e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74,
	0x6f, 0x46, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x74, 0x6f, 0x46, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c, 0x12, 0x22, 0x0a, 0x0c, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0c, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x72, 0x65, 0x71, 0x4d, 0x73, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72,
	0x65, 0x71, 0x4d, 0x73, 0x67, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x4d, 0x73, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x4d, 0x73, 0x67, 0x12, 0x1e, 0x0a, 0x0a, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x65, 0x78, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x22, 0x93, 0x01, 0x0a, 0x14, 0x50, 0x75,
	0x6c, 0x6c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x79, 0x53, 0x65, 0x71, 0x73, 0x52,
	0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x34, 0x0a, 0x09, 0x73, 0x65,
	0x71, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x53, 0x65, 0x71,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x73, 0x65, 0x71, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x2d, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50,
	0x75, 0x6c, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x22,
	0x6c, 0x0a, 0x08, 0x53, 0x65, 0x71, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x44, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x6e,
	0x75, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x6e, 0x75, 0x6d, 0x22, 0x63, 0x0a,
	0x08, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x73, 0x67, 0x73, 0x12, 0x29, 0x0a, 0x04, 0x4d, 0x73, 0x67,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x4d, 0x73, 0x67, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04,
	0x4d, 0x73, 0x67, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x73, 0x45, 0x6e, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x05, 0x69, 0x73, 0x45, 0x6e, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e,
	0x64, 0x53, 0x65, 0x71, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x65, 0x6e, 0x64, 0x53,
	0x65, 0x71, 0x22, 0xef, 0x02, 0x0a, 0x15, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x42, 0x79, 0x53, 0x65, 0x71, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x41, 0x0a, 0x04,
	0x6d, 0x73, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x79, 0x53, 0x65, 0x71, 0x73, 0x52, 0x65, 0x73, 0x70, 0x2e,
	0x4d, 0x73, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6d, 0x73, 0x67, 0x73, 0x12,
	0x65, 0x0a, 0x10, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x73, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x79, 0x53, 0x65, 0x71, 0x73, 0x52, 0x65, 0x73, 0x70, 0x2e, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x67, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x73, 0x67, 0x73, 0x1a, 0x4f, 0x0a, 0x09, 0x4d, 0x73, 0x67, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64,
	0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x73, 0x67, 0x73, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x5b, 0x0a, 0x15, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73,
	0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x73, 0x67, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x26, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x78, 0x53, 0x65,
	0x71, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x8f, 0x02, 0x0a,
	0x0d, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x52, 0x65, 0x73, 0x70, 0x12, 0x42,
	0x0a, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47,
	0x65, 0x74, 0x4d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x52, 0x65, 0x73, 0x70, 0x2e, 0x4d, 0x61, 0x78,
	0x53, 0x65, 0x71, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x65,
	0x71, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x77, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x78, 0x53, 0x65, 0x71, 0x52, 0x65, 0x73, 0x70,
	0x2e, 0x4d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x6d,
	0x69, 0x6e, 0x53, 0x65, 0x71, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x4d, 0x61, 0x78, 0x53, 0x65, 0x71,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3a, 0x0a, 0x0c, 0x4d, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x71,
	0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x6e, 0x64, 0x4d, 0x73, 0x67, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4d, 0x73, 0x67, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4d, 0x73,
	0x67, 0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x73, 0x67,
	0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x4d, 0x73, 0x67, 0x49, 0x44, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x22, 0xa2, 0x06, 0x0a, 0x07, 0x4d, 0x73, 0x67, 0x44, 0x61, 0x74, 0x61, 0x12, 0x16, 0x0a,
	0x06, 0x73, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73,
	0x65, 0x6e, 0x64, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x63, 0x76, 0x49, 0x44, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x63, 0x76, 0x49, 0x44, 0x12, 0x18, 0x0a,
	0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x4d, 0x73, 0x67, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x4d, 0x73, 0x67, 0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x4d, 0x73, 0x67, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4d, 0x73, 0x67, 0x49, 0x44, 0x12, 0x2a, 0x0a, 0x10, 0x73,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x44, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x44, 0x12, 0x26, 0x0a, 0x0e, 0x73, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x4e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x4e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x24, 0x0a, 0x0d, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x46, 0x61, 0x63, 0x65, 0x55, 0x52, 0x4c,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x46, 0x61,
	0x63, 0x65, 0x55, 0x52, 0x4c, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x73, 0x67, 0x46, 0x72,
	0x6f, 0x6d, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x6d, 0x73, 0x67, 0x46, 0x72, 0x6f,
	0x6d, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x73, 0x65, 0x71, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x73, 0x65, 0x71, 0x12,
	0x1a, 0x0a, 0x08, 0x73, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x73, 0x52, 0x65, 0x61, 0x64, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x69, 0x73, 0x52, 0x65, 0x61, 0x64, 0x12, 0x3c, 0x0a, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x4d, 0x73, 0x67, 0x44,
	0x61, 0x74, 0x61, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a, 0x0f, 0x6f, 0x66, 0x66,
	0x6c, 0x69, 0x6e, 0x65, 0x50, 0x75, 0x73, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77,
	0x73, 0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x75, 0x73, 0x68, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0f, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x75, 0x73, 0x68, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x4c, 0x69,
	0x73, 0x74, 0x18, 0x15, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x74, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x65, 0x78,
	0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x1a, 0x3a, 0x0a, 0x0c, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd4, 0x02, 0x0a, 0x0c, 0x50, 0x75, 0x73, 0x68, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x04, 0x6d, 0x73, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73,
	0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x73, 0x2e, 0x4d, 0x73, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6d, 0x73, 0x67,
	0x73, 0x12, 0x5c, 0x0a, 0x10, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x73, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x67, 0x73, 0x1a,
	0x4f, 0x0a, 0x09, 0x4d, 0x73, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x6c,
	0x6c, 0x4d, 0x73, 0x67, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x5b, 0x0a, 0x15, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x73, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x73,
	0x67, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xb5, 0x01,
	0x0a, 0x0f, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x75, 0x73, 0x68, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x65, 0x73, 0x63, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x65, 0x73, 0x63, 0x12, 0x0e, 0x0a, 0x02, 0x65,
	0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x12, 0x22, 0x0a, 0x0c, 0x69,
	0x4f, 0x53, 0x50, 0x75, 0x73, 0x68, 0x53, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x69, 0x4f, 0x53, 0x50, 0x75, 0x73, 0x68, 0x53, 0x6f, 0x75, 0x6e, 0x64, 0x12,
	0x24, 0x0a, 0x0d, 0x69, 0x4f, 0x53, 0x42, 0x61, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x4f, 0x53, 0x42, 0x61, 0x64, 0x67, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x49,
	0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x64, 0x0a, 0x08, 0x54, 0x69, 0x70, 0x73, 0x43, 0x6f, 0x6d,
	0x6d, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x54, 0x69, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x54, 0x69, 0x70, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x6a,
	0x73, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x6a, 0x73, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x94, 0x03, 0x0a, 0x10,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73,
	0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x0a, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x24, 0x0a,
	0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x0e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77, 0x6e, 0x65,
	0x72, 0x55, 0x73, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x12, 0x2e,
	0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32,
	0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x22, 0xfc, 0x01, 0x0a, 0x10, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f,
	0x53, 0x65, 0x74, 0x54, 0x69, 0x70, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73,
	0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x75, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x6d, 0x75, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d,
	0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2e, 0x0a,
	0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a,
	0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x22, 0xe4, 0x01, 0x0a, 0x14, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x53,
	0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x54, 0x69, 0x70, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70,
	0x55, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f,
	0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64,
	0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0xec, 0x01, 0x0a, 0x1c, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x53, 0x65, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x75, 0x6e, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x70, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55,
	0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70,
	0x55, 0x73, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0x9d, 0x01, 0x0a, 0x18, 0x4a, 0x6f, 0x69, 0x6e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x3a, 0x0a, 0x09, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x6e, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x72, 0x65, 0x71, 0x4d, 0x73, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x72, 0x65, 0x71, 0x4d, 0x73, 0x67, 0x22, 0x88, 0x02, 0x0a, 0x0e, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x51, 0x75, 0x69, 0x74, 0x54, 0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3d, 0x0a, 0x08, 0x71, 0x75, 0x69,
	0x74, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08,
	0x71, 0x75, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e,
	0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32,
	0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x22, 0xc6, 0x01, 0x0a, 0x1c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x54,
	0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77,
	0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77,
	0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x1c, 0x0a,
	0x09, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x4d, 0x73, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x4d, 0x73, 0x67, 0x12, 0x1e, 0x0a, 0x0a, 0x72,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x41, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x41, 0x73, 0x22, 0xc6, 0x01, 0x0a, 0x1c,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x39, 0x0a, 0x06, 0x6f,
	0x70, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06,
	0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x4d, 0x73, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x4d, 0x73, 0x67, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72,
	0x41, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x72, 0x41, 0x73, 0x22, 0xcf, 0x03, 0x0a, 0x19, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77,
	0x6e, 0x65, 0x72, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x54, 0x69,
	0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73,
	0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73,
	0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x0d,
	0x6e, 0x65, 0x77, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75,
	0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x6e, 0x65, 0x77, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x6c, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6f, 0x6c,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4f, 0x0a, 0x11, 0x6f, 0x6c, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77, 0x6e,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x11, 0x6f, 0x6c, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0xd1, 0x02, 0x0a, 0x10, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x4b, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70,
	0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f,
	0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x0e, 0x6b, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x0e, 0x6b, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0x99, 0x03, 0x0a, 0x11, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73,
	0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x0f, 0x69, 0x6e,
	0x76, 0x69, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75,
	0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x64, 0x55,
	0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a,
	0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a,
	0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x12, 0x43, 0x0a, 0x0b, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x69, 0x6e, 0x76, 0x69, 0x74,
	0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x22, 0x8f, 0x02, 0x0a, 0x0f, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x54, 0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x43, 0x0a, 0x0b, 0x65, 0x6e, 0x74,
	0x72, 0x61, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x12, 0x24,
	0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0xa4, 0x01, 0x0a, 0x12, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12,
	0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x39,
	0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0xef, 0x02, 0x0a, 0x14, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x4d,
	0x75, 0x74, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73,
	0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x09, 0x6d, 0x75, 0x74, 0x65,
	0x64, 0x55, 0x73, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09,
	0x6d, 0x75, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0c, 0x6d, 0x75, 0x74,
	0x65, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0c, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x2e, 0x0a,
	0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a,
	0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x22, 0xd1, 0x02, 0x0a, 0x1a, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73,
	0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3f, 0x0a, 0x09, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75,
	0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65,
	0x72, 0x12, 0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0x84, 0x02, 0x0a, 0x0e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x75, 0x74, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73,
	0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0x8a, 0x02, 0x0a,
	0x14, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x75, 0x74, 0x65,
	0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64,
	0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64,
	0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46,
	0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12,
	0x24, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0xfd, 0x02, 0x0a, 0x16, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x53, 0x65, 0x74,
	0x54, 0x69, 0x70, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x39, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x46, 0x75,
	0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x24,
	0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x55,
	0x73, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x12, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x2a, 0x0a,
	0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x6f, 0x72, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x6f,
	0x72, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x0a, 0x11, 0x46, 0x72, 0x69,
	0x65, 0x6e, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x61, 0x64, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x07, 0x61, 0x64, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x64, 0x64,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x64, 0x64, 0x57, 0x6f, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x64, 0x64, 0x57,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x4a, 0x0a, 0x0c, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x6f,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x72, 0x6f, 0x6d,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x6f, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x6f, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x22, 0x57, 0x0a, 0x15, 0x46, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x70, 0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x66,
	0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73,
	0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x52, 0x0c, 0x66,
	0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0xcd, 0x01, 0x0a, 0x1d,
	0x46, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x3e, 0x0a,
	0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x77, 0x73, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x52,
	0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1c, 0x0a,
	0x09, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x4d, 0x73, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x4d, 0x73, 0x67, 0x12, 0x24, 0x0a, 0x0d, 0x66,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x28, 0x0a, 0x0f, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x72, 0x69, 0x65,
	0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0x7d, 0x0a, 0x1d, 0x46,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x3e, 0x0a, 0x0c,
	0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77,
	0x73, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x52, 0x0c,
	0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x4d, 0x73, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x4d, 0x73, 0x67, 0x22, 0xef, 0x01, 0x0a, 0x0f, 0x46,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x30,
	0x0a, 0x06, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x46, 0x72,
	0x69, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64,
	0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e,
	0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d,
	0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0f, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x72, 0x69,
	0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0xa3, 0x01, 0x0a,
	0x11, 0x46, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x54, 0x69,
	0x70, 0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x52, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e,
	0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0f, 0x66, 0x72, 0x69, 0x65,
	0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x22, 0x50, 0x0a, 0x0e, 0x42, 0x6c, 0x61, 0x63, 0x6b, 0x41, 0x64, 0x64, 0x65, 0x64,
	0x54, 0x69, 0x70, 0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x6f,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x52, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x22, 0x52, 0x0a, 0x10, 0x42, 0x6c, 0x61, 0x63, 0x6b, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x66, 0x72, 0x6f, 0x6d,
	0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x46, 0x72,
	0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x52, 0x0c, 0x66, 0x72, 0x6f, 0x6d,
	0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0xd5, 0x01, 0x0a, 0x15, 0x46, 0x72, 0x69,
	0x65, 0x6e, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x54, 0x69,
	0x70, 0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69,
	0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x52, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e,
	0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0f, 0x66, 0x72, 0x69, 0x65,
	0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x12, 0x2c, 0x0a, 0x11, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x53, 0x6f, 0x72, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11, 0x66,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x53, 0x6f, 0x72, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x2d, 0x0a, 0x13, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22,
	0x8a, 0x01, 0x0a, 0x14, 0x55, 0x73, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x54, 0x69, 0x70, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x72,
	0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x6f, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x6f, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1e, 0x0a, 0x0a,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0a, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x44, 0x22, 0x50, 0x0a, 0x12,
	0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x54, 0x69,
	0x70, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x53,
	0x0a, 0x15, 0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x70, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x72, 0x6f,
	0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x6f, 0x55, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x6f, 0x55, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x22, 0x53, 0x0a, 0x15, 0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x70, 0x73, 0x12, 0x1e, 0x0a, 0x0a,
	0x66, 0x72, 0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1a, 0x0a, 0x08,
	0x74, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x74, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x60, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x70, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x2e, 0x0a, 0x12, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x4c, 0x69, 0x73, 0x74,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x4c, 0x69, 0x73, 0x74, 0x22, 0x92, 0x01, 0x0a, 0x1a, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x54, 0x69, 0x70, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x63,
	0x76, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x63, 0x76, 0x49,
	0x44, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x73, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x73, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22,
	0xa3, 0x01, 0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x61, 0x73, 0x52, 0x65, 0x61, 0x64, 0x54, 0x69, 0x70, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x75,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x68,
	0x61, 0x73, 0x52, 0x65, 0x61, 0x64, 0x53, 0x65, 0x71, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x68, 0x61, 0x73, 0x52, 0x65, 0x61, 0x64, 0x53, 0x65, 0x71, 0x12, 0x28, 0x0a, 0x0f, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x64, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x2a, 0x0a, 0x10, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65, 0x6d, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x22, 0x1a, 0x0a, 0x04, 0x73, 0x65, 0x71, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x65, 0x71,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x04, 0x73, 0x65, 0x71, 0x73, 0x22, 0x5b, 0x0a,
	0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x69,
	0x70, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6f, 0x70, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x16,
	0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x65, 0x71, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x03, 0x52, 0x04, 0x73, 0x65, 0x71, 0x73, 0x22, 0xfb, 0x01, 0x0a, 0x0d, 0x52,
	0x65, 0x76, 0x6f, 0x6b, 0x65, 0x4d, 0x73, 0x67, 0x54, 0x69, 0x70, 0x73, 0x12, 0x24, 0x0a, 0x0d,
	0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x73, 0x67, 0x49,
	0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d,
	0x73, 0x67, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x65, 0x71, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x73, 0x65, 0x71, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x69, 0x73, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x52, 0x65, 0x76,
	0x6f, 0x6b, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x73, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x22, 0xb1, 0x03, 0x0a, 0x15, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x44, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x49, 0x44,
	0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x52, 0x6f,
	0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x73, 0x67, 0x49,
	0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d,
	0x73, 0x67, 0x49, 0x44, 0x12, 0x28, 0x0a, 0x0f, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x4e,
	0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72,
	0x65, 0x76, 0x6f, 0x6b, 0x65, 0x72, 0x4e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x34,
	0x0a, 0x15, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x53, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x12, 0x40, 0x0a, 0x1b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x4e, 0x69, 0x63,
	0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x4e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x65,
	0x71, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x73, 0x65, 0x71, 0x12, 0x0e, 0x0a, 0x02,
	0x65, 0x78, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x65, 0x78, 0x22, 0x59, 0x0a, 0x15,
	0x43, 0x6c, 0x65, 0x61, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x69, 0x70, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x28, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x73, 0x22, 0x64, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4d, 0x73, 0x67, 0x73, 0x54, 0x69, 0x70, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x65, 0x71,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x04, 0x73, 0x65, 0x71, 0x73, 0x22, 0x98, 0x01,
	0x0a, 0x0e, 0x4d, 0x61, 0x72, 0x6b, 0x41, 0x73, 0x52, 0x65, 0x61, 0x64, 0x54, 0x69, 0x70, 0x73,
	0x12, 0x2a, 0x0a, 0x10, 0x6d, 0x61, 0x72, 0x6b, 0x41, 0x73, 0x52, 0x65, 0x61, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6d, 0x61, 0x72, 0x6b,
	0x41, 0x73, 0x52, 0x65, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x26, 0x0a, 0x0e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x44, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x65, 0x71, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x03, 0x52, 0x04, 0x73, 0x65, 0x71, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x68, 0x61, 0x73, 0x52,
	0x65, 0x61, 0x64, 0x53, 0x65, 0x71, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x68, 0x61,
	0x73, 0x52, 0x65, 0x61, 0x64, 0x53, 0x65, 0x71, 0x22, 0x57, 0x0a, 0x19, 0x53, 0x65, 0x74, 0x41,
	0x70, 0x70, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x22, 0x0a,
	0x0c, 0x69, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x22, 0x1c, 0x0a, 0x1a, 0x53, 0x65, 0x74, 0x41, 0x70, 0x70, 0x42, 0x61, 0x63, 0x6b, 0x67,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x22,
	0x8a, 0x01, 0x0a, 0x12, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x53, 0x0a, 0x11,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x68, 0x6f, 0x77, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x73, 0x68, 0x6f, 0x77, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x22, 0xc5, 0x01, 0x0a, 0x15, 0x46, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x73, 0x49, 0x6e, 0x66,
	0x6f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x70, 0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x66,
	0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73,
	0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x52, 0x0c, 0x66,
	0x72, 0x6f, 0x6d, 0x54, 0x6f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09, 0x66,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09,
	0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x49, 0x44, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x66, 0x72, 0x69,
	0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x28, 0x0a, 0x0f, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x22, 0x5f, 0x0a, 0x17, 0x53, 0x75, 0x62,
	0x55, 0x73, 0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x45, 0x6c, 0x65, 0x6d, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x2c, 0x0a, 0x11,
	0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x44,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x11, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x44, 0x73, 0x22, 0x62, 0x0a, 0x17, 0x53, 0x75,
	0x62, 0x55, 0x73, 0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x54, 0x69, 0x70, 0x73, 0x12, 0x47, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x2e, 0x53, 0x75, 0x62, 0x55, 0x73, 0x65,
	0x72, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6c, 0x65,
	0x6d, 0x52, 0x0b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x73, 0x22, 0x6d,
	0x0a, 0x13, 0x53, 0x75, 0x62, 0x55, 0x73, 0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x28, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x62, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f,
	0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12,
	0x2c, 0x0a, 0x11, 0x75, 0x6e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x75, 0x6e, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0xa5, 0x01,
	0x0a, 0x0d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4d, 0x73, 0x67, 0x54, 0x69, 0x70, 0x73, 0x12,
	0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x4d, 0x73, 0x67, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x4d, 0x73, 0x67, 0x49, 0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x03, 0x65, 0x6e, 0x64, 0x2a, 0x30, 0x0a, 0x09, 0x50, 0x75, 0x6c, 0x6c, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x75, 0x6c, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x41,
	0x73, 0x63, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x75, 0x6c, 0x6c, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x44, 0x65, 0x73, 0x63, 0x10, 0x01, 0x42, 0x25, 0x5a, 0x23, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6d, 0x73, 0x64, 0x6b, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x73, 0x64, 0x6b, 0x77, 0x73, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_sdkws_sdkws_proto_rawDescOnce sync.Once
	file_sdkws_sdkws_proto_rawDescData = file_sdkws_sdkws_proto_rawDesc
)

func file_sdkws_sdkws_proto_rawDescGZIP() []byte {
	file_sdkws_sdkws_proto_rawDescOnce.Do(func() {
		file_sdkws_sdkws_proto_rawDescData = protoimpl.X.CompressGZIP(file_sdkws_sdkws_proto_rawDescData)
	})
	return file_sdkws_sdkws_proto_rawDescData
}

var file_sdkws_sdkws_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_sdkws_sdkws_proto_msgTypes = make([]protoimpl.MessageInfo, 81)
var file_sdkws_sdkws_proto_goTypes = []any{
	(PullOrder)(0),                        // 0: openim.sdkws.PullOrder
	(*GroupInfo)(nil),                     // 1: openim.sdkws.GroupInfo
	(*GroupInfoForSet)(nil),               // 2: openim.sdkws.GroupInfoForSet
	(*GroupMemberFullInfo)(nil),           // 3: openim.sdkws.GroupMemberFullInfo
	(*PublicUserInfo)(nil),                // 4: openim.sdkws.PublicUserInfo
	(*UserInfo)(nil),                      // 5: openim.sdkws.UserInfo
	(*UserInfoWithEx)(nil),                // 6: openim.sdkws.UserInfoWithEx
	(*FriendInfo)(nil),                    // 7: openim.sdkws.FriendInfo
	(*BlackInfo)(nil),                     // 8: openim.sdkws.BlackInfo
	(*GroupRequest)(nil),                  // 9: openim.sdkws.GroupRequest
	(*FriendRequest)(nil),                 // 10: openim.sdkws.FriendRequest
	(*PullMessageBySeqsReq)(nil),          // 11: openim.sdkws.PullMessageBySeqsReq
	(*SeqRange)(nil),                      // 12: openim.sdkws.SeqRange
	(*PullMsgs)(nil),                      // 13: openim.sdkws.PullMsgs
	(*PullMessageBySeqsResp)(nil),         // 14: openim.sdkws.PullMessageBySeqsResp
	(*GetMaxSeqReq)(nil),                  // 15: openim.sdkws.GetMaxSeqReq
	(*GetMaxSeqResp)(nil),                 // 16: openim.sdkws.GetMaxSeqResp
	(*UserSendMsgResp)(nil),               // 17: openim.sdkws.UserSendMsgResp
	(*MsgData)(nil),                       // 18: openim.sdkws.MsgData
	(*PushMessages)(nil),                  // 19: openim.sdkws.PushMessages
	(*OfflinePushInfo)(nil),               // 20: openim.sdkws.OfflinePushInfo
	(*TipsComm)(nil),                      // 21: openim.sdkws.TipsComm
	(*GroupCreatedTips)(nil),              // 22: openim.sdkws.GroupCreatedTips
	(*GroupInfoSetTips)(nil),              // 23: openim.sdkws.GroupInfoSetTips
	(*GroupInfoSetNameTips)(nil),          // 24: openim.sdkws.GroupInfoSetNameTips
	(*GroupInfoSetAnnouncementTips)(nil),  // 25: openim.sdkws.GroupInfoSetAnnouncementTips
	(*JoinGroupApplicationTips)(nil),      // 26: openim.sdkws.JoinGroupApplicationTips
	(*MemberQuitTips)(nil),                // 27: openim.sdkws.MemberQuitTips
	(*GroupApplicationAcceptedTips)(nil),  // 28: openim.sdkws.GroupApplicationAcceptedTips
	(*GroupApplicationRejectedTips)(nil),  // 29: openim.sdkws.GroupApplicationRejectedTips
	(*GroupOwnerTransferredTips)(nil),     // 30: openim.sdkws.GroupOwnerTransferredTips
	(*MemberKickedTips)(nil),              // 31: openim.sdkws.MemberKickedTips
	(*MemberInvitedTips)(nil),             // 32: openim.sdkws.MemberInvitedTips
	(*MemberEnterTips)(nil),               // 33: openim.sdkws.MemberEnterTips
	(*GroupDismissedTips)(nil),            // 34: openim.sdkws.GroupDismissedTips
	(*GroupMemberMutedTips)(nil),          // 35: openim.sdkws.GroupMemberMutedTips
	(*GroupMemberCancelMutedTips)(nil),    // 36: openim.sdkws.GroupMemberCancelMutedTips
	(*GroupMutedTips)(nil),                // 37: openim.sdkws.GroupMutedTips
	(*GroupCancelMutedTips)(nil),          // 38: openim.sdkws.GroupCancelMutedTips
	(*GroupMemberInfoSetTips)(nil),        // 39: openim.sdkws.GroupMemberInfoSetTips
	(*FriendApplication)(nil),             // 40: openim.sdkws.FriendApplication
	(*FromToUserID)(nil),                  // 41: openim.sdkws.FromToUserID
	(*FriendApplicationTips)(nil),         // 42: openim.sdkws.FriendApplicationTips
	(*FriendApplicationApprovedTips)(nil), // 43: openim.sdkws.FriendApplicationApprovedTips
	(*FriendApplicationRejectedTips)(nil), // 44: openim.sdkws.FriendApplicationRejectedTips
	(*FriendAddedTips)(nil),               // 45: openim.sdkws.FriendAddedTips
	(*FriendDeletedTips)(nil),             // 46: openim.sdkws.FriendDeletedTips
	(*BlackAddedTips)(nil),                // 47: openim.sdkws.BlackAddedTips
	(*BlackDeletedTips)(nil),              // 48: openim.sdkws.BlackDeletedTips
	(*FriendInfoChangedTips)(nil),         // 49: openim.sdkws.FriendInfoChangedTips
	(*UserInfoUpdatedTips)(nil),           // 50: openim.sdkws.UserInfoUpdatedTips
	(*UserStatusChangeTips)(nil),          // 51: openim.sdkws.UserStatusChangeTips
	(*UserCommandAddTips)(nil),            // 52: openim.sdkws.UserCommandAddTips
	(*UserCommandUpdateTips)(nil),         // 53: openim.sdkws.UserCommandUpdateTips
	(*UserCommandDeleteTips)(nil),         // 54: openim.sdkws.UserCommandDeleteTips
	(*ConversationUpdateTips)(nil),        // 55: openim.sdkws.ConversationUpdateTips
	(*ConversationSetPrivateTips)(nil),    // 56: openim.sdkws.ConversationSetPrivateTips
	(*ConversationHasReadTips)(nil),       // 57: openim.sdkws.ConversationHasReadTips
	(*NotificationElem)(nil),              // 58: openim.sdkws.NotificationElem
	(*Seqs)(nil),                          // 59: openim.sdkws.seqs
	(*DeleteMessageTips)(nil),             // 60: openim.sdkws.DeleteMessageTips
	(*RevokeMsgTips)(nil),                 // 61: openim.sdkws.RevokeMsgTips
	(*MessageRevokedContent)(nil),         // 62: openim.sdkws.MessageRevokedContent
	(*ClearConversationTips)(nil),         // 63: openim.sdkws.ClearConversationTips
	(*DeleteMsgsTips)(nil),                // 64: openim.sdkws.DeleteMsgsTips
	(*MarkAsReadTips)(nil),                // 65: openim.sdkws.MarkAsReadTips
	(*SetAppBackgroundStatusReq)(nil),     // 66: openim.sdkws.SetAppBackgroundStatusReq
	(*SetAppBackgroundStatusResp)(nil),    // 67: openim.sdkws.SetAppBackgroundStatusResp
	(*ProcessUserCommand)(nil),            // 68: openim.sdkws.ProcessUserCommand
	(*RequestPagination)(nil),             // 69: openim.sdkws.RequestPagination
	(*FriendsInfoUpdateTips)(nil),         // 70: openim.sdkws.FriendsInfoUpdateTips
	(*SubUserOnlineStatusElem)(nil),       // 71: openim.sdkws.SubUserOnlineStatusElem
	(*SubUserOnlineStatusTips)(nil),       // 72: openim.sdkws.SubUserOnlineStatusTips
	(*SubUserOnlineStatus)(nil),           // 73: openim.sdkws.SubUserOnlineStatus
	(*StreamMsgTips)(nil),                 // 74: openim.sdkws.StreamMsgTips
	nil,                                   // 75: openim.sdkws.PullMessageBySeqsResp.MsgsEntry
	nil,                                   // 76: openim.sdkws.PullMessageBySeqsResp.NotificationMsgsEntry
	nil,                                   // 77: openim.sdkws.GetMaxSeqResp.MaxSeqsEntry
	nil,                                   // 78: openim.sdkws.GetMaxSeqResp.MinSeqsEntry
	nil,                                   // 79: openim.sdkws.MsgData.OptionsEntry
	nil,                                   // 80: openim.sdkws.PushMessages.MsgsEntry
	nil,                                   // 81: openim.sdkws.PushMessages.NotificationMsgsEntry
	(*wrapperspb.StringValue)(nil),        // 82: openim.protobuf.StringValue
	(*wrapperspb.Int32Value)(nil),         // 83: openim.protobuf.Int32Value
}
var file_sdkws_sdkws_proto_depIdxs = []int32{
	82, // 0: openim.sdkws.GroupInfoForSet.ex:type_name -> openim.protobuf.StringValue
	83, // 1: openim.sdkws.GroupInfoForSet.needVerification:type_name -> openim.protobuf.Int32Value
	83, // 2: openim.sdkws.GroupInfoForSet.lookMemberInfo:type_name -> openim.protobuf.Int32Value
	83, // 3: openim.sdkws.GroupInfoForSet.applyMemberFriend:type_name -> openim.protobuf.Int32Value
	82, // 4: openim.sdkws.UserInfoWithEx.nickname:type_name -> openim.protobuf.StringValue
	82, // 5: openim.sdkws.UserInfoWithEx.faceURL:type_name -> openim.protobuf.StringValue
	82, // 6: openim.sdkws.UserInfoWithEx.ex:type_name -> openim.protobuf.StringValue
	83, // 7: openim.sdkws.UserInfoWithEx.globalRecvMsgOpt:type_name -> openim.protobuf.Int32Value
	5,  // 8: openim.sdkws.FriendInfo.friendUser:type_name -> openim.sdkws.UserInfo
	4,  // 9: openim.sdkws.BlackInfo.blackUserInfo:type_name -> openim.sdkws.PublicUserInfo
	4,  // 10: openim.sdkws.GroupRequest.userInfo:type_name -> openim.sdkws.PublicUserInfo
	1,  // 11: openim.sdkws.GroupRequest.groupInfo:type_name -> openim.sdkws.GroupInfo
	12, // 12: openim.sdkws.PullMessageBySeqsReq.seqRanges:type_name -> openim.sdkws.SeqRange
	0,  // 13: openim.sdkws.PullMessageBySeqsReq.order:type_name -> openim.sdkws.PullOrder
	18, // 14: openim.sdkws.PullMsgs.Msgs:type_name -> openim.sdkws.MsgData
	75, // 15: openim.sdkws.PullMessageBySeqsResp.msgs:type_name -> openim.sdkws.PullMessageBySeqsResp.MsgsEntry
	76, // 16: openim.sdkws.PullMessageBySeqsResp.notificationMsgs:type_name -> openim.sdkws.PullMessageBySeqsResp.NotificationMsgsEntry
	77, // 17: openim.sdkws.GetMaxSeqResp.maxSeqs:type_name -> openim.sdkws.GetMaxSeqResp.MaxSeqsEntry
	78, // 18: openim.sdkws.GetMaxSeqResp.minSeqs:type_name -> openim.sdkws.GetMaxSeqResp.MinSeqsEntry
	79, // 19: openim.sdkws.MsgData.options:type_name -> openim.sdkws.MsgData.OptionsEntry
	20, // 20: openim.sdkws.MsgData.offlinePushInfo:type_name -> openim.sdkws.OfflinePushInfo
	80, // 21: openim.sdkws.PushMessages.msgs:type_name -> openim.sdkws.PushMessages.MsgsEntry
	81, // 22: openim.sdkws.PushMessages.notificationMsgs:type_name -> openim.sdkws.PushMessages.NotificationMsgsEntry
	1,  // 23: openim.sdkws.GroupCreatedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 24: openim.sdkws.GroupCreatedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 25: openim.sdkws.GroupCreatedTips.memberList:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 26: openim.sdkws.GroupCreatedTips.groupOwnerUser:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 27: openim.sdkws.GroupInfoSetTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 28: openim.sdkws.GroupInfoSetTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 29: openim.sdkws.GroupInfoSetNameTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 30: openim.sdkws.GroupInfoSetNameTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 31: openim.sdkws.GroupInfoSetAnnouncementTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 32: openim.sdkws.GroupInfoSetAnnouncementTips.group:type_name -> openim.sdkws.GroupInfo
	1,  // 33: openim.sdkws.JoinGroupApplicationTips.group:type_name -> openim.sdkws.GroupInfo
	4,  // 34: openim.sdkws.JoinGroupApplicationTips.applicant:type_name -> openim.sdkws.PublicUserInfo
	1,  // 35: openim.sdkws.MemberQuitTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 36: openim.sdkws.MemberQuitTips.quitUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 37: openim.sdkws.GroupApplicationAcceptedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 38: openim.sdkws.GroupApplicationAcceptedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 39: openim.sdkws.GroupApplicationRejectedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 40: openim.sdkws.GroupApplicationRejectedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 41: openim.sdkws.GroupOwnerTransferredTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 42: openim.sdkws.GroupOwnerTransferredTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 43: openim.sdkws.GroupOwnerTransferredTips.newGroupOwner:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 44: openim.sdkws.GroupOwnerTransferredTips.oldGroupOwnerInfo:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 45: openim.sdkws.MemberKickedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 46: openim.sdkws.MemberKickedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 47: openim.sdkws.MemberKickedTips.kickedUserList:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 48: openim.sdkws.MemberInvitedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 49: openim.sdkws.MemberInvitedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 50: openim.sdkws.MemberInvitedTips.invitedUserList:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 51: openim.sdkws.MemberInvitedTips.inviterUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 52: openim.sdkws.MemberEnterTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 53: openim.sdkws.MemberEnterTips.entrantUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 54: openim.sdkws.GroupDismissedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 55: openim.sdkws.GroupDismissedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 56: openim.sdkws.GroupMemberMutedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 57: openim.sdkws.GroupMemberMutedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 58: openim.sdkws.GroupMemberMutedTips.mutedUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 59: openim.sdkws.GroupMemberCancelMutedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 60: openim.sdkws.GroupMemberCancelMutedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 61: openim.sdkws.GroupMemberCancelMutedTips.mutedUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 62: openim.sdkws.GroupMutedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 63: openim.sdkws.GroupMutedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 64: openim.sdkws.GroupCancelMutedTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 65: openim.sdkws.GroupCancelMutedTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	1,  // 66: openim.sdkws.GroupMemberInfoSetTips.group:type_name -> openim.sdkws.GroupInfo
	3,  // 67: openim.sdkws.GroupMemberInfoSetTips.opUser:type_name -> openim.sdkws.GroupMemberFullInfo
	3,  // 68: openim.sdkws.GroupMemberInfoSetTips.changedUser:type_name -> openim.sdkws.GroupMemberFullInfo
	41, // 69: openim.sdkws.FriendApplicationTips.fromToUserID:type_name -> openim.sdkws.FromToUserID
	41, // 70: openim.sdkws.FriendApplicationApprovedTips.fromToUserID:type_name -> openim.sdkws.FromToUserID
	41, // 71: openim.sdkws.FriendApplicationRejectedTips.fromToUserID:type_name -> openim.sdkws.FromToUserID
	7,  // 72: openim.sdkws.FriendAddedTips.friend:type_name -> openim.sdkws.FriendInfo
	4,  // 73: openim.sdkws.FriendAddedTips.opUser:type_name -> openim.sdkws.PublicUserInfo
	41, // 74: openim.sdkws.FriendDeletedTips.fromToUserID:type_name -> openim.sdkws.FromToUserID
	41, // 75: openim.sdkws.BlackAddedTips.fromToUserID:type_name -> openim.sdkws.FromToUserID
	41, // 76: openim.sdkws.BlackDeletedTips.fromToUserID:type_name -> openim.sdkws.FromToUserID
	41, // 77: openim.sdkws.FriendInfoChangedTips.fromToUserID:type_name -> openim.sdkws.FromToUserID
	41, // 78: openim.sdkws.FriendsInfoUpdateTips.fromToUserID:type_name -> openim.sdkws.FromToUserID
	71, // 79: openim.sdkws.SubUserOnlineStatusTips.subscribers:type_name -> openim.sdkws.SubUserOnlineStatusElem
	13, // 80: openim.sdkws.PullMessageBySeqsResp.MsgsEntry.value:type_name -> openim.sdkws.PullMsgs
	13, // 81: openim.sdkws.PullMessageBySeqsResp.NotificationMsgsEntry.value:type_name -> openim.sdkws.PullMsgs
	13, // 82: openim.sdkws.PushMessages.MsgsEntry.value:type_name -> openim.sdkws.PullMsgs
	13, // 83: openim.sdkws.PushMessages.NotificationMsgsEntry.value:type_name -> openim.sdkws.PullMsgs
	84, // [84:84] is the sub-list for method output_type
	84, // [84:84] is the sub-list for method input_type
	84, // [84:84] is the sub-list for extension type_name
	84, // [84:84] is the sub-list for extension extendee
	0,  // [0:84] is the sub-list for field type_name
}

func init() { file_sdkws_sdkws_proto_init() }
func file_sdkws_sdkws_proto_init() {
	if File_sdkws_sdkws_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sdkws_sdkws_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   81,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sdkws_sdkws_proto_goTypes,
		DependencyIndexes: file_sdkws_sdkws_proto_depIdxs,
		EnumInfos:         file_sdkws_sdkws_proto_enumTypes,
		MessageInfos:      file_sdkws_sdkws_proto_msgTypes,
	}.Build()
	File_sdkws_sdkws_proto = out.File
	file_sdkws_sdkws_proto_rawDesc = nil
	file_sdkws_sdkws_proto_goTypes = nil
	file_sdkws_sdkws_proto_depIdxs = nil
}
